/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_set_coordinate_system(), which defines a system
 * _ of real-number coordinates based on the default system of
 * _ integer pixel coordinates.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_set_coordinate_system_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad: the id of the device;
 * _ x_org: the value of the x origin in the default system;
 * _ y_org: the value of the y origin in the default system;
 * _ x_mul: the value of the x scale multiplier;
 * _ y_mul: the value of the y scale multiplier.
 */
void g2_set_coordinate_system_ctof__(int *id_ad,
				     float *x_org, float *y_org,
				     float *x_mul, float *y_mul)
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to acquire the first argument;
   * _ f_x_org, f_y_org: float variables to acquire the arguments;
   * _ d_x_org, d_y_org: double versions of the variables above;
   * _ f_x_mul, f_y_mul: float variables to acquire the arguments;
   * _ d_x_mul, d_y_mul: double versions of the variables above.
   */
  int    i_id_ad;
  float  f_x_org, f_y_org, f_x_mul, f_y_mul;
  double d_x_org, d_y_org, d_x_mul, d_y_mul;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  f_x_org = *x_org;
  f_y_org = *y_org;
  f_x_mul = *x_mul;
  f_y_mul = *y_mul;
  /*
   * Pass the float data to the double variables.
   */
  d_x_org = f_x_org;
  d_y_org = f_y_org;
  d_x_mul = f_x_mul;
  d_y_mul = f_y_mul;
  /*
   * Call the C function with the required arguments.
   */
  g2_set_coordinate_system(i_id_ad,
			   d_x_org, d_y_org,
			   d_x_mul, d_y_mul);
}
/*
 * Compatibility function for gfortran.
 */
void g2_set_coordinate_system_ctof_(int *id_ad,
				    float *x_org, float *y_org,
				    float *x_mul, float *y_mul)
{
  g2_set_coordinate_system_ctof__(id_ad,
				  x_org, y_org,
				  x_mul, y_mul);
}
