/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_set_QP(), which sets the "Quasi-Pixel" shape
 * _ and size to be used.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_set_qp_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad:   the id of the device;
 * _ qp_siz:  the size to be used for the "Quasi-Pixel";
 * _ iqp_shp: the index of the shape of the "Quasi-Pixel".
 */
void g2_set_qp_ctof__(int *id_ad,
		      float *qp_siz,
		      int *iqp_shp)
{
  /*
   * Local variables:
   * _ i_id_ad:   int variable to acquire the first argument;
   * _ f_qp_siz:  float variable to acquire the argument;
   * _ d_qp_siz:  double version of the variable above;
   * _ i_iqp_shp: int variable to acquire the argument.
   */
  int    i_id_ad, i_iqp_shp;
  float  f_qp_siz;
  double d_qp_siz;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad   = *id_ad;
  f_qp_siz  = *qp_siz;
  i_iqp_shp = *iqp_shp;
  /*
   * Pass the float datum to the double variable.
   */
  d_qp_siz = f_qp_siz;
  /*
   * Call the C function with the required arguments.
   */
  g2_set_QP(i_id_ad,
	    d_qp_siz,
	    i_iqp_shp);
}
/*
 * Compatibility function for gfortran.
 */
void g2_set_qp_ctof_(int *id_ad,
		     float *qp_siz,
		     int *iqp_shp)
{
  g2_set_qp_ctof__(id_ad,
		   qp_siz,
		   iqp_shp);
}
