*     JLdL 15Apr07.
*     
*     Copyright (C) 2007 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This program reads a sequence of numbers from stdin, then
*     _ calculates their product and writes it to stdout.
*     
      PROGRAM MULT
*     
*     Double precision everything.
      implicit double precision (a-h,o-z)
*     
*     The maximum number of numbers that this
*     _ program can deal with, plus one.
      parameter(nmax=10001)
*     
*     Storage for the numbers, in real form.
      dimension rnum(nmax)
*     
*     Read the numbers from stdin; this can be any combination
*     _ of rows and columns of integer or real numbers.
      read(*,*,iostat=ioerr) (rnum(inum),inum=1,nmax)
*     
*     There must have been an end-of-file read error.
      if (ioerr.ne.-1) then
*     
*     Write an error message and abort.
         if (ioerr.eq.0) then
            write(*,*) 'mult: ERROR: too many numbers'
         else
            write(*,*) 'mult: ERROR: input read error'
         end if
*     
         stop
*     
      end if
*     
*     Determine the number of numbers read in.
      nnum=inum-1
*     
*     Multiply all the numbers.
      prod=1.0d0
      do inum=1,nnum
         prod=prod*rnum(inum)
      end do
*     
*     If the number is an integer, write it out as such;
*     _ otherwise, write it out as a real number.
      nprd=int(prod)
      if (dble(nprd).eq.prod) then
         write(*,*) nprd
      else
         write(*,*) prod
      end if
*     
      END
