*     JLdL 11Nov07.
*     
*     Copyright (C) 2007 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This is the main plotting program, to be used for plotting
*     _ complex functions w(z) as two-dimensional vector fields
*     _ over the complex plane z; this program is to be started
*     _ and controlled by the Tcl/Tk front-end script called
*     _ complex-functions.tcl.
*     
      PROGRAM PLOT_FUNC
*     
*     Include a file with the relevant global data.
      include 'cb_gdata.for'
*     
*     Declare the g2 interface functions.
      include 'g2-ctof.for'
*     
*     Local variables:
*     _ xr_min_old: storage for the current value of xr_min;
*     _ xr_max_old: storage for the current value of xr_max;
*     _ yi_min_old: storage for the current value of yi_min;
*     _ yi_max_old: storage for the current value of yi_max;
*     _ ix_pos_old: storage for the current value of ix_pos;
*     _ iy_pos_old: storage for the current value of iy_pos;
*     _ iw_scl_old: storage for the current value of iw_scl.
*     
*     Wait to open the file 'complex-functions-params.tmp' for the
*     _ first time; this file is written by the front-end script.
      call wait_to_open
*     
*     Read and delete the file.
      call read_params
*     
*     Store the current values of the input variables which
*     _ determine the plotting-window size, its position,
*     _ and its internal coordinate system.
      xr_min_old = xr_min
      xr_max_old = xr_max
      yi_min_old = yi_min
      yi_max_old = yi_max
      ix_pos_old = ix_pos
      iy_pos_old = iy_pos
      iw_scl_old = iw_scl
*     
*     Uncomment this if necessary for debugging purposes.
*     call write_debug
*     
*     Calculate the values of a few local variables which
*     _ depend on the values read from the file.
      call calculate_params
*     
*     Create the virtual device.
      id_vd = g2_open_vd_ctof()
*     
*     Having read in the data, open the plotting window.
      call open_plotting_window
*     
*     Open a PS output file as well, which will hold a
*     _ copy of the current plotting window contents.
      call open_output_file
*     
*     Initialize the contents of the plotting window.
      call draw_plotting_window
*     
*     Enter an infinite plotting loop.
      do while ( .true. )
*     
*     Monitor meaningfull events.
         call monitor_events(ievent)
*     
*     If there was an event, then process it.
*     
*     Case of a File event.
         if (ievent .eq. 0) then
*     
*     Read and delete the file.
            call read_params
*     
*     Uncomment this if necessary for debugging purposes.
*     call write_debug
*     
*     Calculate the values of a few local variables which
*     _ depend on the values read from the file.
            call calculate_params
*     
*     Variables that need to be monitored in order to verify
*     _ whether we must change the plotting window:
*     _    xr_min, xr_max, yi_min, yi_max,
*     _    ix_pos, iy_pos and iw_scl.
            if ( (xr_min .ne. xr_min_old) .or.
     *           (xr_max .ne. xr_max_old) .or.
     *           (yi_min .ne. yi_min_old) .or.
     *           (yi_max .ne. yi_max_old) .or.
     *           (ix_pos .ne. ix_pos_old) .or.
     *           (iy_pos .ne. iy_pos_old) .or.
     *           (iw_scl .ne. iw_scl_old) ) then
*     
*     If some of the variables has changed, then refresh
*     _ the plotting window.
               call refresh_plotting_window
*     
*     Store the current values of the input variables which
*     _ determine the plotting-window size and position.
               ix_pos_old = ix_pos
               iy_pos_old = iy_pos
               iw_scl_old = iw_scl
               asp_rt_old = asp_rt
*     
            else
*     
*     Otherwise, simply clear the existing window.
               call g2_clear_ctof(id_vd)
*     
            end if
*     
*     The output file must be refreshed every time one changes
*     _ the graphics contents of the plotting window, otherwise
*     _ it will end up containing several pages, only the first
*     _ of which will be visible.
            call refresh_output_file
*     
*     Draw the contents of the new plotting window.
            call draw_plotting_window
*     
*     Case of a Button1 event.
         else if (ievent .eq. 1) then
*     
*     Choose the color scheme for the contents of this routine.
            call set_color_scheme(ics_norm)
*     
*     Get the value of the vector function at the
*     _ current position of the pointer.
            call vector_function
     *           (
     *           px_pos, py_pos,
     *           cx_val, cy_val,
     *           cv_mod,
     *           sz_flag
     *           )
*     
*     Plot the vector function.
            call draw_single_value
     *           (
     *           px_pos, py_pos,
     *           cx_val, cy_val,
     *           cv_mod,
     *           sz_flag
     *           )
*     
*     Flush the graphics buffers.
            call g2_flush_ctof(id_vd)
*     
*     Case of a [Shift]-Button1 or [Ctrl]-Button1 event.
         else if (
     *           (ievent .eq. 2) .or.
     *           (ievent .eq. 3)
     *           ) then
*     
*     Draw multiple values of the vector function,
*     _ while [Shift]-Bytton1 is pressed.
            call draw_many_values(ievent)
*     
*     Case of some Button2 events.
         else if (
     *           (ievent .eq. 21) .or.
     *           (ievent .eq. 22)
     *           ) then
*     
*     Draw an integration contour, while Button2 is pressed,
*     _ and calculate the integral over it.
            call draw_integration_contour
*     
*     Case of a certain Button2 event.
         else if (ievent .eq. 23) then
*     
*     Draw an integral curve starting at the current position
*     _ of the pointer and calculate the integral over it.
            call draw_integral_curve(ievent)
*     
*     Case of some Button3 events.
         else if (
     *           (ievent .eq. 41) .or.
     *           (ievent .eq. 42) .or.
     *           (ievent .eq. 43)
     *           ) then
*     
*     Draw an integral curve starting at the
*     _ current position of the pointer.
            call draw_integral_curve(ievent)
*     
*     Case of a certain Button3 event.
         else if (ievent .eq. 46) then
*     
*     Draw multiple integral curves, following the
*     _ position of the pointer.
            call draw_many_curves
*     
         end if
*     
      end do
*     
      END
