/*
 * JLdL 04Mar08.
 * This program reads a 2-byte (short) integer from the Linux
 * _ strong random number generator device /dev/urandom, and
 * _ writes it to stdout.
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
main()
{
  /*
   * A file descriptor.
   */
  int fdesc;
  /*
   * A file stream.
   */
  FILE *fstrm;
  /*
   * The size of the data to be read is "size" bites,
   * _ the number of objects to be read is "numb".
   */
  size_t size, numb;
  /*
   * A short integer.
   */
  unsigned int nint;
  /*
   * We want to read a single 2-byte integer.
   */
  size=2; numb=1;
  /*
   * Initialize the integer to zero.
   */
  nint=0;
  /*
   * Open the file and associate a file descriptor to it.
   * This is a system call (man 2).
   */
  fdesc=open("/dev/urandom",O_RDONLY);
  /*
   * Open a stream connected to the file descriptor.
   * This is a libc call (man 3).
   */
  fstrm=fdopen(fdesc,"r");
  /*
   * Read from the stream, in binary form, and put the
   * _ result in the location of the variable nint.
   * This is a libc call (man 3).
   */
  fread(&nint,size,numb,fstrm);
  /*
   * Close the stream.
   * This is a libc call (man 3).
   */
  fclose(fstrm);
  /*
   * Close the file descriptor.
   * This is a system call (man 2).
   */
  close(fdesc);
  /*
   * Write out the integer.
   */
  printf("%d\n",nint);
}
