/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_filled_ellipse(), which draws a filled ellipse
 * _ with given center and radii.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_filled_ellipse_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad: the id of the device;
 * _ x_pos: the x position of the center;
 * _ y_pos: the y position of the center;
 * _ x_rad: the x-radius of the ellipse;
 * _ y_rad: the y-radius of the ellipse.
 */
void g2_filled_ellipse_ctof__(int *id_ad,
			      float *x_pos, float *y_pos,
			      float *x_rad, float *y_rad)
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to acquire the first argument;
   * _ f_x_pos, f_y_pos: float variables to acquire the arguments;
   * _ d_x_pos, d_y_pos: double versions of the variables above;
   * _ f_x_rad, f_y_rad: float variables to acquire the arguments;
   * _ d_x_rad, d_y_rad: double versions of the variables above.
   */
  int    i_id_ad;
  float  f_x_pos, f_y_pos, f_x_rad, f_y_rad;
  double d_x_pos, d_y_pos, d_x_rad, d_y_rad;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  f_x_pos = *x_pos;
  f_y_pos = *y_pos;
  f_x_rad = *x_rad;
  f_y_rad = *y_rad;
  /*
   * Pass the float data to the double variables.
   */
  d_x_pos = f_x_pos;
  d_y_pos = f_y_pos;
  d_x_rad = f_x_rad;
  d_y_rad = f_y_rad;
  /*
   * Call the C function with the required arguments.
   */
  g2_filled_ellipse(i_id_ad,
		    d_x_pos, d_y_pos,
		    d_x_rad, d_y_rad);
}
/*
 * Compatibility function for gfortran.
 */
void g2_filled_ellipse_ctof_(int *id_ad,
			     float *x_pos, float *y_pos,
			     float *x_rad, float *y_rad)
{
  g2_filled_ellipse_ctof__(id_ad,
			   x_pos, y_pos,
			   x_rad, y_rad);
}
