/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_ld(), which returns the id of the last
 * _ accessed device.
 *
 * This is to be called from Fortran as an integer function,
 * _ that is, as "id = g2_ld_ctof()".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; there are no arguments.
 */
int g2_ld_ctof__()
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to return the device id.
   */
  int i_id_ad;
  /*
   * Call the C function with the required arguments.
   */
  i_id_ad = g2_ld();
  /*
   * Return the id of the device.
   */
  return(i_id_ad);
}
/*
 * Compatibility function for gfortran.
 */
int g2_ld_ctof_()
{
  return g2_ld_ctof__();
}
