/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_line(), which draws a line between two given
 * _ points.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_line_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad: the id of the device;
 * _ x_beg: the x position of the first point;
 * _ y_beg: the y position of the first point;
 * _ x_end: the x position of the second point;
 * _ y_end: the y position of the second point.
 */
void g2_line_ctof__(int *id_ad,
		    float *x_beg, float *y_beg,
		    float *x_end, float *y_end)
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to acquire the first argument;
   * _ f_x_beg, f_y_beg: float variables to acquire the arguments;
   * _ d_x_beg, d_y_beg: double versions of the variables above;
   * _ f_x_end, f_y_end: float variables to acquire the arguments;
   * _ d_x_end, d_y_end: double versions of the variables above.
   */
  int    i_id_ad;
  float  f_x_beg, f_y_beg, f_x_end, f_y_end;
  double d_x_beg, d_y_beg, d_x_end, d_y_end;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  f_x_beg = *x_beg;
  f_y_beg = *y_beg;
  f_x_end = *x_end;
  f_y_end = *y_end;
  /*
   * Pass the float data to the double variables.
   */
  d_x_beg = f_x_beg;
  d_y_beg = f_y_beg;
  d_x_end = f_x_end;
  d_y_end = f_y_end;
  /*
   * Call the C function with the required arguments.
   */
  g2_line(i_id_ad,
	  d_x_beg, d_y_beg,
	  d_x_end, d_y_end);
}
/*
 * Compatibility function for gfortran.
 */
void g2_line_ctof_(int *id_ad,
		   float *x_beg, float *y_beg,
		   float *x_end, float *y_end)
{
  g2_line_ctof__(id_ad,
		 x_beg, y_beg,
		 x_end, y_end);
}
