*     JLdL 11Nov07.
*     
*     Copyright (C) 2007 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine reads and then deletes a temporary file opened
*     _ previously with the file descriptor 1; after reading the
*     _ first entry in the file it decides whether to stop the
*     _ program or to finish reading the file and then return
*     _ control to the main program.
*     
      SUBROUTINE READ_PARAMS
*     
*     Include files with the relevant global data.
      include 'cb_gdata.for'
*     
*     Declare the g2 interface functions.
      include 'g2-ctof.for'
*     
*     Read the flag in the first entry of the file.
      read(1,*) i_flag
*     
*     If the flag is zero, then let us delete the file and stop
*     _ the plotting program altogether, after closing all the
*     _ devices in an orderly fashion.
      if ( i_flag .eq. 0 ) then
*     
*     Delete the data-transfer file.
         close(unit=1, status='delete')
*     
*     Save the data to the PS file.
         call g2_save_ctof(id_fd)
*     
*     Dissociate the physical devices from the virtual device.
         call g2_detach_ctof(id_vd, id_xd)
         call g2_detach_ctof(id_vd, id_fd)
*     
*     Close the physical devices.
         call g2_close_ctof(id_xd)
         call g2_close_ctof(id_fd)
*     
*     Close the virtual device.
         call g2_close_ctof(id_vd)
*     
         stop
*     
      end if
*     
*     If we are to continue, then read all the remaining
*     _ variables into the common block, one per line.
      read(1,*) i_func
      read(1,*) a_real
      read(1,*) a_imag
      read(1,*) b_real
      read(1,*) b_imag
      read(1,*) c_real
      read(1,*) c_imag
      read(1,*) npower
      read(1,*) xr_min
      read(1,*) xr_max
      read(1,*) yi_min
      read(1,*) yi_max
      read(1,*) xp_org
      read(1,*) yp_org
      read(1,*) i_cscp
      read(1,*) i_vect
      read(1,*) gr_siz
      read(1,*) sm_rad
      read(1,*) i_w_rw
      read(1,*) ix_pos
      read(1,*) iy_pos
      read(1,*) iw_scl
*     
*     Close and delete the file.
      close(unit=1, status='delete')
*     
      return
*     
      END
