



/*!
@file
Defines the `BOOST_HANA_DEFINE_STRUCT`, `BOOST_HANA_ADAPT_STRUCT`, and
`BOOST_HANA_ADAPT_ADT` macros.

@copyright Louis Dionne 2013-2017
Distributed under the Boost Software License, Version 1.0.
(See accompanying file LICENSE.md or copy at http://boost.org/LICENSE_1_0.txt)
 */

//////////////////////////////////////////////////////////////////////////////
// THIS FILE IS GENERATED FROM THE <boost/hana/detail/struct_macros.erb.hpp>
// ERB TEMPLATE. DO NOT EDIT THIS FILE DIRECTLY.
//
// THE ERB TEMPLATE CONTAINS INFORMATION ABOUT HOW TO REGENERATE THIS FILE.
//////////////////////////////////////////////////////////////////////////////

#ifndef BOOST_HANA_DETAIL_STRUCT_MACROS_HPP
#define BOOST_HANA_DETAIL_STRUCT_MACROS_HPP

#include <boost/hana/config.hpp>
#include <boost/hana/detail/preprocessor.hpp>
#include <boost/hana/pair.hpp>
#include <boost/hana/string.hpp>
#include <boost/hana/tuple.hpp>

#include <cstddef>
#include <utility>


BOOST_HANA_NAMESPACE_BEGIN namespace struct_detail {
    template <typename Memptr, Memptr ptr>
    struct member_ptr {
        template <typename T>
        constexpr decltype(auto) operator()(T&& t) const
        { return static_cast<T&&>(t).*ptr; }
    };

    constexpr std::size_t strlen(char const* s) {
        std::size_t n = 0;
        while (*s++ != '\0')
            ++n;
        return n;
    }

    template <std::size_t n, typename Names, std::size_t ...i>
    constexpr auto prepare_member_name_impl(std::index_sequence<i...>) {
        return hana::string_c<hana::at_c<n>(Names::get())[i]...>;
    }

    template <std::size_t n, typename Names>
    constexpr auto prepare_member_name() {
        constexpr std::size_t len = strlen(hana::at_c<n>(Names::get()));
        return prepare_member_name_impl<n, Names>(std::make_index_sequence<len>{});
    }
} BOOST_HANA_NAMESPACE_END

//////////////////////////////////////////////////////////////////////////////
// BOOST_HANA_PP_NARG
//////////////////////////////////////////////////////////////////////////////
//! @ingroup group-details
//! Macro expanding to the number of arguments it is passed.
//!
//! Specifically, `BOOST_HANA_PP_NARG(x1, ..., xn)` expands to `n`. It is
//! an error to call this macro with 0 arguments.
#define BOOST_HANA_PP_NARG(...) \
    BOOST_HANA_PP_NARG_IMPL(__VA_ARGS__, 40,39,38,37,36,35,34,33,32,31,30,29,28,27,26,25,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,)

#define BOOST_HANA_PP_NARG_IMPL(e1,e2,e3,e4,e5,e6,e7,e8,e9,e10,e11,e12,e13,e14,e15,e16,e17,e18,e19,e20,e21,e22,e23,e24,e25,e26,e27,e28,e29,e30,e31,e32,e33,e34,e35,e36,e37,e38,e39,e40, N, ...) N

//////////////////////////////////////////////////////////////////////////////
// BOOST_HANA_PP_BACK
//////////////////////////////////////////////////////////////////////////////
//! @ingroup group-details
//! Expands to its last argument.
#define BOOST_HANA_PP_BACK(...) \
    BOOST_HANA_PP_BACK_IMPL(BOOST_HANA_PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define BOOST_HANA_PP_BACK_IMPL(N, ...) \
    BOOST_HANA_PP_CONCAT(BOOST_HANA_PP_BACK_IMPL_, N)(__VA_ARGS__)


#define BOOST_HANA_PP_BACK_IMPL_1(e1) e1

#define BOOST_HANA_PP_BACK_IMPL_2(e1, e2) e2

#define BOOST_HANA_PP_BACK_IMPL_3(e1, e2, e3) e3

#define BOOST_HANA_PP_BACK_IMPL_4(e1, e2, e3, e4) e4

#define BOOST_HANA_PP_BACK_IMPL_5(e1, e2, e3, e4, e5) e5

#define BOOST_HANA_PP_BACK_IMPL_6(e1, e2, e3, e4, e5, e6) e6

#define BOOST_HANA_PP_BACK_IMPL_7(e1, e2, e3, e4, e5, e6, e7) e7

#define BOOST_HANA_PP_BACK_IMPL_8(e1, e2, e3, e4, e5, e6, e7, e8) e8

#define BOOST_HANA_PP_BACK_IMPL_9(e1, e2, e3, e4, e5, e6, e7, e8, e9) e9

#define BOOST_HANA_PP_BACK_IMPL_10(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10) e10

#define BOOST_HANA_PP_BACK_IMPL_11(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11) e11

#define BOOST_HANA_PP_BACK_IMPL_12(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12) e12

#define BOOST_HANA_PP_BACK_IMPL_13(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13) e13

#define BOOST_HANA_PP_BACK_IMPL_14(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14) e14

#define BOOST_HANA_PP_BACK_IMPL_15(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15) e15

#define BOOST_HANA_PP_BACK_IMPL_16(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16) e16

#define BOOST_HANA_PP_BACK_IMPL_17(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17) e17

#define BOOST_HANA_PP_BACK_IMPL_18(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18) e18

#define BOOST_HANA_PP_BACK_IMPL_19(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19) e19

#define BOOST_HANA_PP_BACK_IMPL_20(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20) e20

#define BOOST_HANA_PP_BACK_IMPL_21(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21) e21

#define BOOST_HANA_PP_BACK_IMPL_22(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22) e22

#define BOOST_HANA_PP_BACK_IMPL_23(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23) e23

#define BOOST_HANA_PP_BACK_IMPL_24(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24) e24

#define BOOST_HANA_PP_BACK_IMPL_25(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25) e25

#define BOOST_HANA_PP_BACK_IMPL_26(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26) e26

#define BOOST_HANA_PP_BACK_IMPL_27(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27) e27

#define BOOST_HANA_PP_BACK_IMPL_28(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28) e28

#define BOOST_HANA_PP_BACK_IMPL_29(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29) e29

#define BOOST_HANA_PP_BACK_IMPL_30(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30) e30

#define BOOST_HANA_PP_BACK_IMPL_31(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31) e31

#define BOOST_HANA_PP_BACK_IMPL_32(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32) e32

#define BOOST_HANA_PP_BACK_IMPL_33(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33) e33

#define BOOST_HANA_PP_BACK_IMPL_34(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34) e34

#define BOOST_HANA_PP_BACK_IMPL_35(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35) e35

#define BOOST_HANA_PP_BACK_IMPL_36(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36) e36

#define BOOST_HANA_PP_BACK_IMPL_37(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37) e37

#define BOOST_HANA_PP_BACK_IMPL_38(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38) e38

#define BOOST_HANA_PP_BACK_IMPL_39(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39) e39

#define BOOST_HANA_PP_BACK_IMPL_40(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40) e40


//////////////////////////////////////////////////////////////////////////////
// BOOST_HANA_PP_DROP_BACK
//////////////////////////////////////////////////////////////////////////////
//! @ingroup group-details
//! Expands to all of its arguments, except for the last one.
#define BOOST_HANA_PP_DROP_BACK(...) \
    BOOST_HANA_PP_DROP_BACK_IMPL(BOOST_HANA_PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define BOOST_HANA_PP_DROP_BACK_IMPL(N, ...) \
    BOOST_HANA_PP_CONCAT(BOOST_HANA_PP_DROP_BACK_IMPL_, N)(__VA_ARGS__)


#define BOOST_HANA_PP_DROP_BACK_IMPL_1(e1)

#define BOOST_HANA_PP_DROP_BACK_IMPL_2(e1, e2)e1

#define BOOST_HANA_PP_DROP_BACK_IMPL_3(e1, e2, e3)e1, e2

#define BOOST_HANA_PP_DROP_BACK_IMPL_4(e1, e2, e3, e4)e1, e2, e3

#define BOOST_HANA_PP_DROP_BACK_IMPL_5(e1, e2, e3, e4, e5)e1, e2, e3, e4

#define BOOST_HANA_PP_DROP_BACK_IMPL_6(e1, e2, e3, e4, e5, e6)e1, e2, e3, e4, e5

#define BOOST_HANA_PP_DROP_BACK_IMPL_7(e1, e2, e3, e4, e5, e6, e7)e1, e2, e3, e4, e5, e6

#define BOOST_HANA_PP_DROP_BACK_IMPL_8(e1, e2, e3, e4, e5, e6, e7, e8)e1, e2, e3, e4, e5, e6, e7

#define BOOST_HANA_PP_DROP_BACK_IMPL_9(e1, e2, e3, e4, e5, e6, e7, e8, e9)e1, e2, e3, e4, e5, e6, e7, e8

#define BOOST_HANA_PP_DROP_BACK_IMPL_10(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10)e1, e2, e3, e4, e5, e6, e7, e8, e9

#define BOOST_HANA_PP_DROP_BACK_IMPL_11(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10

#define BOOST_HANA_PP_DROP_BACK_IMPL_12(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11

#define BOOST_HANA_PP_DROP_BACK_IMPL_13(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12

#define BOOST_HANA_PP_DROP_BACK_IMPL_14(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13

#define BOOST_HANA_PP_DROP_BACK_IMPL_15(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14

#define BOOST_HANA_PP_DROP_BACK_IMPL_16(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15

#define BOOST_HANA_PP_DROP_BACK_IMPL_17(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16

#define BOOST_HANA_PP_DROP_BACK_IMPL_18(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17

#define BOOST_HANA_PP_DROP_BACK_IMPL_19(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18

#define BOOST_HANA_PP_DROP_BACK_IMPL_20(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19

#define BOOST_HANA_PP_DROP_BACK_IMPL_21(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20

#define BOOST_HANA_PP_DROP_BACK_IMPL_22(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21

#define BOOST_HANA_PP_DROP_BACK_IMPL_23(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22

#define BOOST_HANA_PP_DROP_BACK_IMPL_24(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23

#define BOOST_HANA_PP_DROP_BACK_IMPL_25(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24

#define BOOST_HANA_PP_DROP_BACK_IMPL_26(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25

#define BOOST_HANA_PP_DROP_BACK_IMPL_27(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26

#define BOOST_HANA_PP_DROP_BACK_IMPL_28(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27

#define BOOST_HANA_PP_DROP_BACK_IMPL_29(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28

#define BOOST_HANA_PP_DROP_BACK_IMPL_30(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29

#define BOOST_HANA_PP_DROP_BACK_IMPL_31(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30

#define BOOST_HANA_PP_DROP_BACK_IMPL_32(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31

#define BOOST_HANA_PP_DROP_BACK_IMPL_33(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32

#define BOOST_HANA_PP_DROP_BACK_IMPL_34(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33

#define BOOST_HANA_PP_DROP_BACK_IMPL_35(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34

#define BOOST_HANA_PP_DROP_BACK_IMPL_36(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35

#define BOOST_HANA_PP_DROP_BACK_IMPL_37(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36

#define BOOST_HANA_PP_DROP_BACK_IMPL_38(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37

#define BOOST_HANA_PP_DROP_BACK_IMPL_39(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38

#define BOOST_HANA_PP_DROP_BACK_IMPL_40(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39


//////////////////////////////////////////////////////////////////////////////
// BOOST_HANA_ADAPT_STRUCT
//////////////////////////////////////////////////////////////////////////////
template <typename ...>
struct BOOST_HANA_ADAPT_STRUCT_must_be_called_in_the_global_namespace;

#define BOOST_HANA_ADAPT_STRUCT(...)                                        \
  template <>                                                               \
  struct BOOST_HANA_ADAPT_STRUCT_must_be_called_in_the_global_namespace<>;  \
  BOOST_HANA_ADAPT_STRUCT_IMPL(BOOST_HANA_PP_NARG(__VA_ARGS__), __VA_ARGS__)\
  static_assert(true, "force the usage of a trailing semicolon")            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL(N, ...) \
  BOOST_HANA_PP_CONCAT(BOOST_HANA_ADAPT_STRUCT_IMPL_, N)(__VA_ARGS__)


#define BOOST_HANA_ADAPT_STRUCT_IMPL_1(TYPE )    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                             \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    \
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_2(TYPE , m1)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_3(TYPE , m1, m2)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_4(TYPE , m1, m2, m3)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_5(TYPE , m1, m2, m3, m4)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_6(TYPE , m1, m2, m3, m4, m5)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_7(TYPE , m1, m2, m3, m4, m5, m6)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_8(TYPE , m1, m2, m3, m4, m5, m6, m7)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_9(TYPE , m1, m2, m3, m4, m5, m6, m7, m8)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_10(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_11(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_12(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_13(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_14(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_15(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_16(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_17(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_18(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_19(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_20(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_21(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_22(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_23(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_24(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_25(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_26(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_27(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_28(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_29(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_30(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_31(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_32(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_33(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_34(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_35(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_36(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_37(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_38(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_39(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_40(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_41(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/


//////////////////////////////////////////////////////////////////////////////
// BOOST_HANA_ADAPT_ADT
//////////////////////////////////////////////////////////////////////////////
template <typename ...>
struct BOOST_HANA_ADAPT_ADT_must_be_called_in_the_global_namespace;

#define BOOST_HANA_ADAPT_ADT(...)                                           \
  template <>                                                               \
  struct BOOST_HANA_ADAPT_ADT_must_be_called_in_the_global_namespace<>;     \
  BOOST_HANA_ADAPT_ADT_IMPL(BOOST_HANA_PP_NARG(__VA_ARGS__), __VA_ARGS__)   \
  static_assert(true, "force the usage of a trailing semicolon")            \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL(N, ...) \
  BOOST_HANA_PP_CONCAT(BOOST_HANA_ADAPT_ADT_IMPL_, N)(__VA_ARGS__)


#define BOOST_HANA_ADAPT_ADT_IMPL_1(TYPE )             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        \
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    \
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_2(TYPE , m1)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_3(TYPE , m1, m2)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_4(TYPE , m1, m2, m3)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_5(TYPE , m1, m2, m3, m4)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_6(TYPE , m1, m2, m3, m4, m5)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_7(TYPE , m1, m2, m3, m4, m5, m6)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_8(TYPE , m1, m2, m3, m4, m5, m6, m7)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_9(TYPE , m1, m2, m3, m4, m5, m6, m7, m8)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_10(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_11(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_12(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_13(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_14(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_15(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_16(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_17(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_18(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_19(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_20(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_21(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_22(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_23(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_24(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_25(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_26(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_27(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_28(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_29(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_30(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m29)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), BOOST_HANA_PP_DROP_FRONT m29)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_31(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m30)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), BOOST_HANA_PP_DROP_FRONT m29), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), BOOST_HANA_PP_DROP_FRONT m30)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_32(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m31)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), BOOST_HANA_PP_DROP_FRONT m29), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), BOOST_HANA_PP_DROP_FRONT m30), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), BOOST_HANA_PP_DROP_FRONT m31)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_33(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m32)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), BOOST_HANA_PP_DROP_FRONT m29), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), BOOST_HANA_PP_DROP_FRONT m30), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), BOOST_HANA_PP_DROP_FRONT m31), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), BOOST_HANA_PP_DROP_FRONT m32)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_34(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m33)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), BOOST_HANA_PP_DROP_FRONT m29), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), BOOST_HANA_PP_DROP_FRONT m30), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), BOOST_HANA_PP_DROP_FRONT m31), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), BOOST_HANA_PP_DROP_FRONT m32), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), BOOST_HANA_PP_DROP_FRONT m33)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_35(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m34)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), BOOST_HANA_PP_DROP_FRONT m29), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), BOOST_HANA_PP_DROP_FRONT m30), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), BOOST_HANA_PP_DROP_FRONT m31), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), BOOST_HANA_PP_DROP_FRONT m32), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), BOOST_HANA_PP_DROP_FRONT m33), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), BOOST_HANA_PP_DROP_FRONT m34)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_36(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m34), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m35)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), BOOST_HANA_PP_DROP_FRONT m29), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), BOOST_HANA_PP_DROP_FRONT m30), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), BOOST_HANA_PP_DROP_FRONT m31), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), BOOST_HANA_PP_DROP_FRONT m32), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), BOOST_HANA_PP_DROP_FRONT m33), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), BOOST_HANA_PP_DROP_FRONT m34), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), BOOST_HANA_PP_DROP_FRONT m35)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_37(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m34), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m35), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m36)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), BOOST_HANA_PP_DROP_FRONT m29), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), BOOST_HANA_PP_DROP_FRONT m30), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), BOOST_HANA_PP_DROP_FRONT m31), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), BOOST_HANA_PP_DROP_FRONT m32), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), BOOST_HANA_PP_DROP_FRONT m33), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), BOOST_HANA_PP_DROP_FRONT m34), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), BOOST_HANA_PP_DROP_FRONT m35), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), BOOST_HANA_PP_DROP_FRONT m36)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_38(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m34), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m35), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m36), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m37)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), BOOST_HANA_PP_DROP_FRONT m29), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), BOOST_HANA_PP_DROP_FRONT m30), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), BOOST_HANA_PP_DROP_FRONT m31), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), BOOST_HANA_PP_DROP_FRONT m32), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), BOOST_HANA_PP_DROP_FRONT m33), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), BOOST_HANA_PP_DROP_FRONT m34), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), BOOST_HANA_PP_DROP_FRONT m35), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), BOOST_HANA_PP_DROP_FRONT m36), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), BOOST_HANA_PP_DROP_FRONT m37)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_39(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m34), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m35), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m36), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m37), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m38)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), BOOST_HANA_PP_DROP_FRONT m29), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), BOOST_HANA_PP_DROP_FRONT m30), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), BOOST_HANA_PP_DROP_FRONT m31), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), BOOST_HANA_PP_DROP_FRONT m32), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), BOOST_HANA_PP_DROP_FRONT m33), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), BOOST_HANA_PP_DROP_FRONT m34), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), BOOST_HANA_PP_DROP_FRONT m35), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), BOOST_HANA_PP_DROP_FRONT m36), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), BOOST_HANA_PP_DROP_FRONT m37), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), BOOST_HANA_PP_DROP_FRONT m38)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_40(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m34), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m35), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m36), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m37), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m38), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m39)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), BOOST_HANA_PP_DROP_FRONT m29), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), BOOST_HANA_PP_DROP_FRONT m30), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), BOOST_HANA_PP_DROP_FRONT m31), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), BOOST_HANA_PP_DROP_FRONT m32), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), BOOST_HANA_PP_DROP_FRONT m33), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), BOOST_HANA_PP_DROP_FRONT m34), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), BOOST_HANA_PP_DROP_FRONT m35), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), BOOST_HANA_PP_DROP_FRONT m36), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), BOOST_HANA_PP_DROP_FRONT m37), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), BOOST_HANA_PP_DROP_FRONT m38), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), BOOST_HANA_PP_DROP_FRONT m39)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/

#define BOOST_HANA_ADAPT_ADT_IMPL_41(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40)             \
    namespace boost { namespace hana {                                                                  \
        template <>                                                                                     \
        struct accessors_impl<TYPE> {                                                                   \
            template <typename ...>                                                                     \
            static constexpr auto apply() {                                                             \
                struct member_names {                                                                   \
                  static constexpr auto get() {                                                         \
                      return ::boost::hana::make_tuple(                                                 \
                        BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m34), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m35), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m36), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m37), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m38), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m39), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_FRONT m40)\
                      );                                                                                \
                  }                                                                                     \
                };                                                                                      \
                return ::boost::hana::make_tuple(                                                       \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), BOOST_HANA_PP_DROP_FRONT m1), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), BOOST_HANA_PP_DROP_FRONT m2), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), BOOST_HANA_PP_DROP_FRONT m3), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), BOOST_HANA_PP_DROP_FRONT m4), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), BOOST_HANA_PP_DROP_FRONT m5), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), BOOST_HANA_PP_DROP_FRONT m6), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), BOOST_HANA_PP_DROP_FRONT m7), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), BOOST_HANA_PP_DROP_FRONT m8), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), BOOST_HANA_PP_DROP_FRONT m9), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), BOOST_HANA_PP_DROP_FRONT m10), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), BOOST_HANA_PP_DROP_FRONT m11), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), BOOST_HANA_PP_DROP_FRONT m12), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), BOOST_HANA_PP_DROP_FRONT m13), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), BOOST_HANA_PP_DROP_FRONT m14), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), BOOST_HANA_PP_DROP_FRONT m15), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), BOOST_HANA_PP_DROP_FRONT m16), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), BOOST_HANA_PP_DROP_FRONT m17), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), BOOST_HANA_PP_DROP_FRONT m18), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), BOOST_HANA_PP_DROP_FRONT m19), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), BOOST_HANA_PP_DROP_FRONT m20), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), BOOST_HANA_PP_DROP_FRONT m21), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), BOOST_HANA_PP_DROP_FRONT m22), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), BOOST_HANA_PP_DROP_FRONT m23), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), BOOST_HANA_PP_DROP_FRONT m24), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), BOOST_HANA_PP_DROP_FRONT m25), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), BOOST_HANA_PP_DROP_FRONT m26), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), BOOST_HANA_PP_DROP_FRONT m27), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), BOOST_HANA_PP_DROP_FRONT m28), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), BOOST_HANA_PP_DROP_FRONT m29), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), BOOST_HANA_PP_DROP_FRONT m30), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), BOOST_HANA_PP_DROP_FRONT m31), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), BOOST_HANA_PP_DROP_FRONT m32), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), BOOST_HANA_PP_DROP_FRONT m33), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), BOOST_HANA_PP_DROP_FRONT m34), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), BOOST_HANA_PP_DROP_FRONT m35), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), BOOST_HANA_PP_DROP_FRONT m36), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), BOOST_HANA_PP_DROP_FRONT m37), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), BOOST_HANA_PP_DROP_FRONT m38), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), BOOST_HANA_PP_DROP_FRONT m39), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), BOOST_HANA_PP_DROP_FRONT m40)\
                );                                                                                      \
            }                                                                                           \
        };                                                                                              \
    }}                                                                                                  \
/**/


//////////////////////////////////////////////////////////////////////////////
// BOOST_HANA_DEFINE_STRUCT
//////////////////////////////////////////////////////////////////////////////
#define BOOST_HANA_DEFINE_STRUCT(...) \
    BOOST_HANA_DEFINE_STRUCT_IMPL(BOOST_HANA_PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define BOOST_HANA_DEFINE_STRUCT_IMPL(N, ...) \
    BOOST_HANA_PP_CONCAT(BOOST_HANA_DEFINE_STRUCT_IMPL_, N)(__VA_ARGS__)


#define BOOST_HANA_DEFINE_STRUCT_IMPL_1(TYPE )       \
         \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              \
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        \
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_2(TYPE , m1)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_3(TYPE , m1, m2)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_4(TYPE , m1, m2, m3)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_5(TYPE , m1, m2, m3, m4)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_6(TYPE , m1, m2, m3, m4, m5)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_7(TYPE , m1, m2, m3, m4, m5, m6)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_8(TYPE , m1, m2, m3, m4, m5, m6, m7)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_9(TYPE , m1, m2, m3, m4, m5, m6, m7, m8)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_10(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_11(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_12(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_13(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_14(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_15(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_16(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_17(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_18(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_19(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_20(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_21(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_22(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_23(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_24(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_25(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_26(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_27(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_28(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_29(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_30(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28; BOOST_HANA_PP_DROP_BACK m29 BOOST_HANA_PP_BACK m29;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m29)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m29), &TYPE::BOOST_HANA_PP_BACK m29>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_31(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28; BOOST_HANA_PP_DROP_BACK m29 BOOST_HANA_PP_BACK m29; BOOST_HANA_PP_DROP_BACK m30 BOOST_HANA_PP_BACK m30;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m30)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m29), &TYPE::BOOST_HANA_PP_BACK m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m30), &TYPE::BOOST_HANA_PP_BACK m30>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_32(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28; BOOST_HANA_PP_DROP_BACK m29 BOOST_HANA_PP_BACK m29; BOOST_HANA_PP_DROP_BACK m30 BOOST_HANA_PP_BACK m30; BOOST_HANA_PP_DROP_BACK m31 BOOST_HANA_PP_BACK m31;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m31)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m29), &TYPE::BOOST_HANA_PP_BACK m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m30), &TYPE::BOOST_HANA_PP_BACK m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m31), &TYPE::BOOST_HANA_PP_BACK m31>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_33(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28; BOOST_HANA_PP_DROP_BACK m29 BOOST_HANA_PP_BACK m29; BOOST_HANA_PP_DROP_BACK m30 BOOST_HANA_PP_BACK m30; BOOST_HANA_PP_DROP_BACK m31 BOOST_HANA_PP_BACK m31; BOOST_HANA_PP_DROP_BACK m32 BOOST_HANA_PP_BACK m32;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m32)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m29), &TYPE::BOOST_HANA_PP_BACK m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m30), &TYPE::BOOST_HANA_PP_BACK m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m31), &TYPE::BOOST_HANA_PP_BACK m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m32), &TYPE::BOOST_HANA_PP_BACK m32>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_34(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28; BOOST_HANA_PP_DROP_BACK m29 BOOST_HANA_PP_BACK m29; BOOST_HANA_PP_DROP_BACK m30 BOOST_HANA_PP_BACK m30; BOOST_HANA_PP_DROP_BACK m31 BOOST_HANA_PP_BACK m31; BOOST_HANA_PP_DROP_BACK m32 BOOST_HANA_PP_BACK m32; BOOST_HANA_PP_DROP_BACK m33 BOOST_HANA_PP_BACK m33;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m33)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m29), &TYPE::BOOST_HANA_PP_BACK m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m30), &TYPE::BOOST_HANA_PP_BACK m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m31), &TYPE::BOOST_HANA_PP_BACK m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m32), &TYPE::BOOST_HANA_PP_BACK m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m33), &TYPE::BOOST_HANA_PP_BACK m33>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_35(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28; BOOST_HANA_PP_DROP_BACK m29 BOOST_HANA_PP_BACK m29; BOOST_HANA_PP_DROP_BACK m30 BOOST_HANA_PP_BACK m30; BOOST_HANA_PP_DROP_BACK m31 BOOST_HANA_PP_BACK m31; BOOST_HANA_PP_DROP_BACK m32 BOOST_HANA_PP_BACK m32; BOOST_HANA_PP_DROP_BACK m33 BOOST_HANA_PP_BACK m33; BOOST_HANA_PP_DROP_BACK m34 BOOST_HANA_PP_BACK m34;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m34)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m29), &TYPE::BOOST_HANA_PP_BACK m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m30), &TYPE::BOOST_HANA_PP_BACK m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m31), &TYPE::BOOST_HANA_PP_BACK m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m32), &TYPE::BOOST_HANA_PP_BACK m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m33), &TYPE::BOOST_HANA_PP_BACK m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m34), &TYPE::BOOST_HANA_PP_BACK m34>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_36(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28; BOOST_HANA_PP_DROP_BACK m29 BOOST_HANA_PP_BACK m29; BOOST_HANA_PP_DROP_BACK m30 BOOST_HANA_PP_BACK m30; BOOST_HANA_PP_DROP_BACK m31 BOOST_HANA_PP_BACK m31; BOOST_HANA_PP_DROP_BACK m32 BOOST_HANA_PP_BACK m32; BOOST_HANA_PP_DROP_BACK m33 BOOST_HANA_PP_BACK m33; BOOST_HANA_PP_DROP_BACK m34 BOOST_HANA_PP_BACK m34; BOOST_HANA_PP_DROP_BACK m35 BOOST_HANA_PP_BACK m35;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m34), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m35)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m29), &TYPE::BOOST_HANA_PP_BACK m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m30), &TYPE::BOOST_HANA_PP_BACK m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m31), &TYPE::BOOST_HANA_PP_BACK m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m32), &TYPE::BOOST_HANA_PP_BACK m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m33), &TYPE::BOOST_HANA_PP_BACK m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m34), &TYPE::BOOST_HANA_PP_BACK m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m35), &TYPE::BOOST_HANA_PP_BACK m35>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_37(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28; BOOST_HANA_PP_DROP_BACK m29 BOOST_HANA_PP_BACK m29; BOOST_HANA_PP_DROP_BACK m30 BOOST_HANA_PP_BACK m30; BOOST_HANA_PP_DROP_BACK m31 BOOST_HANA_PP_BACK m31; BOOST_HANA_PP_DROP_BACK m32 BOOST_HANA_PP_BACK m32; BOOST_HANA_PP_DROP_BACK m33 BOOST_HANA_PP_BACK m33; BOOST_HANA_PP_DROP_BACK m34 BOOST_HANA_PP_BACK m34; BOOST_HANA_PP_DROP_BACK m35 BOOST_HANA_PP_BACK m35; BOOST_HANA_PP_DROP_BACK m36 BOOST_HANA_PP_BACK m36;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m34), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m35), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m36)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m29), &TYPE::BOOST_HANA_PP_BACK m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m30), &TYPE::BOOST_HANA_PP_BACK m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m31), &TYPE::BOOST_HANA_PP_BACK m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m32), &TYPE::BOOST_HANA_PP_BACK m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m33), &TYPE::BOOST_HANA_PP_BACK m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m34), &TYPE::BOOST_HANA_PP_BACK m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m35), &TYPE::BOOST_HANA_PP_BACK m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m36), &TYPE::BOOST_HANA_PP_BACK m36>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_38(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28; BOOST_HANA_PP_DROP_BACK m29 BOOST_HANA_PP_BACK m29; BOOST_HANA_PP_DROP_BACK m30 BOOST_HANA_PP_BACK m30; BOOST_HANA_PP_DROP_BACK m31 BOOST_HANA_PP_BACK m31; BOOST_HANA_PP_DROP_BACK m32 BOOST_HANA_PP_BACK m32; BOOST_HANA_PP_DROP_BACK m33 BOOST_HANA_PP_BACK m33; BOOST_HANA_PP_DROP_BACK m34 BOOST_HANA_PP_BACK m34; BOOST_HANA_PP_DROP_BACK m35 BOOST_HANA_PP_BACK m35; BOOST_HANA_PP_DROP_BACK m36 BOOST_HANA_PP_BACK m36; BOOST_HANA_PP_DROP_BACK m37 BOOST_HANA_PP_BACK m37;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m34), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m35), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m36), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m37)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m29), &TYPE::BOOST_HANA_PP_BACK m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m30), &TYPE::BOOST_HANA_PP_BACK m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m31), &TYPE::BOOST_HANA_PP_BACK m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m32), &TYPE::BOOST_HANA_PP_BACK m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m33), &TYPE::BOOST_HANA_PP_BACK m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m34), &TYPE::BOOST_HANA_PP_BACK m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m35), &TYPE::BOOST_HANA_PP_BACK m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m36), &TYPE::BOOST_HANA_PP_BACK m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m37), &TYPE::BOOST_HANA_PP_BACK m37>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_39(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28; BOOST_HANA_PP_DROP_BACK m29 BOOST_HANA_PP_BACK m29; BOOST_HANA_PP_DROP_BACK m30 BOOST_HANA_PP_BACK m30; BOOST_HANA_PP_DROP_BACK m31 BOOST_HANA_PP_BACK m31; BOOST_HANA_PP_DROP_BACK m32 BOOST_HANA_PP_BACK m32; BOOST_HANA_PP_DROP_BACK m33 BOOST_HANA_PP_BACK m33; BOOST_HANA_PP_DROP_BACK m34 BOOST_HANA_PP_BACK m34; BOOST_HANA_PP_DROP_BACK m35 BOOST_HANA_PP_BACK m35; BOOST_HANA_PP_DROP_BACK m36 BOOST_HANA_PP_BACK m36; BOOST_HANA_PP_DROP_BACK m37 BOOST_HANA_PP_BACK m37; BOOST_HANA_PP_DROP_BACK m38 BOOST_HANA_PP_BACK m38;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m34), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m35), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m36), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m37), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m38)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m29), &TYPE::BOOST_HANA_PP_BACK m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m30), &TYPE::BOOST_HANA_PP_BACK m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m31), &TYPE::BOOST_HANA_PP_BACK m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m32), &TYPE::BOOST_HANA_PP_BACK m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m33), &TYPE::BOOST_HANA_PP_BACK m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m34), &TYPE::BOOST_HANA_PP_BACK m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m35), &TYPE::BOOST_HANA_PP_BACK m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m36), &TYPE::BOOST_HANA_PP_BACK m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m37), &TYPE::BOOST_HANA_PP_BACK m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m38), &TYPE::BOOST_HANA_PP_BACK m38>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_40(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28; BOOST_HANA_PP_DROP_BACK m29 BOOST_HANA_PP_BACK m29; BOOST_HANA_PP_DROP_BACK m30 BOOST_HANA_PP_BACK m30; BOOST_HANA_PP_DROP_BACK m31 BOOST_HANA_PP_BACK m31; BOOST_HANA_PP_DROP_BACK m32 BOOST_HANA_PP_BACK m32; BOOST_HANA_PP_DROP_BACK m33 BOOST_HANA_PP_BACK m33; BOOST_HANA_PP_DROP_BACK m34 BOOST_HANA_PP_BACK m34; BOOST_HANA_PP_DROP_BACK m35 BOOST_HANA_PP_BACK m35; BOOST_HANA_PP_DROP_BACK m36 BOOST_HANA_PP_BACK m36; BOOST_HANA_PP_DROP_BACK m37 BOOST_HANA_PP_BACK m37; BOOST_HANA_PP_DROP_BACK m38 BOOST_HANA_PP_BACK m38; BOOST_HANA_PP_DROP_BACK m39 BOOST_HANA_PP_BACK m39;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m34), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m35), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m36), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m37), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m38), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m39)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m29), &TYPE::BOOST_HANA_PP_BACK m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m30), &TYPE::BOOST_HANA_PP_BACK m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m31), &TYPE::BOOST_HANA_PP_BACK m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m32), &TYPE::BOOST_HANA_PP_BACK m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m33), &TYPE::BOOST_HANA_PP_BACK m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m34), &TYPE::BOOST_HANA_PP_BACK m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m35), &TYPE::BOOST_HANA_PP_BACK m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m36), &TYPE::BOOST_HANA_PP_BACK m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m37), &TYPE::BOOST_HANA_PP_BACK m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m38), &TYPE::BOOST_HANA_PP_BACK m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m39), &TYPE::BOOST_HANA_PP_BACK m39>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/

#define BOOST_HANA_DEFINE_STRUCT_IMPL_41(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40)       \
  BOOST_HANA_PP_DROP_BACK m1 BOOST_HANA_PP_BACK m1; BOOST_HANA_PP_DROP_BACK m2 BOOST_HANA_PP_BACK m2; BOOST_HANA_PP_DROP_BACK m3 BOOST_HANA_PP_BACK m3; BOOST_HANA_PP_DROP_BACK m4 BOOST_HANA_PP_BACK m4; BOOST_HANA_PP_DROP_BACK m5 BOOST_HANA_PP_BACK m5; BOOST_HANA_PP_DROP_BACK m6 BOOST_HANA_PP_BACK m6; BOOST_HANA_PP_DROP_BACK m7 BOOST_HANA_PP_BACK m7; BOOST_HANA_PP_DROP_BACK m8 BOOST_HANA_PP_BACK m8; BOOST_HANA_PP_DROP_BACK m9 BOOST_HANA_PP_BACK m9; BOOST_HANA_PP_DROP_BACK m10 BOOST_HANA_PP_BACK m10; BOOST_HANA_PP_DROP_BACK m11 BOOST_HANA_PP_BACK m11; BOOST_HANA_PP_DROP_BACK m12 BOOST_HANA_PP_BACK m12; BOOST_HANA_PP_DROP_BACK m13 BOOST_HANA_PP_BACK m13; BOOST_HANA_PP_DROP_BACK m14 BOOST_HANA_PP_BACK m14; BOOST_HANA_PP_DROP_BACK m15 BOOST_HANA_PP_BACK m15; BOOST_HANA_PP_DROP_BACK m16 BOOST_HANA_PP_BACK m16; BOOST_HANA_PP_DROP_BACK m17 BOOST_HANA_PP_BACK m17; BOOST_HANA_PP_DROP_BACK m18 BOOST_HANA_PP_BACK m18; BOOST_HANA_PP_DROP_BACK m19 BOOST_HANA_PP_BACK m19; BOOST_HANA_PP_DROP_BACK m20 BOOST_HANA_PP_BACK m20; BOOST_HANA_PP_DROP_BACK m21 BOOST_HANA_PP_BACK m21; BOOST_HANA_PP_DROP_BACK m22 BOOST_HANA_PP_BACK m22; BOOST_HANA_PP_DROP_BACK m23 BOOST_HANA_PP_BACK m23; BOOST_HANA_PP_DROP_BACK m24 BOOST_HANA_PP_BACK m24; BOOST_HANA_PP_DROP_BACK m25 BOOST_HANA_PP_BACK m25; BOOST_HANA_PP_DROP_BACK m26 BOOST_HANA_PP_BACK m26; BOOST_HANA_PP_DROP_BACK m27 BOOST_HANA_PP_BACK m27; BOOST_HANA_PP_DROP_BACK m28 BOOST_HANA_PP_BACK m28; BOOST_HANA_PP_DROP_BACK m29 BOOST_HANA_PP_BACK m29; BOOST_HANA_PP_DROP_BACK m30 BOOST_HANA_PP_BACK m30; BOOST_HANA_PP_DROP_BACK m31 BOOST_HANA_PP_BACK m31; BOOST_HANA_PP_DROP_BACK m32 BOOST_HANA_PP_BACK m32; BOOST_HANA_PP_DROP_BACK m33 BOOST_HANA_PP_BACK m33; BOOST_HANA_PP_DROP_BACK m34 BOOST_HANA_PP_BACK m34; BOOST_HANA_PP_DROP_BACK m35 BOOST_HANA_PP_BACK m35; BOOST_HANA_PP_DROP_BACK m36 BOOST_HANA_PP_BACK m36; BOOST_HANA_PP_DROP_BACK m37 BOOST_HANA_PP_BACK m37; BOOST_HANA_PP_DROP_BACK m38 BOOST_HANA_PP_BACK m38; BOOST_HANA_PP_DROP_BACK m39 BOOST_HANA_PP_BACK m39; BOOST_HANA_PP_DROP_BACK m40 BOOST_HANA_PP_BACK m40;       \
                                                                                                      \
  struct hana_accessors_impl {                                                                        \
    static constexpr auto apply() {                                                                   \
      struct member_names {                                                                           \
        static constexpr auto get() {                                                                 \
            return ::boost::hana::make_tuple(                                                         \
              BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m1), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m2), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m3), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m4), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m5), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m6), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m7), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m8), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m9), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m10), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m11), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m12), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m13), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m14), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m15), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m16), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m17), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m18), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m19), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m20), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m21), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m22), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m23), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m24), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m25), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m26), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m27), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m28), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m29), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m30), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m31), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m32), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m33), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m34), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m35), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m36), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m37), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m38), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m39), BOOST_HANA_PP_STRINGIZE(BOOST_HANA_PP_BACK m40)\
            );                                                                                        \
        }                                                                                             \
      };                                                                                              \
      return ::boost::hana::make_tuple(                                                               \
        ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m1), &TYPE::BOOST_HANA_PP_BACK m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m2), &TYPE::BOOST_HANA_PP_BACK m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m3), &TYPE::BOOST_HANA_PP_BACK m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m4), &TYPE::BOOST_HANA_PP_BACK m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m5), &TYPE::BOOST_HANA_PP_BACK m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m6), &TYPE::BOOST_HANA_PP_BACK m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m7), &TYPE::BOOST_HANA_PP_BACK m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m8), &TYPE::BOOST_HANA_PP_BACK m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m9), &TYPE::BOOST_HANA_PP_BACK m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m10), &TYPE::BOOST_HANA_PP_BACK m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m11), &TYPE::BOOST_HANA_PP_BACK m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m12), &TYPE::BOOST_HANA_PP_BACK m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m13), &TYPE::BOOST_HANA_PP_BACK m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m14), &TYPE::BOOST_HANA_PP_BACK m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m15), &TYPE::BOOST_HANA_PP_BACK m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m16), &TYPE::BOOST_HANA_PP_BACK m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m17), &TYPE::BOOST_HANA_PP_BACK m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m18), &TYPE::BOOST_HANA_PP_BACK m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m19), &TYPE::BOOST_HANA_PP_BACK m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m20), &TYPE::BOOST_HANA_PP_BACK m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m21), &TYPE::BOOST_HANA_PP_BACK m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m22), &TYPE::BOOST_HANA_PP_BACK m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m23), &TYPE::BOOST_HANA_PP_BACK m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m24), &TYPE::BOOST_HANA_PP_BACK m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m25), &TYPE::BOOST_HANA_PP_BACK m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m26), &TYPE::BOOST_HANA_PP_BACK m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m27), &TYPE::BOOST_HANA_PP_BACK m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m28), &TYPE::BOOST_HANA_PP_BACK m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m29), &TYPE::BOOST_HANA_PP_BACK m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m30), &TYPE::BOOST_HANA_PP_BACK m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m31), &TYPE::BOOST_HANA_PP_BACK m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m32), &TYPE::BOOST_HANA_PP_BACK m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m33), &TYPE::BOOST_HANA_PP_BACK m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m34), &TYPE::BOOST_HANA_PP_BACK m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m35), &TYPE::BOOST_HANA_PP_BACK m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m36), &TYPE::BOOST_HANA_PP_BACK m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m37), &TYPE::BOOST_HANA_PP_BACK m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m38), &TYPE::BOOST_HANA_PP_BACK m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m39), &TYPE::BOOST_HANA_PP_BACK m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::BOOST_HANA_PP_BACK m40), &TYPE::BOOST_HANA_PP_BACK m40>{})\
      );                                                                                              \
    }                                                                                                 \
  }                                                                                                   \
/**/


#endif // !BOOST_HANA_DETAIL_STRUCT_MACROS_HPP
