# Copyright (C) 2009 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA


from PyQt4 import QtCore, QtGui

class FilterBar(QtGui.QFrame):
    """A widget providing a filter bar.

    This is a row of text buttons designed to act like a set of tabs.
    Only one is selected at a given time. On OS X, it ought to look
    like a "scope bar" (though I'm not sure how to make Qt do that).

    Note: Like scope bars, a filter bar most likely appears just under
    the toolbar and above the rest of the work area.
    """

    def __init__(self, labels, *args):
        QtGui.QFrame.__init__(self, *args)
        self.group = QtGui.QButtonGroup()
        self.group.setExclusive(True)
        self.bar = QtGui.QHBoxLayout()
        if labels:
            self._add_label(labels[0], on=True)
            for text in labels[1:]:
                self._add_label(text)
        self.setLayout(self.bar)

    def _add_label(self, text, on=False):
        btn = QtGui.QToolButton()
        btn.setText(text)
        btn.setCheckable(True)
        if on:
            btn.setChecked(True)
        btn.setAutoExclusive(True)
        self.group.addButton(btn)
        self.bar.addWidget(btn)
