.\" dpkg manual page - dpkg-parsechangelog(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006, 2011-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2007-2008 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2009 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-parsechangelog 1 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.nh
.SH BEZEICHNUNG
dpkg\-parsechangelog \- auswerten von Debian changelog\-Dateien
.
.SH ÜBERSICHT
\fBdpkg\-parsechangelog\fP [\fIOption\fP …]
.
.SH BESCHREIBUNG
\fBdpkg\-parsechangelog\fP liest das Änderungsprotokoll (»changelog«) eines
entpackten Debian\-Quellcodebaums ein, wertet diese aus und gibt die
Informationen in der Standard\-Ausgabe in maschinenlesbarer Form aus.
.
.SH OPTIONEN
.TP 
\fB\-l\fP, \fB\-\-file\fP \fIChangelog\-Datei\fP
Gibt die Änderungsprotokolldatei an, aus der Informationen gelesen werden
sollen. Ein ‚\-’ kann zur Angabe des Lesens von der Standardeingabe verwandt
werden. Standardmäßig \fBdebian/changelog\fP.
.TP 
\fB\-F\fP \fIChangelog\-Format\fP
Gibt das Format der Änderungsprotokolldatei an. Standardmäßig wird das
Format aus einer speziellen Zeile in der Nähe des Endes der
Änderungsprotokolldatei gelesen oder, falls dies fehlschlägt, wird das
\fBdebian\fP\-Standardformat angenommen. Siehe auch \fBCHANGELOG\-FORMATE\fP.
.TP 
\fB\-L\fP \fIlibverzeichnis\fP
Veraltete Option ohne Effekt (seit Dpkg 1.18.8). Setzen der
Perl\-Umgebungsvariablen \fBPERL5LIB\fP oder \fBPERLLIB\fP hat einen ähnlichen
Effekt, wenn nach Auswerter\-Perl\-Modulen gesucht wird.
.TP 
\fB\-S\fP, \fB\-\-show\-field\fP \fIFeld\fP
Spezifiziert den Namen des anzuzeigenden Feldes (seit Dpkg 1.17.0). Der
Feldname wird nicht angezeigt, nur sein Wert.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Zeige den Bedienungshinweis und beende.
.TP 
\fB\-\-version\fP
Gebe die Version aus und beende sich.
.SS Auswerter\-Optionen:
Die folgenden Optionen können verwendet werden, um die Ausgabe des
Changelog\-Auswerters zu beinflussen, z.B. den Bereich der Einträge oder das
Format der Ausgabe.
.TP 
\fB\-\-format\fP\fI Ausgabeformat\fP
Setze das Ausgabeformat. Derzeit werden die Werte \fBdpkg\fP und \fBrfc822\fP
unterstützt. \fBdpkg\fP ist das klassische Ausgabeformat (es existiert länger
als diese Option), das voreingestellt ist. Es besteht aus einem Absatz im
Debian\-Steuerformat (lesen Sie \fBdeb\-control\fP(5)). Falls mehr als ein
Eintrag angefordert wird, dann werden die meisten Felder aus dem ersten
Eintrag (normalerweise der neuste Eintrag) verwendet, falls dies nicht
anders angegeben wird:
.RS
.TP 
\fBSource:\fP\fI Paketname\fP
.TP 
\fBVersion:\fP\fI Version\fP
.TP 
\fBDistribution:\fP\fI Ziel\-Distribution\fP
.TP 
\fBUrgency:\fP\fI Dringlichkeit\fP
Die höchste Dringlichkeit aller enthaltenen Einträge wird verwandt, gefolgt
von den zusammengefügten (durch Leerzeichen getrennten) Kommentaren von
allen angeforderten Versionen.
.TP 
\fBMaintainer:\fP\fI Autor\fP
.TP 
\fBDate:\fP\fI Datum\fP
Das Datum des Eintrags als Zeichenkette, wie es im Changelog auftaucht. Mit
dem Format \fBstrptime\fP(3) »\fB%a, %d %b %Y %T %z\fP«, wobei der Wochentag nicht
dem echten Tag aus dem Rest der Datumszeichenkette entsprechen kann. Falls
Sie eine genauere Darstellung des Datums benötigen, verwenden Sie das Feld
\fBTimestamp\fP, beachten dabei aber, dass es nicht möglich sein könnte, es auf
den genauen Wert in diesem Feld abzubilden.
.TP 
\fBTimestamp:\fP\fI Zeitstempel\fP
Das Datum des Eintrags als Zeitstempel in Sekunden seit der Epoche (seit
Dpkg 1.18.8).
.TP 
\fBCloses:\fP\fI Fehlernummer\fP
Die Felder »Closes« aller enthaltenen Einträge werden zusammengefasst.
.TP 
\fBChanges:\fP\fI Changelog\-Einträge\fP
Der Text aller Changelog\-Einträge wird aneinandergehängt. Um aus diesem Feld
ein gültiges mehrzeiliges Feld im Debian Steuer\-Format zu bekomen, werden
leere Zeilen mit einem einzelnen Satzpunkt ersetzt und alle Zeilen durch ein
Leerzeichen eingerückt. Der genaue Inhalt hängt vom Changelog\-Format ab.
.RE
.IP
Die Felder \fBVersion\fP, \fBDistribution\fP, \fBUrgency\fP, \fBMaintainer\fP und
\fBChanges\fP sind verpflichtend.
.IP
Es können zusätzliche benutzerdefinierte Felder vorhanden sein.
.IP
Das \fBrfc822\fP\-Format verwendet die gleichen Felder, gibt aber einzelne
Absätze für jeden Changelog\-Eintrag aus, so dass alle Metadaten für jeden
Eintrag erhalten bleiben.
.TP 
\fB\-\-reverse\fP
füge alle Änderungen in umgekehrter Reihenfolge hinzu (seit Dpkg
1.19.1). Beachten Sie: Für das \fBdpkg\fP\-Format ist der erste Eintrag der
älteste Eintrag.
.TP 
\fB\-\-all\fP
alle Änderungen aufnehmen. Hinweis: Andere Optionen haben keine Wirkung,
wenn diese verwandt wird.
.TP 
\fB\-s\fP, \fB\-\-since\fP \fIVersion\fP
.TQ
\fB\-v\fP \fIVersion\fP
füge alle Änderungen neuer als aus \fIVersion\fP hinzu.
.TP 
\fB\-u\fP, \fB\-\-until\fP \fIVersion\fP
füge alle Änderungen älter als aus \fIVersion\fP hinzu.
.TP 
\fB\-f\fP, \fB\-\-from\fP \fIVersion\fP
füge alle Änderungen aus oder neuer als aus \fIVersion\fP hinzu.
.TP 
\fB\-t\fP, \fB\-\-to\fP \fIVersion\fP
füge alle Änderungen aus oder älter als aus \fIVersion\fP hinzu.
.TP 
\fB\-c\fP, \fB\-\-count\fP \fIAnzahl\fP
.TQ
\fB\-n\fP \fIAnzahl\fP
füge \fIAnzahl\fP Einträge vom Kopf (oder vom Fuß, falls \fIAnzahl\fP negativ ist)
hinzu.
.TP 
\fB\-o\fP, \fB\-\-offset\fP \fIZahl\fP
ändere den Startpunkt für \fB\-\-count\fP, gezählt vom Kopf (oder Fuß, falls
\fIZahl\fP negativ ist).
.
.SH CHANGELOG\-FORMATE
Es ist möglich, ein anderes als das Standardformat zu verwenden, indem ein
Auswerter für dieses alternative Format bereitgestellt wird.

Damit \fBdpkg\-parsechangelog\fP den neuen Auswerter ausführen kann, muss eine
Zeile innerhalb der letzten 40 Zeilen der Changelog\-Datei enthalten sein,
die auf den folgenden regulären Perl\-Ausdruck passt:
„\fB\eschangelog\-format:\es+([0\-9a\-z]+)\eW\fP“. Der Anteil in Klammern sollte
der Name des Formats sein, beispielsweise:

       @@@ changelog\-format: \fIAnderesformat\fP @@@

Changelog\-Formatnamen sind nichtleere kleine alphanumerische Zeichenketten
(„a\-z0\-9“).

Falls eine solche Zeile existiert, wird \fBdpkg\-parsechangelog\fP nach dem
Auswerter als Perl\-Modul \fBDpkg::Changelog::\fP\fIOtherformat\fP suchen. Es ist
ein Fehler, wenn dieser nicht vorhanden ist. Die Großschreibung des
Perl\-Moduls erfolgt automatisch. Das Standard\-Änderungsprotokollformat ist
\fBdebian\fP, hierfür wird standardmäßig ein Auswerter bereitgestellt.

Der Auswerter sollte von der Klasse Dpkg::Changelog abgeleitet sein und die
benötigte dokumentierte Schnittstelle implementieren.

Falls das geparste Changelog\-Format immer oder fast immer eine Leerzeile
zwischen einzelnen Änderungsnotizen lässt, sollten diese Leerzeilen
herausgefiltert werden, so dass die entstehende Ausgabe kompakt wird.

Falls das Changelog\-Format kein Datum oder keine Paketnamensinformationen
enthält, sollte diese Information in der Ausgabe unterbleiben. Der Auswerter
soll nicht versuchen, diese Daten künstlich zu ermitteln oder sie in anderen
Quellen zu finden.

Falls das Änderungsprotokoll nicht das erwartete Format hat, sollte sich der
Auswerter mit einem Fehler beenden, statt zu versuchen, sich irgendwie
durchzuwurschteln und möglicherweise eine falsche Ausgabe zu erzeugen.

Ein Changelog\-Auswerter darf nicht mit dem Benutzer interagieren.
.
.SH BEMERKUNGEN
Alle \fBAuswerter\-Optionen\fP außer \fB\-v\fP werden seit Dpkg 1.14.16 unterstützt.
.PP
Das Auswerten kurzer Optionen mit nicht gebündelten Werten ist nur seit
Dpkg\-Version 1.18.0 verfügbar.
.
.SH UMGEBUNG
.TP 
\fBDPKG_COLORS\fP
Setzt den Farbmodus (seit Dpkg 1.18.5). Die derzeit unterstützten Werte
sind: \fBauto\fP (Vorgabe), \fBalways\fP und \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Falls dies gesetzt ist, wird es zur Entscheidung, ob Native Language
Support, auch als Internationalisierung (oder i18n) Unterstützung bekannt,
aktiviert wird (seit Dpkg 1.19.0). Die akzeptierten Werte sind: \fB0\fP und
\fB1\fP (Vorgabe).
.
.SH DATEIEN
.TP 
\fBdebian/changelog\fP
Die changelog\-Datei wird verwendet, um versionsabhängige Informationen über
das Quellpaket, wie beispielsweise die Dringlichkeit (»urgency«) und die
Distribution des Uploads, die Änderungen seit einer bestimmten
Veröffentlichung und die Quellversionsnummer selbst zu erhalten.
.
.SH "SIEHE AUCH"
\fBdeb\-changelog\fP(5).
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2019 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
