/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */

#include <stdlib.h>
#include <stdio.h>

/* LCMAPS includes */

#include "lcmaps_plugins_basic_config.h"

#include <lcmaps/lcmaps_types.h>
#include <lcmaps/lcmaps_log.h>
#include <lcmaps/lcmaps_arguments.h>

#if defined(HAVE_LCMAPS_LCMAPS_PLUGIN_PROTOTYPES_H)
#   include <lcmaps/lcmaps_plugin_prototypes.h>
#else
#   include "lcmaps_plugin_prototypes.h"
#endif

#define DO_USRLOG           ((unsigned short)0x0001) /*!< flag to indicate that
                                      user logging has to be done \internal */
#define DO_SYSLOG           ((unsigned short)0x0002) /*!< flag to indicate that
                                      syslogging has to be done \internal */

int main()
{
    int argc;
    lcmaps_argument_t *args      = NULL;
    char              *init_argv[] = {"localaccount.mod","-gridmap", "/home/gridtest/cvs/fabric_mgt/gridification/lcmaps/modules/grid-security/grid-mapfile"};
    char              *user_dn   = "/O=dutchgrid/O=users/O=nikhef/CN=Oscar Koeroo";
/*    char              *user_dn   = "/O=dutchgrid/O=users/O=nikhef/CN=Martijn Steenbakkers";*/

    if (lcmaps_log_open(NULL,stdout,DO_USRLOG)) return 1;

    lcmaps_log_debug(0,"\n");
    lcmaps_log(LOG_NOTICE,"Initialization test\n");

    plugin_initialize(3, init_argv);
    plugin_introspect(&argc, &args);
    
    if (lcmaps_setArgValue("user_dn", "char *", (void *) &user_dn, argc, &args) != 0)
    {
        lcmaps_log(0,
               "lcmaps.mod-runPluginManager(): could not SET requested variable \"%s\" of type \"%s\" for plugin \"%s\"\n",
               "user_dn", "char *", "local");
        return 1;
    }
    plugin_run(argc,args);

    printCredData();
    if (cleanCredentialData()!=0)
    {
        lcmaps_log(0,"lcmaps.mod-stopPluginManager() error: could not clean credential data list\n");
        return 1;
    }
    plugin_terminate();
    return 0;
}
