; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN:   FileCheck %s

; These test cases aims to test the builtins for the Power10 VSX vector
; instructions introduced in ISA 3.1.

declare i32 @llvm.ppc.vsx.xvtlsbb(<16 x i8>, i1)

define signext i32 @test_vec_test_lsbb_all_ones(<16 x i8> %vuca) {
; CHECK-LABEL: test_vec_test_lsbb_all_ones:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvtlsbb cr0, v2
; CHECK-NEXT:    mfocrf r3, 128
; CHECK-NEXT:    srwi r3, r3, 31
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.vsx.xvtlsbb(<16 x i8> %vuca, i1 1)
  ret i32 %0
}

define signext i32 @test_vec_test_lsbb_all_zeros(<16 x i8> %vuca) {
; CHECK-LABEL: test_vec_test_lsbb_all_zeros:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvtlsbb cr0, v2
; CHECK-NEXT:    mfocrf r3, 128
; CHECK-NEXT:    rlwinm r3, r3, 3, 31, 31
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.vsx.xvtlsbb(<16 x i8> %vuca, i1 0)
  ret i32 %0
}
