# Stefan Achatz 2012
#
# Tries to find libgobject-2.0 and sets following variables according to found capabilities:
#
# GOBJECT2_FOUND
# GOBJECT2_INCLUDE_DIRS
# GOBJECT2_LIBRARIES

FIND_PACKAGE(PkgConfig)
PKG_CHECK_MODULES(PKG_GOBJECT2 gobject-2.0)

FIND_PATH(GOBJECT2_INCLUDE_DIRS gobject/gobject.h
  HINTS
    ${PKG_GOBJECT2_INCLUDE_DIRS}
    ${PKG_GOBJECT2_INCLUDEDIR}
  PATH_SUFFIXES glib-2.0
)

FIND_LIBRARY(GOBJECT2_LIBRARIES gobject-2.0
  HINTS ${PKG_GOBJECT2_LIBRARY_DIRS}
)

IF(GOBJECT2_LIBRARIES AND GOBJECT2_INCLUDE_DIRS)
  SET(GOBJECT2_FOUND true)
ENDIF()

IF(GOBJECT2_FIND_REQUIRED AND NOT GOBJECT2_FOUND)
  MESSAGE(FATAL_ERROR "Could not find GOBJECT2")
ENDIF()
