/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierControlPointHandle;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierNodeEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class BezierNodeHandle
extends AbstractHandle {
    protected int index;
    private CompositeEdit edit;
    private BezierPath.Node oldNode;
    private Figure transformOwner;

    public BezierNodeHandle(BezierFigure bezierFigure, int n) {
        this(bezierFigure, n, bezierFigure);
    }

    public BezierNodeHandle(BezierFigure bezierFigure, int n, Figure figure) {
        super(bezierFigure);
        this.index = n;
        this.transformOwner = figure;
        figure.addFigureListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.transformOwner.removeFigureListener(this);
        this.transformOwner = null;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Color color;
        Color color2;
        BezierFigure bezierFigure = this.getOwner();
        int n = bezierFigure.getNodeCount();
        boolean bl = bezierFigure.isClosed();
        if (this.getEditor().getTool().supportsHandleInteraction()) {
            color2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_NODE_HANDLE_FILL_COLOR);
            color = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_NODE_HANDLE_STROKE_COLOR);
        } else {
            color2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_NODE_HANDLE_FILL_COLOR_DISABLED);
            color = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_NODE_HANDLE_STROKE_COLOR_DISABLED);
        }
        if (n > this.index) {
            BezierPath.Node node = bezierFigure.getNode(this.index);
            if (node.mask == 0 || this.index == 0 && node.mask == 1 && !bl || this.index == n - 1 && node.mask == 2 && !bl) {
                this.drawRectangle(graphics2D, color2, color);
            } else if (node.mask == 1 || node.mask == 2 || this.index == 0 && !bl || this.index == n - 1 && !bl) {
                this.drawDiamond(graphics2D, color2, color);
            } else {
                this.drawCircle(graphics2D, color2, color);
            }
        }
    }

    @Override
    public BezierFigure getOwner() {
        return (BezierFigure)super.getOwner();
    }

    protected Point getLocation() {
        if (this.getOwner().getNodeCount() > this.index) {
            Point2D.Double double_ = this.getOwner().getPoint(this.index, 0);
            if (this.getTransformOwner().get(AttributeKeys.TRANSFORM) != null) {
                this.getTransformOwner().get(AttributeKeys.TRANSFORM).transform(double_, double_);
            }
            return this.view.drawingToView(double_);
        }
        return new Point(10, 10);
    }

    protected BezierPath.Node getBezierNode() {
        return this.getOwner().getNodeCount() > this.index ? this.getOwner().getNode(this.index) : null;
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle rectangle = new Rectangle(this.getLocation());
        int n = this.getHandlesize();
        rectangle.x -= n / 2;
        rectangle.y -= n / 2;
        rectangle.width = rectangle.height = n;
        return rectangle;
    }

    protected Figure getTransformOwner() {
        return this.transformOwner;
    }

    @Override
    public void trackStart(Point point, int n) {
        BezierFigure bezierFigure = this.getOwner();
        this.edit = new CompositeEdit("Punkt verschieben");
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
        Point2D.Double double_ = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(this.getLocation()));
        Point2D.Double double_2 = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(point));
        this.oldNode = bezierFigure.getNode(this.index);
        this.fireHandleRequestSecondaryHandles();
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
        BezierFigure bezierFigure = this.getOwner();
        bezierFigure.willChange();
        Point2D.Double double_ = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(point2));
        if (this.getTransformOwner().get(AttributeKeys.TRANSFORM) != null) {
            try {
                this.getTransformOwner().get(AttributeKeys.TRANSFORM).inverseTransform(double_, double_);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
        BezierPath.Node node = bezierFigure.getNode(this.index);
        node.moveTo(double_);
        bezierFigure.setNode(this.index, node);
        bezierFigure.changed();
    }

    private void fireAreaInvalidated(BezierPath.Node node) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(node.x[0], node.y[0], 0.0, 0.0);
        for (int i = 1; i < 3; ++i) {
            double_.add(node.x[i], node.y[i]);
        }
        Rectangle rectangle = this.view.drawingToView(double_);
        rectangle.grow(this.getHandlesize(), this.getHandlesize());
        this.fireAreaInvalidated(rectangle);
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
        BezierFigure bezierFigure = this.getOwner();
        BezierPath.Node node = (BezierPath.Node)this.oldNode.clone();
        BezierPath.Node node2 = bezierFigure.getNode(this.index);
        if ((n & 0x3C0) != 0 && (n & 8) == 0) {
            bezierFigure.willChange();
            node2.mask = this.index > 0 && this.index < bezierFigure.getNodeCount() || bezierFigure.isClosed() ? (node2.mask + 3) % 4 : (this.index == 0 ? ((node2.mask & 2) == 0 ? 2 : 0) : ((node2.mask & 1) == 0 ? 1 : 0));
            bezierFigure.setNode(this.index, node2);
            bezierFigure.changed();
            this.fireHandleRequestSecondaryHandles();
        }
        this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(bezierFigure, this.index, node, node2){

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                BezierNodeHandle.this.fireHandleRequestSecondaryHandles();
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                BezierNodeHandle.this.fireHandleRequestSecondaryHandles();
            }
        });
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
    }

    @Override
    public boolean isCombinableWith(Handle handle) {
        return false;
    }

    @Override
    public void trackDoubleClick(Point point, int n) {
        final BezierFigure bezierFigure = this.getOwner();
        if (bezierFigure.getNodeCount() > 2 && (n & 0x380) == 0) {
            Rectangle rectangle = this.getDrawingArea();
            bezierFigure.willChange();
            final BezierPath.Node node = bezierFigure.removeNode(this.index);
            bezierFigure.changed();
            this.fireHandleRequestRemove(rectangle);
            this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    return resourceBundleUtil.getString("edit.bezierPath.joinSegments.text");
                }

                @Override
                public void redo() throws CannotRedoException {
                    super.redo();
                    BezierNodeHandle.this.view.removeFromSelection(bezierFigure);
                    bezierFigure.willChange();
                    bezierFigure.removeNode(BezierNodeHandle.this.index);
                    bezierFigure.changed();
                    BezierNodeHandle.this.view.addToSelection(bezierFigure);
                }

                @Override
                public void undo() throws CannotUndoException {
                    super.undo();
                    BezierNodeHandle.this.view.removeFromSelection(bezierFigure);
                    bezierFigure.willChange();
                    bezierFigure.addNode(BezierNodeHandle.this.index, node);
                    bezierFigure.changed();
                    BezierNodeHandle.this.view.addToSelection(bezierFigure);
                }
            });
        }
    }

    @Override
    public Collection<Handle> createSecondaryHandles() {
        int n;
        BezierFigure bezierFigure = this.getOwner();
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        BezierPath.Node node = bezierFigure.getNode(this.index);
        if ((node.mask & 1) != 0 && (this.index != 0 || bezierFigure.isClosed())) {
            linkedList.add(new BezierControlPointHandle(bezierFigure, this.index, 1, this.getTransformOwner()));
        }
        if ((node.mask & 2) != 0 && (this.index < bezierFigure.getNodeCount() - 1 || bezierFigure.isClosed())) {
            linkedList.add(new BezierControlPointHandle(bezierFigure, this.index, 2, this.getTransformOwner()));
        }
        if (this.index > 0 || bezierFigure.isClosed()) {
            n = this.index == 0 ? bezierFigure.getNodeCount() - 1 : this.index - 1;
            node = bezierFigure.getNode(n);
            if ((node.mask & 2) != 0) {
                linkedList.add(new BezierControlPointHandle(bezierFigure, n, 2, this.getTransformOwner()));
            }
        }
        if (this.index < bezierFigure.getNodeCount() - 1 || bezierFigure.isClosed()) {
            n = this.index == bezierFigure.getNodeCount() - 1 ? 0 : this.index + 1;
            node = bezierFigure.getNode(n);
            if ((node.mask & 1) != 0) {
                linkedList.add(new BezierControlPointHandle(bezierFigure, n, 1, this.getTransformOwner()));
            }
        }
        return linkedList;
    }

    @Override
    public String getToolTipText(Point point) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        BezierPath.Node node = this.getBezierNode();
        return node == null ? null : resourceBundleUtil.getFormatted("handle.bezierNode.toolTipText", resourceBundleUtil.getFormatted(node.getMask() == 0 ? "handle.bezierNode.linear.value" : (node.getMask() == 3 ? "handle.bezierNode.cubic.value" : "handle.bezierNode.quadratic.value"), new Object[0]));
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        final BezierFigure bezierFigure = this.getOwner();
        this.oldNode = bezierFigure.getNode(this.index);
        switch (keyEvent.getKeyCode()) {
            case 38: {
                bezierFigure.willChange();
                bezierFigure.setPoint(this.index, new Point2D.Double(this.oldNode.x[0], this.oldNode.y[0] - 1.0));
                bezierFigure.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(bezierFigure, this.index, this.oldNode, bezierFigure.getNode(this.index)));
                keyEvent.consume();
                break;
            }
            case 40: {
                bezierFigure.willChange();
                bezierFigure.setPoint(this.index, new Point2D.Double(this.oldNode.x[0], this.oldNode.y[0] + 1.0));
                bezierFigure.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(bezierFigure, this.index, this.oldNode, bezierFigure.getNode(this.index)));
                keyEvent.consume();
                break;
            }
            case 37: {
                bezierFigure.willChange();
                bezierFigure.setPoint(this.index, new Point2D.Double(this.oldNode.x[0] - 1.0, this.oldNode.y[0]));
                bezierFigure.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(bezierFigure, this.index, this.oldNode, bezierFigure.getNode(this.index)));
                keyEvent.consume();
                break;
            }
            case 39: {
                bezierFigure.willChange();
                bezierFigure.setPoint(this.index, new Point2D.Double(this.oldNode.x[0] + 1.0, this.oldNode.y[0]));
                bezierFigure.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(bezierFigure, this.index, this.oldNode, bezierFigure.getNode(this.index)));
                keyEvent.consume();
                break;
            }
            case 8: 
            case 127: {
                Rectangle rectangle = this.getDrawingArea();
                bezierFigure.willChange();
                final BezierPath.Node node = bezierFigure.removeNode(this.index);
                bezierFigure.changed();
                this.fireHandleRequestRemove(rectangle);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                        return resourceBundleUtil.getString("edit.bezierPath.joinSegment.text");
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        BezierNodeHandle.this.view.removeFromSelection(bezierFigure);
                        bezierFigure.willChange();
                        bezierFigure.removeNode(BezierNodeHandle.this.index);
                        bezierFigure.changed();
                        BezierNodeHandle.this.view.addToSelection(bezierFigure);
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        BezierNodeHandle.this.view.removeFromSelection(bezierFigure);
                        bezierFigure.willChange();
                        bezierFigure.addNode(BezierNodeHandle.this.index, node);
                        bezierFigure.changed();
                        BezierNodeHandle.this.view.addToSelection(bezierFigure);
                    }
                });
                keyEvent.consume();
            }
        }
    }
}

