% !TeX root = genealogytree.tex
%% The LaTeX package genealogytree - version 1.31 (2018/04/17)
%% genealogytree.tex: Manual class file
%%
%% -------------------------------------------------------------------------------------------
%% Copyright (c) 2013-2016 by Prof. Dr. Dr. Thomas F. Sturm <thomas dot sturm at unibw dot de>
%% -------------------------------------------------------------------------------------------
%%
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   http://www.latex-project.org/lppl.txt
%% and version 1.3 or later is part of all distributions of LaTeX
%% version 2005/12/01 or later.
%%
%% This work has the LPPL maintenance status `author-maintained'.
%%
%% This work consists of all files listed in README
%%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{genealogytree.doc}[2018/04/17 version 1.31 auxiliary documentation class]
\def\version{1.31}%
\def\datum{2018/04/17}%
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
\ProcessOptions
\LoadClass{book}
\RequirePackage{doc}
\AtBeginDocument{\MakeShortVerb{\|}}

\RequirePackage[T1]{fontenc}
\RequirePackage[latin1]{inputenc}
\RequirePackage[english]{babel}
\RequirePackage{lmodern,parskip,array,ifthen,calc,varioref,varwidth,enumerate}
\RequirePackage[makeindex]{imakeidx}
\RequirePackage{amsmath,amssymb}
\RequirePackage[svgnames,table,hyperref]{xcolor}
\RequirePackage{tikz}
\RequirePackage[pdftex,bookmarks,raiselinks,pageanchor,hyperindex,colorlinks]{hyperref}

\RequirePackage[a4paper,left=2.5cm,right=2.5cm,top=1.5cm,bottom=1.5cm,
    marginparsep=3mm,marginparwidth=18mm,
    headheight=0mm,headsep=0cm,
    footskip=1.5cm,includeheadfoot]{geometry}
\RequirePackage{fancyhdr}
\fancyhf{}
\fancyfoot[C]{\thepage}%
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}
\pagestyle{fancy}
\tolerance=2000%
\setlength{\emergencystretch}{20pt}%

\usetikzlibrary{shadings,shadows}
\usetikzlibrary{decorations.pathmorphing}
\usetikzlibrary{decorations.pathreplacing}
\usetikzlibrary{patterns}
\usetikzlibrary{backgrounds}
\usetikzlibrary{spy}

\RequirePackage{array,tabularx}
\RequirePackage{amsmath}
\RequirePackage{lipsum}

\RequirePackage{changepage,booktabs,incgraph}
\strictpagecheck

\definecolor{link}{rgb}{0.423529, 0.184314, 0.541176}


\RequirePackage[most,documentation]{tcolorbox}
\tcbset{skin=enhanced,
  doc head={colback=yellow!10!white,interior style=fill},
  doc head key={colback=magenta!5!white,interior style=fill},
  color key=DarkViolet,
  color value=Teal,
  color color=Teal,
  color hyperlink=link,
  index colorize,index annotate}

\urlstyle{sf}

\RequirePackage{cleveref}

\lstdefinestyle{mydocumentation}{style=tcbdocumentation,
  classoffset=0,
  texcsstyle=*\color{blue},
  commentstyle=\color{black!60!yellow}\itshape,
  % LaTeX and other packages
  moretexcs={arrayrulecolor,draw,includegraphics,ifthenelse,isodd,lipsum,path,pgfkeysalso,tikzset},
  classoffset=1,
  % genealogytree macros
  moretexcs={%
    gtrset,gtredgeset,genealogytree,gtrsetoptionfor,gtrparserdebug,gtrparserdebuginput,
    genealogytreeinput,gtrifnodeid,
    gtrprocessordebug,gtrprocessordebuginput,gtrdebugdrawcontour,gtrlistseparator,
    gtrSymbolsFullLegend,gtrSymbolsLegend,gtrSymbolsRecordReset,gtrSymbolsSetCreate,
    gtrSymbolsSetDraw,gtrsymBorn,gtrsymBornoutofwedlock,gtrsymDiedonbirthday,
    gtrsymBaptized,gtrsymEngaged,gtrsymMarried,gtrsymDivorced,gtrsymPartnership,
    gtrsymFloruit,
    gtrsymDied,gtrsymKilled,gtrsymBuried,gtrsymFuneralurn,gtrloadlanguage,
    gtrsymMale,gtrsymFemale,gtrsymNeuter,gtrSymbolsSetCreateSelected,
    gtrsetoptionsfornode,gtrsetoptionsforfamily,gtrsetoptionsforsubtree,
    gtrignoresubtree,gtrignorenode,gtruselibrary,
    gtrlanguagename,gtrBoxContent,gtrifimagedefined,
    pref,surn,nick,
    gtrParseDate,gtrPrintDate,gtrifdatedefined,gtrPrintPlace,gtrifplacedefined,
    gtrifcommentdefined,gtrifprofessiondefined,gtrDeclareDatabaseFormat,
    gtrPrintEvent,gtrifeventdefined,gtrPrintEventPrefix,gtrPrintName,gtrPrintComment,
    gtrPrintProfession,gtrPrintSex,
    gtrnodenumber,gtrnodetype,gtrnodeid,gtrnodefamily,gtrnodelevel,
    gtrnewstack,gtrmakestack,gtrstacksize,gtrstackpush,gtrstackpop,
    gtrstackpopto,gtrstackpeek,gtrstackpeekto,
    gtrDBsex,gtrDBimage,gtrDrawSymbolicPortrait,
    gtrifgnode,gtrifcnode,gtrifpnode,gtrifroot,gtrifleaf,gtrifchild,
    gtrifparent,gtrifleafchild,gtrifleafparent,gtrincludeDBimage
    },
  texcsstyle=*\color{Definition}\bfseries,
  classoffset=0% restore default
  }

\tcbset{%
  documentation listing style=mydocumentation,%
  sbs/.style={%
    sidebyside,
    before lower app={\tcbset{sidebyside=false}}
  },%
  beforeafter example/.style={
    before skip=6pt plus 2pt minus 2pt,
    after skip=6pt plus 2pt minus 2pt
  },
  docexample/.style={%
    bicolor,beforeafter example,
    colframe=gtr_Yellow_Frame,
    colback=gtr_Yellow_Back,
    coltitle=gtr_Yellow_Frame!40!black,
    fonttitle=\bfseries\sffamily,
    interior style={top color=gtr_Yellow_Back!50,bottom color=gtr_Yellow_Back!90!gtr_Yellow_Frame},
    colbacklower=white,
    attach boxed title to top center={yshift=-2mm},
    boxed title style={colback=gtr_Yellow_Back}
    },
}

\newtcbexternalizetcolorbox{exdispExample}{dispExample}{minipage}{beforeafter example}

\newtcbexternalizetcolorbox{exdispExample*}{dispExample*}{minipage}{beforeafter example}

\tcbmakedocSubKey{docGtrKey}{gtr}
\tcbmakedocSubKey{dataGtrKey}{gtr/database}
\tcbmakedocSubKey{edgeGtrKey}{gtr/edge}
\tcbmakedocSubKey{debugGtrKey}{gtr/debug}
\tcbmakedocSubKey{symlangGtrKey}{gtr/symlang}
\tcbmakedocSubKey{evpreGtrKey}{gtr/event prefix}

\tcbmakedocSubKey{docTcbKey}{tcb}
\tcbmakedocSubKey{docTikzKey}{tikz}

\tcbset{
  color grammar/.store in=\kvtcb@col@grammar,
  doclang/grammar/.store in=\kvtcb@text@grammar,
  doclang/grammars/.store in=\kvtcb@text@grammars,
  color grammar=gtr_Bright_Red,
  doclang/grammar=grammar,
  doclang/grammars=Grammar,
}

\newrobustcmd{\tcbIndexPrintGrammarCA}[1]{\tcb@Index@Print@CA{#1}{\kvtcb@col@grammar}{\kvtcb@text@grammar}}
\newrobustcmd{\tcbIndexPrintGrammarC}[1]{\tcb@Index@Print@C{#1}{\kvtcb@col@grammar}}
\def\tcb@Print@Grammar#1{\textcolor{\kvtcb@col@grammar}{\bfseries\tcb@scantokens{#1}}}
\def\tcb@index@Grammar#1{\iftcb@doc@toindex\kvtcb@index@command{#1\idx@actual\tcbIndexPrintGrammarCA{#1}}\kvtcb@index@command{\kvtcb@text@grammars\idx@level#1\idx@actual\tcbIndexPrintGrammarC{#1}}\fi}


\DeclareDocumentCommand\docGrammar{sm}{%
  \tcb@Print@Grammar{#2}%
  \IfBooleanTF{#1}{}{\tcb@index@Grammar{#2}}%
}

\newtcolorbox{picturebox}[1][]{%
  docexample,interior style={fill=white},tikz upper,#1
}

\newtcbexternalizetcolorbox{expicturebox}{picturebox}{minipage}{beforeafter example}


\newtcolorbox{syntax}[2][]{title={#2},enhanced,drop fuzzy shadow,
  colback=red!5!white,colframe=red!75!black,colbacktitle=red!90!black,
  fonttitle=\bfseries,fontupper=\ttfamily,
  before upper=\begin{tabbing}pa\=\hspace*{8cm}\=\kill,after upper=\end{tabbing},#1}

\newtcolorbox{headingbox}[1][]{%
  enhanced,before=\clearpage,after skip=10mm,enlarge top by=5mm,
  center,
  halign=center,width=10cm,boxrule=0.4pt,
  colupper=gtr_Blue_1,
  colback=white,colframe=gtr_Blue_4,drop fuzzy midday shadow=gtr_Blue_3,#1}

\newcommand{\syncomment}[1]{\textcolor{blue}{\textrm{\itshape#1}}}

\newcommand{\TODO}{\tcbox[capture=minipage,halign=center,colframe=red!75!black,colback=red!10!white,
  beforeafter skip=6pt,fontupper=\bfseries]{!!! TODO !!!}}

\tcbset{%
  savefile/.style={tempfile={#1},
    fonttitle=\bfseries,title=File \flqq\texttt{\detokenize{#1}}\frqq},
  }

\tcbset{index format=pgfchapter}

\def\tikzname{Ti\emph{k}Z}

\RequirePackage{titlesec}


\titleformat{\chapter}[display]%
  {\begin{tcolorbox}[enhanced,sharp corners,nobeforeafter,
    oversize=4cm,interior style={top color=gtr_Blue_6,bottom color=gtr_Blue_5},
    halign=center,fontupper=\normalfont\sffamily\huge\bfseries,
    colupper=gtr_Blue_1,colback=gtr_Blue_6,colframe=gtr_Blue_2]}
  {\bigskip\normalfont\sffamily\Huge\fontsize{60pt}{60pt}\bfseries\color{gtr_Blue_2}\thechapter}{1ex}
  {}[\end{tcolorbox}]

\titleformat{\section}
  {\normalfont\sffamily\Large\bfseries\color{gtr_Blue_2}}{\thesection}{1em}{}
\titleformat{\subsection}
  {\normalfont\sffamily\large\bfseries\color{gtr_Blue_3}}{\thesubsection}{1em}{}
\titleformat{\subsubsection}
  {\normalfont\normalsize\bfseries\color{gtr_Blue_3}}{\thesubsubsection}{1em}{}
\titleformat{\paragraph}[runin]
  {\normalfont\normalsize\bfseries\color{gtr_Blue_3}}{\theparagraph}{1em}{}
\titleformat{\subparagraph}[runin]
  {\normalfont\normalsize\bfseries\color{gtr_Blue_3}}{\thesubparagraph}{1em}{}

\titlespacing*{\chapter}{0pt}{0pt}{40pt}
\titlespacing*{\section}{0pt}{3.5ex plus 1ex minus .2ex}{2.3ex plus .2ex}
\titlespacing*{\subsection}{0pt}{3.25ex plus 1ex minus .2ex}{1.5ex plus .2ex}
\titlespacing*{\subsubsection}{0pt}{3.25ex plus 1ex minus .2ex}{1.5ex plus .2ex}
\titlespacing*{\paragraph}{0pt}{3.25ex plus 1ex minus .2ex}{1em}
\titlespacing*{\subparagraph}{\parindent}{3.25ex plus 1ex minus .2ex}{1em}

\newtcbox{\mylib}{enhanced,nobeforeafter,tcbox raise base,boxrule=0.4pt,top=0mm,bottom=0mm,
  right=0mm,left=4mm,arc=1pt,boxsep=2pt,before upper={\vphantom{dlg}},
  colframe=gtr_Blue_1,coltext=gtr_Blue_1,colback=gtr_Blue_6,
  overlay={\begin{tcbclipinterior}\fill[gtr_Blue_3] (frame.south west)
    rectangle node[text=white,font=\sffamily\bfseries\tiny,rotate=90] {LIB} ([xshift=4mm]frame.north west);\end{tcbclipinterior}}}

\robustify{\mylib}

\pdfstringdefDisableCommands{%
  \def\mylib#1{'#1'}%
}

\usepackage{genealogytree}

\gtruselibrary{all}
\gtrloadlanguage{german}

\newtcbexternalizetcolorbox{extcblisting}{tcblisting}{}{beforeafter example}

\def\myinclude#1{\include{genealogytree.doc.#1}}

\def\myincludeonly#1{%
  \def\myincludelist{}%
  \def\do##1{\gtrkeysappto\myincludelist{genealogytree.doc.##1}}%
  \docsvlist{#1}%
  \begingroup\edef\x{\endgroup\noexpand\includeonly{\myincludelist}}%
  \x%
}

\renewcommand*\l@section{\@dottedtocline{1}{1.5em}{2.6em}}
\renewcommand*\l@subsection{\@dottedtocline{2}{4.1em}{3.2em}}
\renewcommand*\l@subsubsection{\@dottedtocline{3}{7.3em}{4.1em}}

\renewcommand*{\tcbdocnew}[1]{\sffamily\textcolor{green!50!black}{\bfseries N} #1}
\renewcommand*{\tcbdocupdated}[1]{\sffamily\textcolor{blue!75!black}{\bfseries U} #1}

\hyphenation{
  Stein-hauers-toch-ter
}
