/* commtree.c -- Handle the command trees.
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "tua.h"

#define	TNULL	(Tcommrep_t) NULL

static int
DEFUN (command_compare, (comm1, comm2),
       CONST command_rec_t * comm1 AND
       CONST command_rec_t * comm2)
{
  int ret = strcasecmp (comm1->Command, comm2->Command);

  return ret;
}

static PTR
DEFUN (command_new, (data),
       CONST PTR data)
{
  command_rec_t * cr;
  
  cr = (command_rec_t *) xmalloc (sizeof (command_rec_t));
  cr->Command = savestring (((CONST command_rec_t *) data)->Command);
  cr->Number = 0;
  
  return (PTR) cr;
}

command_rec_t *
DEFUN (insert_command, (treep, comm),
       BTREE * treep AND
       CONST char *comm)
{
  command_rec_t cr;
  
  if (*treep == NULL)
    *treep = btree_new ((compare_func_t) command_compare, (makenew_func_t) command_new);

  cr.Command = (char *) comm;
  return (command_rec_t *) btree_insert (*treep, &cr);
}

void
DEFUN (enquire_commands, (tree, funct),
       BTREE tree AND
       traverse_func_t funct)
{
  btree_traverse (tree, funct);
}
