;;;
;;; Copyright (c) 2003-2013 uim Project https://github.com/uim/uim
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

;;; tutcode.scm: TUT-Code for Japanese input.
;;;
;;; TUT-Code<http://www.crew.sfc.keio.ac.jp/~chk/>ϥץȡ
;;; TUT-CodeܸϤԤ
;;; TUT-CodeʳT-CodeTry-CodeϤ⡢ɽˤǽ
;;;
;;; Ѵ(ala)
;;;   ƵŪѴǽǤ
;;;   Υ르ꥺϰʲ3ĤǽǤ
;;;     - tc-2.1+[tcode-ml:1925]
;;;     - ľWin YAMANOBE
;;;     - tc-2.3.1-22.6 (ŪѴƱѤΤǡ
;;;                      bushu.index2bushu.expandե꤬ɬ)
;;;
;;; * ŪѴ
;;;   tc-2.3.1tc-bushu.elΰܿǤ(sortǤǤ䤹ιθ̤б)
;;;   ʲΤ褦򤹤ȻѲǽˤʤޤ
;;;   (define tutcode-use-interactive-bushu-conversion? #t)
;;;   (define tutcode-bushu-index2-filename "/usr/local/share/tc/bushu.index2")
;;;   (define tutcode-bushu-expand-filename "/usr/local/share/tc/bushu.expand")
;;;   (define tutcode-interactive-bushu-start-sequence "als")
;;;   bushu.index2bushu.expandեϡ
;;;   tc-2.3.1Υ󥹥ȡ󥹥ȡ뤵եǤ
;;;
;;; ڸ򤼽Ѵ(alj)
;;;   򤼽Ѵtc2Ʊ(SKKƱͤη)Ǥ
;;; 
;;; * 򤼽Ѵ(:/usr/local/share/tc/mazegaki.dic)ؤΥ
;;;   libuim-skk.soεǽȤäƤޤ
;;;   ΤᡢؽǽSKKƱͤưˤʤޤ:
;;;     + ꤷϼѴƬޤ
;;;       tc2ƱͤˡƬĤθѤʤϡ
;;;       tutcode-mazegaki-fixed-priority-countˤθĿꤷƤ
;;;     + ꤷϸĿͼ(~/.mazegaki.dic)¸ޤ
;;;   γؽǽ򥪥դˤˤϡ
;;;   tutcode-enable-mazegaki-learning?ѿ#fꤷƤ
;;; ** 򤼽ѴؤϿSKKƱͤưˤʤޤ:
;;;     + ~/.mazegaki.dicؤϿ
;;;     + Ͽ: ѴκǸޤǹԤäƵŪϿ⡼ɤ˰ܹԡ
;;;             뤤ϡɤߤϸ塢|򲡤
;;;     + : 񤫤κϡ!򲡤
;;; 
;;; * ѤѴ
;;;   tutcode-mazegaki-enable-inflection?ѿ#tꤹȡѤʤ
;;;   ȤƤѴ䤬ĤʤäˡѤȤѴߤޤ
;;;   (Ѥʤθ䤬1ĤξμưϤʤʤޤ
;;;    ʸϤ򳫻Ϥгꤵޤ)
;;;   ޤǽ餫ѤȤѴϡɤߤ""դ뤫
;;;   ʲΥѴϤƤ
;;;     tutcode-postfix-mazegaki-inflection-start-sequence (ַѥή)
;;;
;;;   ɽϡ<>ˤꡢ촴(Ѹʳʬ)ο̤ǽǤ
;;;   (ɤߤϻ""դƸ촴)
;;;
;;; * ɤߤ򥫥ʤȤƳ
;;;   tutcode-katakana-commit-key˥ʳꥭꤹ
;;;   Ѳǽˤʤޤ
;;;
;;; * ѻѴ(SKK abbrev)⡼ɤɲäƤޤ(al/)
;;;   㤨СfileפϤơ֥եפѴ뵡ǽǤ
;;;
;;; ڸַѴ
;;;   uimsurrounding textطAPI(text acquisition API)Ȥäơ
;;;   ʸμԤޤ
;;;   Τᡢuimsurrounding text API򥵥ݡȤƤ֥å
;;;   (uim-gtk, uim-qt3, uim-qt4)ǤΤ߸ַѴǽǤ
;;;
;;;   ʳΥ֥åǤַѴȤ硢
;;;   tutcode-enable-fallback-surrounding-text?#tꤹȡ
;;;   surrounding text APIѤǤʤˡ
;;;   ʸμγʸХåեԤ
;;;   ʸκ"\b"(tutcode-fallback-backspace-string)Фޤ
;;;     - \b(BS,0x08)ʸ˺ԤץǤΤư
;;;     - γʸХåե䴰ȷѤǡ
;;;       Ĺtutcode-completion-chars-max͡
;;;
;;; * ַѴϡϥtutcode-postfix-bushu-start-sequence
;;;   ꤹȻѲǽˤʤޤ
;;; * ַ򤼽ѴϡʲγϥꤹȻѲǽˤʤޤ
;;;  Ѥʤ tutcode-postfix-mazegaki-start-sequence
;;;  Ѥ   tutcode-postfix-mazegaki-inflection-start-sequence
;;;  Ѥʤ(ɤ1ʸ) tutcode-postfix-mazegaki-1-start-sequence
;;;   ...
;;;  Ѥʤ(ɤ9ʸ) tutcode-postfix-mazegaki-9-start-sequence
;;;  Ѥ(ɤ1ʸ) tutcode-postfix-mazegaki-inflection-1-start-sequence
;;;   ...
;;;  Ѥ(ɤ9ʸ) tutcode-postfix-mazegaki-inflection-9-start-sequence
;;; * ַ򤼽Ѵˤ롢ɤ/촴ο
;;;   ɽϡ<>ˤꡢɤ/촴ο̤ǽǤ
;;;   Ѥ˴ؤƤϡ촴ĹΤͥ褷Ѵޤ
;;;     :֤>֤>֤
;;;         (tutcode-mazegaki-enable-inflection?#tξ硢
;;;          ˽̤ȳѤȤѴ)
;;;        >֤>֤>֤>֤>֤>֤
;;;        (ºݤˤtc2°mazegaki.dicˡ֤פ̵Τǥå)
;;; ** ɤߤʸꤷѴϤ
;;;    Ѥ˴ؤƤϡɤߤϻꤵ줿ʸǸꤷƸ촴Τ߿̡
;;;      (֤פФ3ʸ):֤>֤>֤
;;; * ַѴϡʲγϥꤹȻѲǽˤʤޤ
;;;  оݿ̥⡼   tutcode-postfix-katakana-start-sequence
;;;    Ѵоݤʸ򤹤⡼ɤ򳫻(ַ򤼽ѴƱ)
;;;  Ҥ餬ʤ³ tutcode-postfix-katakana-0-start-sequence
;;;    Ҥ餬ʤ֡פ³оʸȤơʤִ
;;;  о1ʸ        tutcode-postfix-katakana-1-start-sequence
;;;   ...
;;;  о9ʸ        tutcode-postfix-katakana-9-start-sequence
;;;    ʸ򥫥ʤִ
;;;  1ʸִ  tutcode-postfix-katakana-exclude-1-sequence
;;;   ...
;;;  6ʸִ  tutcode-postfix-katakana-exclude-6-sequence
;;;    ʸҤ餬ʤȤƻĤƥʤִ
;;;    (ʤѴʸĹʸΤݤʾ)
;;;    :㤨Фפꤱ2ʸִ㤨Хץꥱ
;;;  1ʸ̤      tutcode-postfix-katakana-shrink-1-sequence
;;;   ...
;;;  6ʸ̤      tutcode-postfix-katakana-shrink-6-sequence
;;;    ľθַѴʸ̤ޤ֤¹Բǽ
;;;    :㤨ФפꤱפҤ餬ʤ³ִ
;;;     㥨Хץꥱ1ʸ̤
;;;     㤨Хץꥱ1ʸ̤
;;;     㤨Хץꥱ
;;; * ַϥѴ
;;;   TUT-Code󡦥դΥ⡼ڤؤʤǱñϤơ
;;;   夫ѻ뤿εǽǤ
;;;   tutcode-keep-illegal-sequence?#tꤷǡ
;;;   ñϸˡtutcode-verbose-stroke-key(ǥեȤϥڡ)
;;;   Ǹ뤳Ȥǥ󥹤üˡʲγϥϤƲ
;;;   (ѴˡǸtutcode-verbose-stroke-keyϼưޤ)
;;;   :"undo "Ǹ""ɽ졢ʲγϥǡ"undo"Ѵ
;;;               tutcode-postfix-kanji2seq-start-sequence
;;;     1ʸ tutcode-postfix-kanji2seq-1-start-sequence
;;;      ...
;;;     9ʸ tutcode-postfix-kanji2seq-9-start-sequence
;;;   ʸꤷʤ硢<>ˤꡢο̤ǽǤ
;;;   ʸꤷʤ硢ñ˥ڡϤƤȡ
;;;   ڡʸѻѴޤ
;;;   ΤȤñζڤΤϤڡưˤϡ
;;;   tutcode-delete-leading-delimiter-on-postfix-kanji2seq?
;;;   #tꤷƤ
;;;   :" code "Ǹ"  "ɽ졢ϥǡ"code"Ѵ
;;;   ʤʸʤξǤ⡢ʤǱѻִС
;;;   ~/.uim˰ʲ򵭽(ϥ";0"ˤ):
;;;   (tutcode-rule-set-sequences!
;;;     `((((";" "0"))
;;;         (,(lambda (state pc)
;;;           (tutcode-begin-postfix-kanji2seq-conversion pc 0))))))
;;;   :ñַ򤼽ѴϤʤɤεǽФ륷󥹤
;;;      ޤޤƤȡ뵡ǽ¹ԤƤޤޤ
;;;      ǤϡεǽФ륷󥹤
;;;      ñǤϽиʤ󥹤ѹ뤳Ȥǲ򤷤Ƥ
;;;      :"/local/"ǤĤ""θ"al/"ˤַѻѴ⡼ɤ
;;;         (ʤ"local/"ξ"Ŭ"ʤΤʤ)
;;; * ַϥ󥹢Ѵ
;;;   TUT-Codeˤ˺TUT-CodeϤ˸夫Ѵ뤿
;;;   ǽǤ
;;;           tutcode-postfix-seq2kanji-start-sequence
;;;     1ʸ tutcode-postfix-seq2kanji-1-start-sequence
;;;      ...
;;;     9ʸ tutcode-postfix-seq2kanji-9-start-sequence
;;;   ַ򤼽ѴɤϤʤɡꤵƤʤϤϾäޤ
;;;   :"aljekri"Ѵ"""ekri"Ѵ""
;;;      "aljekri \n"Τ褦˳ꤵƤ碪""
;;;
;;; selectionФѴ
;;;   uimsurrounding textطAPI(text acquisition API)Ȥäơ
;;;   selectionʸμԤޤ
;;; * 򤼽Ѵ
;;;     Ѥʤ  tutcode-selection-mazegaki-start-sequence
;;;     Ѥ    tutcode-selection-mazegaki-inflection-start-sequence
;;; * Ѵ    tutcode-selection-katakana-start-sequence
;;; * ϥѴ  tutcode-selection-kanji2seq-start-sequence
;;; * ϥ󥹢Ѵ  tutcode-selection-seq2kanji-start-sequence
;;;
;;; ڥإ׵ǽ
;;; * ۸ɽ(ɽθ䥦ɥή)
;;;   ư֤ΥǸˤϤʸɽޤ
;;;   uim-pref-gtkǤɽɽ¾ˡ
;;;   <Control>/ǰŪɽɽڤؤǽǤ
;;;   (ǤդʸϤȤɽ礬Τ)
;;;  - *դʸ:Ǹˤꡢ
;;;    ʸޤಾ۸פɽ뤳Ȥɽޤ(Ǹ)
;;;  - +դʸ:ʸǸǤ뤳Ȥɽޤ
;;;    (ϸ쥬ɤǸ)
;;;  - +׸դʸ:ϸ쥬ɤκǽǸǤ뤳Ȥɽޤ
;;; * ưإɽǽ(ɽθ䥦ɥή)
;;;   򤼽ѴѴϤʸǤɽޤ
;;;   ˡΥإפϡbushu.helpե뤬ꤵƤ
;;;   ʬõɽޤbushu.help˸ĤʤǤ⡢
;;;   ñ˴ؤƤɽǽǤ
;;;   :򤼽Ѵǡͫݵפꤷ
;;;    
;;;                                        
;;;      
;;;            b                   f       
;;;      
;;;      3                         1(ͫ)   
;;;      
;;;        d   e   2a(ݵӴ)            
;;;    
;;; * ʸإɽǽ(tutcode-help-sequence)
;;;   ľʸΥإ(Ǥ)ɽޤ
;;;   (uimsurrounding text APIȤäƥľʸ)
;;; * ľɽ(ư)إפκɽ(tutcode-auto-help-redisplay-sequence)
;;; * ľɽ(ư)إפΥ(tutcode-auto-help-dump-sequence)
;;;   䥦ɥɽإƤʲΤ褦ʸˤcommitޤ
;;;   ((:"Ӵ")򥳥ԡơǥåץܡɤ
;;;    ַѴpreeditإڡȤѴ)
;;;       |  |  |  |  ||            |  |  |     |  ||
;;;       |  |  |  | b||            |  |  |  f  |  ||
;;;       | 3|  |  |  ||            |  |  |1(ͫ)|  ||
;;;       |  | d|  | e||2a(ݵӴ)|  |  |     |  ||
;;;
;;; 䴰/ͽ¬ϡϸ쥬ɡ
;;; +䴰:ʸФơ³ʸθɽޤ
;;; +ͽ¬ϡ:򤼽ѴɤߤФơѴʸθɽޤ
;;; +ֽϸ쥬ɡ:䴰/ͽ¬ϸʸȤˡ
;;;   Ϥͽ¬ʸǸɤɽޤ('+'դɽ)
;;; * 䴰/ͽ¬ϡϸ쥬ɤȤ䥦ɥɽޤ
;;; * 䴰/ͽ¬ϵǽȤˤϡ
;;;   uim-pref-gtkΡͽ¬ϡץ롼פ꤬ɬפǤ
;;;     (a)Look-SKKͭˤmazegaki.dicμեꤹ롣
;;;        (ͽ¬)
;;;     (b)Lookͭˤñեꤹ롣(䴰)
;;;        mazegaki.dicɤߤˡȤƤäƤʤñ䴰硣
;;;        (:ֶפϤǡۡפ䴰ߤ
;;;         ֶۡפmazegaki.dicˤɤߤȤƤäƤʤΤǡ
;;;         (a)Ǥ䴰ʤ((a)ɤߤ򸡺Τ))
;;;         mazegaki.dicѴñȴФơ
;;;         䴰ñեˤϡʲΥޥɤǲǽ
;;;           awk -F'[ /]' '{for(i=3;i<=NF;i++)if(length($i)>2)print $i}' \
;;;           mazegaki.dic | sort -u > mazegaki.words
;;;     (c)Sqlite3ͭˤ롣
;;;        䴰/ͽ¬Ϥ򤷤ؽ硢־֡
;;;   ʬõΤǡ(a)(b)ΥեϥȤƤɬפޤ
;;; * 䴰/ͽ¬ϤγϤϰʲΤ줫Υߥ:
;;; ** 䴰: tutcodeξ֤tutcode-completion-chars-minʸϻ
;;; ** 䴰: tutcodeξ֤<Control>.Ǹ
;;; ** ͽ¬: 򤼽ѴɤϾ֤
;;;              tutcode-prediction-start-char-countʸϻ
;;; ** ͽ¬: 򤼽ѴɤϾ֤<Control>.Ǹ
;;; * 䴰ɽˤ<Control>.Ǹоʸ1ĸ餷ƺ䴰
;;;   Ĺʸоݤ䴰줿ˡ䴰ľǤ褦ˡ
;;; * 嵭䴰ʸ(tutcode-completion-chars-min)
;;;   ͽ¬ʸ(tutcode-prediction-start-char-count)0ꤹȡ
;;;   <Control>.ǸˤΤ䴰/ͽ¬ϸɽޤ
;;; * ϸ쥬(Ϥͽ¬ʸǸ)
;;;   䴰/ͽ¬ϸ䤫äƤޤ
;;; * ۸׾Ǥνϸ쥬ɽ
;;;   ϸ쥬ɤɽƤ+դʸб륭Ϥ硢
;;;   2ǸܰʹߤⲾ۸׾+դɽΤǡ
;;;   ɤ˽äƴϤǽǤ
;;;   ̾ϲ۸ɽξǤ⡢+դʸб륭Ϥ硢
;;;   Ū˲۸פɽˤϡ
;;;   tutcode-stroke-help-with-kanji-combination-guide'full(+դʳ
;;;   ʸɽ)'guide-only(+դʸΤɽ)ꤷƤ
;;;     :ֲгפϤ褦ȤơֲСפϸֳפǤ
;;;        ˺줷硢<Control>.䴰ϸ쥬ɤ+դΡֳפ
;;;        ɽ˽ä1,2,3Ǹϡ
;;;
;;; * ǸФ餯̵䴰/ͽ¬ϸɽˤϡ
;;;   䥦ɥٱɽбƤСʲǲǽǤ
;;;     tutcode-candidate-window-use-delay?#tꤷ
;;;     tutcode-candidate-window-activate-delay-for-{completion,prediction}
;;;     ͤ1[]ʾꡣ
;;;
;;; Ѵͽ¬ϡ
;;;   Ѵ򸡺ơϤ줿󤬴ޤޤܤɽ
;;;
;;; ڵϥ⡼ɡ
;;;   <Control>_ǵϥ⡼ɤΥȥ롣
;;;   ѱѿϥ⡼ɤȤƤȤ褦ˤƤޤ
;;;
;;; 2ȥϥ⡼ɡ
;;;   ɴ기סؤ٤Ʊͤˡ2ǸǳƼε桦Ϥ⡼ɡ
;;;   ϴŪʸɽ¤Ǥޤ
;;;   (̾εϥ⡼ɤǤϡŪʸޤǤɤĤ
;;;   next-page򲿲ⲡɬפäݤʤΤ)
;;;
;;; ڴϥ⡼ɡ
;;;   ɤꤷʸϤ⡼ɡϸ她ڡ
;;;   (tutcode-begin-conv-key)򲡤ȡбʸꤵޤ
;;;   ʲ3ηǤϤǽ(DDSKK 14.2Ʊ)
;;; + Unicode(UCS): U+θ16ʿU+ΤuǤOK(:U+4E85ޤu4e85)
;;;                 (uim-tutcodeɤEUC-JP(EUC-JIS-2004)ʤ
;;;                  ǡJIS X 0213̵ʸ(:ϤU+9AD9)Բ)
;;; + ֹ(JIS X 0213): -Ƕڤä--ֹ(̶줾10ʿ)
;;;                         1̤ξ硢-Ͼάǽ(:1-48-13ޤ48-13)
;;; + JIS(ISO-2022-JP): 416ʿ(:502d)
;;;
;;; ڥҥȥϥ⡼ɡ
;;;   ǶѴ򤼽Ѵ䴰/ͽ¬ϡϡ
;;;   ϤǳꤷʸϤ⡼ɡ
;;;   tutcode-history-size1ʾꤹͭˤʤޤ
;;;
;;; ڳä
;;;   ľγäޤ(tutcode-undo-sequence)
;;;   ʲѴǤϡѴ˳ꤵʸǧ뵡̵
;;;   ԤΤǡտޤʤ˳ꤵ뤳Ȥޤ
;;;   ξˡǽ餫Ϥľפ뤿εǽǤ
;;;   (ʸ뤿ᡢuimsurrounding text APIȤޤ)
;;;   + Ѵ: 2ʸܤϤˤѴ곫(ä˺ƵŪʾ)
;;;   + 
;;;   + 򤼽Ѵ: 1Ĥλμư
;;;   + ɤϻΥʳꡢϥ󥹳
;;;
;;; ڥåץܡɡ
;;;  åץܡʸФʲεǽɲäޤ
;;;  (åץܡɤʸΤᡢuimsurrounding text API)
;;;  * åץܡʸФƥإ(Ǥ)ɽ
;;;    (tutcode-help-clipboard-sequence)
;;;  * åץܡʸʲpreeditŽդ(tutcode-paste-key)
;;;   + Ͽ
;;;   + 򤼽Ѵɤϻ
;;;   + Ѵ(""Τ褦󥹤ˤб)
;;;   + ŪѴ
;;;   + ϻ
;;;
;;; 
;;; * ɽΰѹϡ㤨~/.uimǰʲΤ褦˵Ҥ롣
;;;   (require "tutcode.scm")
;;;   (tutcode-rule-set-sequences!
;;;     '(((("s" " "))(""))                ; ѹ
;;;       ((("a" "l" "i"))("Ľ"))            ; ɲ
;;;       ((("d" "l" "u"))("" ""))       ; ʤޤ
;;;       ((("d" "l" "d" "u"))("" ""))))
;;;
;;; * T-Code/Try-CodeȤ
;;;   uim-pref-gtkꤹ뤫~/.uimǰʲΤ褦ꤷƤ
;;;    (define tutcode-rule-filename "/usr/local/share/uim/tcode.scm")
;;;    ;(define tutcode-rule-filename "/usr/local/share/uim/trycode.scm")
;;;    (define tutcode-mazegaki-start-sequence "fj")
;;;    (define tutcode-bushu-start-sequence "jf")
;;;    (define tutcode-latin-conv-start-sequence "47")
;;;    (define tutcode-kana-toggle-key? (make-key-predicate '()))
;;;
;;; ڥˤĤơ
;;; generic.scm١ˤưʲѹ򤷤Ƥ롣
;;;  * Υڡͭˤʤ褦ѹ
;;;  * Ҥ餬/ʥ⡼ɤڤؤɲá
;;;  * 򤼽ѴǤSKKμȤΤǡ
;;;    skk.scmΤʴѴɬפʬߡ
;;;  * Ѵǽɲá
;;;  * ϥ⡼ɤɲá
;;;  * ۸ɽǽɲá
;;;  * ưإɽǽɲá
;;;  * 䴰/ͽ¬ϡϸ쥬ɵǽɲá
;;; ڸ䥦ɥٱɽ
;;; ٱɽŪ:桼ϻ˥إפ䴰νλԤˤ褦ˡ
;;;  + ưإפκ˾֤뤿ᡢưإפɽޤǤδ֤
;;;    ʹߤʸΥϤ򤷤ƤϤʸɽʤн
;;;  + ֥Ϥ̵Τߥإ(۸)䴰/ͽ¬ϸɽ
;;;    (¤鷺ϤƤ֤;פʥإפɽʤ)
;;; ٱɽή:
;;; candwin                        tutcode.scm
;;; [ɽΤߤٱ䤹]
;;;                                ꥹȤnr,display_limit׻
;;;                            <-- im-delay-activate-candidate-selector
;;;  ꤷԤ
;;;  λ
;;;                            --> delay-activating-handler
;;;                                nr,display_limit,index֤
;;;                            --> get-candidate-handler (֤)
;;;  ɽ
;;;
;;; [ꥹȤκٱ䤹]
;;;                            <-- im-delay-activate-candidate-selector
;;;  ꤷԤ
;;;  λ
;;;                            --> delay-activating-handler
;;;                                ꥹȤ
;;;                                nr,display_limit,index֤
;;;                            --> get-candidate-handler (֤)
;;;  ɽ
;;;
;;; (λ˥ˤim-{de,}activate-candidate-selector
;;;  ƤФ줿饿ޥ󥻥)

(require-extension (srfi 1 2 8 69))
(require "generic.scm")
(require "generic-predict.scm")
(require-custom "tutcode-custom.scm")
(require-custom "generic-key-custom.scm")
(require-custom "tutcode-key-custom.scm")
(require-custom "tutcode-rule-custom.scm");uim-prefɽΤ(tcode̵)
(require-dynlib "skk") ;SKKθ򤼽񤭼θΤlibuim-skk.so
(require "tutcode-bushudic.scm") ;Ѵ
(require "tutcode-kigoudic.scm") ;ϥ⡼Ѥεɽ
(require "tutcode-dialog.scm"); 򤼽Ѵ񤫤κǧ
(require "tutcode-bushu.scm")
(require "japanese.scm") ; for ja-wide or ja-make-kana-str{,-list}
(require "ustr.scm")

;;; user configs

;; widgets and actions

;; widgets
(define tutcode-widgets '(widget_tutcode_input_mode))

;; default activity for each widgets
(define default-widget_tutcode_input_mode 'action_tutcode_direct)

;; actions of widget_tutcode_input_mode
(define tutcode-input-mode-actions
  (if tutcode-use-kigou2-mode?
    '(action_tutcode_direct
      action_tutcode_hiragana
      action_tutcode_katakana
      action_tutcode_kigou
      action_tutcode_kigou2)
    '(action_tutcode_direct
      action_tutcode_hiragana
      action_tutcode_katakana
      action_tutcode_kigou)))

;;; Ѥ륳ɽ
;;; tutcode-context-new(tutcode-custom-load-rule!)
(define tutcode-rule ())
;;; 2ȥϥ⡼ѥɽ
(define tutcode-kigou-rule ())
;;; tutcode-rule롢հ(ǸꥹȤ)hash-table
;;; (ưإѤѴ両ι®Τ)
(define tutcode-reverse-rule-hash-table ())
;;; tutcode-kigou-rule롢հhash-table
(define tutcode-reverse-kigou-rule-hash-table ())
;;; tutcode-bushudic롢
;;; հ(ʸѤ2ʸ)hash-table
;;; (ưإѤѴ両ι®ѡ٤)
(define tutcode-reverse-bushudic-hash-table ())
;;; stroke-helpǡ⥭Ϥ̵ɽƤalist
;;; ɽʤ~/.uim()ꤹ뤫
;;; tutcode-show-stroke-help-window-on-no-input?#fꤹ롣
;;; (tutcode-ruleƤʤƺ٤
;;; ǽΥڡϸƤʤΤǡٺΤȤ)
(define tutcode-stroke-help-top-page-alist #f)
;;; stroke-helpǡ⥭Ϥ̵ɽƤalist
;;; ʥ⡼ѡ
;;; (XXX:ͭξ⥭åȤ褦ˤ?
;;;  ⤷С~/.uimǲ۸ɽƤΥޥưפˤʤ)
(define tutcode-stroke-help-top-page-katakana-alist #f)

;;; ɽѹ/ɲä뤿Υɽ
;;; ~/.uimtutcode-rule-set-sequences!Ͽơ
;;; tutcode-context-newȿǤ롣
(define tutcode-rule-userconfig ())

;;; Ǥȿ
(if (and (symbol-bound? 'tutcode-use-table-style-candidate-window?)
         tutcode-use-table-style-candidate-window?)
  (set! candidate-window-style 'table))
(if (symbol-bound? 'tutcode-commit-candidate-by-label-key?)
  (set! tutcode-commit-candidate-by-label-key
    (if tutcode-commit-candidate-by-label-key?
      'always
      'never)))

;;; ɽθ䥦ɥγƥܥȥбɽ(138)
;;; ɽ䥦ɥȤƻѤ롣
(define uim-candwin-prog-layout ())
;;; ɽ䥦ɥΥ쥤:QWERTY(JIS)
(define uim-candwin-prog-layout-qwerty-jis
  '("1" "2" "3" "4" "5"  "6" "7" "8" "9" "0"  "-" "^" "\\"
    "q" "w" "e" "r" "t"  "y" "u" "i" "o" "p"  "@" "[" ""
    "a" "s" "d" "f" "g"  "h" "j" "k" "l" ";"  ":" "]" ""
    "z" "x" "c" "v" "b"  "n" "m" "," "." "/"  ""  ""  " "
    "!" "\"" "#" "$" "%" "&" "'" "(" ")" ""   "=" "~" "|"
    "Q" "W" "E" "R" "T"  "Y" "U" "I" "O" "P"  "`" "{" ""
    "A" "S" "D" "F" "G"  "H" "J" "K" "L" "+"  "*" "}" ""
    "Z" "X" "C" "V" "B"  "N" "M" "<" ">" "?"  "_" ""  ""))
;;; ɽ䥦ɥΥ쥤:QWERTY(US/ASCII)
(define uim-candwin-prog-layout-qwerty-us
  '("1" "2" "3" "4" "5"  "6" "7" "8" "9" "0"  "-" "=" "\\"
    "q" "w" "e" "r" "t"  "y" "u" "i" "o" "p"  "[" "]" ""
    "a" "s" "d" "f" "g"  "h" "j" "k" "l" ";"  "'" "`" ""
    "z" "x" "c" "v" "b"  "n" "m" "," "." "/"  ""  ""  " "
    "!" "@" "#" "$" "%"  "^" "&" "*" "(" ")"  "_" "+" "|"
    "Q" "W" "E" "R" "T"  "Y" "U" "I" "O" "P"  "{" "}" ""
    "A" "S" "D" "F" "G"  "H" "J" "K" "L" ":"  "\"" "~" ""
    "Z" "X" "C" "V" "B"  "N" "M" "<" ">" "?"  ""  ""  ""))
;;; ɽ䥦ɥΥ쥤:DVORAK
;;; (֤줵줿Τ̵褦ʤΤǰ)
(define uim-candwin-prog-layout-dvorak
  '("1" "2" "3" "4" "5"  "6" "7" "8" "9" "0"  "[" "]" "\\"
    "'" "," "." "p" "y"  "f" "g" "c" "r" "l"  "/" "=" ""
    "a" "o" "e" "u" "i"  "d" "h" "t" "n" "s"  "-" "`" ""
    ";" "q" "j" "k" "x"  "b" "m" "w" "v" "z"  ""  ""  " "
    "!" "@" "#" "$" "%"  "^" "&" "*" "(" ")"  "{" "}" "|"
    "\"" "<" ">" "P" "Y" "F" "G" "C" "R" "L"  "?" "+" ""
    "A" "O" "E" "U" "I"  "D" "H" "T" "N" "S"  "_" "~" ""
    ":" "Q" "J" "K" "X"  "B" "M" "W" "V" "Z"  ""  ""  ""))
;;; ɽθ䥦ɥγƥܥȥбɽꡣ
;;; (~/.uimϤθǼ¹ԤΤǡ
;;;  ~/.uimѹˤuim-candwin-prog-layout񤭤ɬפ)
(set! uim-candwin-prog-layout
  (case tutcode-candidate-window-table-layout
    ((qwerty-jis) uim-candwin-prog-layout-qwerty-jis)
    ((qwerty-us) uim-candwin-prog-layout-qwerty-us)
    ((dvorak) uim-candwin-prog-layout-dvorak)
    (else ()))) ; default

;;; 򤼽Ѵθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; QWERTY(JIS)ѡ
(define tutcode-table-heading-label-char-list-qwerty-jis
  '("a" "s" "d" "f" "g" "h" "j" "k" "l" ";"
    "q" "w" "e" "r" "t" "y" "u" "i" "o" "p"
    "z" "x" "c" "v" "b" "n" "m" "," "." "/"
    "1" "2" "3" "4" "5" "6" "7" "8" "9" "0"))
;;; 򤼽Ѵθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; QWERTY(US)ѡ
(define tutcode-table-heading-label-char-list-qwerty-us
  tutcode-table-heading-label-char-list-qwerty-jis)
;;; 򤼽Ѵθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; DVORAKѡ
(define tutcode-table-heading-label-char-list-dvorak
  '("a" "o" "e" "u" "i"  "d" "h" "t" "n" "s"
    "'" "," "." "p" "y"  "f" "g" "c" "r" "l"
    ";" "q" "j" "k" "x"  "b" "m" "w" "v" "z"
    "1" "2" "3" "4" "5"  "6" "7" "8" "9" "0"))
;;; 򤼽Ѵθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; (Ǥ䤹꤫˸)
(define tutcode-table-heading-label-char-list
  tutcode-table-heading-label-char-list-qwerty-jis)
;;; 򤼽Ѵθѥ٥ʸΥꥹ(uim)
(define tutcode-uim-heading-label-char-list
  '("1" "2" "3" "4" "5" "6" "7" "8" "9" "0"
    "a" "b" "c" "d" "e" "f" "g" "h" "i" "j"
    "k" "l" "m" "n" "o" "p" "q" "r" "s" "t"
    "u" "v" "w" "x" "y" "z"
    "A" "B" "C" "D" "E" "F" "G" "H" "I" "J"
    "K" "L" "M" "N" "O" "P" "Q" "R" "S" "T"
    "U" "V" "W" "X" "Y" "Z"))
;;; 򤼽Ѵθѥ٥ʸΥꥹ
(define tutcode-heading-label-char-list ())

;;; ϥ⡼ɻθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; (ܡɥ쥤Ȥ˽äơ夫鱦ؽ˸)
(define tutcode-table-heading-label-char-list-for-kigou-mode
  (if (null? uim-candwin-prog-layout)
    (delete "" uim-candwin-prog-layout-qwerty-jis)
    (delete "" uim-candwin-prog-layout)))
;;; ϥ⡼ɻθѥ٥ʸΥꥹ(uim)
(define tutcode-uim-heading-label-char-list-for-kigou-mode
  '(" "
    "1" "2" "3" "4" "5" "6" "7" "8" "9" "0"
    "a" "b" "c" "d" "e" "f" "g" "h" "i" "j"
    "k" "l" "m" "n" "o" "p" "q" "r" "s" "t"
    "u" "v" "w" "x" "y" "z"
    "-" "^" "\\" "@" "[" ";" ":" "]" "," "." "/"
    "!" "\"" "#" "$" "%" "&" "'" "(" ")"
    "A" "B" "C" "D" "E" "F" "G" "H" "I" "J"
    "K" "L" "M" "N" "O" "P" "Q" "R" "S" "T"
    "U" "V" "W" "X" "Y" "Z"
    "=" "~" "|" "`" "{" "+" "*" "}" "<" ">" "?" "_"))
;;; ϥ⡼ɻθѥ٥ʸΥꥹ
;;; (ѱѿ⡼ɤȤƻȤˤϡtutcode-kigoudicȹ碌ɬפ)
(define tutcode-heading-label-char-list-for-kigou-mode ())

;;; ҥȥϻθѥ٥ʸΥꥹ
(define tutcode-heading-label-char-list-for-history ())

;;; 䴰/ͽ¬ϻθѥ٥ʸΥꥹȡ
;;; (̾ʸϤ˱ƶʤ褦ˡ1ǸܤȤ֤ʤʸѡ
;;; ()ľϤǤ褦ˡǤϴޤʤ)
;;; QWERTY(JIS)ѡTUT-Codeѡ
(define tutcode-heading-label-char-list-for-prediction-qwerty
  '(                     "Y" "U" "I" "O" "P"
                         "H" "J" "K" "L"
    "Z" "X" "C" "V" "B"  "N" "M"))
;;; 䴰/ͽ¬ϻθѥ٥ʸΥꥹȡ
;;; DVORAKѡTUT-Codeѡ
(define tutcode-heading-label-char-list-for-prediction-dvorak
  '(                     "F" "G" "C" "R" "L"
                         "D" "H" "T" "N" "S"
        "Q" "J" "K" "X"  "B" "M" "W" "V" "Z"))
;;; 䴰/ͽ¬ϻθѥ٥ʸΥꥹȡ
(define tutcode-heading-label-char-list-for-prediction
  tutcode-heading-label-char-list-for-prediction-qwerty)

;;; ưإפǤʸǤɽκݤ˸ʸȤƻȤʸΥꥹ
(define tutcode-auto-help-cand-str-list
  ;; 1,2,3Ǹ򼨤ʸ(1, 2)
  '((("1" "2" "3") ("4" "5" "6") ("7" "8" "9")) ; 1ʸ
    (("a" "b" "c") ("d" "e" "f") ("g" "h" "i")) ; 2ʸ
    (("A" "B" "C") ("D" "E" "F") ("G" "H" "I"))
    (("" "" "") ("" "" "ϻ") ("" "Ȭ" ""))
    (("" "" "") ("" "" "") ("" "" ""))
    (("" "" "") ("" "" "") ("" "" ""))))

;;; ưإ׺־[s]
(define tutcode-auto-help-time-limit 3)

;;; ϸ쥬ѥޡ
(define tutcode-guide-mark "+")
;;; ϸ쥬ѽλޡ
(define tutcode-guide-end-mark "+")
;;; ۸פΥȥǡ
;;; ³ΥҥȤȤɽդޡ
(define tutcode-hint-mark "*")
;;; 2ȥϥ⡼ɻ˲۸ɽԤɤ
(define tutcode-use-stroke-help-window-another? #t)

;;; ַ򤼽Ѵɤ߼ˡɤߤ˴ޤʤʸΥꥹ
(define tutcode-postfix-mazegaki-terminate-char-list
  '("\n" "\t" " " "" "" "" "" "" "" "" "" ""))

;;; ַѴоݼˡ(Ҥ餬ʤ˲ä)оݤˤʸΥꥹ
(define tutcode-postfix-katakana-char-list '(""))

;;; ַϥѴɤ߼ˡɤߤ˴ޤʤʸΥꥹȡ
;;; ڡޤñѴڤˤ硢'(":")ˤ뤳Ȥꡣ
;;; ("\n" "\t"̰tutcode-delete-leading-delimiter-on-postfix-kanji2seq?
;;;  #tξǤʤ褦ˤ뤿)
(define tutcode-postfix-kanji2seq-delimiter-char-list '(" "))

;;; surrounding text APIȤʤˡʸΤcommitʸ
(define tutcode-fallback-backspace-string "\b")

;;; implementations

;;; 򤼽ѴνäƤ뤫ɤ
(define tutcode-dic #f)

;;; list of context
(define tutcode-context-list '())

(define tutcode-prepare-activation
  (lambda (tc)
    (let ((rkc (tutcode-context-rk-context tc)))
      (rk-flush rkc))))

(register-action 'action_tutcode_direct
		 (lambda (tc)
		   '(ja_halfwidth_alnum
		     "a"
		     "ľ"
		     "ľϥ⡼"))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (not (tutcode-context-on? tc))))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (tutcode-flush tc)
                     (tutcode-context-set-state! tc 'tutcode-state-off)
                     (tutcode-update-preedit tc))));flushǥꥢɽȿ

(register-action 'action_tutcode_hiragana
		 (lambda (tc)
		   '(ja_hiragana
		     ""
		     "Ҥ餬"
		     "Ҥ餬ʥ⡼"))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (and (tutcode-context-on? tc)
                          (not (eq? (tutcode-context-state tc)
                                    'tutcode-state-kigou))
                          (not (tutcode-context-katakana-mode? tc))
                          (not (tutcode-kigou2-mode? tc)))))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (if
                       (or
                         (not (tutcode-context-on? tc)) ; Ѵ֤ѹʤ
                         (eq? (tutcode-context-state tc) 'tutcode-state-kigou))
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-context-set-state! tc 'tutcode-state-on)))
                     (if (tutcode-kigou2-mode? tc)
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-toggle-kigou2-mode tc)))
                     (tutcode-context-set-katakana-mode! tc #f)
                     (tutcode-update-preedit tc))))

(register-action 'action_tutcode_katakana
		 (lambda (tc)
		   '(ja_katakana
		     ""
		     ""
		     "ʥ⡼"))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (and (tutcode-context-on? tc)
                          (not (eq? (tutcode-context-state tc)
                                    'tutcode-state-kigou))
                          (tutcode-context-katakana-mode? tc)
                          (not (tutcode-kigou2-mode? tc)))))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (if
                       (or
                         (not (tutcode-context-on? tc)) ; Ѵ֤ѹʤ
                         (eq? (tutcode-context-state tc) 'tutcode-state-kigou))
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-context-set-state! tc 'tutcode-state-on)))
                     (if (tutcode-kigou2-mode? tc)
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-toggle-kigou2-mode tc)))
                     (tutcode-context-set-katakana-mode! tc #t)
                     (tutcode-update-preedit tc))))

(register-action 'action_tutcode_kigou
                 (lambda (tc)
                   '(ja_fullwidth_alnum
                     ""
                     ""
                     "ϥ⡼"))
                 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (eq? (tutcode-context-state tc) 'tutcode-state-kigou)))
                 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (if
                       (not
                         (eq? (tutcode-context-state tc) 'tutcode-state-kigou))
                       (tutcode-flush tc))
                     (tutcode-begin-kigou-mode tc)
                     (tutcode-update-preedit tc))))

(register-action 'action_tutcode_kigou2
                 (lambda (tc)
                   '(ja_fullwidth_alnum
                     ""
                     "2"
                     "ϥ⡼2"))
                 (lambda (c)
                   (let ((tc (tutcode-find-descendant-context c)))
                     (and (tutcode-context-on? tc)
                          (not (eq? (tutcode-context-state tc)
                                    'tutcode-state-kigou))
                          (tutcode-kigou2-mode? tc))))
                 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (if
                       (or
                         (not (tutcode-context-on? tc)) ; Ѵ֤ѹʤ
                         (eq? (tutcode-context-state tc) 'tutcode-state-kigou))
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-context-set-state! tc 'tutcode-state-on)))
                     (if (not (tutcode-kigou2-mode? tc))
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-toggle-kigou2-mode tc)))
                     (tutcode-update-preedit tc))))

;; Update widget definitions based on action configurations. The
;; procedure is needed for on-the-fly reconfiguration involving the
;; custom API
(define tutcode-configure-widgets
  (lambda ()
    (register-widget 'widget_tutcode_input_mode
		     (activity-indicator-new tutcode-input-mode-actions)
		     (actions-new tutcode-input-mode-actions))))

(define tutcode-context-rec-spec
  (append
   context-rec-spec
   (list
     (list 'rk-context ()) ; ȥʸؤѴΤΥƥ
     (list 'rk-context-another ()) ;⤦Ĥrk-context(2strokeϥ⡼)
     ;;; TUT-CodeϾ
     ;;; 'tutcode-state-off TUT-Code
     ;;; 'tutcode-state-on TUT-Code
     ;;; 'tutcode-state-yomi 򤼽Ѵɤ
     ;;; 'tutcode-state-code 
     ;;; 'tutcode-state-converting 򤼽Ѵθ
     ;;; 'tutcode-state-bushu ϡѴ
     ;;; 'tutcode-state-interactive-bushu ŪѴ
     ;;; 'tutcode-state-kigou ϥ⡼
     ;;; 'tutcode-state-history ҥȥϥ⡼
     ;;; 'tutcode-state-postfix-katakana ַѴ
     ;;; 'tutcode-state-postfix-kanji2seq ַϥѴ
     ;;; 'tutcode-state-postfix-seq2kanji ַϥ󥹢Ѵ
     (list 'state 'tutcode-state-off)
     ;;; ʥ⡼ɤɤ
     ;;; #t: ʥ⡼ɡ#f: Ҥ餬ʥ⡼ɡ
     (list 'katakana-mode #f)
     ;;; 򤼽Ѵ/Ѵоݤʸꥹ(ս)
     ;;; (: 򤼽Ѵɤߡ֤פϤ硢("" "" ""))
     (list 'head ())
     ;;; 򤼽Ѵθֹ
     (list 'nth 0)
     ;;; 򤼽Ѵθ
     (list 'nr-candidates 0)
     ;;; ַ򤼽ѴˡѴ˻ѤɤߤĹ
     ;;; (im-delete-text뤿˻)
     ;;; ַ()ַ(0)selection()Ƚˤѡ
     (list 'postfix-yomi-len 0)
     ;;; 򤼽Ѵϻ˻ꤵ줿ɤߤʸ
     ;;; ַξϺѤߤɤߤʸ
     (list 'mazegaki-yomi-len-specified 0)
     ;;; 򤼽ѴѤɤΡַξϼѤߤɤ
     (list 'mazegaki-yomi-all ())
     ;;; 򤼽ѴγѸ
     ;;; (Ѥϸ򡽤ִƸΤǡ᤹˻)
     (list 'mazegaki-suffix ())
     ;;; 䥦ɥξ
     ;;; 'tutcode-candidate-window-off ɽ
     ;;; 'tutcode-candidate-window-converting 򤼽Ѵɽ
     ;;; 'tutcode-candidate-window-kigou ɽ
     ;;; 'tutcode-candidate-window-stroke-help ۸ɽ
     ;;; 'tutcode-candidate-window-auto-help ưإɽ
     ;;; 'tutcode-candidate-window-predicting 䴰/ͽ¬ϸɽ
     ;;; 'tutcode-candidate-window-interactive-bushu ŪѴɽ
     ;;; 'tutcode-candidate-window-history ҥȥϸɽ
     (list 'candidate-window 'tutcode-candidate-window-off)
     ;;; 䥦ɥٱɽԤ椫ɤ
     (list 'candwin-delay-waiting #f)
     ;;; 䥦ɥٱɽԤ򤵤줿Υǥåֹ
     (list 'candwin-delay-selected-index -1)
     ;;; ɽɽѤθvector(Ǥƥڡθꥹ)
     (list 'pseudo-table-cands #f)
     ;;; ȥɽ
     ;;; Ϥ륭ʸбΡget-candidate-handlerѷǤΥꥹ
     (list 'stroke-help ())
     ;;; ưإ
     (list 'auto-help ())
     ;;; 򤼽ѴؤκƵŪϿΤλҥƥ
     (list 'child-context ())
     ;;; ҥƥȤμ
     ;;; 'tutcode-child-type-editor ϿѤѴʸԽǥ
     ;;; 'tutcode-child-type-dialog 񤫤κǧ
     ;;; 'tutcode-child-type-seq2kanji 󥹢Ѵ
     (list 'child-type ())
     ;;; ƥƥ
     (list 'parent-context ())
     ;;; ϿʸԽǥ
     (list 'editor ())
     ;;; ǧ
     (list 'dialog ())
     ;;; ѻѴ(SKK abbrev)⡼ɤɤ
     (list 'latin-conv #f)
     ;;; commitѤʸꥹ(䴰)
     (list 'commit-strs ())
     ;;; commit-strsΤ䴰˻ѤƤʸ
     (list 'commit-strs-used-len 0)
     ;;; commitʸ(ҥȥ)
     (list 'history ())
     ;;; ַѴγundo뤿Υǡ
     (list 'undo ())
     ;;; 䴰/ͽ¬Ϥθ椫ɤ
     ;;; 'tutcode-predicting-off 䴰/ͽ¬ϤθǤʤ
     ;;; 'tutcode-predicting-completion 䴰
     ;;; 'tutcode-predicting-prediction 򤼽Ѵͽ¬ϸ
     ;;; 'tutcode-predicting-bushu Ѵͽ¬ϸ
     ;;; 'tutcode-predicting-interactive-bushu ŪѴ
     (list 'predicting 'tutcode-predicting-off)
     ;;; 䴰/ͽ¬ѥƥ
     (list 'prediction-ctx ())
     ;;; 䴰/ͽ¬ϸɤߤΥꥹ
     (list 'prediction-word ())
     ;;; 䴰/ͽ¬ϸθΥꥹ
     (list 'prediction-candidates ())
     ;;; 䴰/ͽ¬ϸappendixΥꥹ
     (list 'prediction-appendix ())
     ;;; 䴰/ͽ¬ϸ
     (list 'prediction-nr 0)
     ;;; 䴰/ͽ¬ϸθ򤵤Ƥ륤ǥå(ϸ쥬ɹ)
     (list 'prediction-index 0)
     ;;; 䴰/ͽ¬ϸ(ϸ쥬ʬޤ)
     (list 'prediction-nr-all 0)
     ;;; ڡȤ䴰/ͽ¬Ϥθɽ(ϸ쥬ʬϽ)
     (list 'prediction-nr-in-page tutcode-nr-candidate-max-for-prediction)
     ;;; ڡȤ䴰/ͽ¬Ϥθɽ(ϸ쥬ʬޤ)
     (list 'prediction-page-limit
      (+ tutcode-nr-candidate-max-for-prediction
         tutcode-nr-candidate-max-for-guide))
     ;;; Ѵͽ¬
     (list 'prediction-bushu ())
     ;;; Ѵͽ¬θߤɽڡκǽΥǥåֹ
     (list 'prediction-bushu-page-start 0)
     ;;; ϸ쥬ɡ䴰/ͽ¬ϻɽѡ
     ;;; ͽ¬뼡ϴ1ǸϴбΥꥹȡ
     ;;; : (("," "") ("u" "" ""))
     (list 'guide ())
     ;;; ϸ쥬ɺǡ۸(stroke-help)ؤΥɽѡ
     ;;; ʸȥȥΥꥹ(rk-lib-find-partial-seqsѷ)
     ;;; : (((("," "r"))("")) ((("u" "c"))("")) ((("u" "v"))("")))
     (list 'guide-chars ())
     )))
(define-record 'tutcode-context tutcode-context-rec-spec)
(define tutcode-context-new-internal tutcode-context-new)
(define tutcode-context-katakana-mode? tutcode-context-katakana-mode)
(define (tutcode-context-on? pc)
  (not (eq? (tutcode-context-state pc) 'tutcode-state-off)))
(define (tutcode-kigou2-mode? pc)
  (and tutcode-use-kigou2-mode?
       (eq? (rk-context-rule (tutcode-context-rk-context pc))
            tutcode-kigou-rule)))

;;; TUT-CodeΥƥȤ򿷤롣
;;; @return ƥ
(define (tutcode-context-new id im)
  (im-set-delay-activating-handler! im tutcode-delay-activating-handler)
  (if (not tutcode-dic)
    (if (not (symbol-bound? 'skk-lib-dic-open))
      (begin
        (if (symbol-bound? 'uim-notify-info)
          (uim-notify-info
            (N_ "libuim-skk.so is not available. Mazegaki conversion is disabled")))
        (set! tutcode-use-recursive-learning? #f)
        (set! tutcode-enable-mazegaki-learning? #f))
      (begin
        (set! tutcode-dic (skk-lib-dic-open tutcode-dic-filename #f "localhost" 0 'unspecified))
        (if tutcode-use-recursive-learning?
          (require "tutcode-editor.scm"))
        (tutcode-read-personal-dictionary))))
  (let ((tc (tutcode-context-new-internal id im)))
    (tutcode-context-set-widgets! tc tutcode-widgets)
    (if (null? tutcode-rule)
      (begin
        (tutcode-custom-load-rule! tutcode-rule-filename)
        (if tutcode-use-dvorak?
          (begin
            (set! tutcode-rule (tutcode-rule-qwerty-to-dvorak tutcode-rule))
            (set! tutcode-heading-label-char-list-for-prediction
              tutcode-heading-label-char-list-for-prediction-dvorak)))
        ;; tutcode-mazegaki/bushu-start-sequenceϡ
        ;; tutcode-use-dvorak?ΤȤDvorakΥ󥹤Ȥߤʤȿǡ
        ;; Ĥޤꡢruleqwerty-to-dvorakѴȿǤ롣
        (tutcode-custom-set-mazegaki/bushu-start-sequence!)
        (tutcode-rule-commit-sequences! tutcode-rule-userconfig)))
    ;; ɽ䥦ɥ
    (if (null? tutcode-heading-label-char-list)
      (if (or (eq? candidate-window-style 'table)
              tutcode-use-pseudo-table-style?)
        (set! tutcode-heading-label-char-list
          (case tutcode-candidate-window-table-layout
            ((qwerty-jis) tutcode-table-heading-label-char-list-qwerty-jis)
            ((qwerty-us) tutcode-table-heading-label-char-list-qwerty-us)
            ((dvorak) tutcode-table-heading-label-char-list-dvorak)
            (else tutcode-table-heading-label-char-list)))
        (set! tutcode-heading-label-char-list
          tutcode-uim-heading-label-char-list)))
    (if (null? tutcode-heading-label-char-list-for-history)
      (set! tutcode-heading-label-char-list-for-history
        tutcode-heading-label-char-list))
    (if (null? tutcode-heading-label-char-list-for-kigou-mode)
      (if (or (eq? candidate-window-style 'table)
              tutcode-use-pseudo-table-style?)
        (begin
          (set! tutcode-heading-label-char-list-for-kigou-mode
            tutcode-table-heading-label-char-list-for-kigou-mode)
          ;; ϥ⡼ɤѱѿ⡼ɤȤƻȤᡢ
          ;; tutcode-heading-label-char-list-for-kigou-modeѤˤ
          ;; tutcode-kigoudicƬ
          (set! tutcode-kigoudic
            (append
              (map (lambda (lst) (list (ja-wide lst)))
                tutcode-heading-label-char-list-for-kigou-mode)
              (list-tail tutcode-kigoudic
                (length tutcode-heading-label-char-list-for-kigou-mode)))))
        (set! tutcode-heading-label-char-list-for-kigou-mode
          tutcode-uim-heading-label-char-list-for-kigou-mode)))
    (tutcode-context-set-rk-context! tc (rk-context-new tutcode-rule #t #f))
    (if tutcode-use-kigou2-mode?
      (begin
        (if (null? tutcode-kigou-rule)
          (begin
            (require "tutcode-kigou-rule.scm") ;2strokeϥ⡼ѥɽ
            (tutcode-kigou-rule-translate
              tutcode-candidate-window-table-layout)))
        (tutcode-context-set-rk-context-another!
          tc (rk-context-new tutcode-kigou-rule #t #f))))
    (if tutcode-use-recursive-learning?
      (tutcode-context-set-editor! tc (tutcode-editor-new tc)))
    (tutcode-context-set-dialog! tc (tutcode-dialog-new tc))
    (if (or tutcode-use-completion? tutcode-use-prediction?)
      (begin
        (tutcode-context-set-prediction-ctx! tc (predict-make-meta-search))
        (predict-meta-open (tutcode-context-prediction-ctx tc) "tutcode")
        (predict-meta-set-external-charset! (tutcode-context-prediction-ctx tc) "EUC-JP")))
    tc))

;;; Ҥ餬/ʥ⡼ɤڤؤԤ
;;; ξ֤Ҥ餬ʥ⡼ɤξϥʥ⡼ɤڤؤ롣
;;; ξ֤ʥ⡼ɤξϤҤ餬ʥ⡼ɤڤؤ롣
;;; @param pc ƥȥꥹ
(define (tutcode-context-kana-toggle pc)
  (let ((s (tutcode-context-katakana-mode? pc)))
    (tutcode-context-set-katakana-mode! pc (not s))))

;;; äΥƥȤ롣
(define (tutcode-find-root-context pc)
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (null? ppc)
      pc
      (tutcode-find-root-context ppc))))

;;; Υƥ(򤼽ѴκƵŪϿΰֿȤ
;;; =ԽΥƥ)롣
(define (tutcode-find-descendant-context pc)
  (let ((cpc (tutcode-context-child-context pc)))
    (if (null? cpc)
      pc
      (tutcode-find-descendant-context cpc))))

(define (tutcode-predict pc str)
  (predict-meta-search
   (tutcode-context-prediction-ctx pc)
   str))
;;; 䴰/ͽ¬ϸ򸡺
;;; @param str ʸ
;;; @param completion? 䴰ξ#t
;;; @return ʣƤɤߤΥꥹ(ϸ쥬)
(define (tutcode-lib-set-prediction-src-string pc str completion?)
  (let* ((ret      (tutcode-predict pc str))
         (word     (predict-meta-word? ret))
         (cands    (predict-meta-candidates? ret))
         (appendix (predict-meta-appendix? ret))
         (word/cand/appendix (map list word cands appendix))
         (uniq-word/cand/appendix 
          ;; ʣ
          (delete-duplicates word/cand/appendix
            (lambda (x y)
              (let ((xcand (list-ref x 1))
                    (ycand (list-ref y 1)))
                (string=? xcand ycand)))))
         (strlen (string-length str))
         (filtered-word/cand/appendix
          (if completion?
            (filter
              ;; 䴰strǻϤޤäƤʤ(strcommitѤʤΤ)
              (lambda (elem)
                (let ((cand (list-ref elem 1)))
                  (and
                    (> (string-length cand) strlen)
                    (string=? str (substring cand 0 strlen)))))
              uniq-word/cand/appendix)
            uniq-word/cand/appendix))
         (filtered-word
          (map (lambda (x) (list-ref x 0)) filtered-word/cand/appendix))
         (filtered-cands
          (map (lambda (x) (list-ref x 1)) filtered-word/cand/appendix))
         (filtered-appendix
          (map (lambda (x) (list-ref x 2)) filtered-word/cand/appendix)))
    (tutcode-context-set-prediction-word! pc filtered-word)
    (tutcode-context-set-prediction-candidates! pc
      (if completion?
        (map
          (lambda (cand)
            ;; 䴰Ƭstr:
            ;; strϳʸʤΤǡʸνʣ򤱤뤿ᡣ
            (if (string=? str (substring cand 0 strlen))
              (substring cand strlen (string-length cand))
              cand))
          filtered-cands)
        filtered-cands))
    (tutcode-context-set-prediction-appendix! pc filtered-appendix)
    (tutcode-context-set-prediction-nr! pc (length filtered-cands))
    word))

;;; Ѵͽ¬ϸ
;;; @param start-index ֹ
(define (tutcode-lib-set-bushu-prediction pc start-index)
  ;; ֹ椫Ϥޤ1ڡ֤θФƻѡ
  ;; ƻѤȡϸ쥬ɤΥ٥ʸĹʤäƲꤹ
  ;; ɥ˼ޤʤʤ礬Τ(200ʾξʤ)
  ;; (ϸ쥬ɤɽθˡ⤢뤬
  ;; ξ硢ϸ쥬ɤοڡȤѤäƤޤᡢ
  ;; θ䥦ɥ(ڡȤɽѤʤȤ)
  ;; Ǥɽ꤬ȯ)
  (let* ((ret (tutcode-context-prediction-bushu pc))
         (all-len (length ret))
         (start
          (cond
            ((>= start-index all-len)
              (tutcode-context-prediction-bushu-page-start pc))
            ((< start-index 0)
              0)
            (else
              start-index)))
         (end (+ start tutcode-nr-candidate-max-for-prediction))
         (cnt
          (if (< end all-len)
            tutcode-nr-candidate-max-for-prediction
            (- all-len start)))
         (page-word/cand (take (drop ret start) cnt))
         (page-word (map (lambda (elem) (car elem)) page-word/cand))
         (page-cands (map (lambda (elem) (cadr elem)) page-word/cand))
         (len (length page-cands))
         (appendix (make-list len "")))
    (tutcode-context-set-prediction-bushu-page-start! pc start)
    (tutcode-context-set-prediction-word! pc page-word)
    (tutcode-context-set-prediction-candidates! pc page-cands)
    (tutcode-context-set-prediction-appendix! pc appendix)
    (tutcode-context-set-prediction-nr! pc len)))

(define (tutcode-lib-get-nr-predictions pc)
  (tutcode-context-prediction-nr pc))
(define (tutcode-lib-get-nth-word pc nth)
  (let ((word (tutcode-context-prediction-word pc)))
    (list-ref word nth)))
(define (tutcode-lib-get-nth-prediction pc nth)
  (let ((cands (tutcode-context-prediction-candidates pc)))
    (list-ref cands nth)))
(define (tutcode-lib-get-nth-appendix pc nth)
  (let ((appendix (tutcode-context-prediction-appendix pc)))
    (list-ref appendix nth)))
(define (tutcode-lib-commit-nth-prediction pc nth completion?)
  (let ((cand (tutcode-lib-get-nth-prediction pc nth)))
    (predict-meta-commit
      (tutcode-context-prediction-ctx pc)
      (tutcode-lib-get-nth-word pc nth)
      (if completion?
        ;; 䴰ϡcandsϸդƤ
        ;; Ƭcommit-strsƤΤǡ
        (string-append
          (string-list-concat
            (take (tutcode-context-commit-strs pc)
                  (tutcode-context-commit-strs-used-len pc)))
          cand)
        cand)
      (tutcode-lib-get-nth-appendix pc nth))))

;;; ϸ쥬ɽѸꥹȤ䴰/ͽ¬ϸ䤫
;;; @param str 䴰/ͽ¬ϸθ˻Ѥʸ=Ϻʸ
;;; @param completion? 䴰#t
;;; @param all-yomi ͽ¬ϸ両̤˴ޤޤƤɤ
(define (tutcode-guide-set-candidates pc str completion? all-yomi)
  (let* ((cands (tutcode-context-prediction-candidates pc))
         (rule (rk-context-rule (tutcode-context-rk-context pc)))
         (word all-yomi)
         (strlen (string-length str))
         (filtered-cands
          (if (not completion?)
            (filter
              ;; ͽ¬ϻstrǻϤޤäƤʤäƤΤǽ
              (lambda (cand)
                (and
                  (> (string-length cand) strlen)
                  (string=? str (substring cand 0 strlen))))
              cands)
            cands))
         ;; ɤϡɤ(word)⸫ƼǽΤ򥬥
         ;; :""Ϥǡlook""ȤɤߤȤˡ
         ;;    ""򥬥
         (filtered-words
          (if completion?
            ()
            (filter
              (lambda (cand)
                (let ((candlen (string-length cand)))
                  (and
                    (> candlen strlen)
                    ;; strθˡѤ򼨤""ĤʤϽ
                    (not (string=?  "" (substring cand strlen candlen))))))
              word)))
         (trim-str
          (lambda (lst)
            (if (not completion?)
              (map
                (lambda (cand)
                  ;; ͽ¬ϻϺѤstrޤޤƤΤǡ
                  ;; ʸ򥬥ɽ
                  (substring cand strlen (string-length cand)))
                lst)
              lst)))
         (trim-cands (trim-str filtered-cands))
         (trim-words (trim-str filtered-words))
         (candchars ; ͽ¬ϸ1ʸܤδΥꥹ
          (delete-duplicates
            (map (lambda (cand) (last (string-to-list cand)))
              (append trim-cands trim-words))))
         (cand-stroke
          (map
            (lambda (elem)
              (list (list (tutcode-reverse-find-seq elem rule)) (list elem)))
            candchars))
         (filtered-cand-stroke
          (filter
            (lambda (elem)
              (pair? (caar elem))) ; ɽ̵Ͻ
            cand-stroke))
         (label-cands-alist
          (tutcode-guide-update-alist () filtered-cand-stroke)))
    (tutcode-context-set-guide! pc label-cands-alist)
    (tutcode-context-set-guide-chars! pc filtered-cand-stroke)))

;;; ϸ쥬ɽѸꥹȤͽ¬ϸ䤫
;;; @param str ͽ¬ϸθ˻Ѥ=ϺѴ
(define (tutcode-guide-set-candidates-for-bushu pc)
  (let* ((word (tutcode-context-prediction-word pc))
         (rule (rk-context-rule (tutcode-context-rk-context pc)))
         (cand-stroke
          (map
            (lambda (elem)
              (list (list (tutcode-reverse-find-seq elem rule)) (list elem)))
            word))
         (filtered-cand-stroke
          (filter
            (lambda (elem)
              (pair? (caar elem))) ; ɽ̵Ͻ
            cand-stroke))
         (label-cands-alist
          (tutcode-guide-update-alist () filtered-cand-stroke)))
    (tutcode-context-set-guide! pc label-cands-alist)
    (tutcode-context-set-guide-chars! pc filtered-cand-stroke)))

;;; ϸ쥬ɤɽ˻Ȥalist򹹿롣
;;; alistϰʲΤ褦˥٥ʸȴΥꥹȡ
;;; : (("," "") ("u" "" ""))
;;; @param label-cands-alist alist
;;; @param kanji-list ȥȥΥꥹ
;;; : (((("," "r"))("")) ((("u" "c"))("")) ((("u" "v"))("")))
;;; @return νϸ쥬alist
(define (tutcode-guide-update-alist label-cands-alist kanji-list)
  (if (null? kanji-list)
    label-cands-alist
    (let*
      ((kanji-stroke (car kanji-list))
       (kanji (caadr kanji-stroke))
       (stroke (caar kanji-stroke)))
      (tutcode-guide-update-alist
        (tutcode-auto-help-update-stroke-alist-with-key label-cands-alist
          kanji (car stroke))
        (cdr kanji-list)))))

;;; 򤼽ѴѸĿͼɤ߹ࡣ
(define (tutcode-read-personal-dictionary)
  (if (not (setugid?))
      (skk-lib-read-personal-dictionary tutcode-dic tutcode-personal-dic-filename)))

;;; 򤼽ѴѸĿͼ񤭹ࡣ
;;; @param force? tutcode-enable-mazegaki-learning?#fǤ񤭹फɤ
(define (tutcode-save-personal-dictionary force?)
  (if (and
        (or force? tutcode-enable-mazegaki-learning?)
        (not (setugid?)))
      (skk-lib-save-personal-dictionary tutcode-dic tutcode-personal-dic-filename)))

;;; ȥʸؤѴΤrk-push-key!ƤӽФ
;;; ͤ#fǤʤС(ꥹ)car֤
;;; ʥ⡼ɤξͥꥹȤcadr֤
;;; (rk-push-key!ϥȥξ#f֤)
;;; @param pc ƥȥꥹ
;;; @param key ʸ
(define (tutcode-push-key! pc key)
  (let ((res (rk-push-key! (tutcode-context-rk-context pc) key)))
    (and res
      (begin
        (tutcode-context-set-guide-chars! pc ())
        (if
          (and
            (not (null? (cdr res)))
            (tutcode-context-katakana-mode? pc))
          (cadr res)
          (car res))))))

;;; Ѵ֤򥯥ꥢ롣
;;; @param pc ƥȥꥹ
(define (tutcode-flush pc)
  (let ((cpc (tutcode-context-child-context pc)))
    (rk-flush (tutcode-context-rk-context pc))
    (if tutcode-use-recursive-learning?
      (tutcode-editor-flush (tutcode-context-editor pc)))
    (tutcode-dialog-flush (tutcode-context-dialog pc))
    (if (tutcode-context-on? pc) ; ջ˸ƤФ줿ϥˤ
      (tutcode-context-set-state! pc 'tutcode-state-on)) ; Ѵ֤򥯥ꥢ
    (tutcode-context-set-head! pc ())
    (tutcode-context-set-nr-candidates! pc 0)
    (tutcode-context-set-postfix-yomi-len! pc 0)
    (tutcode-context-set-mazegaki-yomi-len-specified! pc 0)
    (tutcode-context-set-mazegaki-yomi-all! pc ())
    (tutcode-context-set-mazegaki-suffix! pc ())
    (tutcode-reset-candidate-window pc)
    (tutcode-context-set-latin-conv! pc #f)
    (tutcode-context-set-guide-chars! pc ())
    (tutcode-context-set-child-context! pc ())
    (tutcode-context-set-child-type! pc ())
    (if (not (null? cpc))
      (tutcode-flush cpc))))

;;; 򤼽Ѵnܤθ֤
;;; @param pc ƥȥꥹ
;;; @param n оݤθֹ
(define (tutcode-get-nth-candidate pc n)
  (let* ((head (tutcode-context-head pc))
         (cand (skk-lib-get-nth-candidate
                tutcode-dic
                n
                (cons (string-list-concat head) "")
                ""
                #f)))
    cand))

;;; ϥ⡼ɻnܤθ֤
;;; @param n оݤθֹ
(define (tutcode-get-nth-candidate-for-kigou-mode pc n)
 (car (nth n tutcode-kigoudic)))

;;; ҥȥϥ⡼ɻnܤθ֤
;;; @param n оݤθֹ
(define (tutcode-get-nth-candidate-for-history pc n)
  (list-ref (tutcode-context-history pc) n))

;;; 򤼽Ѵθθ֤
;;; @param pc ƥȥꥹ
(define (tutcode-get-current-candidate pc)
  (tutcode-get-nth-candidate pc (tutcode-context-nth pc)))

;;; ϥ⡼ɻθθ֤
(define (tutcode-get-current-candidate-for-kigou-mode pc)
  (tutcode-get-nth-candidate-for-kigou-mode pc (tutcode-context-nth pc)))

;;; ҥȥϥ⡼ɻθθ֤
(define (tutcode-get-current-candidate-for-history pc)
  (tutcode-get-nth-candidate-for-history pc (tutcode-context-nth pc)))

;;; 򤼽Ѵǳꤷʸ֤
;;; @param pc ƥȥꥹ
;;; @return ꤷʸ
(define (tutcode-prepare-commit-string pc)
  (let ((res (tutcode-get-current-candidate pc))
        (suffix (tutcode-context-mazegaki-suffix pc))
        (nth (tutcode-context-nth pc)))
    ;; ĤΥ٥륭θꤹȤǤ褦ˡ
    ;; tutcode-enable-mazegaki-learning?#fξϸ¤ӽѤʤ
    ;; (:֤פѴˤơdǡֲסeǡֲפ)
    (if (and tutcode-enable-mazegaki-learning?
             (> nth tutcode-mazegaki-fixed-priority-count))
      (let ((head-and-okuri-head
              (cons (string-list-concat (tutcode-context-head pc)) "")))
        ;; skk-lib-commit-candidateƤ֤ȳؽԤ졢礬ѹ
        (skk-lib-commit-candidate tutcode-dic head-and-okuri-head "" nth #f)
        ;; ƬĤθΤᡢԤθƽФƬˤʤä򲡤
        (do
          ((i tutcode-mazegaki-fixed-priority-count (- i 1)))
          ((<= i 0))
          (skk-lib-commit-candidate tutcode-dic head-and-okuri-head ""
            tutcode-mazegaki-fixed-priority-count #f))
        (tutcode-save-personal-dictionary #f)))
    (tutcode-flush pc)
    (if (null? suffix)
      res
      (string-append res (string-list-concat suffix)))))

;;; ϥ⡼ɻ˳ꤷʸ֤
(define (tutcode-prepare-commit-string-for-kigou-mode pc)
  (tutcode-get-current-candidate-for-kigou-mode pc))

;;; ҥȥϥ⡼ɻ˳ꤷʸ֤
(define (tutcode-prepare-commit-string-for-history pc)
  (tutcode-get-current-candidate-for-history pc))

;;; im-commit-rawƤӽФ
;;; ҥƥȤξϡeditordialogϥϤ
(define (tutcode-commit-raw pc key key-state)
  (tutcode-context-set-undo! pc ())
  (if (or tutcode-use-completion? tutcode-enable-fallback-surrounding-text?)
    (tutcode-append-commit-string pc (im-get-raw-key-str key key-state)))
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (not (null? ppc))
      (case (tutcode-context-child-type ppc)
        ((tutcode-child-type-editor)
          (tutcode-editor-commit-raw (tutcode-context-editor ppc) key key-state))
        ((tutcode-child-type-dialog)
          (tutcode-dialog-commit-raw (tutcode-context-dialog ppc) key key-state))
        ((tutcode-child-type-seq2kanji)
          (tutcode-seq2kanji-commit-raw-from-child ppc key key-state)))
      (im-commit-raw pc))))

;;; im-commitƤӽФ
;;; ҥƥȤξϡeditordialogϥϤ
;;; @param str ߥåȤʸ
;;; @param opts ץ
;;;  opt-skip-append-commit-strs? commit-strsؤɲä
;;;  åפ뤫ɤ̤#f
;;;  opt-skip-append-history? historyؤɲä
;;;  åפ뤫ɤ̤#f
(define (tutcode-commit pc str . opts)
  (tutcode-context-set-undo! pc ())
  (let-optionals* opts ((opt-skip-append-commit-strs? #f)
                        (opt-skip-append-history? #f))
    (if (and
          (or tutcode-use-completion? tutcode-enable-fallback-surrounding-text?)
          (not opt-skip-append-commit-strs?))
      (tutcode-append-commit-string pc str))
    (if (and (> tutcode-history-size 0)
             (not opt-skip-append-history?))
      (tutcode-append-history pc str)))
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (not (null? ppc))
      (case (tutcode-context-child-type ppc)
        ((tutcode-child-type-editor)
          (tutcode-editor-commit (tutcode-context-editor ppc) str))
        ((tutcode-child-type-dialog)
          (tutcode-dialog-commit (tutcode-context-dialog ppc) str))
        ((tutcode-child-type-seq2kanji)
          (tutcode-seq2kanji-commit-from-child ppc str)))
      (im-commit pc str))))

;;; im-commitƤӽФȤȤˡưإɽΥåԤ
(define (tutcode-commit-with-auto-help pc)
  (let* ((head (tutcode-context-head pc))
         (yomi-len (tutcode-context-postfix-yomi-len pc))
         (yomi (and (not (zero? yomi-len))
                    (take (tutcode-context-mazegaki-yomi-all pc)
                          (abs yomi-len))))
         (suffix (tutcode-context-mazegaki-suffix pc))
         (state (tutcode-context-state pc))
         ;; 1ĤǼưꤵ줿տޤΤǤʤäundo
         ;; (ɤϾ֤Ƹ֤ǤϤʤθֹ)
         (undo-data (and (eq? state 'tutcode-state-converting)
                         (list head (tutcode-context-latin-conv pc))))
         (res (tutcode-prepare-commit-string pc))) ; flushˤheadꥢ
    (cond
      ((= yomi-len 0)
        (tutcode-commit pc res)
        (if undo-data
          (tutcode-undo-prepare pc state res undo-data)))
      ((> yomi-len 0)
        (tutcode-postfix-commit pc res yomi))
      (else
        (tutcode-selection-commit pc res yomi)))
    (tutcode-check-auto-help-window-begin pc
      (drop (string-to-list res) (length suffix))
      (append suffix head))))

;;; 򤼽Ѵθˡꤵ줿٥ʸбꤹ
;;; @param ch Ϥ줿٥ʸ
;;; @return ꤷ#t
(define (tutcode-commit-by-label-key pc ch)
  ;; ߸䥦ɥɽƤʤ٥ʸϤ硢
  ;; ߰ʹߤθˤϥ٥ʸбꤹ롣
  ;; (ؽǽ򥪥դˤƸ¤ӽˤƻѤˡ
  ;; next-page-key򲡤򸺤餷
  ;; ʤ٤ʤŪθ٤褦ˤ뤿)
  (let* ((nr (tutcode-context-nr-candidates pc))
         (nth (tutcode-context-nth pc))
         (idx
          (tutcode-get-idx-by-label-key ch nth tutcode-nr-candidate-max
            tutcode-nr-candidate-max tutcode-heading-label-char-list)))
    (if (and (>= idx 0)
             (< idx nr))
      (begin
        (tutcode-context-set-nth! pc idx)
        (tutcode-commit-with-auto-help pc)
        #t)
      (eq? tutcode-commit-candidate-by-label-key 'always))))

;;; ˡꤵ줿٥ʸбֹ׻
;;; @param ch Ϥ줿٥ʸ
;;; @param nth 򤵤Ƥֹ
;;; @param page-limit 򥦥ɥǤγƥڡθ
;;;                   (䴰ξ:䴰+ϸ쥬)
;;; @param nr-in-page 򥦥ɥǤγƥڡθ
;;;                   (䴰ξ:䴰Τ)
;;; @param heading-label-char-list ٥ʸ
;;; @return ֹ
(define (tutcode-get-idx-by-label-key ch nth page-limit nr-in-page
        heading-label-char-list)
  (let*
    ((cur-page (if (= page-limit 0)
                  0
                  (quotient nth page-limit)))
     ;; ߸䥦ɥɽθꥹȤƬθֹ
     (cur-offset (* cur-page nr-in-page))
     (labellen (length heading-label-char-list))
     (cur-labels
       (list-tail heading-label-char-list (remainder cur-offset labellen)))
     (target-labels (member ch cur-labels))
     (offset (if target-labels
               (- (length cur-labels) (length target-labels))
               (+ (length cur-labels)
                  (- labellen
                     (length
                       (member ch heading-label-char-list))))))
     (idx (+ cur-offset offset)))
    idx))

;;; ϥ⡼ɻˡꤵ줿٥ʸбꤹ
;;; @return ꤷ#t
(define (tutcode-commit-by-label-key-for-kigou-mode pc ch)
  ;; 򤼽ѴȰۤʤꡢߤθꤹ礢
  ;; (ѱѿϥ⡼ɤȤƻȤ褦ˤ뤿)
  ;; (ϥ⡼ɻϡٳꤷϢ³ϤǤ褦ˡ
  ;; ľθ򤷤Ƥ뤬
  ;; ΤȤ򤼽ѴƱͤθԤȡ
  ;; ٥ʸꥹȤ2ܤбꤷƤޤ礬
  ;; (:thǤä硢ѱѿϤȤƤϣˤʤäߤˤʤ)
  ;; ᡢ򤼽ѴȤϰۤʤԤ)
  (let* ((nr (tutcode-context-nr-candidates pc))
         (nth (tutcode-context-nth pc))
         (labellen (length tutcode-heading-label-char-list-for-kigou-mode))
         (cur-base (quotient nth labellen))
         (offset
           (- labellen
              (length
                (member ch tutcode-heading-label-char-list-for-kigou-mode))))
         (idx (+ (* cur-base labellen) offset)))
    (if (and (>= idx 0)
             (< idx nr))
      (begin
        (tutcode-context-set-nth! pc idx)
        (tutcode-commit pc
          (tutcode-prepare-commit-string-for-kigou-mode pc))
        #t)
      (eq? tutcode-commit-candidate-by-label-key 'always))))

;;; ҥȥϤθˡꤵ줿٥ʸбꤹ
;;; @param ch Ϥ줿٥ʸ
;;; @return ꤷ#t
(define (tutcode-commit-by-label-key-for-history pc ch)
  (let* ((nr (tutcode-context-nr-candidates pc))
         (nth (tutcode-context-nth pc))
         (idx
          (tutcode-get-idx-by-label-key ch nth
            tutcode-nr-candidate-max-for-history
            tutcode-nr-candidate-max-for-history
            tutcode-heading-label-char-list-for-history)))
    (if (and (>= idx 0)
             (< idx nr))
      (begin
        (tutcode-context-set-nth! pc idx)
        (let ((str (tutcode-prepare-commit-string-for-history pc)))
          (tutcode-commit pc str)
          (tutcode-flush pc)
          (tutcode-check-auto-help-window-begin pc (string-to-list str) ()))
        #t)
      (eq? tutcode-commit-candidate-by-label-key 'always))))

;;; 䴰/ͽ¬ϸɽˡꤵ줿٥ʸбꤹ
;;; @param ch Ϥ줿٥ʸ
;;; @param mode tutcode-context-predicting
;;; @return ꤷ#t
(define (tutcode-commit-by-label-key-for-prediction pc ch mode)
  (let*
    ((nth (tutcode-context-prediction-index pc))
     (page-limit (tutcode-context-prediction-page-limit pc))
     (nr-in-page (tutcode-context-prediction-nr-in-page pc))
     (idx
      (tutcode-get-idx-by-label-key ch nth page-limit nr-in-page
        tutcode-heading-label-char-list-for-prediction))
     (nr (tutcode-lib-get-nr-predictions pc))
     ;; XXX:ϸ쥬ɤΥڡ¿硢
     ;;     䴰ϥ롼פ2ܰʹߤβǽ(ɽcandwinǤʤ)
     (i (if (zero? nr) -1 (remainder idx nr))))
    (if (>= i 0)
      (begin
        (case mode
          ((tutcode-predicting-bushu)
            (tutcode-do-commit-prediction-for-bushu pc i))
          ((tutcode-predicting-interactive-bushu)
            (tutcode-do-commit-prediction-for-interactive-bushu pc i))
          ((tutcode-predicting-completion)
            (tutcode-do-commit-prediction pc i #t))
          (else
            (tutcode-do-commit-prediction pc i #f)))
        #t)
      (eq? tutcode-commit-candidate-by-label-key 'always))))

(define (tutcode-get-prediction-string pc idx)
  (tutcode-lib-get-nth-prediction pc idx))

(define (tutcode-learn-prediction-string pc idx completion?)
  (tutcode-lib-commit-nth-prediction pc idx completion?))

;;; 䴰/ͽ¬ϸꤹ
;;; @param completion? 䴰ɤ
(define (tutcode-do-commit-prediction pc idx completion?)
  (let ((str (tutcode-get-prediction-string pc idx)))
    (tutcode-learn-prediction-string pc idx completion?)
    (tutcode-reset-candidate-window pc)
    (tutcode-commit pc str)
    (tutcode-flush pc)
    (tutcode-check-auto-help-window-begin pc (string-to-list str) ())))

;;; Ѵͽ¬ϸꤹ
(define (tutcode-do-commit-prediction-for-bushu pc idx)
  (let ((str (tutcode-get-prediction-string pc idx)))
    (tutcode-reset-candidate-window pc)
    (tutcode-bushu-commit pc str)))

;;; ŪѴθꤹ
(define (tutcode-do-commit-prediction-for-interactive-bushu pc idx)
  (let ((str (tutcode-get-prediction-string pc idx)))
    (tutcode-reset-candidate-window pc)
    (tutcode-commit pc str)
    (tutcode-flush pc)
    (tutcode-check-auto-help-window-begin pc (string-to-list str) ())))

;;; 򤼽Ѵ񤫤顢򤵤Ƥ롣
(define (tutcode-purge-candidate pc)
  (let ((res (skk-lib-purge-candidate
               tutcode-dic
               (cons (string-list-concat (tutcode-context-head pc)) "")
               ""
               (tutcode-context-nth pc)
               #f)))
    (if res
      (tutcode-save-personal-dictionary #t))
    (tutcode-reset-candidate-window pc)
    (tutcode-flush pc)
    res))

;;; 򤼽Ѵɤ/Ѵ(ʸꥹhead)ʸɲä롣
;;; @param pc ƥȥꥹ
;;; @param str ɲäʸ
(define (tutcode-append-string pc str)
  (if (and str (string? str))
    (tutcode-context-set-head! pc
      (cons str
        (tutcode-context-head pc)))))

;;; commitѤʸꥹcommit-strsʸɲä롣
;;; @param str ɲäʸ
(define (tutcode-append-commit-string pc str)
  (if (and str (string? str))
    (let* ((strlist (string-to-list str)) ; strʣʸξ礢
           (commit-strs (tutcode-context-commit-strs pc))
           (new-strs (append strlist commit-strs)))
      (tutcode-context-set-commit-strs! pc
        (if (> (length new-strs) tutcode-completion-chars-max)
          (take new-strs tutcode-completion-chars-max)
          new-strs)))))

;;; commitʸꥹhistoryʸɲä롣
;;; @param str ɲäʸ
(define (tutcode-append-history pc str)
  (let* ((history (tutcode-context-history pc))
         (new-history (cons str (delete str history))))
    (tutcode-context-set-history! pc
      (if (> (length new-history) tutcode-history-size)
        (take new-history tutcode-history-size)
        new-history))))

;;; 򤼽Ѵ򳫻Ϥ
;;; @param yomi Ѵоݤɤ(ʸεսꥹ)
;;; @param suffix ѤѴԤγѸ(ʸεսꥹ)
;;; @param autocommit? 䤬1Ĥξ˼ưŪ˳ꤹ뤫ɤ
;;; @param recursive-learning? 䤬̵˺ƵϿ⡼ɤ뤫ɤ
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-begin-conversion pc yomi suffix autocommit?
          recursive-learning?)
  (let*
    ((yomi-str (string-list-concat yomi))
     (res (and (symbol-bound? 'skk-lib-get-entry)
               (skk-lib-get-entry tutcode-dic yomi-str "" "" #f)
               (skk-lib-get-nr-candidates tutcode-dic yomi-str "" "" #f))))
    (if res
      (begin
        (tutcode-context-set-head! pc yomi)
        (tutcode-context-set-mazegaki-suffix! pc suffix)
        (tutcode-context-set-nth! pc 0)
        (tutcode-context-set-nr-candidates! pc res)
        (tutcode-context-set-state! pc 'tutcode-state-converting)
        (if (and autocommit? (= res 1))
          ;; 䤬1ĤʤϼưŪ˳ꤹ롣
          ;; (Ͽtutcode-register-candidate-key򲡤Ū˳Ϥ)
          (tutcode-commit-with-auto-help pc)
          (begin
            (tutcode-check-candidate-window-begin pc)
            (if (eq? (tutcode-context-candidate-window pc)
                     'tutcode-candidate-window-converting)
              (tutcode-select-candidate pc 0))))
        #t)
      ;; ̵
      (begin
        (if recursive-learning?
          (begin
            (tutcode-context-set-head! pc yomi)
            (tutcode-context-set-mazegaki-suffix! pc suffix)
            (tutcode-context-set-state! pc 'tutcode-state-converting)
            (tutcode-setup-child-context pc 'tutcode-child-type-editor)))
          ;(tutcode-flush pc) ; flushϤʸ󤬾äƤä
        #f))))

;;; ַ򤼽Ѵ򳫻Ϥ(Ѥˤб)
;;; @param inflection? ѤθԤɤ
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-begin-conversion-with-inflection pc inflection?)
  (let*
    ((yomi (tutcode-context-head pc))
     (yomi-len (length yomi)))
    (tutcode-context-set-postfix-yomi-len! pc 0)
    (tutcode-context-set-mazegaki-yomi-len-specified! pc yomi-len)
    (tutcode-context-set-mazegaki-yomi-all! pc yomi)
    (if (or (not inflection?)
            (not tutcode-mazegaki-enable-inflection?)
            (tutcode-mazegaki-inflection? yomi)) ; Ū""դϤ줿
      (tutcode-begin-conversion pc yomi () #t tutcode-use-recursive-learning?)
      (or
        (tutcode-begin-conversion pc yomi () #f #f)
        ;; ѤȤƺƸ
          (or
            (tutcode-mazegaki-inflection-relimit-right pc yomi-len yomi-len #f)
            ;; ѤʤȤƺƵؽ
            (and tutcode-use-recursive-learning?
              (begin
                (tutcode-begin-conversion pc yomi () #t
                  tutcode-use-recursive-learning?))))))))

;;; Ѥַ򤼽Ѵ򳫻Ϥ
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-begin-mazegaki-inflection-conversion pc)
  (let*
    ((yomi (tutcode-context-head pc))
     (yomi-len (length yomi)))
    (tutcode-context-set-postfix-yomi-len! pc 0)
    (tutcode-context-set-mazegaki-yomi-len-specified! pc yomi-len)
    (tutcode-context-set-mazegaki-yomi-all! pc yomi)
    (if (tutcode-mazegaki-inflection? yomi) ; Ū""դϤ줿
      (tutcode-begin-conversion pc yomi () #t tutcode-use-recursive-learning?)
      (tutcode-mazegaki-inflection-relimit-right pc yomi-len yomi-len #f))))

;;; Ϥ줿ɤбꤹ
;;; @param str-list ɡϤ줿ʸΥꥹ(ս)
(define (tutcode-begin-kanji-code-input pc str-list)
  (let ((kanji (ja-kanji-code-input str-list)))
    (if (and kanji (> (string-length kanji) 0))
      (begin
        (tutcode-commit pc kanji)
        (tutcode-flush pc)
        (tutcode-undo-prepare pc 'tutcode-state-code kanji str-list)
        (tutcode-check-auto-help-window-begin pc (list kanji) ())))))

;;; ҥƥȤ롣
;;; @param type 'tutcode-child-type-editor'tutcode-child-type-dialog
(define (tutcode-setup-child-context pc type)
  (let ((cpc (tutcode-context-new (tutcode-context-uc pc)
              (tutcode-context-im pc))))
    (tutcode-context-set-child-context! pc cpc)
    (tutcode-context-set-child-type! pc type)
    (tutcode-context-set-parent-context! cpc pc)
    (if (eq? type 'tutcode-child-type-dialog)
      (tutcode-context-set-state! cpc 'tutcode-state-off)
      (tutcode-context-set-state! cpc 'tutcode-state-on))
    cpc))

;;; ϥ⡼ɤ򳫻Ϥ롣
;;; @param pc ƥȥꥹ
(define (tutcode-begin-kigou-mode pc)
  (tutcode-context-set-nth! pc 0)
  (tutcode-context-set-nr-candidates! pc (length tutcode-kigoudic))
  (tutcode-context-set-state! pc 'tutcode-state-kigou)
  (tutcode-check-candidate-window-begin pc)
  (if (eq? (tutcode-context-candidate-window pc)
           'tutcode-candidate-window-kigou)
    (tutcode-select-candidate pc 0)))

;;; ҥȥϤθɽ򳫻Ϥ
(define (tutcode-begin-history pc)
  (if (and (> tutcode-history-size 0)
           (pair? (tutcode-context-history pc)))
    (begin
      (tutcode-context-set-nth! pc 0)
      (tutcode-context-set-nr-candidates! pc
        (length (tutcode-context-history pc)))
      (tutcode-context-set-state! pc 'tutcode-state-history)
      (tutcode-check-candidate-window-begin pc)
      (if (eq? (tutcode-context-candidate-window pc)
               'tutcode-candidate-window-history)
        (tutcode-select-candidate pc 0)))))

;;; 2ȥϥ⡼(tutcode-kigou-rule)tutcode-ruleڤؤԤ
;;; @param pc ƥȥꥹ
(define (tutcode-toggle-kigou2-mode pc)
  (if tutcode-use-kigou2-mode?
    (let ((tmp-rkc (tutcode-context-rk-context pc))
          (tmp-stroke-help? tutcode-use-stroke-help-window?))
      (tutcode-context-set-rk-context! pc
        (tutcode-context-rk-context-another pc))
      (tutcode-context-set-rk-context-another! pc tmp-rkc)
      (set! tutcode-use-stroke-help-window?
        tutcode-use-stroke-help-window-another?)
      (set! tutcode-use-stroke-help-window-another? tmp-stroke-help?)
      (tutcode-context-set-guide-chars! pc ()))))

;;; 򤼽Ѵϥ⡼ɡҥȥϥ⡼ɻ
;;; 䥦ɥɽ򳫻Ϥ
(define (tutcode-check-candidate-window-begin pc)
  (if (and (eq? (tutcode-context-candidate-window pc)
                'tutcode-candidate-window-off)
           tutcode-use-candidate-window?
           (>= (tutcode-context-nth pc) (- tutcode-candidate-op-count 1)))
    (let ((state (tutcode-context-state pc)))
      (tutcode-activate-candidate-window pc
        (case state
          ((tutcode-state-kigou) 'tutcode-candidate-window-kigou)
          ((tutcode-state-history) 'tutcode-candidate-window-history)
          (else 'tutcode-candidate-window-converting))
        tutcode-candidate-window-activate-delay-for-mazegaki
        (tutcode-context-nr-candidates pc)
        (case state
          ((tutcode-state-kigou) tutcode-nr-candidate-max-for-kigou-mode)
          ((tutcode-state-history) tutcode-nr-candidate-max-for-history)
          (else tutcode-nr-candidate-max))))))

;;; 䥦ɥɽ
;;; @param type 䥦ɥ
;;; @param delay 䥦ɥɽޤǤԤ[s]
;;; @param nr delay˷׻-1
;;; @param display-limit ڡ
(define (tutcode-activate-candidate-window pc type delay nr display-limit)
  (tutcode-context-set-candidate-window! pc type)
  (tutcode-context-set-candwin-delay-selected-index! pc -1)
  (if (tutcode-candidate-window-enable-delay? pc delay)
    (begin
      (tutcode-context-set-candwin-delay-waiting! pc #t)
      (im-delay-activate-candidate-selector pc delay))
    (begin
      (tutcode-context-set-candwin-delay-waiting! pc #f)
      (if (and tutcode-use-pseudo-table-style?
               (>= nr 0))
        (let ((pnr-pdl (tutcode-pseudo-table-style-setup pc nr display-limit)))
          (im-activate-candidate-selector pc (car pnr-pdl) (cadr pnr-pdl)))
        (im-activate-candidate-selector pc nr display-limit)))))

;;; 䥦ɥٱɽԤɤ֤
;;; @param delay ٱ֡0ξٱɽϤʤ
(define (tutcode-candidate-window-enable-delay? pc delay)
  (and tutcode-candidate-window-use-delay?
       (im-delay-activate-candidate-selector-supported? pc)
       (> delay 0)))

;;; ɽɽѤκǽΥڡθꥹȤ
;;; pseudo-table-candsset
;;; @param nr 
;;; @param display-limit ڡ
;;; @return '(nr display-limit) ɽθꥹȤθȥڡ
(define (tutcode-pseudo-table-style-setup pc nr display-limit)
  (if (= nr 0)
    '(0 0)
    (let* ((pcands (tutcode-pseudo-table-style-make-page pc 0 display-limit nr))
           (pdl (length pcands))
           (nr-page (+ (quotient nr display-limit)
                       (if (= 0 (remainder nr display-limit)) 0 1)))
           (pnr (* nr-page pdl))
           (pcands-all (make-vector nr-page #f)))
      (vector-set! pcands-all 0 pcands)
      (tutcode-context-set-pseudo-table-cands! pc pcands-all)
      (list pnr pdl))))

;;; ɽɽѤοڡθꥹȤ֤
(define (tutcode-pseudo-table-style-make-new-page pc)
  (let*
    ((dl-nr-nth (tutcode-candwin-limit-nr-nth pc))
     (dl (list-ref dl-nr-nth 0))
     (nr (list-ref dl-nr-nth 1))
     (nth (list-ref dl-nr-nth 2))
     (page (quotient nth dl))
     (start-index (* page dl))
     (end-index (+ start-index dl)))
    (tutcode-pseudo-table-style-make-page pc start-index end-index nr)))

;;; 䥦ɥɽθξ֤
;;; @return (<ڡ(display-limit)> <> <θֹ>)
(define (tutcode-candwin-limit-nr-nth pc)
  (cond
    ((eq? (tutcode-context-state pc) 'tutcode-state-kigou)
      (list tutcode-nr-candidate-max-for-kigou-mode
            (tutcode-context-nr-candidates pc)
            (tutcode-context-nth pc)))
    ((eq? (tutcode-context-state pc) 'tutcode-state-history)
      (list tutcode-nr-candidate-max-for-history
            (tutcode-context-nr-candidates pc)
            (tutcode-context-nth pc)))
    ((eq? (tutcode-context-candidate-window pc)
          'tutcode-candidate-window-predicting)
      (list (tutcode-context-prediction-page-limit pc)
            (tutcode-context-prediction-nr-all pc)
            (tutcode-context-prediction-index pc)))
    ((eq? (tutcode-context-candidate-window pc)
          'tutcode-candidate-window-stroke-help)
      (list tutcode-nr-candidate-max-for-kigou-mode
            (length (tutcode-context-stroke-help pc))
            0))
    ((eq? (tutcode-context-candidate-window pc)
          'tutcode-candidate-window-auto-help)
      (list tutcode-nr-candidate-max-for-kigou-mode
            (length (tutcode-context-auto-help pc))
            0))
    ((eq? (tutcode-context-state pc) 'tutcode-state-interactive-bushu)
      (list (tutcode-context-prediction-page-limit pc)
            (tutcode-context-prediction-nr-all pc)
            (tutcode-context-prediction-index pc)))
    ((eq? (tutcode-context-candidate-window pc)
          'tutcode-candidate-window-converting)
      (list tutcode-nr-candidate-max
            (tutcode-context-nr-candidates pc)
            (tutcode-context-nth pc)))
    (else
      (list tutcode-nr-candidate-max 0 0))))

;;; ɽɽѤλꤷֹΥڡθꥹȤ֤
;;; @param start-index ֹ
;;; @param end-index λֹ
(define (tutcode-pseudo-table-style-make-page pc start-index end-index nr)
  (let ((cands
          (let loop
            ((idx start-index)
             (cands ()))
            (if (or (>= idx end-index) (>= idx nr))
              (reverse cands)
              (loop
                (+ idx 1)
                (cons (tutcode-get-candidate-handler-internal pc idx 0)
                      cands))))))
    ;; ǽΥڡʳϡȾʬ֥åǤάʤ
    ;; (ϺǽΥڡθȤ˷׻Τǡ
    ;; ǽΥڡǲȾʬ֥åͭʤΤˡǸΥڡǾάȡ
    ;; 䤬­ʤʤäget-candidate˥顼ˤʤ)
    (tutcode-table-in-vertical-candwin cands (= start-index 0))))

;;; ꥹȾθֹ򡢵ɽθֹѴ
(define (tutcode-pseudo-table-style-candwin-index pc idx)
  (let* ((vec (tutcode-context-pseudo-table-cands pc))
         (display-limit (length (vector-ref vec 0)))
         (page-limit (list-ref (tutcode-candwin-limit-nr-nth pc) 0))
         (page (quotient idx page-limit)))
    (* page display-limit))) ; XXX:candwinΥڡñ̤Τб

;;; ɽθֹ򡢸ꥹȾθֹѴ
(define (tutcode-pseudo-table-style-scm-index pc idx)
  (let* ((vec (tutcode-context-pseudo-table-cands pc))
         (display-limit (length (vector-ref vec 0)))
         (page-limit (list-ref (tutcode-candwin-limit-nr-nth pc) 0))
         (page (quotient idx display-limit)))
    (* page page-limit))) ; XXX:candwinΥڡñ̤Τб

;;; 䥦ɥǸ򤹤
;;; @param idx 򤹤Υǥåֹ
(define (tutcode-select-candidate pc idx)
  (if (tutcode-context-candwin-delay-waiting pc)
    ;; ٱɽԤcandwin̤Τim-select-candidateSEGV
    ;; (XXX (uim api-doc˹碌)candwin¦н褷⤷ʤ
    ;;      shift-pageȤκ߻η׻ݤʤΤǡȤꤢscm¦ǡ)
    (tutcode-context-set-candwin-delay-selected-index! pc idx)
    (tutcode-pseudo-table-select-candidate pc idx)))

;;; 䥦ɥǸ򤹤(ɽɽб)
;;; @param idx 򤹤Υǥåֹ
(define (tutcode-pseudo-table-select-candidate pc idx)
  (if tutcode-use-pseudo-table-style?
    (im-select-candidate pc (tutcode-pseudo-table-style-candwin-index pc idx))
    (im-select-candidate pc idx)))

;;; ۸פɽꥹȤä֤
;;; @return ꥹ(get-candidate-handlerѷ)
(define (tutcode-stroke-help-make pc)
  (let*
    ((rkc (tutcode-context-rk-context pc))
     (seq (rk-context-seq rkc))
     (seqlen (length seq))
     (seq-rev (reverse seq))
     (guide-seqs
      (and
        (pair? seq)
        (pair? (tutcode-context-guide-chars pc))
        (rk-lib-find-partial-seqs seq-rev (tutcode-context-guide-chars pc))))
     (guide-alist (tutcode-stroke-help-guide-update-alist () seqlen
                    (if (pair? guide-seqs) guide-seqs ())))
     ;; :(("v" "+") ("a" "+") ("r" "+"))
     (guide-candcombined
      (map
        (lambda (elem)
          (list (car elem) (string-list-concat (cdr elem))))
        guide-alist))
     ;; stroke-help. :(("k" "") ("i" "") ("g" "*£"))
     (label-cand-alist
      (if (or tutcode-use-stroke-help-window?
              (and
                (pair? guide-seqs)
                (eq? tutcode-stroke-help-with-kanji-combination-guide 'full)))
        (let*
          ((rule (rk-context-rule rkc))
           (ret (rk-lib-find-partial-seqs seq-rev rule))
           (katakana? (tutcode-context-katakana-mode? pc))
           (label-cand-alist
            (if (null? seq) ; tutcode-ruleʤƺ٤Τǥå
              (cond
                ((not tutcode-show-stroke-help-window-on-no-input?)
                  ())
                ((tutcode-kigou2-mode? pc)
                  tutcode-kigou-rule-stroke-help-top-page-alist)
                (katakana?
                  (if (not tutcode-stroke-help-top-page-katakana-alist)
                    (set! tutcode-stroke-help-top-page-katakana-alist
                      (tutcode-stroke-help-update-alist
                        () seqlen katakana? ret)))
                  tutcode-stroke-help-top-page-katakana-alist)
                (else
                  (if (not tutcode-stroke-help-top-page-alist)
                    (set! tutcode-stroke-help-top-page-alist
                      (tutcode-stroke-help-update-alist
                        () seqlen katakana? ret)))
                  tutcode-stroke-help-top-page-alist))
              (tutcode-stroke-help-update-alist () seqlen katakana? ret))))
          ;; ɽʸ򡢽ϸ쥬(+)դʸ֤
          (for-each
            (lambda (elem)
              (let*
                ((label (car elem))
                 (label-cand (assoc label label-cand-alist)))
                (if label-cand
                  (set-cdr! label-cand (cdr elem)))))
            guide-candcombined)
          label-cand-alist)
        (if (eq? tutcode-stroke-help-with-kanji-combination-guide 'guide-only)
          guide-candcombined
          ()))))
    (if (null? label-cand-alist)
      ()
      (map
        (lambda (elem)
          (list (cadr elem) (car elem) ""))
        (reverse label-cand-alist)))))

;;; ۸פɽ򳫻Ϥ
(define (tutcode-check-stroke-help-window-begin pc)
  (if (eq? (tutcode-context-candidate-window pc) 'tutcode-candidate-window-off)
    (if (tutcode-candidate-window-enable-delay? pc
          tutcode-candidate-window-activate-delay-for-stroke-help)
      ;; XXX:ɽʤˤϥޤưʤ褦ˤȤ
      (tutcode-activate-candidate-window pc
        'tutcode-candidate-window-stroke-help
        tutcode-candidate-window-activate-delay-for-stroke-help
        -1 -1)
      (let ((stroke-help (tutcode-stroke-help-make pc)))
        (if (pair? stroke-help)
          (begin
            (tutcode-context-set-stroke-help! pc stroke-help)
            (tutcode-activate-candidate-window pc
              'tutcode-candidate-window-stroke-help
              0
              (length stroke-help)
              tutcode-nr-candidate-max-for-kigou-mode)))))))

;;; ̾θ䥦ɥˡɽǸɽ뤿ˡ
;;; ɽ1ʬϢ뤷Ѵ롣
;;; (ɽ䥦ɥ̤бǡĤ˸¤٤candwinѡ
;;;  uim-el(setq uim-candidate-display-inline t)ξ)
;;; @param cands ("ɽʸ" "٥ʸ" "")Υꥹ
;;; @param omit-empty-block? ɽβȾʬ(եȥΰ)ξ˾ά뤫
;;; @return ѴΥꥹȡ
;;;  :(("*|*|*|*|*||*|*|*|*|*||" "q" "") ...)
(define (tutcode-table-in-vertical-candwin cands omit-empty-block?)
  (let*
    ((layout (if (null? uim-candwin-prog-layout)
                uim-candwin-prog-layout-qwerty-jis
                uim-candwin-prog-layout))
     (vecsize (length layout))
     (vec (make-vector vecsize #f)))
    (for-each
      (lambda (elem)
        (let
          ((k (list-index (lambda (e) (string=? e (cadr elem))) layout)))
          (if k
            (vector-set! vec k (car elem)))))
      cands)
    (let*
      ;; ɽβȾʬ(եȥΰ)ξϾȾʬȤ
      ((vecmax
        (if (not omit-empty-block?)
          vecsize
          (let loop ((k (* 13 4)))
            (if (>= k vecsize)
              (* 13 4)
              (if (string? (vector-ref vec k))
                vecsize
                (loop (+ k 1)))))))
       ;; κĴ٤
       (width-list0
        (let colloop
          ((col 12)
           (width-list ()))
          (if (negative? col)
            width-list
            (colloop
              (- col 1)
              (cons
                (let rowloop
                  ((k col)
                   (maxwidth -1))
                  (if (>= k vecmax)
                    maxwidth
                    (let*
                      ((elem (vector-ref vec k))
                       (width (if (string? elem) (string-length elem) -1)))
                      (rowloop
                        (+ k 13)
                        (if (> width maxwidth)
                          width
                          maxwidth)))))
                width-list)))))
       ;; ɽαü֥åξɽʤ
       (colmax
        (if (any (lambda (x) (> x -1)) (take-right width-list0 3)) 13 10))
       (width-list (map (lambda (x) (if (< x 2) 2 x)) width-list0))
       ;; ٥ϡƹԤǡǽȤΤбΤ
       (labels
        (let rowloop
          ((row 0)
           (labels ()))
          (if (>= (* row 13) vecmax)
            (reverse labels)
            (rowloop
              (+ row 1)
              (cons
                (let colloop
                  ((col 0))
                  (let ((k (+ (* row 13) col)))
                    (cond
                      ((>= col colmax)
                        (list-ref layout (* row 13)))
                      ((string? (vector-ref vec k))
                        (list-ref layout k))
                      (else
                        (colloop (+ col 1))))))
                labels))))))
      ;; ƹϢ뤷Ƹʸ
      (let rowloop
        ((table (take! (vector->list vec) vecmax))
         (k 0)
         (res ()))
        (if (null? table)
          (reverse res)
          (let*
            ((line (take table 13))
             (line-sep
              (cdr
                (let colloop
                  ((col (- colmax 1))
                   (line-sep (if (= colmax 10) '("||") ())))
                  (if (negative? col)
                    line-sep
                    (colloop
                      (- col 1)
                      (append
                        (let*
                          ((elem (list-ref line col))
                           (elemlen (if (string? elem) (string-length elem) 0))
                           (width (list-ref width-list col))
                           (strlist
                            (if (zero? elemlen)
                              (make-list width " ")
                              ;; ֤
                              (letrec
                                ((padleft
                                  (lambda (pad strlist)
                                    (if (<= pad 0)
                                      strlist
                                      (padright
                                        (- pad 1)
                                        (cons " " strlist)))))
                                 (padright
                                  (lambda (pad strlist)
                                    (if (<= pad 0)
                                      strlist
                                      (padleft
                                        (- pad 1)
                                        (append strlist (list " ")))))))
                                (padleft (- width elemlen) (list elem))))))
                          (cons
                            (if (or (= col 5) (= col 10))
                              "||" ; ֥åڤΩ
                              "|")
                            strlist))
                        line-sep))))))
             (cand (apply string-append line-sep))
             (candlabel (list cand (list-ref labels (quotient k 13)) "")))
            (rowloop
              (drop table 13)
              (+ k 13)
              (cons candlabel res))))))))

;;; ۸פɽԤɤŪڤؤ(ȥ)
;;; (ɽܤʤΤǡǤ¤äȤɽ)
(define (tutcode-toggle-stroke-help pc)
  (if tutcode-use-stroke-help-window?
    (begin
      (set! tutcode-use-stroke-help-window? #f)
      (tutcode-reset-candidate-window pc))
    (set! tutcode-use-stroke-help-window? #t)))

;;; ۸ɽѥǡ
;;; @param label-cand-alist ɽѥǡ
;;;  :(("k" "") ("i" "") ("g" "*£"))
;;; @param seqlen ܤΥȥоݤȤ뤫
;;; @param katakana? ʥ⡼ɤɤ
;;; @param rule-list rk-rule
;;; @return label-cand-alist
(define (tutcode-stroke-help-update-alist
         label-cand-alist seqlen katakana? rule-list)
  (if (null? rule-list)
    label-cand-alist
    (tutcode-stroke-help-update-alist
      (tutcode-stroke-help-update-alist-with-rule
        label-cand-alist seqlen katakana? (car rule-list))
      seqlen katakana? (cdr rule-list))))

;;; ۸ɽѥǡ:Ĥruleȿǡ
;;; @param label-cand-alist ɽѥǡ
;;; @param seqlen ܤΥȥоݤȤ뤫
;;; @param katakana? ʥ⡼ɤɤ
;;; @param rule rk-ruleΰĤrule
;;; @return label-cand-alist
(define (tutcode-stroke-help-update-alist-with-rule
         label-cand-alist seqlen katakana? rule)
  (let* ((label (list-ref (caar rule) seqlen))
         (label-cand (assoc label label-cand-alist)))
    ;; ˳ƤƤ鲿⤷ʤruleǺǽ˽иʸ
    (if label-cand
      label-cand-alist
      (let*
        ((candlist (cadr rule))
         ;; ?
         (has-next? (> (length (caar rule)) (+ seqlen 1)))
         (cand
          (or
            (and (not (null? (cdr candlist)))
                 katakana?
                 (cadr candlist))
            (car candlist)))
         (candstr
          (cond
            ((string? cand)
              cand)
            ((symbol? cand)
              (case cand
                ((tutcode-mazegaki-start) "")
                ((tutcode-latin-conv-start) "/")
                ((tutcode-kanji-code-input-start) "")
                ((tutcode-history-start) "")
                ((tutcode-bushu-start) "")
                ((tutcode-interactive-bushu-start) "")
                ((tutcode-postfix-bushu-start) "")
                ((tutcode-selection-mazegaki-start) "s")
                ((tutcode-selection-mazegaki-inflection-start) "s")
                ((tutcode-postfix-mazegaki-start) "")
                ((tutcode-postfix-mazegaki-1-start) "1")
                ((tutcode-postfix-mazegaki-2-start) "2")
                ((tutcode-postfix-mazegaki-3-start) "3")
                ((tutcode-postfix-mazegaki-4-start) "4")
                ((tutcode-postfix-mazegaki-5-start) "5")
                ((tutcode-postfix-mazegaki-6-start) "6")
                ((tutcode-postfix-mazegaki-7-start) "7")
                ((tutcode-postfix-mazegaki-8-start) "8")
                ((tutcode-postfix-mazegaki-9-start) "9")
                ((tutcode-postfix-mazegaki-inflection-start) "")
                ((tutcode-postfix-mazegaki-inflection-1-start) "1")
                ((tutcode-postfix-mazegaki-inflection-2-start) "2")
                ((tutcode-postfix-mazegaki-inflection-3-start) "3")
                ((tutcode-postfix-mazegaki-inflection-4-start) "4")
                ((tutcode-postfix-mazegaki-inflection-5-start) "5")
                ((tutcode-postfix-mazegaki-inflection-6-start) "6")
                ((tutcode-postfix-mazegaki-inflection-7-start) "7")
                ((tutcode-postfix-mazegaki-inflection-8-start) "8")
                ((tutcode-postfix-mazegaki-inflection-9-start) "9")
                ((tutcode-selection-katakana-start) "s")
                ((tutcode-postfix-katakana-start) "")
                ((tutcode-postfix-katakana-0-start) "0")
                ((tutcode-postfix-katakana-1-start) "1")
                ((tutcode-postfix-katakana-2-start) "2")
                ((tutcode-postfix-katakana-3-start) "3")
                ((tutcode-postfix-katakana-4-start) "4")
                ((tutcode-postfix-katakana-5-start) "5")
                ((tutcode-postfix-katakana-6-start) "6")
                ((tutcode-postfix-katakana-7-start) "7")
                ((tutcode-postfix-katakana-8-start) "8")
                ((tutcode-postfix-katakana-9-start) "9")
                ((tutcode-postfix-katakana-exclude-1) "1")
                ((tutcode-postfix-katakana-exclude-2) "2")
                ((tutcode-postfix-katakana-exclude-3) "3")
                ((tutcode-postfix-katakana-exclude-4) "4")
                ((tutcode-postfix-katakana-exclude-5) "5")
                ((tutcode-postfix-katakana-exclude-6) "6")
                ((tutcode-postfix-katakana-shrink-1) "1")
                ((tutcode-postfix-katakana-shrink-2) "2")
                ((tutcode-postfix-katakana-shrink-3) "3")
                ((tutcode-postfix-katakana-shrink-4) "4")
                ((tutcode-postfix-katakana-shrink-5) "5")
                ((tutcode-postfix-katakana-shrink-6) "6")
                ((tutcode-selection-kanji2seq-start) "/s")
                ((tutcode-postfix-kanji2seq-start) "/@")
                ((tutcode-postfix-kanji2seq-1-start) "/1")
                ((tutcode-postfix-kanji2seq-2-start) "/2")
                ((tutcode-postfix-kanji2seq-3-start) "/3")
                ((tutcode-postfix-kanji2seq-4-start) "/4")
                ((tutcode-postfix-kanji2seq-5-start) "/5")
                ((tutcode-postfix-kanji2seq-6-start) "/6")
                ((tutcode-postfix-kanji2seq-7-start) "/7")
                ((tutcode-postfix-kanji2seq-8-start) "/8")
                ((tutcode-postfix-kanji2seq-9-start) "/9")
                ((tutcode-selection-seq2kanji-start) "s")
                ((tutcode-clipboard-seq2kanji-start) "c")
                ((tutcode-postfix-seq2kanji-start) "@")
                ((tutcode-postfix-seq2kanji-1-start) "1")
                ((tutcode-postfix-seq2kanji-2-start) "2")
                ((tutcode-postfix-seq2kanji-3-start) "3")
                ((tutcode-postfix-seq2kanji-4-start) "4")
                ((tutcode-postfix-seq2kanji-5-start) "5")
                ((tutcode-postfix-seq2kanji-6-start) "6")
                ((tutcode-postfix-seq2kanji-7-start) "7")
                ((tutcode-postfix-seq2kanji-8-start) "8")
                ((tutcode-postfix-seq2kanji-9-start) "9")
                ((tutcode-auto-help-redisplay) "")
                ((tutcode-help) "")
                ((tutcode-help-clipboard) "?c")
                ((tutcode-undo) "")
                (else cand)))
            ((procedure? cand)
              "")))
         (cand-hint
          (or
            ;; ξhint-mark(*)դ
            (and has-next? (string-append tutcode-hint-mark candstr))
            candstr)))
        (cons (list label cand-hint) label-cand-alist)))))

;;; ۸׾νϸ쥬ɤɽ˻Ȥalist˴ɲä롣
;;; @param kanji-stroke ɲäȥȥΥꥹȡ
;;; : ((("," "r"))(""))
(define (tutcode-stroke-help-guide-add-kanji pc kanji-stroke)
  (let ((chars (tutcode-context-guide-chars pc)))
    (if (not (member kanji-stroke chars))
      (tutcode-context-set-guide-chars! pc (cons kanji-stroke chars)))))

;;; ۸׾νϸ쥬ɤɽ˻Ȥalist򹹿롣
;;; alistϰʲΤ褦˥٥ʸɽʸΥꥹ(ս)
;;; : (("v" "+" "") ("a" "+" "") ("r" "+" ""))
;;; @param label-cands-alist alist
;;; @param seqlen ܤΥȥоݤȤ뤫
;;; @param rule-list rk-rule
;;; @return νϸ쥬alist
(define (tutcode-stroke-help-guide-update-alist
         label-cands-alist seqlen rule-list)
  (if (null? rule-list)
    label-cands-alist
    (tutcode-stroke-help-guide-update-alist
      (tutcode-stroke-help-guide-update-alist-with-rule
        label-cands-alist seqlen (car rule-list))
      seqlen (cdr rule-list))))

;;; ۸׾νϸ쥬:оݤ1ʸ򡢽ϸ쥬alistɲä롣
;;; @param label-cands-alist alist
;;; @param seqlen ܤΥȥоݤȤ뤫
;;; @param rule rk-ruleΰĤrule
;;; @return νϸ쥬alist
(define (tutcode-stroke-help-guide-update-alist-with-rule
         label-cands-alist seqlen rule)
  (let* ((label (list-ref (caar rule) seqlen))
         (label-cand (assoc label label-cands-alist))
         (has-next? (> (length (caar rule)) (+ seqlen 1))) ; ?
         (cand (car (cadr rule))))
    (if label-cand
      (begin
        ;; ˳ƤƤ
        (set-cdr! label-cand (cons cand (cdr label-cand)))
        label-cands-alist)
      (cons
        (if has-next?
          (list label cand tutcode-guide-mark)
          (list label tutcode-guide-end-mark cand))
        label-cands-alist))))

;;; ưإɽΤθꥹȤ롣
;;; ɽθ䥦ɥξϡʲΤ褦ɽ롣
;;; 11Ǹ22Ǹַȡ
;;;          
;;;          3 
;;;  1()   
;;;  2         
;;; 򤼽ѴʣʸַӡפѴϡʲΤ褦ɽ롣
;;;              
;;;  a()         3 
;;;      1()b  c 
;;;      2         
;;; ꤷʸľϤǤʤ硢ñѴϤǤС
;;; ʲΤ褦Ѵˡɽ롣ͫݵ
;;;    
;;;                                        
;;;      
;;;            b                   f       
;;;      
;;;      3                         1(ͫ)   
;;;      
;;;        d   e   2a(ݵӴ)            
;;;    
;;;
;;; tutcode-auto-help-with-real-keys?#tξ(̾θ䥦ɥ)ϡ
;;; ʲΤ褦ɽ롣
;;;   ͫ lns
;;;   ݵ Ӵ nt cbo
;;;
;;; @param strlist ꤷʸΥꥹ(ս)
;;; @param yomilist ѴɤߤʸΥꥹ(ս)
;;; @return ꥹ(get-candidate-handlerѷ)
(define (tutcode-auto-help-make pc strlist yomilist)
  (let*
    ((helpstrlist (lset-difference string=? (reverse strlist) yomilist))
     (label-cands-alist
      (if (not tutcode-auto-help-with-real-keys?)
        ;; ɽξ:(("y" "2" "1") ("t" "3"))
        (tutcode-auto-help-update-stroke-alist
          pc () tutcode-auto-help-cand-str-list helpstrlist)
        ;; ̾ξ:(("" "t" "y" "y"))
        (reverse
          (tutcode-auto-help-update-stroke-alist-normal pc () helpstrlist)))))
    (if (null? label-cands-alist)
      ()
      (map
        (lambda (elem)
          (list (string-list-concat (cdr elem)) (car elem) ""))
        label-cands-alist))))

;;; Ѵ򤼽ѴǳꤷʸǤɽ롣
;;; @param strlist ꤷʸΥꥹ(ս)
;;; @param yomilist ѴɤߤʸΥꥹ(ս)
;;; @param opt-immediate? ٱ̵Ǥɽ뤫ɤ(ץ)
(define (tutcode-check-auto-help-window-begin pc strlist yomilist . opt-immediate?)
  (if (and (eq? (tutcode-context-candidate-window pc)
                'tutcode-candidate-window-off)
           tutcode-use-auto-help-window?)
    (let ((immediate? (:optional opt-immediate? #f)))
      (tutcode-context-set-guide-chars! pc ())
      (if (and (not immediate?)
               (tutcode-candidate-window-enable-delay? pc
                tutcode-candidate-window-activate-delay-for-auto-help))
        (begin
          (tutcode-context-set-auto-help! pc (list 'delaytmp strlist yomilist))
          (tutcode-activate-candidate-window pc
            'tutcode-candidate-window-auto-help
            tutcode-candidate-window-activate-delay-for-auto-help
            -1 -1))
        (let ((auto-help (tutcode-auto-help-make pc strlist yomilist)))
          (if (pair? auto-help)
            (begin
              (tutcode-context-set-auto-help! pc auto-help)
              (tutcode-activate-candidate-window pc
                'tutcode-candidate-window-auto-help
                0
                (length auto-help)
                tutcode-nr-candidate-max-for-kigou-mode))))))))

;;; ֤ľˤʸǤɽ롣
;;; (surrounding text APIȤäƥ֤ľˤʸ)
(define (tutcode-help pc)
  (let ((former-seq (tutcode-postfix-acquire-text pc 1)))
    (if (positive? (length former-seq))
      (tutcode-check-auto-help-window-begin pc former-seq () #t))))

;;; åץܡʸǤɽ롣
;;; (surrounding text APIȤäƥåץܡɤʸ)
(define (tutcode-help-clipboard pc)
  (let*
    ((len (length tutcode-auto-help-cand-str-list))
     (latter-seq (tutcode-clipboard-acquire-text-wo-nl pc len)))
    (if (pair? latter-seq)
      (tutcode-check-auto-help-window-begin pc latter-seq () #t))))

;;; clipboardФϥ󥹢Ѵ򳫻Ϥ
(define (tutcode-begin-clipboard-seq2kanji-conversion pc)
  (let ((lst (tutcode-clipboard-acquire-text pc 'full)))
    (if (pair? lst)
      (let ((str (string-list-concat (tutcode-sequence->kanji-list pc lst))))
        (tutcode-commit pc str)
        (tutcode-undo-prepare pc 'tutcode-state-off str ())))))

;;; åץܡɤʸԤƼ
;;; @param len ʸ
;;; @return ʸΥꥹ(ս)
(define (tutcode-clipboard-acquire-text-wo-nl pc len)
  (let ((latter-seq (tutcode-clipboard-acquire-text pc len)))
    (and (pair? latter-seq)
         (delete "\n" latter-seq))))

;;; surrounding text APIȤäƥåץܡɤʸ
;;; @param len ʸ
;;; @return ʸΥꥹ(ս)Ǥʤ#f
(define (tutcode-clipboard-acquire-text pc len)
  (and-let*
    ((ustr (im-acquire-text pc 'clipboard 'beginning 0 len))
     (latter (ustr-latter-seq ustr))
     (latter-seq (and (pair? latter) (string-to-list (car latter)))))
    (and (not (null? latter-seq))
         latter-seq)))

;;; ưإפɽɽ˻Ȥalist򹹿롣
;;; alistϰʲΤ褦Ǹ򼨤٥ʸȡɽʸΥꥹ
;;;  :(("y" "2" "1") ("t" "3")) ; ("y" "y" "t")Ȥȥɽ
;;;      
;;;  3 12
;;;      
;;;      
;;; @param label-cands-alist alist
;;; @param kanji-list إɽоݤǤ롢ꤵ줿
;;; @param cand-list إɽ˻ȤǸ򼨤ʸΥꥹ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist pc label-cands-alist
         cand-list kanji-list)
  (if (or (null? cand-list) (null? kanji-list))
    label-cands-alist
    (tutcode-auto-help-update-stroke-alist
      pc
      (tutcode-auto-help-update-stroke-alist-with-kanji
        pc label-cands-alist (car cand-list) (car kanji-list))
      (cdr cand-list) (cdr kanji-list))))

;;; ưإפ̾ɽ˻Ȥalist򹹿롣
;;; alistϰʲΤ褦ʸȡʸϤ뤿ΥΥꥹ(ս)
;;;  :(("" "t" "y" "y"))
;;; @param label-cands-alist alist
;;; @param kanji-list إɽоݤǤ롢ꤵ줿
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-normal pc label-cands-alist
         kanji-list)
  (if (null? kanji-list)
    label-cands-alist
    (tutcode-auto-help-update-stroke-alist-normal
      pc
      (tutcode-auto-help-update-stroke-alist-normal-with-kanji
        pc label-cands-alist (car kanji-list))
      (cdr kanji-list))))

;;; ưإ:оݤ1ʸϤ륹ȥإalistɲä롣
;;; @param label-cands-alist alist
;;; @param cand-list إɽ˻ȤǸ򼨤ʸΥꥹ
;;; @param kanji إɽоʸ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-with-kanji pc label-cands-alist
         cand-list kanji)
  (let*
    ((stime (time))
     (rule (rk-context-rule (tutcode-context-rk-context pc)))
     (stroke (tutcode-reverse-find-seq kanji rule)))
    (if stroke
      (begin
        (tutcode-stroke-help-guide-add-kanji
          pc (list (list stroke) (list kanji)))
        (tutcode-auto-help-update-stroke-alist-with-stroke
          label-cands-alist
          (cons (string-append (caar cand-list) "(" kanji ")") (cdar cand-list))
          stroke))
      (let ((decomposed (tutcode-auto-help-bushu-decompose kanji rule stime)))
        ;; : "" => (((("," "o"))("")) ((("f" "q"))("")))
        (if (not decomposed)
          label-cands-alist
          (let*
            ((bushu-strs (tutcode-auto-help-bushu-composition-strs decomposed))
             (helpstrlist (append (list "(" kanji "") bushu-strs '(")")))
             (helpstr (apply string-append helpstrlist))
             (alist
              (letrec
                ((update-stroke
                  (lambda (lst alist cand-list)
                    (if (or (null? lst) (null? cand-list))
                      (list alist cand-list)
                      (let
                        ((res
                          (if (tutcode-rule-element? (car lst))
                            (list
                              (tutcode-auto-help-update-stroke-alist-with-stroke
                                alist (car cand-list) (caar (car lst)))
                              (cdr cand-list))
                            (update-stroke (car lst) alist cand-list))))
                        (update-stroke (cdr lst) (car res) (cadr res)))))))
                (update-stroke decomposed label-cands-alist
                  (cons
                    (cons
                      (string-append (caar cand-list) helpstr)
                      (cdar cand-list))
                    (cdr cand-list))))))
            (tutcode-auto-help-bushu-composition-add-guide pc decomposed)
            (car alist)))))))

;;; tutcode-ruleǤη((("," "o"))(""))ɤ֤
(define (tutcode-rule-element? x)
  (and
    (pair? x)
    (pair? (car x))
    (pair? (caar x))
    (pair? (cdr x))
    (pair? (cadr x))
    (every string? (caar x))
    (every string? (cadr x))))

;;; ưإ:tutcode-auto-help-bushu-decomposeǸ
;;; ˡǻȤ򡢥оʸɲä롣
;;; @param decomposed tutcode-auto-help-bushu-decompose
(define (tutcode-auto-help-bushu-composition-add-guide pc decomposed)
  (if (not (null? decomposed))
    (begin
      (if (tutcode-rule-element? (car decomposed))
        (tutcode-stroke-help-guide-add-kanji pc (car decomposed))
        (tutcode-auto-help-bushu-composition-add-guide pc (car decomposed)))
      (tutcode-auto-help-bushu-composition-add-guide pc (cdr decomposed)))))

;;; ưإ:tutcode-auto-help-bushu-decomposeǸ
;;; ȥޤˡ顢
;;; ʸΤߤȴФˡ
;;; @param decomposed tutcode-auto-help-bushu-decompose
;;; @return ˡʸꥹ
(define (tutcode-auto-help-bushu-composition-strs decomposed)
  (tutcode-auto-help-bushu-composition-traverse decomposed ()
    (lambda (ele) (list (caadr ele))) "" ""))

;;; ưإ:tutcode-auto-help-bushu-decomposeθ̤Υĥ꡼¤顢
;;; ȴФեåȤʥꥹȤ
;;; @param decomposed tutcode-auto-help-bushu-decompose
;;; @param lst Υꥹ
;;; @param picker decomposed(tutcode-rule-element)
;;;   оǤȴФδؿ
;;; @param branch-str ޤ狼򼨤˷̥ꥹȤɲäʸ
;;; @param delim-str ζڤ򼨤˷̥ꥹȤɲäʸ
;;; @return Υꥹ
(define (tutcode-auto-help-bushu-composition-traverse decomposed lst picker
          branch-str delim-str)
  (if (null? decomposed)
    lst
    (let
      ((add
        (if (tutcode-rule-element? (car decomposed))
          (cons delim-str (picker (car decomposed)))
          (tutcode-auto-help-bushu-composition-traverse (car decomposed)
            (list branch-str) picker branch-str delim-str))))
      (tutcode-auto-help-bushu-composition-traverse (cdr decomposed)
        (append lst add) picker branch-str delim-str))))

;;; ưإ:оݤ1ʸϤ륹ȥإalistɲä롣
;;; @param label-cands-alist alist
;;; @param kanji إɽоʸ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-normal-with-kanji
          pc label-cands-alist kanji)
  (let*
    ((stime (time))
     (rule (rk-context-rule (tutcode-context-rk-context pc)))
     (stroke (tutcode-reverse-find-seq kanji rule)))
    (if stroke
      (begin
        (tutcode-stroke-help-guide-add-kanji
          pc (list (list stroke) (list kanji)))
        (tutcode-auto-help-update-stroke-alist-normal-with-stroke
          label-cands-alist
          (cons (string-append kanji " ") stroke)
          kanji))
      (let ((decomposed (tutcode-auto-help-bushu-decompose kanji rule stime)))
        ;; : "" => (((("," "o"))("")) ((("f" "q"))("")))
        (if (not decomposed)
          label-cands-alist
          (let*
            ((bushu-strs (tutcode-auto-help-bushu-composition-strs decomposed))
             (helpstrlist (append (list kanji "") bushu-strs))
             (helpstr (apply string-append helpstrlist))
             (bushu-stroke
              (tutcode-auto-help-bushu-composition-traverse decomposed ()
                caar "" " ")))
            (tutcode-auto-help-bushu-composition-add-guide pc decomposed)
            (tutcode-auto-help-update-stroke-alist-normal-with-stroke
              label-cands-alist
              (cons helpstr bushu-stroke)
              kanji)))))))

;;; ưإ:оݤΥȥ(Υꥹ)إalistɲä롣
;;; @param label-cands-alist alist
;;; @param cand-list إɽ˻ȤǸ򼨤ʸΥꥹ
;;; @param stroke оݥȥ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-with-stroke label-cands-alist
         cand-list stroke)
  (if (or (null? cand-list) (null? stroke))
    label-cands-alist
    (tutcode-auto-help-update-stroke-alist-with-stroke
      (tutcode-auto-help-update-stroke-alist-with-key
        label-cands-alist
        (if (pair? cand-list) (car cand-list) "")
        (car stroke))
      (cdr cand-list) (cdr stroke))))

;;; ưإ:оݤΥȥ(Υꥹ)إalistɲä롣
;;; @param label-cands-alist alist
;;; @param stroke оݥȥ
;;; @param label ꤵ줿
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-normal-with-stroke
          label-cands-alist stroke label)
  (let ((label-cand (assoc label label-cands-alist)))
    (if (not label-cand)
      (cons (cons label (reverse stroke)) label-cands-alist))))

;;; ưإ:оݤΥإalistɲä롣
;;; @param label-cands-alist alist
;;; @param cand إɽ˻Ȥоݥ򼨤ʸ
;;; @param key оݥ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-with-key label-cands-alist
         cand key)
  (let*
    ((label key)
     (label-cand (assoc label label-cands-alist)))
    (if label-cand
      (begin
        (set-cdr! label-cand (cons cand (cdr label-cand)))
        label-cands-alist)
      (cons (list label cand) label-cands-alist))))

;;; ưإ:ľμưإפɽ
(define (tutcode-auto-help-redisplay pc)
  (let ((help (tutcode-context-auto-help pc)))
    (if (and help
             (> (length help) 0)
             (not (eq? (car help) 'delaytmp)))
      (tutcode-activate-candidate-window pc
        'tutcode-candidate-window-auto-help
        0
        (length help)
        tutcode-nr-candidate-max-for-kigou-mode))))

;;; ưإ:ľΥإפǸ䥦ɥɽƤסcommit
;;; ((:"")򥳥ԡ)
(define (tutcode-auto-help-dump state pc)
  (if (eq? state 'tutcode-state-on)
    (let ((help (tutcode-context-auto-help pc)))
      (if (and help
               (> (length help) 0)
               (not (eq? (car help) 'delaytmp)))
        (let ((linecands
                (append-map
                  (lambda (elem)
                    (list (car elem) "\n"))
                  (tutcode-table-in-vertical-candwin help #t))))
          (tutcode-commit pc (apply string-append linecands) #t #t))))))

;;; preeditɽ򹹿롣
(define (tutcode-do-update-preedit pc)
  (let ((stat (tutcode-context-state pc))
        (cpc (tutcode-context-child-context pc))
        (cursor-shown? #f))
    (case stat
      ((tutcode-state-yomi)
        (im-pushback-preedit pc preedit-none "")
        (let ((h (string-list-concat (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h))))
      ((tutcode-state-code)
        (im-pushback-preedit pc preedit-none "")
        (let ((h (string-list-concat (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h))))
      ((tutcode-state-converting)
        (im-pushback-preedit pc preedit-none "")
        (if (null? cpc)
          (begin
            (im-pushback-preedit pc preedit-none
              (tutcode-get-current-candidate pc))
            (let ((suffix (tutcode-context-mazegaki-suffix pc))) ; Ѹ
              (if (pair? suffix)
                (begin
                  (im-pushback-preedit pc preedit-cursor "")
                  (set! cursor-shown? #t)
                  (im-pushback-preedit pc preedit-none
                    (string-list-concat suffix))))))
          ;; child context's preedit
          (let ((h (string-list-concat (tutcode-context-head pc)))
                (editor (tutcode-context-editor pc))
                (dialog (tutcode-context-dialog pc)))
            (if (string? h)
              (im-pushback-preedit pc preedit-none h))
            (im-pushback-preedit pc preedit-none "")
            (im-pushback-preedit pc preedit-none
              (case (tutcode-context-child-type pc)
                ((tutcode-child-type-editor)
                  (tutcode-editor-get-left-string editor))
                ((tutcode-child-type-dialog)
                  (tutcode-dialog-get-left-string dialog))))
            (tutcode-do-update-preedit cpc)
            (set! cursor-shown? #t)
            (im-pushback-preedit pc preedit-none
              (case (tutcode-context-child-type pc)
                ((tutcode-child-type-editor)
                  (tutcode-editor-get-right-string editor))
                ((tutcode-child-type-dialog)
                  (tutcode-dialog-get-right-string dialog))))
            (im-pushback-preedit pc preedit-none ""))))
      ;; ѴΥޡʸȤheadǴ(ƵŪΤ)
      ((tutcode-state-bushu)
        (let ((h (string-list-concat (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h))))
      ((tutcode-state-interactive-bushu)
        (im-pushback-preedit pc preedit-none "")
        (let ((h (string-list-concat (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h)))
        (if tutcode-show-pending-rk?
          (im-pushback-preedit pc preedit-underline
            (rk-pending (tutcode-context-rk-context pc))))
        (im-pushback-preedit pc preedit-cursor "")
        (set! cursor-shown? #t)
        (if (> (tutcode-lib-get-nr-predictions pc) 0)
          (begin
            (im-pushback-preedit pc preedit-underline "=>")
            (im-pushback-preedit pc preedit-underline
              (tutcode-get-prediction-string pc
                (tutcode-context-prediction-index pc)))))) ; ϸ쥬̵
      ((tutcode-state-kigou)
        ;; 䥦ɥɽǤǤ褦preeditɽ
        (im-pushback-preedit pc preedit-reverse
          (tutcode-get-current-candidate-for-kigou-mode pc)))
      ((tutcode-state-history)
        (im-pushback-preedit pc preedit-none "")
        (im-pushback-preedit pc preedit-none
          (tutcode-get-current-candidate-for-history pc)))
      ((tutcode-state-postfix-katakana)
        (im-pushback-preedit pc preedit-none "")
        (let ((h (string-list-concat (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h))))
      ((tutcode-state-postfix-kanji2seq)
        (im-pushback-preedit pc preedit-none "")
        (let ((h (string-list-concat (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h))))
      ((tutcode-state-postfix-seq2kanji)
        (im-pushback-preedit pc preedit-none "")
        (let ((h (string-list-concat (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h)))))
    (if (not cursor-shown?)
      (begin
        (if (and tutcode-show-pending-rk?
                 (memq stat '(tutcode-state-on tutcode-state-yomi
                              tutcode-state-bushu)))
          (im-pushback-preedit pc preedit-underline
            (rk-pending (tutcode-context-rk-context pc))))
        (im-pushback-preedit pc preedit-cursor "")))))

;;; preeditɽ򹹿롣
(define (tutcode-update-preedit pc)
  (im-clear-preedit pc)
  (tutcode-do-update-preedit (tutcode-find-root-context pc))
  (im-update-preedit pc))

;; called from tutcode-editor
;;; tutcode-editor¦ǤԽλ˸ƤФ롣
;;; @param str ǥ¦ǳꤵ줿ʸ
(define (tutcode-commit-editor-context pc str)
  (let* ((yomi-len (tutcode-context-postfix-yomi-len pc))
         (suffix (tutcode-context-mazegaki-suffix pc))
         (commit-str (if (null? suffix)
                         str
                         (string-append str (string-list-concat suffix)))))
    (tutcode-context-set-child-context! pc ())
    (tutcode-context-set-child-type! pc ())
    (cond
      ((= yomi-len 0)
        (tutcode-flush pc)
        (tutcode-commit pc commit-str))
      ((> yomi-len 0)
        (let ((yomi (take (tutcode-context-mazegaki-yomi-all pc) yomi-len)))
          (tutcode-postfix-commit pc commit-str yomi)
          (tutcode-flush pc)))
      (else
        (tutcode-selection-commit pc commit-str
          (tutcode-context-mazegaki-yomi-all pc))
        (tutcode-flush pc)))
    (tutcode-update-preedit pc)))

;;; 䴰򸡺Ƹ䥦ɥɽ
;;; @param force-check? ɬԤɤ
;;;  #fξʸ̤ξϸʤ
;;; @param num commit-strs鸡оݤˤʸ0ξơ
(define (tutcode-check-completion pc force-check? num)
  (tutcode-context-set-commit-strs-used-len! pc 0)
  (if (eq? (tutcode-context-predicting pc) 'tutcode-predicting-off)
    (let* ((commit-strs-all (tutcode-context-commit-strs pc))
           (commit-strs
            (if (> num 0)
              (take commit-strs-all num)
              commit-strs-all))
           (len (length commit-strs)))
      (if
        (or (>= len tutcode-completion-chars-min)
            (and force-check?
                 (> len 0)))
        (let ((delay
                (if force-check?
                  0
                  tutcode-candidate-window-activate-delay-for-completion)))
          (if (tutcode-candidate-window-enable-delay? pc delay)
            (tutcode-activate-candidate-window pc
              'tutcode-candidate-window-predicting delay -1 -1)
            (if (tutcode-check-completion-make pc force-check? num)
              (tutcode-activate-candidate-window pc
                'tutcode-candidate-window-predicting
                0
                (tutcode-context-prediction-nr-all pc)
                (tutcode-context-prediction-page-limit pc)))))))))

;;; 䴰򸡺ƸꥹȤ
;;; @param force-check? ɬԤɤ
;;;  #fξʸ̤ξϸʤ
;;; @param num commit-strs鸡оݤˤʸ0ξơ
;;; @return #t:ɽ䤢, #f:ɽʤ
(define (tutcode-check-completion-make pc force-check? num)
  (tutcode-context-set-commit-strs-used-len! pc 0)
  (if (eq? (tutcode-context-predicting pc) 'tutcode-predicting-off)
    (let* ((commit-strs-all (tutcode-context-commit-strs pc))
           (commit-strs
            (if (> num 0)
              (take commit-strs-all num)
              commit-strs-all))
           (len (length commit-strs)))
      (if
        (or (>= len tutcode-completion-chars-min)
            (and force-check?
                 (> len 0)))
        (let ((str (string-list-concat commit-strs)))
          (tutcode-lib-set-prediction-src-string pc str #t)
          (let ((nr (tutcode-lib-get-nr-predictions pc)))
            (if (and nr (> nr 0))
              (let*
                ((nr-guide
                  (if tutcode-use-kanji-combination-guide?
                    (begin
                      (tutcode-guide-set-candidates pc str #t ())
                      (length (tutcode-context-guide pc)))
                    0))
                 (res (tutcode-prediction-calc-window-param nr nr-guide))
                 (nr-all (list-ref res 0)) ; (䴰+ϸ쥬)
                 (page-limit (list-ref res 1)) ; ڡ(䴰+ϸ)
                 (nr-in-page (list-ref res 2))) ; ڡ(䴰Τ)
                (if (> page-limit 0)
                  (begin
                    (tutcode-context-set-commit-strs-used-len! pc len)
                    (tutcode-context-set-prediction-nr-in-page! pc nr-in-page)
                    (tutcode-context-set-prediction-page-limit! pc page-limit)
                    (tutcode-context-set-prediction-nr-all! pc nr-all)
                    (tutcode-context-set-prediction-index! pc 0)
                    (tutcode-context-set-predicting! pc
                      'tutcode-predicting-completion)))
                #t)
              ;; 䴰䤬Ĥʤ硢1ʸäʸȤäƺƸ
              ;; (ľtutcode-context-set-commit-strs!ʸȡ
              ;;  ְäʸϤBackspaceǾäȤˡ
              ;;  Ϥʸ󤬺Ƥ뤿ᡢԤ䴰ˤʤʤ
              ;;  줢ꡣ®Ūˤϡľܺ®)
              (if (> len 1)
                (tutcode-check-completion-make pc force-check? (- len 1))
                #f))))
        #f))
    #f))

;;; 򤼽Ѵͽ¬ϸ򸡺Ƹ䥦ɥɽ
;;; @param force-check? ɬԤɤ
;;;  #fξʸ̤ξϸʤ
(define (tutcode-check-prediction pc force-check?)
  (if (eq? (tutcode-context-predicting pc) 'tutcode-predicting-off)
    (let* ((head (tutcode-context-head pc))
           (preedit-len (length head)))
      (if
        (or (>= preedit-len tutcode-prediction-start-char-count)
            force-check?)
        (let ((delay
              (if force-check?
                0
                tutcode-candidate-window-activate-delay-for-prediction)))
          (if (tutcode-candidate-window-enable-delay? pc delay)
            (tutcode-activate-candidate-window pc
              'tutcode-candidate-window-predicting delay -1 -1)
            (if (tutcode-check-prediction-make pc force-check?)
              (tutcode-activate-candidate-window pc
                'tutcode-candidate-window-predicting
                0
                (tutcode-context-prediction-nr-all pc)
                (tutcode-context-prediction-page-limit pc)))))))))

;;; ͽ¬ϸ򸡺ƸꥹȤ
;;; @param force-check? ɬԤɤ
;;;  #fξʸ̤ξϸʤ
;;; @return #t:ɽ䤢, #f:ɽʤ
(define (tutcode-check-prediction-make pc force-check?)
  (if (eq? (tutcode-context-predicting pc) 'tutcode-predicting-off)
    (let* ((head (tutcode-context-head pc))
           (preedit-len (length head)))
      (if
        (or (>= preedit-len tutcode-prediction-start-char-count)
            force-check?)
        (let*
          ((preconv-str (string-list-concat head))
           (all-yomi (tutcode-lib-set-prediction-src-string pc preconv-str #f))
           (nr (tutcode-lib-get-nr-predictions pc)))
          (if (and nr (> nr 0))
            (let*
              ((nr-guide
                (if tutcode-use-kanji-combination-guide?
                  (begin
                    (tutcode-guide-set-candidates pc preconv-str #f all-yomi)
                    (length (tutcode-context-guide pc)))
                  0))
               (res (tutcode-prediction-calc-window-param nr nr-guide))
               (nr-all (list-ref res 0)) ; (ͽ¬+ϸ쥬)
               (page-limit (list-ref res 1)) ; ڡ(ͽ¬+ϸ)
               (nr-in-page (list-ref res 2))) ; ڡ(ͽ¬Τ)
              (if (> page-limit 0)
                (begin
                  (tutcode-context-set-prediction-nr-in-page! pc nr-in-page)
                  (tutcode-context-set-prediction-page-limit! pc page-limit)
                  (tutcode-context-set-prediction-nr-all! pc nr-all)
                  (tutcode-context-set-prediction-index! pc 0)
                  (tutcode-context-set-predicting! pc
                    'tutcode-predicting-prediction)
                  #t)
                #f))
            #f))
        #f))
    #f))

;;; Ѵͽ¬ϸ򸡺Ƹ䥦ɥ(ٱ)ɽ
;;; @param char Ϥ줿1
(define (tutcode-check-bushu-prediction pc char)
  (if (tutcode-candidate-window-enable-delay? pc
        tutcode-candidate-window-activate-delay-for-bushu-prediction)
    (begin
      (tutcode-context-set-prediction-bushu! pc char) ; ٱƽлѤ˰ݻ
      (tutcode-activate-candidate-window pc
        'tutcode-candidate-window-predicting
        tutcode-candidate-window-activate-delay-for-bushu-prediction
        -1 -1))
    (tutcode-check-bushu-prediction-make pc char #t)))

;;; Ѵͽ¬ϸ򸡺ƸꥹȤ
;;; @param char Ϥ줿1
;;; @param show-candwin? ꥹȤκ䥦ɥɽԤɤ
;;; @return #t:ɽ䤢, #f:ɽʤ
(define (tutcode-check-bushu-prediction-make pc char show-candwin?)
  (let ((res
          (case tutcode-bushu-conversion-algorithm
            ((tc-2.3.1-22.6)
              (tutcode-bushu-predict-tc23 char))
            (else ; 'tc-2.1+ml1925
              (tutcode-bushu-predict-tc21 char)))))
    (tutcode-context-set-prediction-bushu! pc res)
    (tutcode-context-set-prediction-bushu-page-start! pc 0)
    (tutcode-bushu-prediction-make-page pc 0 show-candwin?)))

;;; Ѵͽ¬ϸ򸡺ƸꥹȤ
;;; @param char Ϥ줿1
;;; @return (<2> <ʸ>)Υꥹ
(define (tutcode-bushu-predict-tc21 char)
  (let* ((res (tutcode-bushu-predict char tutcode-bushudic))
         (alt (assoc char tutcode-bushudic-altchar))
         (altres
          (if alt
            (tutcode-bushu-predict (cadr alt) tutcode-bushudic)
            ()))
         (resall (append res altres)))
    resall))

;;; Ѵͽ¬ϸ򸡺ƸꥹȤ
;;; @param char Ϥ줿1
;;; @return (<2> <ʸ>)Υꥹ
(define (tutcode-bushu-predict-tc23 char)
  (let ((gosei (tutcode-bushu-compose-tc23 (list char) #f)))
    (map
      (lambda (elem)
        (list #f elem))
      gosei)))

;;; Ѵͽ¬ϸΤ
;;; ꤵ줿ֹ椫Ϥޤ1ڡ֤θꥹȤ롣
;;; @param start-index ֹ
;;; @param show-candwin? ꥹȤκ䥦ɥɽԤɤ
;;;  #fξϡꥹȤκΤ߹Ԥ(delay-activating-handler)
;;; @return #t:ɽ䤢, #f:ɽʤ
(define (tutcode-bushu-prediction-make-page pc start-index show-candwin?)
  (tutcode-lib-set-bushu-prediction pc start-index)
  (let ((nr (tutcode-lib-get-nr-predictions pc)))
    (if (and nr (> nr 0))
      (let*
        ((nr-guide
          (if tutcode-use-kanji-combination-guide?
            (begin
              (tutcode-guide-set-candidates-for-bushu pc)
              (length (tutcode-context-guide pc)))
            0))
         (res (tutcode-prediction-calc-window-param nr nr-guide))
         (nr-all (list-ref res 0)) ; (ͽ¬+ϸ쥬)
         (page-limit (list-ref res 1)) ; ڡ(ͽ¬+ϸ)
         (nr-in-page (list-ref res 2))) ; ڡ(ͽ¬Τ)
        (if (> page-limit 0)
          (begin
            (tutcode-context-set-prediction-nr-in-page! pc nr-in-page)
            (tutcode-context-set-prediction-page-limit! pc page-limit)
            (tutcode-context-set-prediction-nr-all! pc nr-all)
            (tutcode-context-set-prediction-index! pc 0)
            (tutcode-context-set-predicting! pc 'tutcode-predicting-bushu)
            (if show-candwin?
              (tutcode-activate-candidate-window pc
                'tutcode-candidate-window-predicting
                0 nr-all page-limit))
            #t)
          #f))
      #f)))

;;; 䴰Ƚϸ쥬ɽΤcandwinѥѥ᡼׻
;;; @param nr 䴰
;;; @param nr-guide ϸ쥬ɸ
;;; @return (<> <ڡȤθ> <ڡȤ䴰>)
(define (tutcode-prediction-calc-window-param nr nr-guide)
  (cond
    ;; 1ڡ˼ޤ
    ((and (<= nr-guide tutcode-nr-candidate-max-for-guide)
          (<= nr tutcode-nr-candidate-max-for-prediction))
      (list (+ nr-guide nr) (+ nr-guide nr) nr))
    ;; 䴰䤬1ڡ˼ޤʤ
    ((and (<= nr-guide tutcode-nr-candidate-max-for-guide)
          (> nr tutcode-nr-candidate-max-for-prediction))
      (if (= 0 tutcode-nr-candidate-max-for-prediction)
        (list nr-guide nr-guide 0) ; 䴰ɽʤ
        (let*
          ((nr-page
            ;; ڡϰˤʤݤʤΤǡ
            ;; ƥڡƱϸ쥬ɤɽ
            ;; ;Υڡˤɽʤ
            ;; (ƥڡǤindexnr-candidate-max-for-prediction̤
            ;;  䴰/ͽ¬ϸ䡢ʾθϸ쥬ɤȤưΤ
            ;;  ʤ䴰ʤ;ΥڡǤɽ)
            (quotient nr tutcode-nr-candidate-max-for-prediction))
           (page-limit (+ nr-guide tutcode-nr-candidate-max-for-prediction))
           (nr-all (+ nr (* nr-guide nr-page))))
          (list nr-all page-limit tutcode-nr-candidate-max-for-prediction))))
    ;; ϸ쥬ɤ1ڡ˼ޤʤ
    ((and (> nr-guide tutcode-nr-candidate-max-for-guide)
          (<= nr tutcode-nr-candidate-max-for-prediction))
      (if (= 0 tutcode-nr-candidate-max-for-guide)
        (list nr nr nr) ; ϸ쥬ɤɽʤ
        (let*
          ((nr-page
            (+ 
              (quotient nr-guide tutcode-nr-candidate-max-for-guide)
              (if (= 0 (remainder nr-guide tutcode-nr-candidate-max-for-guide))
                0
                1)))
           (page-limit (+ nr tutcode-nr-candidate-max-for-guide))
           (nr-all (+ nr-guide (* nr nr-page))))
          (list nr-all page-limit nr))))
    ;; 䴰Ƚϸ쥬ξȤ1ڡ˼ޤʤ
    (else
      (cond
        ;; ϸ쥬ɤΤɽ
        ((= 0 tutcode-nr-candidate-max-for-prediction)
          (list nr-guide tutcode-nr-candidate-max-for-guide 0))
        ;; 䴰Τɽ
        ((= 0 tutcode-nr-candidate-max-for-guide)
          (list nr tutcode-nr-candidate-max-for-prediction
            tutcode-nr-candidate-max-for-prediction))
        (else
          (let*
            ((nr-page-prediction
              (quotient nr tutcode-nr-candidate-max-for-prediction))
             (nr-page-guide
              (+
                (quotient nr-guide tutcode-nr-candidate-max-for-guide)
                (if (= 0 (remainder nr-guide tutcode-nr-candidate-max-for-guide))
                  0
                  1)))
             (nr-page (max nr-page-prediction nr-page-guide))
             (page-limit (+ tutcode-nr-candidate-max-for-guide
              tutcode-nr-candidate-max-for-prediction))
             (nr-all 
              (if (> nr-page-prediction nr-page-guide)
                (+ nr (* nr-page tutcode-nr-candidate-max-for-guide))
                (+ nr-guide (* nr-page tutcode-nr-candidate-max-for-prediction)))))
            (list nr-all page-limit tutcode-nr-candidate-max-for-prediction)))))))

;;; TUT-CodeϾ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-on c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (rkc (tutcode-context-rk-context pc))
     ;; reset-candidate-windowǥꥻåȤΤ¸Ƥ
     (completing?
      (eq? (tutcode-context-predicting pc) 'tutcode-predicting-completion))
     (rk-commit-flush
      (lambda ()
        (if (and tutcode-keep-illegal-sequence?
                 (pair? (rk-context-seq rkc)))
          (tutcode-commit pc (rk-pending rkc) #f #t))
        (rk-flush rkc)))
     ;; 䴰ɽΥڡưϡreset-candidate-window
     (prediction-keys-handled?
      (if completing?
        (cond
          ((tutcode-next-page-key? key key-state)
            (tutcode-change-prediction-page pc #t)
            #t)
          ((tutcode-prev-page-key? key key-state)
            (tutcode-change-prediction-page pc #f)
            #t)
          (else
            #f))
        #f)))
    (if (not prediction-keys-handled?)
      (begin
        (tutcode-reset-candidate-window pc)
        (cond
          ((and
            (tutcode-vi-escape-key? key key-state)
            tutcode-use-with-vi?)
           (rk-commit-flush)
           (tutcode-context-set-commit-strs! pc ())
           (tutcode-context-set-state! pc 'tutcode-state-off)
           (tutcode-commit-raw pc key key-state)) ; ESC򥢥ץˤϤ
          ((tutcode-off-key? key key-state)
           (rk-commit-flush)
           (tutcode-context-set-commit-strs! pc ())
           (tutcode-context-set-state! pc 'tutcode-state-off))
          ((tutcode-on-key? key key-state) ; off-keyon-key̥ξ
           ;; onǤoffǤ⡢on-keyonˤʤΤcommit-raw
           (rk-commit-flush))
          ((tutcode-kigou-toggle-key? key key-state)
           (rk-commit-flush)
           (tutcode-begin-kigou-mode pc))
          ((tutcode-kigou2-toggle-key? key key-state)
           (rk-commit-flush)
           (tutcode-toggle-kigou2-mode pc))
          ((and (tutcode-kana-toggle-key? key key-state)
                (not (tutcode-kigou2-mode? pc)))
           (rk-commit-flush)
           (tutcode-context-kana-toggle pc))
          ((tutcode-backspace-key? key key-state)
           (if (> (length (rk-context-seq rkc)) 0)
             (rk-flush rkc)
             (begin
               (tutcode-commit-raw pc key key-state)
               (if (and (or tutcode-use-completion?
                            tutcode-enable-fallback-surrounding-text?)
                        (pair? (tutcode-context-commit-strs pc)))
                 (tutcode-context-set-commit-strs! pc
                     (cdr (tutcode-context-commit-strs pc))))
               (if (and tutcode-use-completion?
                        completing?
                        (> tutcode-completion-chars-min 0))
                 (tutcode-check-completion pc #f 0)))))
          ((tutcode-stroke-help-toggle-key? key key-state)
           (tutcode-toggle-stroke-help pc))
          ((and tutcode-use-completion?
                (tutcode-begin-completion-key? key key-state))
           (rk-commit-flush)
           (if completing?
             ;; 䴰begin-completin-key줿оʸ1餷ƺ䴰
             ;; (տޤʤʸ䴰줿ˡ䴰ľǤ褦)
             ;; оݤ1ʸ̤ˤʤ䴰ɥĤ(ɽʤ)
             (let ((len (tutcode-context-commit-strs-used-len pc)))
               (if (> len 1)
                 (tutcode-check-completion pc #t (- len 1))))
             (tutcode-check-completion pc #t 0)))
          ((and (tutcode-paste-key? key key-state)
                (pair? (tutcode-context-parent-context pc)))
            (let ((latter-seq (tutcode-clipboard-acquire-text-wo-nl pc 'full)))
              (if (pair? latter-seq)
                (tutcode-commit pc (string-list-concat latter-seq)))))
          ((or
            (symbol? key)
            (and
              (modifier-key-mask key-state)
              (not (shift-key-mask key-state))))
           (rk-commit-flush)
           (tutcode-commit-raw pc key key-state))
          ;; 䴰ѥ٥륭?
          ((and completing?
                (tutcode-heading-label-char-for-prediction? key)
                (tutcode-commit-by-label-key-for-prediction pc
                  (charcode->string key) 'tutcode-predicting-completion)))
          ;; ʤ󥹤ƼΤƤ(tc2˹碌ư)
          ;; (rk-push-key!ȡޤǤΥ󥹤ϼΤƤ뤬
          ;; ְäϻĤäƤޤΤǡrk-push-key!ϻȤʤ)
          ((not (rk-expect-key? rkc (charcode->string key)))
           (if (> (length (rk-context-seq rkc)) 0)
             (begin
               (cond
                 ((tutcode-verbose-stroke-key? key key-state)
                   (tutcode-commit pc (rk-pending rkc) #f #t))
                 (tutcode-keep-illegal-sequence?
                   (tutcode-commit pc (rk-pending rkc) #f #t)
                   (tutcode-commit-raw pc key key-state)))
               (rk-flush rkc))
             ;; ñȤΥ(TUT-CodeϤǤʤ)
             (tutcode-commit-raw pc key key-state)))
          (else
           (let ((res (tutcode-push-key! pc (charcode->string key))))
            (cond
              ((string? res)
                (tutcode-commit pc res #f (not (tutcode-kigou2-mode? pc)))
                (if (and tutcode-use-completion?
                         (> tutcode-completion-chars-min 0))
                  (tutcode-check-completion pc #f 0)))
              ((symbol? res)
                (case res
                  ((tutcode-mazegaki-start)
                    (tutcode-context-set-latin-conv! pc #f)
                    (tutcode-context-set-postfix-yomi-len! pc 0)
                    (tutcode-context-set-state! pc 'tutcode-state-yomi))
                  ((tutcode-latin-conv-start)
                    (tutcode-context-set-latin-conv! pc #t)
                    (tutcode-context-set-postfix-yomi-len! pc 0)
                    (tutcode-context-set-state! pc 'tutcode-state-yomi))
                  ((tutcode-kanji-code-input-start)
                    (tutcode-context-set-state! pc 'tutcode-state-code))
                  ((tutcode-bushu-start)
                    (tutcode-context-set-undo! pc ());ƵŪѴundo
                    (tutcode-context-set-state! pc 'tutcode-state-bushu)
                    (tutcode-append-string pc ""))
                  ((tutcode-interactive-bushu-start)
                    (tutcode-context-set-prediction-nr! pc 0)
                    (tutcode-context-set-state! pc
                      'tutcode-state-interactive-bushu))
                  ((tutcode-history-start)
                    (tutcode-begin-history pc))
                  ((tutcode-undo)
                    (tutcode-undo pc))
                  ((tutcode-help)
                    (tutcode-help pc))
                  ((tutcode-help-clipboard)
                    (tutcode-help-clipboard pc))
                  ((tutcode-auto-help-redisplay)
                    (tutcode-auto-help-redisplay pc))
                  ((tutcode-postfix-bushu-start)
                    (tutcode-begin-postfix-bushu-conversion pc))
                  ((tutcode-postfix-mazegaki-start)
                    (tutcode-begin-postfix-mazegaki-conversion pc #f #f #f))
                  ((tutcode-postfix-mazegaki-1-start)
                    (tutcode-begin-postfix-mazegaki-conversion pc 1 #t
                      tutcode-use-recursive-learning?))
                  ((tutcode-postfix-mazegaki-2-start)
                    (tutcode-begin-postfix-mazegaki-conversion pc 2 #t
                      tutcode-use-recursive-learning?))
                  ((tutcode-postfix-mazegaki-3-start)
                    (tutcode-begin-postfix-mazegaki-conversion pc 3 #t
                      tutcode-use-recursive-learning?))
                  ((tutcode-postfix-mazegaki-4-start)
                    (tutcode-begin-postfix-mazegaki-conversion pc 4 #t
                      tutcode-use-recursive-learning?))
                  ((tutcode-postfix-mazegaki-5-start)
                    (tutcode-begin-postfix-mazegaki-conversion pc 5 #t
                      tutcode-use-recursive-learning?))
                  ((tutcode-postfix-mazegaki-6-start)
                    (tutcode-begin-postfix-mazegaki-conversion pc 6 #t
                      tutcode-use-recursive-learning?))
                  ((tutcode-postfix-mazegaki-7-start)
                    (tutcode-begin-postfix-mazegaki-conversion pc 7 #t
                      tutcode-use-recursive-learning?))
                  ((tutcode-postfix-mazegaki-8-start)
                    (tutcode-begin-postfix-mazegaki-conversion pc 8 #t
                      tutcode-use-recursive-learning?))
                  ((tutcode-postfix-mazegaki-9-start)
                    (tutcode-begin-postfix-mazegaki-conversion pc 9 #t
                      tutcode-use-recursive-learning?))
                  ((tutcode-postfix-mazegaki-inflection-start)
                    (tutcode-begin-postfix-mazegaki-inflection-conversion pc #f))
                  ((tutcode-postfix-mazegaki-inflection-1-start)
                    (tutcode-begin-postfix-mazegaki-inflection-conversion pc 1))
                  ((tutcode-postfix-mazegaki-inflection-2-start)
                    (tutcode-begin-postfix-mazegaki-inflection-conversion pc 2))
                  ((tutcode-postfix-mazegaki-inflection-3-start)
                    (tutcode-begin-postfix-mazegaki-inflection-conversion pc 3))
                  ((tutcode-postfix-mazegaki-inflection-4-start)
                    (tutcode-begin-postfix-mazegaki-inflection-conversion pc 4))
                  ((tutcode-postfix-mazegaki-inflection-5-start)
                    (tutcode-begin-postfix-mazegaki-inflection-conversion pc 5))
                  ((tutcode-postfix-mazegaki-inflection-6-start)
                    (tutcode-begin-postfix-mazegaki-inflection-conversion pc 6))
                  ((tutcode-postfix-mazegaki-inflection-7-start)
                    (tutcode-begin-postfix-mazegaki-inflection-conversion pc 7))
                  ((tutcode-postfix-mazegaki-inflection-8-start)
                    (tutcode-begin-postfix-mazegaki-inflection-conversion pc 8))
                  ((tutcode-postfix-mazegaki-inflection-9-start)
                    (tutcode-begin-postfix-mazegaki-inflection-conversion pc 9))
                  ((tutcode-postfix-katakana-start)
                    (tutcode-begin-postfix-katakana-conversion pc #f))
                  ((tutcode-postfix-katakana-0-start)
                    (tutcode-begin-postfix-katakana-conversion pc 0))
                  ((tutcode-postfix-katakana-1-start)
                    (tutcode-begin-postfix-katakana-conversion pc 1))
                  ((tutcode-postfix-katakana-2-start)
                    (tutcode-begin-postfix-katakana-conversion pc 2))
                  ((tutcode-postfix-katakana-3-start)
                    (tutcode-begin-postfix-katakana-conversion pc 3))
                  ((tutcode-postfix-katakana-4-start)
                    (tutcode-begin-postfix-katakana-conversion pc 4))
                  ((tutcode-postfix-katakana-5-start)
                    (tutcode-begin-postfix-katakana-conversion pc 5))
                  ((tutcode-postfix-katakana-6-start)
                    (tutcode-begin-postfix-katakana-conversion pc 6))
                  ((tutcode-postfix-katakana-7-start)
                    (tutcode-begin-postfix-katakana-conversion pc 7))
                  ((tutcode-postfix-katakana-8-start)
                    (tutcode-begin-postfix-katakana-conversion pc 8))
                  ((tutcode-postfix-katakana-9-start)
                    (tutcode-begin-postfix-katakana-conversion pc 9))
                  ((tutcode-postfix-katakana-exclude-1)
                    (tutcode-begin-postfix-katakana-conversion pc -1))
                  ((tutcode-postfix-katakana-exclude-2)
                    (tutcode-begin-postfix-katakana-conversion pc -2))
                  ((tutcode-postfix-katakana-exclude-3)
                    (tutcode-begin-postfix-katakana-conversion pc -3))
                  ((tutcode-postfix-katakana-exclude-4)
                    (tutcode-begin-postfix-katakana-conversion pc -4))
                  ((tutcode-postfix-katakana-exclude-5)
                    (tutcode-begin-postfix-katakana-conversion pc -5))
                  ((tutcode-postfix-katakana-exclude-6)
                    (tutcode-begin-postfix-katakana-conversion pc -6))
                  ((tutcode-postfix-katakana-shrink-1)
                    (tutcode-postfix-katakana-shrink pc 1))
                  ((tutcode-postfix-katakana-shrink-2)
                    (tutcode-postfix-katakana-shrink pc 2))
                  ((tutcode-postfix-katakana-shrink-3)
                    (tutcode-postfix-katakana-shrink pc 3))
                  ((tutcode-postfix-katakana-shrink-4)
                    (tutcode-postfix-katakana-shrink pc 4))
                  ((tutcode-postfix-katakana-shrink-5)
                    (tutcode-postfix-katakana-shrink pc 5))
                  ((tutcode-postfix-katakana-shrink-6)
                    (tutcode-postfix-katakana-shrink pc 6))
                  ((tutcode-postfix-kanji2seq-start)
                    (tutcode-begin-postfix-kanji2seq-conversion pc #f))
                  ((tutcode-postfix-kanji2seq-1-start)
                    (tutcode-begin-postfix-kanji2seq-conversion pc 1))
                  ((tutcode-postfix-kanji2seq-2-start)
                    (tutcode-begin-postfix-kanji2seq-conversion pc 2))
                  ((tutcode-postfix-kanji2seq-3-start)
                    (tutcode-begin-postfix-kanji2seq-conversion pc 3))
                  ((tutcode-postfix-kanji2seq-4-start)
                    (tutcode-begin-postfix-kanji2seq-conversion pc 4))
                  ((tutcode-postfix-kanji2seq-5-start)
                    (tutcode-begin-postfix-kanji2seq-conversion pc 5))
                  ((tutcode-postfix-kanji2seq-6-start)
                    (tutcode-begin-postfix-kanji2seq-conversion pc 6))
                  ((tutcode-postfix-kanji2seq-7-start)
                    (tutcode-begin-postfix-kanji2seq-conversion pc 7))
                  ((tutcode-postfix-kanji2seq-8-start)
                    (tutcode-begin-postfix-kanji2seq-conversion pc 8))
                  ((tutcode-postfix-kanji2seq-9-start)
                    (tutcode-begin-postfix-kanji2seq-conversion pc 9))
                  ((tutcode-postfix-seq2kanji-start)
                    (tutcode-begin-postfix-seq2kanji-conversion pc #f))
                  ((tutcode-postfix-seq2kanji-1-start)
                    (tutcode-begin-postfix-seq2kanji-conversion pc 1))
                  ((tutcode-postfix-seq2kanji-2-start)
                    (tutcode-begin-postfix-seq2kanji-conversion pc 2))
                  ((tutcode-postfix-seq2kanji-3-start)
                    (tutcode-begin-postfix-seq2kanji-conversion pc 3))
                  ((tutcode-postfix-seq2kanji-4-start)
                    (tutcode-begin-postfix-seq2kanji-conversion pc 4))
                  ((tutcode-postfix-seq2kanji-5-start)
                    (tutcode-begin-postfix-seq2kanji-conversion pc 5))
                  ((tutcode-postfix-seq2kanji-6-start)
                    (tutcode-begin-postfix-seq2kanji-conversion pc 6))
                  ((tutcode-postfix-seq2kanji-7-start)
                    (tutcode-begin-postfix-seq2kanji-conversion pc 7))
                  ((tutcode-postfix-seq2kanji-8-start)
                    (tutcode-begin-postfix-seq2kanji-conversion pc 8))
                  ((tutcode-postfix-seq2kanji-9-start)
                    (tutcode-begin-postfix-seq2kanji-conversion pc 9))
                  ((tutcode-selection-mazegaki-start)
                    (tutcode-begin-selection-mazegaki-conversion pc))
                  ((tutcode-selection-mazegaki-inflection-start)
                    (tutcode-begin-selection-mazegaki-inflection-conversion pc))
                  ((tutcode-selection-katakana-start)
                    (tutcode-begin-selection-katakana-conversion pc))
                  ((tutcode-selection-kanji2seq-start)
                    (tutcode-begin-selection-kanji2seq-conversion pc))
                  ((tutcode-selection-seq2kanji-start)
                    (tutcode-begin-selection-seq2kanji-conversion pc))
                  ((tutcode-clipboard-seq2kanji-start)
                    (tutcode-begin-clipboard-seq2kanji-conversion pc))))
              ((procedure? res)
                (res 'tutcode-state-on pc))))))))))

;;; ַѴԤ
(define (tutcode-begin-postfix-bushu-conversion pc)
  (and-let*
    ((former-seq (tutcode-postfix-acquire-text pc 2))
     (res (and (>= (length former-seq) 2)
               (tutcode-bushu-convert (cadr former-seq) (car former-seq)))))
    (tutcode-postfix-commit pc res former-seq)
    (tutcode-check-auto-help-window-begin pc (list res) ())))

;;; ַ/ַѴγundo
(define (tutcode-undo pc)
  (let ((undo (tutcode-context-undo pc)))
    (if (pair? undo)
      (let ((state (list-ref undo 0))
            (commit-len (list-ref undo 1))
            (data (list-ref undo 2)))
        (tutcode-postfix-delete-text pc commit-len)
        (case state
          ((tutcode-state-off) ; ַѴ
            (tutcode-commit pc (string-list-concat data) #f #t))
          ((tutcode-state-converting)
            (tutcode-context-set-head! pc (list-ref data 0))
            (tutcode-context-set-latin-conv! pc (list-ref data 1))
            (tutcode-context-set-state! pc 'tutcode-state-yomi))
          ((tutcode-state-bushu)
            (tutcode-context-set-head! pc data)
            (tutcode-context-set-state! pc 'tutcode-state-bushu))
          ((tutcode-state-yomi)
            (tutcode-context-set-head! pc data)
            (tutcode-context-set-state! pc 'tutcode-state-yomi))
          ((tutcode-state-code)
            (tutcode-context-set-head! pc data)
            (tutcode-context-set-state! pc 'tutcode-state-code))
          )))))

;;; ַ/ַѴγundo뤿ν
;;; @param state Ѵμ('tutcode-state-converting)
;;; @param commit-str ʸ
;;; @param data ξ֤ƸΤɬפʾ
(define (tutcode-undo-prepare pc state commit-str data)
  (let ((commit-len (length (string-to-list commit-str))))
    ;; XXX: ¿undo̤б
    (tutcode-context-set-undo! pc (list state commit-len data))))

;;; ַѴꤹ
;;; @param str ꤹʸ
;;; @param yomi-list Ѵʸ(ɤ/)Υꥹ(ս)
(define (tutcode-postfix-commit pc str yomi-list)
  ;; FirefoxǺ֤Τ򤹤뤿preeditclearƤdelete-text
  (im-clear-preedit pc)
  (im-update-preedit pc)
  (tutcode-postfix-delete-text pc (length yomi-list))
  (tutcode-commit pc str)
  (tutcode-undo-prepare pc 'tutcode-state-off str yomi-list))

;;; ַ򤼽Ѵ򳫻Ϥ
;;; @param yomi-len ꤵ줿ɤߤʸꤵƤʤ#f
;;; @param autocommit? 䤬1Ĥξ˼ưŪ˳ꤹ뤫ɤ
;;;  (yomi-len#fǤʤͭ)
;;; @param recursive-learning? 䤬̵˺ƵϿ⡼ɤ뤫ɤ
;;;  (yomi-len#fǤʤͭ)
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-begin-postfix-mazegaki-conversion pc yomi-len autocommit?
          recursive-learning?)
  (tutcode-context-set-mazegaki-yomi-len-specified! pc (or yomi-len 0))
  (let*
    ((former-seq (tutcode-postfix-mazegaki-acquire-yomi pc yomi-len))
     (former-len (length former-seq)))
    (if yomi-len
      (and
        (>= former-len yomi-len)
        (let ((yomi (take former-seq yomi-len)))
          (tutcode-context-set-postfix-yomi-len! pc yomi-len)
          (if (> yomi-len (length (tutcode-context-mazegaki-yomi-all pc)))
            (tutcode-context-set-mazegaki-yomi-all! pc yomi))
          (tutcode-begin-conversion pc yomi () autocommit? recursive-learning?)))
      ;; ɤߤʸꤵƤʤɤߤ̤ʤѴ
      (and
        (> former-len 0)
        (begin
          (tutcode-context-set-postfix-yomi-len! pc former-len)
          (tutcode-context-set-mazegaki-yomi-all! pc former-seq)
          (tutcode-mazegaki-relimit-right pc former-seq #f))))))

;;; ɤߤ̤ʤ򤼽ѴԤ
;;; ѤʤȤƸƤ䤬Ĥʤϡ
;;; ѤȤƸߤ롣
;;; @param yomi Ѵоݤɤ(ʸεսꥹ)
;;; @param relimit-first? (ǽμ񸡺)ɤߤ̤
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-mazegaki-relimit-right pc yomi relimit-first?)
  (or
    (and
      (not relimit-first?)
      (tutcode-begin-conversion pc yomi () #f #f))
    ;; 䤬Ĥʤä
    (or
      (and
        (> (length yomi) 1)
        (> (tutcode-context-postfix-yomi-len pc) 0) ;ַξϲ⤷ʤ
        (begin ; ɤߤ1ʸ餷ƺƸ
          (tutcode-context-set-postfix-yomi-len! pc (- (length yomi) 1))
          (tutcode-mazegaki-relimit-right pc (drop-right yomi 1) #f)))
      (and tutcode-mazegaki-enable-inflection? ; Ѥθ˰ܹ
        (not (tutcode-mazegaki-inflection? yomi)) ; ŪϽʣʤ
        (let*
          ((len-specified (tutcode-context-mazegaki-yomi-len-specified pc))
           (len
            (if (> len-specified 0)
              len-specified
              (length (tutcode-context-mazegaki-yomi-all pc)))))
          (tutcode-mazegaki-inflection-relimit-right pc len len #f))))))

;;; ɤߤ򿭤Фʤַ򤼽ѴԤ
;;; @param yomi-len ɤߤĹ
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-postfix-mazegaki-relimit-left pc yomi-len)
  (and
    (<= yomi-len tutcode-mazegaki-yomi-max)
    (let*
      ((yomi-all (tutcode-context-mazegaki-yomi-all pc))
       (yomi-all-len (length yomi-all)))
      (if (<= yomi-len yomi-all-len)
        (let ((yomi (take yomi-all yomi-len)))
          (tutcode-context-set-postfix-yomi-len! pc yomi-len)
          (or
            (tutcode-begin-conversion pc yomi () #f #f)
            (tutcode-postfix-mazegaki-relimit-left pc (+ yomi-len 1))))
        ;; Ѥɤߤ­ʤʤä硢¤yomi-maxĹɤߤ
        (and
          (< yomi-all-len tutcode-mazegaki-yomi-max)
          (let ((former-seq (tutcode-postfix-mazegaki-acquire-yomi pc
                             tutcode-mazegaki-yomi-max)))
            (and
              (> (length former-seq) yomi-all-len)
              (begin
                (tutcode-context-set-mazegaki-yomi-all! pc former-seq)
                (tutcode-postfix-mazegaki-relimit-left pc yomi-len)))))))))

;;; ꤵ줿ɤߤѤ줫ɤ֤
;;; @param head оݤɤ
;;; @return #t:Ѥξ硣#f:ʳξ硣
(define (tutcode-mazegaki-inflection? head)
  (and
    (pair? head)
    (string=? "" (car head))))

;;; ѤȤƸַ򤼽Ѵ򳫻Ϥ
;;; @param yomi-len ꤵ줿ɤߤʸꤵƤʤ#f
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-begin-postfix-mazegaki-inflection-conversion pc yomi-len)
  (tutcode-context-set-mazegaki-yomi-len-specified! pc (or yomi-len 0))
  (let*
    ((former-seq (tutcode-postfix-mazegaki-acquire-yomi pc yomi-len))
     (former-len (length former-seq)))
    (if yomi-len
      (and
        (>= former-len yomi-len)
        (let ((yomi (take former-seq yomi-len)))
          (tutcode-context-set-postfix-yomi-len! pc yomi-len)
          (tutcode-context-set-mazegaki-yomi-all! pc yomi)
          (if (tutcode-mazegaki-inflection? yomi)
            ;; Ū""դϤ줿硢ѤʤȤƸ
            ;; (ѤȤƼ갷ϡ""ΰ֤Ĵʤ
            ;;  ˤʤ뤬Ū˻ꤵƤϰĴ)
            (tutcode-begin-conversion pc yomi () #t
              tutcode-use-recursive-learning?)
            (tutcode-mazegaki-inflection-relimit-right pc
              yomi-len yomi-len #f))))
      ;; ɤߤʸꤵƤʤɤ/촴̤ʤѴ
      (and
        (> former-len 0)
        ;; 촴ĹΤͥ褷Ѵ
        (begin
          (tutcode-context-set-postfix-yomi-len! pc former-len)
          (tutcode-context-set-mazegaki-yomi-all! pc former-seq)
          (if (tutcode-mazegaki-inflection? former-seq) ; Ū""
            (tutcode-mazegaki-relimit-right pc former-seq #f)
            (tutcode-mazegaki-inflection-relimit-right pc
              former-len former-len #f)))))))

;;; Ѥθ򤼽ѴΤᡢ
;;; ɤ/촴̤ʤ顢촴ĹȤʤɤߤ򸫤ĤѴԤ
;;; @param yomi-cur-len yomi-allΤǸѴоݤȤʤäƤɤߤĹ
;;; @param len оݤȤ촴Ĺ
;;; @param relimit-first? (ǽμ񸡺)ɤߤ̤뤫ɤ
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-mazegaki-inflection-relimit-right pc yomi-cur-len len
          relimit-first?)
  (and
    (> len 0)
    (let*
      ((yomi-all (tutcode-context-mazegaki-yomi-all pc))
       (len-specified (tutcode-context-mazegaki-yomi-len-specified pc)))
      (or
        ;; 촴Ĺ(len=length head)ݻޤޡɤߤ̤ʤ鸡
        (let loop
          ((yomi-cur (take yomi-all yomi-cur-len))
           (skip-search? relimit-first?))
          (let* ((yomi-len (length yomi-cur))
                 (suffix-len (- yomi-len len)))
            (and
              (>= suffix-len 0)
              (or
                (and
                  (not skip-search?)
                  (<= suffix-len tutcode-mazegaki-suffix-max)
                  (receive (suffix head) (split-at yomi-cur suffix-len)
                    (if (> (tutcode-context-postfix-yomi-len pc) 0) ; ַ?
                      (tutcode-context-set-postfix-yomi-len! pc yomi-len))
                    (tutcode-begin-conversion pc (cons "" head) suffix #f #f)))
                (and
                  (= len-specified 0)
                  ;; ɤߤ1ʸ̤Ƹ
                  (loop (drop-right yomi-cur 1) #f))))))
        ;; 촴1ʸ̤Ƹ
        (tutcode-mazegaki-inflection-relimit-right pc
          (if (> len-specified 0)
            len-specified
            (length yomi-all))
          (- len 1) #f)))))

;;; Ѥθ򤼽ѴΤᡢ
;;; ɤ/촴򿭤Фʤ顢촴ĹȤʤɤߤ򸫤ĤѴԤ
;;; @param yomi-cur-len yomi-allΤǸѴоݤȤʤäƤɤߤĹ
;;; @param len оݤȤ촴Ĺ
;;; @param relimit-first? (ǽμ񸡺)ɤߤ򿭤Ф
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-mazegaki-inflection-relimit-left pc yomi-cur-len len
          relimit-first?)
  (let*
    ((yomi-all (tutcode-context-mazegaki-yomi-all pc))
     (yomi-all-len (length yomi-all))
     (len-specified (tutcode-context-mazegaki-yomi-len-specified pc)))
    (or
      (and
        (<= len yomi-all-len)
        (or
          (let loop
            ((yomi-len yomi-cur-len)
             (skip-search? relimit-first?))
            ;; 촴Ĺ(len=length head)ݻޤɤߤ򿭤Фʤ鸡
            (and
              (<= len yomi-len yomi-all-len)
              (or
                (and
                  (not skip-search?)
                  (<= (- yomi-len len) tutcode-mazegaki-suffix-max)
                  (receive (suffix head)
                           (split-at (take yomi-all yomi-len) (- yomi-len len))
                    (if (> (tutcode-context-postfix-yomi-len pc) 0) ; ַ?
                      (tutcode-context-set-postfix-yomi-len! pc yomi-len))
                    (tutcode-begin-conversion pc
                      (cons "" head) suffix #f #f)))
                ;; ɤߤ1ʸФƸ
                (and
                  (= len-specified 0)
                  (loop (+ yomi-len 1) #f)))))
          ;; 촴1ʸФƸ
          (tutcode-mazegaki-inflection-relimit-left pc
            (if (> len-specified 0)
              yomi-cur-len
              (+ len 1)) ; Ĺθ촴ƤɤߤκûĹ
            (+ len 1) #f)))
      ;; ˿ФϡѤʤθ˰ܹ
      (if (> (tutcode-context-postfix-yomi-len pc) 0) ; ַ?
        (let ((len-new (if (> len-specified 0) len-specified 1)))
          (tutcode-postfix-mazegaki-relimit-left pc len-new))
        ;; ַ
        (tutcode-begin-conversion pc yomi-all () #f #f)))))

;;; 򤼽Ѵrelimit-rightϻνԤ:
;;; ɤ/촴̤ƺƸ
(define (tutcode-mazegaki-proc-relimit-right pc)
  (tutcode-reset-candidate-window pc)
  (let*
    ((head (tutcode-context-head pc))
     (head-len (length head))
     (postfix-yomi-len (tutcode-context-postfix-yomi-len pc))
     (yomi-all (tutcode-context-mazegaki-yomi-all pc))
     (inflection?
      (and (tutcode-mazegaki-inflection? head)
           (not (tutcode-mazegaki-inflection? yomi-all)))) ; Ū""
     (found?
      (if (not inflection?)
        (tutcode-mazegaki-relimit-right pc head #t)
        (tutcode-mazegaki-inflection-relimit-right pc
          (+ (- head-len 1)
             (length (tutcode-context-mazegaki-suffix pc)))
          (- head-len 1) #t)))) ; (car head)""
    (if (not found?) ; ̵ɤ/촴̤Τ
      (tutcode-context-set-postfix-yomi-len! pc postfix-yomi-len))))

;;; 򤼽Ѵrelimit-leftϻνԤ:
;;; ɤ/촴򿭤ФƺƸ
(define (tutcode-mazegaki-proc-relimit-left pc)
  (tutcode-reset-candidate-window pc)
  (let*
    ((head (tutcode-context-head pc))
     (head-len (length head))
     (postfix-yomi-len (tutcode-context-postfix-yomi-len pc))
     (yomi-all (tutcode-context-mazegaki-yomi-all pc))
     (inflection?
      (and (tutcode-mazegaki-inflection? head)
           (not (tutcode-mazegaki-inflection? yomi-all)))) ; Ū""
     (found?
      (if (not inflection?)
        (and (> postfix-yomi-len 0) ; ַξɤߤ򿭤Ф
             (tutcode-postfix-mazegaki-relimit-left pc (+ head-len 1)))
        (tutcode-mazegaki-inflection-relimit-left pc
          (+ (- head-len 1)
             (length (tutcode-context-mazegaki-suffix pc)))
          (- head-len 1) #t)))) ; (car head)""
    (if (not found?) ; ̵ɤ/촴򿭤ФΤ
      (tutcode-context-set-postfix-yomi-len! pc postfix-yomi-len))))

;;; ASCIIʸɤ֤
;;; @param str ʸ
(define (tutcode-ascii? str)
  (let ((ch (string->ichar str)))
    (and ch (<= ch 127))))

;;; ַ򤼽ѴѤɤߤ
;;; @param yomi-len ꤵ줿ɤߤʸꤵƤʤ#f
;;; @return ɤ(ʸεսꥹ)
(define (tutcode-postfix-mazegaki-acquire-yomi pc yomi-len)
  (let ((former-seq (tutcode-postfix-acquire-text pc
                     (or yomi-len tutcode-mazegaki-yomi-max))))
    (if yomi-len
      ;; XXX:ɤߤʸꤵƤ""ޤ롣relimit-left
      ;;     ͳξ桼Ū˻ꤷΤȤߤʤƱͤ˴ޤ롣
      former-seq
      ;; ɤߤʸꤵƤʤǤʸ(yomi-max)
      (let ((last-ascii? (and (pair? former-seq)
                              (tutcode-ascii? (car former-seq)))))
        (take-while
          (lambda (elem)
            (and
              ;; ܸʸASCIIʸζܤСޤǤ
              (eq? (tutcode-ascii? elem) last-ascii?)
              ;; """"ʸɤߤ˴ޤʤ
              (not (member elem tutcode-postfix-mazegaki-terminate-char-list))))
          former-seq)))))

;;; ʸ
;;; @param len ʸ
;;; @return ʸΥꥹ(ս)
(define (tutcode-postfix-acquire-text pc len)
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (not (null? ppc))
      (case (tutcode-context-child-type ppc)
        ((tutcode-child-type-dialog)
          ())
        ((tutcode-child-type-editor)
          (let*
            ((ec (tutcode-context-editor ppc))
             (left-string (tutcode-editor-left-string ec)))
            (if (> (length left-string) len)
              (take left-string len)
              left-string)))
        ((tutcode-child-type-seq2kanji)
          (let ((head (tutcode-context-head ppc)))
            (if (> (length head) len)
              (take head len)
              head))))
      (let*
        ((ustr (im-acquire-text pc 'primary 'cursor len 0))
         (former (and ustr (ustr-former-seq ustr)))
         (former-seq (and (pair? former) (string-to-list (car former)))))
        (if ustr
          (or former-seq ())
          ;; im-acquire-text̤бĶξ硢γʸХåե
          (if tutcode-enable-fallback-surrounding-text?
            (let ((commit-strs (tutcode-context-commit-strs pc)))
              (if (> (length commit-strs) len)
                (take commit-strs len)
                commit-strs))
            ()))))))

;;; ʸ
;;; @param len ʸ
(define (tutcode-postfix-delete-text pc len)
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (not (null? ppc))
      (case (tutcode-context-child-type ppc)
        ((tutcode-child-type-editor)
          (let*
            ((ec (tutcode-context-editor ppc))
             (left-string (tutcode-editor-left-string ec)))
            (tutcode-editor-set-left-string! ec
              (if (> (length left-string) len)
                (drop left-string len)
                ()))))
        ((tutcode-child-type-seq2kanji)
          (let ((head (tutcode-context-head ppc)))
            (tutcode-context-set-head! ppc
              (if (> (length head) len)
                (drop head len)
                ())))))
      (or
        (im-delete-text pc 'primary 'cursor len 0)
        ;; im-delete-text̤бĶξ硢"\b"롣
        ;; XXX:"\b"ǧʸ륢ץǤʤưʤ
        ;; (tutcode-commit-rawϺѥ򤽤ΤޤޥץϤȤꤹ
        ;;  ΤʤΤǡʲΤ褦backspaceǸˤϻȤʤ
        ;;  (tutcode-commit-raw pc 'backspace 0))
        (and tutcode-enable-fallback-surrounding-text?
          (begin
            (let ((commit-strs (tutcode-context-commit-strs pc)))
              (tutcode-context-set-commit-strs! pc
                (if (> (length commit-strs) len)
                  (drop commit-strs len)
                  ())))
            (if (> (string-length tutcode-fallback-backspace-string) 0)
              (tutcode-commit pc
                (apply string-append
                  (make-list len tutcode-fallback-backspace-string))
                #t #t))))))))

;;; selectionФƸ򤼽Ѵ򳫻Ϥ
(define (tutcode-begin-selection-mazegaki-conversion pc)
  (let ((sel (tutcode-selection-acquire-text-wo-nl pc)))
    (if (pair? sel)
      (let ((sel-len (length sel)))
        (tutcode-context-set-mazegaki-yomi-len-specified! pc sel-len)
        (tutcode-context-set-postfix-yomi-len! pc (- sel-len)) ; :selection
        (tutcode-context-set-mazegaki-yomi-all! pc sel)
        (tutcode-begin-conversion pc sel () #t
          tutcode-use-recursive-learning?)))))

;;; selectionФƳѤȤƸ򤼽Ѵ򳫻Ϥ
(define (tutcode-begin-selection-mazegaki-inflection-conversion pc)
  (let ((sel (tutcode-selection-acquire-text-wo-nl pc)))
    (if (pair? sel)
      (let ((sel-len (length sel)))
        (tutcode-context-set-mazegaki-yomi-len-specified! pc sel-len)
        (tutcode-context-set-postfix-yomi-len! pc (- sel-len)) ; :selection
        (tutcode-context-set-mazegaki-yomi-all! pc sel)
        (if (tutcode-mazegaki-inflection? sel)
          (tutcode-begin-conversion pc sel () #t
            tutcode-use-recursive-learning?)
          (tutcode-mazegaki-inflection-relimit-right pc
            sel-len sel-len #f))))))

;;; selectionФƥѴ򳫻Ϥ
(define (tutcode-begin-selection-katakana-conversion pc)
  (let ((sel (tutcode-selection-acquire-text pc)))
    (if (pair? sel)
      (let* ((katakana (tutcode-katakana-convert sel
                        (not (tutcode-context-katakana-mode? pc))))
             (str (string-list-concat katakana)))
        (tutcode-selection-commit pc str sel)
        (if (= (length katakana) 1) ; 1ʸξ硢ưإɽ(tc2Ʊ)
          (tutcode-check-auto-help-window-begin pc katakana ()))))))

;;; selectionФƴϥѴ򳫻Ϥ
(define (tutcode-begin-selection-kanji2seq-conversion pc)
  (let ((sel (tutcode-selection-acquire-text pc)))
    (if (pair? sel)
      (tutcode-selection-commit pc
        (string-list-concat (tutcode-kanji-list->sequence pc sel)) sel))))

;;; selectionФϥ󥹢Ѵ򳫻Ϥ
(define (tutcode-begin-selection-seq2kanji-conversion pc)
  (let ((sel (tutcode-selection-acquire-text pc)))
    (if (pair? sel)
      (tutcode-selection-commit pc
        (string-list-concat (tutcode-sequence->kanji-list pc sel)) sel))))

;;; selectionФѴꤹ
;;; @param str ꤹʸ
;;; @param yomi-list Ѵʸ(ɤ/)Υꥹ(ս)
(define (tutcode-selection-commit pc str yomi-list)
  ;; commitselection񤭤Τdelete-text
  ;(im-delete-text pc 'selection 'beginning 0 'full)
  (tutcode-commit pc str)
  (tutcode-undo-prepare pc 'tutcode-state-off str yomi-list))

;;; selectionʸԤƼ
;;; @return ʸΥꥹ(ս)
(define (tutcode-selection-acquire-text-wo-nl pc)
  (let ((latter-seq (tutcode-selection-acquire-text pc)))
    (and (pair? latter-seq)
         (delete "\n" latter-seq))))

;;; selectionʸ
;;; @return ʸΥꥹ(ս)
(define (tutcode-selection-acquire-text pc)
  (and-let*
    ((ustr (im-acquire-text pc 'selection 'beginning 0 'full))
     (latter (ustr-latter-seq ustr))
     (latter-seq (and (pair? latter) (string-to-list (car latter)))))
    (and (not (null? latter-seq))
         latter-seq)))

;;; ַѴꤹ
;;; @param yomi ɤ
;;; @param katakana ɤߤ򥫥ʤѴʸꥹ
;;; @param show-help? katakana1ʸξ˼ưإפɽ뤫ɤ
(define (tutcode-postfix-katakana-commit pc yomi katakana show-help?)
  (let ((str (string-list-concat katakana)))
    (tutcode-postfix-commit pc str yomi)
    (tutcode-flush pc)
    (if (and show-help?
             (= (length katakana) 1)) ; 1ʸξ硢ưإɽ(tc2Ʊ)
      (tutcode-check-auto-help-window-begin pc katakana ()))))

;;; ַѴ򳫻Ϥ
;;; @param yomi-len ꤵ줿ɤߤʸꤵƤʤ#f
;;;   0: Ҥ餬ʤ䡼³֥ʤѴ롣
;;;   : ͤʸҤ餬ʤȤƻĤƥѴ
;;;   (ʤѴʸĹʸΤݤʾ)
;;;   㤨Фפꤱj2㤨Хץꥱ
(define (tutcode-begin-postfix-katakana-conversion pc yomi-len)
  (let*
    ((former-all (tutcode-postfix-katakana-acquire-yomi pc
      (if (and yomi-len (<= yomi-len 0)) #f yomi-len)))
     (former-seq
      (cond
        ((not yomi-len)
          former-all)
        ((>= yomi-len 0)
          former-all)
        (else
          (let ((len (- yomi-len)))
            (if (<= (length former-all) len)
              ()
              (drop-right former-all len)))))))
    (if yomi-len
      (let ((katakana (tutcode-katakana-convert former-seq
                        (not (tutcode-context-katakana-mode? pc)))))
        (tutcode-postfix-katakana-commit pc former-seq katakana #t))
      ;; ɤߤʸꤵƤʤ
      (if (pair? former-seq)
        (begin
          (tutcode-context-set-mazegaki-yomi-all! pc former-all)
          (tutcode-context-set-head! pc
            (tutcode-katakana-convert former-seq
              (not (tutcode-context-katakana-mode? pc))))
          (tutcode-context-set-state! pc 'tutcode-state-postfix-katakana))))))

;;; ľθַѴ̤
;;; @param count ̤ʸ
(define (tutcode-postfix-katakana-shrink pc count)
  (let ((undo (tutcode-context-undo pc)))
    (if (and (pair? undo)
             (eq? (list-ref undo 0) 'tutcode-state-off)) ; ַѴ
      (let* ((commit-len (list-ref undo 1))
             (yomi (list-ref undo 2))
             (yomi-len (length yomi)))
        (tutcode-postfix-delete-text pc commit-len)
        (receive (kata hira)
          (if (< count yomi-len)
            (split-at yomi (- yomi-len count))
            (values () yomi))
          (let ((str (string-list-concat
                      (append
                        (tutcode-katakana-convert kata
                          (not (tutcode-context-katakana-mode? pc)))
                        hira))))
            (tutcode-commit pc str)
            ;; shrink򷫤֤ݤcountʸĥʤ̤褦
            (tutcode-undo-prepare pc 'tutcode-state-off
              (string-list-concat kata) kata)))))))

;;; ַѴоʸ
;;; @param yomi-len ꤵ줿ʸꤵƤʤ#f
;;; @return ʸ(ʸεսꥹ)
(define (tutcode-postfix-katakana-acquire-yomi pc yomi-len)
  (let ((former-seq (tutcode-postfix-acquire-text pc
                     (or yomi-len tutcode-mazegaki-yomi-max))))
    (if yomi-len
      former-seq
      (let ((hira (take-while
                    (lambda (char)
                      (tutcode-postfix-katakana-acquire-char? pc char))
                    former-seq)))
        ;; ֥ȤФ塼פФơ1ʸĤƥѴ
        ;; ֥ȥХ塼פˤʤ褦ˡҤ餬󤬡֡פǻϤޤϽ
        (reverse
          (drop-while
            (lambda (char)
              (member char tutcode-postfix-katakana-char-list))
            (reverse hira)))))))

;;; ַѴоʸ(Ҥ餬ʡ)ɤ֤
(define (tutcode-postfix-katakana-acquire-char? pc char)
  (or (if (tutcode-context-katakana-mode? pc)
        (tutcode-katakana? char) ; ʥ⡼ɻϥо
        (tutcode-hiragana? char))
      (member char tutcode-postfix-katakana-char-list)))

;;; Ҥ餬ʤɤ
(define (tutcode-hiragana? s)
  (and (string>=? s "") (string<=? s "")))
;;; ʤɤ
(define (tutcode-katakana? s)
  (and (string>=? s "") (string<=? s "")))

;;; ַѴ⡼ɻΥϤ롣
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-postfix-katakana c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (head (tutcode-context-head pc)))
    (cond
      ((tutcode-cancel-key? key key-state)
        (tutcode-flush pc))
      ((or (tutcode-commit-key? key key-state)
           (tutcode-return-key? key key-state))
        (tutcode-postfix-katakana-commit pc
          (take (tutcode-context-mazegaki-yomi-all pc) (length head))
          head #t))
      ((tutcode-mazegaki-relimit-right-key? key key-state)
        (if (> (length head) 1)
          (tutcode-context-set-head! pc (drop-right head 1))))
      ((tutcode-mazegaki-relimit-left-key? key key-state)
        (let ((yomi-all (tutcode-context-mazegaki-yomi-all pc))
              (cur-len (length head)))
          (if (> (length yomi-all) cur-len)
            (tutcode-context-set-head! pc
              (tutcode-katakana-convert
                (take yomi-all (+ cur-len 1))
                (not (tutcode-context-katakana-mode? pc)))))))
      (else
        (tutcode-postfix-katakana-commit pc
          (take (tutcode-context-mazegaki-yomi-all pc) (length head))
          head #f)
        (tutcode-proc-state-on pc key key-state)))))

;;; ΥꥹȤϥ󥹤Ѵ롣
;;; Ϥü뤿Ϥ줿;ʬverbose-stroke-keyϺ֤
;;; @param kanji-list ʸꥹ(ս)
;;; @return ϥʸꥹ(ս)
;;;  Υ󥹤Ϥkanji-list롣
;;;XXX:ɽˡФʣΥ󥹤硢ǽΤΤ
;;;    ʸ⤢硢ʸ󥹤Ȥ롣
;;;    :"CODE "Ǹ"COD"ɽϥѴ"CODe "
(define (tutcode-kanji-list->sequence pc kanji-list)
  (let*
    ((rule (rk-context-rule (tutcode-context-rk-context pc)))
     (allseq
      (append-map
        (lambda (x)
          (let ((seq (tutcode-reverse-find-seq x rule)))
            ;; ľϤǤʤϴΤޤ(XXX:ˡޤɽ?)
            (if seq (reverse seq) (list x))))
        kanji-list)))
    ;; Ǹverbose-stroke-key(:":")ϴϤü뤿
    ;; ;ʬϤ줿ǽΤǺ
    ;; : "undo:""o"("o" "")"code:"":"(":" "" "")
    (if (and (pair? allseq)
             (tutcode-verbose-stroke-key? (string->ichar (car allseq)) 0))
      (cdr allseq)
      allseq)))

;;; ַδϥѴ򳫻Ϥ
;;; @param yomi-len ꤵ줿ɤߤʸꤵƤʤ#f
;;;  0ξϡ#fƱͤ˰оʸ⡼ɤ餺˳ꡣ
(define (tutcode-begin-postfix-kanji2seq-conversion pc yomi-len)
  (let*
    ((former-all (tutcode-postfix-acquire-text pc
      (if (and yomi-len (> yomi-len 0)) yomi-len tutcode-mazegaki-yomi-max)))
     (former-seq
      (if (and yomi-len (> yomi-len 0))
        former-all
        (let*
          ;; verbose-stroke-key" "(ǥե)ξ硢;ʬϤƤ
          ;; takeʤΤǡ;ʬverbose-stroke-keyϥåס
          ;; (tutcode-kanji-list->sequence;ʬverbose-stroke-key)
          ;; :"undo """("" "")"code "" "(" " "" "")
          ((first (safe-car former-all))
           (first-verbose-key?
            (tutcode-verbose-stroke-key? (and first (string->ichar first)) 0))
           (rest (if first-verbose-key? (cdr former-all) former-all))
           (seq
            (take-while
              (lambda (elem)
                (not (member elem
                      (append tutcode-postfix-kanji2seq-delimiter-char-list
                        '("\n" "\t")))))
              rest)))
          (if first-verbose-key?
            (cons first seq) ; delete-textĹ碌뤿first
            seq)))))
    (if yomi-len
      (let ((seq (tutcode-kanji-list->sequence pc former-seq)))
        (tutcode-postfix-commit pc (string-list-concat seq) former-seq))
      ;; ɤߤʸꤵƤʤ
      (if (pair? former-seq)
        (begin
          (tutcode-context-set-mazegaki-yomi-all! pc former-all)
          (tutcode-context-set-postfix-yomi-len! pc (length former-seq))
          (tutcode-context-set-head! pc
            (tutcode-kanji-list->sequence pc former-seq))
          (tutcode-context-set-state! pc 'tutcode-state-postfix-kanji2seq))))))

;;; ַδϥѴ⡼ɻΥϤ롣
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-postfix-kanji2seq c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (head (tutcode-context-head pc))
     (yomi-len (tutcode-context-postfix-yomi-len pc))
     (yomi-all (tutcode-context-mazegaki-yomi-all pc))
     (update-context!
      (lambda (new-yomi-len)
        (tutcode-context-set-postfix-yomi-len! pc new-yomi-len)
        (tutcode-context-set-head! pc
          (tutcode-kanji-list->sequence pc (take yomi-all new-yomi-len)))))
     (commit
      (lambda ()
        (let*
          ((len (if (and tutcode-delete-leading-delimiter-on-postfix-kanji2seq?
                         (> (length yomi-all) yomi-len)
                         (member (list-ref yomi-all yomi-len)
                          tutcode-postfix-kanji2seq-delimiter-char-list))
                  (+ yomi-len 1)
                  yomi-len))
           (yomi (take yomi-all len)))
          (tutcode-postfix-commit pc (string-list-concat head) yomi)
          (tutcode-flush pc)))))
    (cond
      ((tutcode-cancel-key? key key-state)
        (tutcode-flush pc))
      ((or (tutcode-commit-key? key key-state)
           (tutcode-return-key? key key-state))
        (commit))
      ((tutcode-mazegaki-relimit-right-key? key key-state)
        (if (> yomi-len 1)
          (update-context! (- yomi-len 1))))
      ((tutcode-mazegaki-relimit-left-key? key key-state)
        (if (> (length yomi-all) yomi-len)
          (update-context! (+ yomi-len 1))))
      (else
        (commit)
        (tutcode-proc-state-on pc key key-state)))))

;;; ϥ󥹤Ѵ
;;; @param sequence ϥ󥹡ʸΥꥹ(ս)
;;; @return ѴδʸΥꥹ(ս)
(define (tutcode-sequence->kanji-list pc sequence)
  (if (null? sequence)
    ()
    (let ((string->key-and-status
            (lambda (s)
              (let ((ch (string->ichar s)))
                (cond
                  ;; key-press-handlerϤᡢsymbolѴ(uim-key.c)
                  ;; (tutcode-return-key?ǥޥå褦ˤ뤿)
                  ((not (integer? ch)) (cons ch 0)) ; sξch#f
                  ((= ch 8) '(backspace . 0))
                  ((= ch 9) '(tab . 0))
                  ((= ch 10) '(return . 0))
                  ((= ch 27) '(escape . 0))
                  ((= ch 127) '(delete . 0))
                  ((ichar-control? ch)
                    (cons (ichar-downcase (+ ch 64)) 2)) ; ex. "<Control>j"
                  ((ichar-upper-case? ch)
                    ;; key-predicateѤshift-key-maskset
                    ;; downcaseruleȰפʤʤΤǤΤޤޡ
                    (cons ch 1))
                  (else (cons ch 0))))))
          (key? (lambda (k) (or (integer? k) (key-symbol? k))))
          (commit-pending-rk
            (lambda (c)
              (let ((rkc (tutcode-context-rk-context c)))
                (if (pair? (rk-context-seq rkc))
                  (tutcode-commit c (rk-pending rkc) #f #t)))))
          (head-save (tutcode-context-head pc))
          ;; ŪΤ̣߰ΤإɽϰŪ˥դˤ
          ;; (䴰/ͽ¬ϤϤҤäȤƻȤ⤷ʤΤǤΤޤ)
          (use-candwin-save tutcode-use-candidate-window?)
          (use-stroke-help-win-save tutcode-use-stroke-help-window?)
          (use-auto-help-win-save tutcode-use-auto-help-window?)
          (use-kanji-combination-guide-save tutcode-use-kanji-combination-guide?)
          (stroke-help-with-guide-save
            tutcode-stroke-help-with-kanji-combination-guide)
          ;; child contextäƤkey-press򿩤碌
          (cpc (tutcode-setup-child-context pc 'tutcode-child-type-seq2kanji)))
      (tutcode-context-set-head! pc ()) ; contextǤcommitheadˤ
      (set! tutcode-use-candidate-window? #f)
      (set! tutcode-use-stroke-help-window? #f)
      (set! tutcode-use-auto-help-window? #f)
      (set! tutcode-use-kanji-combination-guide? #f)
      (set! tutcode-stroke-help-with-kanji-combination-guide 'disable)
      (for-each
        (lambda (s)
          (let ((k-s (string->key-and-status s)))
            (if (key? (car k-s))
              (tutcode-key-press-handler-internal cpc (car k-s) (cdr k-s))
              (begin ; ϤΤޤ
                (commit-pending-rk cpc)
                (tutcode-flush cpc)
                (tutcode-commit cpc s)))))
        (reverse sequence))
      (commit-pending-rk cpc) ; Ǿ̤pendingΤ߳ꡣäȤ줷ʤ
      ;; XXX:ϳʸΤ߼̤ʸϾä
      (let ((kanji-list (tutcode-context-head pc)))
        (tutcode-flush cpc)
        (tutcode-context-set-child-context! pc ())
        (tutcode-context-set-child-type! pc ())
        (tutcode-context-set-head! pc head-save)
        (set! tutcode-use-candidate-window? use-candwin-save)
        (set! tutcode-use-stroke-help-window? use-stroke-help-win-save)
        (set! tutcode-use-auto-help-window? use-auto-help-win-save)
        (set! tutcode-use-kanji-combination-guide?
          use-kanji-combination-guide-save)
        (set! tutcode-stroke-help-with-kanji-combination-guide
          stroke-help-with-guide-save)
        kanji-list))))

;;; ҥƥȤǤcommit
;;; @param str commit줿ʸ
(define (tutcode-seq2kanji-commit-from-child pc str)
  (tutcode-context-set-head! pc
    (append (string-to-list str) (tutcode-context-head pc))))

;;; ҥƥȤǤcommit-raw
(define (tutcode-seq2kanji-commit-raw-from-child pc key key-state)
  (let ((raw-str
          (im-get-raw-key-str
            (cond
              ;; tutcode-sequence->kanji-listѴsymbolcharcode᤹
              ((eq? key 'backspace) 8)
              ((eq? key 'tab) 9)
              ((eq? key 'return) 10)
              ((eq? key 'escape) 27)
              ((eq? key 'delete) 127)
              ((control-key-mask key-state)
                (- (ichar-upcase key) 64))
              ((shift-key-mask key-state)
                (ichar-upcase key))
              (else key))
            0)))
    (if raw-str
      (tutcode-seq2kanji-commit-from-child pc raw-str))))

;;; ַϥ󥹢Ѵ򳫻Ϥ
;;; @param yomi-len ꤵ줿ɤߤʸꤵƤʤ#f
(define (tutcode-begin-postfix-seq2kanji-conversion pc yomi-len)
  (let*
    ((former-all (tutcode-postfix-acquire-text pc
                  (or yomi-len tutcode-mazegaki-yomi-max)))
     (former-seq
      (if yomi-len
        former-all
        ;; Ƭξ硢򤼽ѴγβǽΤǡԤޤ
        (receive
          (newlines rest)
          (span
            (lambda (x)
              (string=? x "\n"))
            former-all)
          (append newlines
            (take-while
              (lambda (elem)
                (and (tutcode-ascii? elem)
                     (not (string=? elem "\n"))))
              rest))))))
    (if (pair? former-seq)
      (let ((kanji-list (tutcode-sequence->kanji-list pc former-seq)))
        (if yomi-len
          (begin
            (tutcode-postfix-commit pc
              (string-list-concat kanji-list) former-seq)
            (tutcode-flush pc))
          ;; ɤߤʸꤵƤʤ
          (begin
            (tutcode-context-set-mazegaki-yomi-all! pc former-all)
            (tutcode-context-set-postfix-yomi-len! pc (length former-seq))
            (tutcode-context-set-head! pc kanji-list)
            (tutcode-context-set-state! pc
              'tutcode-state-postfix-seq2kanji)))))))

;;; ַϥ󥹢Ѵ⡼ɻΥϤ롣
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-postfix-seq2kanji c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (yomi-len (tutcode-context-postfix-yomi-len pc))
     (yomi-all (tutcode-context-mazegaki-yomi-all pc))
     (update-context!
      (lambda (new-yomi-len)
        (tutcode-context-set-postfix-yomi-len! pc new-yomi-len)
        (tutcode-context-set-head! pc
          (tutcode-sequence->kanji-list pc (take yomi-all new-yomi-len)))))
     (commit
      (lambda ()
        (tutcode-postfix-commit pc
          (string-list-concat (tutcode-context-head pc))
          (take yomi-all yomi-len))
        (tutcode-flush pc))))
    (cond
      ((tutcode-cancel-key? key key-state)
        (tutcode-flush pc))
      ((or (tutcode-commit-key? key key-state)
           (tutcode-return-key? key key-state))
        (commit))
      ((tutcode-mazegaki-relimit-right-key? key key-state)
        (if (> yomi-len 1)
          ;; ַ򤼽񤭤ǳꤵƤʤʸʤɡ
          ;; relimit-rightѴʸ󤬿Ӥ礢ꡣ
          ;; :"aljrk""" > "ljrk""ߤ"
          (update-context! (- yomi-len 1))))
      ((tutcode-mazegaki-relimit-left-key? key key-state)
        (if (> (length yomi-all) yomi-len)
          (update-context! (+ yomi-len 1))))
      (else
        (commit)
        (tutcode-proc-state-on pc key key-state)))))

;;; ľϾ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-off c key key-state)
  (let ((pc (tutcode-find-descendant-context c)))
    (cond
      ((tutcode-on-key? key key-state)
        (tutcode-context-set-state! pc 'tutcode-state-on))
      ((tutcode-off-key? key key-state) ; on-keyoff-key̥ξ
        ) ; onǤoffǤ⡢off-keyoffˤʤΤcommit-raw
      (else
        (tutcode-commit-raw pc key key-state)))))

;;; ϥ⡼ɻΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-kigou c key key-state)
  (let ((pc (tutcode-find-descendant-context c)))
    (cond
      ((and
        (tutcode-vi-escape-key? key key-state)
        tutcode-use-with-vi?)
       (tutcode-reset-candidate-window pc)
       (tutcode-context-set-state! pc 'tutcode-state-off)
       (tutcode-commit-raw pc key key-state)) ; ESC򥢥ץˤϤ
      ((tutcode-off-key? key key-state)
       (tutcode-reset-candidate-window pc)
       (tutcode-context-set-state! pc 'tutcode-state-off))
      ((tutcode-kigou-toggle-key? key key-state)
       (tutcode-reset-candidate-window pc)
       (tutcode-context-set-state! pc 'tutcode-state-on))
      ((tutcode-kigou2-toggle-key? key key-state)
       (tutcode-reset-candidate-window pc)
       (if (not (tutcode-kigou2-mode? pc))
         (tutcode-toggle-kigou2-mode pc))
       (tutcode-context-set-state! pc 'tutcode-state-on))
      ;; ڡѥڡϲǽȤ뤿ᡢ
      ;; next-candidate-key?Υåheading-label-char?å
      ((and (not (and (modifier-key-mask key-state)
                      (not (shift-key-mask key-state))))
            (tutcode-heading-label-char-for-kigou-mode? key)
            (tutcode-commit-by-label-key-for-kigou-mode pc
              (charcode->string key)))
        (if (eq? (tutcode-context-candidate-window pc)
                 'tutcode-candidate-window-kigou)
          (tutcode-select-candidate pc (tutcode-context-nth pc))))
      ((tutcode-next-candidate-key? key key-state)
        (tutcode-change-candidate-index pc 1))
      ((tutcode-prev-candidate-key? key key-state)
        (tutcode-change-candidate-index pc -1))
      ((tutcode-cancel-key? key key-state)
        (tutcode-reset-candidate-window pc)
        (tutcode-begin-kigou-mode pc))
      ((tutcode-next-page-key? key key-state)
        (tutcode-change-candidate-index pc
          tutcode-nr-candidate-max-for-kigou-mode))
      ((tutcode-prev-page-key? key key-state)
        (tutcode-change-candidate-index pc
          (- tutcode-nr-candidate-max-for-kigou-mode)))
      ((tutcode-commit-key? key key-state) ; return-keyϥץϤ
        (tutcode-commit pc (tutcode-prepare-commit-string-for-kigou-mode pc)))
      (else
        (tutcode-commit-raw pc key key-state)))))

;;; ҥȥϥ⡼ɻΥϤ롣
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-history c key key-state)
  (let ((pc (tutcode-find-descendant-context c)))
    (cond
      ((tutcode-next-candidate-key? key key-state)
        (tutcode-change-candidate-index pc 1))
      ((tutcode-prev-candidate-key? key key-state)
        (tutcode-change-candidate-index pc -1))
      ((tutcode-next-page-key? key key-state)
        (tutcode-change-candidate-index pc
          tutcode-nr-candidate-max-for-history))
      ((tutcode-prev-page-key? key key-state)
        (tutcode-change-candidate-index pc
          (- tutcode-nr-candidate-max-for-history)))
      ((tutcode-cancel-key? key key-state)
        (tutcode-flush pc))
      ((and (not (and (modifier-key-mask key-state)
                      (not (shift-key-mask key-state))))
            (tutcode-heading-label-char-for-history? key)
            (tutcode-commit-by-label-key-for-history pc
              (charcode->string key))))
      ((or (tutcode-commit-key? key key-state)
           (tutcode-return-key? key key-state))
        (let ((str (tutcode-prepare-commit-string-for-history pc)))
          (tutcode-commit pc str)
          (tutcode-flush pc)
          (tutcode-check-auto-help-window-begin pc (string-to-list str) ())))
      (else
        (tutcode-commit pc (tutcode-prepare-commit-string-for-history pc))
        (tutcode-flush pc)
        (tutcode-proc-state-on pc key key-state)))))

;;; ʸꥹȤ򥫥ʤѴ
;;; @param strlist ʸΥꥹ
;;; @param to-katakana? ʤѴ#tҤ餬ʤѴ#f
;;; @return Ѵʸꥹ
(define (tutcode-katakana-convert strlist to-katakana?)
  ;;XXX:ʥʺ߻ȿž(ʤ)̤б
  (let ((idx (if to-katakana? 1 0)))
    (map
      (lambda (e)
        (list-ref (ja-find-kana-list-from-rule ja-rk-rule e) idx))
      strlist)))

;;; 򤼽ѴɤϾ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-yomi c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (rkc (tutcode-context-rk-context pc))
     (head (tutcode-context-head pc))
     (kigou2-mode? (tutcode-kigou2-mode? pc))
     (res #f)
     (katakana-commit
      (lambda ()
        (let ((str
                (string-list-concat
                  (tutcode-katakana-convert head
                    (not (tutcode-context-katakana-mode? pc))))))
          (tutcode-commit pc str)
          (tutcode-flush pc)
          (tutcode-undo-prepare pc 'tutcode-state-yomi str head))))
     (rk-append-flush
      (lambda ()
        (if tutcode-keep-illegal-sequence?
          (tutcode-context-set-head! pc (append (rk-context-seq rkc) head)))
        (rk-flush rkc)))
     ;; reset-candidate-windowǥꥻåȤΤ¸Ƥ
     (predicting?
      (eq? (tutcode-context-predicting pc) 'tutcode-predicting-prediction))
     ;; ͽ¬ϸɽΥڡưϡreset-candidate-window
     (prediction-keys-handled?
      (if predicting?
        (cond
          ((tutcode-next-page-key? key key-state)
            (tutcode-change-prediction-page pc #t)
            #t)
          ((tutcode-prev-page-key? key key-state)
            (tutcode-change-prediction-page pc #f)
            #t)
          (else
            #f))
        #f)))
    (if (not prediction-keys-handled?)
      (begin
        (tutcode-reset-candidate-window pc)
        (cond
          ((tutcode-off-key? key key-state)
           (tutcode-flush pc)
           (tutcode-context-set-state! pc 'tutcode-state-off))
          ((and (tutcode-kana-toggle-key? key key-state)
                (not (tutcode-context-latin-conv pc))
                (not kigou2-mode?))
           (rk-append-flush)
           (tutcode-context-kana-toggle pc))
          ((tutcode-kigou2-toggle-key? key key-state)
           (rk-append-flush)
           (tutcode-toggle-kigou2-mode pc))
          ((tutcode-backspace-key? key key-state)
           (if (> (length (rk-context-seq rkc)) 0)
            (rk-flush rkc)
            (if (> (length head) 0)
              (begin
                (tutcode-context-set-head! pc (cdr head))
                (if (and predicting? (> tutcode-prediction-start-char-count 0))
                  (tutcode-check-prediction pc #f))))))
          ((or
            (tutcode-commit-key? key key-state)
            (tutcode-return-key? key key-state))
           (tutcode-commit pc (string-list-concat head))
           (tutcode-flush pc))
          ((tutcode-cancel-key? key key-state)
           (tutcode-flush pc))
          ((tutcode-stroke-help-toggle-key? key key-state)
           (tutcode-toggle-stroke-help pc))
          ((and tutcode-use-prediction?
                (tutcode-begin-completion-key? key key-state))
           (rk-append-flush)
           (if (not predicting?)
             (tutcode-check-prediction pc #t)))
          ;; 1Ĥξ硢Ѵ弫ưꤵconverting⡼ɤʤ
          ;; ΤǡξǤpurgeǤ褦ˡǥå
          ((and (tutcode-purge-candidate-key? key key-state)
                (not (null? head))
                (not kigou2-mode?))
           ;; converting⡼ɤ˰ܹԤƤpurge
           (tutcode-begin-conversion pc head () #f #f)
           (if (eq? (tutcode-context-state pc) 'tutcode-state-converting)
             (tutcode-proc-state-converting pc key key-state)))
          ((and (tutcode-register-candidate-key? key key-state)
                tutcode-use-recursive-learning?
                (not kigou2-mode?))
           (tutcode-context-set-state! pc 'tutcode-state-converting)
           (tutcode-setup-child-context pc 'tutcode-child-type-editor))
          ((tutcode-katakana-commit-key? key key-state)
            (katakana-commit))
          ((tutcode-paste-key? key key-state)
            (let ((latter-seq (tutcode-clipboard-acquire-text-wo-nl pc 'full)))
              (if (pair? latter-seq)
                (tutcode-context-set-head! pc (append latter-seq head)))))
          ((symbol? key)
           (tutcode-flush pc)
           (tutcode-proc-state-on pc key key-state))
          ((and
            (modifier-key-mask key-state)
            (not (shift-key-mask key-state)))
           ;; <Control>nǤѴ?
           (if (tutcode-begin-conv-key? key key-state)
             (if (not (null? head))
               (tutcode-begin-conversion-with-inflection pc #t)
               (tutcode-flush pc))
             (begin
               (tutcode-flush pc)
               (tutcode-proc-state-on pc key key-state))))
          ;; ͽ¬ϸѥ٥륭?
          ((and predicting?
                (tutcode-heading-label-char-for-prediction? key)
                (tutcode-commit-by-label-key-for-prediction pc
                  (charcode->string key) 'tutcode-predicting-prediction)))
          ((tutcode-context-latin-conv pc)
           (if (tutcode-begin-conv-key? key key-state) ; spaceǤѴ?
             (if (not (null? head))
               (tutcode-begin-conversion-with-inflection pc #t)
               (tutcode-flush pc))
             (set! res (charcode->string key))))
          ((not (rk-expect-key? rkc (charcode->string key)))
           (if (> (length (rk-context-seq rkc)) 0)
             (begin
               (cond
                 ((tutcode-verbose-stroke-key? key key-state)
                   (tutcode-context-set-head! pc
                     (append (rk-context-seq rkc) head)))
                 (tutcode-keep-illegal-sequence?
                   (tutcode-context-set-head! pc
                     (append (rk-context-seq rkc) head))
                   (set! res (charcode->string key))))
               (rk-flush rkc))
             ;; spaceǤѴ?
             ;; (spaceϥ󥹤˴ޤޤ礬Τǡ
             ;;  rk-expectspace̵Ȥ)
             ;; (trycodespaceǻϤޤ륭󥹤ȤäƤ硢
             ;;  spaceѴϤϤǤʤΤǡ<Control>nȤɬפ)
             (if (tutcode-begin-conv-key? key key-state)
               (if (not (null? head))
                 (tutcode-begin-conversion-with-inflection pc #t)
                 (tutcode-flush pc))
               (set! res (charcode->string key)))))
          (else
           (set! res (tutcode-push-key! pc (charcode->string key)))
           (if (eq? res 'tutcode-postfix-bushu-start)
            (begin
              (set! res
                (and (>= (length head) 2)
                     (tutcode-bushu-convert (cadr head) (car head))))
              (if res
                (begin
                  (tutcode-context-set-head! pc (cddr head))
                  (tutcode-check-auto-help-window-begin pc (list res) ())))))))
        (cond
          ((string? res)
            (tutcode-append-string pc res)
            (if (and tutcode-use-prediction?
                     (> tutcode-prediction-start-char-count 0)
                     ;; ַѴˤauto-helpɽѻϲ⤷ʤ
                     (eq? (tutcode-context-candidate-window pc)
                          'tutcode-candidate-window-off))
              (tutcode-check-prediction pc #f)))
          ((symbol? res)
            (case res
              ((tutcode-auto-help-redisplay)
                (tutcode-auto-help-redisplay pc))
              ;; ѤʤȤѴϡ䤬1Ĥξϼư
              ((tutcode-postfix-mazegaki-start)
                (if (not (null? head))
                  (tutcode-begin-conversion-with-inflection pc #f)
                  (begin
                    (tutcode-flush pc)
                    (tutcode-begin-postfix-mazegaki-conversion pc #f #f #f))))
              ;; ѤȤѴ(postfixѥ󥹤ή)
              ((tutcode-postfix-mazegaki-inflection-start)
                (if (not (null? head))
                  (tutcode-begin-mazegaki-inflection-conversion pc)
                  (begin
                    (tutcode-flush pc)
                    (tutcode-begin-postfix-mazegaki-inflection-conversion pc #f))))
              ((tutcode-postfix-katakana-start)
                (if (not (null? head))
                  (katakana-commit)
                  (begin
                    (tutcode-flush pc)
                    (tutcode-begin-postfix-katakana-conversion pc #f))))
              ;; ϥѴclipboardpaste
              ((tutcode-postfix-kanji2seq-start)
                (if (not (null? head))
                  (let ((str
                          (string-list-concat
                            (tutcode-kanji-list->sequence pc head))))
                    (tutcode-commit pc str)
                    (tutcode-flush pc)
                    (tutcode-undo-prepare pc 'tutcode-state-yomi str head))
                  (begin
                    (tutcode-flush pc)
                    (tutcode-begin-postfix-kanji2seq-conversion pc #f))))))
          ((procedure? res)
            (res 'tutcode-state-yomi pc)))))))

;;; Ͼ֤ΤȤΥϤ롣
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-code c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (head (tutcode-context-head pc))
     (res #f))
    (cond
      ((and tutcode-use-with-vi?
            (tutcode-vi-escape-key? key key-state))
        (tutcode-flush pc)
        (tutcode-context-set-state! pc 'tutcode-state-off)
        (tutcode-commit-raw pc key key-state)) ; ESC򥢥ץˤϤ
      ((tutcode-off-key? key key-state)
        (tutcode-flush pc)
        (tutcode-context-set-state! pc 'tutcode-state-off))
      ((tutcode-kigou-toggle-key? key key-state)
        (tutcode-flush pc)
        (tutcode-begin-kigou-mode pc))
      ((tutcode-kigou2-toggle-key? key key-state)
        (tutcode-flush pc)
        (if (not (tutcode-kigou2-mode? pc))
          (tutcode-toggle-kigou2-mode pc)))
      ((tutcode-backspace-key? key key-state)
        (if (pair? head)
          (tutcode-context-set-head! pc (cdr head))))
      ((tutcode-cancel-key? key key-state)
        (tutcode-flush pc))
      ((or (tutcode-commit-key? key key-state)
           (tutcode-return-key? key key-state))
        (tutcode-commit pc (string-list-concat head))
        (tutcode-flush pc))
      ((tutcode-paste-key? key key-state)
        (let ((latter-seq (tutcode-clipboard-acquire-text-wo-nl pc 'full)))
          (if (pair? latter-seq)
            (tutcode-context-set-head! pc (append latter-seq head)))))
      ((symbol? key)
        (tutcode-flush pc)
        (tutcode-proc-state-on pc key key-state))
      ((and (modifier-key-mask key-state)
            (not (shift-key-mask key-state)))
        (if (tutcode-begin-conv-key? key key-state) ; <Control>nǤѴ?
          (if (pair? head)
            (tutcode-begin-kanji-code-input pc head)
            (tutcode-flush pc))
          (begin
            (tutcode-flush pc)
            (tutcode-proc-state-on pc key key-state))))
      ((tutcode-begin-conv-key? key key-state) ; spaceǤѴ?
        (if (pair? head)
          (tutcode-begin-kanji-code-input pc head)
          (tutcode-flush pc)))
      (else
        (tutcode-append-string pc (charcode->string key))))))

;;; ѴϾ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-bushu c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (rkc (tutcode-context-rk-context pc))
     (res #f)
     (predicting?
      (eq? (tutcode-context-predicting pc) 'tutcode-predicting-bushu))
     (re-predict
      (lambda ()
        (if tutcode-use-bushu-prediction?
          (let ((prevchar (car (tutcode-context-head pc))))
            (if (not (string=? prevchar ""))
              (tutcode-check-bushu-prediction pc prevchar)))))))
    (tutcode-reset-candidate-window pc)
    (cond
      ((tutcode-off-key? key key-state)
       (tutcode-flush pc)
       (tutcode-context-set-state! pc 'tutcode-state-off))
      ((and (tutcode-kana-toggle-key? key key-state)
            (not (tutcode-kigou2-mode? pc)))
       (rk-flush rkc)
       (tutcode-context-kana-toggle pc))
      ((tutcode-kigou2-toggle-key? key key-state)
       (rk-flush rkc)
       (tutcode-toggle-kigou2-mode pc))
      ((tutcode-backspace-key? key key-state)
       (if (> (length (rk-context-seq rkc)) 0)
        (rk-flush rkc)
        ;; head1ʸܤѴΥޡbackspaceǤϾäʤ褦
        ;; 롣ְäƳѤʸäʤ褦ˤ뤿ᡣ
        (if (> (length (tutcode-context-head pc)) 1)
          (tutcode-context-set-head! pc (cdr (tutcode-context-head pc))))))
      ((or
        (tutcode-commit-key? key key-state)
        (tutcode-return-key? key key-state))
        ;; ƵŪѴ(ꤷ)᤹
        (set! res (car (tutcode-context-head pc)))
        (tutcode-context-set-head! pc (cdr (tutcode-context-head pc)))
        (if (not (string=? res ""))
          ;; ⤦1ʸ(ΤϤ)äơä
          (tutcode-context-set-head! pc (cdr (tutcode-context-head pc)))
          (set! res #f))
        (if (= (length (tutcode-context-head pc)) 0)
          (begin
            ;; Ǿ̤Ѵξ硢Ѵ󤬤commit
            (if res
              (tutcode-commit pc res))
            (tutcode-flush pc)
            (if res (tutcode-check-auto-help-window-begin pc (list res) ()))
            (set! res #f))
          (if (not res)
            (re-predict))))
      ((tutcode-cancel-key? key key-state)
        ;; ƵŪѴ(󥻥뤷)᤹
        (set! res (car (tutcode-context-head pc)))
        (tutcode-context-set-head! pc (cdr (tutcode-context-head pc)))
        (if (not (string=? res ""))
          ;; ⤦1ʸ(ΤϤ)äơä
          (tutcode-context-set-head! pc (cdr (tutcode-context-head pc))))
        (set! res #f)
        (if (= (length (tutcode-context-head pc)) 0)
          (tutcode-flush pc)
          (re-predict)))
      ((tutcode-stroke-help-toggle-key? key key-state)
       (tutcode-toggle-stroke-help pc))
      ((and predicting? (tutcode-next-page-key? key key-state))
       (tutcode-change-bushu-prediction-page pc #t))
      ((and predicting? (tutcode-prev-page-key? key key-state))
       (tutcode-change-bushu-prediction-page pc #f))
      ((tutcode-paste-key? key key-state)
        (let ((latter-seq (tutcode-clipboard-acquire-text-wo-nl pc 'full)))
          (if (pair? latter-seq)
            (let* ((head (tutcode-context-head pc))
                   (paste-res
                    (tutcode-bushu-convert-on-list
                      (reverse (append latter-seq head)) ())))
              (if (string? paste-res)
                (begin
                  (tutcode-commit pc paste-res)
                  (tutcode-flush pc)
                  (tutcode-undo-prepare pc 'tutcode-state-bushu paste-res head)
                  (tutcode-check-auto-help-window-begin pc (list paste-res) ()))
                (begin
                  (tutcode-context-set-head! pc paste-res)
                  (if (and tutcode-use-bushu-prediction?
                           (pair? paste-res)
                           (not (string=? (car paste-res) "")))
                    (tutcode-check-bushu-prediction pc (car paste-res)))))))))
      ((or
        (symbol? key)
        (and
          (modifier-key-mask key-state)
          (not (shift-key-mask key-state))))
       (tutcode-flush pc)
       (tutcode-proc-state-on pc key key-state))
      ;; ͽ¬ϸѥ٥륭?
      ((and predicting?
            (tutcode-heading-label-char-for-prediction? key)
            (tutcode-commit-by-label-key-for-prediction pc
              (charcode->string key) 'tutcode-predicting-bushu)))
      ((not (rk-expect-key? rkc (charcode->string key)))
       (if (> (length (rk-context-seq rkc)) 0)
         (begin
           (if (tutcode-verbose-stroke-key? key key-state)
             (set! res (last (rk-context-seq rkc))))
           (rk-flush rkc))
         (set! res (charcode->string key))))
      (else
       (set! res (tutcode-push-key! pc (charcode->string key)))))
    (cond
      ((string? res)
        ;; ƵŪ礬ΤǡheadΤundoѤݻ
        (tutcode-undo-prepare pc 'tutcode-state-bushu " " ; " ":1ʸ
          (tutcode-context-head pc))
        (tutcode-begin-bushu-conversion pc res))
      ((symbol? res)
       (case res
        ((tutcode-bushu-start) ; ƵŪѴ
          (tutcode-append-string pc ""))
        ((tutcode-auto-help-redisplay)
          (tutcode-auto-help-redisplay pc))
        ((tutcode-undo) ; ƵŪѴundo
          (let ((undo (tutcode-context-undo pc)))
            (if (pair? undo)
              (tutcode-context-set-head! pc (list-ref undo 2)))))
        ;;XXX Ѵϸ򤼽Ѵ̵ˤ
        ))
      ((procedure? res)
       (res 'tutcode-state-bushu pc)))))

;;; Ѵ
;;; @param char Ϥ줿ʸ(2ܤ)
(define (tutcode-begin-bushu-conversion pc char)
  (let ((prevchar (car (tutcode-context-head pc))))
    (if (string=? prevchar "")
      (begin
        (tutcode-append-string pc char)
        (if tutcode-use-bushu-prediction?
          (tutcode-check-bushu-prediction pc char)))
      ;; ľʸޡǤʤ2ʸܤϤ줿Ѵ
      (let ((convchar (tutcode-bushu-convert prevchar char)))
        (if (string? convchar)
          ;; 
          (tutcode-bushu-commit pc convchar)
          ;; ԻϤľԤġͽ¬ϸϺɽ
          (if tutcode-use-bushu-prediction?
            (if (string? (tutcode-context-prediction-bushu pc)) ; ٱԤ?
              (tutcode-check-bushu-prediction pc prevchar)
              ;; ͽ¬ϸꥹȺѤξ硢ɽڡɽ
              (tutcode-bushu-prediction-make-page pc
                (tutcode-context-prediction-bushu-page-start pc) #t))))))))

;;; ѴѴʸꤹ
;;; @param convchar Ѵʸ
(define (tutcode-bushu-commit pc convchar)
  ;; 1ܤȢä
  (tutcode-context-set-head! pc (cddr (tutcode-context-head pc)))
  (if (null? (tutcode-context-head pc))
    ;; ѴԤ󤬻ĤäƤʤСꤷƽλ
    (let ((undo-data (tutcode-context-undo pc))) ; commitȥꥢ
      (tutcode-commit pc convchar)
      (tutcode-flush pc)
      (tutcode-context-set-undo! pc undo-data)
      (tutcode-check-auto-help-window-begin pc (list convchar) ()))
    ;; 󤬤ޤĤäƤСƳǧ
    ;; (ʸ2ʸܤʤСϢ³Ѵ)
    (tutcode-begin-bushu-conversion pc convchar)))

;;; ѴꥹȤФŬѤ
;;; @param bushu-list 󥹤Υꥹȡ
;;;  :("" "" "" "" "" "" "" "")
;;; @param conv-list ѴΥꥹ(ս)
;;; @return λѴʸ󡣹ξѴꥹ(ս)
;;;  :""
(define (tutcode-bushu-convert-on-list bushu-list conv-list)
  (if (null? bushu-list)
    conv-list
    (let ((bushu (car bushu-list))
          (prevchar (safe-car conv-list)))
      (if (or (not prevchar) (string=? prevchar "") (string=? bushu ""))
        ;; 1ʸ or Ƶ
        (tutcode-bushu-convert-on-list (cdr bushu-list) (cons bushu conv-list))
        ;; ľʸޡǤʤ2ʸܢѴ
        (let ((convchar (tutcode-bushu-convert prevchar bushu)))
          (if (string? convchar) ; ?
            (if (or (null? (cdr conv-list)) (null? (cddr conv-list)))
              convchar ; λ(bushu-listλĤ̵)
              (tutcode-bushu-convert-on-list
                (cons convchar (cdr bushu-list))
                (cddr conv-list))) ; ƵŪ˹
            ;; Իϼǻ
            (tutcode-bushu-convert-on-list (cdr bushu-list) conv-list)))))))

;;; ŪѴΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-interactive-bushu c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (rkc (tutcode-context-rk-context pc))
     (head (tutcode-context-head pc))
     (res #f)
     (has-candidate? (> (tutcode-context-prediction-nr pc) 0))
     ;; ɽΥڡưϡreset-candidate-window
     (candidate-selection-keys-handled?
      (if has-candidate?
        (cond
          ((tutcode-next-page-key? key key-state)
            (tutcode-change-prediction-page pc #t)
            #t)
          ((tutcode-prev-page-key? key key-state)
            (tutcode-change-prediction-page pc #f)
            #t)
          ((and (tutcode-next-candidate-key? key key-state)
                ;; 2ǸܤΥڡξϸǤϤʤ
                (= (length (rk-context-seq rkc)) 0))
            (tutcode-change-prediction-index pc 1)
            #t)
          ((tutcode-prev-candidate-key? key key-state)
            (tutcode-change-prediction-index pc -1)
            #t)
          (else
            #f))
        #f)))
    (if (not candidate-selection-keys-handled?)
      (begin
        (tutcode-reset-candidate-window pc)
        (cond
          ((tutcode-off-key? key key-state)
           (tutcode-flush pc)
           (tutcode-context-set-state! pc 'tutcode-state-off))
          ((and (tutcode-kana-toggle-key? key key-state)
                (not (tutcode-kigou2-mode? pc)))
           (rk-flush rkc)
           (tutcode-context-kana-toggle pc))
          ((tutcode-kigou2-toggle-key? key key-state)
           (rk-flush rkc)
           (tutcode-toggle-kigou2-mode pc))
          ((tutcode-backspace-key? key key-state)
           (if (> (length (rk-context-seq rkc)) 0)
            (rk-flush rkc)
            (if (> (length head) 0)
              (begin
                (tutcode-context-set-head! pc (cdr head))
                (if has-candidate?
                  (tutcode-begin-interactive-bushu-conversion pc))))))
          ((or
            (tutcode-commit-key? key key-state)
            (tutcode-return-key? key key-state))
           (let ((str
                  (cond
                    (has-candidate?
                      (tutcode-get-prediction-string pc
                        (tutcode-context-prediction-index pc))) ; ϸ쥬̵
                    ((> (length head) 0)
                      (string-list-concat (tutcode-context-head pc)))
                    (else
                      #f))))
             (if str (tutcode-commit pc str))
             (tutcode-flush pc)
             (if str (tutcode-check-auto-help-window-begin pc (list str) ()))))
          ((tutcode-cancel-key? key key-state)
           (tutcode-flush pc))
          ((tutcode-stroke-help-toggle-key? key key-state)
           (tutcode-toggle-stroke-help pc))
          ((tutcode-paste-key? key key-state)
            (let ((latter-seq (tutcode-clipboard-acquire-text-wo-nl pc 'full)))
              (if (pair? latter-seq)
                (begin
                  (tutcode-context-set-head! pc (append latter-seq head))
                  (tutcode-begin-interactive-bushu-conversion pc)))))
          ((or
            (symbol? key)
            (and
              (modifier-key-mask key-state)
              (not (shift-key-mask key-state))))
           (tutcode-flush pc)
           (tutcode-proc-state-on pc key key-state))
          ((and (tutcode-heading-label-char-for-prediction? key)
                (= (length (rk-context-seq rkc)) 0)
                (tutcode-commit-by-label-key-for-prediction pc
                  (charcode->string key)
                  'tutcode-predicting-interactive-bushu)))
          ((not (rk-expect-key? rkc (charcode->string key)))
           (if (> (length (rk-context-seq rkc)) 0)
             (begin
               (if (tutcode-verbose-stroke-key? key key-state)
                 (set! res (last (rk-context-seq rkc))))
               (rk-flush rkc))
             (set! res (charcode->string key))))
          (else
           (set! res (tutcode-push-key! pc (charcode->string key)))))
        (cond
          ((string? res)
            (tutcode-append-string pc res)
            (tutcode-begin-interactive-bushu-conversion pc))
          ((symbol? res)
           (case res
            ((tutcode-auto-help-redisplay)
              (tutcode-auto-help-redisplay pc))
            ;;XXX Ѵϸ򤼽Ѵ̵ˤ
            ))
          ((procedure? res)
           (res 'tutcode-state-interactive-bushu pc)))))))

;;; ŪѴ
(define (tutcode-begin-interactive-bushu-conversion pc)
  (let*
    ((head (tutcode-context-head pc))
     (res
      (if (null? head)
        ()
        (tutcode-bushu-compose-interactively (reverse head)))))
    (cond
      ;; BSʸä줿硢preeditθänr0
      ((null? head)
        (tutcode-context-set-prediction-nr! pc 0)
        (tutcode-context-set-prediction-candidates! pc ()))
      ;; ʸäǽʸ
      ((null? res)
        (tutcode-context-set-head! pc (cdr (tutcode-context-head pc)))
        (if (> (tutcode-context-prediction-nr pc) 0)
          (begin
            (tutcode-activate-candidate-window pc
              'tutcode-candidate-window-interactive-bushu
              tutcode-candidate-window-activate-delay-for-interactive-bushu
              (tutcode-context-prediction-nr-all pc)
              (tutcode-context-prediction-page-limit pc))
            (tutcode-select-candidate pc
              (tutcode-context-prediction-index pc)))
          ;; paste줿ʣƻȤȹǽ1äƺƸ
          (tutcode-begin-interactive-bushu-conversion pc)))
      (else
        (let ((nr (length res)))
          (tutcode-context-set-prediction-word! pc ())
          (tutcode-context-set-prediction-candidates! pc res)
          (tutcode-context-set-prediction-appendix! pc ())
          (tutcode-context-set-prediction-nr! pc nr)
          (tutcode-context-set-prediction-index! pc 0)
          (let*
            ((params (tutcode-prediction-calc-window-param nr 0))
             (nr-all (list-ref params 0)) ; 
             (page-limit (list-ref params 1)) ; ڡ
             (nr-in-page (list-ref params 2))) ; ڡ
            (if (> page-limit 0)
              (begin
                ;; ͽ¬ϸѿή
                (tutcode-context-set-prediction-nr-in-page! pc nr-in-page)
                (tutcode-context-set-prediction-page-limit! pc page-limit)
                (tutcode-context-set-prediction-nr-all! pc nr-all)
                (tutcode-activate-candidate-window pc
                  'tutcode-candidate-window-interactive-bushu
                  tutcode-candidate-window-activate-delay-for-interactive-bushu
                  nr-all
                  page-limit)
                (tutcode-select-candidate pc 0)))))))))

;;; 򤹤
;;; @param pc ƥȥꥹ
;;; @param num ߤθֹ椫鿷ֹޤǤΥեå
(define (tutcode-change-candidate-index pc num)
  (let* ((nr (tutcode-context-nr-candidates pc))
         (nth (tutcode-context-nth pc))
         (new-nth (+ nth num)))
    (cond
      ((< new-nth 0)
       (set! new-nth 0))
      ((and tutcode-use-recursive-learning?
            (eq? (tutcode-context-state pc) 'tutcode-state-converting)
            (= nth (- nr 1))
            (>= new-nth nr))
       (tutcode-reset-candidate-window pc)
       (tutcode-setup-child-context pc 'tutcode-child-type-editor))
      ((>= new-nth nr)
       (set! new-nth (- nr 1))))
    (tutcode-context-set-nth! pc new-nth))
  (if (null? (tutcode-context-child-context pc))
    (begin
      (tutcode-check-candidate-window-begin pc)
      (if (not (eq? (tutcode-context-candidate-window pc)
                    'tutcode-candidate-window-off))
        (tutcode-select-candidate pc (tutcode-context-nth pc))))))

;;; 䴰/ͽ¬ϸ򤹤
;;; @param num ߤθֹ椫鿷ֹޤǤΥեå
(define (tutcode-change-prediction-index pc num)
  (let* ((nr-all (tutcode-context-prediction-nr-all pc))
         (idx (tutcode-context-prediction-index pc))
         (n (+ idx num))
         (compensated-n
          (cond
           ((>= n nr-all) (- nr-all 1))
           ((< n 0) 0)
           (else n))))
    (tutcode-context-set-prediction-index! pc compensated-n)
    (tutcode-select-candidate pc compensated-n)))

;;; /ڡ䴰/ͽ¬ϸɽ
;;; @param next? #t:ڡ, #f:ڡ
(define (tutcode-change-prediction-page pc next?)
  (let ((page-limit (tutcode-context-prediction-page-limit pc)))
    (tutcode-change-prediction-index pc (if next? page-limit (- page-limit)))))

;;; /ڡѴͽ¬ϸɽ
;;; @param next? #t:ڡ, #f:ڡ
(define (tutcode-change-bushu-prediction-page pc next?)
  (let* ((idx (tutcode-context-prediction-bushu-page-start pc))
         (n (+ idx
              (if next?
                tutcode-nr-candidate-max-for-prediction
                (- tutcode-nr-candidate-max-for-prediction)))))
    (tutcode-bushu-prediction-make-page pc n #t)))

;;; 䥦ɥĤ
(define (tutcode-reset-candidate-window pc)
  (if (not (eq? (tutcode-context-candidate-window pc)
                'tutcode-candidate-window-off))
    (begin
      (im-deactivate-candidate-selector pc)
      (tutcode-context-set-candidate-window! pc 'tutcode-candidate-window-off)
      (tutcode-context-set-predicting! pc 'tutcode-predicting-off)
      (tutcode-context-set-pseudo-table-cands! pc #f)
      (tutcode-context-set-candwin-delay-waiting! pc #f)
      (tutcode-context-set-candwin-delay-selected-index! pc -1))))

;;; 򤼽Ѵθ֤顢ɤϾ֤᤹
;;; @param pc ƥȥꥹ
(define (tutcode-back-to-yomi-state pc)
  (let ((postfix-yomi-len (tutcode-context-postfix-yomi-len pc)))
    (cond
      ((= postfix-yomi-len 0)
        (tutcode-reset-candidate-window pc)
        (tutcode-context-set-state! pc 'tutcode-state-yomi)
        (tutcode-context-set-head! pc (tutcode-context-mazegaki-yomi-all pc))
        (tutcode-context-set-mazegaki-suffix! pc ())
        (tutcode-context-set-nr-candidates! pc 0))
      ((> postfix-yomi-len 0)
        (tutcode-flush pc))
      (else ; selection
        (im-clear-preedit pc)
        (im-update-preedit pc)
        ;; Firefoxqt4ξ硢preeditɽselection񤭤褦ǡ
        ;; cancelƤäޤޤˤʤΤǡѤselectionƤ᤹
        ;; (selection֤뤿Firefoxqt4ʳ(leafpad)ǤϤ줷
        ;; ʤäǥåȤselectionΥǥåȤ礭)
        ;; (acquire-textƤȽFirefoxξpair֤뤿Ƚǽ)
        (tutcode-commit pc
          (string-list-concat (tutcode-context-mazegaki-yomi-all pc)) #t #t)
        (tutcode-flush pc)))))

;;; 򤼽ѴμϿ֤顢֤᤹
;;; @param pc ƥȥꥹ
(define (tutcode-back-to-converting-state pc)
  (tutcode-context-set-nth! pc (- (tutcode-context-nr-candidates pc) 1))
  (tutcode-check-candidate-window-begin pc)
  (if (eq? (tutcode-context-candidate-window pc)
           'tutcode-candidate-window-converting)
    (tutcode-select-candidate pc (tutcode-context-nth pc)))
  (tutcode-context-set-state! pc 'tutcode-state-converting))

;;; Ϥ줿٥ʸɤĴ٤
;;; @param key Ϥ줿
(define (tutcode-heading-label-char? key)
  (member (charcode->string key) tutcode-heading-label-char-list))

;;; Ϥ줿ϥ⡼ɻθ٥ʸɤĴ٤
;;; @param key Ϥ줿
(define (tutcode-heading-label-char-for-kigou-mode? key)
  (member (charcode->string key) tutcode-heading-label-char-list-for-kigou-mode))

;;; Ϥ줿ҥȥϥ⡼ɻθ٥ʸɤĴ٤
;;; @param key Ϥ줿
(define (tutcode-heading-label-char-for-history? key)
  (member (charcode->string key) tutcode-heading-label-char-list-for-history))

;;; Ϥ줿䴰/ͽ¬ϻθ٥ʸɤĴ٤
;;; @param key Ϥ줿
(define (tutcode-heading-label-char-for-prediction? key)
  (member (charcode->string key) tutcode-heading-label-char-list-for-prediction))

;;; 򤼽Ѵθ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-converting c key key-state)
  (let ((pc (tutcode-find-descendant-context c)))
    (cond
      ((tutcode-next-candidate-key? key key-state)
        (tutcode-change-candidate-index pc 1))
      ((tutcode-prev-candidate-key? key key-state)
        (tutcode-change-candidate-index pc -1))
      ((tutcode-cancel-key? key key-state)
        (tutcode-back-to-yomi-state pc))
      ((tutcode-next-page-key? key key-state)
        (tutcode-change-candidate-index pc tutcode-nr-candidate-max))
      ((tutcode-prev-page-key? key key-state)
        (tutcode-change-candidate-index pc (- tutcode-nr-candidate-max)))
      ((or (tutcode-commit-key? key key-state)
           (tutcode-return-key? key key-state))
        (tutcode-commit-with-auto-help pc))
      ((tutcode-purge-candidate-key? key key-state)
        (tutcode-reset-candidate-window pc)
        (tutcode-setup-child-context pc 'tutcode-child-type-dialog))
      ((and (tutcode-register-candidate-key? key key-state)
            tutcode-use-recursive-learning?)
        (tutcode-reset-candidate-window pc)
        (tutcode-setup-child-context pc 'tutcode-child-type-editor))
      ((tutcode-mazegaki-relimit-right-key? key key-state)
        (tutcode-mazegaki-proc-relimit-right pc))
      ((tutcode-mazegaki-relimit-left-key? key key-state)
        (tutcode-mazegaki-proc-relimit-left pc))
      ((and (or (eq? tutcode-commit-candidate-by-label-key 'always)
                (eq? tutcode-commit-candidate-by-label-key 'havecand)
                (and (eq? tutcode-commit-candidate-by-label-key 'candwin)
                     (not (eq? (tutcode-context-candidate-window pc)
                               'tutcode-candidate-window-off))
                     (not (tutcode-context-candwin-delay-waiting pc))))
            (not (and (modifier-key-mask key-state)
                      (not (shift-key-mask key-state))))
            (> (tutcode-context-nr-candidates pc) 1)
            (tutcode-heading-label-char? key)
            (tutcode-commit-by-label-key pc (charcode->string key))))
      (else
        (let* ((postfix-yomi-len (tutcode-context-postfix-yomi-len pc))
               (yomi (and (not (zero? postfix-yomi-len))
                          (take (tutcode-context-mazegaki-yomi-all pc)
                                (abs postfix-yomi-len))))
               (commit-str (tutcode-prepare-commit-string pc)))
          (cond
            ((= postfix-yomi-len 0)
              (tutcode-commit pc commit-str))
            ((> postfix-yomi-len 0)
              (tutcode-postfix-commit pc commit-str yomi))
            (else
              (tutcode-selection-commit pc commit-str yomi))))
        (tutcode-proc-state-on pc key key-state)))))

;;; ѴԤ
;;; @param c1 1ܤ
;;; @param c2 2ܤ
;;; @return ʸǤʤäȤ#f
(define (tutcode-bushu-convert c1 c2)
  (case tutcode-bushu-conversion-algorithm
    ((tc-2.3.1-22.6)
      (tutcode-bushu-convert-tc23 c1 c2))
    ((kw-yamanobe)
      (tutcode-bushu-convert-kwyamanobe c1 c2))
    (else ; 'tc-2.1+ml1925
      (tutcode-bushu-convert-tc21 c1 c2))))

;;; ѴԤ
;;; tc-2.1+[tcode-ml:1925]르ꥺѡ
;;; @param c1 1ܤ
;;; @param c2 2ܤ
;;; @return ʸǤʤäȤ#f
(define (tutcode-bushu-convert-tc21 c1 c2)
  (if (null? tutcode-bushu-help)
    (set! tutcode-bushu-help (tutcode-bushu-help-load)))
  (and c1 c2
    (or
      (and tutcode-bushu-help (tutcode-bushu-compose c1 c2 tutcode-bushu-help))
      (tutcode-bushu-compose-sub c1 c2)
      (let ((a1 (tutcode-bushu-alternative c1))
            (a2 (tutcode-bushu-alternative c2)))
        (and
          (or
            (not (string=? a1 c1))
            (not (string=? a2 c2)))
          (begin
            (set! c1 a1)
            (set! c2 a2)
            #t)
          (tutcode-bushu-compose-sub c1 c2)))
      (let* ((decomposed1 (tutcode-bushu-decompose c1))
             (decomposed2 (tutcode-bushu-decompose c2))
             (tc11 (and decomposed1 (car decomposed1)))
             (tc12 (and decomposed1 (cadr decomposed1)))
             (tc21 (and decomposed2 (car decomposed2)))
             (tc22 (and decomposed2 (cadr decomposed2)))
             ;; ʸ2ĤȤϰۤʤ
             ;; ʸǤ뤳Ȥǧ롣
             ;; (string=?#fäȤ˥顼ˤʤΤequal?)
             (newchar
                (lambda (new)
                  (and
                    (not (equal? new c1))
                    (not (equal? new c2))
                    new))))
        (or
          ;; 
          (and
            (equal? tc11 c2)
            (newchar tc12))
          (and
            (equal? tc12 c2)
            (newchar tc11))
          (and
            (equal? tc21 c1)
            (newchar tc22))
          (and
            (equal? tc22 c1)
            (newchar tc21))
          ;; ʤˤ­
          (let ((compose-newchar
                  (lambda (i1 i2)
                    (let ((res (tutcode-bushu-compose-sub i1 i2)))
                      (and res
                        (newchar res))))))
            (or
              (compose-newchar c1 tc22) (compose-newchar tc11 c2)
              (compose-newchar c1 tc21) (compose-newchar tc12 c2)
              (compose-newchar tc11 tc22) (compose-newchar tc11 tc21)
              (compose-newchar tc12 tc22) (compose-newchar tc12 tc21)))
          ;; ʤˤ
          (and tc11
            (equal? tc11 tc21)
            (newchar tc12))
          (and tc11
            (equal? tc11 tc22)
            (newchar tc12))
          (and tc12
            (equal? tc12 tc21)
            (newchar tc11))
          (and tc12
            (equal? tc12 tc22)
            (newchar tc11)))))))

;;; ѴԤ
;;; ľWin+YAMANOBE르ꥺѡ
;;; @param ca 1ܤ
;;; @param cb 2ܤ
;;; @return ʸǤʤäȤ#f
(define (tutcode-bushu-convert-kwyamanobe ca cb)
  (if (null? tutcode-bushu-help)
    (set! tutcode-bushu-help (tutcode-bushu-help-load)))
  (and ca cb
    (or
      (and tutcode-bushu-help (tutcode-bushu-compose ca cb tutcode-bushu-help))
      (let
        ;; ʸ2ĤȤϰۤʤ
        ;; ʸǤ뤳Ȥǧ롣
        ;; (string=?#fäȤ˥顼ˤʤΤequal?)
        ((newchar
          (lambda (new)
            (and new
              (not (equal? new ca))
              (not (equal? new cb))
              new)))
         (bushu-compose-sub
          (lambda (x y)
            (and x y
              (tutcode-bushu-compose x y tutcode-bushudic))))) ; no swap
        (or
          (newchar (bushu-compose-sub ca cb))
          (let
            ((a (tutcode-bushu-alternative ca))
             (b (tutcode-bushu-alternative cb))
             (compose-alt
              (lambda (cx cy x y)
                (and
                  (or
                    (not (string=? x cx))
                    (not (string=? y cy)))
                  (newchar (bushu-compose-sub x y))))))
            (or
              (compose-alt ca cb a b)
              (let*
                ((ad (tutcode-bushu-decompose a))
                 (bd (tutcode-bushu-decompose b))
                 (a1 (and ad (car ad)))
                 (a2 (and ad (cadr ad)))
                 (b1 (and bd (car bd)))
                 (b2 (and bd (cadr bd)))
                 (compose-newchar
                  (lambda (i1 i2)
                    (newchar (bushu-compose-sub i1 i2))))
                 (compose-l2r
                  (lambda (x y z)
                    (newchar (bushu-compose-sub (bushu-compose-sub x y) z))))
                 (compose-r2l
                  (lambda (x y z)
                    (newchar (bushu-compose-sub x (bushu-compose-sub y z)))))
                 (compose-lr
                  (lambda (a a1 a2 b b1 b2)
                    (or
                      (and a1 a2
                        (or
                          (compose-l2r a1 b a2)
                          (compose-r2l a1 a2 b)))
                      (and b1 b2
                        (or
                          (compose-l2r a b1 b2)
                          (compose-r2l b1 a b2))))))
                 (subtract
                  (lambda (a1 a2 b)
                    (or
                      (and (equal? a2 b) (newchar a1))
                      (and (equal? a1 b) (newchar a2))))))
                (or
                  (compose-lr a a1 a2 b b1 b2)
                  ;; 
                  (subtract a1 a2 b)
                  (let*
                    ((ad1 (and a1 (tutcode-bushu-decompose a1)))
                     (ad2 (and a2 (tutcode-bushu-decompose a2)))
                     (a11 (and ad1 (car ad1)))
                     (a12 (and ad1 (cadr ad1)))
                     (a21 (and ad2 (car ad2)))
                     (a22 (and ad2 (cadr ad2)))
                     (bushu-convert-sub
                      (lambda (a a1 a11 a12 a2 a21 a22 b b1 b2)
                        (or
                          (and a2 a11 a12
                            (or
                              (and (equal? a12 b) (compose-newchar a11 a2))
                              (and (equal? a11 b) (compose-newchar a12 a2))))
                          (and a1 a21 a22
                            (or
                              (and (equal? a22 b) (compose-newchar a1 a21))
                              (and (equal? a21 b) (compose-newchar a1 a22))))
                          ;; ʤˤ­
                          (compose-newchar a b1)
                          (compose-newchar a b2)
                          (compose-newchar a1 b)
                          (compose-newchar a2 b)
                          (and a1 a2 b1
                            (or
                              (compose-l2r a1 b1 a2)
                              (compose-r2l a1 a2 b1)))
                          (and a1 a2 b2
                            (or
                              (compose-l2r a1 b2 a2)
                              (compose-r2l a1 a2 b2)))
                          (and a1 b1 b2
                            (or
                              (compose-l2r a1 b1 b2)
                              (compose-r2l b1 a1 b2)))
                          (and a2 b1 b2
                            (or
                              (compose-l2r a2 b1 b2)
                              (compose-r2l b1 a2 b2)))
                          ;; ξʤˤ­
                          (compose-newchar a1 b1)
                          (compose-newchar a1 b2)
                          (compose-newchar a2 b1)
                          (compose-newchar a2 b2)
                          ;; ʤˤ
                          (and a2 b1 (equal? a2 b1) (newchar a1))
                          (and a2 b2 (equal? a2 b2) (newchar a1))
                          (and a1 b1 (equal? a1 b1) (newchar a2))
                          (and a1 b2 (equal? a1 b2) (newchar a2))
                          (and a2 a11 a12
                            (or
                              (and (or (equal? a12 b1) (equal? a12 b2))
                                (compose-newchar a11 a2))
                              (and (or (equal? a11 b1) (equal? a11 b2))
                                (compose-newchar a12 a2))))
                          (and a1 a21 a22
                            (or
                              (and (or (equal? a22 b1) (equal? a22 b2))
                                (compose-newchar a1 a21))
                              (and (or (equal? a21 b1) (equal? a21 b2))
                                (compose-newchar a1 a22))))))))
                    (or
                      (bushu-convert-sub a a1 a11 a12 a2 a21 a22 b b1 b2)
                      ;; ʸνդˤƤߤ
                      (and (not (equal? ca cb))
                        (or
                          (newchar (bushu-compose-sub cb ca))
                          (compose-alt cb ca b a)
                          (compose-lr b b1 b2 a a1 a2)
                          (subtract b1 b2 a)
                          (let*
                            ((bd1 (and b1 (tutcode-bushu-decompose b1)))
                             (bd2 (and b2 (tutcode-bushu-decompose b2)))
                             (b11 (and bd1 (car bd1)))
                             (b12 (and bd1 (cadr bd1)))
                             (b21 (and bd2 (car bd2)))
                             (b22 (and bd2 (cadr bd2))))
                            (bushu-convert-sub b b1 b11 b12 b2 b21 b22 a a1 a2)
                            ))))))))))))))

;;; Ѵ:c1c2ƤǤʸõ֤
;;; ꤵ줿֤ǸĤʤäϡ֤줫õ
;;; @param c1 1ܤ
;;; @param c2 2ܤ
;;; @return ʸǤʤäȤ#f
(define (tutcode-bushu-compose-sub c1 c2)
  (and c1 c2
    (or
      (tutcode-bushu-compose c1 c2 tutcode-bushudic)
      (tutcode-bushu-compose c2 c1 tutcode-bushudic))))

;;; Ѵ:c1c2ƤǤʸõ֤
;;; @param c1 1ܤ
;;; @param c2 2ܤ
;;; @return ʸǤʤäȤ#f
(define (tutcode-bushu-compose c1 c2 bushudic)
  (let ((seq (rk-lib-find-seq (list c1 c2) bushudic)))
    (and seq
      (car (cadr seq)))))

;;; Ѵ:ʸõ֤
;;; @param c оݤʸ
;;; @return ʸʸĤʤäȤϸʸ
(define (tutcode-bushu-alternative c)
  (let ((alt (assoc c tutcode-bushudic-altchar)))
    (or
      (and alt (cadr alt))
      c)))

;;; Ѵ:ʸ2Ĥʬ򤹤롣
;;; @param c ʬоݤʸ
;;; @return ʬ򤷤ƤǤ2ĤΥꥹȡʬǤʤäȤ#f
(define (tutcode-bushu-decompose c)
  (if (null? tutcode-reverse-bushudic-hash-table)
    (set! tutcode-reverse-bushudic-hash-table
      (tutcode-rule->reverse-hash-table tutcode-bushudic)))
  (let ((i (tutcode-euc-jp-string->ichar c)))
    (and i
      (hash-table-ref/default tutcode-reverse-bushudic-hash-table i #f))))

;;; tutcode-ruleΥꥹȤ顢հ(ǸꥹȤ)Ѥ
;;; hash-table
;;; @param rule tutcode-ruleΥꥹ
;;; @return hash-table
(define (tutcode-rule->reverse-hash-table rule)
  (alist->hash-table
    (filter-map
      (lambda (elem)
        (and-let*
          ((kanji (caadr elem))
           (kanji-string? (string? kanji)) ; 'tutcode-mazegaki-startϽ
           (i (tutcode-euc-jp-string->ichar kanji)))
          (cons i (caar elem))))
      rule)))

;;; hash-tableΥѤˡ1ʸʸ󤫤ɤѴ
;;; @param s ʸ
;;; @return ɡʸĹ1Ǥʤ#f
(define (tutcode-euc-jp-string->ichar s)
  ;; ichar.scmstring->ichar(string->charcode)EUC-JP
  (let ((sl (with-char-codec "EUC-JP"
              (lambda ()
                (string->list s)))))
    (cond
      ((null? sl)
        0)
      ((null? (cdr sl))
        (char->integer (car sl)))
      (else
        #f))))

;;; ưإ:bushu.helpե򸡺оʸΥإ(2Ĥ)
;;; @param c оʸ
;;; @return إפɽ(2ĤΥꥹ)Ĥʤä#f
(define (tutcode-bushu-help-lookup c)
  (and (not (string=? tutcode-bushu-help-filename "")) ; ǥեȤ""
    (let*
      ((looked (tutcode-bushu-search c tutcode-bushu-help-filename))
       (lst (and looked (tutcode-bushu-parse-entry looked))))
      (and lst
        (>= (length lst) 2)
        (take lst 2)))))

;;; ưإ:оʸΤɬפȤʤ롢
;;; Ǥʤ2ĤʸΥꥹȤ֤
;;; : "" => (((("," "o"))("")) ((("f" "q"))("")))
;;; @param c оʸ
;;; @param rule tutcode-rule
;;; @param stime 
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  Ĥʤä#f
(define (tutcode-auto-help-bushu-decompose c rule stime)
  (case tutcode-bushu-conversion-algorithm
    ((tc-2.3.1-22.6)
      (tutcode-auto-help-bushu-decompose-tc23 c rule stime))
    (else ; 'tc-2.1+ml1925
      (tutcode-auto-help-bushu-decompose-tc21 c rule stime))))

;;; ưإ:оʸΤɬפȤʤ롢
;;; Ǥʤ2ĤʸΥꥹȤ֤
;;; : "" => (((("," "o"))("")) ((("f" "q"))("")))
;;; @param c оʸ
;;; @param rule tutcode-rule
;;; @param stime 
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  Ĥʤä#f
(define (tutcode-auto-help-bushu-decompose-tc21 c rule stime)
  (if (> (string->number (difftime (time) stime)) tutcode-auto-help-time-limit)
    #f
    (let*
      ((bushu (or (tutcode-bushu-help-lookup c)
                  (tutcode-bushu-decompose c)))
       (b1 (and bushu (car bushu)))
       (b2 (and bushu (cadr bushu)))
       (seq1 (and b1 (tutcode-auto-help-get-stroke b1 rule)))
       (seq2 (and b2 (tutcode-auto-help-get-stroke b2 rule))))
      (or
        ;; ­ˤ
        (and seq1 seq2
          (list seq1 seq2))
        ;; ñʰˤ
        (tutcode-auto-help-bushu-decompose-by-subtraction c rule)
        ;; ʤˤ
        (or
          ;; 1ľϲǽ
          ;; (1)(2ʤȤƻĴ)ˤǽ?
          (and seq1 b2
            (or
              (tutcode-auto-help-bushu-decompose-looking-bushudic
                tutcode-bushudic () 99
                (lambda (elem)
                  (tutcode-auto-help-get-stroke-list-with-right-part
                    c b1 b2 seq1 rule elem)))
              ;; 2ǤϹǽ2򤵤ʬ
              (let
                ((b2dec
                  (tutcode-auto-help-bushu-decompose-tc21 b2 rule stime)))
                (and b2dec
                  (list seq1 b2dec)))))
          ;; 2ľϲǽ
          ;; (2)(1ʤȤƻĴ)ˤǽ?
          (and seq2 b1
            (or
              (tutcode-auto-help-bushu-decompose-looking-bushudic
                tutcode-bushudic () 99
                (lambda (elem)
                  (tutcode-auto-help-get-stroke-list-with-left-part
                    c b1 b2 seq2 rule elem)))
              ;; 1ǤϹǽ1򤵤ʬ
              (let
                ((b1dec
                  (tutcode-auto-help-bushu-decompose-tc21 b1 rule stime)))
                (and b1dec
                  (list b1dec seq2)))))
          ;; 12ľԲĢʬ
          (and b1 b2
            (let
              ((b1dec (tutcode-auto-help-bushu-decompose-tc21 b1 rule stime))
               (b2dec (tutcode-auto-help-bushu-decompose-tc21 b2 rule stime)))
              (and b1dec b2dec
                (list b1dec b2dec))))
          ;; XXX: ʤɤι̤б
          )))))

;;; ưإ:оʸϤݤǸΥꥹȤ롣
;;; : "" => ((("," "o")) (""))
;;; @param b оʸ
;;; @param rule tutcode-rule
;;; @return ǸꥹȡԲǽʾ#f
(define (tutcode-auto-help-get-stroke b rule)
  (let
    ((seq
      (or (tutcode-reverse-find-seq b rule)
          ;; ǻȤ"3"Τ褦ľϲǽб뤿ᡢ
          ;; ٥ʸ˴ޤޤƤСľϲǽȤߤʤ
          (and
            (member b tutcode-heading-label-char-list-for-kigou-mode)
            (list b)))))
    (and seq
      (list (list seq) (list b)))))

;;; ưإ:Ǥ˸
;;; ǽ˸Ĥä2ǸȤ߹碌֤
;;; (filtermapȤäơǾΥȥΤΤõȻ֤Τǡ)
;;; ξȤ2ǸȤ߹碌Ĥʤä顢
;;; 3ǸȤȤ߹碌֤
;;; @param long-stroke-result 3Ǹʾʸޤ
;;; @param min-stroke long-stroke-resultθߤκǾǸ
;;; @param get-stroke-list Ѥ2ĤʸȥȥΥꥹȤ֤ؿ
;;; @return Ѥ2ĤʸȥȥΥꥹȡ
;;;  Ĥʤä#f
(define (tutcode-auto-help-bushu-decompose-looking-bushudic bushudic
          long-stroke-result min-stroke get-stroke-list)
  (if (null? bushudic)
    (and
      (not (null? long-stroke-result))
      long-stroke-result)
    (let*
      ((res
        (get-stroke-list (list min-stroke (car bushudic))))
       (len (if (not res) 99 (tutcode-auto-help-count-stroke-length res)))
       (min (if (< len min-stroke) len min-stroke)))
      (if (<= len 4) ; "5"Ȥ4Ǹ̤⤢뤬ޤǤϸʤ
        res
        (tutcode-auto-help-bushu-decompose-looking-bushudic (cdr bushudic)
          (if (< len min-stroke) res long-stroke-result)
          min get-stroke-list)))))

;;; ưإ:оʸˤΤɬפȤʤ롢
;;; ǤʤʸΥꥹȤ֤
;;; : "" => (((("g" "t" "h")) ("")) ((("G" "I")) ("")))
;;;    (Ȥʤtutcode-bushudicǤ((("" "")) ("")))
;;; @param c оʸ
;;; @param rule tutcode-rule
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  Ĥʤä#f
(define (tutcode-auto-help-bushu-decompose-by-subtraction c rule)
  (tutcode-auto-help-bushu-decompose-looking-bushudic tutcode-bushudic
    () 99
    (lambda (elem)
      (tutcode-auto-help-get-stroke-list-by-subtraction c rule elem))))

;;; ưإ:ɬפǸ
;;; @param bushu-compose-list ˻Ȥ2ʸȥȥΥꥹȡ
;;;  : (((("g" "t" "h")) ("")) ((("G" "I")) ("")))
;;; @return bushu-compose-list˴ޤޤǸ(ξ5)
(define (tutcode-auto-help-count-stroke-length bushu-compose-list)
  (+ (length (caaar bushu-compose-list))
     (length (caaadr bushu-compose-list))))

;;; ưإ:оʸˤǤϡ
;;; ˻ȤʸȡΥȥΥꥹȤ֤
;;; @param c оʸ
;;; @param rule tutcode-rule
;;; @param min-stroke-bushu-list min-strokebushudicǤΥꥹȡ
;;;  : (6 ((("" "")) ("")))
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  bushu-listȤäƹǤʤ#f
;;;  : (((("g" "t" "h")) ("")) ((("G" "I")) ("")))
(define (tutcode-auto-help-get-stroke-list-by-subtraction
          c rule min-stroke-bushu-list)
  (and-let*
    ((min-stroke (car min-stroke-bushu-list))
     (bushu-list (cadr min-stroke-bushu-list))
     (mem (member c (caar bushu-list)))
     (b1 (caadr bushu-list))
     ;; 2ĤΤcʳ
     (b2 (if (= 2 (length mem)) (cadr mem) (car (caar bushu-list))))
     (seq1 (tutcode-auto-help-get-stroke b1 rule))
     (seq2 (tutcode-auto-help-get-stroke b2 rule))
     (ret (list seq1 seq2))
     ;; ٤ΤǡǸå
     (small-stroke? (< (tutcode-auto-help-count-stroke-length ret) min-stroke))
     ;; ºݤơоʸʤΤ
     (composed (tutcode-bushu-convert b1 b2))
     (c-composed? (string=? composed c)))
    ret))

;;; ưإ:оʸ1פȡ2ʤȤƻĴפˤ
;;; Ǥϡ
;;; ˻ȤʸȡΥȥΥꥹȤ֤
;;; @param c оʸ
;;; @param b1 1(ľϲǽ)
;;; @param b2 2(ľԲǽ)
;;; @param seq1 b1ϥ󥹤Υꥹ
;;; @param rule tutcode-rule
;;; @param min-stroke-bushu-list min-strokebushudicǤΥꥹȡ
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  bushu-listȤäƹǤʤ#f
(define (tutcode-auto-help-get-stroke-list-with-right-part
         c b1 b2 seq1 rule min-stroke-bushu-list)
  (and-let*
    ((min-stroke (car min-stroke-bushu-list))
     (bushu-list (cadr min-stroke-bushu-list))
     (mem (member b2 (caar bushu-list)))
     (kanji (caadr bushu-list)) ; 2ʤȤƻĴ
     (seq (tutcode-auto-help-get-stroke kanji rule))
     (ret (list seq1 seq))
     ;; ٤ΤǡǸå
     (small-stroke? (< (tutcode-auto-help-count-stroke-length ret) min-stroke))
     ;; ºݤơоʸʤΤ
     (composed (tutcode-bushu-convert b1 kanji))
     (c-composed? (string=? composed c)))
    ret))

;;; ưإ:оʸ1ʤȤƻĴפȡ2פˤ
;;; Ǥϡ
;;; ˻ȤʸȡΥȥΥꥹȤ֤
;;; @param c оʸ (: "")
;;; @param b1 1(ľԲǽ) (: "")
;;; @param b2 2(ľϲǽ) (: "")
;;; @param seq2 b2ϥ󥹤Υꥹȡ
;;;  : ((("b" ",")) (""))
;;; @param rule tutcode-rule
;;; @param min-stroke-bushu-list min-strokebushudicǤΥꥹȡ
;;;  : (6 ((("" "")) ("")))
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  bushu-listȤäƹǤʤ#f
;;;  : (((("e" "v" ".")) ("")) ((("b" ",")) ("")))
(define (tutcode-auto-help-get-stroke-list-with-left-part
         c b1 b2 seq2 rule min-stroke-bushu-list)
  (and-let*
    ((min-stroke (car min-stroke-bushu-list))
     (bushu-list (cadr min-stroke-bushu-list))
     (mem (member b1 (caar bushu-list)))
     (kanji (caadr bushu-list)) ; 1ʤȤƻĴ
     (seq (tutcode-auto-help-get-stroke kanji rule))
     (ret (list seq seq2))
     ;; ٤ΤǡǸå
     (small-stroke? (< (tutcode-auto-help-count-stroke-length ret) min-stroke))
     ;; ºݤơоʸʤΤ
     (composed (tutcode-bushu-convert kanji b2))
     (c-composed? (string=? composed c)))
    ret))

;;; Ѵͽ¬ϸ򸡺
;;; @param str 1
;;; @param bushudic ꥹ
;;; @return (<2> <ʸ>)Υꥹ
(define (tutcode-bushu-predict str bushudic)
  (if (null? tutcode-bushu-help)
    (set! tutcode-bushu-help (tutcode-bushu-help-load)))
  (let*
    ((rules-help
      (if tutcode-bushu-help
        (rk-lib-find-partial-seqs (list str) tutcode-bushu-help)
        ()))
     (rules-dic (rk-lib-find-partial-seqs (list str) bushudic))
     (rules (append rules-help rules-dic)) ; ʣbushu.help¦ǲǽ
     (words1 (map (lambda (elem) (cadaar elem)) rules))
     ;; (((str 2))(ʸ)) -> (2 ʸ)
     (word/cand1 (map (lambda (elem) (list (cadaar elem) (caadr elem))) rules))
     (more-cands
      (filter-map
        (lambda (elem)
          (let
            ;; (((1 2))(ʸ))
            ((bushu1 (caaar elem))
             (bushu2 (cadaar elem))
             (gosei (caadr elem)))
            (or
              ;; str1ʸܤξrk-lib-find-partial-seqsǸ
              ;(string=? str bushu1) ; (((str 2))(ʸ))
              (and (string=? str bushu2) ; (((1 str))(ʸ))
                    ;; ˾ǽиѤξϽ
                    ;; : ((("" ""))(""))""иѤξ硢
                    ;;     ((("" ""))(""))""Ͻ
                   (not (member bushu1 words1))
                   (list bushu1 gosei))
              (and (string=? str gosei) ; (((1 2))(str))
                   ;; XXX:ξ硢strbushu1bushu2Ǥ뤳Ȥ
                   ;;     ǧ٤tutcode-bushu-convert٤ΤǾά
                   (list bushu1 bushu2)))))
          bushudic)))
    (append word/cand1 more-cands)))

;;; tutcode-ruleհơѴʸ顢ϥ롣
;;; : (tutcode-reverse-find-seq "" tutcode-rule) => ("r" "k")
;;; @param c Ѵʸ
;;; @param rule tutcode-rule
;;; @return ϥΥꥹȡtutcode-rulecĤʤä#f
(define (tutcode-reverse-find-seq c rule)
  (and (string? c)
    (let*
      ((hash-table
        (if (eq? rule tutcode-kigou-rule)
          (begin
            (if (null? tutcode-reverse-kigou-rule-hash-table)
              (set! tutcode-reverse-kigou-rule-hash-table
                (tutcode-rule->reverse-hash-table rule)))
            tutcode-reverse-kigou-rule-hash-table)
          (begin
            (if (null? tutcode-reverse-rule-hash-table)
              (set! tutcode-reverse-rule-hash-table
                (tutcode-rule->reverse-hash-table rule)))
            tutcode-reverse-rule-hash-table)))
       (i (tutcode-euc-jp-string->ichar c)))
      (and i
        (hash-table-ref/default hash-table i #f)))))

;;; ߤstatepreeditĤɤ֤
;;; @param pc ƥȥꥹ
(define (tutcode-state-has-preedit? pc)
  (or
    (not (null? (tutcode-context-child-context pc)))
    (memq (tutcode-context-state pc)
      '(tutcode-state-yomi tutcode-state-bushu tutcode-state-converting
        tutcode-state-interactive-bushu tutcode-state-kigou
        tutcode-state-code tutcode-state-history
        tutcode-state-postfix-katakana tutcode-state-postfix-kanji2seq
        tutcode-state-postfix-seq2kanji))))

;;; 줿ȤνοʬԤ
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-key-press-handler c key key-state)
  (if (ichar-control? key)
      (im-commit-raw c)
      (tutcode-key-press-handler-internal c key key-state)))

;;; 줿ȤνοʬԤ
;;; (seq2kanjiθƽѡichar-control?ʸseq2kanji̤ƤĤ褦)
(define (tutcode-key-press-handler-internal c key key-state)
  (let ((pc (tutcode-find-descendant-context c)))
    (case (tutcode-context-state pc)
      ((tutcode-state-on)
       (let* ((rkc (tutcode-context-rk-context pc))
              (prev-pending-rk (rk-context-seq rkc)))
         (tutcode-proc-state-on pc key key-state)
         (if (or (and tutcode-show-pending-rk?
                      (or (pair? (rk-context-seq rkc))
                          (pair? prev-pending-rk))) ; prev-pending-rkõ
               ;; 򤼽ѴѴϡ䢥ɽ
               (tutcode-state-has-preedit? c)
               ;; ʸַ򤼽ѴκƵؽ󥻥
               (not (eq? (tutcode-find-descendant-context c) pc)))
           (tutcode-update-preedit pc))))
      ((tutcode-state-kigou)
       (tutcode-proc-state-kigou pc key key-state)
       (tutcode-update-preedit pc))
      ((tutcode-state-yomi)
       (tutcode-proc-state-yomi pc key key-state)
       (tutcode-update-preedit pc))
      ((tutcode-state-converting)
       (tutcode-proc-state-converting pc key key-state)
       (tutcode-update-preedit pc))
      ((tutcode-state-bushu)
       (tutcode-proc-state-bushu pc key key-state)
       (tutcode-update-preedit pc))
      ((tutcode-state-interactive-bushu)
       (tutcode-proc-state-interactive-bushu pc key key-state)
       (tutcode-update-preedit pc))
      ((tutcode-state-code)
       (tutcode-proc-state-code pc key key-state)
       (tutcode-update-preedit pc))
      ((tutcode-state-history)
       (tutcode-proc-state-history pc key key-state)
       (tutcode-update-preedit pc))
      ((tutcode-state-postfix-katakana)
       (tutcode-proc-state-postfix-katakana pc key key-state)
       (tutcode-update-preedit pc))
      ((tutcode-state-postfix-kanji2seq)
       (tutcode-proc-state-postfix-kanji2seq pc key key-state)
       (tutcode-update-preedit pc))
      ((tutcode-state-postfix-seq2kanji)
       (tutcode-proc-state-postfix-seq2kanji pc key key-state)
       (tutcode-update-preedit pc))
      (else
       (tutcode-proc-state-off pc key key-state)
       (if (or (and tutcode-show-pending-rk?
                    (pair? (rk-context-seq (tutcode-context-rk-context pc))))
               (tutcode-state-has-preedit? c)) ; Ƶؽ
         (tutcode-update-preedit pc))))
    (if (or tutcode-use-stroke-help-window?
            (not (eq? tutcode-stroke-help-with-kanji-combination-guide
                      'disable)))
      ;; editorκβǽΤdescendant-contextľ
      (let ((newpc (tutcode-find-descendant-context c)))
        (if
          (and
            (memq (tutcode-context-state newpc)
              '(tutcode-state-on tutcode-state-yomi tutcode-state-bushu
                tutcode-state-interactive-bushu))
            (not (tutcode-context-latin-conv newpc)))
          (tutcode-check-stroke-help-window-begin newpc))))))

;;; Υ줿ȤνԤ
;;; @param pc ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-key-release-handler pc key key-state)
  (if (or (ichar-control? key)
	  (not (tutcode-context-on? pc)))
      ;; don't discard key release event for apps
      (im-commit-raw pc)))

;;; TUT-Code IMνԤ
(define (tutcode-init-handler id im arg)
  (let ((tc (tutcode-context-new id im)))
    (set! tutcode-context-list (cons tc tutcode-context-list))
    tc))

(define (tutcode-release-handler tc)
  (tutcode-save-personal-dictionary #f)
  (set! tutcode-context-list (delete! tc tutcode-context-list))
  (if (null? tutcode-context-list)
    (begin
      (skk-lib-free-dic tutcode-dic)
      (set! tutcode-dic #f))))

(define (tutcode-reset-handler tc)
  (tutcode-flush tc))

(define (tutcode-focus-in-handler tc) #f)

(define (tutcode-focus-out-handler c)
  (if (not tutcode-show-pending-rk?)
    (let* ((tc (tutcode-find-descendant-context c))
           (rkc (tutcode-context-rk-context tc)))
      (rk-flush rkc))))

(define tutcode-place-handler tutcode-focus-in-handler)
(define tutcode-displace-handler tutcode-focus-out-handler)

;;; 䥦ɥʸ뤿˸Ƥִؿ
(define (tutcode-get-candidate-handler c idx accel-enum-hint)
  (let ((tc (tutcode-find-descendant-context c)))
    (if tutcode-use-pseudo-table-style?
      (let* ((vec (tutcode-context-pseudo-table-cands tc))
             (dl (length (vector-ref vec 0)))
             (page (quotient idx dl))
             (pcands (vector-ref vec page))
             (cands
              (or pcands
                  (let ((cands (tutcode-pseudo-table-style-make-new-page tc)))
                    (vector-set! vec page cands)
                    cands))))
        (list-ref cands (remainder idx dl)))
      (tutcode-get-candidate-handler-internal tc idx accel-enum-hint))))

;;; 䥦ɥʸ뤿˸Ƥִؿ
;;; (tutcode-pseudo-table-style-setupθƤӽФ)
(define (tutcode-get-candidate-handler-internal tc idx accel-enum-hint)
  (cond
    ;; 
    ((eq? (tutcode-context-state tc) 'tutcode-state-kigou)
      (let* ((cand (tutcode-get-nth-candidate-for-kigou-mode tc idx))
             (n (remainder idx
                  (length tutcode-heading-label-char-list-for-kigou-mode)))
             (label (nth n tutcode-heading-label-char-list-for-kigou-mode)))
        ;; XXX:annotationɽϸ̵ƤΤǡ""֤Ƥ
        (list cand label "")))
    ;; ҥȥ
    ((eq? (tutcode-context-state tc) 'tutcode-state-history)
      (let* ((cand (tutcode-get-nth-candidate-for-history tc idx))
             (n (remainder idx
                  (length tutcode-heading-label-char-list-for-history)))
             (label (nth n tutcode-heading-label-char-list-for-history)))
        (list cand label "")))
    ;; 䴰/ͽ¬ϸ
    ((eq? (tutcode-context-candidate-window tc)
          'tutcode-candidate-window-predicting)
      (let*
        ((nr-in-page (tutcode-context-prediction-nr-in-page tc))
         (page-limit (tutcode-context-prediction-page-limit tc))
         (pages (quotient idx page-limit))
         (idx-in-page (remainder idx page-limit)))
        ;; ƥڡˤϡnr-in-pageĤ䴰/ͽ¬ϸȡϸ쥬ɤɽ
        (if (< idx-in-page nr-in-page)
          ;; 䴰/ͽ¬ϸʸ
          (let*
            ((nr-predictions (tutcode-lib-get-nr-predictions tc))
             (p-idx (+ idx-in-page (* pages nr-in-page)))
             (i (remainder p-idx nr-predictions))
             (cand (tutcode-lib-get-nth-prediction tc i))
             (word (and (eq? (tutcode-context-predicting tc)
                             'tutcode-predicting-bushu)
                        (tutcode-lib-get-nth-word tc i)))
             (cand-guide
              (if word
                (string-append cand "(" word ")")
                cand))
             (n (remainder p-idx
                  (length tutcode-heading-label-char-list-for-prediction)))
             (label (nth n tutcode-heading-label-char-list-for-prediction)))
            (list cand-guide label ""))
          ;; ϸ쥬
          (let*
            ((guide (tutcode-context-guide tc))
             (guide-len (length guide)))
            (if (= guide-len 0)
              (list "" "" "")
              (let*
                ((guide-idx-in-page (- idx-in-page nr-in-page))
                 (nr-guide-in-page (- page-limit nr-in-page))
                 (guide-idx (+ guide-idx-in-page (* pages nr-guide-in-page)))
                 (n (remainder guide-idx guide-len))
                 (label-cands-alist (nth n guide))
                 (label (car label-cands-alist))
                 (cands (cdr label-cands-alist))
                 (cand
                  (string-list-concat
                    (append cands (list tutcode-guide-mark)))))
                (list cand label "")))))))
    ;; ۸
    ((eq? (tutcode-context-candidate-window tc)
          'tutcode-candidate-window-stroke-help)
      (nth idx (tutcode-context-stroke-help tc)))
    ;; ưإ
    ((eq? (tutcode-context-candidate-window tc)
          'tutcode-candidate-window-auto-help)
      (nth idx (tutcode-context-auto-help tc)))
    ;; ŪѴ
    ((eq? (tutcode-context-state tc) 'tutcode-state-interactive-bushu)
      (let*
        ;; ͽ¬ϸѿή
        ((nr-in-page (tutcode-context-prediction-nr-in-page tc))
         (page-limit (tutcode-context-prediction-page-limit tc))
         (pages (quotient idx page-limit))
         (idx-in-page (remainder idx page-limit))
         (nr-predictions (tutcode-lib-get-nr-predictions tc))
         (p-idx (+ idx-in-page (* pages nr-in-page)))
         (i (remainder p-idx nr-predictions))
         (cand (tutcode-lib-get-nth-prediction tc i))
         (n (remainder p-idx
              (length tutcode-heading-label-char-list-for-prediction)))
         (label (nth n tutcode-heading-label-char-list-for-prediction)))
        (list cand label "")))
    ;; 򤼽Ѵ
    ((eq? (tutcode-context-candidate-window tc)
          'tutcode-candidate-window-converting)
      (let* ((cand (tutcode-get-nth-candidate tc idx))
             (n (remainder idx (length tutcode-heading-label-char-list)))
             (label (nth n tutcode-heading-label-char-list)))
        (list cand label "")))
    (else
      (list "" "" ""))))

;;; 䥦ɥ򤷤Ȥ˸Ƥִؿ
;;; ɽθ䤬򤵤줿硢ꤹ롣
;;; ɽƤʤ䤬򤵤줿(䥦ɥ¦
;;; ڡưԤ줿)硢ֹ򹹿
(define (tutcode-set-candidate-index-handler c pidx)
  (let* ((pc (tutcode-find-descendant-context c))
         (candwin (tutcode-context-candidate-window pc))
         (idx (if tutcode-use-pseudo-table-style?
                ;; XXX:ɽǤϡޥˤ̤б
                ;;     candwinڡΥåϡڡǽθ
                (tutcode-pseudo-table-style-scm-index pc pidx)
                pidx))
         ;; ۸׾Υå򥭡ϤȤƽ(եȥܡ)
         (label-to-key-press
          (lambda (label)
            (let ((key (string->ichar label)))
              (if key
                (tutcode-key-press-handler c key 0)))))
         (candlist-to-key-press
          (lambda (candlist)
            (let* ((candlabel (list-ref candlist idx))
                   (label (cadr candlabel)))
              (label-to-key-press label)))))
    (cond
      ((and (memq candwin '(tutcode-candidate-window-converting
                            tutcode-candidate-window-kigou
                            tutcode-candidate-window-history))
          (>= idx 0)
          (< idx (tutcode-context-nr-candidates pc)))
        (let*
          ((prev (tutcode-context-nth pc))
           (state (tutcode-context-state pc))
           (page-limit
            (case state
              ((tutcode-state-kigou) tutcode-nr-candidate-max-for-kigou-mode)
              ((tutcode-state-history) tutcode-nr-candidate-max-for-history)
              (else tutcode-nr-candidate-max)))
           (prev-page (quotient prev page-limit))
           (new-page (quotient idx page-limit)))
          (tutcode-context-set-nth! pc idx)
          (if (= new-page prev-page)
            (case state
              ((tutcode-state-kigou)
                (tutcode-commit pc
                  (tutcode-prepare-commit-string-for-kigou-mode pc)))
              ((tutcode-state-history)
                (let ((str (tutcode-prepare-commit-string-for-history pc)))
                  (tutcode-commit pc str)
                  (tutcode-flush pc)
                  (tutcode-check-auto-help-window-begin pc
                    (string-to-list str) ())))
              (else
                (tutcode-commit-with-auto-help pc))))
          (tutcode-update-preedit pc)))
      ((and (or (eq? candwin 'tutcode-candidate-window-predicting)
                (eq? candwin 'tutcode-candidate-window-interactive-bushu))
            (>= idx 0))
        (let*
          ((nr-in-page (tutcode-context-prediction-nr-in-page pc))
           (page-limit (tutcode-context-prediction-page-limit pc))
           (idx-in-page (remainder idx page-limit))
           (prev (tutcode-context-prediction-index pc))
           (prev-page (quotient prev page-limit))
           (new-page (quotient idx page-limit)))
          (tutcode-context-set-prediction-index! pc idx)
          (if (= new-page prev-page)
            (if (< idx-in-page nr-in-page)
              (let*
                ((nr-predictions (tutcode-lib-get-nr-predictions pc))
                 (p-idx (+ idx-in-page (* new-page nr-in-page)))
                 (i (remainder p-idx nr-predictions))
                 (mode (tutcode-context-predicting pc)))
                (if (eq? candwin 'tutcode-candidate-window-interactive-bushu)
                  (tutcode-do-commit-prediction-for-interactive-bushu pc i)
                  (if (eq? mode 'tutcode-predicting-bushu)
                    (tutcode-do-commit-prediction-for-bushu pc i)
                    (tutcode-do-commit-prediction pc i
                      (eq? mode 'tutcode-predicting-completion)))))
              ;; ϸ쥬
              (let*
                ((guide (tutcode-context-guide pc))
                 (guide-len (length guide)))
                (if (positive? guide-len)
                  (let*
                    ((guide-idx-in-page (- idx-in-page nr-in-page))
                     (nr-guide-in-page (- page-limit nr-in-page))
                     (guide-idx (+ guide-idx-in-page
                                   (* new-page nr-guide-in-page)))
                     (n (remainder guide-idx guide-len))
                     (label-cands-alist (nth n guide))
                     (label (car label-cands-alist)))
                    (label-to-key-press label))))))
          (tutcode-update-preedit pc)))
        ((eq? candwin 'tutcode-candidate-window-stroke-help)
          (candlist-to-key-press (tutcode-context-stroke-help pc)))
        ((eq? candwin 'tutcode-candidate-window-auto-help)
          (candlist-to-key-press (tutcode-context-auto-help pc))))))

;;; ٱɽбƤ䥦ɥԤλ
;;; (ڡɽ򤵤줿ǥåֹ)
;;; 뤿˸Ƥִؿ
;;; @return (nr display-limit selected-index)
(define (tutcode-delay-activating-handler c)
  (let* ((tc (tutcode-find-descendant-context c))
         (selected-index (tutcode-context-candwin-delay-selected-index tc)))
    (tutcode-context-set-candwin-delay-waiting! tc #f)
    (let
      ((res
        (cond
          ((eq? (tutcode-context-state tc) 'tutcode-state-kigou)
            (list tutcode-nr-candidate-max-for-kigou-mode
                  (tutcode-context-nr-candidates tc)))
          ((eq? (tutcode-context-state tc) 'tutcode-state-history)
            (list tutcode-nr-candidate-max-for-history
                  (tutcode-context-nr-candidates tc)))
          ((eq? (tutcode-context-candidate-window tc)
                'tutcode-candidate-window-predicting)
            (case (tutcode-context-state tc)
              ((tutcode-state-bushu)
                (if (tutcode-check-bushu-prediction-make tc
                      (tutcode-context-prediction-bushu tc) #f) ;ꥹȺ
                  (list (tutcode-context-prediction-page-limit tc)
                        (tutcode-context-prediction-nr-all tc))
                  (list (tutcode-context-prediction-page-limit tc) 0)))
              ((tutcode-state-on)
                (if (tutcode-check-completion-make tc #f 0)
                  (list (tutcode-context-prediction-page-limit tc)
                        (tutcode-context-prediction-nr-all tc))
                  (list (tutcode-context-prediction-page-limit tc) 0)))
              ((tutcode-state-yomi)
                (if (tutcode-check-prediction-make tc #f)
                  (list (tutcode-context-prediction-page-limit tc)
                        (tutcode-context-prediction-nr-all tc))
                  (list (tutcode-context-prediction-page-limit tc) 0)))
              (else
                '(0 0))))
          ((eq? (tutcode-context-candidate-window tc)
                'tutcode-candidate-window-stroke-help)
            (let ((stroke-help (tutcode-stroke-help-make tc)))
              (if (pair? stroke-help)
                (begin
                  (tutcode-context-set-stroke-help! tc stroke-help)
                  (list tutcode-nr-candidate-max-for-kigou-mode
                        (length stroke-help)))
                (list tutcode-nr-candidate-max-for-kigou-mode 0))))
          ((eq? (tutcode-context-candidate-window tc)
                'tutcode-candidate-window-auto-help)
            (let*
              ((tmp (cdr (tutcode-context-auto-help tc)))
               (strlist (car tmp))
               (yomilist (cadr tmp))
               (auto-help (tutcode-auto-help-make tc strlist yomilist)))
              (if (pair? auto-help)
                (begin
                  (tutcode-context-set-auto-help! tc auto-help)
                  (list tutcode-nr-candidate-max-for-kigou-mode
                        (length auto-help)))
                (list tutcode-nr-candidate-max-for-kigou-mode 0))))
          ((eq? (tutcode-context-state tc)
                'tutcode-state-interactive-bushu)
            (list (tutcode-context-prediction-page-limit tc)
                  (tutcode-context-prediction-nr-all tc)))
          ((eq? (tutcode-context-candidate-window tc)
                'tutcode-candidate-window-converting)
            (list tutcode-nr-candidate-max
                  (tutcode-context-nr-candidates tc)))
          (else
            (list tutcode-nr-candidate-max 0)))))
      (reverse
        (if (and tutcode-use-pseudo-table-style?
                 (> (cadr res) 0)) ; nr0ξcandwinɽʤ
          (let ((pres
                  (tutcode-pseudo-table-style-setup tc (cadr res) (car res))))
            ;; candwin-indexsetupƽи˸Ƥɬפ
            (cons (tutcode-pseudo-table-style-candwin-index tc selected-index)
                    (reverse pres)))
          (cons selected-index res))))))

(tutcode-configure-widgets)

;;; TUT-Code IMϿ롣
(register-im
 'tutcode
 "ja"
 "EUC-JP"
 tutcode-im-name-label
 tutcode-im-short-desc
 #f
 tutcode-init-handler
 tutcode-release-handler
 context-mode-handler
 tutcode-key-press-handler
 tutcode-key-release-handler
 tutcode-reset-handler
 tutcode-get-candidate-handler
 tutcode-set-candidate-index-handler
 context-prop-activate-handler
 #f
 tutcode-focus-in-handler
 tutcode-focus-out-handler
 tutcode-place-handler
 tutcode-displace-handler
 )

;;; ɽѴ롣
;;; @param from Ѵоݥɽ
;;; @param translate-alist Ѵɽ
;;; @return Ѵɽ
(define (tutcode-rule-translate from translate-alist)
  (map
    (lambda (elem)
      (cons
        (list
          (map
            (lambda (key)
              (let ((res (assoc key translate-alist)))
                (if res
                  (cadr res)
                  key)))
            (caar elem)))
        (cdr elem)))
    from))

;;; ɽQwertyDvorakѤѴ롣
;;; @param qwerty QwertyΥɽ
;;; @return DvorakѴɽ
(define (tutcode-rule-qwerty-to-dvorak qwerty)
  (tutcode-rule-translate qwerty tutcode-rule-qwerty-to-dvorak-alist))

;;; ɽQwerty-jisQwerty-usѤѴ롣
;;; @param jis Qwerty-jisΥɽ
;;; @return Qwerty-usѴɽ
(define (tutcode-rule-qwerty-jis-to-qwerty-us jis)
  (tutcode-rule-translate jis tutcode-rule-qwerty-jis-to-qwerty-us-alist))

;;; kigou-rule򥭡ܡɥ쥤Ȥ˹碌Ѵ
;;; @param layout tutcode-candidate-window-table-layout
(define (tutcode-kigou-rule-translate layout)
  (let
    ((translate-stroke-help-alist
      (lambda (lis translate-alist)
        (map
          (lambda (elem)
            (cons
              (let ((res (assoc (car elem) translate-alist)))
                (if res
                  (cadr res)
                  (car elem)))
              (cdr elem)))
          lis))))
    (case layout
      ((qwerty-us)
        (set! tutcode-kigou-rule
          (tutcode-rule-qwerty-jis-to-qwerty-us
            (tutcode-kigou-rule-pre-translate
              tutcode-rule-qwerty-jis-to-qwerty-us-alist)))
        (set! tutcode-kigou-rule-stroke-help-top-page-alist
          (translate-stroke-help-alist 
            tutcode-kigou-rule-stroke-help-top-page-alist
            tutcode-rule-qwerty-jis-to-qwerty-us-alist)))
      ((dvorak)
        (set! tutcode-kigou-rule
          (tutcode-rule-qwerty-to-dvorak
            (tutcode-kigou-rule-pre-translate
              tutcode-rule-qwerty-to-dvorak-alist)))
        (set! tutcode-kigou-rule-stroke-help-top-page-alist
          (translate-stroke-help-alist 
            tutcode-kigou-rule-stroke-help-top-page-alist
            tutcode-rule-qwerty-to-dvorak-alist))))))

;;; Qwerty-jisQwerty-usؤѴơ֥롣
(define tutcode-rule-qwerty-jis-to-qwerty-us-alist
  '(
    ("^" "=")
    ("@" "[")
    ("[" "]")
    (":" "'")
    ("]" "`")
    ("\"" "@")
    ("'" "&")
    ("&" "^")
    ("(" "*")
    (")" "(")
    ("|" ")") ;tutcode-kigou-ruleѡ<Shift>0qwerty-jisǤ|ѤƤΤ
    ("=" "_")
    ("~" "+")
    ("_" "|") ;XXX
    ("`" "{")
    ("{" "}")
    ("+" ":")
    ("*" "\"")
    ("}" "~")))

;;; QwertyDvorakؤѴơ֥롣
(define tutcode-rule-qwerty-to-dvorak-alist
  '(
    ;("1" "1")
    ;("2" "2")
    ;("3" "3")
    ;("4" "4")
    ;("5" "5")
    ;("6" "6")
    ;("7" "7")
    ;("8" "8")
    ;("9" "9")
    ;("0" "0")
    ("-" "[")
    ("^" "]") ;106
    ("q" "'")
    ("w" ",")
    ("e" ".")
    ("r" "p")
    ("t" "y")
    ("y" "f")
    ("u" "g")
    ("i" "c")
    ("o" "r")
    ("p" "l")
    ("@" "/") ;106
    ("[" "=") ;106
    ;("a" "a")
    ("s" "o")
    ("d" "e")
    ("f" "u")
    ("g" "i")
    ("h" "d")
    ("j" "h")
    ("k" "t")
    ("l" "n")
    (";" "s")
    (":" "-") ;106
    ("]" "`")
    ("z" ";")
    ("x" "q")
    ("c" "j")
    ("v" "k")
    ("b" "x")
    ("n" "b")
    ;("m" "m")
    ("," "w")
    ("." "v")
    ("/" "z")
    ;(" " " ")
    ;; shift
    ;("!" "!")
    ("\"" "@") ;106
    ;("#" "#")
    ;("$" "$")
    ;("%" "%")
    ("&" "^") ;106
    ("'" "&") ;106
    ("(" "*") ;106
    (")" "(") ;106
    ("=" "{") ;106
    ("~" "}") ;106
    ("|" ")") ;tutcode-kigou-ruleѡ<Shift>0qwerty-jisǤ|ѤƤΤ
    ("_" "|") ;XXX
    ("Q" "\"")
    ("W" "<")
    ("E" ">")
    ("R" "P")
    ("T" "Y")
    ("Y" "F")
    ("U" "G")
    ("I" "C")
    ("O" "R")
    ("P" "L")
    ("`" "?") ;106
    ("{" "+") ;106
    ;("A" "A")
    ("S" "O")
    ("D" "E")
    ("F" "U")
    ("G" "I")
    ("H" "D")
    ("J" "H")
    ("K" "T")
    ("L" "N")
    ("+" "S") ;106
    ("*" "_") ;106
    ("}" "~")
    ("Z" ":")
    ("X" "Q")
    ("C" "J")
    ("V" "K")
    ("B" "X")
    ("N" "B")
    ;("M" "M")
    ("<" "W")
    (">" "V")
    ("?" "Z")
    ))

;;; tutcode-customꤵ줿ɽΥե̾饳ɽ̾äơ
;;; Ѥ륳ɽȤꤹ롣
;;; 륳ɽ̾ϡե̾".scm"򤱤äơ
;;; "-rule"ĤƤʤäɲäΡ
;;; : "tutcode-rule.scm"tutcode-rule
;;;     "tcode.scm"tcode-rule
;;; @param filename tutcode-rule-filename
(define (tutcode-custom-load-rule! filename)
  (and
    (try-load filename)
    (let*
      ((basename (last (string-split filename "/")))
       ;; ե̾".scm"򤱤
       (bnlist (string-to-list basename))
       (codename
        (or
          (and
            (> (length bnlist) 4)
            (string=? (string-list-concat (list-head bnlist 4)) ".scm")
            (string-list-concat (list-tail bnlist 4)))
          basename))
       ;; "-rule"ĤƤʤäɲ
       (rulename
        (or
          (and
            (not (string=? (last (string-split codename "-")) "rule"))
            (string-append codename "-rule"))
          codename)))
      (and rulename
        (symbol-bound? (string->symbol rulename))
        (set! tutcode-rule
          (eval (string->symbol rulename) (interaction-environment)))))))

;;; tutcode-key-customꤵ줿򤼽/ѴϤΥ󥹤
;;; ɽȿǤ
(define (tutcode-custom-set-mazegaki/bushu-start-sequence!)
  (let
    ((make-subrule
      (lambda (keyseq cmd)
        (and keyseq
             (> (string-length keyseq) 0))
          (let ((keys (reverse (string-to-list keyseq))))
            (list (list keys) cmd)))))
    (tutcode-rule-set-sequences!
      (filter
        pair?
        (list
          (make-subrule tutcode-katakana-sequence
            (list
              (lambda (state pc) (tutcode-context-set-katakana-mode! pc #t))))
          (make-subrule tutcode-hiragana-sequence
            (list
              (lambda (state pc) (tutcode-context-set-katakana-mode! pc #f))))
          (make-subrule tutcode-mazegaki-start-sequence
            '(tutcode-mazegaki-start))
          (make-subrule tutcode-latin-conv-start-sequence
            '(tutcode-latin-conv-start))
          (make-subrule tutcode-kanji-code-input-start-sequence
            '(tutcode-kanji-code-input-start))
          (make-subrule tutcode-history-start-sequence
            '(tutcode-history-start))
          (make-subrule tutcode-bushu-start-sequence
            '(tutcode-bushu-start))
          (and
            tutcode-use-interactive-bushu-conversion?
            (make-subrule tutcode-interactive-bushu-start-sequence
              '(tutcode-interactive-bushu-start)))
          (make-subrule tutcode-postfix-bushu-start-sequence
            '(tutcode-postfix-bushu-start))
          (make-subrule tutcode-selection-mazegaki-start-sequence
            '(tutcode-selection-mazegaki-start))
          (make-subrule tutcode-selection-mazegaki-inflection-start-sequence
            '(tutcode-selection-mazegaki-inflection-start))
          (make-subrule tutcode-selection-katakana-start-sequence
            '(tutcode-selection-katakana-start))
          (make-subrule tutcode-selection-kanji2seq-start-sequence
            '(tutcode-selection-kanji2seq-start))
          (make-subrule tutcode-selection-seq2kanji-start-sequence
            '(tutcode-selection-seq2kanji-start))
          (make-subrule tutcode-clipboard-seq2kanji-start-sequence
            '(tutcode-clipboard-seq2kanji-start))
          (make-subrule tutcode-postfix-mazegaki-start-sequence
            '(tutcode-postfix-mazegaki-start))
          (make-subrule tutcode-postfix-mazegaki-1-start-sequence
            '(tutcode-postfix-mazegaki-1-start))
          (make-subrule tutcode-postfix-mazegaki-2-start-sequence
            '(tutcode-postfix-mazegaki-2-start))
          (make-subrule tutcode-postfix-mazegaki-3-start-sequence
            '(tutcode-postfix-mazegaki-3-start))
          (make-subrule tutcode-postfix-mazegaki-4-start-sequence
            '(tutcode-postfix-mazegaki-4-start))
          (make-subrule tutcode-postfix-mazegaki-5-start-sequence
            '(tutcode-postfix-mazegaki-5-start))
          (make-subrule tutcode-postfix-mazegaki-6-start-sequence
            '(tutcode-postfix-mazegaki-6-start))
          (make-subrule tutcode-postfix-mazegaki-7-start-sequence
            '(tutcode-postfix-mazegaki-7-start))
          (make-subrule tutcode-postfix-mazegaki-8-start-sequence
            '(tutcode-postfix-mazegaki-8-start))
          (make-subrule tutcode-postfix-mazegaki-9-start-sequence
            '(tutcode-postfix-mazegaki-9-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-start-sequence
            '(tutcode-postfix-mazegaki-inflection-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-1-start-sequence
            '(tutcode-postfix-mazegaki-inflection-1-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-2-start-sequence
            '(tutcode-postfix-mazegaki-inflection-2-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-3-start-sequence
            '(tutcode-postfix-mazegaki-inflection-3-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-4-start-sequence
            '(tutcode-postfix-mazegaki-inflection-4-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-5-start-sequence
            '(tutcode-postfix-mazegaki-inflection-5-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-6-start-sequence
            '(tutcode-postfix-mazegaki-inflection-6-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-7-start-sequence
            '(tutcode-postfix-mazegaki-inflection-7-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-8-start-sequence
            '(tutcode-postfix-mazegaki-inflection-8-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-9-start-sequence
            '(tutcode-postfix-mazegaki-inflection-9-start))
          (make-subrule tutcode-postfix-katakana-start-sequence
            '(tutcode-postfix-katakana-start))
          (make-subrule tutcode-postfix-katakana-0-start-sequence
            '(tutcode-postfix-katakana-0-start))
          (make-subrule tutcode-postfix-katakana-1-start-sequence
            '(tutcode-postfix-katakana-1-start))
          (make-subrule tutcode-postfix-katakana-2-start-sequence
            '(tutcode-postfix-katakana-2-start))
          (make-subrule tutcode-postfix-katakana-3-start-sequence
            '(tutcode-postfix-katakana-3-start))
          (make-subrule tutcode-postfix-katakana-4-start-sequence
            '(tutcode-postfix-katakana-4-start))
          (make-subrule tutcode-postfix-katakana-5-start-sequence
            '(tutcode-postfix-katakana-5-start))
          (make-subrule tutcode-postfix-katakana-6-start-sequence
            '(tutcode-postfix-katakana-6-start))
          (make-subrule tutcode-postfix-katakana-7-start-sequence
            '(tutcode-postfix-katakana-7-start))
          (make-subrule tutcode-postfix-katakana-8-start-sequence
            '(tutcode-postfix-katakana-8-start))
          (make-subrule tutcode-postfix-katakana-9-start-sequence
            '(tutcode-postfix-katakana-9-start))
          (make-subrule tutcode-postfix-katakana-exclude-1-sequence
            '(tutcode-postfix-katakana-exclude-1))
          (make-subrule tutcode-postfix-katakana-exclude-2-sequence
            '(tutcode-postfix-katakana-exclude-2))
          (make-subrule tutcode-postfix-katakana-exclude-3-sequence
            '(tutcode-postfix-katakana-exclude-3))
          (make-subrule tutcode-postfix-katakana-exclude-4-sequence
            '(tutcode-postfix-katakana-exclude-4))
          (make-subrule tutcode-postfix-katakana-exclude-5-sequence
            '(tutcode-postfix-katakana-exclude-5))
          (make-subrule tutcode-postfix-katakana-exclude-6-sequence
            '(tutcode-postfix-katakana-exclude-6))
          (make-subrule tutcode-postfix-katakana-shrink-1-sequence
            '(tutcode-postfix-katakana-shrink-1))
          (make-subrule tutcode-postfix-katakana-shrink-2-sequence
            '(tutcode-postfix-katakana-shrink-2))
          (make-subrule tutcode-postfix-katakana-shrink-3-sequence
            '(tutcode-postfix-katakana-shrink-3))
          (make-subrule tutcode-postfix-katakana-shrink-4-sequence
            '(tutcode-postfix-katakana-shrink-4))
          (make-subrule tutcode-postfix-katakana-shrink-5-sequence
            '(tutcode-postfix-katakana-shrink-5))
          (make-subrule tutcode-postfix-katakana-shrink-6-sequence
            '(tutcode-postfix-katakana-shrink-6))
          (make-subrule tutcode-postfix-kanji2seq-start-sequence
            '(tutcode-postfix-kanji2seq-start))
          (make-subrule tutcode-postfix-kanji2seq-1-start-sequence
            '(tutcode-postfix-kanji2seq-1-start))
          (make-subrule tutcode-postfix-kanji2seq-2-start-sequence
            '(tutcode-postfix-kanji2seq-2-start))
          (make-subrule tutcode-postfix-kanji2seq-3-start-sequence
            '(tutcode-postfix-kanji2seq-3-start))
          (make-subrule tutcode-postfix-kanji2seq-4-start-sequence
            '(tutcode-postfix-kanji2seq-4-start))
          (make-subrule tutcode-postfix-kanji2seq-5-start-sequence
            '(tutcode-postfix-kanji2seq-5-start))
          (make-subrule tutcode-postfix-kanji2seq-6-start-sequence
            '(tutcode-postfix-kanji2seq-6-start))
          (make-subrule tutcode-postfix-kanji2seq-7-start-sequence
            '(tutcode-postfix-kanji2seq-7-start))
          (make-subrule tutcode-postfix-kanji2seq-8-start-sequence
            '(tutcode-postfix-kanji2seq-8-start))
          (make-subrule tutcode-postfix-kanji2seq-9-start-sequence
            '(tutcode-postfix-kanji2seq-9-start))
          (make-subrule tutcode-postfix-seq2kanji-start-sequence
            '(tutcode-postfix-seq2kanji-start))
          (make-subrule tutcode-postfix-seq2kanji-1-start-sequence
            '(tutcode-postfix-seq2kanji-1-start))
          (make-subrule tutcode-postfix-seq2kanji-2-start-sequence
            '(tutcode-postfix-seq2kanji-2-start))
          (make-subrule tutcode-postfix-seq2kanji-3-start-sequence
            '(tutcode-postfix-seq2kanji-3-start))
          (make-subrule tutcode-postfix-seq2kanji-4-start-sequence
            '(tutcode-postfix-seq2kanji-4-start))
          (make-subrule tutcode-postfix-seq2kanji-5-start-sequence
            '(tutcode-postfix-seq2kanji-5-start))
          (make-subrule tutcode-postfix-seq2kanji-6-start-sequence
            '(tutcode-postfix-seq2kanji-6-start))
          (make-subrule tutcode-postfix-seq2kanji-7-start-sequence
            '(tutcode-postfix-seq2kanji-7-start))
          (make-subrule tutcode-postfix-seq2kanji-8-start-sequence
            '(tutcode-postfix-seq2kanji-8-start))
          (make-subrule tutcode-postfix-seq2kanji-9-start-sequence
            '(tutcode-postfix-seq2kanji-9-start))
          (make-subrule tutcode-auto-help-redisplay-sequence
            '(tutcode-auto-help-redisplay))
          (make-subrule tutcode-auto-help-dump-sequence
            (list tutcode-auto-help-dump))
          (make-subrule tutcode-help-sequence
            '(tutcode-help))
          (make-subrule tutcode-help-clipboard-sequence
            '(tutcode-help-clipboard))
          (make-subrule tutcode-undo-sequence
            '(tutcode-undo)))))))

;;; ɽΰѹ/ɲä롣~/.uimλѤꡣ
;;; ƤӽФˤtutcode-rule-userconfigϿƤǡ
;;; ºݤ˥ɽȿǤΤϡtutcode-context-new
;;;
;;; (tutcode-rule-filename꤬uim-pref~/.uimΤɤǹԤ줿Ǥ
;;;  ~/.uimǤΥɽΰѹƱҤǤǤ褦ˤ뤿ᡣ
;;;  ɽɸhookѰդ)
;;;
;;; ƤӽФ:
;;;   (tutcode-rule-set-sequences!
;;;     '(((("d" "l" "u")) ("" ""))
;;;       ((("d" "l" "d" "u")) ("" ""))))
;;; @param rules 󥹤ϤʸΥꥹ
(define (tutcode-rule-set-sequences! rules)
  (set! tutcode-rule-userconfig
    (append rules tutcode-rule-userconfig)))

;;; ɽξѹ/ɲäΤtutcode-rule-userconfig
;;; ɽȿǤ롣
(define (tutcode-rule-commit-sequences! rules)
  (let* ((newseqs ()) ;ɲä륭
         ;; ɽλꥷ󥹤Ϥʸѹ롣
         ;; seq 
         ;; kanji ϤʸcarҤ餬ʥ⡼ѡcadrʥ⡼
         (setseq1!
          (lambda (elem)
            (let* ((seq (caar elem))
                   (kanji (cadr elem))
                   (curseq (rk-lib-find-seq seq tutcode-rule))
                   (pair (and curseq (cadr curseq))))
              (if (and pair (pair? pair))
                (begin
                  (set-car! pair (car kanji))
                  (if (not (null? (cdr kanji)))
                    (if (< (length pair) 2)
                      (set-cdr! pair (list (cadr kanji)))
                      (set-car! (cdr pair) (cadr kanji)))))
                (begin
                  ;; ɽ˻ꤵ줿󥹤̵
                  (set! newseqs (append newseqs (list elem)))))))))
    (for-each setseq1! rules)
    ;; ɲå
    (if (not (null? newseqs))
      (set! tutcode-rule (append tutcode-rule newseqs)))))

;;; selectionФƻꤵ줿ŬѤִ̤롣
;;; ~/.uimǤλ:
;;; (require "external-filter.scm")
;;; (define (tutcode-filter-fmt-quote state pc)
;;;   (tutcode-selection-filter pc
;;;     (lambda (str)
;;;       ;; ʸ塢ѥޡƬդ (nkf -e: uim-tutcodeEUC-JP)
;;;       (external-filter-launch-command "nkf -e -f | sed -e 's/^/> /'" str))))
;;; (require "fmt-ja.scm")
;;; (define (tutcode-filter-fmt-ja state pc)
;;;   (tutcode-selection-filter pc
;;;     (lambda (str)
;;;       (apply string-append (fmt-ja-str str)))))
;;; (require "japan-util.scm")
;;; (define (tutcode-filter-ascii-fullkana state pc)
;;;   (tutcode-selection-filter pc
;;;     (lambda (str)
;;;       (string-list-concat
;;;         (japan-util-ascii-convert
;;;           (japan-util-halfkana-to-fullkana-convert
;;;             (string-to-list str)))))))
;;; (tutcode-rule-set-sequences!
;;;   `(((("a" "v" "q")) (,tutcode-filter-fmt-quote))
;;;     ((("a" "v" "f")) (,tutcode-filter-fmt-ja))
;;;     ((("a" "v" "a")) (,tutcode-filter-ascii-fullkana))))
;;; @param fn ե륿ؿʸϤ˼ꡢ̤ʸ֤
(define (tutcode-selection-filter pc fn)
  (let ((sel (tutcode-selection-acquire-text pc)))
    (if (pair? sel)
      (let* ((str (string-list-concat sel))
             (res (fn str)))
        (if (and (string? res)
                 ;; ѹ̵ʤcommitʤ(쥯󤬲ʤ褦)
                 (not (string=? res str)))
          (tutcode-selection-commit pc res sel))))))
