#include "tb_task.h"
#include <QSqlDatabase>
#include <QDebug>
#include <QtSql/qsqlquery.h>
#include <QSqlError>

extern QSqlDatabase database ;

Tb_Task::Tb_Task()
{

}
Tb_Task::Tb_Task(QString task_id,QString gid,int gid_index,QString url,QString download_path,
                 QString download_filename,QDateTime create_time)
{
    this->task_id = task_id;
    this->gid = gid;
    this->gid_index = gid_index;
    this->url = url;
    this->download_path = download_path;
    this->download_filename = download_filename;
    this->create_time.setDate(create_time.date());
    this->create_time.setTime(create_time.time());

}
//添加任务
bool Tb_Task::addTbTask(Tb_Task * task)
{
    if(database.open())
    {
        QSqlQuery sql_query;

        sql_query.prepare("insert into download_task values (?,?,?,?,?,?,?);");

        sql_query.addBindValue(task->task_id);
        sql_query.addBindValue(task->gid);
        sql_query.addBindValue(task->gid_index);
        sql_query.addBindValue(task->url);
        sql_query.addBindValue(task->download_path);
        sql_query.addBindValue(task->download_filename);
        sql_query.addBindValue(task->create_time);


        if(!sql_query.exec())
        {
            qWarning()<<"Insert download_task table failed : " << sql_query.lastError();
            database.close();
            return false;
        }
        database.close();
        sql_query.clear();
        return true;
    }

    return false;

}

bool Tb_Task::updateTbTaskByTaskId(Tb_Task *task)
{
    if(database.open())
    {
        QSqlQuery sql_query;

        sql_query.prepare("update  download_task set  gid=? , gid_index=? , url=? ,download_path=? , download_filename=? ,create_time=? where task_id= ?");

        sql_query.addBindValue(task->gid);
        sql_query.addBindValue(task->gid_index);
        sql_query.addBindValue(task->url);
        sql_query.addBindValue(task->download_path);
        sql_query.addBindValue(task->download_filename);
        sql_query.addBindValue(task->create_time);
        sql_query.addBindValue(task->task_id);

        if(!sql_query.exec())
        {
            qWarning()<<"Update download_task table failed : " << sql_query.lastError();
            database.close();
            return false;
        }
        database.close();
        sql_query.clear();
        return true;
    }

    return false;

}

Tb_Task * Tb_Task::getTbTaskByTaskId(QString task_id)
{
    Tb_Task *tb_task =NULL;
    if(database.open())
    {
        QString select_all_sql = "select * from download_task where task_id='"+task_id+"';";
        QSqlQuery sql_query;
        sql_query.prepare(select_all_sql);
        if(!sql_query.exec())
        {
            qDebug()<<"Select download_task table failed : " << sql_query.lastError();
            return NULL;
        }
        else
        {

            while(sql_query.next())
            {

                QString task_id = sql_query.value(0).toString();
                QString gid = sql_query.value(1).toString(); //下载gid
                int gid_index = sql_query.value(2).toInt(); //位置index
                QString url = sql_query.value(3).toString(); //下载url地址
                QString download_path  = sql_query.value(4).toString(); //下载全路径包括文件名
                QString download_filename = sql_query.value(5).toString(); //下载文件名
                QDateTime create_time = sql_query.value(6).toDateTime(); //任务创建时间

                tb_task = new Tb_Task( task_id, gid, gid_index, url, download_path,
                                       download_filename,create_time);

            }
            database.close();
            sql_query.clear();

            return tb_task;

        }
    }
    return NULL;
}

QList<Tb_Task *> Tb_Task::getAllTbTask()
{

    QList<Tb_Task *> list;
    if(!database.open())
    {

            qWarning()<<"Open database failed : " << database.lastError();
            qFatal("failed to connect database.") ;

            return list;
    }
    else
    {
        QString select_all_sql = "select * from download_task;";
        QSqlQuery sql_query;
        sql_query.prepare(select_all_sql);
        if(!sql_query.exec())
        {
            qDebug()<<"Select download_task table failed : " << sql_query.lastError();
            return list;
        }
        else
        {
            while(sql_query.next())
            {
                QString task_id = sql_query.value(0).toString();
                QString gid = sql_query.value(1).toString(); //下载gid
                int gid_index = sql_query.value(2).toInt(); //位置index
                QString url = sql_query.value(3).toString(); //下载url地址
                QString download_path  = sql_query.value(4).toString(); //下载全路径包括文件名
                QString download_filename = sql_query.value(5).toString(); //下载文件名
                QDateTime create_time = sql_query.value(6).toDateTime();//任务创建时间

                Tb_Task * tb_task = new Tb_Task( task_id, gid, gid_index, url, download_path,
                                       download_filename,create_time);
                list.append(tb_task);
            }
        }

        database.close();
        sql_query.clear();

        return list;
    }
}

bool Tb_Task::deleteTbTask(QString task_id)
{
    bool status = true;
    if(database.open())
    {
        QSqlQuery sql_query;

        sql_query.prepare("delete from  download_task where task_id=?;");

        sql_query.addBindValue(task_id);

        if(!sql_query.exec())
        {
            QSqlError error = sql_query.lastError();

            qWarning()<<"Delete download_task failed : " << error;
            status = false;

        }
        sql_query.clear();
        sql_query.prepare("delete from  download_task_status where task_id=?;");
        sql_query.addBindValue(task_id);
        if(!sql_query.exec())
        {
            QSqlError error = sql_query.lastError();

            qWarning()<<"Delete download_task_status failed : " << error;

            status = false;
        }
        database.close();
        sql_query.clear();

    }

    return status;
}
bool Tb_Task::deleteAllTbTask()
{
    if(database.open())
    {
        QSqlQuery sql_query;

        sql_query.prepare("delete from  download_task ;");


        if(!sql_query.exec())
        {

            qWarning()<<"Delete download_task failed : " << sql_query.lastError();
            database.close();
            return false;
        }
        database.close();
        sql_query.clear();
        return true;
    }

    return false;
}


bool Tb_Task::isExistUrl(QString url)
{
    if(database.open())
    {
        QString  select_all_sql ="select count(*)  from download_task,download_task_status where download_task.url='"+url+"' and download_task.task_id=download_task_status.task_id;";
        QSqlQuery sql_query;
        sql_query.prepare(select_all_sql);
        if(!sql_query.exec())
        {
            qWarning()<<"select download_task,download_task_status failed : " << sql_query.lastError();
            return false;
        }
        else
        {

            while(sql_query.next())
            {

               if(sql_query.value(0).toInt() >=1)
               {
                   return true;
               }


           }
            database.close();
            sql_query.clear();

            return false;

        }
    }
    return false;
}

