#include "timesectioncontrol.h"
#include <QHBoxLayout>
TimeSectionControl::TimeSectionControl()
    : QWidget()
{

}
void TimeSectionControl::start_causeEndTimeChanged(QTime startTime)
{
    QTime endTime =  endTimeEdit->time();
    int end_time_hour =0,end_time_minute =0 ;
    if(startTime.hour() > endTime.hour())
    {
        end_time_hour = startTime.hour();
        end_time_minute = startTime.minute() + 1;

        if(end_time_minute == 60)
        {
            end_time_hour = end_time_hour+ 1;
            end_time_minute = 0;
        }
        endTime.setHMS(end_time_hour,end_time_minute,0);
        endTimeEdit->setTime(endTime);
    }
    else if(startTime.hour() == endTime.hour())
    {
        if(startTime.minute() >= endTime.minute() )
        {
            end_time_minute = startTime.minute() +1;
            end_time_hour = endTime.hour();
            if(end_time_minute == 60)
            {
                end_time_hour = endTime.hour() + 1;
                end_time_minute = 0;
            }
            endTime.setHMS(end_time_hour,end_time_minute,0);
            endTimeEdit->setTime(endTime);
        }
    }
}

void TimeSectionControl::end_causeStartTimeChanged(QTime endTime)
{
    QTime starTime =  startTimeEdit->time();
    int hour = starTime.hour();
    int minute = starTime.minute();
    if(starTime.hour() > endTime.hour())
    {
        if(endTime.minute()==0)
        {
            hour = endTime.hour() -1 ;
            minute =59;
        }
        else {
            hour = endTime.hour() ;
            minute = endTime.minute() -1 ;
        }
       starTime.setHMS(hour,minute,0);
       startTimeEdit->setTime(starTime);
    }
    else if (starTime.hour() == endTime.hour())
    {
        if(starTime.minute() >= endTime.minute())
        {
            if(starTime.minute() == 0)
            {
                hour = starTime.hour() -1;
                minute = 59;
            }
            else {
                minute = endTime.minute() -1 ;
            }
            starTime.setHMS(hour,minute,0);
            startTimeEdit->setTime(starTime);
        }
    }
}
TimeSectionControl::TimeSectionControl(QString preDescribInfo , QString afterDescribInfo,QTime *startTime,QTime * endTime)
{
    DLabel * startLabel = new DLabel();
    startLabel->setText(preDescribInfo);
    DLabel * endLabel = new DLabel();
    endLabel->setText(afterDescribInfo);
    startTimeEdit = new QTimeEdit(*startTime);
    endTimeEdit = new QTimeEdit(*endTime);
    QVBoxLayout * timeVBox = new QVBoxLayout();
    timeVBox->addWidget(startLabel);
    QHBoxLayout * timeHBox = new QHBoxLayout();
    //timeHBox->addWidget(startLabel);
    timeHBox->addWidget(startTimeEdit);
    //timeHBox->addWidget(endLabel);
    timeHBox->addWidget(endTimeEdit);
   // this->setLayout(timeHBox);
    timeVBox->addLayout(timeHBox);
    timeVBox->setContentsMargins(0,0,0,0);
    this->setLayout(timeVBox);



    connect(startTimeEdit,&QTimeEdit::timeChanged,this,&TimeSectionControl::get_startTimeChanged);
    connect(endTimeEdit,&QTimeEdit::timeChanged,this,&TimeSectionControl::get_endTimeChanged);

}

void TimeSectionControl::setTimeZone(QTime *startTime,QTime *endTime)
{
    startTimeEdit->setTime(*startTime);
    endTimeEdit->setTime(*endTime);
}
