/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef __UOSXML_H__
#define __UOSXML_H__

#include "libsylph/xml.h"

#define UOSXMLBUFSIZE XMLBUFSIZE

typedef XMLAttr UosXMLAttr;
typedef XMLTag UosXMLTag;
typedef XMLNode UosXMLNode;
typedef XMLFile UosXMLFile;

XMLFile *uos_xml_open_file		(const gchar	*path);
void     uos_xml_close_file		(XMLFile	*file);
GNode   *uos_xml_parse_file		(const gchar	*path);

gint uos_xml_get_dtd		(XMLFile	*file);
gint uos_xml_parse_next_tag		(XMLFile	*file);
void uos_xml_push_tag		(XMLFile	*file,
				 XMLTag		*tag);
void uos_xml_pop_tag		(XMLFile	*file);

XMLTag *uos_xml_get_current_tag	(XMLFile	*file);
GList  *uos_xml_get_current_tag_attr(XMLFile	*file);
gchar  *uos_xml_get_element		(XMLFile	*file);

gint uos_xml_read_line		(XMLFile	*file);
void uos_xml_truncate_buf		(XMLFile	*file);
gboolean  uos_xml_compare_tag	(XMLFile	*file,
				 const gchar	*name);

XMLNode *uos_xml_node_new		(XMLTag		*tag,
				 const gchar	*text);
XMLTag *uos_xml_tag_new		(const gchar	*tag);
XMLAttr *uos_xml_attr_new		(const gchar	*name,
				 const gchar	*value);
void uos_xml_tag_add_attr		(XMLTag		*tag,
				 XMLAttr	*attr);

XMLTag  *uos_xml_copy_tag		(XMLTag		*tag);
XMLAttr *uos_xml_copy_attr		(XMLAttr	*attr);

gint uos_xml_unescape_str		(gchar		*str);
gchar *uos_xml_escape_str		(const gchar	*str);
gint uos_xml_file_put_escape_str	(FILE		*fp,
				 const gchar	*str);

gint uos_xml_file_put_xml_decl	(FILE		*fp);
gint uos_xml_file_put_node		(FILE		*fp,
				 XMLNode	*node);

void uos_xml_free_node		(XMLNode	*node);
void uos_xml_free_tree		(GNode		*node);

#endif /* __UOSXML_H__ */
