/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * november 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <sigctest.h>

// compiled only with libsigc extension
#ifdef USE_SIGCPLUSPLUS

static char buff[256];

// Sigctest MAIN FORM  CLASS
/*
main form constructor
*/
SigctestForm::SigctestForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
}

/*
main form destructor
*/
SigctestForm::~SigctestForm()
{
}

/*
main form setup
*/
extern char *mini_ofolder_xpm[];
void
SigctestForm::GUISetup(void)
{
  SetSize(400,300);
  Title = "Extended signal system test";
  vbox3 = new VDKBox(this,v_box);
  Add(vbox3,0,1,1,0);
  fixed0 = new VDKFixed(this);
  vbox3->Add(fixed0,0,1,1,0);
  aButton = new VDKCustomButton(this,(char*) NULL,"A custom Button",
				16,(GtkPositionType) 1);
  aButton->SetSize(120,32);
  fixed0->Add(aButton,8,8,1,0);
  aToggledButton = new VDKCustomButton(this,(char*) NULL,
				       "a Custom toggled button",
				       32,(GtkPositionType) 1);
  aToggledButton->SetSize(180,32);
  fixed0->Add(aToggledButton,144,8,1,0);
  char* aCustomListTitles[] = { "Title" };
  aCustomList = new VDKCustomList(this,1,aCustomListTitles,
				  (GtkSelectionMode) 0);
  aCustomList->SetSize(120,190);
  aCustomList->AutoResize = false;
  aCustomList->BorderShadow = (GtkShadowType) shadow_in;
  fixed0->Add(aCustomList,8,57,1,0);
  aCheckButton = new VDKCheckButton(this,"checkbutton0");
  fixed0->Add(aCheckButton,142,56,1,0);
  frame0 = new VDKFrame(this,NULL,v_box,shadow_etched_in);
  frame0->SetSize(235,47);
  fixed0->Add(frame0,141,78,1,0);
  frame0->BorderWidth(0);
  aToolbar = new VDKToolbar(this);
  aToolbar->SetSize(231,34);
  frame0->Add(aToolbar,144,81,1,0);
  aToolbar->BorderWidth(3);
  aToolbar->Relief = (GtkReliefStyle) 0;
#include "loadfile.xpm"
  aToolbar->AddButton(loadfile_xpm,NULL,NULL);
  aToolbar->AddButton(mini_ofolder_xpm,NULL,NULL);
  aNotebook = new VDKNotebook(this);
  aNotebook->SetSize(231,113);
  fixed0->Add(aNotebook,144,135,1,0);
  notebook0_page0 = new VDKBox(this,v_box);
  aNotebook->AddPage(notebook0_page0,"page 1");
  notebook0_page2 = new VDKBox(this,v_box);
  aNotebook->AddPage(notebook0_page2,"page 2");
  notebook0_page3 = new VDKBox(this,v_box);
  aNotebook->AddPage(notebook0_page3,"page 3");
  aStatusbar = new VDKStatusbar(this);
  aStatusbar->SetSize(398,20);
  Add(aStatusbar,r_justify,false,false,0);
  aStatusbar->Shadow = shadow_in;
}

void
SigctestForm::Setup(void)
{
  GUISetup();
  // fills custom list with some strings
  aCustomList->Font = new VDKFont(this,"helvetica 12");
  for (int t = 0; t < 10; t++)
    {
      char* p = buff;
      sprintf(p,"Item %d",t);
      aCustomList->AddRow(&p);
    }
  aCustomList->SelectRow(0,0);
  // connects with signals using extended system
  aButton->OnButtonClicked.connect(
            slot(*this,&SigctestForm::OnButtonClicked));
  aCustomList->OnRowSelect.connect(
            slot(*this,&SigctestForm::OnCustomListSelected));
  aCheckButton->OnButtonToggled.connect(
            slot(*this,&SigctestForm::OnCheckButtonToggled));
  /*
  this examples show how to use a paradigm different from the signal-driven.
  Here we base the paradigm on widget state-change,in other words we connect
  with a property change rather than a signal.
  In this way we completely forget signals and concentrate on widget state
  and we want trap when the widget state changes (the underlying signal 
  that caused widget state change remains on the background however)
  */
  // intercepts a value changed into toggle button "Checked" property
  aToggledButton->Checked.OnValueChanged.connect(
            slot(*this,&SigctestForm::OnToggledButtonCheckedPropertyChange));
  // intercepts a value changed into custom list "Unselected" property
  aCustomList->Unselected.OnValueChanged.connect(
            slot(*this,&SigctestForm::OnCustomListUnselectedPropertyChange));
  // traps a value change of toolbar "ButtonPressed" property
  aToolbar->ButtonPressed.OnValueChanged.connect(
            slot(*this,&SigctestForm::OnToolbarButtonPressedPropertyChange));
  // answers to a notebook page switch
  aNotebook->ActivePage.OnValueChanged.connect(
            slot(*this,&SigctestForm::OnNotebookActivePagePropertyChange));
}

void 
SigctestForm::OnButtonClicked(VDKObject* sender)
{
  sprintf(buff,"custom button:%p clicked",sender);
  aStatusbar->Push(buff);
}

void
SigctestForm::OnCustomListSelected(VDKObject* sender, int row, int col)
{
  sprintf(buff,"custom list[%p] selection changed - row:%d", sender, row);
  aStatusbar->Push(buff);
}

void 
SigctestForm::OnCheckButtonToggled(bool toggled)
{
  sprintf(buff,"Check button toggled : %s",
          toggled ? "true" : "false");  
  aStatusbar->Push(buff);
}

void 
SigctestForm::OnNotebookActivePagePropertyChange(int page)
{
  sprintf(buff,"Notebook <ActivePage> property changed : %d",page);
  aStatusbar->Push(buff);
}

void 
SigctestForm::OnToggledButtonCheckedPropertyChange(bool checked)
{
  sprintf(buff,"Toggled button <Checked> property changed : %s",
          checked ? "true" : "false");
  aStatusbar->Push(buff);
}

void
SigctestForm::OnCustomListUnselectedPropertyChange
  (VDKCustomList* sender, VDKPoint p)
{
  sprintf(buff,"Custom list[%p] <Unselected> property changed - row:%d",
                sender,p.x);
  aStatusbar->Push(buff);
}

void
SigctestForm::OnToolbarButtonPressedPropertyChange(int button)
{
  sprintf(buff,"Toolbar <ButtonPressed> property changed:%d",button);
  aStatusbar->Push(buff);
}
// compiled only with libsigc extension
#endif
