# @(#)Makefile
#
# Copyright 1994 - 2012  David A. Bagley, bagleyd@tux.org
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and
# its documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and
# that both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# This program is distributed in the hope that it will be "useful",
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

# Master Makefile for X and Windows

# If this fails to build one may have to edit the individual Imakefiles.
# Also install the appropriate .ad file in $HOME or where ever you
# normally  put these preferences.
# To configure, build, and install in /usr/local/bin
#	make configure  # this step no longer necessary
#	make         # Motif version built by default
#	make run     # this cycles through all programs
#	make install # if you like them
# Any problems please consult the individual README's and let the author know.
# xdial and xthreed are more or less demos and are not built by default.

#SHELL=/bin/sh

#STUFF=abacus dial threed
STUFF=dial threed
GL=rubik skewb dino
ROTATIONAL=${GL} pyraminx oct mball
SLIDING=cubes triangles hexagons panex mlink barrel
ALTRIS=tetris tertris hextris welltris

#XT=${STUFF} ${ROTATIONAL} ${SLIDING} ${ALTRIS}
# Swap this next line in and the next line out to build xdial and xthreed
#XT=${STUFF} ${ROTATIONAL} ${SLIDING}
XT=${ROTATIONAL} ${SLIDING}
#XT=${ALTRIS}

AUTOMAKE=/usr/share/automake-1.12

PRE=
NAME=xt.
#NAME=xpuzzles.
#NAME=xabacus.
#NAME=altris.

PROGRAMS=${XT}

UNIXDIR=./net
DOSDIR=win

all :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			if ! test -f Makefile; then\
				./configure;\
			fi;\
			make all;\
			cd ..;\
		fi;\
	done

win :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}/win32; then\
			cd ${PRE}$${i}${VER}/win32;\
			make;\
			cd ../..;\
		fi;\
	done

automake :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			cp -p ${AUTOMAKE}/config.guess .;\
			cp -p ${AUTOMAKE}/config.sub .;\
			cp -p ${AUTOMAKE}/install-sh .;\
			cp -p ${AUTOMAKE}/mkinstalldirs .;\
			cd ..;\
		fi;\
	done

autoconf :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			$@;\
			rm -rf autom4te.cache;\
			cd ..;\
		fi;\
	done

configure :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			./configure;\
			cd ..;\
		fi;\
	done

# Use this in conjunction with the next one
configure-x :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			./configure --without-motif ;\
			cd ..;\
		fi;\
	done

configure-xm :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			./configure --enable-xm-prefix ;\
			cd ..;\
		fi;\
	done

configure-3d :
	for i in ${GL}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			./configure --without-opengl ;\
			cd ..;\
		fi;\
	done

configure-sound :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in distclean;\
			./configure --without-nas --without-esound --without-nas --enable-def-play="play.sh" ;\
			cd ..;\
		fi;\
	done

imake :
	for i in ${PROGRAMS}; do\
                if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			xmkmf -a;\
			make;\
			cd ..;\
		fi;\
	done


xmkmf :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			xmkmf -a;\
			cd ..;\
		fi;\
	done

# add in all extra features
pre-xmkmf :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			cp -p Imakefile Imakefile.orig;\
			sed -e "s/^XCOMM #define/#define/" Imakefile.orig > Imakefile;\
			cd ..;\
		fi;\
	done

post-xmkmf :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			mv Imakefile.orig Imakefile;\
			cd ..;\
		fi;\
	done

antic :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in $@;\
			cd ..;\
		fi;\
	done

antic-win :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}/win32; then\
			cd ${PRE}$${i}${VER}/win32;\
			make antic;\
			cd ../..;\
		fi;\
	done

cppcheck :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in $@;\
			cd ..;\
		fi;\
	done

lint :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

lint-win :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}/win32; then\
			cd ${PRE}$${i}${VER}/win32;\
			make lint;\
			cd ../..;\
		fi;\
	done

indent :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

indentcheck :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			ls -al *.c *.c~ *.h *.h~;\
			cd ..;\
		fi;\
	done

dbx :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in gdb;\
			cd ..;\
		fi;\
	done

gdb :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in $@;\
			cd ..;\
		fi;\
	done

run :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in $@;\
			cd ..;\
		fi;\
	done

run-scores :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in run.scores;\
			cd ..;\
		fi;\
	done

run-version :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in run.version;\
			cd ..;\
		fi;\
	done

run-win :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}/win32; then\
			cd ${PRE}$${i}${VER}/win32;\
			make -f Makefile run;\
			cd ../..;\
		fi;\
	done

dist-win :
	mkdir -p $(DOSDIR);\
	for i in *README; do\
		cp $${i} $(DOSDIR)/$${i};\
		cp $${i} $(DOSDIR)/$${i}.old;\
		unix2dos $(DOSDIR)/$${i}.old $(DOSDIR)/$${i};\
		rm $(DOSDIR)/$${i}.old;\
	done;\
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}/win32; then\
			cd ${PRE}$${i}${VER}/win32;\
			make -f Makefile dist;\
			cd ../..;\
		fi;\
	done

clean :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in $@;\
			cd ..;\
		fi;\
	done

clean-win :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}/win32; then\
			cd ${PRE}$${i}${VER}/win32;\
			make clean;\
			cd ../..;\
		fi;\
	done

distclean :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in $@;\
			cd ..;\
		fi;\
	done

clean.all :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in $@;\
			cd ..;\
		fi;\
	done

pack :
	rm -rf xt xt.tar.bz2;\
	mkdir ${UNIXDIR};\
	make bzip2;\
	mv ${UNIXDIR} xt ;\
	tar cvjf xt.tar.bz2 xt;\
	sftp gwyn.tux.org

tar :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in tar;\
			cd ..;\
		fi;\
	done

compress :
	if test -d ${UNIXDIR}; then\
		cp -p ${NAME}Makefile ${UNIXDIR}/${NAME}Makefile;\
		cp -p *.README ${UNIXDIR};\
		cp -p *.lsm ${UNIXDIR};\
		for i in ${PROGRAMS}; do\
			if test -d ${PRE}$${i}${VER}; then\
				cd ${PRE}$${i}${VER};\
				make -f Makefile.in $@;\
				cd ..;\
			fi;\
		done;\
	else echo "${UNIXDIR} not a directory";\
	fi

gzip :
	if test -d ${UNIXDIR}; then\
		cp -p ${NAME}Makefile ${UNIXDIR}/${NAME}Makefile;\
		cp -p *.README ${UNIXDIR};\
		cp -p *.lsm ${UNIXDIR};\
		for i in ${PROGRAMS}; do\
			if test -d ${PRE}$${i}${VER}; then\
				cd ${PRE}$${i}${VER};\
				make -f Makefile.in $@;\
				cd ..;\
				mv ${PRE}$${i}${VER}.tar.gz ${UNIXDIR};\
			fi;\
		done;\
	else echo "${UNIXDIR} not a directory";\
	fi

bzip2 :
	if test -d ${UNIXDIR}; then\
		cp -p ${NAME}Makefile ${UNIXDIR}/${NAME}Makefile;\
		cp -p *.README ${UNIXDIR};\
		cp -p *.lsm ${UNIXDIR};\
		for i in ${PROGRAMS}; do\
			if test -d ${PRE}$${i}${VER}; then\
				cd ${PRE}$${i}${VER};\
				make -f Makefile.in $@;\
				cd ..;\
				mv ${PRE}$${i}${VER}.tar.bz2 ${UNIXDIR};\
			fi;\
		done;\
	else echo "${UNIXDIR} not a directory";\
	fi

untar :
	for i in ${PROGRAMS}; do\
		if test -r ${PRE}$${i}${VER}.tar; then\
			tar xvf ${PRE}$${i}${VER}.tar;\
			rm -f ${PRE}$${i}${VER}.tar;\
		else echo "no ${PRE}$${i}${VER}.tar";\
		fi;\
	done

uncompress :
	for i in ${PROGRAMS}; do\
		if test -r ${PRE}$${i}${VER}.tar.Z; then\
			zcat ${PRE}$${i}${VER}.tar.Z | tar xvf -;\
			rm -f ${PRE}$${i}${VER}.tar.Z;\
		else echo "no ${PRE}$${i}${VER}.tar.Z";\
		fi;\
	done

gunzip :
	for i in ${PROGRAMS}; do\
		if test -r ${PRE}$${i}${VER}.tar.gz; then\
			gzcat ${PRE}$${i}${VER}.tar.gz | tar xvf -;\
			rm -f ${PRE}$${i}${VER}.tar.gz;\
		else echo "no ${PRE}$${i}${VER}.tar.gz";\
		fi;\
	done

bunzip2 :
	for i in ${PROGRAMS}; do\
		if test -r ${PRE}$${i}${VER}.tar.bz2; then\
			bzcat ${PRE}$${i}${VER}.tar.bz2 | tar xvf -;\
			rm -f ${PRE}$${i}${VER}.tar.bz2;\
		else echo "no ${PRE}$${i}${VER}.tar.bz2";\
		fi;\
	done

read :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			more README;\
			cd ..;\
		fi;\
	done

man :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in $@;\
			cd ..;\
		fi;\
	done

dist.man :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in dist.man;\
			cd ..;\
		fi;\
	done

html :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in $@;\
			cd ..;\
		fi;\
	done

hlp :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make -f Makefile.in $@;\
			cd ..;\
		fi;\
	done

#print :

small :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

small-win :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}/win32; then\
			cd ${PRE}$${i}${VER}/win32;\
			make small;\
			cd ../..;\
		fi;\
	done

install :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

install-win :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}/win32; then\
			cd ${PRE}$${i}${VER}/win32;\
			make install;\
			cd ../..;\
		fi;\
	done

uninstall :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

install-games :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

uninstall-games :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

install-png :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

uninstall-png :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

install-xpm :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

uninstall-xpm :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

install-xpm-home :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

uninstall-xpm-home :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done

vi :
	for i in ${PROGRAMS}; do\
		vi ${PRE}$${i}${VER}/?`echo $${i} | cut -c2-`.c;\
	done

icon :
	for i in ${PROGRAMS}; do\
		if test -d ${PRE}$${i}${VER}; then\
			cd ${PRE}$${i}${VER};\
			make $@;\
			cd ..;\
		fi;\
	done
