/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DTK_SCREENACE_X11_H
#define DTK_SCREENACE_X11_H

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @brief init x11 display content
 */
int initX11ScreenAce();

/**
 * @brief destory x11 display content
 */
void destoryX11ScreenAce();

/**
 * @brief set protected windowid to prohibit screenshot
 * @param wid: window ID
 * @return true: success
 */
bool xSetProtectedWindow(int32_t window);

/**
 * @brief remove protected windowid to enable screenshot
 * @param wid: window ID
 * @return true: success
 */
bool xRemoveProtectedWindow(int32_t window);

/**
 * @brief set screenshot tools blacklist
 * @param name: blacklist
 * @return true: success
 */
bool xSetScreenShotTools(const char *name);

/**
 * @brief remove screenshot tools blacklist
 * @param name: blacklist
 * @return true: success
 */
bool xRemoveScreenShotTools(char *name);

/**
 * @brief free screenshot tools pointer
 */
void xFreeScreenShotTools();

/**
 * @brief set prohibited
 */
void xSetProhibited(const char* white_lists, bool prohibit);

#ifdef __cplusplus
}
#endif

#endif
