#include "utils/environments.h"
#include "MainWindow.h"
#include "MainWindowSnipe.h"
#include "utils/global.h"
#include "utils/Utils.h"
#include <DApplication>
#include <QDebug>
#include <QLoggingCategory>
#include <DTabWidget>
#include <QScreen>
#include <DLog>
#include <DWidgetUtil>
#include <QLocale>
#include <QScopedPointer>
#include "dbus/session/RecoverySessionDbusService.h"

DCORE_USE_NAMESPACE
DWIDGET_USE_NAMESPACE


int main(int argc, char **argv)
{
    DApplication app(argc, argv);
#if QT_VERSION < QT_VERSION_CHECK(6, 0, 0)
    app.setAttribute(Qt::AA_UseHighDpiPixmaps); // 高清图
#endif
    app.setOrganizationName("deepin");
    app.setApplicationName("uos-recovery-gui");
    app.setApplicationVersion(VERSION);
    app.loadTranslator();

    QString locale = QLocale::system().name();
    QString tsFile = QString("%1/uos-recovery-gui_%2.qm").arg(DI_I18N_GUI_DIR_ENV, locale);
    QScopedPointer<QTranslator> translator(new QTranslator);
    translator->load(tsFile);
    qApp->installTranslator(translator.data());
    qInfo() << QString("locale: <%1> current load ts file: <%2>").arg(locale, tsFile);

    app.setApplicationDisplayName(QObject::tr("Backup and Restore"));
    app.setStyle("chameleon");
    app.setWindowIcon(QIcon::fromTheme("uos-recovery"));
    app.setProductIcon(QIcon::fromTheme("uos-recovery"));
    app.setApplicationDescription(QApplication::translate("main",
        "Backup and Restore is a tool for system backup and restore, and data backup and recovery."));
    //DApplicationSettings saveTheme;
    QLoggingCategory::defaultCategory()->setEnabled(QtDebugMsg, true);

    // app.setAutoActivateWindows(true); // 多DMainWidow不能用这个，DTK的实现不满足要求
    if (!app.setSingleInstance(app.applicationName())) {
        return -1;
    }

    //设置日志
    const QString logFormat = "%{time}{yyyy-MM-dd, HH:mm:ss.zzz}[%{type:1}][%{threadid} ] %{message}\n";
    DLogManager::setLogFormat(logFormat);
    DLogManager::registerJournalAppender();
    DLogManager::registerConsoleAppender();
    DLogManager::registerFileAppender();

//    MainWindow w;
//    w.setFixedSize(QSize(MAIN_WINDOW_WIDTH, MAIN_WINDOW_HEIGHT));

    MainWindowSnipe w;
    int MAIN_WINDOW_WIDTH_984 = 984;
    int MAIN_WINDOW_HEIGHT_650 = 650;
    w.setFixedSize(QSize(MAIN_WINDOW_WIDTH_984, MAIN_WINDOW_HEIGHT_650));
    Dtk::Widget::moveToCenter(&w);

    RecoverySessionDbusService dbus(&w);
    w.show();
    return app.exec();
}