#pragma once
#include "UImgRecovery.h"
#include <QMap>
#include <QTime>
#include "utils/Device.h"

class QTimer;
class RsyncTask;
class SquashfsTask;
class CheckTask;
class RemoveTask;

class GhostUImg : public UImgRecovery
{
    Q_OBJECT

public:
    GhostUImg();
    ~GhostUImg();

    // Ghost备份空间校验
    ErrorCode CheckGhostBackupDiskSpace(const QString &selectDir) override;

    //制作uimg
    ErrorCode createUImg(const SystemCloneRequest &request) override;
    ErrorCode removeUImgBackup(const RemoveUserDataBackupRequest &request) override;

#ifdef QT_DEBUG
    // 这里都是单元测试函数
    QStringList getRsyncSystemBackupFiltersTest();
#endif

private:
    void makeImgFile();
    int updateTimeRemain(int progress);
    bool doSystemUpgradeConfig();
    void unDoSystemUpgradeConfig();
    bool writeGhostDeviceInfo(const QString &filePath);
    qint64 getUsedDeviceSize(const QString &fstabPath);
    QJsonArray getFstabInfos(const QString &fstabPath);
    QJsonObject getSysDirInfos(const quint64 &sysRootSizeBytes, const quint64 &sysRootbSizeBytes, const quint64 &efiSizeBytes);
    bool getRootDev(QString &rootDev);
    QJsonObject getSystemUpgradeInfo();
    void backUpConfFiles();
    void replaceRootUuidContent(const QString &srcFilePath, const QString &destFilePath, const QJsonArray &devInfos);
    QStringList getRsyncSystemBackupFilters();
    void clearUuidInRecoveryConf(const QString &recoveryConf);
    QStringList getV20SystemBackupExcludes();
    void getDirSizeMap(QMap<QString, quint64> &dirSizeMap);
    void getInitBackupDirs();

private slots:
    void subTimeSlot();

private:
    RsyncTask *m_rsyncTask = nullptr;
    SquashfsTask *m_squashfsTask = nullptr;
    CheckTask *m_checkTask = nullptr;
    RemoveTask *m_pRemoveTask = nullptr;
    QMap<QString, RemoveTask*> m_pRemoveTaskMap;
    GhostLog m_ghostLog;
    QTimer *m_subTimer = nullptr;
    QString m_destDir = "";
    QString m_startTime = "";
    int m_totalTimeNeed = 0;
    int m_timeUsed = 0;
    int m_timeIndex = 0;
    bool m_doSystemUpgradeConfig = false;
    OperateType m_curOperateType;
    QString m_curOperateID;
    QDateTime m_imgStartTime;
    QList<GhostDiskInfo> m_diskInfoList;
    QMap<QString, quint64> m_dirSizeMap;
    QString m_initBackupDirs;
    QStringList m_existInitAppDirs;
    int m_progress = 0;
    int m_remainSecond = 0;
    int m_lastRemainSecond = 0;
    int m_lastProgress = 0;
    int m_afterMakeSquashfs = -1;
};
