#ifndef AVIFILE_AVM_EXCEPT_H
#define AVIFILE_AVM_EXCEPT_H

#include "avm_default.h"

//#warning exceptions will be OBSOLETE
/********************************************************

	Exception object
	Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/

AVM_BEGIN_NAMESPACE;

/**
 *
 *   The idea is to use error codes for non-fatal problems
 * ( for example, problem in decompressing one frame is not fatal
 * for video decoder ) and exceptions for problems which leave
 * object in unusable state. GenError is an intermediate case.
 *
 */
class AVMEXPORT BaseError
{
protected:
    const char* file;
    char* module;
    char* description;
    char* severity;
    int line;
public:
    BaseError();
    /** \internal copy constructor */
    BaseError(const BaseError& f);
    BaseError(const char* severity, const char* module, const char* file,
	      int line, const char* desc);
    virtual ~BaseError();
    BaseError& operator=(const BaseError& f);
    void Print();
    void PrintAll();
    const char* GetModule() const;
    const char* GetDesc() const;
};

class AVMEXPORT FatalError: public BaseError
{
public:
    FatalError(const char* mod, const char* f, int l, const char* desc,...);
    FatalError(const FatalError& f):BaseError(f){}
};

class AVMEXPORT GenError: public BaseError
{
public:
    GenError(const char* mod, const char* f, int l, const char* desc,...);
    GenError(const GenError& f):BaseError(f){}
};

#define FATAL(X...) avm::FatalError(__MODULE__,__FILE__,__LINE__,X)
#define WARNING(X...) avm::GenError(__ERR_MODULE__,__FILE__,__LINE__,X)

AVM_END_NAMESPACE;

#ifdef AVM_COMPATIBLE
typedef avm::BaseError BaseError;
typedef avm::FatalError FatalError;
typedef avm::GenError GenError;
#endif // AVM_COMPATIBLE

/***

If you want to understand how exactly it will work:

#include <stdio.h>

class Error
{
public:
    Error()
    {
	int pos;
	__asm__ __volatile__
	("push %%esp\n\t"
	"pop %%eax\n\t"
	: "=a"(pos)
	);
	printf("Created Error object, esp=%x, this=%x\n", pos, this);
    }
    Error(const Error& e)
    {
	printf("Copy-created Error object %x from %x\n", this, &e);
    }
    ~Error()
    {
	printf("Destroyed Error object, this=%x\n", this);
    }
};

void main()
{
    try
    {
	throw Error();
    }
    catch(const Error& e)
    {
	int pos;
	__asm__ __volatile__
	("push %%esp\n\t"
	"pop %%eax\n\t"
	: "=a"(pos)
	);
	printf("esp %x\n", pos);	
	printf("Caught object %x\n", &e);
    }
}

Created Error object, esp=bffff910, this=bffff964
Copy-created Error object 804a0c8 from bffff964
Destroyed Error object, this=bffff964
esp bffff940
Caught object 804a0c8
Destroyed Error object, this=804a0c8

***/

#endif // AVIFILE_AVM_EXCEPT_H
