////////////////////////////////////////////////////////////////////////////////
// checkstyle: Checks Java source code for adherence to a set of rules.
// Copyright (C) 2001-2020 the original author or authors.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////

package org.checkstyle.suppressionxpathfilter;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import org.junit.jupiter.api.Test;

import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.checks.coding.MultipleVariableDeclarationsCheck;

public class XpathRegressionMultipleVariableDeclarationsTest extends AbstractXpathTestSupport {

    private final String checkName = MultipleVariableDeclarationsCheck.class.getSimpleName();

    @Override
    protected String getCheckName() {
        return checkName;
    }

    @Test
    public void testOne() throws Exception {
        final File fileToProcess = new File(
                getPath("SuppressionXpathRegressionMultipleVariableDeclarationsOne.java"));

        final DefaultConfiguration moduleConfig =
                createModuleConfig(MultipleVariableDeclarationsCheck.class);

        final String[] expectedViolation = {
            "4:5: " + getCheckMessage(MultipleVariableDeclarationsCheck.class,
                MultipleVariableDeclarationsCheck.MSG_MULTIPLE_COMMA),
        };

        final List<String> expectedXpathQueries = Arrays.asList(
            "/CLASS_DEF[./IDENT["
                + "@text='SuppressionXpathRegressionMultipleVariableDeclarationsOne']]/OBJBLOCK"
                + "/VARIABLE_DEF[./IDENT[@text='i']]",
            "/CLASS_DEF[./IDENT["
                + "@text='SuppressionXpathRegressionMultipleVariableDeclarationsOne']]/OBJBLOCK"
                + "/VARIABLE_DEF[./IDENT[@text='i']]/MODIFIERS",
            "/CLASS_DEF[./IDENT["
                + "@text='SuppressionXpathRegressionMultipleVariableDeclarationsOne']]/OBJBLOCK"
                + "/VARIABLE_DEF[./IDENT[@text='i']]/TYPE",
            "/CLASS_DEF[./IDENT["
                + "@text='SuppressionXpathRegressionMultipleVariableDeclarationsOne']]/OBJBLOCK"
                + "/VARIABLE_DEF[./IDENT[@text='i']]/TYPE/LITERAL_INT",
            "/CLASS_DEF[./IDENT["
                + "@text='SuppressionXpathRegressionMultipleVariableDeclarationsOne']]/OBJBLOCK"
                + "/VARIABLE_DEF[./IDENT[@text='j']]",
            "/CLASS_DEF[./IDENT["
                + "@text='SuppressionXpathRegressionMultipleVariableDeclarationsOne']]/OBJBLOCK"
                + "/VARIABLE_DEF[./IDENT[@text='j']]/MODIFIERS",
            "/CLASS_DEF[./IDENT["
                + "@text='SuppressionXpathRegressionMultipleVariableDeclarationsOne']]/OBJBLOCK"
                + "/VARIABLE_DEF[./IDENT[@text='j']]/TYPE",
            "/CLASS_DEF[./IDENT["
                + "@text='SuppressionXpathRegressionMultipleVariableDeclarationsOne']]/OBJBLOCK"
                + "/VARIABLE_DEF[./IDENT[@text='j']]/TYPE/LITERAL_INT"
        );

        runVerifications(moduleConfig, fileToProcess, expectedViolation,
                expectedXpathQueries);
    }

    @Test
    public void testTwo() throws Exception {
        final File fileToProcess = new File(
                getPath("SuppressionXpathRegressionMultipleVariableDeclarationsTwo.java"));

        final DefaultConfiguration moduleConfig =
                createModuleConfig(MultipleVariableDeclarationsCheck.class);

        final String[] expectedViolation = {
            "4:5: " + getCheckMessage(MultipleVariableDeclarationsCheck.class,
                MultipleVariableDeclarationsCheck.MSG_MULTIPLE),
        };

        final List<String> expectedXpathQueries = Arrays.asList(
            "/CLASS_DEF[./IDENT["
                + "@text='SuppressionXpathRegressionMultipleVariableDeclarationsTwo']]/OBJBLOCK"
                + "/VARIABLE_DEF[./IDENT[@text='i1']]",
            "/CLASS_DEF[./IDENT["
                + "@text='SuppressionXpathRegressionMultipleVariableDeclarationsTwo']]/OBJBLOCK"
                + "/VARIABLE_DEF[./IDENT[@text='i1']]/MODIFIERS",
            "/CLASS_DEF[./IDENT["
                + "@text='SuppressionXpathRegressionMultipleVariableDeclarationsTwo']]/OBJBLOCK"
                + "/VARIABLE_DEF[./IDENT[@text='i1']]/TYPE",
            "/CLASS_DEF[./IDENT["
                + "@text='SuppressionXpathRegressionMultipleVariableDeclarationsTwo']]/OBJBLOCK"
                + "/VARIABLE_DEF[./IDENT[@text='i1']]/TYPE/LITERAL_INT"
        );

        runVerifications(moduleConfig, fileToProcess, expectedViolation,
                expectedXpathQueries);
    }
}
