/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.CigarArray;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.SequenceI;

public class AlignmentView {
    private SeqCigar[] sequences = null;
    private int[] contigs = null;
    private int width = 0;
    private int firstCol = 0;

    public AlignmentView(CigarArray seqcigararray) {
        if (!seqcigararray.isSeqCigarArray()) {
            throw new Error("Implementation Error - can only make an alignment view from a CigarArray of sequences.");
        }
        this.contigs = seqcigararray.getDeletedRegions();
        this.sequences = seqcigararray.getSeqCigarArray();
        this.width = seqcigararray.getWidth();
    }

    public AlignmentView(CigarArray sdata, int firstcol) {
        this(sdata);
        this.firstCol = firstcol;
    }

    public void setSequences(SeqCigar[] sequences) {
        this.sequences = sequences;
    }

    public void setContigs(int[] contigs) {
        this.contigs = contigs;
    }

    public SeqCigar[] getSequences() {
        return this.sequences;
    }

    public int[] getContigs() {
        return this.contigs;
    }

    public Object[] getAlignmentAndColumnSelection(char gapCharacter) {
        ColumnSelection colsel = new ColumnSelection();
        return new Object[]{SeqCigar.createAlignmentSequences(this.sequences, gapCharacter, colsel, this.contigs), colsel};
    }

    public String[] getSequenceStrings(char c) {
        String[] seqs = new String[this.sequences.length];
        for (int n = 0; n < this.sequences.length; ++n) {
            String fullseq = this.sequences[n].getSequenceString(c);
            if (this.contigs != null) {
                seqs[n] = "";
                int p = 0;
                for (int h = 0; h < this.contigs.length; h += 3) {
                    int n2 = n;
                    seqs[n2] = seqs[n2] + fullseq.substring(p, this.contigs[h + 1]);
                    p = this.contigs[h + 1] + this.contigs[h + 2];
                }
                int n3 = n;
                seqs[n3] = seqs[n3] + fullseq.substring(p);
                continue;
            }
            seqs[n] = fullseq;
        }
        return seqs;
    }

    public int getWidth() {
        return this.width;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    public SequenceI[][] getVisibleContigs(char gapCharacter) {
        SequenceI[][] smsa;
        int njobs = 1;
        if (this.sequences == null || this.width <= 0) {
            return null;
        }
        if (this.contigs != null && this.contigs.length > 0) {
            int start = 0;
            njobs = 0;
            int fwidth = this.width;
            for (int contig = 0; contig < this.contigs.length; contig += 3) {
                if (this.contigs[contig + 1] - start > 0) {
                    ++njobs;
                }
                fwidth += this.contigs[contig + 2];
                start = this.contigs[contig + 1] + this.contigs[contig + 2];
            }
            if (start < fwidth) {
                ++njobs;
            }
            smsa = new SequenceI[njobs][];
            start = 0;
            int j = 0;
            for (int contig = 0; contig < this.contigs.length; contig += 3) {
                if (this.contigs[contig + 1] - start > 0) {
                    SequenceI[] mseq = new SequenceI[this.sequences.length];
                    for (int s = 0; s < mseq.length; ++s) {
                        mseq[s] = this.sequences[s].getSeq(gapCharacter).getSubSequence(start, this.contigs[contig + 1]);
                    }
                    smsa[j] = mseq;
                    ++j;
                }
                start = this.contigs[contig + 1] + this.contigs[contig + 2];
            }
            if (start < fwidth) {
                SequenceI[] mseq = new SequenceI[this.sequences.length];
                for (int s = 0; s < mseq.length; ++s) {
                    mseq[s] = this.sequences[s].getSeq(gapCharacter).getSubSequence(start, fwidth + 1);
                }
                smsa[j] = mseq;
                ++j;
            }
        } else {
            smsa = new SequenceI[][]{new SequenceI[this.sequences.length]};
            for (int s = 0; s < this.sequences.length; ++s) {
                smsa[0][s] = this.sequences[s].getSeq(gapCharacter);
            }
        }
        return smsa;
    }

    public Object[] getUpdatedView(SequenceI[][] nvismsa, AlignmentOrder[] orders, char gapCharacter) {
        if (this.sequences == null || this.width <= 0) {
            throw new Error("empty view cannot be updated.");
        }
        if (nvismsa == null) {
            throw new Error("nvismsa==null. use getAlignmentAndColumnSelection() instead.");
        }
        if (this.contigs != null && this.contigs.length > 0) {
            SequenceI[] alignment = new SequenceI[this.sequences.length];
            ColumnSelection columnselection = new ColumnSelection();
            if (this.contigs != null && this.contigs.length > 0) {
                int s;
                int start = 0;
                int nwidth = 0;
                int owidth = this.width;
                int j = 0;
                for (int contig = 0; contig < this.contigs.length; contig += 3) {
                    owidth += this.contigs[contig + 2];
                    if (this.contigs[contig + 1] - start > 0) {
                        int swidth = 0;
                        if (nvismsa[j] != null) {
                            SequenceI[] mseq = nvismsa[j];
                            AlignmentOrder order = orders == null ? null : orders[j];
                            ++j;
                            if (mseq.length != this.sequences.length) {
                                throw new Error("Mismatch between number of sequences in block " + j + " (" + mseq.length + ") and the original view (" + this.sequences.length + ")");
                            }
                            swidth = mseq[0].getLength();
                            for (int s2 = 0; s2 < mseq.length; ++s2) {
                                if (alignment[s2] == null) {
                                    alignment[s2] = mseq[s2];
                                    continue;
                                }
                                alignment[s2].setSequence(alignment[s2].getSequenceAsString() + mseq[s2].getSequenceAsString());
                                if (mseq[s2].getStart() <= mseq[s2].getEnd()) {
                                    alignment[s2].setEnd(mseq[s2].getEnd());
                                }
                                if (order == null) continue;
                                order.updateSequence(mseq[s2], alignment[s2]);
                            }
                        } else {
                            for (int s3 = 0; s3 < this.sequences.length; ++s3) {
                                SequenceI oseq = this.sequences[s3].getSeq(gapCharacter).getSubSequence(start, this.contigs[contig + 1]);
                                if (swidth < oseq.getLength()) {
                                    swidth = oseq.getLength();
                                }
                                if (alignment[s3] == null) {
                                    alignment[s3] = oseq;
                                    continue;
                                }
                                alignment[s3].setSequence(alignment[s3].getSequenceAsString() + oseq.getSequenceAsString());
                                if (oseq.getEnd() < oseq.getStart()) continue;
                                alignment[s3].setEnd(oseq.getEnd());
                            }
                            ++j;
                        }
                        nwidth += swidth;
                    }
                    start = this.contigs[contig + 1] + this.contigs[contig + 2];
                    for (s = 0; s < this.sequences.length; ++s) {
                        SequenceI hseq = this.sequences[s].getSeq(gapCharacter).getSubSequence(this.contigs[contig + 1], start);
                        if (alignment[s] == null) {
                            alignment[s] = hseq;
                            continue;
                        }
                        alignment[s].setSequence(alignment[s].getSequenceAsString() + hseq.getSequenceAsString());
                        if (hseq.getEnd() < hseq.getStart()) continue;
                        alignment[s].setEnd(hseq.getEnd());
                    }
                    columnselection.hideColumns(nwidth, nwidth + this.contigs[contig + 2] - 1);
                    nwidth += this.contigs[contig + 2];
                }
                if (j < nvismsa.length) {
                    int swidth = 0;
                    if (nvismsa[j] != null) {
                        SequenceI[] mseq = nvismsa[j];
                        AlignmentOrder order = orders != null ? orders[j] : null;
                        swidth = mseq[0].getLength();
                        for (int s4 = 0; s4 < mseq.length; ++s4) {
                            if (alignment[s4] == null) {
                                alignment[s4] = mseq[s4];
                                continue;
                            }
                            alignment[s4].setSequence(alignment[s4].getSequenceAsString() + mseq[s4].getSequenceAsString());
                            if (mseq[s4].getEnd() >= mseq[s4].getStart()) {
                                alignment[s4].setEnd(mseq[s4].getEnd());
                            }
                            if (order == null) continue;
                            order.updateSequence(mseq[s4], alignment[s4]);
                        }
                    } else if (start < owidth) {
                        for (s = 0; s < this.sequences.length; ++s) {
                            SequenceI oseq = this.sequences[s].getSeq(gapCharacter).getSubSequence(start, owidth + 1);
                            if (swidth < oseq.getLength()) {
                                swidth = oseq.getLength();
                            }
                            if (alignment[s] == null) {
                                alignment[s] = oseq;
                                continue;
                            }
                            alignment[s].setSequence(alignment[s].getSequenceAsString() + oseq.getSequenceAsString());
                            if (oseq.getEnd() < oseq.getStart()) continue;
                            alignment[s].setEnd(oseq.getEnd());
                        }
                        nwidth += swidth;
                    }
                }
            }
            return new Object[]{alignment, columnselection};
        }
        if (nvismsa.length != 1) {
            throw new Error("Mismatch between visible blocks to update and number of contigs in view (contigs=0,blocks=" + nvismsa.length);
        }
        if (nvismsa[0] != null) {
            return new Object[]{nvismsa[0], new ColumnSelection()};
        }
        return this.getAlignmentAndColumnSelection(gapCharacter);
    }

    public int[] getVisibleContigs() {
        if (this.contigs != null && this.contigs.length > 0) {
            int start = 0;
            int nvis = 0;
            int fwidth = this.width;
            for (int contig = 0; contig < this.contigs.length; contig += 3) {
                if (this.contigs[contig + 1] - start > 0) {
                    ++nvis;
                }
                fwidth += this.contigs[contig + 2];
                start = this.contigs[contig + 1] + this.contigs[contig + 2];
            }
            if (start < fwidth) {
                ++nvis;
            }
            int[] viscontigs = new int[nvis * 2];
            nvis = 0;
            start = 0;
            for (int contig = 0; contig < this.contigs.length; contig += 3) {
                if (this.contigs[contig + 1] - start > 0) {
                    viscontigs[nvis] = start;
                    viscontigs[nvis + 1] = this.contigs[contig + 1] - 1;
                    nvis += 2;
                }
                start = this.contigs[contig + 1] + this.contigs[contig + 2];
            }
            if (start < fwidth) {
                viscontigs[nvis] = start;
                viscontigs[nvis + 1] = fwidth;
                nvis += 2;
            }
            return viscontigs;
        }
        return new int[]{0, this.width};
    }

    public int getAlignmentOrigin() {
        return this.firstCol;
    }
}

