/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.server;

import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.net.ssl.internal.www.protocol.https.Handler;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.Security;
import org.emboss.jemboss.JembossJarUtil;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.soap.GetWossname;

public class TestPublicServer {
    private static JembossParams mysettings;

    public TestPublicServer() {
        if (mysettings.getPublicSoapURL().startsWith("https") && !mysettings.getUseHTTPSProxy()) {
            System.setProperty("https.proxyHost", "");
            System.setProperty("http.proxyHost", "");
            System.setProperty("proxyHost", "");
            String[] settings = new String[]{new String("proxy.override=true")};
            mysettings.updateJembossPropStrings(settings);
        }
        if (mysettings.getPublicSoapURL().startsWith("https")) {
            Provider p = new Provider();
            Security.addProvider((java.security.Provider)p);
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

                public URLStreamHandler createURLStreamHandler(String protocol) {
                    if (protocol != null && protocol.compareTo("https") == 0) {
                        return new Handler();
                    }
                    return null;
                }
            });
            System.setProperty("javax.net.ssl.trustStore", "resources/client.keystore");
            String jembossClientKeyStore = System.getProperty("user.home") + "/.jembossClientKeystore";
            try {
                new JembossJarUtil("resources/client.jar").writeByteFile("client.keystore", jembossClientKeyStore);
                System.setProperty("javax.net.ssl.trustStore", jembossClientKeyStore);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            GetWossname ewoss = new GetWossname(mysettings);
            System.out.println(ewoss.getWossnameText());
            System.out.println("\n\nAbove are the wossname results from the server :\n" + mysettings.getPublicSoapURL());
        }
        catch (Exception e) {
            System.out.println("\nFailed to connect to :\n" + mysettings.getPublicSoapURL());
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        mysettings = new JembossParams();
        new TestPublicServer();
    }
}

