/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.tag.docbook;

import org.dbdoclet.xiphias.dom.NodeImpl;


public class Varlistentry extends DocBookElement {

    Varlistentry() {
        super("varlistentry");
        setFormatType(FORMAT_BLOCK);
    }

    @Override
    public void closed() {

        if (hasChildNodes() == false) {

            appendChild(new Term());
            appendChild(new Listitem().appendChild(new Simpara()));
            return;
        }

        if (getNumberOfChildNodes() == 1) {

            NodeImpl node = (NodeImpl) getTrafoChildNodes().get(0);

            if (node instanceof Term) {

                appendChild(new Listitem().appendChild(new Simpara()));
                return;
            }

            if (node instanceof Listitem) {

                insertChild(0, new Term());
                return;
            }
        }
    }
}
