
;
; Data used to generate directory in CBM BASIC format
;

dir_hdr:                     ; 32 bytes - header

	!byte $01, $08           ; program location
	!byte $01, $01           ; link to the next line - dummy, will be regenerated by BASIC
	!byte $00, $00           ; line number 0
	!byte $12, $22           ; reverse mode, quote
	!pet "                "  ; space for disk/directory name
    !byte $22, $20           ; quote, space
	!pet "   2a"             ; default ID, disk format
	!byte $00                ; end of the line

dir_hdr_sd:                  ; 32 bytes - header

	!byte $01, $08           ; program location
	!byte $01, $01           ; link to the next line - dummy, will be regenerated by BASIC
	!byte $00, $00           ; line number 0
	!byte $12, $22           ; reverse mode, quote
	!pet "sd card"           ; space for disk/directory name
	!byte $A0, $A0, $A0, $A0, $A0, $A0, $A0, $A0, $A0
    !byte $22, $20           ; quote, space
	!pet "fat32"             ; filesystem
	!byte $00                ; end of the line

dir_end:                     ; 19 bytes

	!byte $01, $01           ; link to the next line - dummy, will be regenerated by BASIC
	!byte $00, $00           ; line number 0 (blocks available)
	!pet "blocks free."
	!byte $00, $00, $00      ; end of the line, end of program marker

; File types / extensions

dir_types:

	!pet "del", $00          ; deleted file
	!pet "seq", $00          ; sequential file
	!pet "prg", $00          ; program (executable)
	!pet "usr", $00          ; user type
	!pet "rel", $00          ; random access file
	!pet "cbm", $00          ; CBM-style partition
	!pet "dir", $00          ; directory

; File types below are not mandatory

	!pet "tap", $00          ; tape image
	!pet "d67", $00          ; CBM 2040 (DOS 1)               - disk image
	!pet "d64", $00          ; CBM 1541 / 2031 / 3040 / 4040  - disk image
	!pet "d71", $00          ; CBM 1571                       - disk image
	!pet "d81", $00          ; CBM 1581                       - disk image
	!pet "d80", $00          ; CBM 8050                       - disk image
	!pet "d81", $00          ; CBM 8250 / 1001                - disk image
	!pet "d90", $00          ; CBM D9060 / D9090              - hard disk image
	!pet "d1m", $00          ; CMD FD 2000 / 4000             - disk image (DD)
	!pet "d2m", $00          ; CMD FD 2000 / 4000             - disk image (HD)
	!pet "d4m", $00          ; CMD FD 4000                    - disk image (ED)
	!pet "dhd", $00          ; CMD HD                         - hard disk image
	!pet "dnp", $00          ; CMD partition                  - single partition image
	!pet "rom", $00          ; rom image
	!pet "m65", $00          ; MEGA65 utility

dir_types__end:
