/**************************************************************/
/* ********************************************************** */
/* *                                                        * */
/* *                                                        * */
/* *                                                        * */
/* *  $Module:  CONVERTER FROM PROLOG TO DFG SYNTAX         * */ 
/* *                                                        * */
/* *  Copyright (C) 1998, 1999, 2000, 2001                  * */
/* *  MPI fuer Informatik                                   * */
/* *                                                        * */
/* *  This program is free software; you can redistribute   * */
/* *  it and/or modify it under the terms of the FreeBSD    * */
/* *  Licence.                                              * */
/* *                                                        * */
/* *  This program is distributed in the hope that it will  * */
/* *  be useful, but WITHOUT ANY WARRANTY; without even     * */
/* *  the implied warranty of MERCHANTABILITY or FITNESS    * */
/* *  FOR A PARTICULAR PURPOSE.  See the LICENCE file       * */
/* *  for more details.                                     * */
/* *                                                        * */
/* *                                                        * */
/* $Revision: 1.6 $                                         * */
/* $State: Exp $                                            * */
/* $Date: 2010-02-22 14:09:58 $                             * */
/* $Author: weidenb $                                       * */
/* *                                                        * */
/* *             Contact:                                   * */
/* *             Christoph Weidenbach                       * */
/* *             MPI fuer Informatik                        * */
/* *             Stuhlsatzenhausweg 85                      * */
/* *             66123 Saarbruecken                         * */
/* *             Email: spass@mpi-inf.mpg.de                * */
/* *             Germany                                    * */
/* *                                                        * */
/* ********************************************************** */
/**************************************************************/


/* $RCSfile: prolog2dfg.c,v $ */

#include <errno.h>
#include "list.h"
#include "symbol.h"
#include "flags.h"
#include "term.h"
#include "foldfg.h"
#include "pro.h"
#include "clause.h"

#define PROLOG2DFG__VERSION "0.50"

int main(int argc, const char* argv[])
{
  LIST       Clauses;
  FILE       *File;
  const char *FileName;
  FLAGSTORE  Flags;
  PRECEDENCE Precedence;

  memory_Init(memory__UNLIMITED);
  symbol_Init(TRUE);
  stack_Init();
  flag_Init(flag_SPASS);

  Flags = flag_CreateStore();
  flag_InitStoreByDefaults(Flags);
  Precedence = symbol_CreatePrecedence();

  term_Init();
  fol_Init(TRUE, Precedence);
  clause_Init();

  if (argc < 3) {
    fputs("\n\t          prolog2dfg Version ", stdout);
    fputs(PROLOG2DFG__VERSION, stdout);
    puts("\n\t       Usage: prolog2dfg <input-file>  <output-file>\n");
    return EXIT_FAILURE;
  }
  
  /* Read input file in PROLOG syntax */
  FileName = argv[1];
  File     = misc_OpenFile(FileName, "r");
  Clauses  = pro_PrologParser(File, Flags, Precedence);
  misc_CloseFile(File, FileName);

  /* Write output file in DFG syntax */
  FileName = argv[2];
  File     = misc_OpenFile(FileName,"w");
  fprintf(File, "begin_problem(Unknown).\n\n");
  fprintf(File, "list_of_descriptions.\n");
  fprintf(File, "  name({* Unknown *}).\n");
  fprintf(File, "  author({*prolog2dfg*}).\n");
  fprintf(File, "  status(unknown).\n");
  fprintf(File, "  description({* File generated by prlog2dfg Version ");
  fprintf(File, PROLOG2DFG__VERSION);
  fprintf(File, "*}).\n");
  fprintf(File, "end_of_list.\n\n");
  fprintf(File, "list_of_symbols.\n");
  symbol_FPrintDFGSignature(File);
  fprintf(File, "end_of_list.\n\n");
  fprintf(File, "list_of_clauses(conjectures, cnf).\n");
  
  for ( ; !list_Empty(Clauses); Clauses = list_Pop(Clauses)) {
    clause_FPrintDFG(File, list_Car(Clauses), FALSE);
    clause_Delete(list_Car(Clauses));
  }
 
  fprintf(File, "end_of_list.\n\n");
  fprintf(File, "end_problem.\n\n");
  misc_CloseFile(File, FileName);
  printf("\nResult of Transformation is written to file: %s\n\n", argv[2]);

  flag_DeleteStore(Flags);
  symbol_DeletePrecedence(Precedence);
  fol_Free();
  symbol_FreeAllSymbols();
#ifdef CHECK
  memory_Print();
#endif
  return 0;
}

