.TH "TXT2REGEX" 1 "May 21, 2020" ""

.SH NAME
.P
\fBtxt2regex\fR \-\- console regular expression wizard
.SH SYNOPSIS
.P
\fBtxt2regex\fR [\fB\-\-nocolor\fR|\fB\-\-whitebg\fR] [\fB\-\-all\fR|\fB\-\-prog\fR \fIprograms\fR]
.P
\fBtxt2regex\fR \fB\-\-showmeta\fR
.P
\fBtxt2regex\fR \fB\-\-showinfo\fR \fIprogram\fR [\fB\-\-nocolor\fR]
.P
\fBtxt2regex\fR \fB\-\-history\fR \fIvalue\fR [\fB\-\-all\fR|\fB\-\-prog\fR \fIprograms\fR]
.P
\fBtxt2regex\fR \fB\-\-make\fR \fIlabel\fR [\fB\-\-all\fR|\fB\-\-prog\fR \fIprograms\fR]
.SH DESCRIPTION
.P
\fBtxt2regex\fR is a regular expression wizard that converts human
sentences to regexes.
.P
In a simple interactive console interface, the user answer questions and
\fBtxt2regex\fR builds the regexes for more than 20 programs.
.P
\fIhttps://aurelio.net/projects/txt2regex/\fR
.SH OPTIONS

.TP
\fB\-\-all\fR
Select all the available programs. Be aware that the list of available
programs is long. You will need a terminal window with more than 40
lines for the user interface to fit. Also make sure that the \fB$LINES\fR
shell variable is exported, so \fBtxt2regex\fR can detect the current
number of available lines.

.TP
\fB\-h\fR, \fB\-\-help\fR
Print the help message and quit.

.TP
\fB\-\-history <value>\fR
Print a regex from the given history data. The history value is shown in
the last screen of the wizard, when you quit.

.TP
\fB\-\-make <label>\fR
Print a ready regex for the specified label. Inform an empty label to
see the list of available labels.

.TP
\fB\-\-nocolor\fR
Do not use colors.

.TP
\fB\-\-prog <program1,program2,...>\fR
Specify which programs to use, separated by commas. Use \fB\-\-showmeta\fR
to see the complete list of available programs.

.TP
\fB\-\-showinfo <program>\fR
Print regex\-related info about the specified program. Use \fB\-\-nocolor\fR
to have a text\-only output (no control characters).

.TP
\fB\-\-showmeta\fR
Print a metacharacters table featuring all the programs.

.TP
\fB\-V\fR, \fB\-\-version\fR
Print the program version and quit.

.TP
\fB\-\-whitebg\fR
Adjust colors for white background terminals.

.SH EXAMPLES

.TP
Using it as a wizard (interactive interface):


.nf
txt2regex
.fi



.TP
Specify a custom selection of programs for the wizard:


.nf
txt2regex --prog perl,python,php,javascript
.fi



.TP
Getting an extensive metacharacters table:


.nf
txt2regex --showmeta
.fi



.TP
Getting regex\-related information about sed:


.nf
txt2regex --showinfo sed
.fi



.TP
Replay a regex by using history data:


.nf
txt2regex --history '16421¤:01¤:'
.fi



.TP
Getting handy ready\-to\-use regexes for common patterns:


.nf
txt2regex --make hour
txt2regex --make number3 --prog perl
txt2regex --make date2 --all
.fi



.SH WIZARD INTERFACE

.nf
+---------------------------------------+
| Top menu                              |
| Group menu                            |
|                                       |
| Regexes of the selected programs      |
| ...                                   |
| ...                                   |
|                                       |
| History                               |
| Prompt                                |
|                                       |
| The question                          |
| The answers                           |
| ...                                   |
| ...                                   |
+---------------------------------------+
.fi


.SH WIZARD COMMANDS

.TS
tab(^); cl.
 \fB.\fR^Quit the program (with confirmation)
 \fB0\fR^Reset the regular expression
 \fB1\-9\fR^Answers the questions
 \fB*\fR^Toggles color ON/OFF
 \fB/\fR^Add/remove programs
 \fB|\fR^Insert an alternation (where allowed)
 \fB(\fR^Open a new group (where allowed)
 \fB)\fR^Close the opened group (if any)
.TE

.SH BUGS
.P
https://github.com/aureliojargas/txt2regex/issues
.SH AUTHOR
.P
Aurelio Jargas <verde@aurelio.net>
.SH COPYRIGHT
.P
Copyright © 2001\-2020 Aurelio Jargas, GNU GPL v2

.\" man code generated by txt2tags 3.4 (http://txt2tags.org)
.\" cmdline: txt2tags -t man man/txt2regex.t2t
