// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See layer_chassis_generator.py for modifications

/***************************************************************************
 *
 * Copyright (c) 2015-2024 The Khronos Group Inc.
 * Copyright (c) 2015-2024 Valve Corporation
 * Copyright (c) 2015-2024 LunarG, Inc.
 * Copyright (c) 2015-2024 Google Inc.
 * Copyright (c) 2023-2024 RasterGrid Kft.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/

// NOLINTBEGIN

#pragma once

// This source code creates dispatch vectors for each chassis api intercept,
// i.e., PreCallValidateFoo, PreCallRecordFoo, PostCallRecordFoo, etc., ensuring that
// each vector contains only the validation objects that override that particular base
// class virtual function. Preventing non-overridden calls from reaching the default
// functions saved about 5% in multithreaded applications.

typedef enum InterceptId {
    InterceptIdPreCallValidateGetDeviceQueue,
    InterceptIdPreCallRecordGetDeviceQueue,
    InterceptIdPostCallRecordGetDeviceQueue,
    InterceptIdPreCallValidateQueueSubmit,
    InterceptIdPreCallRecordQueueSubmit,
    InterceptIdPostCallRecordQueueSubmit,
    InterceptIdPreCallValidateQueueWaitIdle,
    InterceptIdPreCallRecordQueueWaitIdle,
    InterceptIdPostCallRecordQueueWaitIdle,
    InterceptIdPreCallValidateDeviceWaitIdle,
    InterceptIdPreCallRecordDeviceWaitIdle,
    InterceptIdPostCallRecordDeviceWaitIdle,
    InterceptIdPreCallValidateAllocateMemory,
    InterceptIdPreCallRecordAllocateMemory,
    InterceptIdPostCallRecordAllocateMemory,
    InterceptIdPreCallValidateFreeMemory,
    InterceptIdPreCallRecordFreeMemory,
    InterceptIdPostCallRecordFreeMemory,
    InterceptIdPreCallValidateMapMemory,
    InterceptIdPreCallRecordMapMemory,
    InterceptIdPostCallRecordMapMemory,
    InterceptIdPreCallValidateUnmapMemory,
    InterceptIdPreCallRecordUnmapMemory,
    InterceptIdPostCallRecordUnmapMemory,
    InterceptIdPreCallValidateFlushMappedMemoryRanges,
    InterceptIdPreCallRecordFlushMappedMemoryRanges,
    InterceptIdPostCallRecordFlushMappedMemoryRanges,
    InterceptIdPreCallValidateInvalidateMappedMemoryRanges,
    InterceptIdPreCallRecordInvalidateMappedMemoryRanges,
    InterceptIdPostCallRecordInvalidateMappedMemoryRanges,
    InterceptIdPreCallValidateGetDeviceMemoryCommitment,
    InterceptIdPreCallRecordGetDeviceMemoryCommitment,
    InterceptIdPostCallRecordGetDeviceMemoryCommitment,
    InterceptIdPreCallValidateBindBufferMemory,
    InterceptIdPreCallRecordBindBufferMemory,
    InterceptIdPostCallRecordBindBufferMemory,
    InterceptIdPreCallValidateBindImageMemory,
    InterceptIdPreCallRecordBindImageMemory,
    InterceptIdPostCallRecordBindImageMemory,
    InterceptIdPreCallValidateGetBufferMemoryRequirements,
    InterceptIdPreCallRecordGetBufferMemoryRequirements,
    InterceptIdPostCallRecordGetBufferMemoryRequirements,
    InterceptIdPreCallValidateGetImageMemoryRequirements,
    InterceptIdPreCallRecordGetImageMemoryRequirements,
    InterceptIdPostCallRecordGetImageMemoryRequirements,
    InterceptIdPreCallValidateGetImageSparseMemoryRequirements,
    InterceptIdPreCallRecordGetImageSparseMemoryRequirements,
    InterceptIdPostCallRecordGetImageSparseMemoryRequirements,
    InterceptIdPreCallValidateQueueBindSparse,
    InterceptIdPreCallRecordQueueBindSparse,
    InterceptIdPostCallRecordQueueBindSparse,
    InterceptIdPreCallValidateCreateFence,
    InterceptIdPreCallRecordCreateFence,
    InterceptIdPostCallRecordCreateFence,
    InterceptIdPreCallValidateDestroyFence,
    InterceptIdPreCallRecordDestroyFence,
    InterceptIdPostCallRecordDestroyFence,
    InterceptIdPreCallValidateResetFences,
    InterceptIdPreCallRecordResetFences,
    InterceptIdPostCallRecordResetFences,
    InterceptIdPreCallValidateGetFenceStatus,
    InterceptIdPreCallRecordGetFenceStatus,
    InterceptIdPostCallRecordGetFenceStatus,
    InterceptIdPreCallValidateWaitForFences,
    InterceptIdPreCallRecordWaitForFences,
    InterceptIdPostCallRecordWaitForFences,
    InterceptIdPreCallValidateCreateSemaphore,
    InterceptIdPreCallRecordCreateSemaphore,
    InterceptIdPostCallRecordCreateSemaphore,
    InterceptIdPreCallValidateDestroySemaphore,
    InterceptIdPreCallRecordDestroySemaphore,
    InterceptIdPostCallRecordDestroySemaphore,
    InterceptIdPreCallValidateCreateEvent,
    InterceptIdPreCallRecordCreateEvent,
    InterceptIdPostCallRecordCreateEvent,
    InterceptIdPreCallValidateDestroyEvent,
    InterceptIdPreCallRecordDestroyEvent,
    InterceptIdPostCallRecordDestroyEvent,
    InterceptIdPreCallValidateGetEventStatus,
    InterceptIdPreCallRecordGetEventStatus,
    InterceptIdPostCallRecordGetEventStatus,
    InterceptIdPreCallValidateSetEvent,
    InterceptIdPreCallRecordSetEvent,
    InterceptIdPostCallRecordSetEvent,
    InterceptIdPreCallValidateResetEvent,
    InterceptIdPreCallRecordResetEvent,
    InterceptIdPostCallRecordResetEvent,
    InterceptIdPreCallValidateCreateQueryPool,
    InterceptIdPreCallRecordCreateQueryPool,
    InterceptIdPostCallRecordCreateQueryPool,
    InterceptIdPreCallValidateDestroyQueryPool,
    InterceptIdPreCallRecordDestroyQueryPool,
    InterceptIdPostCallRecordDestroyQueryPool,
    InterceptIdPreCallValidateGetQueryPoolResults,
    InterceptIdPreCallRecordGetQueryPoolResults,
    InterceptIdPostCallRecordGetQueryPoolResults,
    InterceptIdPreCallValidateCreateBuffer,
    InterceptIdPostCallRecordCreateBuffer,
    InterceptIdPreCallValidateDestroyBuffer,
    InterceptIdPreCallRecordDestroyBuffer,
    InterceptIdPostCallRecordDestroyBuffer,
    InterceptIdPreCallValidateCreateBufferView,
    InterceptIdPreCallRecordCreateBufferView,
    InterceptIdPostCallRecordCreateBufferView,
    InterceptIdPreCallValidateDestroyBufferView,
    InterceptIdPreCallRecordDestroyBufferView,
    InterceptIdPostCallRecordDestroyBufferView,
    InterceptIdPreCallValidateCreateImage,
    InterceptIdPreCallRecordCreateImage,
    InterceptIdPostCallRecordCreateImage,
    InterceptIdPreCallValidateDestroyImage,
    InterceptIdPreCallRecordDestroyImage,
    InterceptIdPostCallRecordDestroyImage,
    InterceptIdPreCallValidateGetImageSubresourceLayout,
    InterceptIdPreCallRecordGetImageSubresourceLayout,
    InterceptIdPostCallRecordGetImageSubresourceLayout,
    InterceptIdPreCallValidateCreateImageView,
    InterceptIdPreCallRecordCreateImageView,
    InterceptIdPostCallRecordCreateImageView,
    InterceptIdPreCallValidateDestroyImageView,
    InterceptIdPreCallRecordDestroyImageView,
    InterceptIdPostCallRecordDestroyImageView,
    InterceptIdPreCallValidateDestroyShaderModule,
    InterceptIdPreCallRecordDestroyShaderModule,
    InterceptIdPostCallRecordDestroyShaderModule,
    InterceptIdPreCallValidateCreatePipelineCache,
    InterceptIdPreCallRecordCreatePipelineCache,
    InterceptIdPostCallRecordCreatePipelineCache,
    InterceptIdPreCallValidateDestroyPipelineCache,
    InterceptIdPreCallRecordDestroyPipelineCache,
    InterceptIdPostCallRecordDestroyPipelineCache,
    InterceptIdPreCallValidateGetPipelineCacheData,
    InterceptIdPreCallRecordGetPipelineCacheData,
    InterceptIdPostCallRecordGetPipelineCacheData,
    InterceptIdPreCallValidateMergePipelineCaches,
    InterceptIdPreCallRecordMergePipelineCaches,
    InterceptIdPostCallRecordMergePipelineCaches,
    InterceptIdPreCallValidateDestroyPipeline,
    InterceptIdPreCallRecordDestroyPipeline,
    InterceptIdPostCallRecordDestroyPipeline,
    InterceptIdPreCallValidateCreatePipelineLayout,
    InterceptIdPostCallRecordCreatePipelineLayout,
    InterceptIdPreCallValidateDestroyPipelineLayout,
    InterceptIdPreCallRecordDestroyPipelineLayout,
    InterceptIdPostCallRecordDestroyPipelineLayout,
    InterceptIdPreCallValidateCreateSampler,
    InterceptIdPreCallRecordCreateSampler,
    InterceptIdPostCallRecordCreateSampler,
    InterceptIdPreCallValidateDestroySampler,
    InterceptIdPreCallRecordDestroySampler,
    InterceptIdPostCallRecordDestroySampler,
    InterceptIdPreCallValidateCreateDescriptorSetLayout,
    InterceptIdPreCallRecordCreateDescriptorSetLayout,
    InterceptIdPostCallRecordCreateDescriptorSetLayout,
    InterceptIdPreCallValidateDestroyDescriptorSetLayout,
    InterceptIdPreCallRecordDestroyDescriptorSetLayout,
    InterceptIdPostCallRecordDestroyDescriptorSetLayout,
    InterceptIdPreCallValidateCreateDescriptorPool,
    InterceptIdPreCallRecordCreateDescriptorPool,
    InterceptIdPostCallRecordCreateDescriptorPool,
    InterceptIdPreCallValidateDestroyDescriptorPool,
    InterceptIdPreCallRecordDestroyDescriptorPool,
    InterceptIdPostCallRecordDestroyDescriptorPool,
    InterceptIdPreCallValidateResetDescriptorPool,
    InterceptIdPreCallRecordResetDescriptorPool,
    InterceptIdPostCallRecordResetDescriptorPool,
    InterceptIdPreCallRecordAllocateDescriptorSets,
    InterceptIdPreCallValidateFreeDescriptorSets,
    InterceptIdPreCallRecordFreeDescriptorSets,
    InterceptIdPostCallRecordFreeDescriptorSets,
    InterceptIdPreCallValidateUpdateDescriptorSets,
    InterceptIdPreCallRecordUpdateDescriptorSets,
    InterceptIdPostCallRecordUpdateDescriptorSets,
    InterceptIdPreCallValidateCreateFramebuffer,
    InterceptIdPreCallRecordCreateFramebuffer,
    InterceptIdPostCallRecordCreateFramebuffer,
    InterceptIdPreCallValidateDestroyFramebuffer,
    InterceptIdPreCallRecordDestroyFramebuffer,
    InterceptIdPostCallRecordDestroyFramebuffer,
    InterceptIdPreCallValidateCreateRenderPass,
    InterceptIdPreCallRecordCreateRenderPass,
    InterceptIdPostCallRecordCreateRenderPass,
    InterceptIdPreCallValidateDestroyRenderPass,
    InterceptIdPreCallRecordDestroyRenderPass,
    InterceptIdPostCallRecordDestroyRenderPass,
    InterceptIdPreCallValidateGetRenderAreaGranularity,
    InterceptIdPreCallRecordGetRenderAreaGranularity,
    InterceptIdPostCallRecordGetRenderAreaGranularity,
    InterceptIdPreCallValidateCreateCommandPool,
    InterceptIdPreCallRecordCreateCommandPool,
    InterceptIdPostCallRecordCreateCommandPool,
    InterceptIdPreCallValidateDestroyCommandPool,
    InterceptIdPreCallRecordDestroyCommandPool,
    InterceptIdPostCallRecordDestroyCommandPool,
    InterceptIdPreCallValidateResetCommandPool,
    InterceptIdPreCallRecordResetCommandPool,
    InterceptIdPostCallRecordResetCommandPool,
    InterceptIdPreCallValidateAllocateCommandBuffers,
    InterceptIdPreCallRecordAllocateCommandBuffers,
    InterceptIdPostCallRecordAllocateCommandBuffers,
    InterceptIdPreCallValidateFreeCommandBuffers,
    InterceptIdPreCallRecordFreeCommandBuffers,
    InterceptIdPostCallRecordFreeCommandBuffers,
    InterceptIdPreCallValidateBeginCommandBuffer,
    InterceptIdPreCallRecordBeginCommandBuffer,
    InterceptIdPostCallRecordBeginCommandBuffer,
    InterceptIdPreCallValidateEndCommandBuffer,
    InterceptIdPreCallRecordEndCommandBuffer,
    InterceptIdPostCallRecordEndCommandBuffer,
    InterceptIdPreCallValidateResetCommandBuffer,
    InterceptIdPreCallRecordResetCommandBuffer,
    InterceptIdPostCallRecordResetCommandBuffer,
    InterceptIdPreCallValidateCmdBindPipeline,
    InterceptIdPreCallRecordCmdBindPipeline,
    InterceptIdPostCallRecordCmdBindPipeline,
    InterceptIdPreCallValidateCmdSetViewport,
    InterceptIdPreCallRecordCmdSetViewport,
    InterceptIdPostCallRecordCmdSetViewport,
    InterceptIdPreCallValidateCmdSetScissor,
    InterceptIdPreCallRecordCmdSetScissor,
    InterceptIdPostCallRecordCmdSetScissor,
    InterceptIdPreCallValidateCmdSetLineWidth,
    InterceptIdPreCallRecordCmdSetLineWidth,
    InterceptIdPostCallRecordCmdSetLineWidth,
    InterceptIdPreCallValidateCmdSetDepthBias,
    InterceptIdPreCallRecordCmdSetDepthBias,
    InterceptIdPostCallRecordCmdSetDepthBias,
    InterceptIdPreCallValidateCmdSetBlendConstants,
    InterceptIdPreCallRecordCmdSetBlendConstants,
    InterceptIdPostCallRecordCmdSetBlendConstants,
    InterceptIdPreCallValidateCmdSetDepthBounds,
    InterceptIdPreCallRecordCmdSetDepthBounds,
    InterceptIdPostCallRecordCmdSetDepthBounds,
    InterceptIdPreCallValidateCmdSetStencilCompareMask,
    InterceptIdPreCallRecordCmdSetStencilCompareMask,
    InterceptIdPostCallRecordCmdSetStencilCompareMask,
    InterceptIdPreCallValidateCmdSetStencilWriteMask,
    InterceptIdPreCallRecordCmdSetStencilWriteMask,
    InterceptIdPostCallRecordCmdSetStencilWriteMask,
    InterceptIdPreCallValidateCmdSetStencilReference,
    InterceptIdPreCallRecordCmdSetStencilReference,
    InterceptIdPostCallRecordCmdSetStencilReference,
    InterceptIdPreCallValidateCmdBindDescriptorSets,
    InterceptIdPreCallRecordCmdBindDescriptorSets,
    InterceptIdPostCallRecordCmdBindDescriptorSets,
    InterceptIdPreCallValidateCmdBindIndexBuffer,
    InterceptIdPreCallRecordCmdBindIndexBuffer,
    InterceptIdPostCallRecordCmdBindIndexBuffer,
    InterceptIdPreCallValidateCmdBindVertexBuffers,
    InterceptIdPreCallRecordCmdBindVertexBuffers,
    InterceptIdPostCallRecordCmdBindVertexBuffers,
    InterceptIdPreCallValidateCmdDraw,
    InterceptIdPreCallRecordCmdDraw,
    InterceptIdPostCallRecordCmdDraw,
    InterceptIdPreCallValidateCmdDrawIndexed,
    InterceptIdPreCallRecordCmdDrawIndexed,
    InterceptIdPostCallRecordCmdDrawIndexed,
    InterceptIdPreCallValidateCmdDrawIndirect,
    InterceptIdPreCallRecordCmdDrawIndirect,
    InterceptIdPostCallRecordCmdDrawIndirect,
    InterceptIdPreCallValidateCmdDrawIndexedIndirect,
    InterceptIdPreCallRecordCmdDrawIndexedIndirect,
    InterceptIdPostCallRecordCmdDrawIndexedIndirect,
    InterceptIdPreCallValidateCmdDispatch,
    InterceptIdPreCallRecordCmdDispatch,
    InterceptIdPostCallRecordCmdDispatch,
    InterceptIdPreCallValidateCmdDispatchIndirect,
    InterceptIdPreCallRecordCmdDispatchIndirect,
    InterceptIdPostCallRecordCmdDispatchIndirect,
    InterceptIdPreCallValidateCmdCopyBuffer,
    InterceptIdPreCallRecordCmdCopyBuffer,
    InterceptIdPostCallRecordCmdCopyBuffer,
    InterceptIdPreCallValidateCmdCopyImage,
    InterceptIdPreCallRecordCmdCopyImage,
    InterceptIdPostCallRecordCmdCopyImage,
    InterceptIdPreCallValidateCmdBlitImage,
    InterceptIdPreCallRecordCmdBlitImage,
    InterceptIdPostCallRecordCmdBlitImage,
    InterceptIdPreCallValidateCmdCopyBufferToImage,
    InterceptIdPreCallRecordCmdCopyBufferToImage,
    InterceptIdPostCallRecordCmdCopyBufferToImage,
    InterceptIdPreCallValidateCmdCopyImageToBuffer,
    InterceptIdPreCallRecordCmdCopyImageToBuffer,
    InterceptIdPostCallRecordCmdCopyImageToBuffer,
    InterceptIdPreCallValidateCmdUpdateBuffer,
    InterceptIdPreCallRecordCmdUpdateBuffer,
    InterceptIdPostCallRecordCmdUpdateBuffer,
    InterceptIdPreCallValidateCmdFillBuffer,
    InterceptIdPreCallRecordCmdFillBuffer,
    InterceptIdPostCallRecordCmdFillBuffer,
    InterceptIdPreCallValidateCmdClearColorImage,
    InterceptIdPreCallRecordCmdClearColorImage,
    InterceptIdPostCallRecordCmdClearColorImage,
    InterceptIdPreCallValidateCmdClearDepthStencilImage,
    InterceptIdPreCallRecordCmdClearDepthStencilImage,
    InterceptIdPostCallRecordCmdClearDepthStencilImage,
    InterceptIdPreCallValidateCmdClearAttachments,
    InterceptIdPreCallRecordCmdClearAttachments,
    InterceptIdPostCallRecordCmdClearAttachments,
    InterceptIdPreCallValidateCmdResolveImage,
    InterceptIdPreCallRecordCmdResolveImage,
    InterceptIdPostCallRecordCmdResolveImage,
    InterceptIdPreCallValidateCmdSetEvent,
    InterceptIdPreCallRecordCmdSetEvent,
    InterceptIdPostCallRecordCmdSetEvent,
    InterceptIdPreCallValidateCmdResetEvent,
    InterceptIdPreCallRecordCmdResetEvent,
    InterceptIdPostCallRecordCmdResetEvent,
    InterceptIdPreCallValidateCmdWaitEvents,
    InterceptIdPreCallRecordCmdWaitEvents,
    InterceptIdPostCallRecordCmdWaitEvents,
    InterceptIdPreCallValidateCmdPipelineBarrier,
    InterceptIdPreCallRecordCmdPipelineBarrier,
    InterceptIdPostCallRecordCmdPipelineBarrier,
    InterceptIdPreCallValidateCmdBeginQuery,
    InterceptIdPreCallRecordCmdBeginQuery,
    InterceptIdPostCallRecordCmdBeginQuery,
    InterceptIdPreCallValidateCmdEndQuery,
    InterceptIdPreCallRecordCmdEndQuery,
    InterceptIdPostCallRecordCmdEndQuery,
    InterceptIdPreCallValidateCmdResetQueryPool,
    InterceptIdPreCallRecordCmdResetQueryPool,
    InterceptIdPostCallRecordCmdResetQueryPool,
    InterceptIdPreCallValidateCmdWriteTimestamp,
    InterceptIdPreCallRecordCmdWriteTimestamp,
    InterceptIdPostCallRecordCmdWriteTimestamp,
    InterceptIdPreCallValidateCmdCopyQueryPoolResults,
    InterceptIdPreCallRecordCmdCopyQueryPoolResults,
    InterceptIdPostCallRecordCmdCopyQueryPoolResults,
    InterceptIdPreCallValidateCmdPushConstants,
    InterceptIdPreCallRecordCmdPushConstants,
    InterceptIdPostCallRecordCmdPushConstants,
    InterceptIdPreCallValidateCmdBeginRenderPass,
    InterceptIdPreCallRecordCmdBeginRenderPass,
    InterceptIdPostCallRecordCmdBeginRenderPass,
    InterceptIdPreCallValidateCmdNextSubpass,
    InterceptIdPreCallRecordCmdNextSubpass,
    InterceptIdPostCallRecordCmdNextSubpass,
    InterceptIdPreCallValidateCmdEndRenderPass,
    InterceptIdPreCallRecordCmdEndRenderPass,
    InterceptIdPostCallRecordCmdEndRenderPass,
    InterceptIdPreCallValidateCmdExecuteCommands,
    InterceptIdPreCallRecordCmdExecuteCommands,
    InterceptIdPostCallRecordCmdExecuteCommands,
    InterceptIdPreCallValidateBindBufferMemory2,
    InterceptIdPreCallRecordBindBufferMemory2,
    InterceptIdPostCallRecordBindBufferMemory2,
    InterceptIdPreCallValidateBindImageMemory2,
    InterceptIdPreCallRecordBindImageMemory2,
    InterceptIdPostCallRecordBindImageMemory2,
    InterceptIdPreCallValidateGetDeviceGroupPeerMemoryFeatures,
    InterceptIdPreCallRecordGetDeviceGroupPeerMemoryFeatures,
    InterceptIdPostCallRecordGetDeviceGroupPeerMemoryFeatures,
    InterceptIdPreCallValidateCmdSetDeviceMask,
    InterceptIdPreCallRecordCmdSetDeviceMask,
    InterceptIdPostCallRecordCmdSetDeviceMask,
    InterceptIdPreCallValidateCmdDispatchBase,
    InterceptIdPreCallRecordCmdDispatchBase,
    InterceptIdPostCallRecordCmdDispatchBase,
    InterceptIdPreCallValidateGetImageMemoryRequirements2,
    InterceptIdPreCallRecordGetImageMemoryRequirements2,
    InterceptIdPostCallRecordGetImageMemoryRequirements2,
    InterceptIdPreCallValidateGetBufferMemoryRequirements2,
    InterceptIdPreCallRecordGetBufferMemoryRequirements2,
    InterceptIdPostCallRecordGetBufferMemoryRequirements2,
    InterceptIdPreCallValidateGetImageSparseMemoryRequirements2,
    InterceptIdPreCallRecordGetImageSparseMemoryRequirements2,
    InterceptIdPostCallRecordGetImageSparseMemoryRequirements2,
    InterceptIdPreCallValidateTrimCommandPool,
    InterceptIdPreCallRecordTrimCommandPool,
    InterceptIdPostCallRecordTrimCommandPool,
    InterceptIdPreCallValidateGetDeviceQueue2,
    InterceptIdPreCallRecordGetDeviceQueue2,
    InterceptIdPostCallRecordGetDeviceQueue2,
    InterceptIdPreCallValidateCreateSamplerYcbcrConversion,
    InterceptIdPreCallRecordCreateSamplerYcbcrConversion,
    InterceptIdPostCallRecordCreateSamplerYcbcrConversion,
    InterceptIdPreCallValidateDestroySamplerYcbcrConversion,
    InterceptIdPreCallRecordDestroySamplerYcbcrConversion,
    InterceptIdPostCallRecordDestroySamplerYcbcrConversion,
    InterceptIdPreCallValidateCreateDescriptorUpdateTemplate,
    InterceptIdPreCallRecordCreateDescriptorUpdateTemplate,
    InterceptIdPostCallRecordCreateDescriptorUpdateTemplate,
    InterceptIdPreCallValidateDestroyDescriptorUpdateTemplate,
    InterceptIdPreCallRecordDestroyDescriptorUpdateTemplate,
    InterceptIdPostCallRecordDestroyDescriptorUpdateTemplate,
    InterceptIdPreCallValidateUpdateDescriptorSetWithTemplate,
    InterceptIdPreCallRecordUpdateDescriptorSetWithTemplate,
    InterceptIdPostCallRecordUpdateDescriptorSetWithTemplate,
    InterceptIdPreCallValidateGetDescriptorSetLayoutSupport,
    InterceptIdPreCallRecordGetDescriptorSetLayoutSupport,
    InterceptIdPostCallRecordGetDescriptorSetLayoutSupport,
    InterceptIdPreCallValidateCmdDrawIndirectCount,
    InterceptIdPreCallRecordCmdDrawIndirectCount,
    InterceptIdPostCallRecordCmdDrawIndirectCount,
    InterceptIdPreCallValidateCmdDrawIndexedIndirectCount,
    InterceptIdPreCallRecordCmdDrawIndexedIndirectCount,
    InterceptIdPostCallRecordCmdDrawIndexedIndirectCount,
    InterceptIdPreCallValidateCreateRenderPass2,
    InterceptIdPreCallRecordCreateRenderPass2,
    InterceptIdPostCallRecordCreateRenderPass2,
    InterceptIdPreCallValidateCmdBeginRenderPass2,
    InterceptIdPreCallRecordCmdBeginRenderPass2,
    InterceptIdPostCallRecordCmdBeginRenderPass2,
    InterceptIdPreCallValidateCmdNextSubpass2,
    InterceptIdPreCallRecordCmdNextSubpass2,
    InterceptIdPostCallRecordCmdNextSubpass2,
    InterceptIdPreCallValidateCmdEndRenderPass2,
    InterceptIdPreCallRecordCmdEndRenderPass2,
    InterceptIdPostCallRecordCmdEndRenderPass2,
    InterceptIdPreCallValidateResetQueryPool,
    InterceptIdPreCallRecordResetQueryPool,
    InterceptIdPostCallRecordResetQueryPool,
    InterceptIdPreCallValidateGetSemaphoreCounterValue,
    InterceptIdPreCallRecordGetSemaphoreCounterValue,
    InterceptIdPostCallRecordGetSemaphoreCounterValue,
    InterceptIdPreCallValidateWaitSemaphores,
    InterceptIdPreCallRecordWaitSemaphores,
    InterceptIdPostCallRecordWaitSemaphores,
    InterceptIdPreCallValidateSignalSemaphore,
    InterceptIdPreCallRecordSignalSemaphore,
    InterceptIdPostCallRecordSignalSemaphore,
    InterceptIdPreCallValidateGetBufferDeviceAddress,
    InterceptIdPreCallRecordGetBufferDeviceAddress,
    InterceptIdPostCallRecordGetBufferDeviceAddress,
    InterceptIdPreCallValidateGetBufferOpaqueCaptureAddress,
    InterceptIdPreCallRecordGetBufferOpaqueCaptureAddress,
    InterceptIdPostCallRecordGetBufferOpaqueCaptureAddress,
    InterceptIdPreCallValidateGetDeviceMemoryOpaqueCaptureAddress,
    InterceptIdPreCallRecordGetDeviceMemoryOpaqueCaptureAddress,
    InterceptIdPostCallRecordGetDeviceMemoryOpaqueCaptureAddress,
    InterceptIdPreCallValidateCreatePrivateDataSlot,
    InterceptIdPreCallRecordCreatePrivateDataSlot,
    InterceptIdPostCallRecordCreatePrivateDataSlot,
    InterceptIdPreCallValidateDestroyPrivateDataSlot,
    InterceptIdPreCallRecordDestroyPrivateDataSlot,
    InterceptIdPostCallRecordDestroyPrivateDataSlot,
    InterceptIdPreCallValidateSetPrivateData,
    InterceptIdPreCallRecordSetPrivateData,
    InterceptIdPostCallRecordSetPrivateData,
    InterceptIdPreCallValidateGetPrivateData,
    InterceptIdPreCallRecordGetPrivateData,
    InterceptIdPostCallRecordGetPrivateData,
    InterceptIdPreCallValidateCmdSetEvent2,
    InterceptIdPreCallRecordCmdSetEvent2,
    InterceptIdPostCallRecordCmdSetEvent2,
    InterceptIdPreCallValidateCmdResetEvent2,
    InterceptIdPreCallRecordCmdResetEvent2,
    InterceptIdPostCallRecordCmdResetEvent2,
    InterceptIdPreCallValidateCmdWaitEvents2,
    InterceptIdPreCallRecordCmdWaitEvents2,
    InterceptIdPostCallRecordCmdWaitEvents2,
    InterceptIdPreCallValidateCmdPipelineBarrier2,
    InterceptIdPreCallRecordCmdPipelineBarrier2,
    InterceptIdPostCallRecordCmdPipelineBarrier2,
    InterceptIdPreCallValidateCmdWriteTimestamp2,
    InterceptIdPreCallRecordCmdWriteTimestamp2,
    InterceptIdPostCallRecordCmdWriteTimestamp2,
    InterceptIdPreCallValidateQueueSubmit2,
    InterceptIdPreCallRecordQueueSubmit2,
    InterceptIdPostCallRecordQueueSubmit2,
    InterceptIdPreCallValidateCmdCopyBuffer2,
    InterceptIdPreCallRecordCmdCopyBuffer2,
    InterceptIdPostCallRecordCmdCopyBuffer2,
    InterceptIdPreCallValidateCmdCopyImage2,
    InterceptIdPreCallRecordCmdCopyImage2,
    InterceptIdPostCallRecordCmdCopyImage2,
    InterceptIdPreCallValidateCmdCopyBufferToImage2,
    InterceptIdPreCallRecordCmdCopyBufferToImage2,
    InterceptIdPostCallRecordCmdCopyBufferToImage2,
    InterceptIdPreCallValidateCmdCopyImageToBuffer2,
    InterceptIdPreCallRecordCmdCopyImageToBuffer2,
    InterceptIdPostCallRecordCmdCopyImageToBuffer2,
    InterceptIdPreCallValidateCmdBlitImage2,
    InterceptIdPreCallRecordCmdBlitImage2,
    InterceptIdPostCallRecordCmdBlitImage2,
    InterceptIdPreCallValidateCmdResolveImage2,
    InterceptIdPreCallRecordCmdResolveImage2,
    InterceptIdPostCallRecordCmdResolveImage2,
    InterceptIdPreCallValidateCmdBeginRendering,
    InterceptIdPreCallRecordCmdBeginRendering,
    InterceptIdPostCallRecordCmdBeginRendering,
    InterceptIdPreCallValidateCmdEndRendering,
    InterceptIdPreCallRecordCmdEndRendering,
    InterceptIdPostCallRecordCmdEndRendering,
    InterceptIdPreCallValidateCmdSetCullMode,
    InterceptIdPreCallRecordCmdSetCullMode,
    InterceptIdPostCallRecordCmdSetCullMode,
    InterceptIdPreCallValidateCmdSetFrontFace,
    InterceptIdPreCallRecordCmdSetFrontFace,
    InterceptIdPostCallRecordCmdSetFrontFace,
    InterceptIdPreCallValidateCmdSetPrimitiveTopology,
    InterceptIdPreCallRecordCmdSetPrimitiveTopology,
    InterceptIdPostCallRecordCmdSetPrimitiveTopology,
    InterceptIdPreCallValidateCmdSetViewportWithCount,
    InterceptIdPreCallRecordCmdSetViewportWithCount,
    InterceptIdPostCallRecordCmdSetViewportWithCount,
    InterceptIdPreCallValidateCmdSetScissorWithCount,
    InterceptIdPreCallRecordCmdSetScissorWithCount,
    InterceptIdPostCallRecordCmdSetScissorWithCount,
    InterceptIdPreCallValidateCmdBindVertexBuffers2,
    InterceptIdPreCallRecordCmdBindVertexBuffers2,
    InterceptIdPostCallRecordCmdBindVertexBuffers2,
    InterceptIdPreCallValidateCmdSetDepthTestEnable,
    InterceptIdPreCallRecordCmdSetDepthTestEnable,
    InterceptIdPostCallRecordCmdSetDepthTestEnable,
    InterceptIdPreCallValidateCmdSetDepthWriteEnable,
    InterceptIdPreCallRecordCmdSetDepthWriteEnable,
    InterceptIdPostCallRecordCmdSetDepthWriteEnable,
    InterceptIdPreCallValidateCmdSetDepthCompareOp,
    InterceptIdPreCallRecordCmdSetDepthCompareOp,
    InterceptIdPostCallRecordCmdSetDepthCompareOp,
    InterceptIdPreCallValidateCmdSetDepthBoundsTestEnable,
    InterceptIdPreCallRecordCmdSetDepthBoundsTestEnable,
    InterceptIdPostCallRecordCmdSetDepthBoundsTestEnable,
    InterceptIdPreCallValidateCmdSetStencilTestEnable,
    InterceptIdPreCallRecordCmdSetStencilTestEnable,
    InterceptIdPostCallRecordCmdSetStencilTestEnable,
    InterceptIdPreCallValidateCmdSetStencilOp,
    InterceptIdPreCallRecordCmdSetStencilOp,
    InterceptIdPostCallRecordCmdSetStencilOp,
    InterceptIdPreCallValidateCmdSetRasterizerDiscardEnable,
    InterceptIdPreCallRecordCmdSetRasterizerDiscardEnable,
    InterceptIdPostCallRecordCmdSetRasterizerDiscardEnable,
    InterceptIdPreCallValidateCmdSetDepthBiasEnable,
    InterceptIdPreCallRecordCmdSetDepthBiasEnable,
    InterceptIdPostCallRecordCmdSetDepthBiasEnable,
    InterceptIdPreCallValidateCmdSetPrimitiveRestartEnable,
    InterceptIdPreCallRecordCmdSetPrimitiveRestartEnable,
    InterceptIdPostCallRecordCmdSetPrimitiveRestartEnable,
    InterceptIdPreCallValidateGetDeviceBufferMemoryRequirements,
    InterceptIdPreCallRecordGetDeviceBufferMemoryRequirements,
    InterceptIdPostCallRecordGetDeviceBufferMemoryRequirements,
    InterceptIdPreCallValidateGetDeviceImageMemoryRequirements,
    InterceptIdPreCallRecordGetDeviceImageMemoryRequirements,
    InterceptIdPostCallRecordGetDeviceImageMemoryRequirements,
    InterceptIdPreCallValidateGetDeviceImageSparseMemoryRequirements,
    InterceptIdPreCallRecordGetDeviceImageSparseMemoryRequirements,
    InterceptIdPostCallRecordGetDeviceImageSparseMemoryRequirements,
    InterceptIdPreCallValidateCreateSwapchainKHR,
    InterceptIdPreCallRecordCreateSwapchainKHR,
    InterceptIdPostCallRecordCreateSwapchainKHR,
    InterceptIdPreCallValidateDestroySwapchainKHR,
    InterceptIdPreCallRecordDestroySwapchainKHR,
    InterceptIdPostCallRecordDestroySwapchainKHR,
    InterceptIdPreCallValidateGetSwapchainImagesKHR,
    InterceptIdPreCallRecordGetSwapchainImagesKHR,
    InterceptIdPostCallRecordGetSwapchainImagesKHR,
    InterceptIdPreCallValidateAcquireNextImageKHR,
    InterceptIdPreCallRecordAcquireNextImageKHR,
    InterceptIdPostCallRecordAcquireNextImageKHR,
    InterceptIdPreCallValidateQueuePresentKHR,
    InterceptIdPreCallRecordQueuePresentKHR,
    InterceptIdPostCallRecordQueuePresentKHR,
    InterceptIdPreCallValidateGetDeviceGroupPresentCapabilitiesKHR,
    InterceptIdPreCallRecordGetDeviceGroupPresentCapabilitiesKHR,
    InterceptIdPostCallRecordGetDeviceGroupPresentCapabilitiesKHR,
    InterceptIdPreCallValidateGetDeviceGroupSurfacePresentModesKHR,
    InterceptIdPreCallRecordGetDeviceGroupSurfacePresentModesKHR,
    InterceptIdPostCallRecordGetDeviceGroupSurfacePresentModesKHR,
    InterceptIdPreCallValidateAcquireNextImage2KHR,
    InterceptIdPreCallRecordAcquireNextImage2KHR,
    InterceptIdPostCallRecordAcquireNextImage2KHR,
    InterceptIdPreCallValidateCreateSharedSwapchainsKHR,
    InterceptIdPreCallRecordCreateSharedSwapchainsKHR,
    InterceptIdPostCallRecordCreateSharedSwapchainsKHR,
    InterceptIdPreCallValidateCreateVideoSessionKHR,
    InterceptIdPreCallRecordCreateVideoSessionKHR,
    InterceptIdPostCallRecordCreateVideoSessionKHR,
    InterceptIdPreCallValidateDestroyVideoSessionKHR,
    InterceptIdPreCallRecordDestroyVideoSessionKHR,
    InterceptIdPostCallRecordDestroyVideoSessionKHR,
    InterceptIdPreCallValidateGetVideoSessionMemoryRequirementsKHR,
    InterceptIdPreCallRecordGetVideoSessionMemoryRequirementsKHR,
    InterceptIdPostCallRecordGetVideoSessionMemoryRequirementsKHR,
    InterceptIdPreCallValidateBindVideoSessionMemoryKHR,
    InterceptIdPreCallRecordBindVideoSessionMemoryKHR,
    InterceptIdPostCallRecordBindVideoSessionMemoryKHR,
    InterceptIdPreCallValidateCreateVideoSessionParametersKHR,
    InterceptIdPreCallRecordCreateVideoSessionParametersKHR,
    InterceptIdPostCallRecordCreateVideoSessionParametersKHR,
    InterceptIdPreCallValidateUpdateVideoSessionParametersKHR,
    InterceptIdPreCallRecordUpdateVideoSessionParametersKHR,
    InterceptIdPostCallRecordUpdateVideoSessionParametersKHR,
    InterceptIdPreCallValidateDestroyVideoSessionParametersKHR,
    InterceptIdPreCallRecordDestroyVideoSessionParametersKHR,
    InterceptIdPostCallRecordDestroyVideoSessionParametersKHR,
    InterceptIdPreCallValidateCmdBeginVideoCodingKHR,
    InterceptIdPreCallRecordCmdBeginVideoCodingKHR,
    InterceptIdPostCallRecordCmdBeginVideoCodingKHR,
    InterceptIdPreCallValidateCmdEndVideoCodingKHR,
    InterceptIdPreCallRecordCmdEndVideoCodingKHR,
    InterceptIdPostCallRecordCmdEndVideoCodingKHR,
    InterceptIdPreCallValidateCmdControlVideoCodingKHR,
    InterceptIdPreCallRecordCmdControlVideoCodingKHR,
    InterceptIdPostCallRecordCmdControlVideoCodingKHR,
    InterceptIdPreCallValidateCmdDecodeVideoKHR,
    InterceptIdPreCallRecordCmdDecodeVideoKHR,
    InterceptIdPostCallRecordCmdDecodeVideoKHR,
    InterceptIdPreCallValidateCmdBeginRenderingKHR,
    InterceptIdPreCallRecordCmdBeginRenderingKHR,
    InterceptIdPostCallRecordCmdBeginRenderingKHR,
    InterceptIdPreCallValidateCmdEndRenderingKHR,
    InterceptIdPreCallRecordCmdEndRenderingKHR,
    InterceptIdPostCallRecordCmdEndRenderingKHR,
    InterceptIdPreCallValidateGetDeviceGroupPeerMemoryFeaturesKHR,
    InterceptIdPreCallRecordGetDeviceGroupPeerMemoryFeaturesKHR,
    InterceptIdPostCallRecordGetDeviceGroupPeerMemoryFeaturesKHR,
    InterceptIdPreCallValidateCmdSetDeviceMaskKHR,
    InterceptIdPreCallRecordCmdSetDeviceMaskKHR,
    InterceptIdPostCallRecordCmdSetDeviceMaskKHR,
    InterceptIdPreCallValidateCmdDispatchBaseKHR,
    InterceptIdPreCallRecordCmdDispatchBaseKHR,
    InterceptIdPostCallRecordCmdDispatchBaseKHR,
    InterceptIdPreCallValidateTrimCommandPoolKHR,
    InterceptIdPreCallRecordTrimCommandPoolKHR,
    InterceptIdPostCallRecordTrimCommandPoolKHR,
    InterceptIdPreCallValidateGetMemoryWin32HandleKHR,
    InterceptIdPreCallRecordGetMemoryWin32HandleKHR,
    InterceptIdPostCallRecordGetMemoryWin32HandleKHR,
    InterceptIdPreCallValidateGetMemoryWin32HandlePropertiesKHR,
    InterceptIdPreCallRecordGetMemoryWin32HandlePropertiesKHR,
    InterceptIdPostCallRecordGetMemoryWin32HandlePropertiesKHR,
    InterceptIdPreCallValidateGetMemoryFdKHR,
    InterceptIdPreCallRecordGetMemoryFdKHR,
    InterceptIdPostCallRecordGetMemoryFdKHR,
    InterceptIdPreCallValidateGetMemoryFdPropertiesKHR,
    InterceptIdPreCallRecordGetMemoryFdPropertiesKHR,
    InterceptIdPostCallRecordGetMemoryFdPropertiesKHR,
    InterceptIdPreCallValidateImportSemaphoreWin32HandleKHR,
    InterceptIdPreCallRecordImportSemaphoreWin32HandleKHR,
    InterceptIdPostCallRecordImportSemaphoreWin32HandleKHR,
    InterceptIdPreCallValidateGetSemaphoreWin32HandleKHR,
    InterceptIdPreCallRecordGetSemaphoreWin32HandleKHR,
    InterceptIdPostCallRecordGetSemaphoreWin32HandleKHR,
    InterceptIdPreCallValidateImportSemaphoreFdKHR,
    InterceptIdPreCallRecordImportSemaphoreFdKHR,
    InterceptIdPostCallRecordImportSemaphoreFdKHR,
    InterceptIdPreCallValidateGetSemaphoreFdKHR,
    InterceptIdPreCallRecordGetSemaphoreFdKHR,
    InterceptIdPostCallRecordGetSemaphoreFdKHR,
    InterceptIdPreCallValidateCmdPushDescriptorSetKHR,
    InterceptIdPreCallRecordCmdPushDescriptorSetKHR,
    InterceptIdPostCallRecordCmdPushDescriptorSetKHR,
    InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplateKHR,
    InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplateKHR,
    InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplateKHR,
    InterceptIdPreCallValidateCreateDescriptorUpdateTemplateKHR,
    InterceptIdPreCallRecordCreateDescriptorUpdateTemplateKHR,
    InterceptIdPostCallRecordCreateDescriptorUpdateTemplateKHR,
    InterceptIdPreCallValidateDestroyDescriptorUpdateTemplateKHR,
    InterceptIdPreCallRecordDestroyDescriptorUpdateTemplateKHR,
    InterceptIdPostCallRecordDestroyDescriptorUpdateTemplateKHR,
    InterceptIdPreCallValidateUpdateDescriptorSetWithTemplateKHR,
    InterceptIdPreCallRecordUpdateDescriptorSetWithTemplateKHR,
    InterceptIdPostCallRecordUpdateDescriptorSetWithTemplateKHR,
    InterceptIdPreCallValidateCreateRenderPass2KHR,
    InterceptIdPreCallRecordCreateRenderPass2KHR,
    InterceptIdPostCallRecordCreateRenderPass2KHR,
    InterceptIdPreCallValidateCmdBeginRenderPass2KHR,
    InterceptIdPreCallRecordCmdBeginRenderPass2KHR,
    InterceptIdPostCallRecordCmdBeginRenderPass2KHR,
    InterceptIdPreCallValidateCmdNextSubpass2KHR,
    InterceptIdPreCallRecordCmdNextSubpass2KHR,
    InterceptIdPostCallRecordCmdNextSubpass2KHR,
    InterceptIdPreCallValidateCmdEndRenderPass2KHR,
    InterceptIdPreCallRecordCmdEndRenderPass2KHR,
    InterceptIdPostCallRecordCmdEndRenderPass2KHR,
    InterceptIdPreCallValidateGetSwapchainStatusKHR,
    InterceptIdPreCallRecordGetSwapchainStatusKHR,
    InterceptIdPostCallRecordGetSwapchainStatusKHR,
    InterceptIdPreCallValidateImportFenceWin32HandleKHR,
    InterceptIdPreCallRecordImportFenceWin32HandleKHR,
    InterceptIdPostCallRecordImportFenceWin32HandleKHR,
    InterceptIdPreCallValidateGetFenceWin32HandleKHR,
    InterceptIdPreCallRecordGetFenceWin32HandleKHR,
    InterceptIdPostCallRecordGetFenceWin32HandleKHR,
    InterceptIdPreCallValidateImportFenceFdKHR,
    InterceptIdPreCallRecordImportFenceFdKHR,
    InterceptIdPostCallRecordImportFenceFdKHR,
    InterceptIdPreCallValidateGetFenceFdKHR,
    InterceptIdPreCallRecordGetFenceFdKHR,
    InterceptIdPostCallRecordGetFenceFdKHR,
    InterceptIdPreCallValidateAcquireProfilingLockKHR,
    InterceptIdPreCallRecordAcquireProfilingLockKHR,
    InterceptIdPostCallRecordAcquireProfilingLockKHR,
    InterceptIdPreCallValidateReleaseProfilingLockKHR,
    InterceptIdPreCallRecordReleaseProfilingLockKHR,
    InterceptIdPostCallRecordReleaseProfilingLockKHR,
    InterceptIdPreCallValidateGetImageMemoryRequirements2KHR,
    InterceptIdPreCallRecordGetImageMemoryRequirements2KHR,
    InterceptIdPostCallRecordGetImageMemoryRequirements2KHR,
    InterceptIdPreCallValidateGetBufferMemoryRequirements2KHR,
    InterceptIdPreCallRecordGetBufferMemoryRequirements2KHR,
    InterceptIdPostCallRecordGetBufferMemoryRequirements2KHR,
    InterceptIdPreCallValidateGetImageSparseMemoryRequirements2KHR,
    InterceptIdPreCallRecordGetImageSparseMemoryRequirements2KHR,
    InterceptIdPostCallRecordGetImageSparseMemoryRequirements2KHR,
    InterceptIdPreCallValidateCreateSamplerYcbcrConversionKHR,
    InterceptIdPreCallRecordCreateSamplerYcbcrConversionKHR,
    InterceptIdPostCallRecordCreateSamplerYcbcrConversionKHR,
    InterceptIdPreCallValidateDestroySamplerYcbcrConversionKHR,
    InterceptIdPreCallRecordDestroySamplerYcbcrConversionKHR,
    InterceptIdPostCallRecordDestroySamplerYcbcrConversionKHR,
    InterceptIdPreCallValidateBindBufferMemory2KHR,
    InterceptIdPreCallRecordBindBufferMemory2KHR,
    InterceptIdPostCallRecordBindBufferMemory2KHR,
    InterceptIdPreCallValidateBindImageMemory2KHR,
    InterceptIdPreCallRecordBindImageMemory2KHR,
    InterceptIdPostCallRecordBindImageMemory2KHR,
    InterceptIdPreCallValidateGetDescriptorSetLayoutSupportKHR,
    InterceptIdPreCallRecordGetDescriptorSetLayoutSupportKHR,
    InterceptIdPostCallRecordGetDescriptorSetLayoutSupportKHR,
    InterceptIdPreCallValidateCmdDrawIndirectCountKHR,
    InterceptIdPreCallRecordCmdDrawIndirectCountKHR,
    InterceptIdPostCallRecordCmdDrawIndirectCountKHR,
    InterceptIdPreCallValidateCmdDrawIndexedIndirectCountKHR,
    InterceptIdPreCallRecordCmdDrawIndexedIndirectCountKHR,
    InterceptIdPostCallRecordCmdDrawIndexedIndirectCountKHR,
    InterceptIdPreCallValidateGetSemaphoreCounterValueKHR,
    InterceptIdPreCallRecordGetSemaphoreCounterValueKHR,
    InterceptIdPostCallRecordGetSemaphoreCounterValueKHR,
    InterceptIdPreCallValidateWaitSemaphoresKHR,
    InterceptIdPreCallRecordWaitSemaphoresKHR,
    InterceptIdPostCallRecordWaitSemaphoresKHR,
    InterceptIdPreCallValidateSignalSemaphoreKHR,
    InterceptIdPreCallRecordSignalSemaphoreKHR,
    InterceptIdPostCallRecordSignalSemaphoreKHR,
    InterceptIdPreCallValidateCmdSetFragmentShadingRateKHR,
    InterceptIdPreCallRecordCmdSetFragmentShadingRateKHR,
    InterceptIdPostCallRecordCmdSetFragmentShadingRateKHR,
    InterceptIdPreCallValidateCmdSetRenderingAttachmentLocationsKHR,
    InterceptIdPreCallRecordCmdSetRenderingAttachmentLocationsKHR,
    InterceptIdPostCallRecordCmdSetRenderingAttachmentLocationsKHR,
    InterceptIdPreCallValidateCmdSetRenderingInputAttachmentIndicesKHR,
    InterceptIdPreCallRecordCmdSetRenderingInputAttachmentIndicesKHR,
    InterceptIdPostCallRecordCmdSetRenderingInputAttachmentIndicesKHR,
    InterceptIdPreCallValidateWaitForPresentKHR,
    InterceptIdPreCallRecordWaitForPresentKHR,
    InterceptIdPostCallRecordWaitForPresentKHR,
    InterceptIdPreCallValidateGetBufferDeviceAddressKHR,
    InterceptIdPreCallRecordGetBufferDeviceAddressKHR,
    InterceptIdPostCallRecordGetBufferDeviceAddressKHR,
    InterceptIdPreCallValidateGetBufferOpaqueCaptureAddressKHR,
    InterceptIdPreCallRecordGetBufferOpaqueCaptureAddressKHR,
    InterceptIdPostCallRecordGetBufferOpaqueCaptureAddressKHR,
    InterceptIdPreCallValidateGetDeviceMemoryOpaqueCaptureAddressKHR,
    InterceptIdPreCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR,
    InterceptIdPostCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR,
    InterceptIdPreCallValidateCreateDeferredOperationKHR,
    InterceptIdPreCallRecordCreateDeferredOperationKHR,
    InterceptIdPostCallRecordCreateDeferredOperationKHR,
    InterceptIdPreCallValidateDestroyDeferredOperationKHR,
    InterceptIdPreCallRecordDestroyDeferredOperationKHR,
    InterceptIdPostCallRecordDestroyDeferredOperationKHR,
    InterceptIdPreCallValidateGetDeferredOperationMaxConcurrencyKHR,
    InterceptIdPreCallRecordGetDeferredOperationMaxConcurrencyKHR,
    InterceptIdPostCallRecordGetDeferredOperationMaxConcurrencyKHR,
    InterceptIdPreCallValidateGetDeferredOperationResultKHR,
    InterceptIdPreCallRecordGetDeferredOperationResultKHR,
    InterceptIdPostCallRecordGetDeferredOperationResultKHR,
    InterceptIdPreCallValidateDeferredOperationJoinKHR,
    InterceptIdPreCallRecordDeferredOperationJoinKHR,
    InterceptIdPostCallRecordDeferredOperationJoinKHR,
    InterceptIdPreCallValidateGetPipelineExecutablePropertiesKHR,
    InterceptIdPreCallRecordGetPipelineExecutablePropertiesKHR,
    InterceptIdPostCallRecordGetPipelineExecutablePropertiesKHR,
    InterceptIdPreCallValidateGetPipelineExecutableStatisticsKHR,
    InterceptIdPreCallRecordGetPipelineExecutableStatisticsKHR,
    InterceptIdPostCallRecordGetPipelineExecutableStatisticsKHR,
    InterceptIdPreCallValidateGetPipelineExecutableInternalRepresentationsKHR,
    InterceptIdPreCallRecordGetPipelineExecutableInternalRepresentationsKHR,
    InterceptIdPostCallRecordGetPipelineExecutableInternalRepresentationsKHR,
    InterceptIdPreCallValidateMapMemory2KHR,
    InterceptIdPreCallRecordMapMemory2KHR,
    InterceptIdPostCallRecordMapMemory2KHR,
    InterceptIdPreCallValidateUnmapMemory2KHR,
    InterceptIdPreCallRecordUnmapMemory2KHR,
    InterceptIdPostCallRecordUnmapMemory2KHR,
    InterceptIdPreCallValidateGetEncodedVideoSessionParametersKHR,
    InterceptIdPreCallRecordGetEncodedVideoSessionParametersKHR,
    InterceptIdPostCallRecordGetEncodedVideoSessionParametersKHR,
    InterceptIdPreCallValidateCmdEncodeVideoKHR,
    InterceptIdPreCallRecordCmdEncodeVideoKHR,
    InterceptIdPostCallRecordCmdEncodeVideoKHR,
    InterceptIdPreCallValidateCmdSetEvent2KHR,
    InterceptIdPreCallRecordCmdSetEvent2KHR,
    InterceptIdPostCallRecordCmdSetEvent2KHR,
    InterceptIdPreCallValidateCmdResetEvent2KHR,
    InterceptIdPreCallRecordCmdResetEvent2KHR,
    InterceptIdPostCallRecordCmdResetEvent2KHR,
    InterceptIdPreCallValidateCmdWaitEvents2KHR,
    InterceptIdPreCallRecordCmdWaitEvents2KHR,
    InterceptIdPostCallRecordCmdWaitEvents2KHR,
    InterceptIdPreCallValidateCmdPipelineBarrier2KHR,
    InterceptIdPreCallRecordCmdPipelineBarrier2KHR,
    InterceptIdPostCallRecordCmdPipelineBarrier2KHR,
    InterceptIdPreCallValidateCmdWriteTimestamp2KHR,
    InterceptIdPreCallRecordCmdWriteTimestamp2KHR,
    InterceptIdPostCallRecordCmdWriteTimestamp2KHR,
    InterceptIdPreCallValidateQueueSubmit2KHR,
    InterceptIdPreCallRecordQueueSubmit2KHR,
    InterceptIdPostCallRecordQueueSubmit2KHR,
    InterceptIdPreCallValidateCmdWriteBufferMarker2AMD,
    InterceptIdPreCallRecordCmdWriteBufferMarker2AMD,
    InterceptIdPostCallRecordCmdWriteBufferMarker2AMD,
    InterceptIdPreCallValidateGetQueueCheckpointData2NV,
    InterceptIdPreCallRecordGetQueueCheckpointData2NV,
    InterceptIdPostCallRecordGetQueueCheckpointData2NV,
    InterceptIdPreCallValidateCmdCopyBuffer2KHR,
    InterceptIdPreCallRecordCmdCopyBuffer2KHR,
    InterceptIdPostCallRecordCmdCopyBuffer2KHR,
    InterceptIdPreCallValidateCmdCopyImage2KHR,
    InterceptIdPreCallRecordCmdCopyImage2KHR,
    InterceptIdPostCallRecordCmdCopyImage2KHR,
    InterceptIdPreCallValidateCmdCopyBufferToImage2KHR,
    InterceptIdPreCallRecordCmdCopyBufferToImage2KHR,
    InterceptIdPostCallRecordCmdCopyBufferToImage2KHR,
    InterceptIdPreCallValidateCmdCopyImageToBuffer2KHR,
    InterceptIdPreCallRecordCmdCopyImageToBuffer2KHR,
    InterceptIdPostCallRecordCmdCopyImageToBuffer2KHR,
    InterceptIdPreCallValidateCmdBlitImage2KHR,
    InterceptIdPreCallRecordCmdBlitImage2KHR,
    InterceptIdPostCallRecordCmdBlitImage2KHR,
    InterceptIdPreCallValidateCmdResolveImage2KHR,
    InterceptIdPreCallRecordCmdResolveImage2KHR,
    InterceptIdPostCallRecordCmdResolveImage2KHR,
    InterceptIdPreCallValidateCmdTraceRaysIndirect2KHR,
    InterceptIdPreCallRecordCmdTraceRaysIndirect2KHR,
    InterceptIdPostCallRecordCmdTraceRaysIndirect2KHR,
    InterceptIdPreCallValidateGetDeviceBufferMemoryRequirementsKHR,
    InterceptIdPreCallRecordGetDeviceBufferMemoryRequirementsKHR,
    InterceptIdPostCallRecordGetDeviceBufferMemoryRequirementsKHR,
    InterceptIdPreCallValidateGetDeviceImageMemoryRequirementsKHR,
    InterceptIdPreCallRecordGetDeviceImageMemoryRequirementsKHR,
    InterceptIdPostCallRecordGetDeviceImageMemoryRequirementsKHR,
    InterceptIdPreCallValidateGetDeviceImageSparseMemoryRequirementsKHR,
    InterceptIdPreCallRecordGetDeviceImageSparseMemoryRequirementsKHR,
    InterceptIdPostCallRecordGetDeviceImageSparseMemoryRequirementsKHR,
    InterceptIdPreCallValidateCmdBindIndexBuffer2KHR,
    InterceptIdPreCallRecordCmdBindIndexBuffer2KHR,
    InterceptIdPostCallRecordCmdBindIndexBuffer2KHR,
    InterceptIdPreCallValidateGetRenderingAreaGranularityKHR,
    InterceptIdPreCallRecordGetRenderingAreaGranularityKHR,
    InterceptIdPostCallRecordGetRenderingAreaGranularityKHR,
    InterceptIdPreCallValidateGetDeviceImageSubresourceLayoutKHR,
    InterceptIdPreCallRecordGetDeviceImageSubresourceLayoutKHR,
    InterceptIdPostCallRecordGetDeviceImageSubresourceLayoutKHR,
    InterceptIdPreCallValidateGetImageSubresourceLayout2KHR,
    InterceptIdPreCallRecordGetImageSubresourceLayout2KHR,
    InterceptIdPostCallRecordGetImageSubresourceLayout2KHR,
    InterceptIdPreCallValidateCreatePipelineBinariesKHR,
    InterceptIdPreCallRecordCreatePipelineBinariesKHR,
    InterceptIdPostCallRecordCreatePipelineBinariesKHR,
    InterceptIdPreCallValidateDestroyPipelineBinaryKHR,
    InterceptIdPreCallRecordDestroyPipelineBinaryKHR,
    InterceptIdPostCallRecordDestroyPipelineBinaryKHR,
    InterceptIdPreCallValidateGetPipelineKeyKHR,
    InterceptIdPreCallRecordGetPipelineKeyKHR,
    InterceptIdPostCallRecordGetPipelineKeyKHR,
    InterceptIdPreCallValidateGetPipelineBinaryDataKHR,
    InterceptIdPreCallRecordGetPipelineBinaryDataKHR,
    InterceptIdPostCallRecordGetPipelineBinaryDataKHR,
    InterceptIdPreCallValidateReleaseCapturedPipelineDataKHR,
    InterceptIdPreCallRecordReleaseCapturedPipelineDataKHR,
    InterceptIdPostCallRecordReleaseCapturedPipelineDataKHR,
    InterceptIdPreCallValidateCmdSetLineStippleKHR,
    InterceptIdPreCallRecordCmdSetLineStippleKHR,
    InterceptIdPostCallRecordCmdSetLineStippleKHR,
    InterceptIdPreCallValidateGetCalibratedTimestampsKHR,
    InterceptIdPreCallRecordGetCalibratedTimestampsKHR,
    InterceptIdPostCallRecordGetCalibratedTimestampsKHR,
    InterceptIdPreCallValidateCmdBindDescriptorSets2KHR,
    InterceptIdPreCallRecordCmdBindDescriptorSets2KHR,
    InterceptIdPostCallRecordCmdBindDescriptorSets2KHR,
    InterceptIdPreCallValidateCmdPushConstants2KHR,
    InterceptIdPreCallRecordCmdPushConstants2KHR,
    InterceptIdPostCallRecordCmdPushConstants2KHR,
    InterceptIdPreCallValidateCmdPushDescriptorSet2KHR,
    InterceptIdPreCallRecordCmdPushDescriptorSet2KHR,
    InterceptIdPostCallRecordCmdPushDescriptorSet2KHR,
    InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplate2KHR,
    InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplate2KHR,
    InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplate2KHR,
    InterceptIdPreCallValidateCmdSetDescriptorBufferOffsets2EXT,
    InterceptIdPreCallRecordCmdSetDescriptorBufferOffsets2EXT,
    InterceptIdPostCallRecordCmdSetDescriptorBufferOffsets2EXT,
    InterceptIdPreCallValidateCmdBindDescriptorBufferEmbeddedSamplers2EXT,
    InterceptIdPreCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT,
    InterceptIdPostCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT,
    InterceptIdPreCallValidateDebugMarkerSetObjectTagEXT,
    InterceptIdPreCallRecordDebugMarkerSetObjectTagEXT,
    InterceptIdPostCallRecordDebugMarkerSetObjectTagEXT,
    InterceptIdPreCallValidateDebugMarkerSetObjectNameEXT,
    InterceptIdPreCallRecordDebugMarkerSetObjectNameEXT,
    InterceptIdPostCallRecordDebugMarkerSetObjectNameEXT,
    InterceptIdPreCallValidateCmdDebugMarkerBeginEXT,
    InterceptIdPreCallRecordCmdDebugMarkerBeginEXT,
    InterceptIdPostCallRecordCmdDebugMarkerBeginEXT,
    InterceptIdPreCallValidateCmdDebugMarkerEndEXT,
    InterceptIdPreCallRecordCmdDebugMarkerEndEXT,
    InterceptIdPostCallRecordCmdDebugMarkerEndEXT,
    InterceptIdPreCallValidateCmdDebugMarkerInsertEXT,
    InterceptIdPreCallRecordCmdDebugMarkerInsertEXT,
    InterceptIdPostCallRecordCmdDebugMarkerInsertEXT,
    InterceptIdPreCallValidateCmdBindTransformFeedbackBuffersEXT,
    InterceptIdPreCallRecordCmdBindTransformFeedbackBuffersEXT,
    InterceptIdPostCallRecordCmdBindTransformFeedbackBuffersEXT,
    InterceptIdPreCallValidateCmdBeginTransformFeedbackEXT,
    InterceptIdPreCallRecordCmdBeginTransformFeedbackEXT,
    InterceptIdPostCallRecordCmdBeginTransformFeedbackEXT,
    InterceptIdPreCallValidateCmdEndTransformFeedbackEXT,
    InterceptIdPreCallRecordCmdEndTransformFeedbackEXT,
    InterceptIdPostCallRecordCmdEndTransformFeedbackEXT,
    InterceptIdPreCallValidateCmdBeginQueryIndexedEXT,
    InterceptIdPreCallRecordCmdBeginQueryIndexedEXT,
    InterceptIdPostCallRecordCmdBeginQueryIndexedEXT,
    InterceptIdPreCallValidateCmdEndQueryIndexedEXT,
    InterceptIdPreCallRecordCmdEndQueryIndexedEXT,
    InterceptIdPostCallRecordCmdEndQueryIndexedEXT,
    InterceptIdPreCallValidateCmdDrawIndirectByteCountEXT,
    InterceptIdPreCallRecordCmdDrawIndirectByteCountEXT,
    InterceptIdPostCallRecordCmdDrawIndirectByteCountEXT,
    InterceptIdPreCallValidateCreateCuModuleNVX,
    InterceptIdPreCallRecordCreateCuModuleNVX,
    InterceptIdPostCallRecordCreateCuModuleNVX,
    InterceptIdPreCallValidateCreateCuFunctionNVX,
    InterceptIdPreCallRecordCreateCuFunctionNVX,
    InterceptIdPostCallRecordCreateCuFunctionNVX,
    InterceptIdPreCallValidateDestroyCuModuleNVX,
    InterceptIdPreCallRecordDestroyCuModuleNVX,
    InterceptIdPostCallRecordDestroyCuModuleNVX,
    InterceptIdPreCallValidateDestroyCuFunctionNVX,
    InterceptIdPreCallRecordDestroyCuFunctionNVX,
    InterceptIdPostCallRecordDestroyCuFunctionNVX,
    InterceptIdPreCallValidateCmdCuLaunchKernelNVX,
    InterceptIdPreCallRecordCmdCuLaunchKernelNVX,
    InterceptIdPostCallRecordCmdCuLaunchKernelNVX,
    InterceptIdPreCallValidateGetImageViewHandleNVX,
    InterceptIdPreCallRecordGetImageViewHandleNVX,
    InterceptIdPostCallRecordGetImageViewHandleNVX,
    InterceptIdPreCallValidateGetImageViewAddressNVX,
    InterceptIdPreCallRecordGetImageViewAddressNVX,
    InterceptIdPostCallRecordGetImageViewAddressNVX,
    InterceptIdPreCallValidateCmdDrawIndirectCountAMD,
    InterceptIdPreCallRecordCmdDrawIndirectCountAMD,
    InterceptIdPostCallRecordCmdDrawIndirectCountAMD,
    InterceptIdPreCallValidateCmdDrawIndexedIndirectCountAMD,
    InterceptIdPreCallRecordCmdDrawIndexedIndirectCountAMD,
    InterceptIdPostCallRecordCmdDrawIndexedIndirectCountAMD,
    InterceptIdPreCallValidateGetShaderInfoAMD,
    InterceptIdPreCallRecordGetShaderInfoAMD,
    InterceptIdPostCallRecordGetShaderInfoAMD,
    InterceptIdPreCallValidateGetMemoryWin32HandleNV,
    InterceptIdPreCallRecordGetMemoryWin32HandleNV,
    InterceptIdPostCallRecordGetMemoryWin32HandleNV,
    InterceptIdPreCallValidateCmdBeginConditionalRenderingEXT,
    InterceptIdPreCallRecordCmdBeginConditionalRenderingEXT,
    InterceptIdPostCallRecordCmdBeginConditionalRenderingEXT,
    InterceptIdPreCallValidateCmdEndConditionalRenderingEXT,
    InterceptIdPreCallRecordCmdEndConditionalRenderingEXT,
    InterceptIdPostCallRecordCmdEndConditionalRenderingEXT,
    InterceptIdPreCallValidateCmdSetViewportWScalingNV,
    InterceptIdPreCallRecordCmdSetViewportWScalingNV,
    InterceptIdPostCallRecordCmdSetViewportWScalingNV,
    InterceptIdPreCallValidateDisplayPowerControlEXT,
    InterceptIdPreCallRecordDisplayPowerControlEXT,
    InterceptIdPostCallRecordDisplayPowerControlEXT,
    InterceptIdPreCallValidateRegisterDeviceEventEXT,
    InterceptIdPreCallRecordRegisterDeviceEventEXT,
    InterceptIdPostCallRecordRegisterDeviceEventEXT,
    InterceptIdPreCallValidateRegisterDisplayEventEXT,
    InterceptIdPreCallRecordRegisterDisplayEventEXT,
    InterceptIdPostCallRecordRegisterDisplayEventEXT,
    InterceptIdPreCallValidateGetSwapchainCounterEXT,
    InterceptIdPreCallRecordGetSwapchainCounterEXT,
    InterceptIdPostCallRecordGetSwapchainCounterEXT,
    InterceptIdPreCallValidateGetRefreshCycleDurationGOOGLE,
    InterceptIdPreCallRecordGetRefreshCycleDurationGOOGLE,
    InterceptIdPostCallRecordGetRefreshCycleDurationGOOGLE,
    InterceptIdPreCallValidateGetPastPresentationTimingGOOGLE,
    InterceptIdPreCallRecordGetPastPresentationTimingGOOGLE,
    InterceptIdPostCallRecordGetPastPresentationTimingGOOGLE,
    InterceptIdPreCallValidateCmdSetDiscardRectangleEXT,
    InterceptIdPreCallRecordCmdSetDiscardRectangleEXT,
    InterceptIdPostCallRecordCmdSetDiscardRectangleEXT,
    InterceptIdPreCallValidateCmdSetDiscardRectangleEnableEXT,
    InterceptIdPreCallRecordCmdSetDiscardRectangleEnableEXT,
    InterceptIdPostCallRecordCmdSetDiscardRectangleEnableEXT,
    InterceptIdPreCallValidateCmdSetDiscardRectangleModeEXT,
    InterceptIdPreCallRecordCmdSetDiscardRectangleModeEXT,
    InterceptIdPostCallRecordCmdSetDiscardRectangleModeEXT,
    InterceptIdPreCallValidateSetHdrMetadataEXT,
    InterceptIdPreCallRecordSetHdrMetadataEXT,
    InterceptIdPostCallRecordSetHdrMetadataEXT,
    InterceptIdPreCallValidateSetDebugUtilsObjectNameEXT,
    InterceptIdPreCallRecordSetDebugUtilsObjectNameEXT,
    InterceptIdPostCallRecordSetDebugUtilsObjectNameEXT,
    InterceptIdPreCallValidateSetDebugUtilsObjectTagEXT,
    InterceptIdPreCallRecordSetDebugUtilsObjectTagEXT,
    InterceptIdPostCallRecordSetDebugUtilsObjectTagEXT,
    InterceptIdPreCallValidateQueueBeginDebugUtilsLabelEXT,
    InterceptIdPreCallRecordQueueBeginDebugUtilsLabelEXT,
    InterceptIdPostCallRecordQueueBeginDebugUtilsLabelEXT,
    InterceptIdPreCallValidateQueueEndDebugUtilsLabelEXT,
    InterceptIdPreCallRecordQueueEndDebugUtilsLabelEXT,
    InterceptIdPostCallRecordQueueEndDebugUtilsLabelEXT,
    InterceptIdPreCallValidateQueueInsertDebugUtilsLabelEXT,
    InterceptIdPreCallRecordQueueInsertDebugUtilsLabelEXT,
    InterceptIdPostCallRecordQueueInsertDebugUtilsLabelEXT,
    InterceptIdPreCallValidateCmdBeginDebugUtilsLabelEXT,
    InterceptIdPreCallRecordCmdBeginDebugUtilsLabelEXT,
    InterceptIdPostCallRecordCmdBeginDebugUtilsLabelEXT,
    InterceptIdPreCallValidateCmdEndDebugUtilsLabelEXT,
    InterceptIdPreCallRecordCmdEndDebugUtilsLabelEXT,
    InterceptIdPostCallRecordCmdEndDebugUtilsLabelEXT,
    InterceptIdPreCallValidateCmdInsertDebugUtilsLabelEXT,
    InterceptIdPreCallRecordCmdInsertDebugUtilsLabelEXT,
    InterceptIdPostCallRecordCmdInsertDebugUtilsLabelEXT,
    InterceptIdPreCallValidateGetAndroidHardwareBufferPropertiesANDROID,
    InterceptIdPreCallRecordGetAndroidHardwareBufferPropertiesANDROID,
    InterceptIdPostCallRecordGetAndroidHardwareBufferPropertiesANDROID,
    InterceptIdPreCallValidateGetMemoryAndroidHardwareBufferANDROID,
    InterceptIdPreCallRecordGetMemoryAndroidHardwareBufferANDROID,
    InterceptIdPostCallRecordGetMemoryAndroidHardwareBufferANDROID,
    InterceptIdPreCallValidateCreateExecutionGraphPipelinesAMDX,
    InterceptIdPreCallRecordCreateExecutionGraphPipelinesAMDX,
    InterceptIdPostCallRecordCreateExecutionGraphPipelinesAMDX,
    InterceptIdPreCallValidateGetExecutionGraphPipelineScratchSizeAMDX,
    InterceptIdPreCallRecordGetExecutionGraphPipelineScratchSizeAMDX,
    InterceptIdPostCallRecordGetExecutionGraphPipelineScratchSizeAMDX,
    InterceptIdPreCallValidateGetExecutionGraphPipelineNodeIndexAMDX,
    InterceptIdPreCallRecordGetExecutionGraphPipelineNodeIndexAMDX,
    InterceptIdPostCallRecordGetExecutionGraphPipelineNodeIndexAMDX,
    InterceptIdPreCallValidateCmdInitializeGraphScratchMemoryAMDX,
    InterceptIdPreCallRecordCmdInitializeGraphScratchMemoryAMDX,
    InterceptIdPostCallRecordCmdInitializeGraphScratchMemoryAMDX,
    InterceptIdPreCallValidateCmdDispatchGraphAMDX,
    InterceptIdPreCallRecordCmdDispatchGraphAMDX,
    InterceptIdPostCallRecordCmdDispatchGraphAMDX,
    InterceptIdPreCallValidateCmdDispatchGraphIndirectAMDX,
    InterceptIdPreCallRecordCmdDispatchGraphIndirectAMDX,
    InterceptIdPostCallRecordCmdDispatchGraphIndirectAMDX,
    InterceptIdPreCallValidateCmdDispatchGraphIndirectCountAMDX,
    InterceptIdPreCallRecordCmdDispatchGraphIndirectCountAMDX,
    InterceptIdPostCallRecordCmdDispatchGraphIndirectCountAMDX,
    InterceptIdPreCallValidateCmdSetSampleLocationsEXT,
    InterceptIdPreCallRecordCmdSetSampleLocationsEXT,
    InterceptIdPostCallRecordCmdSetSampleLocationsEXT,
    InterceptIdPreCallValidateGetImageDrmFormatModifierPropertiesEXT,
    InterceptIdPreCallRecordGetImageDrmFormatModifierPropertiesEXT,
    InterceptIdPostCallRecordGetImageDrmFormatModifierPropertiesEXT,
    InterceptIdPreCallValidateCmdBindShadingRateImageNV,
    InterceptIdPreCallRecordCmdBindShadingRateImageNV,
    InterceptIdPostCallRecordCmdBindShadingRateImageNV,
    InterceptIdPreCallValidateCmdSetViewportShadingRatePaletteNV,
    InterceptIdPreCallRecordCmdSetViewportShadingRatePaletteNV,
    InterceptIdPostCallRecordCmdSetViewportShadingRatePaletteNV,
    InterceptIdPreCallValidateCmdSetCoarseSampleOrderNV,
    InterceptIdPreCallRecordCmdSetCoarseSampleOrderNV,
    InterceptIdPostCallRecordCmdSetCoarseSampleOrderNV,
    InterceptIdPreCallValidateCreateAccelerationStructureNV,
    InterceptIdPreCallRecordCreateAccelerationStructureNV,
    InterceptIdPostCallRecordCreateAccelerationStructureNV,
    InterceptIdPreCallValidateDestroyAccelerationStructureNV,
    InterceptIdPreCallRecordDestroyAccelerationStructureNV,
    InterceptIdPostCallRecordDestroyAccelerationStructureNV,
    InterceptIdPreCallValidateGetAccelerationStructureMemoryRequirementsNV,
    InterceptIdPreCallRecordGetAccelerationStructureMemoryRequirementsNV,
    InterceptIdPostCallRecordGetAccelerationStructureMemoryRequirementsNV,
    InterceptIdPreCallValidateBindAccelerationStructureMemoryNV,
    InterceptIdPreCallRecordBindAccelerationStructureMemoryNV,
    InterceptIdPostCallRecordBindAccelerationStructureMemoryNV,
    InterceptIdPreCallValidateCmdBuildAccelerationStructureNV,
    InterceptIdPreCallRecordCmdBuildAccelerationStructureNV,
    InterceptIdPostCallRecordCmdBuildAccelerationStructureNV,
    InterceptIdPreCallValidateCmdCopyAccelerationStructureNV,
    InterceptIdPreCallRecordCmdCopyAccelerationStructureNV,
    InterceptIdPostCallRecordCmdCopyAccelerationStructureNV,
    InterceptIdPreCallValidateCmdTraceRaysNV,
    InterceptIdPreCallRecordCmdTraceRaysNV,
    InterceptIdPostCallRecordCmdTraceRaysNV,
    InterceptIdPreCallValidateGetRayTracingShaderGroupHandlesKHR,
    InterceptIdPreCallRecordGetRayTracingShaderGroupHandlesKHR,
    InterceptIdPostCallRecordGetRayTracingShaderGroupHandlesKHR,
    InterceptIdPreCallValidateGetRayTracingShaderGroupHandlesNV,
    InterceptIdPreCallRecordGetRayTracingShaderGroupHandlesNV,
    InterceptIdPostCallRecordGetRayTracingShaderGroupHandlesNV,
    InterceptIdPreCallValidateGetAccelerationStructureHandleNV,
    InterceptIdPreCallRecordGetAccelerationStructureHandleNV,
    InterceptIdPostCallRecordGetAccelerationStructureHandleNV,
    InterceptIdPreCallValidateCmdWriteAccelerationStructuresPropertiesNV,
    InterceptIdPreCallRecordCmdWriteAccelerationStructuresPropertiesNV,
    InterceptIdPostCallRecordCmdWriteAccelerationStructuresPropertiesNV,
    InterceptIdPreCallValidateCompileDeferredNV,
    InterceptIdPreCallRecordCompileDeferredNV,
    InterceptIdPostCallRecordCompileDeferredNV,
    InterceptIdPreCallValidateGetMemoryHostPointerPropertiesEXT,
    InterceptIdPreCallRecordGetMemoryHostPointerPropertiesEXT,
    InterceptIdPostCallRecordGetMemoryHostPointerPropertiesEXT,
    InterceptIdPreCallValidateCmdWriteBufferMarkerAMD,
    InterceptIdPreCallRecordCmdWriteBufferMarkerAMD,
    InterceptIdPostCallRecordCmdWriteBufferMarkerAMD,
    InterceptIdPreCallValidateGetCalibratedTimestampsEXT,
    InterceptIdPreCallRecordGetCalibratedTimestampsEXT,
    InterceptIdPostCallRecordGetCalibratedTimestampsEXT,
    InterceptIdPreCallValidateCmdDrawMeshTasksNV,
    InterceptIdPreCallRecordCmdDrawMeshTasksNV,
    InterceptIdPostCallRecordCmdDrawMeshTasksNV,
    InterceptIdPreCallValidateCmdDrawMeshTasksIndirectNV,
    InterceptIdPreCallRecordCmdDrawMeshTasksIndirectNV,
    InterceptIdPostCallRecordCmdDrawMeshTasksIndirectNV,
    InterceptIdPreCallValidateCmdDrawMeshTasksIndirectCountNV,
    InterceptIdPreCallRecordCmdDrawMeshTasksIndirectCountNV,
    InterceptIdPostCallRecordCmdDrawMeshTasksIndirectCountNV,
    InterceptIdPreCallValidateCmdSetExclusiveScissorEnableNV,
    InterceptIdPreCallRecordCmdSetExclusiveScissorEnableNV,
    InterceptIdPostCallRecordCmdSetExclusiveScissorEnableNV,
    InterceptIdPreCallValidateCmdSetExclusiveScissorNV,
    InterceptIdPreCallRecordCmdSetExclusiveScissorNV,
    InterceptIdPostCallRecordCmdSetExclusiveScissorNV,
    InterceptIdPreCallValidateCmdSetCheckpointNV,
    InterceptIdPreCallRecordCmdSetCheckpointNV,
    InterceptIdPostCallRecordCmdSetCheckpointNV,
    InterceptIdPreCallValidateGetQueueCheckpointDataNV,
    InterceptIdPreCallRecordGetQueueCheckpointDataNV,
    InterceptIdPostCallRecordGetQueueCheckpointDataNV,
    InterceptIdPreCallValidateInitializePerformanceApiINTEL,
    InterceptIdPreCallRecordInitializePerformanceApiINTEL,
    InterceptIdPostCallRecordInitializePerformanceApiINTEL,
    InterceptIdPreCallValidateUninitializePerformanceApiINTEL,
    InterceptIdPreCallRecordUninitializePerformanceApiINTEL,
    InterceptIdPostCallRecordUninitializePerformanceApiINTEL,
    InterceptIdPreCallValidateCmdSetPerformanceMarkerINTEL,
    InterceptIdPreCallRecordCmdSetPerformanceMarkerINTEL,
    InterceptIdPostCallRecordCmdSetPerformanceMarkerINTEL,
    InterceptIdPreCallValidateCmdSetPerformanceStreamMarkerINTEL,
    InterceptIdPreCallRecordCmdSetPerformanceStreamMarkerINTEL,
    InterceptIdPostCallRecordCmdSetPerformanceStreamMarkerINTEL,
    InterceptIdPreCallValidateCmdSetPerformanceOverrideINTEL,
    InterceptIdPreCallRecordCmdSetPerformanceOverrideINTEL,
    InterceptIdPostCallRecordCmdSetPerformanceOverrideINTEL,
    InterceptIdPreCallValidateAcquirePerformanceConfigurationINTEL,
    InterceptIdPreCallRecordAcquirePerformanceConfigurationINTEL,
    InterceptIdPostCallRecordAcquirePerformanceConfigurationINTEL,
    InterceptIdPreCallValidateReleasePerformanceConfigurationINTEL,
    InterceptIdPreCallRecordReleasePerformanceConfigurationINTEL,
    InterceptIdPostCallRecordReleasePerformanceConfigurationINTEL,
    InterceptIdPreCallValidateQueueSetPerformanceConfigurationINTEL,
    InterceptIdPreCallRecordQueueSetPerformanceConfigurationINTEL,
    InterceptIdPostCallRecordQueueSetPerformanceConfigurationINTEL,
    InterceptIdPreCallValidateGetPerformanceParameterINTEL,
    InterceptIdPreCallRecordGetPerformanceParameterINTEL,
    InterceptIdPostCallRecordGetPerformanceParameterINTEL,
    InterceptIdPreCallValidateSetLocalDimmingAMD,
    InterceptIdPreCallRecordSetLocalDimmingAMD,
    InterceptIdPostCallRecordSetLocalDimmingAMD,
    InterceptIdPreCallValidateGetBufferDeviceAddressEXT,
    InterceptIdPreCallRecordGetBufferDeviceAddressEXT,
    InterceptIdPostCallRecordGetBufferDeviceAddressEXT,
    InterceptIdPreCallValidateAcquireFullScreenExclusiveModeEXT,
    InterceptIdPreCallRecordAcquireFullScreenExclusiveModeEXT,
    InterceptIdPostCallRecordAcquireFullScreenExclusiveModeEXT,
    InterceptIdPreCallValidateReleaseFullScreenExclusiveModeEXT,
    InterceptIdPreCallRecordReleaseFullScreenExclusiveModeEXT,
    InterceptIdPostCallRecordReleaseFullScreenExclusiveModeEXT,
    InterceptIdPreCallValidateGetDeviceGroupSurfacePresentModes2EXT,
    InterceptIdPreCallRecordGetDeviceGroupSurfacePresentModes2EXT,
    InterceptIdPostCallRecordGetDeviceGroupSurfacePresentModes2EXT,
    InterceptIdPreCallValidateCmdSetLineStippleEXT,
    InterceptIdPreCallRecordCmdSetLineStippleEXT,
    InterceptIdPostCallRecordCmdSetLineStippleEXT,
    InterceptIdPreCallValidateResetQueryPoolEXT,
    InterceptIdPreCallRecordResetQueryPoolEXT,
    InterceptIdPostCallRecordResetQueryPoolEXT,
    InterceptIdPreCallValidateCmdSetCullModeEXT,
    InterceptIdPreCallRecordCmdSetCullModeEXT,
    InterceptIdPostCallRecordCmdSetCullModeEXT,
    InterceptIdPreCallValidateCmdSetFrontFaceEXT,
    InterceptIdPreCallRecordCmdSetFrontFaceEXT,
    InterceptIdPostCallRecordCmdSetFrontFaceEXT,
    InterceptIdPreCallValidateCmdSetPrimitiveTopologyEXT,
    InterceptIdPreCallRecordCmdSetPrimitiveTopologyEXT,
    InterceptIdPostCallRecordCmdSetPrimitiveTopologyEXT,
    InterceptIdPreCallValidateCmdSetViewportWithCountEXT,
    InterceptIdPreCallRecordCmdSetViewportWithCountEXT,
    InterceptIdPostCallRecordCmdSetViewportWithCountEXT,
    InterceptIdPreCallValidateCmdSetScissorWithCountEXT,
    InterceptIdPreCallRecordCmdSetScissorWithCountEXT,
    InterceptIdPostCallRecordCmdSetScissorWithCountEXT,
    InterceptIdPreCallValidateCmdBindVertexBuffers2EXT,
    InterceptIdPreCallRecordCmdBindVertexBuffers2EXT,
    InterceptIdPostCallRecordCmdBindVertexBuffers2EXT,
    InterceptIdPreCallValidateCmdSetDepthTestEnableEXT,
    InterceptIdPreCallRecordCmdSetDepthTestEnableEXT,
    InterceptIdPostCallRecordCmdSetDepthTestEnableEXT,
    InterceptIdPreCallValidateCmdSetDepthWriteEnableEXT,
    InterceptIdPreCallRecordCmdSetDepthWriteEnableEXT,
    InterceptIdPostCallRecordCmdSetDepthWriteEnableEXT,
    InterceptIdPreCallValidateCmdSetDepthCompareOpEXT,
    InterceptIdPreCallRecordCmdSetDepthCompareOpEXT,
    InterceptIdPostCallRecordCmdSetDepthCompareOpEXT,
    InterceptIdPreCallValidateCmdSetDepthBoundsTestEnableEXT,
    InterceptIdPreCallRecordCmdSetDepthBoundsTestEnableEXT,
    InterceptIdPostCallRecordCmdSetDepthBoundsTestEnableEXT,
    InterceptIdPreCallValidateCmdSetStencilTestEnableEXT,
    InterceptIdPreCallRecordCmdSetStencilTestEnableEXT,
    InterceptIdPostCallRecordCmdSetStencilTestEnableEXT,
    InterceptIdPreCallValidateCmdSetStencilOpEXT,
    InterceptIdPreCallRecordCmdSetStencilOpEXT,
    InterceptIdPostCallRecordCmdSetStencilOpEXT,
    InterceptIdPreCallValidateCopyMemoryToImageEXT,
    InterceptIdPreCallRecordCopyMemoryToImageEXT,
    InterceptIdPostCallRecordCopyMemoryToImageEXT,
    InterceptIdPreCallValidateCopyImageToMemoryEXT,
    InterceptIdPreCallRecordCopyImageToMemoryEXT,
    InterceptIdPostCallRecordCopyImageToMemoryEXT,
    InterceptIdPreCallValidateCopyImageToImageEXT,
    InterceptIdPreCallRecordCopyImageToImageEXT,
    InterceptIdPostCallRecordCopyImageToImageEXT,
    InterceptIdPreCallValidateTransitionImageLayoutEXT,
    InterceptIdPreCallRecordTransitionImageLayoutEXT,
    InterceptIdPostCallRecordTransitionImageLayoutEXT,
    InterceptIdPreCallValidateGetImageSubresourceLayout2EXT,
    InterceptIdPreCallRecordGetImageSubresourceLayout2EXT,
    InterceptIdPostCallRecordGetImageSubresourceLayout2EXT,
    InterceptIdPreCallValidateReleaseSwapchainImagesEXT,
    InterceptIdPreCallRecordReleaseSwapchainImagesEXT,
    InterceptIdPostCallRecordReleaseSwapchainImagesEXT,
    InterceptIdPreCallValidateGetGeneratedCommandsMemoryRequirementsNV,
    InterceptIdPreCallRecordGetGeneratedCommandsMemoryRequirementsNV,
    InterceptIdPostCallRecordGetGeneratedCommandsMemoryRequirementsNV,
    InterceptIdPreCallValidateCmdPreprocessGeneratedCommandsNV,
    InterceptIdPreCallRecordCmdPreprocessGeneratedCommandsNV,
    InterceptIdPostCallRecordCmdPreprocessGeneratedCommandsNV,
    InterceptIdPreCallValidateCmdExecuteGeneratedCommandsNV,
    InterceptIdPreCallRecordCmdExecuteGeneratedCommandsNV,
    InterceptIdPostCallRecordCmdExecuteGeneratedCommandsNV,
    InterceptIdPreCallValidateCmdBindPipelineShaderGroupNV,
    InterceptIdPreCallRecordCmdBindPipelineShaderGroupNV,
    InterceptIdPostCallRecordCmdBindPipelineShaderGroupNV,
    InterceptIdPreCallValidateCreateIndirectCommandsLayoutNV,
    InterceptIdPreCallRecordCreateIndirectCommandsLayoutNV,
    InterceptIdPostCallRecordCreateIndirectCommandsLayoutNV,
    InterceptIdPreCallValidateDestroyIndirectCommandsLayoutNV,
    InterceptIdPreCallRecordDestroyIndirectCommandsLayoutNV,
    InterceptIdPostCallRecordDestroyIndirectCommandsLayoutNV,
    InterceptIdPreCallValidateCmdSetDepthBias2EXT,
    InterceptIdPreCallRecordCmdSetDepthBias2EXT,
    InterceptIdPostCallRecordCmdSetDepthBias2EXT,
    InterceptIdPreCallValidateCreatePrivateDataSlotEXT,
    InterceptIdPreCallRecordCreatePrivateDataSlotEXT,
    InterceptIdPostCallRecordCreatePrivateDataSlotEXT,
    InterceptIdPreCallValidateDestroyPrivateDataSlotEXT,
    InterceptIdPreCallRecordDestroyPrivateDataSlotEXT,
    InterceptIdPostCallRecordDestroyPrivateDataSlotEXT,
    InterceptIdPreCallValidateSetPrivateDataEXT,
    InterceptIdPreCallRecordSetPrivateDataEXT,
    InterceptIdPostCallRecordSetPrivateDataEXT,
    InterceptIdPreCallValidateGetPrivateDataEXT,
    InterceptIdPreCallRecordGetPrivateDataEXT,
    InterceptIdPostCallRecordGetPrivateDataEXT,
    InterceptIdPreCallValidateCreateCudaModuleNV,
    InterceptIdPreCallRecordCreateCudaModuleNV,
    InterceptIdPostCallRecordCreateCudaModuleNV,
    InterceptIdPreCallValidateGetCudaModuleCacheNV,
    InterceptIdPreCallRecordGetCudaModuleCacheNV,
    InterceptIdPostCallRecordGetCudaModuleCacheNV,
    InterceptIdPreCallValidateCreateCudaFunctionNV,
    InterceptIdPreCallRecordCreateCudaFunctionNV,
    InterceptIdPostCallRecordCreateCudaFunctionNV,
    InterceptIdPreCallValidateDestroyCudaModuleNV,
    InterceptIdPreCallRecordDestroyCudaModuleNV,
    InterceptIdPostCallRecordDestroyCudaModuleNV,
    InterceptIdPreCallValidateDestroyCudaFunctionNV,
    InterceptIdPreCallRecordDestroyCudaFunctionNV,
    InterceptIdPostCallRecordDestroyCudaFunctionNV,
    InterceptIdPreCallValidateCmdCudaLaunchKernelNV,
    InterceptIdPreCallRecordCmdCudaLaunchKernelNV,
    InterceptIdPostCallRecordCmdCudaLaunchKernelNV,
    InterceptIdPreCallValidateExportMetalObjectsEXT,
    InterceptIdPreCallRecordExportMetalObjectsEXT,
    InterceptIdPostCallRecordExportMetalObjectsEXT,
    InterceptIdPreCallValidateGetDescriptorSetLayoutSizeEXT,
    InterceptIdPreCallRecordGetDescriptorSetLayoutSizeEXT,
    InterceptIdPostCallRecordGetDescriptorSetLayoutSizeEXT,
    InterceptIdPreCallValidateGetDescriptorSetLayoutBindingOffsetEXT,
    InterceptIdPreCallRecordGetDescriptorSetLayoutBindingOffsetEXT,
    InterceptIdPostCallRecordGetDescriptorSetLayoutBindingOffsetEXT,
    InterceptIdPreCallValidateGetDescriptorEXT,
    InterceptIdPreCallRecordGetDescriptorEXT,
    InterceptIdPostCallRecordGetDescriptorEXT,
    InterceptIdPreCallValidateCmdBindDescriptorBuffersEXT,
    InterceptIdPreCallRecordCmdBindDescriptorBuffersEXT,
    InterceptIdPostCallRecordCmdBindDescriptorBuffersEXT,
    InterceptIdPreCallValidateCmdSetDescriptorBufferOffsetsEXT,
    InterceptIdPreCallRecordCmdSetDescriptorBufferOffsetsEXT,
    InterceptIdPostCallRecordCmdSetDescriptorBufferOffsetsEXT,
    InterceptIdPreCallValidateCmdBindDescriptorBufferEmbeddedSamplersEXT,
    InterceptIdPreCallRecordCmdBindDescriptorBufferEmbeddedSamplersEXT,
    InterceptIdPostCallRecordCmdBindDescriptorBufferEmbeddedSamplersEXT,
    InterceptIdPreCallValidateGetBufferOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallRecordGetBufferOpaqueCaptureDescriptorDataEXT,
    InterceptIdPostCallRecordGetBufferOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallValidateGetImageOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallRecordGetImageOpaqueCaptureDescriptorDataEXT,
    InterceptIdPostCallRecordGetImageOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallValidateGetImageViewOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallRecordGetImageViewOpaqueCaptureDescriptorDataEXT,
    InterceptIdPostCallRecordGetImageViewOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallValidateGetSamplerOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallRecordGetSamplerOpaqueCaptureDescriptorDataEXT,
    InterceptIdPostCallRecordGetSamplerOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallValidateGetAccelerationStructureOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallRecordGetAccelerationStructureOpaqueCaptureDescriptorDataEXT,
    InterceptIdPostCallRecordGetAccelerationStructureOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallValidateCmdSetFragmentShadingRateEnumNV,
    InterceptIdPreCallRecordCmdSetFragmentShadingRateEnumNV,
    InterceptIdPostCallRecordCmdSetFragmentShadingRateEnumNV,
    InterceptIdPreCallValidateGetDeviceFaultInfoEXT,
    InterceptIdPreCallRecordGetDeviceFaultInfoEXT,
    InterceptIdPostCallRecordGetDeviceFaultInfoEXT,
    InterceptIdPreCallValidateCmdSetVertexInputEXT,
    InterceptIdPreCallRecordCmdSetVertexInputEXT,
    InterceptIdPostCallRecordCmdSetVertexInputEXT,
    InterceptIdPreCallValidateGetMemoryZirconHandleFUCHSIA,
    InterceptIdPreCallRecordGetMemoryZirconHandleFUCHSIA,
    InterceptIdPostCallRecordGetMemoryZirconHandleFUCHSIA,
    InterceptIdPreCallValidateGetMemoryZirconHandlePropertiesFUCHSIA,
    InterceptIdPreCallRecordGetMemoryZirconHandlePropertiesFUCHSIA,
    InterceptIdPostCallRecordGetMemoryZirconHandlePropertiesFUCHSIA,
    InterceptIdPreCallValidateImportSemaphoreZirconHandleFUCHSIA,
    InterceptIdPreCallRecordImportSemaphoreZirconHandleFUCHSIA,
    InterceptIdPostCallRecordImportSemaphoreZirconHandleFUCHSIA,
    InterceptIdPreCallValidateGetSemaphoreZirconHandleFUCHSIA,
    InterceptIdPreCallRecordGetSemaphoreZirconHandleFUCHSIA,
    InterceptIdPostCallRecordGetSemaphoreZirconHandleFUCHSIA,
    InterceptIdPreCallValidateCreateBufferCollectionFUCHSIA,
    InterceptIdPreCallRecordCreateBufferCollectionFUCHSIA,
    InterceptIdPostCallRecordCreateBufferCollectionFUCHSIA,
    InterceptIdPreCallValidateSetBufferCollectionImageConstraintsFUCHSIA,
    InterceptIdPreCallRecordSetBufferCollectionImageConstraintsFUCHSIA,
    InterceptIdPostCallRecordSetBufferCollectionImageConstraintsFUCHSIA,
    InterceptIdPreCallValidateSetBufferCollectionBufferConstraintsFUCHSIA,
    InterceptIdPreCallRecordSetBufferCollectionBufferConstraintsFUCHSIA,
    InterceptIdPostCallRecordSetBufferCollectionBufferConstraintsFUCHSIA,
    InterceptIdPreCallValidateDestroyBufferCollectionFUCHSIA,
    InterceptIdPreCallRecordDestroyBufferCollectionFUCHSIA,
    InterceptIdPostCallRecordDestroyBufferCollectionFUCHSIA,
    InterceptIdPreCallValidateGetBufferCollectionPropertiesFUCHSIA,
    InterceptIdPreCallRecordGetBufferCollectionPropertiesFUCHSIA,
    InterceptIdPostCallRecordGetBufferCollectionPropertiesFUCHSIA,
    InterceptIdPreCallValidateGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI,
    InterceptIdPreCallRecordGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI,
    InterceptIdPostCallRecordGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI,
    InterceptIdPreCallValidateCmdSubpassShadingHUAWEI,
    InterceptIdPreCallRecordCmdSubpassShadingHUAWEI,
    InterceptIdPostCallRecordCmdSubpassShadingHUAWEI,
    InterceptIdPreCallValidateCmdBindInvocationMaskHUAWEI,
    InterceptIdPreCallRecordCmdBindInvocationMaskHUAWEI,
    InterceptIdPostCallRecordCmdBindInvocationMaskHUAWEI,
    InterceptIdPreCallValidateGetMemoryRemoteAddressNV,
    InterceptIdPreCallRecordGetMemoryRemoteAddressNV,
    InterceptIdPostCallRecordGetMemoryRemoteAddressNV,
    InterceptIdPreCallValidateGetPipelinePropertiesEXT,
    InterceptIdPreCallRecordGetPipelinePropertiesEXT,
    InterceptIdPostCallRecordGetPipelinePropertiesEXT,
    InterceptIdPreCallValidateCmdSetPatchControlPointsEXT,
    InterceptIdPreCallRecordCmdSetPatchControlPointsEXT,
    InterceptIdPostCallRecordCmdSetPatchControlPointsEXT,
    InterceptIdPreCallValidateCmdSetRasterizerDiscardEnableEXT,
    InterceptIdPreCallRecordCmdSetRasterizerDiscardEnableEXT,
    InterceptIdPostCallRecordCmdSetRasterizerDiscardEnableEXT,
    InterceptIdPreCallValidateCmdSetDepthBiasEnableEXT,
    InterceptIdPreCallRecordCmdSetDepthBiasEnableEXT,
    InterceptIdPostCallRecordCmdSetDepthBiasEnableEXT,
    InterceptIdPreCallValidateCmdSetLogicOpEXT,
    InterceptIdPreCallRecordCmdSetLogicOpEXT,
    InterceptIdPostCallRecordCmdSetLogicOpEXT,
    InterceptIdPreCallValidateCmdSetPrimitiveRestartEnableEXT,
    InterceptIdPreCallRecordCmdSetPrimitiveRestartEnableEXT,
    InterceptIdPostCallRecordCmdSetPrimitiveRestartEnableEXT,
    InterceptIdPreCallValidateCmdSetColorWriteEnableEXT,
    InterceptIdPreCallRecordCmdSetColorWriteEnableEXT,
    InterceptIdPostCallRecordCmdSetColorWriteEnableEXT,
    InterceptIdPreCallValidateCmdDrawMultiEXT,
    InterceptIdPreCallRecordCmdDrawMultiEXT,
    InterceptIdPostCallRecordCmdDrawMultiEXT,
    InterceptIdPreCallValidateCmdDrawMultiIndexedEXT,
    InterceptIdPreCallRecordCmdDrawMultiIndexedEXT,
    InterceptIdPostCallRecordCmdDrawMultiIndexedEXT,
    InterceptIdPreCallValidateCreateMicromapEXT,
    InterceptIdPreCallRecordCreateMicromapEXT,
    InterceptIdPostCallRecordCreateMicromapEXT,
    InterceptIdPreCallValidateDestroyMicromapEXT,
    InterceptIdPreCallRecordDestroyMicromapEXT,
    InterceptIdPostCallRecordDestroyMicromapEXT,
    InterceptIdPreCallValidateCmdBuildMicromapsEXT,
    InterceptIdPreCallRecordCmdBuildMicromapsEXT,
    InterceptIdPostCallRecordCmdBuildMicromapsEXT,
    InterceptIdPreCallValidateBuildMicromapsEXT,
    InterceptIdPreCallRecordBuildMicromapsEXT,
    InterceptIdPostCallRecordBuildMicromapsEXT,
    InterceptIdPreCallValidateCopyMicromapEXT,
    InterceptIdPreCallRecordCopyMicromapEXT,
    InterceptIdPostCallRecordCopyMicromapEXT,
    InterceptIdPreCallValidateCopyMicromapToMemoryEXT,
    InterceptIdPreCallRecordCopyMicromapToMemoryEXT,
    InterceptIdPostCallRecordCopyMicromapToMemoryEXT,
    InterceptIdPreCallValidateCopyMemoryToMicromapEXT,
    InterceptIdPreCallRecordCopyMemoryToMicromapEXT,
    InterceptIdPostCallRecordCopyMemoryToMicromapEXT,
    InterceptIdPreCallValidateWriteMicromapsPropertiesEXT,
    InterceptIdPreCallRecordWriteMicromapsPropertiesEXT,
    InterceptIdPostCallRecordWriteMicromapsPropertiesEXT,
    InterceptIdPreCallValidateCmdCopyMicromapEXT,
    InterceptIdPreCallRecordCmdCopyMicromapEXT,
    InterceptIdPostCallRecordCmdCopyMicromapEXT,
    InterceptIdPreCallValidateCmdCopyMicromapToMemoryEXT,
    InterceptIdPreCallRecordCmdCopyMicromapToMemoryEXT,
    InterceptIdPostCallRecordCmdCopyMicromapToMemoryEXT,
    InterceptIdPreCallValidateCmdCopyMemoryToMicromapEXT,
    InterceptIdPreCallRecordCmdCopyMemoryToMicromapEXT,
    InterceptIdPostCallRecordCmdCopyMemoryToMicromapEXT,
    InterceptIdPreCallValidateCmdWriteMicromapsPropertiesEXT,
    InterceptIdPreCallRecordCmdWriteMicromapsPropertiesEXT,
    InterceptIdPostCallRecordCmdWriteMicromapsPropertiesEXT,
    InterceptIdPreCallValidateGetDeviceMicromapCompatibilityEXT,
    InterceptIdPreCallRecordGetDeviceMicromapCompatibilityEXT,
    InterceptIdPostCallRecordGetDeviceMicromapCompatibilityEXT,
    InterceptIdPreCallValidateGetMicromapBuildSizesEXT,
    InterceptIdPreCallRecordGetMicromapBuildSizesEXT,
    InterceptIdPostCallRecordGetMicromapBuildSizesEXT,
    InterceptIdPreCallValidateCmdDrawClusterHUAWEI,
    InterceptIdPreCallRecordCmdDrawClusterHUAWEI,
    InterceptIdPostCallRecordCmdDrawClusterHUAWEI,
    InterceptIdPreCallValidateCmdDrawClusterIndirectHUAWEI,
    InterceptIdPreCallRecordCmdDrawClusterIndirectHUAWEI,
    InterceptIdPostCallRecordCmdDrawClusterIndirectHUAWEI,
    InterceptIdPreCallValidateSetDeviceMemoryPriorityEXT,
    InterceptIdPreCallRecordSetDeviceMemoryPriorityEXT,
    InterceptIdPostCallRecordSetDeviceMemoryPriorityEXT,
    InterceptIdPreCallValidateGetDescriptorSetLayoutHostMappingInfoVALVE,
    InterceptIdPreCallRecordGetDescriptorSetLayoutHostMappingInfoVALVE,
    InterceptIdPostCallRecordGetDescriptorSetLayoutHostMappingInfoVALVE,
    InterceptIdPreCallValidateGetDescriptorSetHostMappingVALVE,
    InterceptIdPreCallRecordGetDescriptorSetHostMappingVALVE,
    InterceptIdPostCallRecordGetDescriptorSetHostMappingVALVE,
    InterceptIdPreCallValidateCmdCopyMemoryIndirectNV,
    InterceptIdPreCallRecordCmdCopyMemoryIndirectNV,
    InterceptIdPostCallRecordCmdCopyMemoryIndirectNV,
    InterceptIdPreCallValidateCmdCopyMemoryToImageIndirectNV,
    InterceptIdPreCallRecordCmdCopyMemoryToImageIndirectNV,
    InterceptIdPostCallRecordCmdCopyMemoryToImageIndirectNV,
    InterceptIdPreCallValidateCmdDecompressMemoryNV,
    InterceptIdPreCallRecordCmdDecompressMemoryNV,
    InterceptIdPostCallRecordCmdDecompressMemoryNV,
    InterceptIdPreCallValidateCmdDecompressMemoryIndirectCountNV,
    InterceptIdPreCallRecordCmdDecompressMemoryIndirectCountNV,
    InterceptIdPostCallRecordCmdDecompressMemoryIndirectCountNV,
    InterceptIdPreCallValidateGetPipelineIndirectMemoryRequirementsNV,
    InterceptIdPreCallRecordGetPipelineIndirectMemoryRequirementsNV,
    InterceptIdPostCallRecordGetPipelineIndirectMemoryRequirementsNV,
    InterceptIdPreCallValidateCmdUpdatePipelineIndirectBufferNV,
    InterceptIdPreCallRecordCmdUpdatePipelineIndirectBufferNV,
    InterceptIdPostCallRecordCmdUpdatePipelineIndirectBufferNV,
    InterceptIdPreCallValidateGetPipelineIndirectDeviceAddressNV,
    InterceptIdPreCallRecordGetPipelineIndirectDeviceAddressNV,
    InterceptIdPostCallRecordGetPipelineIndirectDeviceAddressNV,
    InterceptIdPreCallValidateCmdSetDepthClampEnableEXT,
    InterceptIdPreCallRecordCmdSetDepthClampEnableEXT,
    InterceptIdPostCallRecordCmdSetDepthClampEnableEXT,
    InterceptIdPreCallValidateCmdSetPolygonModeEXT,
    InterceptIdPreCallRecordCmdSetPolygonModeEXT,
    InterceptIdPostCallRecordCmdSetPolygonModeEXT,
    InterceptIdPreCallValidateCmdSetRasterizationSamplesEXT,
    InterceptIdPreCallRecordCmdSetRasterizationSamplesEXT,
    InterceptIdPostCallRecordCmdSetRasterizationSamplesEXT,
    InterceptIdPreCallValidateCmdSetSampleMaskEXT,
    InterceptIdPreCallRecordCmdSetSampleMaskEXT,
    InterceptIdPostCallRecordCmdSetSampleMaskEXT,
    InterceptIdPreCallValidateCmdSetAlphaToCoverageEnableEXT,
    InterceptIdPreCallRecordCmdSetAlphaToCoverageEnableEXT,
    InterceptIdPostCallRecordCmdSetAlphaToCoverageEnableEXT,
    InterceptIdPreCallValidateCmdSetAlphaToOneEnableEXT,
    InterceptIdPreCallRecordCmdSetAlphaToOneEnableEXT,
    InterceptIdPostCallRecordCmdSetAlphaToOneEnableEXT,
    InterceptIdPreCallValidateCmdSetLogicOpEnableEXT,
    InterceptIdPreCallRecordCmdSetLogicOpEnableEXT,
    InterceptIdPostCallRecordCmdSetLogicOpEnableEXT,
    InterceptIdPreCallValidateCmdSetColorBlendEnableEXT,
    InterceptIdPreCallRecordCmdSetColorBlendEnableEXT,
    InterceptIdPostCallRecordCmdSetColorBlendEnableEXT,
    InterceptIdPreCallValidateCmdSetColorBlendEquationEXT,
    InterceptIdPreCallRecordCmdSetColorBlendEquationEXT,
    InterceptIdPostCallRecordCmdSetColorBlendEquationEXT,
    InterceptIdPreCallValidateCmdSetColorWriteMaskEXT,
    InterceptIdPreCallRecordCmdSetColorWriteMaskEXT,
    InterceptIdPostCallRecordCmdSetColorWriteMaskEXT,
    InterceptIdPreCallValidateCmdSetTessellationDomainOriginEXT,
    InterceptIdPreCallRecordCmdSetTessellationDomainOriginEXT,
    InterceptIdPostCallRecordCmdSetTessellationDomainOriginEXT,
    InterceptIdPreCallValidateCmdSetRasterizationStreamEXT,
    InterceptIdPreCallRecordCmdSetRasterizationStreamEXT,
    InterceptIdPostCallRecordCmdSetRasterizationStreamEXT,
    InterceptIdPreCallValidateCmdSetConservativeRasterizationModeEXT,
    InterceptIdPreCallRecordCmdSetConservativeRasterizationModeEXT,
    InterceptIdPostCallRecordCmdSetConservativeRasterizationModeEXT,
    InterceptIdPreCallValidateCmdSetExtraPrimitiveOverestimationSizeEXT,
    InterceptIdPreCallRecordCmdSetExtraPrimitiveOverestimationSizeEXT,
    InterceptIdPostCallRecordCmdSetExtraPrimitiveOverestimationSizeEXT,
    InterceptIdPreCallValidateCmdSetDepthClipEnableEXT,
    InterceptIdPreCallRecordCmdSetDepthClipEnableEXT,
    InterceptIdPostCallRecordCmdSetDepthClipEnableEXT,
    InterceptIdPreCallValidateCmdSetSampleLocationsEnableEXT,
    InterceptIdPreCallRecordCmdSetSampleLocationsEnableEXT,
    InterceptIdPostCallRecordCmdSetSampleLocationsEnableEXT,
    InterceptIdPreCallValidateCmdSetColorBlendAdvancedEXT,
    InterceptIdPreCallRecordCmdSetColorBlendAdvancedEXT,
    InterceptIdPostCallRecordCmdSetColorBlendAdvancedEXT,
    InterceptIdPreCallValidateCmdSetProvokingVertexModeEXT,
    InterceptIdPreCallRecordCmdSetProvokingVertexModeEXT,
    InterceptIdPostCallRecordCmdSetProvokingVertexModeEXT,
    InterceptIdPreCallValidateCmdSetLineRasterizationModeEXT,
    InterceptIdPreCallRecordCmdSetLineRasterizationModeEXT,
    InterceptIdPostCallRecordCmdSetLineRasterizationModeEXT,
    InterceptIdPreCallValidateCmdSetLineStippleEnableEXT,
    InterceptIdPreCallRecordCmdSetLineStippleEnableEXT,
    InterceptIdPostCallRecordCmdSetLineStippleEnableEXT,
    InterceptIdPreCallValidateCmdSetDepthClipNegativeOneToOneEXT,
    InterceptIdPreCallRecordCmdSetDepthClipNegativeOneToOneEXT,
    InterceptIdPostCallRecordCmdSetDepthClipNegativeOneToOneEXT,
    InterceptIdPreCallValidateCmdSetViewportWScalingEnableNV,
    InterceptIdPreCallRecordCmdSetViewportWScalingEnableNV,
    InterceptIdPostCallRecordCmdSetViewportWScalingEnableNV,
    InterceptIdPreCallValidateCmdSetViewportSwizzleNV,
    InterceptIdPreCallRecordCmdSetViewportSwizzleNV,
    InterceptIdPostCallRecordCmdSetViewportSwizzleNV,
    InterceptIdPreCallValidateCmdSetCoverageToColorEnableNV,
    InterceptIdPreCallRecordCmdSetCoverageToColorEnableNV,
    InterceptIdPostCallRecordCmdSetCoverageToColorEnableNV,
    InterceptIdPreCallValidateCmdSetCoverageToColorLocationNV,
    InterceptIdPreCallRecordCmdSetCoverageToColorLocationNV,
    InterceptIdPostCallRecordCmdSetCoverageToColorLocationNV,
    InterceptIdPreCallValidateCmdSetCoverageModulationModeNV,
    InterceptIdPreCallRecordCmdSetCoverageModulationModeNV,
    InterceptIdPostCallRecordCmdSetCoverageModulationModeNV,
    InterceptIdPreCallValidateCmdSetCoverageModulationTableEnableNV,
    InterceptIdPreCallRecordCmdSetCoverageModulationTableEnableNV,
    InterceptIdPostCallRecordCmdSetCoverageModulationTableEnableNV,
    InterceptIdPreCallValidateCmdSetCoverageModulationTableNV,
    InterceptIdPreCallRecordCmdSetCoverageModulationTableNV,
    InterceptIdPostCallRecordCmdSetCoverageModulationTableNV,
    InterceptIdPreCallValidateCmdSetShadingRateImageEnableNV,
    InterceptIdPreCallRecordCmdSetShadingRateImageEnableNV,
    InterceptIdPostCallRecordCmdSetShadingRateImageEnableNV,
    InterceptIdPreCallValidateCmdSetRepresentativeFragmentTestEnableNV,
    InterceptIdPreCallRecordCmdSetRepresentativeFragmentTestEnableNV,
    InterceptIdPostCallRecordCmdSetRepresentativeFragmentTestEnableNV,
    InterceptIdPreCallValidateCmdSetCoverageReductionModeNV,
    InterceptIdPreCallRecordCmdSetCoverageReductionModeNV,
    InterceptIdPostCallRecordCmdSetCoverageReductionModeNV,
    InterceptIdPreCallValidateGetShaderModuleIdentifierEXT,
    InterceptIdPreCallRecordGetShaderModuleIdentifierEXT,
    InterceptIdPostCallRecordGetShaderModuleIdentifierEXT,
    InterceptIdPreCallValidateGetShaderModuleCreateInfoIdentifierEXT,
    InterceptIdPreCallRecordGetShaderModuleCreateInfoIdentifierEXT,
    InterceptIdPostCallRecordGetShaderModuleCreateInfoIdentifierEXT,
    InterceptIdPreCallValidateCreateOpticalFlowSessionNV,
    InterceptIdPreCallRecordCreateOpticalFlowSessionNV,
    InterceptIdPostCallRecordCreateOpticalFlowSessionNV,
    InterceptIdPreCallValidateDestroyOpticalFlowSessionNV,
    InterceptIdPreCallRecordDestroyOpticalFlowSessionNV,
    InterceptIdPostCallRecordDestroyOpticalFlowSessionNV,
    InterceptIdPreCallValidateBindOpticalFlowSessionImageNV,
    InterceptIdPreCallRecordBindOpticalFlowSessionImageNV,
    InterceptIdPostCallRecordBindOpticalFlowSessionImageNV,
    InterceptIdPreCallValidateCmdOpticalFlowExecuteNV,
    InterceptIdPreCallRecordCmdOpticalFlowExecuteNV,
    InterceptIdPostCallRecordCmdOpticalFlowExecuteNV,
    InterceptIdPreCallValidateAntiLagUpdateAMD,
    InterceptIdPreCallRecordAntiLagUpdateAMD,
    InterceptIdPostCallRecordAntiLagUpdateAMD,
    InterceptIdPreCallValidateDestroyShaderEXT,
    InterceptIdPreCallRecordDestroyShaderEXT,
    InterceptIdPostCallRecordDestroyShaderEXT,
    InterceptIdPreCallValidateGetShaderBinaryDataEXT,
    InterceptIdPreCallRecordGetShaderBinaryDataEXT,
    InterceptIdPostCallRecordGetShaderBinaryDataEXT,
    InterceptIdPreCallValidateCmdBindShadersEXT,
    InterceptIdPreCallRecordCmdBindShadersEXT,
    InterceptIdPostCallRecordCmdBindShadersEXT,
    InterceptIdPreCallValidateCmdSetDepthClampRangeEXT,
    InterceptIdPreCallRecordCmdSetDepthClampRangeEXT,
    InterceptIdPostCallRecordCmdSetDepthClampRangeEXT,
    InterceptIdPreCallValidateGetFramebufferTilePropertiesQCOM,
    InterceptIdPreCallRecordGetFramebufferTilePropertiesQCOM,
    InterceptIdPostCallRecordGetFramebufferTilePropertiesQCOM,
    InterceptIdPreCallValidateGetDynamicRenderingTilePropertiesQCOM,
    InterceptIdPreCallRecordGetDynamicRenderingTilePropertiesQCOM,
    InterceptIdPostCallRecordGetDynamicRenderingTilePropertiesQCOM,
    InterceptIdPreCallValidateSetLatencySleepModeNV,
    InterceptIdPreCallRecordSetLatencySleepModeNV,
    InterceptIdPostCallRecordSetLatencySleepModeNV,
    InterceptIdPreCallValidateLatencySleepNV,
    InterceptIdPreCallRecordLatencySleepNV,
    InterceptIdPostCallRecordLatencySleepNV,
    InterceptIdPreCallValidateSetLatencyMarkerNV,
    InterceptIdPreCallRecordSetLatencyMarkerNV,
    InterceptIdPostCallRecordSetLatencyMarkerNV,
    InterceptIdPreCallValidateGetLatencyTimingsNV,
    InterceptIdPreCallRecordGetLatencyTimingsNV,
    InterceptIdPostCallRecordGetLatencyTimingsNV,
    InterceptIdPreCallValidateQueueNotifyOutOfBandNV,
    InterceptIdPreCallRecordQueueNotifyOutOfBandNV,
    InterceptIdPostCallRecordQueueNotifyOutOfBandNV,
    InterceptIdPreCallValidateCmdSetAttachmentFeedbackLoopEnableEXT,
    InterceptIdPreCallRecordCmdSetAttachmentFeedbackLoopEnableEXT,
    InterceptIdPostCallRecordCmdSetAttachmentFeedbackLoopEnableEXT,
    InterceptIdPreCallValidateGetScreenBufferPropertiesQNX,
    InterceptIdPreCallRecordGetScreenBufferPropertiesQNX,
    InterceptIdPostCallRecordGetScreenBufferPropertiesQNX,
    InterceptIdPreCallValidateGetGeneratedCommandsMemoryRequirementsEXT,
    InterceptIdPreCallRecordGetGeneratedCommandsMemoryRequirementsEXT,
    InterceptIdPostCallRecordGetGeneratedCommandsMemoryRequirementsEXT,
    InterceptIdPreCallValidateCmdPreprocessGeneratedCommandsEXT,
    InterceptIdPreCallRecordCmdPreprocessGeneratedCommandsEXT,
    InterceptIdPostCallRecordCmdPreprocessGeneratedCommandsEXT,
    InterceptIdPreCallValidateCmdExecuteGeneratedCommandsEXT,
    InterceptIdPreCallRecordCmdExecuteGeneratedCommandsEXT,
    InterceptIdPostCallRecordCmdExecuteGeneratedCommandsEXT,
    InterceptIdPreCallValidateCreateIndirectCommandsLayoutEXT,
    InterceptIdPreCallRecordCreateIndirectCommandsLayoutEXT,
    InterceptIdPostCallRecordCreateIndirectCommandsLayoutEXT,
    InterceptIdPreCallValidateDestroyIndirectCommandsLayoutEXT,
    InterceptIdPreCallRecordDestroyIndirectCommandsLayoutEXT,
    InterceptIdPostCallRecordDestroyIndirectCommandsLayoutEXT,
    InterceptIdPreCallValidateCreateIndirectExecutionSetEXT,
    InterceptIdPreCallRecordCreateIndirectExecutionSetEXT,
    InterceptIdPostCallRecordCreateIndirectExecutionSetEXT,
    InterceptIdPreCallValidateDestroyIndirectExecutionSetEXT,
    InterceptIdPreCallRecordDestroyIndirectExecutionSetEXT,
    InterceptIdPostCallRecordDestroyIndirectExecutionSetEXT,
    InterceptIdPreCallValidateUpdateIndirectExecutionSetPipelineEXT,
    InterceptIdPreCallRecordUpdateIndirectExecutionSetPipelineEXT,
    InterceptIdPostCallRecordUpdateIndirectExecutionSetPipelineEXT,
    InterceptIdPreCallValidateUpdateIndirectExecutionSetShaderEXT,
    InterceptIdPreCallRecordUpdateIndirectExecutionSetShaderEXT,
    InterceptIdPostCallRecordUpdateIndirectExecutionSetShaderEXT,
    InterceptIdPreCallValidateCreateAccelerationStructureKHR,
    InterceptIdPreCallRecordCreateAccelerationStructureKHR,
    InterceptIdPostCallRecordCreateAccelerationStructureKHR,
    InterceptIdPreCallValidateDestroyAccelerationStructureKHR,
    InterceptIdPreCallRecordDestroyAccelerationStructureKHR,
    InterceptIdPostCallRecordDestroyAccelerationStructureKHR,
    InterceptIdPreCallValidateCmdBuildAccelerationStructuresKHR,
    InterceptIdPreCallRecordCmdBuildAccelerationStructuresKHR,
    InterceptIdPostCallRecordCmdBuildAccelerationStructuresKHR,
    InterceptIdPreCallValidateCmdBuildAccelerationStructuresIndirectKHR,
    InterceptIdPreCallRecordCmdBuildAccelerationStructuresIndirectKHR,
    InterceptIdPostCallRecordCmdBuildAccelerationStructuresIndirectKHR,
    InterceptIdPreCallValidateBuildAccelerationStructuresKHR,
    InterceptIdPreCallRecordBuildAccelerationStructuresKHR,
    InterceptIdPostCallRecordBuildAccelerationStructuresKHR,
    InterceptIdPreCallValidateCopyAccelerationStructureKHR,
    InterceptIdPreCallRecordCopyAccelerationStructureKHR,
    InterceptIdPostCallRecordCopyAccelerationStructureKHR,
    InterceptIdPreCallValidateCopyAccelerationStructureToMemoryKHR,
    InterceptIdPreCallRecordCopyAccelerationStructureToMemoryKHR,
    InterceptIdPostCallRecordCopyAccelerationStructureToMemoryKHR,
    InterceptIdPreCallValidateCopyMemoryToAccelerationStructureKHR,
    InterceptIdPreCallRecordCopyMemoryToAccelerationStructureKHR,
    InterceptIdPostCallRecordCopyMemoryToAccelerationStructureKHR,
    InterceptIdPreCallValidateWriteAccelerationStructuresPropertiesKHR,
    InterceptIdPreCallRecordWriteAccelerationStructuresPropertiesKHR,
    InterceptIdPostCallRecordWriteAccelerationStructuresPropertiesKHR,
    InterceptIdPreCallValidateCmdCopyAccelerationStructureKHR,
    InterceptIdPreCallRecordCmdCopyAccelerationStructureKHR,
    InterceptIdPostCallRecordCmdCopyAccelerationStructureKHR,
    InterceptIdPreCallValidateCmdCopyAccelerationStructureToMemoryKHR,
    InterceptIdPreCallRecordCmdCopyAccelerationStructureToMemoryKHR,
    InterceptIdPostCallRecordCmdCopyAccelerationStructureToMemoryKHR,
    InterceptIdPreCallValidateCmdCopyMemoryToAccelerationStructureKHR,
    InterceptIdPreCallRecordCmdCopyMemoryToAccelerationStructureKHR,
    InterceptIdPostCallRecordCmdCopyMemoryToAccelerationStructureKHR,
    InterceptIdPreCallValidateGetAccelerationStructureDeviceAddressKHR,
    InterceptIdPreCallRecordGetAccelerationStructureDeviceAddressKHR,
    InterceptIdPostCallRecordGetAccelerationStructureDeviceAddressKHR,
    InterceptIdPreCallValidateCmdWriteAccelerationStructuresPropertiesKHR,
    InterceptIdPreCallRecordCmdWriteAccelerationStructuresPropertiesKHR,
    InterceptIdPostCallRecordCmdWriteAccelerationStructuresPropertiesKHR,
    InterceptIdPreCallValidateGetDeviceAccelerationStructureCompatibilityKHR,
    InterceptIdPreCallRecordGetDeviceAccelerationStructureCompatibilityKHR,
    InterceptIdPostCallRecordGetDeviceAccelerationStructureCompatibilityKHR,
    InterceptIdPreCallValidateGetAccelerationStructureBuildSizesKHR,
    InterceptIdPreCallRecordGetAccelerationStructureBuildSizesKHR,
    InterceptIdPostCallRecordGetAccelerationStructureBuildSizesKHR,
    InterceptIdPreCallValidateCmdTraceRaysKHR,
    InterceptIdPreCallRecordCmdTraceRaysKHR,
    InterceptIdPostCallRecordCmdTraceRaysKHR,
    InterceptIdPreCallValidateGetRayTracingCaptureReplayShaderGroupHandlesKHR,
    InterceptIdPreCallRecordGetRayTracingCaptureReplayShaderGroupHandlesKHR,
    InterceptIdPostCallRecordGetRayTracingCaptureReplayShaderGroupHandlesKHR,
    InterceptIdPreCallValidateCmdTraceRaysIndirectKHR,
    InterceptIdPreCallRecordCmdTraceRaysIndirectKHR,
    InterceptIdPostCallRecordCmdTraceRaysIndirectKHR,
    InterceptIdPreCallValidateGetRayTracingShaderGroupStackSizeKHR,
    InterceptIdPreCallRecordGetRayTracingShaderGroupStackSizeKHR,
    InterceptIdPostCallRecordGetRayTracingShaderGroupStackSizeKHR,
    InterceptIdPreCallValidateCmdSetRayTracingPipelineStackSizeKHR,
    InterceptIdPreCallRecordCmdSetRayTracingPipelineStackSizeKHR,
    InterceptIdPostCallRecordCmdSetRayTracingPipelineStackSizeKHR,
    InterceptIdPreCallValidateCmdDrawMeshTasksEXT,
    InterceptIdPreCallRecordCmdDrawMeshTasksEXT,
    InterceptIdPostCallRecordCmdDrawMeshTasksEXT,
    InterceptIdPreCallValidateCmdDrawMeshTasksIndirectEXT,
    InterceptIdPreCallRecordCmdDrawMeshTasksIndirectEXT,
    InterceptIdPostCallRecordCmdDrawMeshTasksIndirectEXT,
    InterceptIdPreCallValidateCmdDrawMeshTasksIndirectCountEXT,
    InterceptIdPreCallRecordCmdDrawMeshTasksIndirectCountEXT,
    InterceptIdPostCallRecordCmdDrawMeshTasksIndirectCountEXT,
    InterceptIdCount,
} InterceptId;

// clang-format off
void ValidationObject::InitObjectDispatchVectors() {

#define BUILD_DISPATCH_VECTOR(name) \
    init_object_dispatch_vector(InterceptId ## name, \
                                typeid(&ValidationObject::name), \
                                typeid(&ThreadSafety::name), \
                                typeid(&StatelessValidation::name), \
                                typeid(&ObjectLifetimes::name), \
                                typeid(&CoreChecks::name), \
                                typeid(&BestPractices::name), \
                                typeid(&gpuav::Validator::name), \
                                typeid(&debug_printf::Validator::name), \
                                typeid(&SyncValidator::name));

    auto init_object_dispatch_vector = [this](InterceptId id,
                                              const std::type_info& vo_typeid,
                                              const std::type_info& tt_typeid,
                                              const std::type_info& tpv_typeid,
                                              const std::type_info& tot_typeid,
                                              const std::type_info& tcv_typeid,
                                              const std::type_info& tbp_typeid,
                                              const std::type_info& tga_typeid,
                                              const std::type_info& tdp_typeid,
                                              const std::type_info& tsv_typeid) {
        for (auto item : this->object_dispatch) {
            auto intercept_vector = &this->intercept_vectors[id];
            switch (item->container_type) {
            case LayerObjectTypeThreading:
                if (tt_typeid != vo_typeid) intercept_vector->push_back(item);
                break;
            case LayerObjectTypeParameterValidation:
                if (tpv_typeid != vo_typeid) intercept_vector->push_back(item);
                break;
            case LayerObjectTypeObjectTracker:
                if (tot_typeid != vo_typeid) intercept_vector->push_back(item);
                break;
            case LayerObjectTypeCoreValidation:
                if (tcv_typeid != vo_typeid) intercept_vector->push_back(item);
                break;
            case LayerObjectTypeBestPractices:
                if (tbp_typeid != vo_typeid) intercept_vector->push_back(item);
                break;
            case LayerObjectTypeGpuAssisted:
                if (tga_typeid != vo_typeid) intercept_vector->push_back(item);
                break;
            case LayerObjectTypeDebugPrintf:
                if (tdp_typeid != vo_typeid) intercept_vector->push_back(item);
                break;
            case LayerObjectTypeSyncValidation:
                if (tsv_typeid != vo_typeid) intercept_vector->push_back(item);
                break;
            case LayerObjectTypeInstance:
            case LayerObjectTypeDevice:
                break;
            default:
                /* Chassis codegen needs to be updated for unknown validation object type */
                assert(0);
            }
        }
    };
    // clang-format on

    intercept_vectors.resize(InterceptIdCount);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceQueue);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceQueue);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceQueue);
    BUILD_DISPATCH_VECTOR(PreCallValidateQueueSubmit);
    BUILD_DISPATCH_VECTOR(PreCallRecordQueueSubmit);
    BUILD_DISPATCH_VECTOR(PostCallRecordQueueSubmit);
    BUILD_DISPATCH_VECTOR(PreCallValidateQueueWaitIdle);
    BUILD_DISPATCH_VECTOR(PreCallRecordQueueWaitIdle);
    BUILD_DISPATCH_VECTOR(PostCallRecordQueueWaitIdle);
    BUILD_DISPATCH_VECTOR(PreCallValidateDeviceWaitIdle);
    BUILD_DISPATCH_VECTOR(PreCallRecordDeviceWaitIdle);
    BUILD_DISPATCH_VECTOR(PostCallRecordDeviceWaitIdle);
    BUILD_DISPATCH_VECTOR(PreCallValidateAllocateMemory);
    BUILD_DISPATCH_VECTOR(PreCallRecordAllocateMemory);
    BUILD_DISPATCH_VECTOR(PostCallRecordAllocateMemory);
    BUILD_DISPATCH_VECTOR(PreCallValidateFreeMemory);
    BUILD_DISPATCH_VECTOR(PreCallRecordFreeMemory);
    BUILD_DISPATCH_VECTOR(PostCallRecordFreeMemory);
    BUILD_DISPATCH_VECTOR(PreCallValidateMapMemory);
    BUILD_DISPATCH_VECTOR(PreCallRecordMapMemory);
    BUILD_DISPATCH_VECTOR(PostCallRecordMapMemory);
    BUILD_DISPATCH_VECTOR(PreCallValidateUnmapMemory);
    BUILD_DISPATCH_VECTOR(PreCallRecordUnmapMemory);
    BUILD_DISPATCH_VECTOR(PostCallRecordUnmapMemory);
    BUILD_DISPATCH_VECTOR(PreCallValidateFlushMappedMemoryRanges);
    BUILD_DISPATCH_VECTOR(PreCallRecordFlushMappedMemoryRanges);
    BUILD_DISPATCH_VECTOR(PostCallRecordFlushMappedMemoryRanges);
    BUILD_DISPATCH_VECTOR(PreCallValidateInvalidateMappedMemoryRanges);
    BUILD_DISPATCH_VECTOR(PreCallRecordInvalidateMappedMemoryRanges);
    BUILD_DISPATCH_VECTOR(PostCallRecordInvalidateMappedMemoryRanges);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceMemoryCommitment);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceMemoryCommitment);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceMemoryCommitment);
    BUILD_DISPATCH_VECTOR(PreCallValidateBindBufferMemory);
    BUILD_DISPATCH_VECTOR(PreCallRecordBindBufferMemory);
    BUILD_DISPATCH_VECTOR(PostCallRecordBindBufferMemory);
    BUILD_DISPATCH_VECTOR(PreCallValidateBindImageMemory);
    BUILD_DISPATCH_VECTOR(PreCallRecordBindImageMemory);
    BUILD_DISPATCH_VECTOR(PostCallRecordBindImageMemory);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetBufferMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetBufferMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetBufferMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageSparseMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageSparseMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageSparseMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PreCallValidateQueueBindSparse);
    BUILD_DISPATCH_VECTOR(PreCallRecordQueueBindSparse);
    BUILD_DISPATCH_VECTOR(PostCallRecordQueueBindSparse);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateFence);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateFence);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateFence);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyFence);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyFence);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyFence);
    BUILD_DISPATCH_VECTOR(PreCallValidateResetFences);
    BUILD_DISPATCH_VECTOR(PreCallRecordResetFences);
    BUILD_DISPATCH_VECTOR(PostCallRecordResetFences);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetFenceStatus);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetFenceStatus);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetFenceStatus);
    BUILD_DISPATCH_VECTOR(PreCallValidateWaitForFences);
    BUILD_DISPATCH_VECTOR(PreCallRecordWaitForFences);
    BUILD_DISPATCH_VECTOR(PostCallRecordWaitForFences);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateSemaphore);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateSemaphore);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateSemaphore);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroySemaphore);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroySemaphore);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroySemaphore);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateEvent);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateEvent);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateEvent);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyEvent);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyEvent);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyEvent);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetEventStatus);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetEventStatus);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetEventStatus);
    BUILD_DISPATCH_VECTOR(PreCallValidateSetEvent);
    BUILD_DISPATCH_VECTOR(PreCallRecordSetEvent);
    BUILD_DISPATCH_VECTOR(PostCallRecordSetEvent);
    BUILD_DISPATCH_VECTOR(PreCallValidateResetEvent);
    BUILD_DISPATCH_VECTOR(PreCallRecordResetEvent);
    BUILD_DISPATCH_VECTOR(PostCallRecordResetEvent);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateQueryPool);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateQueryPool);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateQueryPool);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyQueryPool);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyQueryPool);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyQueryPool);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetQueryPoolResults);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetQueryPoolResults);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetQueryPoolResults);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateBuffer);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateBuffer);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyBuffer);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyBuffer);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyBuffer);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateBufferView);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateBufferView);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateBufferView);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyBufferView);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyBufferView);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyBufferView);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateImage);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateImage);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateImage);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyImage);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyImage);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyImage);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageSubresourceLayout);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageSubresourceLayout);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageSubresourceLayout);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateImageView);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateImageView);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateImageView);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyImageView);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyImageView);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyImageView);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyShaderModule);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyShaderModule);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyShaderModule);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreatePipelineCache);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreatePipelineCache);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreatePipelineCache);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyPipelineCache);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyPipelineCache);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyPipelineCache);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPipelineCacheData);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPipelineCacheData);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPipelineCacheData);
    BUILD_DISPATCH_VECTOR(PreCallValidateMergePipelineCaches);
    BUILD_DISPATCH_VECTOR(PreCallRecordMergePipelineCaches);
    BUILD_DISPATCH_VECTOR(PostCallRecordMergePipelineCaches);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyPipeline);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyPipeline);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyPipeline);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreatePipelineLayout);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreatePipelineLayout);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyPipelineLayout);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyPipelineLayout);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyPipelineLayout);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateSampler);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateSampler);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateSampler);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroySampler);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroySampler);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroySampler);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateDescriptorSetLayout);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateDescriptorSetLayout);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateDescriptorSetLayout);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyDescriptorSetLayout);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyDescriptorSetLayout);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyDescriptorSetLayout);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateDescriptorPool);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateDescriptorPool);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateDescriptorPool);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyDescriptorPool);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyDescriptorPool);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyDescriptorPool);
    BUILD_DISPATCH_VECTOR(PreCallValidateResetDescriptorPool);
    BUILD_DISPATCH_VECTOR(PreCallRecordResetDescriptorPool);
    BUILD_DISPATCH_VECTOR(PostCallRecordResetDescriptorPool);
    BUILD_DISPATCH_VECTOR(PreCallRecordAllocateDescriptorSets);
    BUILD_DISPATCH_VECTOR(PreCallValidateFreeDescriptorSets);
    BUILD_DISPATCH_VECTOR(PreCallRecordFreeDescriptorSets);
    BUILD_DISPATCH_VECTOR(PostCallRecordFreeDescriptorSets);
    BUILD_DISPATCH_VECTOR(PreCallValidateUpdateDescriptorSets);
    BUILD_DISPATCH_VECTOR(PreCallRecordUpdateDescriptorSets);
    BUILD_DISPATCH_VECTOR(PostCallRecordUpdateDescriptorSets);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateFramebuffer);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateFramebuffer);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateFramebuffer);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyFramebuffer);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyFramebuffer);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyFramebuffer);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateRenderPass);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateRenderPass);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateRenderPass);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyRenderPass);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyRenderPass);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyRenderPass);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetRenderAreaGranularity);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetRenderAreaGranularity);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetRenderAreaGranularity);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateCommandPool);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateCommandPool);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateCommandPool);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyCommandPool);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyCommandPool);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyCommandPool);
    BUILD_DISPATCH_VECTOR(PreCallValidateResetCommandPool);
    BUILD_DISPATCH_VECTOR(PreCallRecordResetCommandPool);
    BUILD_DISPATCH_VECTOR(PostCallRecordResetCommandPool);
    BUILD_DISPATCH_VECTOR(PreCallValidateAllocateCommandBuffers);
    BUILD_DISPATCH_VECTOR(PreCallRecordAllocateCommandBuffers);
    BUILD_DISPATCH_VECTOR(PostCallRecordAllocateCommandBuffers);
    BUILD_DISPATCH_VECTOR(PreCallValidateFreeCommandBuffers);
    BUILD_DISPATCH_VECTOR(PreCallRecordFreeCommandBuffers);
    BUILD_DISPATCH_VECTOR(PostCallRecordFreeCommandBuffers);
    BUILD_DISPATCH_VECTOR(PreCallValidateBeginCommandBuffer);
    BUILD_DISPATCH_VECTOR(PreCallRecordBeginCommandBuffer);
    BUILD_DISPATCH_VECTOR(PostCallRecordBeginCommandBuffer);
    BUILD_DISPATCH_VECTOR(PreCallValidateEndCommandBuffer);
    BUILD_DISPATCH_VECTOR(PreCallRecordEndCommandBuffer);
    BUILD_DISPATCH_VECTOR(PostCallRecordEndCommandBuffer);
    BUILD_DISPATCH_VECTOR(PreCallValidateResetCommandBuffer);
    BUILD_DISPATCH_VECTOR(PreCallRecordResetCommandBuffer);
    BUILD_DISPATCH_VECTOR(PostCallRecordResetCommandBuffer);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindPipeline);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindPipeline);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindPipeline);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetViewport);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetViewport);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetViewport);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetScissor);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetScissor);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetScissor);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetLineWidth);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetLineWidth);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetLineWidth);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthBias);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthBias);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthBias);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetBlendConstants);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetBlendConstants);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetBlendConstants);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthBounds);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthBounds);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthBounds);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetStencilCompareMask);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetStencilCompareMask);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetStencilCompareMask);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetStencilWriteMask);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetStencilWriteMask);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetStencilWriteMask);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetStencilReference);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetStencilReference);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetStencilReference);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindDescriptorSets);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindDescriptorSets);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindDescriptorSets);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindIndexBuffer);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindIndexBuffer);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindIndexBuffer);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindVertexBuffers);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindVertexBuffers);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindVertexBuffers);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDraw);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDraw);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDraw);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawIndexed);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawIndexed);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawIndexed);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawIndirect);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawIndirect);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawIndirect);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawIndexedIndirect);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawIndexedIndirect);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawIndexedIndirect);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDispatch);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDispatch);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDispatch);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDispatchIndirect);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDispatchIndirect);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDispatchIndirect);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyBuffer);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyBuffer);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyBuffer);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyImage);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyImage);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyImage);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBlitImage);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBlitImage);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBlitImage);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyBufferToImage);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyBufferToImage);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyBufferToImage);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyImageToBuffer);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyImageToBuffer);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyImageToBuffer);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdUpdateBuffer);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdUpdateBuffer);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdUpdateBuffer);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdFillBuffer);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdFillBuffer);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdFillBuffer);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdClearColorImage);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdClearColorImage);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdClearColorImage);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdClearDepthStencilImage);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdClearDepthStencilImage);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdClearDepthStencilImage);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdClearAttachments);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdClearAttachments);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdClearAttachments);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdResolveImage);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdResolveImage);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdResolveImage);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetEvent);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetEvent);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetEvent);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdResetEvent);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdResetEvent);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdResetEvent);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdWaitEvents);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdWaitEvents);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdWaitEvents);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdPipelineBarrier);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdPipelineBarrier);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdPipelineBarrier);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBeginQuery);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBeginQuery);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBeginQuery);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdEndQuery);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdEndQuery);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdEndQuery);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdResetQueryPool);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdResetQueryPool);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdResetQueryPool);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdWriteTimestamp);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdWriteTimestamp);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdWriteTimestamp);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyQueryPoolResults);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyQueryPoolResults);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyQueryPoolResults);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdPushConstants);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdPushConstants);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdPushConstants);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBeginRenderPass);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBeginRenderPass);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBeginRenderPass);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdNextSubpass);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdNextSubpass);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdNextSubpass);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdEndRenderPass);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdEndRenderPass);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdEndRenderPass);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdExecuteCommands);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdExecuteCommands);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdExecuteCommands);
    BUILD_DISPATCH_VECTOR(PreCallValidateBindBufferMemory2);
    BUILD_DISPATCH_VECTOR(PreCallRecordBindBufferMemory2);
    BUILD_DISPATCH_VECTOR(PostCallRecordBindBufferMemory2);
    BUILD_DISPATCH_VECTOR(PreCallValidateBindImageMemory2);
    BUILD_DISPATCH_VECTOR(PreCallRecordBindImageMemory2);
    BUILD_DISPATCH_VECTOR(PostCallRecordBindImageMemory2);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceGroupPeerMemoryFeatures);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceGroupPeerMemoryFeatures);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceGroupPeerMemoryFeatures);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDeviceMask);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDeviceMask);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDeviceMask);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDispatchBase);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDispatchBase);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDispatchBase);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageMemoryRequirements2);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageMemoryRequirements2);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageMemoryRequirements2);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetBufferMemoryRequirements2);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetBufferMemoryRequirements2);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetBufferMemoryRequirements2);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageSparseMemoryRequirements2);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageSparseMemoryRequirements2);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageSparseMemoryRequirements2);
    BUILD_DISPATCH_VECTOR(PreCallValidateTrimCommandPool);
    BUILD_DISPATCH_VECTOR(PreCallRecordTrimCommandPool);
    BUILD_DISPATCH_VECTOR(PostCallRecordTrimCommandPool);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceQueue2);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceQueue2);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceQueue2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateSamplerYcbcrConversion);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateSamplerYcbcrConversion);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateSamplerYcbcrConversion);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroySamplerYcbcrConversion);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroySamplerYcbcrConversion);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroySamplerYcbcrConversion);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateDescriptorUpdateTemplate);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateDescriptorUpdateTemplate);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateDescriptorUpdateTemplate);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyDescriptorUpdateTemplate);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyDescriptorUpdateTemplate);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyDescriptorUpdateTemplate);
    BUILD_DISPATCH_VECTOR(PreCallValidateUpdateDescriptorSetWithTemplate);
    BUILD_DISPATCH_VECTOR(PreCallRecordUpdateDescriptorSetWithTemplate);
    BUILD_DISPATCH_VECTOR(PostCallRecordUpdateDescriptorSetWithTemplate);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDescriptorSetLayoutSupport);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDescriptorSetLayoutSupport);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDescriptorSetLayoutSupport);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawIndirectCount);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawIndirectCount);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawIndirectCount);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawIndexedIndirectCount);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawIndexedIndirectCount);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawIndexedIndirectCount);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateRenderPass2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateRenderPass2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateRenderPass2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBeginRenderPass2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBeginRenderPass2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBeginRenderPass2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdNextSubpass2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdNextSubpass2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdNextSubpass2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdEndRenderPass2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdEndRenderPass2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdEndRenderPass2);
    BUILD_DISPATCH_VECTOR(PreCallValidateResetQueryPool);
    BUILD_DISPATCH_VECTOR(PreCallRecordResetQueryPool);
    BUILD_DISPATCH_VECTOR(PostCallRecordResetQueryPool);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetSemaphoreCounterValue);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetSemaphoreCounterValue);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetSemaphoreCounterValue);
    BUILD_DISPATCH_VECTOR(PreCallValidateWaitSemaphores);
    BUILD_DISPATCH_VECTOR(PreCallRecordWaitSemaphores);
    BUILD_DISPATCH_VECTOR(PostCallRecordWaitSemaphores);
    BUILD_DISPATCH_VECTOR(PreCallValidateSignalSemaphore);
    BUILD_DISPATCH_VECTOR(PreCallRecordSignalSemaphore);
    BUILD_DISPATCH_VECTOR(PostCallRecordSignalSemaphore);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetBufferDeviceAddress);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetBufferDeviceAddress);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetBufferDeviceAddress);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetBufferOpaqueCaptureAddress);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetBufferOpaqueCaptureAddress);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetBufferOpaqueCaptureAddress);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceMemoryOpaqueCaptureAddress);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceMemoryOpaqueCaptureAddress);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceMemoryOpaqueCaptureAddress);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreatePrivateDataSlot);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreatePrivateDataSlot);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreatePrivateDataSlot);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyPrivateDataSlot);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyPrivateDataSlot);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyPrivateDataSlot);
    BUILD_DISPATCH_VECTOR(PreCallValidateSetPrivateData);
    BUILD_DISPATCH_VECTOR(PreCallRecordSetPrivateData);
    BUILD_DISPATCH_VECTOR(PostCallRecordSetPrivateData);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPrivateData);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPrivateData);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPrivateData);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetEvent2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetEvent2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetEvent2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdResetEvent2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdResetEvent2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdResetEvent2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdWaitEvents2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdWaitEvents2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdWaitEvents2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdPipelineBarrier2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdPipelineBarrier2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdPipelineBarrier2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdWriteTimestamp2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdWriteTimestamp2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdWriteTimestamp2);
    BUILD_DISPATCH_VECTOR(PreCallValidateQueueSubmit2);
    BUILD_DISPATCH_VECTOR(PreCallRecordQueueSubmit2);
    BUILD_DISPATCH_VECTOR(PostCallRecordQueueSubmit2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyBuffer2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyBuffer2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyBuffer2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyImage2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyImage2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyImage2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyBufferToImage2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyBufferToImage2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyBufferToImage2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyImageToBuffer2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyImageToBuffer2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyImageToBuffer2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBlitImage2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBlitImage2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBlitImage2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdResolveImage2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdResolveImage2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdResolveImage2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBeginRendering);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBeginRendering);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBeginRendering);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdEndRendering);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdEndRendering);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdEndRendering);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetCullMode);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetCullMode);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetCullMode);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetFrontFace);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetFrontFace);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetFrontFace);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetPrimitiveTopology);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetPrimitiveTopology);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetPrimitiveTopology);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetViewportWithCount);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetViewportWithCount);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetViewportWithCount);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetScissorWithCount);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetScissorWithCount);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetScissorWithCount);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindVertexBuffers2);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindVertexBuffers2);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindVertexBuffers2);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthTestEnable);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthTestEnable);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthTestEnable);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthWriteEnable);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthWriteEnable);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthWriteEnable);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthCompareOp);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthCompareOp);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthCompareOp);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthBoundsTestEnable);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthBoundsTestEnable);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthBoundsTestEnable);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetStencilTestEnable);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetStencilTestEnable);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetStencilTestEnable);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetStencilOp);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetStencilOp);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetStencilOp);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetRasterizerDiscardEnable);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetRasterizerDiscardEnable);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetRasterizerDiscardEnable);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthBiasEnable);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthBiasEnable);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthBiasEnable);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetPrimitiveRestartEnable);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetPrimitiveRestartEnable);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetPrimitiveRestartEnable);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceBufferMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceBufferMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceBufferMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceImageMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceImageMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceImageMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceImageSparseMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceImageSparseMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceImageSparseMemoryRequirements);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateSwapchainKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateSwapchainKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateSwapchainKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroySwapchainKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroySwapchainKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroySwapchainKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetSwapchainImagesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetSwapchainImagesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetSwapchainImagesKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateAcquireNextImageKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordAcquireNextImageKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordAcquireNextImageKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateQueuePresentKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordQueuePresentKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordQueuePresentKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceGroupPresentCapabilitiesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceGroupPresentCapabilitiesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceGroupPresentCapabilitiesKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceGroupSurfacePresentModesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceGroupSurfacePresentModesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceGroupSurfacePresentModesKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateAcquireNextImage2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordAcquireNextImage2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordAcquireNextImage2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateSharedSwapchainsKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateSharedSwapchainsKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateSharedSwapchainsKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateVideoSessionKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateVideoSessionKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateVideoSessionKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyVideoSessionKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyVideoSessionKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyVideoSessionKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetVideoSessionMemoryRequirementsKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetVideoSessionMemoryRequirementsKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetVideoSessionMemoryRequirementsKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateBindVideoSessionMemoryKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordBindVideoSessionMemoryKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordBindVideoSessionMemoryKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateVideoSessionParametersKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateVideoSessionParametersKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateVideoSessionParametersKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateUpdateVideoSessionParametersKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordUpdateVideoSessionParametersKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordUpdateVideoSessionParametersKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyVideoSessionParametersKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyVideoSessionParametersKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyVideoSessionParametersKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBeginVideoCodingKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBeginVideoCodingKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBeginVideoCodingKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdEndVideoCodingKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdEndVideoCodingKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdEndVideoCodingKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdControlVideoCodingKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdControlVideoCodingKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdControlVideoCodingKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDecodeVideoKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDecodeVideoKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDecodeVideoKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBeginRenderingKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBeginRenderingKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBeginRenderingKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdEndRenderingKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdEndRenderingKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdEndRenderingKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceGroupPeerMemoryFeaturesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceGroupPeerMemoryFeaturesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceGroupPeerMemoryFeaturesKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDeviceMaskKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDeviceMaskKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDeviceMaskKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDispatchBaseKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDispatchBaseKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDispatchBaseKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateTrimCommandPoolKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordTrimCommandPoolKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordTrimCommandPoolKHR);
#ifdef VK_USE_PLATFORM_WIN32_KHR
    BUILD_DISPATCH_VECTOR(PreCallValidateGetMemoryWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetMemoryWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetMemoryWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetMemoryWin32HandlePropertiesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetMemoryWin32HandlePropertiesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetMemoryWin32HandlePropertiesKHR);
#endif  // VK_USE_PLATFORM_WIN32_KHR
    BUILD_DISPATCH_VECTOR(PreCallValidateGetMemoryFdKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetMemoryFdKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetMemoryFdKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetMemoryFdPropertiesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetMemoryFdPropertiesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetMemoryFdPropertiesKHR);
#ifdef VK_USE_PLATFORM_WIN32_KHR
    BUILD_DISPATCH_VECTOR(PreCallValidateImportSemaphoreWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordImportSemaphoreWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordImportSemaphoreWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetSemaphoreWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetSemaphoreWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetSemaphoreWin32HandleKHR);
#endif  // VK_USE_PLATFORM_WIN32_KHR
    BUILD_DISPATCH_VECTOR(PreCallValidateImportSemaphoreFdKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordImportSemaphoreFdKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordImportSemaphoreFdKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetSemaphoreFdKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetSemaphoreFdKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetSemaphoreFdKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdPushDescriptorSetKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdPushDescriptorSetKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdPushDescriptorSetKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdPushDescriptorSetWithTemplateKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdPushDescriptorSetWithTemplateKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdPushDescriptorSetWithTemplateKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateDescriptorUpdateTemplateKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateDescriptorUpdateTemplateKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateDescriptorUpdateTemplateKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyDescriptorUpdateTemplateKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyDescriptorUpdateTemplateKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyDescriptorUpdateTemplateKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateUpdateDescriptorSetWithTemplateKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordUpdateDescriptorSetWithTemplateKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordUpdateDescriptorSetWithTemplateKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateRenderPass2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateRenderPass2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateRenderPass2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBeginRenderPass2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBeginRenderPass2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBeginRenderPass2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdNextSubpass2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdNextSubpass2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdNextSubpass2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdEndRenderPass2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdEndRenderPass2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdEndRenderPass2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetSwapchainStatusKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetSwapchainStatusKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetSwapchainStatusKHR);
#ifdef VK_USE_PLATFORM_WIN32_KHR
    BUILD_DISPATCH_VECTOR(PreCallValidateImportFenceWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordImportFenceWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordImportFenceWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetFenceWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetFenceWin32HandleKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetFenceWin32HandleKHR);
#endif  // VK_USE_PLATFORM_WIN32_KHR
    BUILD_DISPATCH_VECTOR(PreCallValidateImportFenceFdKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordImportFenceFdKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordImportFenceFdKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetFenceFdKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetFenceFdKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetFenceFdKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateAcquireProfilingLockKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordAcquireProfilingLockKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordAcquireProfilingLockKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateReleaseProfilingLockKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordReleaseProfilingLockKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordReleaseProfilingLockKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageMemoryRequirements2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageMemoryRequirements2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageMemoryRequirements2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetBufferMemoryRequirements2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetBufferMemoryRequirements2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetBufferMemoryRequirements2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageSparseMemoryRequirements2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageSparseMemoryRequirements2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageSparseMemoryRequirements2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateSamplerYcbcrConversionKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateSamplerYcbcrConversionKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateSamplerYcbcrConversionKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroySamplerYcbcrConversionKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroySamplerYcbcrConversionKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroySamplerYcbcrConversionKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateBindBufferMemory2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordBindBufferMemory2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordBindBufferMemory2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateBindImageMemory2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordBindImageMemory2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordBindImageMemory2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDescriptorSetLayoutSupportKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDescriptorSetLayoutSupportKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDescriptorSetLayoutSupportKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawIndirectCountKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawIndirectCountKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawIndirectCountKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawIndexedIndirectCountKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawIndexedIndirectCountKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawIndexedIndirectCountKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetSemaphoreCounterValueKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetSemaphoreCounterValueKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetSemaphoreCounterValueKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateWaitSemaphoresKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordWaitSemaphoresKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordWaitSemaphoresKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateSignalSemaphoreKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordSignalSemaphoreKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordSignalSemaphoreKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetFragmentShadingRateKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetFragmentShadingRateKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetFragmentShadingRateKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetRenderingAttachmentLocationsKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetRenderingAttachmentLocationsKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetRenderingAttachmentLocationsKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetRenderingInputAttachmentIndicesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetRenderingInputAttachmentIndicesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetRenderingInputAttachmentIndicesKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateWaitForPresentKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordWaitForPresentKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordWaitForPresentKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetBufferDeviceAddressKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetBufferDeviceAddressKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetBufferDeviceAddressKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetBufferOpaqueCaptureAddressKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetBufferOpaqueCaptureAddressKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetBufferOpaqueCaptureAddressKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceMemoryOpaqueCaptureAddressKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateDeferredOperationKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateDeferredOperationKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateDeferredOperationKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyDeferredOperationKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyDeferredOperationKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyDeferredOperationKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeferredOperationMaxConcurrencyKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeferredOperationMaxConcurrencyKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeferredOperationMaxConcurrencyKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeferredOperationResultKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeferredOperationResultKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeferredOperationResultKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateDeferredOperationJoinKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordDeferredOperationJoinKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordDeferredOperationJoinKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPipelineExecutablePropertiesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPipelineExecutablePropertiesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPipelineExecutablePropertiesKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPipelineExecutableStatisticsKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPipelineExecutableStatisticsKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPipelineExecutableStatisticsKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPipelineExecutableInternalRepresentationsKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPipelineExecutableInternalRepresentationsKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPipelineExecutableInternalRepresentationsKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateMapMemory2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordMapMemory2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordMapMemory2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateUnmapMemory2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordUnmapMemory2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordUnmapMemory2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetEncodedVideoSessionParametersKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetEncodedVideoSessionParametersKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetEncodedVideoSessionParametersKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdEncodeVideoKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdEncodeVideoKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdEncodeVideoKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetEvent2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetEvent2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetEvent2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdResetEvent2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdResetEvent2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdResetEvent2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdWaitEvents2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdWaitEvents2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdWaitEvents2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdPipelineBarrier2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdPipelineBarrier2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdPipelineBarrier2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdWriteTimestamp2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdWriteTimestamp2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdWriteTimestamp2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateQueueSubmit2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordQueueSubmit2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordQueueSubmit2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdWriteBufferMarker2AMD);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdWriteBufferMarker2AMD);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdWriteBufferMarker2AMD);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetQueueCheckpointData2NV);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetQueueCheckpointData2NV);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetQueueCheckpointData2NV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyBuffer2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyBuffer2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyBuffer2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyImage2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyImage2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyImage2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyBufferToImage2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyBufferToImage2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyBufferToImage2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyImageToBuffer2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyImageToBuffer2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyImageToBuffer2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBlitImage2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBlitImage2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBlitImage2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdResolveImage2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdResolveImage2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdResolveImage2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdTraceRaysIndirect2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdTraceRaysIndirect2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdTraceRaysIndirect2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceBufferMemoryRequirementsKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceBufferMemoryRequirementsKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceBufferMemoryRequirementsKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceImageMemoryRequirementsKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceImageMemoryRequirementsKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceImageMemoryRequirementsKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceImageSparseMemoryRequirementsKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceImageSparseMemoryRequirementsKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceImageSparseMemoryRequirementsKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindIndexBuffer2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindIndexBuffer2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindIndexBuffer2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetRenderingAreaGranularityKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetRenderingAreaGranularityKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetRenderingAreaGranularityKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceImageSubresourceLayoutKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceImageSubresourceLayoutKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceImageSubresourceLayoutKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageSubresourceLayout2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageSubresourceLayout2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageSubresourceLayout2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreatePipelineBinariesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreatePipelineBinariesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreatePipelineBinariesKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyPipelineBinaryKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyPipelineBinaryKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyPipelineBinaryKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPipelineKeyKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPipelineKeyKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPipelineKeyKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPipelineBinaryDataKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPipelineBinaryDataKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPipelineBinaryDataKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateReleaseCapturedPipelineDataKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordReleaseCapturedPipelineDataKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordReleaseCapturedPipelineDataKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetLineStippleKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetLineStippleKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetLineStippleKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetCalibratedTimestampsKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetCalibratedTimestampsKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetCalibratedTimestampsKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindDescriptorSets2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindDescriptorSets2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindDescriptorSets2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdPushConstants2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdPushConstants2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdPushConstants2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdPushDescriptorSet2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdPushDescriptorSet2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdPushDescriptorSet2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdPushDescriptorSetWithTemplate2KHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdPushDescriptorSetWithTemplate2KHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdPushDescriptorSetWithTemplate2KHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDescriptorBufferOffsets2EXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDescriptorBufferOffsets2EXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDescriptorBufferOffsets2EXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindDescriptorBufferEmbeddedSamplers2EXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateDebugMarkerSetObjectTagEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordDebugMarkerSetObjectTagEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordDebugMarkerSetObjectTagEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateDebugMarkerSetObjectNameEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordDebugMarkerSetObjectNameEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordDebugMarkerSetObjectNameEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDebugMarkerBeginEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDebugMarkerBeginEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDebugMarkerBeginEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDebugMarkerEndEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDebugMarkerEndEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDebugMarkerEndEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDebugMarkerInsertEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDebugMarkerInsertEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDebugMarkerInsertEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindTransformFeedbackBuffersEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindTransformFeedbackBuffersEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindTransformFeedbackBuffersEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBeginTransformFeedbackEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBeginTransformFeedbackEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBeginTransformFeedbackEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdEndTransformFeedbackEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdEndTransformFeedbackEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdEndTransformFeedbackEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBeginQueryIndexedEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBeginQueryIndexedEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBeginQueryIndexedEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdEndQueryIndexedEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdEndQueryIndexedEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdEndQueryIndexedEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawIndirectByteCountEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawIndirectByteCountEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawIndirectByteCountEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateCuModuleNVX);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateCuModuleNVX);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateCuModuleNVX);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateCuFunctionNVX);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateCuFunctionNVX);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateCuFunctionNVX);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyCuModuleNVX);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyCuModuleNVX);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyCuModuleNVX);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyCuFunctionNVX);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyCuFunctionNVX);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyCuFunctionNVX);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCuLaunchKernelNVX);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCuLaunchKernelNVX);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCuLaunchKernelNVX);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageViewHandleNVX);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageViewHandleNVX);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageViewHandleNVX);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageViewAddressNVX);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageViewAddressNVX);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageViewAddressNVX);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawIndirectCountAMD);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawIndirectCountAMD);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawIndirectCountAMD);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawIndexedIndirectCountAMD);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawIndexedIndirectCountAMD);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawIndexedIndirectCountAMD);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetShaderInfoAMD);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetShaderInfoAMD);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetShaderInfoAMD);
#ifdef VK_USE_PLATFORM_WIN32_KHR
    BUILD_DISPATCH_VECTOR(PreCallValidateGetMemoryWin32HandleNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetMemoryWin32HandleNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetMemoryWin32HandleNV);
#endif  // VK_USE_PLATFORM_WIN32_KHR
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBeginConditionalRenderingEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBeginConditionalRenderingEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBeginConditionalRenderingEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdEndConditionalRenderingEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdEndConditionalRenderingEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdEndConditionalRenderingEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetViewportWScalingNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetViewportWScalingNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetViewportWScalingNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateDisplayPowerControlEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordDisplayPowerControlEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordDisplayPowerControlEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateRegisterDeviceEventEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordRegisterDeviceEventEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordRegisterDeviceEventEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateRegisterDisplayEventEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordRegisterDisplayEventEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordRegisterDisplayEventEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetSwapchainCounterEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetSwapchainCounterEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetSwapchainCounterEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetRefreshCycleDurationGOOGLE);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetRefreshCycleDurationGOOGLE);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetRefreshCycleDurationGOOGLE);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPastPresentationTimingGOOGLE);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPastPresentationTimingGOOGLE);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPastPresentationTimingGOOGLE);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDiscardRectangleEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDiscardRectangleEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDiscardRectangleEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDiscardRectangleEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDiscardRectangleEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDiscardRectangleEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDiscardRectangleModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDiscardRectangleModeEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDiscardRectangleModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateSetHdrMetadataEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordSetHdrMetadataEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordSetHdrMetadataEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateSetDebugUtilsObjectNameEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordSetDebugUtilsObjectNameEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordSetDebugUtilsObjectNameEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateSetDebugUtilsObjectTagEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordSetDebugUtilsObjectTagEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordSetDebugUtilsObjectTagEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateQueueBeginDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordQueueBeginDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordQueueBeginDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateQueueEndDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordQueueEndDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordQueueEndDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateQueueInsertDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordQueueInsertDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordQueueInsertDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBeginDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBeginDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBeginDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdEndDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdEndDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdEndDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdInsertDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdInsertDebugUtilsLabelEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdInsertDebugUtilsLabelEXT);
#ifdef VK_USE_PLATFORM_ANDROID_KHR
    BUILD_DISPATCH_VECTOR(PreCallValidateGetAndroidHardwareBufferPropertiesANDROID);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetAndroidHardwareBufferPropertiesANDROID);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetAndroidHardwareBufferPropertiesANDROID);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetMemoryAndroidHardwareBufferANDROID);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetMemoryAndroidHardwareBufferANDROID);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetMemoryAndroidHardwareBufferANDROID);
#endif  // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_ENABLE_BETA_EXTENSIONS
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateExecutionGraphPipelinesAMDX);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateExecutionGraphPipelinesAMDX);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateExecutionGraphPipelinesAMDX);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetExecutionGraphPipelineScratchSizeAMDX);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetExecutionGraphPipelineScratchSizeAMDX);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetExecutionGraphPipelineScratchSizeAMDX);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetExecutionGraphPipelineNodeIndexAMDX);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetExecutionGraphPipelineNodeIndexAMDX);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetExecutionGraphPipelineNodeIndexAMDX);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdInitializeGraphScratchMemoryAMDX);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdInitializeGraphScratchMemoryAMDX);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdInitializeGraphScratchMemoryAMDX);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDispatchGraphAMDX);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDispatchGraphAMDX);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDispatchGraphAMDX);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDispatchGraphIndirectAMDX);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDispatchGraphIndirectAMDX);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDispatchGraphIndirectAMDX);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDispatchGraphIndirectCountAMDX);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDispatchGraphIndirectCountAMDX);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDispatchGraphIndirectCountAMDX);
#endif  // VK_ENABLE_BETA_EXTENSIONS
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetSampleLocationsEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetSampleLocationsEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetSampleLocationsEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageDrmFormatModifierPropertiesEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageDrmFormatModifierPropertiesEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageDrmFormatModifierPropertiesEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindShadingRateImageNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindShadingRateImageNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindShadingRateImageNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetViewportShadingRatePaletteNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetViewportShadingRatePaletteNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetViewportShadingRatePaletteNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetCoarseSampleOrderNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetCoarseSampleOrderNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetCoarseSampleOrderNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateAccelerationStructureNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateAccelerationStructureNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateAccelerationStructureNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyAccelerationStructureNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyAccelerationStructureNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyAccelerationStructureNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetAccelerationStructureMemoryRequirementsNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetAccelerationStructureMemoryRequirementsNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetAccelerationStructureMemoryRequirementsNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateBindAccelerationStructureMemoryNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordBindAccelerationStructureMemoryNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordBindAccelerationStructureMemoryNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBuildAccelerationStructureNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBuildAccelerationStructureNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBuildAccelerationStructureNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyAccelerationStructureNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyAccelerationStructureNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyAccelerationStructureNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdTraceRaysNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdTraceRaysNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdTraceRaysNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetRayTracingShaderGroupHandlesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetRayTracingShaderGroupHandlesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetRayTracingShaderGroupHandlesKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetRayTracingShaderGroupHandlesNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetRayTracingShaderGroupHandlesNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetRayTracingShaderGroupHandlesNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetAccelerationStructureHandleNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetAccelerationStructureHandleNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetAccelerationStructureHandleNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdWriteAccelerationStructuresPropertiesNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdWriteAccelerationStructuresPropertiesNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdWriteAccelerationStructuresPropertiesNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCompileDeferredNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCompileDeferredNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCompileDeferredNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetMemoryHostPointerPropertiesEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetMemoryHostPointerPropertiesEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetMemoryHostPointerPropertiesEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdWriteBufferMarkerAMD);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdWriteBufferMarkerAMD);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdWriteBufferMarkerAMD);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetCalibratedTimestampsEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetCalibratedTimestampsEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetCalibratedTimestampsEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawMeshTasksNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawMeshTasksNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawMeshTasksNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawMeshTasksIndirectNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawMeshTasksIndirectNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawMeshTasksIndirectNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawMeshTasksIndirectCountNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawMeshTasksIndirectCountNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawMeshTasksIndirectCountNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetExclusiveScissorEnableNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetExclusiveScissorEnableNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetExclusiveScissorEnableNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetExclusiveScissorNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetExclusiveScissorNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetExclusiveScissorNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetCheckpointNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetCheckpointNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetCheckpointNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetQueueCheckpointDataNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetQueueCheckpointDataNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetQueueCheckpointDataNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateInitializePerformanceApiINTEL);
    BUILD_DISPATCH_VECTOR(PreCallRecordInitializePerformanceApiINTEL);
    BUILD_DISPATCH_VECTOR(PostCallRecordInitializePerformanceApiINTEL);
    BUILD_DISPATCH_VECTOR(PreCallValidateUninitializePerformanceApiINTEL);
    BUILD_DISPATCH_VECTOR(PreCallRecordUninitializePerformanceApiINTEL);
    BUILD_DISPATCH_VECTOR(PostCallRecordUninitializePerformanceApiINTEL);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetPerformanceMarkerINTEL);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetPerformanceMarkerINTEL);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetPerformanceMarkerINTEL);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetPerformanceStreamMarkerINTEL);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetPerformanceStreamMarkerINTEL);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetPerformanceStreamMarkerINTEL);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetPerformanceOverrideINTEL);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetPerformanceOverrideINTEL);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetPerformanceOverrideINTEL);
    BUILD_DISPATCH_VECTOR(PreCallValidateAcquirePerformanceConfigurationINTEL);
    BUILD_DISPATCH_VECTOR(PreCallRecordAcquirePerformanceConfigurationINTEL);
    BUILD_DISPATCH_VECTOR(PostCallRecordAcquirePerformanceConfigurationINTEL);
    BUILD_DISPATCH_VECTOR(PreCallValidateReleasePerformanceConfigurationINTEL);
    BUILD_DISPATCH_VECTOR(PreCallRecordReleasePerformanceConfigurationINTEL);
    BUILD_DISPATCH_VECTOR(PostCallRecordReleasePerformanceConfigurationINTEL);
    BUILD_DISPATCH_VECTOR(PreCallValidateQueueSetPerformanceConfigurationINTEL);
    BUILD_DISPATCH_VECTOR(PreCallRecordQueueSetPerformanceConfigurationINTEL);
    BUILD_DISPATCH_VECTOR(PostCallRecordQueueSetPerformanceConfigurationINTEL);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPerformanceParameterINTEL);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPerformanceParameterINTEL);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPerformanceParameterINTEL);
    BUILD_DISPATCH_VECTOR(PreCallValidateSetLocalDimmingAMD);
    BUILD_DISPATCH_VECTOR(PreCallRecordSetLocalDimmingAMD);
    BUILD_DISPATCH_VECTOR(PostCallRecordSetLocalDimmingAMD);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetBufferDeviceAddressEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetBufferDeviceAddressEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetBufferDeviceAddressEXT);
#ifdef VK_USE_PLATFORM_WIN32_KHR
    BUILD_DISPATCH_VECTOR(PreCallValidateAcquireFullScreenExclusiveModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordAcquireFullScreenExclusiveModeEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordAcquireFullScreenExclusiveModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateReleaseFullScreenExclusiveModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordReleaseFullScreenExclusiveModeEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordReleaseFullScreenExclusiveModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceGroupSurfacePresentModes2EXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceGroupSurfacePresentModes2EXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceGroupSurfacePresentModes2EXT);
#endif  // VK_USE_PLATFORM_WIN32_KHR
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetLineStippleEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetLineStippleEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetLineStippleEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateResetQueryPoolEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordResetQueryPoolEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordResetQueryPoolEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetCullModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetCullModeEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetCullModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetFrontFaceEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetFrontFaceEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetFrontFaceEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetPrimitiveTopologyEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetPrimitiveTopologyEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetPrimitiveTopologyEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetViewportWithCountEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetViewportWithCountEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetViewportWithCountEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetScissorWithCountEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetScissorWithCountEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetScissorWithCountEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindVertexBuffers2EXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindVertexBuffers2EXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindVertexBuffers2EXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthTestEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthTestEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthTestEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthWriteEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthWriteEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthWriteEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthCompareOpEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthCompareOpEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthCompareOpEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthBoundsTestEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthBoundsTestEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthBoundsTestEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetStencilTestEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetStencilTestEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetStencilTestEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetStencilOpEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetStencilOpEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetStencilOpEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCopyMemoryToImageEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCopyMemoryToImageEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCopyMemoryToImageEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCopyImageToMemoryEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCopyImageToMemoryEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCopyImageToMemoryEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCopyImageToImageEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCopyImageToImageEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCopyImageToImageEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateTransitionImageLayoutEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordTransitionImageLayoutEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordTransitionImageLayoutEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageSubresourceLayout2EXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageSubresourceLayout2EXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageSubresourceLayout2EXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateReleaseSwapchainImagesEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordReleaseSwapchainImagesEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordReleaseSwapchainImagesEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetGeneratedCommandsMemoryRequirementsNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetGeneratedCommandsMemoryRequirementsNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetGeneratedCommandsMemoryRequirementsNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdPreprocessGeneratedCommandsNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdPreprocessGeneratedCommandsNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdPreprocessGeneratedCommandsNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdExecuteGeneratedCommandsNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdExecuteGeneratedCommandsNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdExecuteGeneratedCommandsNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindPipelineShaderGroupNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindPipelineShaderGroupNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindPipelineShaderGroupNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateIndirectCommandsLayoutNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateIndirectCommandsLayoutNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateIndirectCommandsLayoutNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyIndirectCommandsLayoutNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyIndirectCommandsLayoutNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyIndirectCommandsLayoutNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthBias2EXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthBias2EXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthBias2EXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreatePrivateDataSlotEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreatePrivateDataSlotEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreatePrivateDataSlotEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyPrivateDataSlotEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyPrivateDataSlotEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyPrivateDataSlotEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateSetPrivateDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordSetPrivateDataEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordSetPrivateDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPrivateDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPrivateDataEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPrivateDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateCudaModuleNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateCudaModuleNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateCudaModuleNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetCudaModuleCacheNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetCudaModuleCacheNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetCudaModuleCacheNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateCudaFunctionNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateCudaFunctionNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateCudaFunctionNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyCudaModuleNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyCudaModuleNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyCudaModuleNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyCudaFunctionNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyCudaFunctionNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyCudaFunctionNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCudaLaunchKernelNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCudaLaunchKernelNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCudaLaunchKernelNV);
#ifdef VK_USE_PLATFORM_METAL_EXT
    BUILD_DISPATCH_VECTOR(PreCallValidateExportMetalObjectsEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordExportMetalObjectsEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordExportMetalObjectsEXT);
#endif  // VK_USE_PLATFORM_METAL_EXT
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDescriptorSetLayoutSizeEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDescriptorSetLayoutSizeEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDescriptorSetLayoutSizeEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDescriptorSetLayoutBindingOffsetEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDescriptorSetLayoutBindingOffsetEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDescriptorSetLayoutBindingOffsetEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDescriptorEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDescriptorEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDescriptorEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindDescriptorBuffersEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindDescriptorBuffersEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindDescriptorBuffersEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDescriptorBufferOffsetsEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDescriptorBufferOffsetsEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDescriptorBufferOffsetsEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindDescriptorBufferEmbeddedSamplersEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindDescriptorBufferEmbeddedSamplersEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindDescriptorBufferEmbeddedSamplersEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetBufferOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetBufferOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetBufferOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetImageViewOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetImageViewOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetImageViewOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetSamplerOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetSamplerOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetSamplerOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetAccelerationStructureOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetAccelerationStructureOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetAccelerationStructureOpaqueCaptureDescriptorDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetFragmentShadingRateEnumNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetFragmentShadingRateEnumNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetFragmentShadingRateEnumNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceFaultInfoEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceFaultInfoEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceFaultInfoEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetVertexInputEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetVertexInputEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetVertexInputEXT);
#ifdef VK_USE_PLATFORM_FUCHSIA
    BUILD_DISPATCH_VECTOR(PreCallValidateGetMemoryZirconHandleFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetMemoryZirconHandleFUCHSIA);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetMemoryZirconHandleFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetMemoryZirconHandlePropertiesFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetMemoryZirconHandlePropertiesFUCHSIA);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetMemoryZirconHandlePropertiesFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallValidateImportSemaphoreZirconHandleFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallRecordImportSemaphoreZirconHandleFUCHSIA);
    BUILD_DISPATCH_VECTOR(PostCallRecordImportSemaphoreZirconHandleFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetSemaphoreZirconHandleFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetSemaphoreZirconHandleFUCHSIA);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetSemaphoreZirconHandleFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateBufferCollectionFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateBufferCollectionFUCHSIA);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateBufferCollectionFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallValidateSetBufferCollectionImageConstraintsFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallRecordSetBufferCollectionImageConstraintsFUCHSIA);
    BUILD_DISPATCH_VECTOR(PostCallRecordSetBufferCollectionImageConstraintsFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallValidateSetBufferCollectionBufferConstraintsFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallRecordSetBufferCollectionBufferConstraintsFUCHSIA);
    BUILD_DISPATCH_VECTOR(PostCallRecordSetBufferCollectionBufferConstraintsFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyBufferCollectionFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyBufferCollectionFUCHSIA);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyBufferCollectionFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetBufferCollectionPropertiesFUCHSIA);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetBufferCollectionPropertiesFUCHSIA);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetBufferCollectionPropertiesFUCHSIA);
#endif  // VK_USE_PLATFORM_FUCHSIA
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSubpassShadingHUAWEI);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSubpassShadingHUAWEI);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSubpassShadingHUAWEI);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindInvocationMaskHUAWEI);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindInvocationMaskHUAWEI);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindInvocationMaskHUAWEI);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetMemoryRemoteAddressNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetMemoryRemoteAddressNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetMemoryRemoteAddressNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPipelinePropertiesEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPipelinePropertiesEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPipelinePropertiesEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetPatchControlPointsEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetPatchControlPointsEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetPatchControlPointsEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetRasterizerDiscardEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetRasterizerDiscardEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetRasterizerDiscardEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthBiasEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthBiasEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthBiasEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetLogicOpEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetLogicOpEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetLogicOpEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetPrimitiveRestartEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetPrimitiveRestartEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetPrimitiveRestartEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetColorWriteEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetColorWriteEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetColorWriteEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawMultiEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawMultiEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawMultiEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawMultiIndexedEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawMultiIndexedEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawMultiIndexedEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateMicromapEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateMicromapEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateMicromapEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyMicromapEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyMicromapEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyMicromapEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBuildMicromapsEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBuildMicromapsEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBuildMicromapsEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateBuildMicromapsEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordBuildMicromapsEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordBuildMicromapsEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCopyMicromapEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCopyMicromapEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCopyMicromapEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCopyMicromapToMemoryEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCopyMicromapToMemoryEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCopyMicromapToMemoryEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCopyMemoryToMicromapEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCopyMemoryToMicromapEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCopyMemoryToMicromapEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateWriteMicromapsPropertiesEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordWriteMicromapsPropertiesEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordWriteMicromapsPropertiesEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyMicromapEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyMicromapEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyMicromapEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyMicromapToMemoryEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyMicromapToMemoryEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyMicromapToMemoryEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyMemoryToMicromapEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyMemoryToMicromapEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyMemoryToMicromapEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdWriteMicromapsPropertiesEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdWriteMicromapsPropertiesEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdWriteMicromapsPropertiesEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceMicromapCompatibilityEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceMicromapCompatibilityEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceMicromapCompatibilityEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetMicromapBuildSizesEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetMicromapBuildSizesEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetMicromapBuildSizesEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawClusterHUAWEI);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawClusterHUAWEI);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawClusterHUAWEI);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawClusterIndirectHUAWEI);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawClusterIndirectHUAWEI);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawClusterIndirectHUAWEI);
    BUILD_DISPATCH_VECTOR(PreCallValidateSetDeviceMemoryPriorityEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordSetDeviceMemoryPriorityEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordSetDeviceMemoryPriorityEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDescriptorSetLayoutHostMappingInfoVALVE);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDescriptorSetLayoutHostMappingInfoVALVE);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDescriptorSetLayoutHostMappingInfoVALVE);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDescriptorSetHostMappingVALVE);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDescriptorSetHostMappingVALVE);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDescriptorSetHostMappingVALVE);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyMemoryIndirectNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyMemoryIndirectNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyMemoryIndirectNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyMemoryToImageIndirectNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyMemoryToImageIndirectNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyMemoryToImageIndirectNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDecompressMemoryNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDecompressMemoryNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDecompressMemoryNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDecompressMemoryIndirectCountNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDecompressMemoryIndirectCountNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDecompressMemoryIndirectCountNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPipelineIndirectMemoryRequirementsNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPipelineIndirectMemoryRequirementsNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPipelineIndirectMemoryRequirementsNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdUpdatePipelineIndirectBufferNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdUpdatePipelineIndirectBufferNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdUpdatePipelineIndirectBufferNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetPipelineIndirectDeviceAddressNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetPipelineIndirectDeviceAddressNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetPipelineIndirectDeviceAddressNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthClampEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthClampEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthClampEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetPolygonModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetPolygonModeEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetPolygonModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetRasterizationSamplesEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetRasterizationSamplesEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetRasterizationSamplesEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetSampleMaskEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetSampleMaskEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetSampleMaskEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetAlphaToCoverageEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetAlphaToCoverageEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetAlphaToCoverageEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetAlphaToOneEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetAlphaToOneEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetAlphaToOneEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetLogicOpEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetLogicOpEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetLogicOpEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetColorBlendEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetColorBlendEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetColorBlendEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetColorBlendEquationEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetColorBlendEquationEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetColorBlendEquationEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetColorWriteMaskEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetColorWriteMaskEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetColorWriteMaskEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetTessellationDomainOriginEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetTessellationDomainOriginEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetTessellationDomainOriginEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetRasterizationStreamEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetRasterizationStreamEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetRasterizationStreamEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetConservativeRasterizationModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetConservativeRasterizationModeEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetConservativeRasterizationModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetExtraPrimitiveOverestimationSizeEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetExtraPrimitiveOverestimationSizeEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetExtraPrimitiveOverestimationSizeEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthClipEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthClipEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthClipEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetSampleLocationsEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetSampleLocationsEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetSampleLocationsEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetColorBlendAdvancedEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetColorBlendAdvancedEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetColorBlendAdvancedEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetProvokingVertexModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetProvokingVertexModeEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetProvokingVertexModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetLineRasterizationModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetLineRasterizationModeEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetLineRasterizationModeEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetLineStippleEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetLineStippleEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetLineStippleEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthClipNegativeOneToOneEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthClipNegativeOneToOneEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthClipNegativeOneToOneEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetViewportWScalingEnableNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetViewportWScalingEnableNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetViewportWScalingEnableNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetViewportSwizzleNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetViewportSwizzleNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetViewportSwizzleNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetCoverageToColorEnableNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetCoverageToColorEnableNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetCoverageToColorEnableNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetCoverageToColorLocationNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetCoverageToColorLocationNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetCoverageToColorLocationNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetCoverageModulationModeNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetCoverageModulationModeNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetCoverageModulationModeNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetCoverageModulationTableEnableNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetCoverageModulationTableEnableNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetCoverageModulationTableEnableNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetCoverageModulationTableNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetCoverageModulationTableNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetCoverageModulationTableNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetShadingRateImageEnableNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetShadingRateImageEnableNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetShadingRateImageEnableNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetRepresentativeFragmentTestEnableNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetRepresentativeFragmentTestEnableNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetRepresentativeFragmentTestEnableNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetCoverageReductionModeNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetCoverageReductionModeNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetCoverageReductionModeNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetShaderModuleIdentifierEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetShaderModuleIdentifierEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetShaderModuleIdentifierEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetShaderModuleCreateInfoIdentifierEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetShaderModuleCreateInfoIdentifierEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetShaderModuleCreateInfoIdentifierEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateOpticalFlowSessionNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateOpticalFlowSessionNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateOpticalFlowSessionNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyOpticalFlowSessionNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyOpticalFlowSessionNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyOpticalFlowSessionNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateBindOpticalFlowSessionImageNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordBindOpticalFlowSessionImageNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordBindOpticalFlowSessionImageNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdOpticalFlowExecuteNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdOpticalFlowExecuteNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdOpticalFlowExecuteNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateAntiLagUpdateAMD);
    BUILD_DISPATCH_VECTOR(PreCallRecordAntiLagUpdateAMD);
    BUILD_DISPATCH_VECTOR(PostCallRecordAntiLagUpdateAMD);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyShaderEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyShaderEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyShaderEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetShaderBinaryDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetShaderBinaryDataEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetShaderBinaryDataEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBindShadersEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBindShadersEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBindShadersEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetDepthClampRangeEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetDepthClampRangeEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetDepthClampRangeEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetFramebufferTilePropertiesQCOM);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetFramebufferTilePropertiesQCOM);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetFramebufferTilePropertiesQCOM);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDynamicRenderingTilePropertiesQCOM);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDynamicRenderingTilePropertiesQCOM);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDynamicRenderingTilePropertiesQCOM);
    BUILD_DISPATCH_VECTOR(PreCallValidateSetLatencySleepModeNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordSetLatencySleepModeNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordSetLatencySleepModeNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateLatencySleepNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordLatencySleepNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordLatencySleepNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateSetLatencyMarkerNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordSetLatencyMarkerNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordSetLatencyMarkerNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetLatencyTimingsNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetLatencyTimingsNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetLatencyTimingsNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateQueueNotifyOutOfBandNV);
    BUILD_DISPATCH_VECTOR(PreCallRecordQueueNotifyOutOfBandNV);
    BUILD_DISPATCH_VECTOR(PostCallRecordQueueNotifyOutOfBandNV);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetAttachmentFeedbackLoopEnableEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetAttachmentFeedbackLoopEnableEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetAttachmentFeedbackLoopEnableEXT);
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    BUILD_DISPATCH_VECTOR(PreCallValidateGetScreenBufferPropertiesQNX);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetScreenBufferPropertiesQNX);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetScreenBufferPropertiesQNX);
#endif  // VK_USE_PLATFORM_SCREEN_QNX
    BUILD_DISPATCH_VECTOR(PreCallValidateGetGeneratedCommandsMemoryRequirementsEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetGeneratedCommandsMemoryRequirementsEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetGeneratedCommandsMemoryRequirementsEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdPreprocessGeneratedCommandsEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdPreprocessGeneratedCommandsEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdPreprocessGeneratedCommandsEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdExecuteGeneratedCommandsEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdExecuteGeneratedCommandsEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdExecuteGeneratedCommandsEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateIndirectCommandsLayoutEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateIndirectCommandsLayoutEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateIndirectCommandsLayoutEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyIndirectCommandsLayoutEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyIndirectCommandsLayoutEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyIndirectCommandsLayoutEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateIndirectExecutionSetEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateIndirectExecutionSetEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateIndirectExecutionSetEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyIndirectExecutionSetEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyIndirectExecutionSetEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyIndirectExecutionSetEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateUpdateIndirectExecutionSetPipelineEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordUpdateIndirectExecutionSetPipelineEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordUpdateIndirectExecutionSetPipelineEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateUpdateIndirectExecutionSetShaderEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordUpdateIndirectExecutionSetShaderEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordUpdateIndirectExecutionSetShaderEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCreateAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCreateAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCreateAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateDestroyAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordDestroyAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordDestroyAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBuildAccelerationStructuresKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBuildAccelerationStructuresKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBuildAccelerationStructuresKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdBuildAccelerationStructuresIndirectKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdBuildAccelerationStructuresIndirectKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdBuildAccelerationStructuresIndirectKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateBuildAccelerationStructuresKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordBuildAccelerationStructuresKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordBuildAccelerationStructuresKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCopyAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCopyAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCopyAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCopyAccelerationStructureToMemoryKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCopyAccelerationStructureToMemoryKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCopyAccelerationStructureToMemoryKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCopyMemoryToAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCopyMemoryToAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCopyMemoryToAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateWriteAccelerationStructuresPropertiesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordWriteAccelerationStructuresPropertiesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordWriteAccelerationStructuresPropertiesKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyAccelerationStructureToMemoryKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyAccelerationStructureToMemoryKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyAccelerationStructureToMemoryKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdCopyMemoryToAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdCopyMemoryToAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdCopyMemoryToAccelerationStructureKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetAccelerationStructureDeviceAddressKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetAccelerationStructureDeviceAddressKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetAccelerationStructureDeviceAddressKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdWriteAccelerationStructuresPropertiesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdWriteAccelerationStructuresPropertiesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdWriteAccelerationStructuresPropertiesKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetDeviceAccelerationStructureCompatibilityKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetDeviceAccelerationStructureCompatibilityKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetDeviceAccelerationStructureCompatibilityKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetAccelerationStructureBuildSizesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetAccelerationStructureBuildSizesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetAccelerationStructureBuildSizesKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdTraceRaysKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdTraceRaysKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdTraceRaysKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetRayTracingCaptureReplayShaderGroupHandlesKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetRayTracingCaptureReplayShaderGroupHandlesKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetRayTracingCaptureReplayShaderGroupHandlesKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdTraceRaysIndirectKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdTraceRaysIndirectKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdTraceRaysIndirectKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateGetRayTracingShaderGroupStackSizeKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordGetRayTracingShaderGroupStackSizeKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordGetRayTracingShaderGroupStackSizeKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdSetRayTracingPipelineStackSizeKHR);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdSetRayTracingPipelineStackSizeKHR);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdSetRayTracingPipelineStackSizeKHR);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawMeshTasksEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawMeshTasksEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawMeshTasksEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawMeshTasksIndirectEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawMeshTasksIndirectEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawMeshTasksIndirectEXT);
    BUILD_DISPATCH_VECTOR(PreCallValidateCmdDrawMeshTasksIndirectCountEXT);
    BUILD_DISPATCH_VECTOR(PreCallRecordCmdDrawMeshTasksIndirectCountEXT);
    BUILD_DISPATCH_VECTOR(PostCallRecordCmdDrawMeshTasksIndirectCountEXT);
}

// NOLINTEND
