/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public class WhitespaceAfterCheck
extends AbstractCheck {
    public static final String MSG_WS_NOT_FOLLOWED = "ws.notFollowed";
    public static final String MSG_WS_TYPECAST = "ws.typeCast";

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{74, 45, 23, 83, 92, 84, 85, 91, 97, 88, 207, 96, 175, 171, 89, 67, 95, 93, 181};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 23) {
            int[] line;
            DetailAST targetAST = ast.findFirstToken(77);
            if (!WhitespaceAfterCheck.isFollowedByWhitespace(targetAST, line = this.getLineCodePoints(targetAST.getLineNo() - 1))) {
                this.log(targetAST, MSG_WS_TYPECAST, new Object[0]);
            }
        } else {
            int[] line = this.getLineCodePoints(ast.getLineNo() - 1);
            if (!WhitespaceAfterCheck.isFollowedByWhitespace(ast, line)) {
                Object[] message = new Object[]{ast.getText()};
                this.log(ast, MSG_WS_NOT_FOLLOWED, message);
            }
        }
    }

    private static boolean isFollowedByWhitespace(DetailAST targetAST, int ... line) {
        int after = targetAST.getColumnNo() + targetAST.getText().length();
        boolean followedByWhitespace = true;
        if (after < line.length) {
            int codePoint = line[after];
            followedByWhitespace = codePoint == 59 || codePoint == 41 || Character.isWhitespace(codePoint);
        }
        return followedByWhitespace;
    }
}

