#line 1 "ExprParserLexIn.cpp"

#line 3 "ExprParserLexIn.cpp"

#define  SeExprYY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define SeExprYY_FLEX_MAJOR_VERSION 2
#define SeExprYY_FLEX_MINOR_VERSION 6
#define SeExprYY_FLEX_SUBMINOR_VERSION 4
#if SeExprYY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define SeExprconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define SeExprnoreturn __attribute__((__noreturn__))
#else
#define SeExprnoreturn
#endif

/* Returned upon end-of-file. */
#define SeExprYY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define SeExprYY_SC_TO_UI(c) ((SeExprYY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (SeExpr_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The SeExprYYSTATE alias is for lex
 * compatibility.
 */
#define SeExprYY_START (((SeExpr_start) - 1) / 2)
#define SeExprYYSTATE SeExprYY_START
/* Action number for EOF rule of a given start state. */
#define SeExprYY_STATE_EOF(state) (SeExprYY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define SeExprYY_NEW_FILE SeExprrestart( SeExprin  )
#define SeExprYY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef SeExprYY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, SeExprYY_BUF_SIZE is 2*SeExprYY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define SeExprYY_BUF_SIZE 32768
#else
#define SeExprYY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define SeExprYY_STATE_BUF_SIZE   ((SeExprYY_BUF_SIZE + 2) * sizeof(SeExpr_state_type))

#ifndef SeExprYY_TYPEDEF_SeExprYY_BUFFER_STATE
#define SeExprYY_TYPEDEF_SeExprYY_BUFFER_STATE
typedef struct SeExpr_buffer_state *SeExprYY_BUFFER_STATE;
#endif

#ifndef SeExprYY_TYPEDEF_SeExprYY_SIZE_T
#define SeExprYY_TYPEDEF_SeExprYY_SIZE_T
typedef size_t SeExpr_size_t;
#endif

extern int SeExprleng;

extern FILE *SeExprin, *SeExprout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define SeExprYY_LESS_LINENO(n)
    #define SeExprYY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define SeExprless(n) \
	do \
		{ \
		/* Undo effects of setting up SeExprtext. */ \
        int SeExprless_macro_arg = (n); \
        SeExprYY_LESS_LINENO(SeExprless_macro_arg);\
		*SeExpr_cp = (SeExpr_hold_char); \
		SeExprYY_RESTORE_SeExprYY_MORE_OFFSET \
		(SeExpr_c_buf_p) = SeExpr_cp = SeExpr_bp + SeExprless_macro_arg - SeExprYY_MORE_ADJ; \
		SeExprYY_DO_BEFORE_ACTION; /* set up SeExprtext again */ \
		} \
	while ( 0 )
#define unput(c) SeExprunput( c, (SeExprtext_ptr)  )

#ifndef SeExprYY_STRUCT_SeExprYY_BUFFER_STATE
#define SeExprYY_STRUCT_SeExprYY_BUFFER_STATE
struct SeExpr_buffer_state
	{
	FILE *SeExpr_input_file;

	char *SeExpr_ch_buf;		/* input buffer */
	char *SeExpr_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int SeExpr_buf_size;

	/* Number of characters read into SeExpr_ch_buf, not including EOB
	 * characters.
	 */
	int SeExpr_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int SeExpr_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int SeExpr_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int SeExpr_at_bol;

    int SeExpr_bs_lineno; /**< The line count. */
    int SeExpr_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int SeExpr_fill_buffer;

	int SeExpr_buffer_status;

#define SeExprYY_BUFFER_NEW 0
#define SeExprYY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as SeExprYY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via SeExprrestart()), so that the user can continue scanning by
	 * just pointing SeExprin at a new input file.
	 */
#define SeExprYY_BUFFER_EOF_PENDING 2

	};
#endif /* !SeExprYY_STRUCT_SeExprYY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t SeExpr_buffer_stack_top = 0; /**< index of top of stack. */
static size_t SeExpr_buffer_stack_max = 0; /**< capacity of stack. */
static SeExprYY_BUFFER_STATE * SeExpr_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define SeExprYY_CURRENT_BUFFER ( (SeExpr_buffer_stack) \
                          ? (SeExpr_buffer_stack)[(SeExpr_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define SeExprYY_CURRENT_BUFFER_LVALUE (SeExpr_buffer_stack)[(SeExpr_buffer_stack_top)]

/* SeExpr_hold_char holds the character lost when SeExprtext is formed. */
static char SeExpr_hold_char;
static int SeExpr_n_chars;		/* number of characters read into SeExpr_ch_buf */
int SeExprleng;

/* Points to current character in buffer. */
static char *SeExpr_c_buf_p = NULL;
static int SeExpr_init = 0;		/* whether we need to initialize */
static int SeExpr_start = 0;	/* start state number */

/* Flag which is used to allow SeExprwrap()'s to do buffer switches
 * instead of setting up a fresh SeExprin.  A bit of a hack ...
 */
static int SeExpr_did_buffer_switch_on_eof;

void SeExprrestart ( FILE *input_file  );
void SeExpr_switch_to_buffer ( SeExprYY_BUFFER_STATE new_buffer  );
SeExprYY_BUFFER_STATE SeExpr_create_buffer ( FILE *file, int size  );
void SeExpr_delete_buffer ( SeExprYY_BUFFER_STATE b  );
void SeExpr_flush_buffer ( SeExprYY_BUFFER_STATE b  );
void SeExprpush_buffer_state ( SeExprYY_BUFFER_STATE new_buffer  );
void SeExprpop_buffer_state ( void );

static void SeExprensure_buffer_stack ( void );
static void SeExpr_load_buffer_state ( void );
static void SeExpr_init_buffer ( SeExprYY_BUFFER_STATE b, FILE *file  );
#define SeExprYY_FLUSH_BUFFER SeExpr_flush_buffer( SeExprYY_CURRENT_BUFFER )

SeExprYY_BUFFER_STATE SeExpr_scan_buffer ( char *base, SeExpr_size_t size  );
SeExprYY_BUFFER_STATE SeExpr_scan_string ( const char *SeExpr_str  );
SeExprYY_BUFFER_STATE SeExpr_scan_bytes ( const char *bytes, int len  );

void *SeExpralloc ( SeExpr_size_t  );
void *SeExprrealloc ( void *, SeExpr_size_t  );
void SeExprfree ( void *  );

#define SeExpr_new_buffer SeExpr_create_buffer
#define SeExpr_set_interactive(is_interactive) \
	{ \
	if ( ! SeExprYY_CURRENT_BUFFER ){ \
        SeExprensure_buffer_stack (); \
		SeExprYY_CURRENT_BUFFER_LVALUE =    \
            SeExpr_create_buffer( SeExprin, SeExprYY_BUF_SIZE ); \
	} \
	SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_is_interactive = is_interactive; \
	}
#define SeExpr_set_bol(at_bol) \
	{ \
	if ( ! SeExprYY_CURRENT_BUFFER ){\
        SeExprensure_buffer_stack (); \
		SeExprYY_CURRENT_BUFFER_LVALUE =    \
            SeExpr_create_buffer( SeExprin, SeExprYY_BUF_SIZE ); \
	} \
	SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_at_bol = at_bol; \
	}
#define SeExprYY_AT_BOL() (SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_at_bol)

/* Begin user sect3 */

#define SeExprwrap() (/*CONSTCOND*/1)
#define SeExprYY_SKIP_SeExprYYWRAP
typedef flex_uint8_t SeExprYY_CHAR;

FILE *SeExprin = NULL, *SeExprout = NULL;

typedef int SeExpr_state_type;

extern int SeExprlineno;
int SeExprlineno = 1;

extern char *SeExprtext;
#ifdef SeExprtext_ptr
#undef SeExprtext_ptr
#endif
#define SeExprtext_ptr SeExprtext

static SeExpr_state_type SeExpr_get_previous_state ( void );
static SeExpr_state_type SeExpr_try_NUL_trans ( SeExpr_state_type current_state  );
static int SeExpr_get_next_buffer ( void );
static void SeExprnoreturn SeExpr_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up SeExprtext.
 */
#define SeExprYY_DO_BEFORE_ACTION \
	(SeExprtext_ptr) = SeExpr_bp; \
	SeExprleng = (int) (SeExpr_cp - SeExpr_bp); \
	(SeExpr_hold_char) = *SeExpr_cp; \
	*SeExpr_cp = '\0'; \
	(SeExpr_c_buf_p) = SeExpr_cp;
#define SeExprYY_NUM_RULES 42
#define SeExprYY_END_OF_BUFFER 43
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct SeExpr_trans_info
	{
	flex_int32_t SeExpr_verify;
	flex_int32_t SeExpr_nxt;
	};
static const flex_int16_t SeExpr_accept[160] =
    {   0,
        0,    0,   43,   41,   39,   39,   41,   41,   40,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   31,   41,
       41,   41,   36,   36,   36,   26,   36,   36,   36,   36,
       36,   41,   41,   36,   36,   36,   36,   36,   36,   36,
       41,   15,    0,   32,    0,   40,    0,   34,   23,   13,
        0,   33,    0,   21,   19,   20,   18,   31,   22,   31,
       31,    0,   16,   14,   17,   36,   36,   36,   36,   36,
       25,   36,   36,   36,   37,   38,   24,   36,   36,   36,
       36,   36,   10,   36,   36,   12,   32,   34,    0,   33,
        0,   31,    0,    0,   31,   36,   36,   36,   36,   36,

       36,   36,   30,    3,   36,   36,   36,   36,   36,    0,
        0,   31,    0,    0,   31,   36,   36,   36,   36,   36,
       36,   36,   11,   36,   36,   36,   36,   35,    0,   31,
       36,   36,    9,    4,   36,   36,   36,   36,   36,   36,
       36,   35,   36,   36,    5,   36,   36,    2,   36,   27,
       28,    1,   36,    7,    8,   36,    6,   29,    0
    } ;

static const SeExprYY_CHAR SeExpr_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    7,    8,    9,   10,    1,
        1,   11,   12,    1,   13,   14,   15,   16,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   18,   19,   20,
       21,   22,    1,    1,   23,   24,   25,   26,   27,   28,
       29,   26,   30,   26,   26,   31,   32,   33,   34,   35,
       26,   36,   37,   38,   39,   40,   26,   26,   41,   26,
        1,   42,    1,   43,   26,    1,   44,   45,   26,   46,

       47,   48,   49,   50,   51,   26,   26,   52,   53,   54,
       55,   26,   26,   56,   57,   58,   59,   26,   26,   60,
       26,   26,    1,   61,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const SeExprYY_CHAR SeExpr_meta[62] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    3,    1,    3,    3,    4,    1,    1,
        1,    1,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    1,    1,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        1
    } ;

static const flex_int16_t SeExpr_base[168] =
    {   0,
        0,    0,  245,  246,  246,  246,  223,   57,  201,    0,
      221,  232,   53,  219,  218,   43,   50,  217,   54,  216,
      215,  214,    0,  207,  199,  196,  200,  200,  191,  195,
      204,   15,  205,  170,  177,   20,  179,  174,  170,  167,
      158,  246,   69,  246,   70,  176,  163,  198,  246,  246,
       66,  246,   67,  246,  246,  246,  246,   66,  246,   69,
       73,   90,  246,  246,  246,    0,  186,  181,  177,  178,
        0,  175,  180,  173,  246,  246,  246,  148,  159,  149,
      147,  145,    0,  149,  147,  246,   73,  183,  182,   81,
      105,  108,  114,   81,   88,  169,  161,  163,  173,  165,

      166,  152,    0,    0,  145,  144,  133,  142,  133,    0,
      112,  116,  124,  122,  126,  154,  148,  149,  146,  150,
      148,  151,    0,  124,  121,  128,  109,    0,  128,  130,
      146,  134,    0,    0,  125,  117,  119,   97,   99,   93,
       98,    0,  115,   86,    0,   82,   81,    0,   50,    0,
        0,  246,   54,    0,    0,   34,    0,    0,  246,  155,
      160,   79,  165,  168,  171,   74,  174
    } ;

static const flex_int16_t SeExpr_def[168] =
    {   0,
      159,    1,  159,  159,  159,  159,  159,  160,  161,  162,
      159,  159,  163,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  164,  164,  164,  164,  164,  164,  164,  164,
      164,  159,  159,  164,  164,  164,  164,  164,  164,  164,
      159,  159,  160,  159,  160,  161,  161,  165,  159,  159,
      163,  159,  163,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  164,  164,  164,  164,  164,
      164,  164,  164,  164,  159,  159,  159,  164,  164,  164,
      164,  164,  164,  164,  164,  159,  160,  165,  159,  163,
      159,  159,  159,  159,  159,  164,  164,  164,  164,  164,

      164,  164,  164,  164,  164,  164,  164,  164,  164,  166,
      159,  159,  159,  159,  159,  164,  164,  164,  164,  164,
      164,  164,  164,  164,  164,  164,  164,  167,  159,  159,
      164,  164,  164,  164,  164,  164,  164,  164,  164,  164,
      164,  167,  164,  164,  164,  164,  164,  164,  164,  164,
      164,  159,  164,  164,  164,  164,  164,  164,    0,  159,
      159,  159,  159,  159,  159,  159,  159
    } ;

static const flex_int16_t SeExpr_nxt[308] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,   18,   19,   19,    4,    4,   20,
       21,   22,   23,   24,   25,   23,   26,   27,   23,   23,
       23,   23,   23,   23,   28,   23,   29,   23,   30,   31,
       23,   32,   33,   23,   34,   35,   36,   23,   37,   23,
       38,   39,   23,   23,   23,   23,   40,   23,   23,   23,
       41,   44,   52,   56,   57,   58,   58,   60,   75,   61,
       61,   80,   76,   44,   87,   52,   90,   44,  128,   81,
       62,   58,   58,   48,   92,   92,   60,  158,   61,   61,
       52,  157,   91,  156,   53,   93,   95,   95,   45,   62,

       62,   94,   94,   95,   95,   95,   95,   53,   53,  155,
       45,   45,   91,  154,   45,   93,  111,  111,  153,   62,
      112,  112,   53,   92,   92,  114,  114,  112,  112,  115,
      115,  112,  112,  152,  113,  129,  129,  115,  115,  130,
      130,  115,  115,  130,  130,  130,  130,  151,  150,  149,
      148,  147,  146,  145,  113,   43,  144,   43,   43,   43,
       46,  143,   46,   46,   46,   51,  141,   51,   51,   51,
       66,  140,   66,   88,   88,   88,  142,  139,  142,  138,
      137,  136,  135,  134,  133,  132,  131,  127,  126,  125,
      124,  123,  122,  121,  120,  119,  118,  117,  116,  110,

       89,  109,  108,  107,  106,  105,  104,  103,  102,  101,
      100,   99,   98,   97,   96,   89,  159,   47,   86,   85,
       84,   83,   82,   79,   78,   77,   74,   73,   72,   71,
       70,   69,   68,   67,   65,   64,   63,   59,   55,   54,
       50,   49,   47,   42,  159,    3,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,

      159,  159,  159,  159,  159,  159,  159
    } ;

static const flex_int16_t SeExpr_chk[308] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    8,   13,   16,   16,   17,   17,   19,   32,   19,
       19,   36,   32,   43,   45,   51,   53,   87,  166,   36,
       19,   58,   58,  162,   60,   60,   61,  156,   61,   61,
       90,  153,   58,  149,   13,   60,   94,   94,    8,   61,

       19,   62,   62,   95,   95,   62,   62,   51,   53,  147,
       43,   45,   58,  146,   87,   60,   91,   91,  144,   61,
       91,   91,   90,   92,   92,   93,   93,  111,  111,   93,
       93,  112,  112,  143,   92,  113,  113,  114,  114,  113,
      113,  115,  115,  129,  129,  130,  130,  141,  140,  139,
      138,  137,  136,  135,   92,  160,  132,  160,  160,  160,
      161,  131,  161,  161,  161,  163,  127,  163,  163,  163,
      164,  126,  164,  165,  165,  165,  167,  125,  167,  124,
      122,  121,  120,  119,  118,  117,  116,  109,  108,  107,
      106,  105,  102,  101,  100,   99,   98,   97,   96,   89,

       88,   85,   84,   82,   81,   80,   79,   78,   74,   73,
       72,   70,   69,   68,   67,   48,   47,   46,   41,   40,
       39,   38,   37,   35,   34,   33,   31,   30,   29,   28,
       27,   26,   25,   24,   22,   21,   20,   18,   15,   14,
       12,   11,    9,    7,    3,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,

      159,  159,  159,  159,  159,  159,  159
    } ;

static SeExpr_state_type SeExpr_last_accepting_state;
static char *SeExpr_last_accepting_cpos;

extern int SeExpr_flex_debug;
int SeExpr_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define SeExprmore() SeExprmore_used_but_not_detected
#define SeExprYY_MORE_ADJ 0
#define SeExprYY_RESTORE_SeExprYY_MORE_OFFSET
char *SeExprtext;
#line 1 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
/**
 * SPDX-FileCopyrightText: 2011-2019 Disney Enterprises, Inc.
 * SPDX-License-Identifier: LicenseRef-Apache-2.0
 * SPDX-FileCopyrightText: 2020-2021 L. E. Segovia <amy@amyspark.me>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
/* Don't generate SeExprwrap since everything is in one string */
/* Don't generate unput since it's unused and gcc complains... */
/* Don't generate input since it's unused too -- amyspark */
#define SeExprYY_NO_INPUT 1
/* Don't worry about interactive and using isatty(). Fixes Windows compile. */
#line 18 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
#include <cctype>
#include <cstring>
#include <cmath>
#include <vector>

// If c++11 don't use register designator, lex and yacc need to go...
#if __cplusplus > 199711L
#define register      // Deprecated in C++11.
#endif  // #if __cplusplus > 199711L

#include "ExprParser.h"
#include "ExprNode.h"
#include "Expression.h"
#include "Utils.h"

#ifdef SEEXPR_WIN32
#    define SeExprYY_NO_UNISTD_H
#    define SeExprYY_SKIP_SeExprYYWRAP
#endif

#ifndef MAKEDEPEND
#    include "ExprParser.tab.h"
#endif

// TODO: make this thread safe
static int columnNumber=0; // really buffer position
static int lineNumber=0; // not used
std::vector<std::pair<int,int> >* comments=0;
//! For lexer's internal use only!
void SeExprLexerResetState(std::vector<std::pair<int,int> >& commentsIn){
    comments=&commentsIn;
    columnNumber=lineNumber=0;
}

int SeExprpos();

#define SeExprYY_USER_ACTION { \
    SeExprlloc.first_line=lineNumber;SeExprlloc.first_column=columnNumber; \
    columnNumber+=SeExprleng;\
    SeExprlloc.last_column=columnNumber;SeExprlloc.last_line=lineNumber;}

#line 619 "ExprParserLexIn.cpp"
#line 620 "ExprParserLexIn.cpp"

#define INITIAL 0

#ifndef SeExprYY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef SeExprYY_EXTRA_TYPE
#define SeExprYY_EXTRA_TYPE void *
#endif

static int SeExpr_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int SeExprlex_destroy ( void );

int SeExprget_debug ( void );

void SeExprset_debug ( int debug_flag  );

SeExprYY_EXTRA_TYPE SeExprget_extra ( void );

void SeExprset_extra ( SeExprYY_EXTRA_TYPE user_defined  );

FILE *SeExprget_in ( void );

void SeExprset_in  ( FILE * _in_str  );

FILE *SeExprget_out ( void );

void SeExprset_out  ( FILE * _out_str  );

			int SeExprget_leng ( void );

char *SeExprget_text ( void );

int SeExprget_lineno ( void );

void SeExprset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef SeExprYY_SKIP_SeExprYYWRAP
#ifdef __cplusplus
extern "C" int SeExprwrap ( void );
#else
extern int SeExprwrap ( void );
#endif
#endif

#ifndef SeExprYY_NO_UNPUT
    
#endif

#ifndef SeExprtext_ptr
static void SeExpr_flex_strncpy ( char *, const char *, int );
#endif

#ifdef SeExprYY_NEED_STRLEN
static int SeExpr_flex_strlen ( const char * );
#endif

#ifndef SeExprYY_NO_INPUT
#ifdef __cplusplus
static int SeExprinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef SeExprYY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define SeExprYY_READ_BUF_SIZE 16384
#else
#define SeExprYY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( SeExprtext, (size_t) SeExprleng, 1, SeExprout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or SeExprYY_NULL,
 * is returned in "result".
 */
#ifndef SeExprYY_INPUT
#define SeExprYY_INPUT(buf,result,max_size) \
	if ( SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( SeExprin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( SeExprin ) ) \
			SeExprYY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (SeExpr_size_t) max_size, SeExprin)) == 0 && ferror(SeExprin)) \
			{ \
			if( errno != EINTR) \
				{ \
				SeExprYY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(SeExprin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "SeExprterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef SeExprterminate
#define SeExprterminate() return SeExprYY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef SeExprYY_START_STACK_INCR
#define SeExprYY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef SeExprYY_FATAL_ERROR
#define SeExprYY_FATAL_ERROR(msg) SeExpr_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef SeExprYY_DECL
#define SeExprYY_DECL_IS_OURS 1

extern int SeExprlex (void);

#define SeExprYY_DECL int SeExprlex (void)
#endif /* !SeExprYY_DECL */

/* Code executed at the beginning of each rule, after SeExprtext and SeExprleng
 * have been set up.
 */
#ifndef SeExprYY_USER_ACTION
#define SeExprYY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef SeExprYY_BREAK
#define SeExprYY_BREAK /*LINTED*/break;
#endif

#define SeExprYY_RULE_SETUP \
	SeExprYY_USER_ACTION

/** The main scanner function which does all the work.
 */
SeExprYY_DECL
{
	SeExpr_state_type SeExpr_current_state;
	char *SeExpr_cp, *SeExpr_bp;
	int SeExpr_act;
    
	if ( !(SeExpr_init) )
		{
		(SeExpr_init) = 1;

#ifdef SeExprYY_USER_INIT
		SeExprYY_USER_INIT;
#endif

		if ( ! (SeExpr_start) )
			(SeExpr_start) = 1;	/* first start state */

		if ( ! SeExprin )
			SeExprin = stdin;

		if ( ! SeExprout )
			SeExprout = stdout;

		if ( ! SeExprYY_CURRENT_BUFFER ) {
			SeExprensure_buffer_stack ();
			SeExprYY_CURRENT_BUFFER_LVALUE =
				SeExpr_create_buffer( SeExprin, SeExprYY_BUF_SIZE );
		}

		SeExpr_load_buffer_state(  );
		}

	{
#line 66 "@@PATH@@/src/KSeExpr/ExprParserLex.l"

#line 837 "ExprParserLexIn.cpp"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		SeExpr_cp = (SeExpr_c_buf_p);

		/* Support of SeExprtext. */
		*SeExpr_cp = (SeExpr_hold_char);

		/* SeExpr_bp points to the position in SeExpr_ch_buf of the start of
		 * the current run.
		 */
		SeExpr_bp = SeExpr_cp;

		SeExpr_current_state = (SeExpr_start);
SeExpr_match:
		do
			{
			SeExprYY_CHAR SeExpr_c = SeExpr_ec[SeExprYY_SC_TO_UI(*SeExpr_cp)] ;
			if ( SeExpr_accept[SeExpr_current_state] )
				{
				(SeExpr_last_accepting_state) = SeExpr_current_state;
				(SeExpr_last_accepting_cpos) = SeExpr_cp;
				}
			while ( SeExpr_chk[SeExpr_base[SeExpr_current_state] + SeExpr_c] != SeExpr_current_state )
				{
				SeExpr_current_state = (int) SeExpr_def[SeExpr_current_state];
				if ( SeExpr_current_state >= 160 )
					SeExpr_c = SeExpr_meta[SeExpr_c];
				}
			SeExpr_current_state = SeExpr_nxt[SeExpr_base[SeExpr_current_state] + SeExpr_c];
			++SeExpr_cp;
			}
		while ( SeExpr_current_state != 159 );
		SeExpr_cp = (SeExpr_last_accepting_cpos);
		SeExpr_current_state = (SeExpr_last_accepting_state);

SeExpr_find_action:
		SeExpr_act = SeExpr_accept[SeExpr_current_state];

		SeExprYY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( SeExpr_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of SeExprYY_DO_BEFORE_ACTION */
			*SeExpr_cp = (SeExpr_hold_char);
			SeExpr_cp = (SeExpr_last_accepting_cpos);
			SeExpr_current_state = (SeExpr_last_accepting_state);
			goto SeExpr_find_action;

case 1:
SeExprYY_RULE_SETUP
#line 67 "@@PATH@@/src/KSeExpr/ExprParserLex.l"

	SeExprYY_BREAK
case 2:
SeExprYY_RULE_SETUP
#line 69 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return EXTERN; }
	SeExprYY_BREAK
case 3:
SeExprYY_RULE_SETUP
#line 70 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return DEF; }
	SeExprYY_BREAK
case 4:
SeExprYY_RULE_SETUP
#line 71 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return FLOATPOINT; }
	SeExprYY_BREAK
case 5:
SeExprYY_RULE_SETUP
#line 72 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return STRING; }
	SeExprYY_BREAK
case 6:
SeExprYY_RULE_SETUP
#line 73 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return LIFETIME_CONSTANT; }
	SeExprYY_BREAK
case 7:
SeExprYY_RULE_SETUP
#line 74 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return LIFETIME_UNIFORM; }
	SeExprYY_BREAK
case 8:
SeExprYY_RULE_SETUP
#line 75 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return LIFETIME_VARYING; }
	SeExprYY_BREAK
case 9:
SeExprYY_RULE_SETUP
#line 76 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return LIFETIME_ERROR; }
	SeExprYY_BREAK
case 10:
SeExprYY_RULE_SETUP
#line 78 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return IF; }
	SeExprYY_BREAK
case 11:
SeExprYY_RULE_SETUP
#line 79 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return ELSE; }
	SeExprYY_BREAK
case 12:
SeExprYY_RULE_SETUP
#line 81 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return OR; }
	SeExprYY_BREAK
case 13:
SeExprYY_RULE_SETUP
#line 82 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return AND; }
	SeExprYY_BREAK
case 14:
SeExprYY_RULE_SETUP
#line 83 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return EQ; }
	SeExprYY_BREAK
case 15:
SeExprYY_RULE_SETUP
#line 84 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return NE; }
	SeExprYY_BREAK
case 16:
SeExprYY_RULE_SETUP
#line 85 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return SEEXPR_LE; }
	SeExprYY_BREAK
case 17:
SeExprYY_RULE_SETUP
#line 86 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return SEEXPR_GE; }
	SeExprYY_BREAK
case 18:
SeExprYY_RULE_SETUP
#line 87 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return ARROW; }
	SeExprYY_BREAK
case 19:
SeExprYY_RULE_SETUP
#line 88 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return AddEq; }
	SeExprYY_BREAK
case 20:
SeExprYY_RULE_SETUP
#line 89 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return SubEq; }
	SeExprYY_BREAK
case 21:
SeExprYY_RULE_SETUP
#line 90 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return MultEq; }
	SeExprYY_BREAK
case 22:
SeExprYY_RULE_SETUP
#line 91 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return DivEq; }
	SeExprYY_BREAK
case 23:
SeExprYY_RULE_SETUP
#line 92 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return ModEq; }
	SeExprYY_BREAK
case 24:
SeExprYY_RULE_SETUP
#line 93 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return ExpEq; }
	SeExprYY_BREAK
case 25:
SeExprYY_RULE_SETUP
#line 95 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ SeExprlval.d = M_PI; return NUMBER; }
	SeExprYY_BREAK
case 26:
SeExprYY_RULE_SETUP
#line 96 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ SeExprlval.d = M_E; return NUMBER; }
	SeExprYY_BREAK
case 27:
SeExprYY_RULE_SETUP
#line 97 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ SeExprlval.d = 0; return NUMBER; }
	SeExprYY_BREAK
case 28:
SeExprYY_RULE_SETUP
#line 98 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ SeExprlval.d = 1; return NUMBER; }
	SeExprYY_BREAK
case 29:
SeExprYY_RULE_SETUP
#line 99 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ SeExprlval.d = 2; return NUMBER; }
	SeExprYY_BREAK
case 30:
SeExprYY_RULE_SETUP
#line 100 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ SeExprlval.d = 3; return NUMBER; }
	SeExprYY_BREAK
case 31:
SeExprYY_RULE_SETUP
#line 102 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ SeExprlval.d = KSeExpr::Utils::atof(SeExprtext); return NUMBER; }
	SeExprYY_BREAK
case 32:
SeExprYY_RULE_SETUP
#line 103 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ /* match quoted string, allow embedded quote, \" */
			  SeExprlval.s = strdup(&SeExprtext[1]);
			  SeExprlval.s[strlen(SeExprlval.s)-1] = '\0';
                          return STR; }
	SeExprYY_BREAK
case 33:
SeExprYY_RULE_SETUP
#line 107 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ /* match quoted string, allow embedded quote, \' */
			  SeExprlval.s = strdup(&SeExprtext[1]);
			  SeExprlval.s[strlen(SeExprlval.s)-1] = '\0';
                          return STR; }
	SeExprYY_BREAK
case 34:
SeExprYY_RULE_SETUP
#line 111 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ SeExprlval.s = strdup(&SeExprtext[1]); return VAR; }
	SeExprYY_BREAK
case 35:
SeExprYY_RULE_SETUP
#line 112 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ SeExprlval.s = strdup(&SeExprtext[1]); return VAR; }
	SeExprYY_BREAK
case 36:
SeExprYY_RULE_SETUP
#line 113 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ SeExprlval.s = strdup(SeExprtext); return NAME; }
	SeExprYY_BREAK
case 37:
SeExprYY_RULE_SETUP
#line 115 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
/* ignore quoted newline */;
	SeExprYY_BREAK
case 38:
SeExprYY_RULE_SETUP
#line 116 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
/* ignore quoted tab */;
	SeExprYY_BREAK
case 39:
/* rule 39 can match eol */
SeExprYY_RULE_SETUP
#line 117 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
/* ignore whitespace */;
	SeExprYY_BREAK
case 40:
SeExprYY_RULE_SETUP
#line 118 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ /* match comment */
                         int startPos=SeExprpos(),endPos=SeExprpos()+strlen(&SeExprtext[1])+1;
			  comments->push_back(std::pair<int,int>(startPos,endPos));}
	SeExprYY_BREAK
case 41:
SeExprYY_RULE_SETUP
#line 122 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
{ return SeExprtext[0]; }
	SeExprYY_BREAK
case 42:
SeExprYY_RULE_SETUP
#line 124 "@@PATH@@/src/KSeExpr/ExprParserLex.l"
ECHO;
	SeExprYY_BREAK
#line 1109 "ExprParserLexIn.cpp"
case SeExprYY_STATE_EOF(INITIAL):
	SeExprterminate();

	case SeExprYY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int SeExpr_amount_of_matched_text = (int) (SeExpr_cp - (SeExprtext_ptr)) - 1;

		/* Undo the effects of SeExprYY_DO_BEFORE_ACTION. */
		*SeExpr_cp = (SeExpr_hold_char);
		SeExprYY_RESTORE_SeExprYY_MORE_OFFSET

		if ( SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_buffer_status == SeExprYY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed SeExprin at a new source and called
			 * SeExprlex().  If so, then we have to assure
			 * consistency between SeExprYY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(SeExpr_n_chars) = SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_n_chars;
			SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_input_file = SeExprin;
			SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_buffer_status = SeExprYY_BUFFER_NORMAL;
			}

		/* Note that here we test for SeExpr_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since SeExpr_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (SeExpr_c_buf_p) <= &SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_ch_buf[(SeExpr_n_chars)] )
			{ /* This was really a NUL. */
			SeExpr_state_type SeExpr_next_state;

			(SeExpr_c_buf_p) = (SeExprtext_ptr) + SeExpr_amount_of_matched_text;

			SeExpr_current_state = SeExpr_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * SeExpr_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			SeExpr_next_state = SeExpr_try_NUL_trans( SeExpr_current_state );

			SeExpr_bp = (SeExprtext_ptr) + SeExprYY_MORE_ADJ;

			if ( SeExpr_next_state )
				{
				/* Consume the NUL. */
				SeExpr_cp = ++(SeExpr_c_buf_p);
				SeExpr_current_state = SeExpr_next_state;
				goto SeExpr_match;
				}

			else
				{
				SeExpr_cp = (SeExpr_last_accepting_cpos);
				SeExpr_current_state = (SeExpr_last_accepting_state);
				goto SeExpr_find_action;
				}
			}

		else switch ( SeExpr_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(SeExpr_did_buffer_switch_on_eof) = 0;

				if ( SeExprwrap(  ) )
					{
					/* Note: because we've taken care in
					 * SeExpr_get_next_buffer() to have set up
					 * SeExprtext, we can now set up
					 * SeExpr_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * SeExprYY_NULL, it'll still work - another
					 * SeExprYY_NULL will get returned.
					 */
					(SeExpr_c_buf_p) = (SeExprtext_ptr) + SeExprYY_MORE_ADJ;

					SeExpr_act = SeExprYY_STATE_EOF(SeExprYY_START);
					goto do_action;
					}

				else
					{
					if ( ! (SeExpr_did_buffer_switch_on_eof) )
						SeExprYY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(SeExpr_c_buf_p) =
					(SeExprtext_ptr) + SeExpr_amount_of_matched_text;

				SeExpr_current_state = SeExpr_get_previous_state(  );

				SeExpr_cp = (SeExpr_c_buf_p);
				SeExpr_bp = (SeExprtext_ptr) + SeExprYY_MORE_ADJ;
				goto SeExpr_match;

			case EOB_ACT_LAST_MATCH:
				(SeExpr_c_buf_p) =
				&SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_ch_buf[(SeExpr_n_chars)];

				SeExpr_current_state = SeExpr_get_previous_state(  );

				SeExpr_cp = (SeExpr_c_buf_p);
				SeExpr_bp = (SeExprtext_ptr) + SeExprYY_MORE_ADJ;
				goto SeExpr_find_action;
			}
		break;
		}

	default:
		SeExprYY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of SeExprlex */

/* SeExpr_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int SeExpr_get_next_buffer (void)
{
    	char *dest = SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_ch_buf;
	char *source = (SeExprtext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (SeExpr_c_buf_p) > &SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_ch_buf[(SeExpr_n_chars) + 1] )
		SeExprYY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (SeExpr_c_buf_p) - (SeExprtext_ptr) - SeExprYY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((SeExpr_c_buf_p) - (SeExprtext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_buffer_status == SeExprYY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_n_chars = (SeExpr_n_chars) = 0;

	else
		{
			int num_to_read =
			SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			SeExprYY_BUFFER_STATE b = SeExprYY_CURRENT_BUFFER_LVALUE;

			int SeExpr_c_buf_p_offset =
				(int) ((SeExpr_c_buf_p) - b->SeExpr_ch_buf);

			if ( b->SeExpr_is_our_buffer )
				{
				int new_size = b->SeExpr_buf_size * 2;

				if ( new_size <= 0 )
					b->SeExpr_buf_size += b->SeExpr_buf_size / 8;
				else
					b->SeExpr_buf_size *= 2;

				b->SeExpr_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					SeExprrealloc( (void *) b->SeExpr_ch_buf,
							 (SeExpr_size_t) (b->SeExpr_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->SeExpr_ch_buf = NULL;

			if ( ! b->SeExpr_ch_buf )
				SeExprYY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(SeExpr_c_buf_p) = &b->SeExpr_ch_buf[SeExpr_c_buf_p_offset];

			num_to_read = SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > SeExprYY_READ_BUF_SIZE )
			num_to_read = SeExprYY_READ_BUF_SIZE;

		/* Read in more data. */
		SeExprYY_INPUT( (&SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_ch_buf[number_to_move]),
			(SeExpr_n_chars), num_to_read );

		SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_n_chars = (SeExpr_n_chars);
		}

	if ( (SeExpr_n_chars) == 0 )
		{
		if ( number_to_move == SeExprYY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			SeExprrestart( SeExprin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_buffer_status =
				SeExprYY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((SeExpr_n_chars) + number_to_move) > SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (SeExpr_n_chars) + number_to_move + ((SeExpr_n_chars) >> 1);
		SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_ch_buf = (char *) SeExprrealloc(
			(void *) SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_ch_buf, (SeExpr_size_t) new_size  );
		if ( ! SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_ch_buf )
			SeExprYY_FATAL_ERROR( "out of dynamic memory in SeExpr_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_buf_size = (int) (new_size - 2);
	}

	(SeExpr_n_chars) += number_to_move;
	SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_ch_buf[(SeExpr_n_chars)] = SeExprYY_END_OF_BUFFER_CHAR;
	SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_ch_buf[(SeExpr_n_chars) + 1] = SeExprYY_END_OF_BUFFER_CHAR;

	(SeExprtext_ptr) = &SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_ch_buf[0];

	return ret_val;
}

/* SeExpr_get_previous_state - get the state just before the EOB char was reached */

    static SeExpr_state_type SeExpr_get_previous_state (void)
{
	SeExpr_state_type SeExpr_current_state;
	char *SeExpr_cp;
    
	SeExpr_current_state = (SeExpr_start);

	for ( SeExpr_cp = (SeExprtext_ptr) + SeExprYY_MORE_ADJ; SeExpr_cp < (SeExpr_c_buf_p); ++SeExpr_cp )
		{
		SeExprYY_CHAR SeExpr_c = (*SeExpr_cp ? SeExpr_ec[SeExprYY_SC_TO_UI(*SeExpr_cp)] : 1);
		if ( SeExpr_accept[SeExpr_current_state] )
			{
			(SeExpr_last_accepting_state) = SeExpr_current_state;
			(SeExpr_last_accepting_cpos) = SeExpr_cp;
			}
		while ( SeExpr_chk[SeExpr_base[SeExpr_current_state] + SeExpr_c] != SeExpr_current_state )
			{
			SeExpr_current_state = (int) SeExpr_def[SeExpr_current_state];
			if ( SeExpr_current_state >= 160 )
				SeExpr_c = SeExpr_meta[SeExpr_c];
			}
		SeExpr_current_state = SeExpr_nxt[SeExpr_base[SeExpr_current_state] + SeExpr_c];
		}

	return SeExpr_current_state;
}

/* SeExpr_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = SeExpr_try_NUL_trans( current_state );
 */
    static SeExpr_state_type SeExpr_try_NUL_trans  (SeExpr_state_type SeExpr_current_state )
{
	int SeExpr_is_jam;
    	char *SeExpr_cp = (SeExpr_c_buf_p);

	SeExprYY_CHAR SeExpr_c = 1;
	if ( SeExpr_accept[SeExpr_current_state] )
		{
		(SeExpr_last_accepting_state) = SeExpr_current_state;
		(SeExpr_last_accepting_cpos) = SeExpr_cp;
		}
	while ( SeExpr_chk[SeExpr_base[SeExpr_current_state] + SeExpr_c] != SeExpr_current_state )
		{
		SeExpr_current_state = (int) SeExpr_def[SeExpr_current_state];
		if ( SeExpr_current_state >= 160 )
			SeExpr_c = SeExpr_meta[SeExpr_c];
		}
	SeExpr_current_state = SeExpr_nxt[SeExpr_base[SeExpr_current_state] + SeExpr_c];
	SeExpr_is_jam = (SeExpr_current_state == 159);

		return SeExpr_is_jam ? 0 : SeExpr_current_state;
}

#ifndef SeExprYY_NO_UNPUT

#endif

#ifndef SeExprYY_NO_INPUT
#ifdef __cplusplus
    static int SeExprinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(SeExpr_c_buf_p) = (SeExpr_hold_char);

	if ( *(SeExpr_c_buf_p) == SeExprYY_END_OF_BUFFER_CHAR )
		{
		/* SeExpr_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (SeExpr_c_buf_p) < &SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_ch_buf[(SeExpr_n_chars)] )
			/* This was really a NUL. */
			*(SeExpr_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((SeExpr_c_buf_p) - (SeExprtext_ptr));
			++(SeExpr_c_buf_p);

			switch ( SeExpr_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because SeExpr_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					SeExprrestart( SeExprin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( SeExprwrap(  ) )
						return 0;

					if ( ! (SeExpr_did_buffer_switch_on_eof) )
						SeExprYY_NEW_FILE;
#ifdef __cplusplus
					return SeExprinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(SeExpr_c_buf_p) = (SeExprtext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (SeExpr_c_buf_p);	/* cast for 8-bit char's */
	*(SeExpr_c_buf_p) = '\0';	/* preserve SeExprtext */
	(SeExpr_hold_char) = *++(SeExpr_c_buf_p);

	return c;
}
#endif	/* ifndef SeExprYY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void SeExprrestart  (FILE * input_file )
{
    
	if ( ! SeExprYY_CURRENT_BUFFER ){
        SeExprensure_buffer_stack ();
		SeExprYY_CURRENT_BUFFER_LVALUE =
            SeExpr_create_buffer( SeExprin, SeExprYY_BUF_SIZE );
	}

	SeExpr_init_buffer( SeExprYY_CURRENT_BUFFER, input_file );
	SeExpr_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void SeExpr_switch_to_buffer  (SeExprYY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		SeExprpop_buffer_state();
	 *		SeExprpush_buffer_state(new_buffer);
     */
	SeExprensure_buffer_stack ();
	if ( SeExprYY_CURRENT_BUFFER == new_buffer )
		return;

	if ( SeExprYY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(SeExpr_c_buf_p) = (SeExpr_hold_char);
		SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_buf_pos = (SeExpr_c_buf_p);
		SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_n_chars = (SeExpr_n_chars);
		}

	SeExprYY_CURRENT_BUFFER_LVALUE = new_buffer;
	SeExpr_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (SeExprwrap()) processing, but the only time this flag
	 * is looked at is after SeExprwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(SeExpr_did_buffer_switch_on_eof) = 1;
}

static void SeExpr_load_buffer_state  (void)
{
    	(SeExpr_n_chars) = SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_n_chars;
	(SeExprtext_ptr) = (SeExpr_c_buf_p) = SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_buf_pos;
	SeExprin = SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_input_file;
	(SeExpr_hold_char) = *(SeExpr_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c SeExprYY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    SeExprYY_BUFFER_STATE SeExpr_create_buffer  (FILE * file, int  size )
{
	SeExprYY_BUFFER_STATE b;
    
	b = (SeExprYY_BUFFER_STATE) SeExpralloc( sizeof( struct SeExpr_buffer_state )  );
	if ( ! b )
		SeExprYY_FATAL_ERROR( "out of dynamic memory in SeExpr_create_buffer()" );

	b->SeExpr_buf_size = size;

	/* SeExpr_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->SeExpr_ch_buf = (char *) SeExpralloc( (SeExpr_size_t) (b->SeExpr_buf_size + 2)  );
	if ( ! b->SeExpr_ch_buf )
		SeExprYY_FATAL_ERROR( "out of dynamic memory in SeExpr_create_buffer()" );

	b->SeExpr_is_our_buffer = 1;

	SeExpr_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with SeExpr_create_buffer()
 * 
 */
    void SeExpr_delete_buffer (SeExprYY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == SeExprYY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		SeExprYY_CURRENT_BUFFER_LVALUE = (SeExprYY_BUFFER_STATE) 0;

	if ( b->SeExpr_is_our_buffer )
		SeExprfree( (void *) b->SeExpr_ch_buf  );

	SeExprfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a SeExprrestart() or at EOF.
 */
    static void SeExpr_init_buffer  (SeExprYY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	SeExpr_flush_buffer( b );

	b->SeExpr_input_file = file;
	b->SeExpr_fill_buffer = 1;

    /* If b is the current buffer, then SeExpr_init_buffer was _probably_
     * called from SeExprrestart() or through SeExpr_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != SeExprYY_CURRENT_BUFFER){
        b->SeExpr_bs_lineno = 1;
        b->SeExpr_bs_column = 0;
    }

        b->SeExpr_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, SeExprYY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c SeExprYY_CURRENT_BUFFER.
 * 
 */
    void SeExpr_flush_buffer (SeExprYY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->SeExpr_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->SeExpr_ch_buf[0] = SeExprYY_END_OF_BUFFER_CHAR;
	b->SeExpr_ch_buf[1] = SeExprYY_END_OF_BUFFER_CHAR;

	b->SeExpr_buf_pos = &b->SeExpr_ch_buf[0];

	b->SeExpr_at_bol = 1;
	b->SeExpr_buffer_status = SeExprYY_BUFFER_NEW;

	if ( b == SeExprYY_CURRENT_BUFFER )
		SeExpr_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void SeExprpush_buffer_state (SeExprYY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	SeExprensure_buffer_stack();

	/* This block is copied from SeExpr_switch_to_buffer. */
	if ( SeExprYY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(SeExpr_c_buf_p) = (SeExpr_hold_char);
		SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_buf_pos = (SeExpr_c_buf_p);
		SeExprYY_CURRENT_BUFFER_LVALUE->SeExpr_n_chars = (SeExpr_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (SeExprYY_CURRENT_BUFFER)
		(SeExpr_buffer_stack_top)++;
	SeExprYY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from SeExpr_switch_to_buffer. */
	SeExpr_load_buffer_state(  );
	(SeExpr_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void SeExprpop_buffer_state (void)
{
    	if (!SeExprYY_CURRENT_BUFFER)
		return;

	SeExpr_delete_buffer(SeExprYY_CURRENT_BUFFER );
	SeExprYY_CURRENT_BUFFER_LVALUE = NULL;
	if ((SeExpr_buffer_stack_top) > 0)
		--(SeExpr_buffer_stack_top);

	if (SeExprYY_CURRENT_BUFFER) {
		SeExpr_load_buffer_state(  );
		(SeExpr_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void SeExprensure_buffer_stack (void)
{
	SeExpr_size_t num_to_alloc;
    
	if (!(SeExpr_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(SeExpr_buffer_stack) = (struct SeExpr_buffer_state**)SeExpralloc
								(num_to_alloc * sizeof(struct SeExpr_buffer_state*)
								);
		if ( ! (SeExpr_buffer_stack) )
			SeExprYY_FATAL_ERROR( "out of dynamic memory in SeExprensure_buffer_stack()" );

		memset((SeExpr_buffer_stack), 0, num_to_alloc * sizeof(struct SeExpr_buffer_state*));

		(SeExpr_buffer_stack_max) = num_to_alloc;
		(SeExpr_buffer_stack_top) = 0;
		return;
	}

	if ((SeExpr_buffer_stack_top) >= ((SeExpr_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		SeExpr_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (SeExpr_buffer_stack_max) + grow_size;
		(SeExpr_buffer_stack) = (struct SeExpr_buffer_state**)SeExprrealloc
								((SeExpr_buffer_stack),
								num_to_alloc * sizeof(struct SeExpr_buffer_state*)
								);
		if ( ! (SeExpr_buffer_stack) )
			SeExprYY_FATAL_ERROR( "out of dynamic memory in SeExprensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((SeExpr_buffer_stack) + (SeExpr_buffer_stack_max), 0, grow_size * sizeof(struct SeExpr_buffer_state*));
		(SeExpr_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
SeExprYY_BUFFER_STATE SeExpr_scan_buffer  (char * base, SeExpr_size_t  size )
{
	SeExprYY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != SeExprYY_END_OF_BUFFER_CHAR ||
	     base[size-1] != SeExprYY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (SeExprYY_BUFFER_STATE) SeExpralloc( sizeof( struct SeExpr_buffer_state )  );
	if ( ! b )
		SeExprYY_FATAL_ERROR( "out of dynamic memory in SeExpr_scan_buffer()" );

	b->SeExpr_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->SeExpr_buf_pos = b->SeExpr_ch_buf = base;
	b->SeExpr_is_our_buffer = 0;
	b->SeExpr_input_file = NULL;
	b->SeExpr_n_chars = b->SeExpr_buf_size;
	b->SeExpr_is_interactive = 0;
	b->SeExpr_at_bol = 1;
	b->SeExpr_fill_buffer = 0;
	b->SeExpr_buffer_status = SeExprYY_BUFFER_NEW;

	SeExpr_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to SeExprlex() will
 * scan from a @e copy of @a str.
 * @param SeExprstr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       SeExpr_scan_bytes() instead.
 */
SeExprYY_BUFFER_STATE SeExpr_scan_string (const char * SeExprstr )
{
    
	return SeExpr_scan_bytes( SeExprstr, (int) strlen(SeExprstr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to SeExprlex() will
 * scan from a @e copy of @a bytes.
 * @param SeExprbytes the byte buffer to scan
 * @param _SeExprbytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
SeExprYY_BUFFER_STATE SeExpr_scan_bytes  (const char * SeExprbytes, int  _SeExprbytes_len )
{
	SeExprYY_BUFFER_STATE b;
	char *buf;
	SeExpr_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (SeExpr_size_t) (_SeExprbytes_len + 2);
	buf = (char *) SeExpralloc( n  );
	if ( ! buf )
		SeExprYY_FATAL_ERROR( "out of dynamic memory in SeExpr_scan_bytes()" );

	for ( i = 0; i < _SeExprbytes_len; ++i )
		buf[i] = SeExprbytes[i];

	buf[_SeExprbytes_len] = buf[_SeExprbytes_len+1] = SeExprYY_END_OF_BUFFER_CHAR;

	b = SeExpr_scan_buffer( buf, n );
	if ( ! b )
		SeExprYY_FATAL_ERROR( "bad buffer in SeExpr_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->SeExpr_is_our_buffer = 1;

	return b;
}

#ifndef SeExprYY_EXIT_FAILURE
#define SeExprYY_EXIT_FAILURE 2
#endif

static void SeExprnoreturn SeExpr_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( SeExprYY_EXIT_FAILURE );
}

/* Redefine SeExprless() so it works in section 3 code. */

#undef SeExprless
#define SeExprless(n) \
	do \
		{ \
		/* Undo effects of setting up SeExprtext. */ \
        int SeExprless_macro_arg = (n); \
        SeExprYY_LESS_LINENO(SeExprless_macro_arg);\
		SeExprtext[SeExprleng] = (SeExpr_hold_char); \
		(SeExpr_c_buf_p) = SeExprtext + SeExprless_macro_arg; \
		(SeExpr_hold_char) = *(SeExpr_c_buf_p); \
		*(SeExpr_c_buf_p) = '\0'; \
		SeExprleng = SeExprless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int SeExprget_lineno  (void)
{
    
    return SeExprlineno;
}

/** Get the input stream.
 * 
 */
FILE *SeExprget_in  (void)
{
        return SeExprin;
}

/** Get the output stream.
 * 
 */
FILE *SeExprget_out  (void)
{
        return SeExprout;
}

/** Get the length of the current token.
 * 
 */
int SeExprget_leng  (void)
{
        return SeExprleng;
}

/** Get the current token.
 * 
 */

char *SeExprget_text  (void)
{
        return SeExprtext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void SeExprset_lineno (int  _line_number )
{
    
    SeExprlineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see SeExpr_switch_to_buffer
 */
void SeExprset_in (FILE *  _in_str )
{
        SeExprin = _in_str ;
}

void SeExprset_out (FILE *  _out_str )
{
        SeExprout = _out_str ;
}

int SeExprget_debug  (void)
{
        return SeExpr_flex_debug;
}

void SeExprset_debug (int  _bdebug )
{
        SeExpr_flex_debug = _bdebug ;
}

static int SeExpr_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from SeExprlex_destroy(), so don't allocate here.
     */

    (SeExpr_buffer_stack) = NULL;
    (SeExpr_buffer_stack_top) = 0;
    (SeExpr_buffer_stack_max) = 0;
    (SeExpr_c_buf_p) = NULL;
    (SeExpr_init) = 0;
    (SeExpr_start) = 0;

/* Defined in main.c */
#ifdef SeExprYY_STDINIT
    SeExprin = stdin;
    SeExprout = stdout;
#else
    SeExprin = NULL;
    SeExprout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * SeExprlex_init()
     */
    return 0;
}

/* SeExprlex_destroy is for both reentrant and non-reentrant scanners. */
int SeExprlex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(SeExprYY_CURRENT_BUFFER){
		SeExpr_delete_buffer( SeExprYY_CURRENT_BUFFER  );
		SeExprYY_CURRENT_BUFFER_LVALUE = NULL;
		SeExprpop_buffer_state();
	}

	/* Destroy the stack itself. */
	SeExprfree((SeExpr_buffer_stack) );
	(SeExpr_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * SeExprlex() is called, initialization will occur. */
    SeExpr_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef SeExprtext_ptr
static void SeExpr_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef SeExprYY_NEED_STRLEN
static int SeExpr_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *SeExpralloc (SeExpr_size_t  size )
{
			return malloc(size);
}

void *SeExprrealloc  (void * ptr, SeExpr_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void SeExprfree (void * ptr )
{
			free( (char *) ptr );	/* see SeExprrealloc() for (char *) cast */
}

#define SeExprYYTABLES_NAME "SeExprtables"

#line 124 "@@PATH@@/src/KSeExpr/ExprParserLex.l"


/* Gets index of current token (corresponding to SeExprtext).
   Used for error reporting.
 */
int SeExprpos()
{
    return SeExpr_c_buf_p - SeExprYY_CURRENT_BUFFER->SeExpr_ch_buf - SeExprleng;
}

