""" Collection of python utility-methodes commonly used by other
    bibliograph packages.
    From http://pypi.python.org/pypi/bibliograph.core/
    from Tom Gross <itconsense@gmail.com>

    Adapted for calibre use

    Zope Public License (ZPL) Version 2.1

    A copyright notice accompanies this license document that
    identifies the copyright holders.

    This license has been certified as open source. It has also
    been designated as GPL compatible by the Free Software
    Foundation (FSF).

    Redistribution and use in source and binary forms, with or
    without modification, are permitted provided that the
    following conditions are met:

    1. Redistributions in source code must retain the
       accompanying copyright notice, this list of conditions,
       and the following disclaimer.

    2. Redistributions in binary form must reproduce the accompanying
       copyright notice, this list of conditions, and the
       following disclaimer in the documentation and/or other
       materials provided with the distribution.

    3. Names of the copyright holders must not be used to
       endorse or promote products derived from this software
       without prior written permission from the copyright
       holders.

    4. The right to distribute this software or to use it for
       any purpose does not give you the right to use
       Servicemarks (sm) or Trademarks (tm) of the copyright
       holders. Use of them is covered by separate agreement
       with the copyright holders.

    5. If any files are modified, you must cause the modified
       files to carry prominent notices stating that you changed
       the files and the date of any change.

    Disclaimer

      THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS''
      AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT
      NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
      AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
      NO EVENT SHALL THE COPYRIGHT HOLDERS BE
      LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
      EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
      LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
      LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
      HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
      CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
      OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
      SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
      DAMAGE.
    """

__author__  = 'sengian <sengian1 at gmail.com>'
__docformat__ = 'restructuredtext en'

import re, string

from calibre.utils.mreplace import MReplace

utf8enc2latex_mapping = {
    # This is a mapping of Unicode characters to LaTeX equivalents.
    # The information has been extracted from
    # <http://www.w3.org/2003/entities/xml/unicode.xml>, written by
    # David Carlisle and Sebastian Rahtz.
    #
    # The extraction has been done by the "create_unimap.py" script
    # located at <http://docutils.sf.net/tools/dev/create_unimap.py>.

    # Fix some encoding problem between cp1252 and latin1
    # from http://www.microsoft.com/typography/unicode/1252.htm
    u'\x80': '{\\texteuro}',  # EURO SIGN
    u'\x82': '{,}',  # SINGLE LOW-9 QUOTATION MARK
    u'\x83': '$f$',  # LATIN SMALL LETTER F WITH HOOK
    u'\x84': '{,,}',  # DOUBLE LOW-9 QUOTATION MARK
    u'\x85': '{\\ldots}',  # HORIZONTAL ELLIPSIS
    u'\x86': '{\\textdagger}',  # DAGGER
    u'\x87': '{\\textdaggerdbl}',  # DOUBLE DAGGER
    u'\x88': '{\textasciicircum}',  # MODIFIER LETTER CIRCUMFLEX ACCENT
    u'\x89': '{\\textperthousand}',  # PER MILLE SIGN
    u'\x8A': '{\\v{S}}',  # LATIN CAPITAL LETTER S WITH CARON
    u'\x8B': '{\\guilsinglleft}',  # SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    u'\x8C': '{\\OE}',  # LATIN CAPITAL LIGATURE OE
    u'\x8E': '{\\v{Z}}',  # LATIN CAPITAL LETTER Z WITH CARON
    u'\x91': '{`}',  # LEFT SINGLE QUOTATION MARK
    u'\x92': "{'}",  # RIGHT SINGLE QUOTATION MARK
    u'\x93': '{\\textquotedblleft}',  # LEFT DOUBLE QUOTATION MARK
    u'\x94': '{\\textquotedblright}',  # RIGHT DOUBLE QUOTATION MARK
    u'\x95': '{\\textbullet}',  # BULLET
    u'\x96': '{\\textendash}',  # EN DASH
    u'\x97': '{\\textemdash}',  # EM DASH
    u'\x98': '{\\texttildelow}',  # SMALL TILDE
    u'\x99': '{\\texttrademark}',  # TRADE MARK SIGN
    u'\x9A': '{\\v{s}}',  # LATIN SMALL LETTER S WITH CARON
    u'\x9B': '{\\guilsinglright}',  # SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    u'\x9C': '{\\oe}',  # LATIN SMALL LIGATURE OE
    u'\x9E': '{\\v{z}}',  # LATIN SMALL LETTER Z WITH CARON
    u'\x9F': '{\\"{Y}}',  # LATIN CAPITAL LETTER Y WITH DIAERESIS

    u'\xa1': '{\\textexclamdown}',
    u'\xa2': '{\\textcent}',
    u'\xa3': '{\\textsterling}',
    u'\xa4': '{\\textcurrency}',
    u'\xa5': '{\\textyen}',
    u'\xa6': '{\\textbrokenbar}',
    u'\xa7': '{\\textsection}',
    u'\xa8': '{\\textasciidieresis}',
    u'\xa9': '{\\textcopyright}',
    u'\xaa': '{\\textordfeminine}',
    u'\xab': '{\\guillemotleft}',
    u'\xad': '$\\-$',
    u'\xae': '{\\textregistered}',
    u'\xaf': '{\\textasciimacron}',
    u'\xb0': '{\\textdegree}',
    u'\xb6': '{\\textparagraph}',
    u'\xba': '{\\textordmasculine}',
    u'\xbb': '{\\guillemotright}',
    u'\xbc': '{\\textonequarter}',
    u'\xbd': '{\\textonehalf}',
    u'\xbe': '{\\textthreequarters}',
    u'\xbf': '{\\textquestiondown}',
    u'\xc6': '{\\AE}',
    u'\xd0': '{\\DH}',
    u'\xd7': '{\\texttimes}',
    u'\xd8': '{\\O}',
    u'\xde': '{\\TH}',
    u'\xdf': '{\\ss}',
    u'\xe6': '{\\ae}',
    u'\xf0': '{\\dh}',
    u'\xf8': '{\\o}',
    u'\xfe': '{\\th}',
    u'\u0100': '{\\={A}}',
    u'\u0101': '{\\={a}}',
    u'\u0108': '{\\^{C}}',
    u'\u0109': '{\\^{c}}',
    u'\u010a': '{\\.{C}}',
    u'\u010b': '{\\.{c}}',
    u'\u0110': '{\\DJ}',
    u'\u0111': '{\\dj}',
    u'\u0112': '{\\={E}}',
    u'\u0113': '{\\={e}}',
    u'\u0114': '{\\u{E}}',
    u'\u0115': '{\\u{e}}',
    u'\u0116': '{\\.{E}}',
    u'\u0117': '{\\.{e}}',
    u'\u011c': '{\\^{G}}',
    u'\u011d': '{\\^{g}}',
    u'\u0120': '{\\.{G}}',
    u'\u0121': '{\\.{g}}',
    u'\u0122': '{\\c{G}}',
    u'\u0123': '{\\c{g}}',
    u'\u0124': '{\\^{H}}',
    u'\u0125': '{\\^{h}}',
    u'\u0126': '{{\\fontencoding{LELA}\\selectfont\\char40}}',
    u'\u0127': '$\\Elzxh$',
    u'\u0128': '{\\~{I}}',
    u'\u0129': '{\\~{\\i}}',
    u'\u012a': '{\\={I}}',
    u'\u012b': '{\\={\\i}}',
    u'\u012c': '{\\u{I}}',
    u'\u012d': '{\\u{\\i}}',
    u'\u012e': '{\\k{I}}',
    u'\u012f': '{\\k{i}}',
    u'\u0131': '{\\i}',
    u'\u0132': '{IJ}',
    u'\u0133': '{ij}',
    u'\u0134': '{\\^{J}}',
    u'\u0135': '{\\^{\\j}}',
    u'\u0136': '{\\c{K}}',
    u'\u0137': '{\\c{k}}',
    u'\u0138': '{{\\fontencoding{LELA}\\selectfont\\char91}}',
    u'\u013b': '{\\c{L}}',
    u'\u013c': '{\\c{l}}',
    u'\u013f': '{{\\fontencoding{LELA}\\selectfont\\char201}}',
    u'\u0140': '{{\\fontencoding{LELA}\\selectfont\\char202}}',
    u'\u0141': '{\\L}',
    u'\u0142': '{\\l}',
    u'\u0145': '{\\c{N}}',
    u'\u0146': '{\\c{n}}',
    u'\u0149': "{'n}",
    u'\u014a': '{\\NG}',
    u'\u014b': '{\\ng}',
    u'\u014c': '{\\={O}}',
    u'\u014d': '{\\={o}}',
    u'\u014e': '{\\u{O}}',
    u'\u014f': '{\\u{o}}',
    u'\u0152': '{\\OE}',
    u'\u0153': '{\\oe}',
    u'\u0156': '{\\c{R}}',
    u'\u0157': '{\\c{r}}',
    u'\u015c': '{\\^{S}}',
    u'\u015d': '{\\^{s}}',
    u'\u0166': '{{\\fontencoding{LELA}\\selectfont\\char47}}',
    u'\u0167': '{{\\fontencoding{LELA}\\selectfont\\char63}}',
    u'\u0168': '{\\~{U}}',
    u'\u0169': '{\\~{u}}',
    u'\u016a': '{\\={U}}',
    u'\u016b': '{\\={u}}',
    u'\u016c': '{\\u{U}}',
    u'\u016d': '{\\u{u}}',
    u'\u0172': '{\\k{U}}',
    u'\u0173': '{\\k{u}}',
    u'\u0174': '{\\^{W}}',
    u'\u0175': '{\\^{w}}',
    u'\u0176': '{\\^{Y}}',
    u'\u0177': '{\\^{y}}',
    u'\u0195': '{\\texthvlig}',
    u'\u019e': '{\\textnrleg}',
    u'\u01aa': '$\\eth$',
    u'\u01ba': '{{\\fontencoding{LELA}\\selectfont\\char195}}',
    u'\u01c2': '{\\textdoublepipe}',
    u'\u01f5': "{\\'{g}}",
    u'\u0250': '$\\Elztrna$',
    u'\u0252': '$\\Elztrnsa$',
    u'\u0254': '$\\Elzopeno$',
    u'\u0256': '$\\Elzrtld$',
    u'\u0258': '{{\\fontencoding{LEIP}\\selectfont\\char61}}',
    u'\u0259': '$\\Elzschwa$',
    u'\u025b': '$\\varepsilon$',
    u'\u0261': '{g}',
    u'\u0263': '$\\Elzpgamma$',
    u'\u0264': '$\\Elzpbgam$',
    u'\u0265': '$\\Elztrnh$',
    u'\u026c': '$\\Elzbtdl$',
    u'\u026d': '$\\Elzrtll$',
    u'\u026f': '$\\Elztrnm$',
    u'\u0270': '$\\Elztrnmlr$',
    u'\u0271': '$\\Elzltlmr$',
    u'\u0272': '{\\Elzltln}',
    u'\u0273': '$\\Elzrtln$',
    u'\u0277': '$\\Elzclomeg$',
    u'\u0278': '{\\textphi}',
    u'\u0279': '$\\Elztrnr$',
    u'\u027a': '$\\Elztrnrl$',
    u'\u027b': '$\\Elzrttrnr$',
    u'\u027c': '$\\Elzrl$',
    u'\u027d': '$\\Elzrtlr$',
    u'\u027e': '$\\Elzfhr$',
    u'\u027f': '{{\\fontencoding{LEIP}\\selectfont\\char202}}',
    u'\u0282': '$\\Elzrtls$',
    u'\u0283': '$\\Elzesh$',
    u'\u0287': '$\\Elztrnt$',
    u'\u0288': '$\\Elzrtlt$',
    u'\u028a': '$\\Elzpupsil$',
    u'\u028b': '$\\Elzpscrv$',
    u'\u028c': '$\\Elzinvv$',
    u'\u028d': '$\\Elzinvw$',
    u'\u028e': '$\\Elztrny$',
    u'\u0290': '$\\Elzrtlz$',
    u'\u0292': '$\\Elzyogh$',
    u'\u0294': '$\\Elzglst$',
    u'\u0295': '$\\Elzreglst$',
    u'\u0296': '$\\Elzinglst$',
    u'\u029e': '{\\textturnk}',
    u'\u02a4': '$\\Elzdyogh$',
    u'\u02a7': '$\\Elztesh$',
    u'\u02bc': "{'}",
    u'\u02c7': '{\\textasciicaron}',
    u'\u02c8': '$\\Elzverts$',
    u'\u02cc': '$\\Elzverti$',
    u'\u02d0': '$\\Elzlmrk$',
    u'\u02d1': '$\\Elzhlmrk$',
    u'\u02d2': '$\\Elzsbrhr$',
    u'\u02d3': '$\\Elzsblhr$',
    u'\u02d4': '$\\Elzrais$',
    u'\u02d5': '$\\Elzlow$',
    u'\u02d8': '{\\textasciibreve}',
    u'\u02d9': '{\\textperiodcentered}',
    u'\u02da': '{\\r{}}',
    u'\u02db': '{\\k{}}',
    u'\u02dc': '{\\texttildelow}',
    u'\u02e5': '{\\tone{55}}',
    u'\u02e6': '{\\tone{44}}',
    u'\u02e7': '{\\tone{33}}',
    u'\u02e8': '{\\tone{22}}',
    u'\u02e9': '{\\tone{11}}',
    u'\u0300': '{\\`}',
    u'\u0301': "{\\'}",
    u'\u0302': '{\\^}',
    u'\u0303': '{\\~}',
    u'\u0304': '{\\=}',
    u'\u0306': '{\\u}',
    u'\u0307': '{\\.}',
    u'\u0308': '{\\"}',
    u'\u030a': '{\\r}',
    u'\u030b': '{\\H}',
    u'\u030c': '{\\v}',
    u'\u030f': '{\\cyrchar\\C}',
    u'\u0311': '{{\\fontencoding{LECO}\\selectfont\\char177}}',
    u'\u0318': '{{\\fontencoding{LECO}\\selectfont\\char184}}',
    u'\u0319': '{{\\fontencoding{LECO}\\selectfont\\char185}}',
    u'\u0321': '$\\Elzpalh$',
    u'\u0322': '{\\Elzrh}',
    u'\u0327': '{\\c}',
    u'\u0328': '{\\k}',
    u'\u032a': '$\\Elzsbbrg$',
    u'\u032b': '{{\\fontencoding{LECO}\\selectfont\\char203}}',
    u'\u032f': '{{\\fontencoding{LECO}\\selectfont\\char207}}',
    u'\u0335': '{\\Elzxl}',
    u'\u0336': '{\\Elzbar}',
    u'\u0337': '{{\\fontencoding{LECO}\\selectfont\\char215}}',
    u'\u0338': '{{\\fontencoding{LECO}\\selectfont\\char216}}',
    u'\u033a': '{{\\fontencoding{LECO}\\selectfont\\char218}}',
    u'\u033b': '{{\\fontencoding{LECO}\\selectfont\\char219}}',
    u'\u033c': '{{\\fontencoding{LECO}\\selectfont\\char220}}',
    u'\u033d': '{{\\fontencoding{LECO}\\selectfont\\char221}}',
    u'\u0361': '{{\\fontencoding{LECO}\\selectfont\\char225}}',
    u'\u0386': "{\\'{A}}",
    u'\u0388': "{\\'{E}}",
    u'\u0389': "{\\'{H}}",
    u'\u038a': "{\\'{}{I}}",
    u'\u038c': "{\\'{}O}",
    u'\u038e': "$\\mathrm{'Y}$",
    u'\u038f': "$\\mathrm{'\\Omega}$",
    u'\u0390': '$\\acute{\\ddot{\\iota}}$',
    u'\u0391': '$\\Alpha$',
    u'\u0392': '$\\Beta$',
    u'\u0393': '$\\Gamma$',
    u'\u0394': '$\\Delta$',
    u'\u0395': '$\\Epsilon$',
    u'\u0396': '$\\Zeta$',
    u'\u0397': '$\\Eta$',
    u'\u0398': '$\\Theta$',
    u'\u0399': '$\\Iota$',
    u'\u039a': '$\\Kappa$',
    u'\u039b': '$\\Lambda$',
    u'\u039c': '$M$',
    u'\u039d': '$N$',
    u'\u039e': '$\\Xi$',
    u'\u039f': '$O$',
    u'\u03a0': '$\\Pi$',
    u'\u03a1': '$\\Rho$',
    u'\u03a3': '$\\Sigma$',
    u'\u03a4': '$\\Tau$',
    u'\u03a5': '$\\Upsilon$',
    u'\u03a6': '$\\Phi$',
    u'\u03a8': '$\\Psi$',
    u'\u03a9': '$\\Omega$',
    u'\u03aa': '$\\mathrm{\\ddot{I}}$',
    u'\u03ab': '$\\mathrm{\\ddot{Y}}$',
    u'\u03ac': "{\\'{$\\alpha$}}",
    u'\u03ad': '$\\acute{\\epsilon}$',
    u'\u03ae': '$\\acute{\\eta}$',
    u'\u03af': '$\\acute{\\iota}$',
    u'\u03b0': '$\\acute{\\ddot{\\upsilon}}$',
    u'\u03b1': '$\\alpha$',
    u'\u03b2': '$\\beta$',
    u'\u03b3': '$\\gamma$',
    u'\u03b4': '$\\delta$',
    u'\u03b5': '$\\epsilon$',
    u'\u03b6': '$\\zeta$',
    u'\u03b7': '$\\eta$',
    u'\u03b8': '{\\texttheta}',
    u'\u03b9': '$\\iota$',
    u'\u03ba': '$\\kappa$',
    u'\u03bb': '$\\lambda$',
    u'\u03bc': '$\\mu$',
    u'\u03be': '$\\xi$',
    u'\u03bf': '$o$',
    u'\u03c0': '$\\pi$',
    u'\u03c1': '$\\rho$',
    u'\u03c2': '$\\varsigma$',
    u'\u03c3': '$\\sigma$',
    u'\u03c4': '$\\tau$',
    u'\u03c5': '$\\upsilon$',
    u'\u03c6': '$\\varphi$',
    u'\u03c7': '$\\chi$',
    u'\u03c8': '$\\psi$',
    u'\u03c9': '$\\omega$',
    u'\u03ca': '$\\ddot{\\iota}$',
    u'\u03cb': '$\\ddot{\\upsilon}$',
    u'\u03cc': "{\\'{o}}",
    u'\u03cd': '$\\acute{\\upsilon}$',
    u'\u03ce': '$\\acute{\\omega}$',
    u'\u03d0': '{\\Pisymbol{ppi022}{87}}',
    u'\u03d1': '{\\textvartheta}',
    u'\u03d2': '$\\Upsilon$',
    u'\u03d5': '$\\phi$',
    u'\u03d6': '$\\varpi$',
    u'\u03da': '$\\Stigma$',
    u'\u03dc': '$\\Digamma$',
    u'\u03dd': '$\\digamma$',
    u'\u03de': '$\\Koppa$',
    u'\u03e0': '$\\Sampi$',
    u'\u03f0': '$\\varkappa$',
    u'\u03f1': '$\\varrho$',
    u'\u03f4': '{\\textTheta}',
    u'\u03f6': '$\\backepsilon$',
    u'\u0403': "{\\cyrchar{\\'\\CYRG}}",
    u'\u040c': "{\\cyrchar{\\'\\CYRK}}",
    u'\u0453': "{\\cyrchar{\\'\\cyrg}}",
    u'\u045c': "{\\cyrchar{\\'\\cyrk}}",
    u'\u0460': '{\\cyrchar\\CYROMEGA}',
    u'\u0461': '{\\cyrchar\\cyromega}',
    u'\u0464': '{\\cyrchar\\CYRIOTE}',
    u'\u0465': '{\\cyrchar\\cyriote}',
    u'\u0466': '{\\cyrchar\\CYRLYUS}',
    u'\u0467': '{\\cyrchar\\cyrlyus}',
    u'\u0468': '{\\cyrchar\\CYRIOTLYUS}',
    u'\u0469': '{\\cyrchar\\cyriotlyus}',
    u'\u046c': '{\\cyrchar\\CYRIOTBYUS}',
    u'\u046d': '{\\cyrchar\\cyriotbyus}',
    u'\u046e': '{\\cyrchar\\CYRKSI}',
    u'\u046f': '{\\cyrchar\\cyrksi}',
    u'\u0470': '{\\cyrchar\\CYRPSI}',
    u'\u0471': '{\\cyrchar\\cyrpsi}',
    u'\u0478': '{\\cyrchar\\CYRUK}',
    u'\u0479': '{\\cyrchar\\cyruk}',
    u'\u047a': '{\\cyrchar\\CYROMEGARND}',
    u'\u047b': '{\\cyrchar\\cyromegarnd}',
    u'\u047c': '{\\cyrchar\\CYROMEGATITLO}',
    u'\u047d': '{\\cyrchar\\cyromegatitlo}',
    u'\u047e': '{\\cyrchar\\CYROT}',
    u'\u047f': '{\\cyrchar\\cyrot}',
    u'\u0480': '{\\cyrchar\\CYRKOPPA}',
    u'\u0481': '{\\cyrchar\\cyrkoppa}',
    u'\u0482': '{\\cyrchar\\cyrthousands}',
    u'\u0488': '{\\cyrchar\\cyrhundredthousands}',
    u'\u0489': '{\\cyrchar\\cyrmillions}',
    u'\u2002': '{\\hspace{0.6em}}',
    u'\u2003': '{\\hspace{1em}}',
    u'\u2004': '{\\hspace{0.33em}}',
    u'\u2005': '{\\hspace{0.25em}}',
    u'\u2006': '{\\hspace{0.166em}}',
    u'\u2007': '{\\hphantom{0}}',
    u'\u2008': '{\\hphantom{,}}',
    u'\u2009': '{\\hspace{0.167em}}',
    u'\u200a': '$\\mkern1mu$',
    u'\u2010': '{-}',
    u'\u2013': '{\\textendash}',
    u'\u2014': '{\\textemdash}',
    u'\u2015': '{\\rule{1em}{1pt}}',
    u'\u201b': '$\\Elzreapos$',
    u'\u201c': '{\\textquotedblleft}',
    u'\u201d': '{\\textquotedblright}',
    u'\u2020': '{\\textdagger}',
    u'\u2021': '{\\textdaggerdbl}',
    u'\u2022': '{\\textbullet}',
    u'\u2024': '{.}',
    u'\u2025': '{..}',
    u'\u2030': '{\\textperthousand}',
    u'\u2031': '{\\textpertenthousand}',
    u'\u2033': "${''}$",
    u'\u2034': "${'''}$",
    u'\u2035': '$\\backprime$',
    u'\u2039': '{\\guilsinglleft}',
    u'\u203a': '{\\guilsinglright}',
    u'\u2057': "$''''$",
    u'\u205f': '{\\mkern4mu}',
    u'\u2060': '{\\nolinebreak}',
    u'\u20a7': '{\\ensuremath{\\Elzpes}}',
    u'\u20ac': '{\\texteuro}',
    u'\u20db': '$\\dddot$',
    u'\u20dc': '$\\ddddot$',
    u'\u2102': '$\\mathbb{C}$',
    u'\u210a': '{\\mathscr{g}}',
    u'\u210b': '$\\mathscr{H}$',
    u'\u210c': '$\\mathfrak{H}$',
    u'\u210d': '$\\mathbb{H}$',
    u'\u210f': '$\\hslash$',
    u'\u2110': '$\\mathscr{I}$',
    u'\u2111': '$\\mathfrak{I}$',
    u'\u2112': '$\\mathscr{L}$',
    u'\u2113': '$\\mathscr{l}$',
    u'\u2115': '$\\mathbb{N}$',
    u'\u2118': '$\\wp$',
    u'\u2119': '$\\mathbb{P}$',
    u'\u211a': '$\\mathbb{Q}$',
    u'\u211b': '$\\mathscr{R}$',
    u'\u211c': '$\\mathfrak{R}$',
    u'\u211d': '$\\mathbb{R}$',
    u'\u2122': '{\\texttrademark}',
    u'\u2124': '$\\mathbb{Z}$',
    u'\u2128': '$\\mathfrak{Z}$',
    u'\u2129': '$\\ElsevierGlyph{2129}$',
    u'\u212b': '{\\AA}',
    u'\u212c': '$\\mathscr{B}$',
    u'\u212d': '$\\mathfrak{C}$',
    u'\u212f': '$\\mathscr{e}$',
    u'\u2130': '$\\mathscr{E}$',
    u'\u2131': '$\\mathscr{F}$',
    u'\u2133': '$\\mathscr{M}$',
    u'\u2134': '$\\mathscr{o}$',
    u'\u2135': '$\\aleph$',
    u'\u2136': '$\\beth$',
    u'\u2137': '$\\gimel$',
    u'\u2138': '$\\daleth$',
    u'\u2153': '$\\textfrac{1}{3}$',
    u'\u2154': '$\\textfrac{2}{3}$',
    u'\u2155': '$\\textfrac{1}{5}$',
    u'\u2156': '$\\textfrac{2}{5}$',
    u'\u2157': '$\\textfrac{3}{5}$',
    u'\u2158': '$\\textfrac{4}{5}$',
    u'\u2159': '$\\textfrac{1}{6}$',
    u'\u215a': '$\\textfrac{5}{6}$',
    u'\u215b': '$\\textfrac{1}{8}$',
    u'\u215c': '$\\textfrac{3}{8}$',
    u'\u215d': '$\\textfrac{5}{8}$',
    u'\u215e': '$\\textfrac{7}{8}$',
    u'\u2194': '$\\leftrightarrow$',
    u'\u2195': '$\\updownarrow$',
    u'\u2196': '$\\nwarrow$',
    u'\u2197': '$\\nearrow$',
    u'\u2198': '$\\searrow$',
    u'\u2199': '$\\swarrow$',
    u'\u219a': '$\\nleftarrow$',
    u'\u219b': '$\\nrightarrow$',
    u'\u219c': '$\\arrowwaveright$',
    u'\u219d': '$\\arrowwaveright$',
    u'\u219e': '$\\twoheadleftarrow$',
    u'\u21a0': '$\\twoheadrightarrow$',
    u'\u21a2': '$\\leftarrowtail$',
    u'\u21a3': '$\\rightarrowtail$',
    u'\u21a6': '$\\mapsto$',
    u'\u21a9': '$\\hookleftarrow$',
    u'\u21aa': '$\\hookrightarrow$',
    u'\u21ab': '$\\looparrowleft$',
    u'\u21ac': '$\\looparrowright$',
    u'\u21ad': '$\\leftrightsquigarrow$',
    u'\u21ae': '$\\nleftrightarrow$',
    u'\u21b0': '$\\Lsh$',
    u'\u21b1': '$\\Rsh$',
    u'\u21b3': '$\\ElsevierGlyph{21B3}$',
    u'\u21b6': '$\\curvearrowleft$',
    u'\u21b7': '$\\curvearrowright$',
    u'\u21ba': '$\\circlearrowleft$',
    u'\u21bb': '$\\circlearrowright$',
    u'\u21bc': '$\\leftharpoonup$',
    u'\u21bd': '$\\leftharpoondown$',
    u'\u21be': '$\\upharpoonright$',
    u'\u21bf': '$\\upharpoonleft$',
    u'\u21c0': '$\\rightharpoonup$',
    u'\u21c1': '$\\rightharpoondown$',
    u'\u21c2': '$\\downharpoonright$',
    u'\u21c3': '$\\downharpoonleft$',
    u'\u21c4': '$\\rightleftarrows$',
    u'\u21c5': '$\\dblarrowupdown$',
    u'\u21c6': '$\\leftrightarrows$',
    u'\u21c7': '$\\leftleftarrows$',
    u'\u21c8': '$\\upuparrows$',
    u'\u21c9': '$\\rightrightarrows$',
    u'\u21ca': '$\\downdownarrows$',
    u'\u21cb': '$\\leftrightharpoons$',
    u'\u21cc': '$\\rightleftharpoons$',
    u'\u21cd': '$\\nLeftarrow$',
    u'\u21ce': '$\\nLeftrightarrow$',
    u'\u21cf': '$\\nRightarrow$',
    u'\u21d0': '$\\Leftarrow$',
    u'\u21d1': '$\\Uparrow$',
    u'\u21d2': '$\\Rightarrow$',
    u'\u21d3': '$\\Downarrow$',
    u'\u21d4': '$\\Leftrightarrow$',
    u'\u21d5': '$\\Updownarrow$',
    u'\u21da': '$\\Lleftarrow$',
    u'\u21db': '$\\Rrightarrow$',
    u'\u21dd': '$\\rightsquigarrow$',
    u'\u21f5': '$\\DownArrowUpArrow$',
    u'\u2200': '$\\forall$',
    u'\u2201': '$\\complement$',
    u'\u2202': '$\\partial$',
    u'\u2203': '$\\exists$',
    u'\u2204': '$\\nexists$',
    u'\u2205': '$\\varnothing$',
    u'\u2207': '$\\nabla$',
    u'\u2208': '$\\in$',
    u'\u2209': '$\\not\\in$',
    u'\u220b': '$\\ni$',
    u'\u220c': '$\\not\\ni$',
    u'\u220f': '$\\prod$',
    u'\u2210': '$\\coprod$',
    u'\u2211': '$\\sum$',
    u'\u2213': '$\\mp$',
    u'\u2214': '$\\dotplus$',
    u'\u2216': '$\\setminus$',
    u'\u2217': '${_\\ast}$',
    u'\u2218': '$\\circ$',
    u'\u2219': '$\\bullet$',
    u'\u221a': '$\\surd$',
    u'\u221d': '$\\propto$',
    u'\u221e': '$\\infty$',
    u'\u221f': '$\\rightangle$',
    u'\u2220': '$\\angle$',
    u'\u2221': '$\\measuredangle$',
    u'\u2222': '$\\sphericalangle$',
    u'\u2223': '$\\mid$',
    u'\u2224': '$\\nmid$',
    u'\u2225': '$\\parallel$',
    u'\u2226': '$\\nparallel$',
    u'\u2227': '$\\wedge$',
    u'\u2228': '$\\vee$',
    u'\u2229': '$\\cap$',
    u'\u222a': '$\\cup$',
    u'\u222b': '$\\int$',
    u'\u222c': '$\\int\\!\\int$',
    u'\u222d': '$\\int\\!\\int\\!\\int$',
    u'\u222e': '$\\oint$',
    u'\u222f': '$\\surfintegral$',
    u'\u2230': '$\\volintegral$',
    u'\u2231': '$\\clwintegral$',
    u'\u2232': '$\\ElsevierGlyph{2232}$',
    u'\u2233': '$\\ElsevierGlyph{2233}$',
    u'\u2234': '$\\therefore$',
    u'\u2235': '$\\because$',
    u'\u2237': '$\\Colon$',
    u'\u2238': '$\\ElsevierGlyph{2238}$',
    u'\u223a': '$\\mathbin{{:}\\!\\!{-}\\!\\!{:}}$',
    u'\u223b': '$\\homothetic$',
    u'\u223c': '$\\sim$',
    u'\u223d': '$\\backsim$',
    u'\u223e': '$\\lazysinv$',
    u'\u2240': '$\\wr$',
    u'\u2241': '$\\not\\sim$',
    u'\u2242': '$\\ElsevierGlyph{2242}$',
    u'\u2243': '$\\simeq$',
    u'\u2244': '$\\not\\simeq$',
    u'\u2245': '$\\cong$',
    u'\u2246': '$\\approxnotequal$',
    u'\u2247': '$\\not\\cong$',
    u'\u2248': '$\\approx$',
    u'\u2249': '$\\not\\approx$',
    u'\u224a': '$\\approxeq$',
    u'\u224b': '$\\tildetrpl$',
    u'\u224c': '$\\allequal$',
    u'\u224d': '$\\asymp$',
    u'\u224e': '$\\Bumpeq$',
    u'\u224f': '$\\bumpeq$',
    u'\u2250': '$\\doteq$',
    u'\u2251': '$\\doteqdot$',
    u'\u2252': '$\\fallingdotseq$',
    u'\u2253': '$\\risingdotseq$',
    u'\u2254': '{:=}',
    u'\u2255': '$=:$',
    u'\u2256': '$\\eqcirc$',
    u'\u2257': '$\\circeq$',
    u'\u2259': '$\\estimates$',
    u'\u225a': '$\\ElsevierGlyph{225A}$',
    u'\u225b': '$\\starequal$',
    u'\u225c': '$\\triangleq$',
    u'\u225f': '$\\ElsevierGlyph{225F}$',
    u'\u2260': '$\\not =$',
    u'\u2262': '$\\not\\equiv$',
    u'\u2264': '$\\leq$',
    u'\u2265': '$\\geq$',
    u'\u2266': '$\\leqq$',
    u'\u2267': '$\\geqq$',
    u'\u2268': '$\\lneqq$',
    u'\u2269': '$\\gneqq$',
    u'\u226a': '$\\ll$',
    u'\u226b': '$\\gg$',
    u'\u226c': '$\\between$',
    u'\u226d': '$\\not\\kern-0.3em\\times$',
    u'\u226e': '$\\not<$',
    u'\u226f': '$\\not>$',
    u'\u2270': '$\\not\\leq$',
    u'\u2271': '$\\not\\geq$',
    u'\u2272': '$\\lessequivlnt$',
    u'\u2273': '$\\greaterequivlnt$',
    u'\u2274': '$\\ElsevierGlyph{2274}$',
    u'\u2275': '$\\ElsevierGlyph{2275}$',
    u'\u2276': '$\\lessgtr$',
    u'\u2277': '$\\gtrless$',
    u'\u2278': '$\\notlessgreater$',
    u'\u2279': '$\\notgreaterless$',
    u'\u227a': '$\\prec$',
    u'\u227b': '$\\succ$',
    u'\u227c': '$\\preccurlyeq$',
    u'\u227d': '$\\succcurlyeq$',
    u'\u227e': '$\\precapprox$',
    u'\u227f': '$\\succapprox$',
    u'\u2280': '$\\not\\prec$',
    u'\u2281': '$\\not\\succ$',
    u'\u2282': '$\\subset$',
    u'\u2283': '$\\supset$',
    u'\u2284': '$\\not\\subset$',
    u'\u2285': '$\\not\\supset$',
    u'\u2286': '$\\subseteq$',
    u'\u2287': '$\\supseteq$',
    u'\u2288': '$\\not\\subseteq$',
    u'\u2289': '$\\not\\supseteq$',
    u'\u228a': '$\\subsetneq$',
    u'\u228b': '$\\supsetneq$',
    u'\u228e': '$\\uplus$',
    u'\u228f': '$\\sqsubset$',
    u'\u2290': '$\\sqsupset$',
    u'\u2291': '$\\sqsubseteq$',
    u'\u2292': '$\\sqsupseteq$',
    u'\u2293': '$\\sqcap$',
    u'\u2294': '$\\sqcup$',
    u'\u2295': '$\\oplus$',
    u'\u2296': '$\\ominus$',
    u'\u2297': '$\\otimes$',
    u'\u2298': '$\\oslash$',
    u'\u2299': '$\\odot$',
    u'\u229a': '$\\circledcirc$',
    u'\u229b': '$\\circledast$',
    u'\u229d': '$\\circleddash$',
    u'\u229e': '$\\boxplus$',
    u'\u229f': '$\\boxminus$',
    u'\u22a0': '$\\boxtimes$',
    u'\u22a1': '$\\boxdot$',
    u'\u22a2': '$\\vdash$',
    u'\u22a3': '$\\dashv$',
    u'\u22a4': '$\\top$',
    u'\u22a5': '$\\perp$',
    u'\u22a7': '$\\truestate$',
    u'\u22a8': '$\\forcesextra$',
    u'\u22a9': '$\\Vdash$',
    u'\u22aa': '$\\Vvdash$',
    u'\u22ab': '$\\VDash$',
    u'\u22ac': '$\\nvdash$',
    u'\u22ad': '$\\nvDash$',
    u'\u22ae': '$\\nVdash$',
    u'\u22af': '$\\nVDash$',
    u'\u22b2': '$\\vartriangleleft$',
    u'\u22b3': '$\\vartriangleright$',
    u'\u22b4': '$\\trianglelefteq$',
    u'\u22b5': '$\\trianglerighteq$',
    u'\u22b6': '$\\original$',
    u'\u22b7': '$\\image$',
    u'\u22b8': '$\\multimap$',
    u'\u22b9': '$\\hermitconjmatrix$',
    u'\u22ba': '$\\intercal$',
    u'\u22bb': '$\\veebar$',
    u'\u22be': '$\\rightanglearc$',
    u'\u22c0': '$\\ElsevierGlyph{22C0}$',
    u'\u22c1': '$\\ElsevierGlyph{22C1}$',
    u'\u22c2': '$\\bigcap$',
    u'\u22c3': '$\\bigcup$',
    u'\u22c4': '$\\diamond$',
    u'\u22c5': '$\\cdot$',
    u'\u22c6': '$\\star$',
    u'\u22c7': '$\\divideontimes$',
    u'\u22c8': '$\\bowtie$',
    u'\u22c9': '$\\ltimes$',
    u'\u22ca': '$\\rtimes$',
    u'\u22cb': '$\\leftthreetimes$',
    u'\u22cc': '$\\rightthreetimes$',
    u'\u22cd': '$\\backsimeq$',
    u'\u22ce': '$\\curlyvee$',
    u'\u22cf': '$\\curlywedge$',
    u'\u22d0': '$\\Subset$',
    u'\u22d1': '$\\Supset$',
    u'\u22d2': '$\\Cap$',
    u'\u22d3': '$\\Cup$',
    u'\u22d4': '$\\pitchfork$',
    u'\u22d6': '$\\lessdot$',
    u'\u22d7': '$\\gtrdot$',
    u'\u22d8': '$\\verymuchless$',
    u'\u22d9': '$\\verymuchgreater$',
    u'\u22da': '$\\lesseqgtr$',
    u'\u22db': '$\\gtreqless$',
    u'\u22de': '$\\curlyeqprec$',
    u'\u22df': '$\\curlyeqsucc$',
    u'\u22e2': '$\\not\\sqsubseteq$',
    u'\u22e3': '$\\not\\sqsupseteq$',
    u'\u22e5': '$\\Elzsqspne$',
    u'\u22e6': '$\\lnsim$',
    u'\u22e7': '$\\gnsim$',
    u'\u22e8': '$\\precedesnotsimilar$',
    u'\u22e9': '$\\succnsim$',
    u'\u22ea': '$\\ntriangleleft$',
    u'\u22eb': '$\\ntriangleright$',
    u'\u22ec': '$\\ntrianglelefteq$',
    u'\u22ed': '$\\ntrianglerighteq$',
    u'\u22ee': '$\\vdots$',
    u'\u22ef': '$\\cdots$',
    u'\u22f0': '$\\upslopeellipsis$',
    u'\u22f1': '$\\downslopeellipsis$',
    u'\u2305': '{\\barwedge}',
    u'\u2306': '$\\perspcorrespond$',
    u'\u2308': '$\\lceil$',
    u'\u2309': '$\\rceil$',
    u'\u230a': '$\\lfloor$',
    u'\u230b': '$\\rfloor$',
    u'\u2315': '$\\recorder$',
    u'\u2316': '$\\mathchar"2208$',
    u'\u231c': '$\\ulcorner$',
    u'\u231d': '$\\urcorner$',
    u'\u231e': '$\\llcorner$',
    u'\u231f': '$\\lrcorner$',
    u'\u2322': '$\\frown$',
    u'\u2323': '$\\smile$',
    u'\u233d': '$\\ElsevierGlyph{E838}$',
    u'\u23a3': '$\\Elzdlcorn$',
    u'\u23b0': '$\\lmoustache$',
    u'\u23b1': '$\\rmoustache$',
    u'\u2423': '{\\textvisiblespace}',
    u'\u2460': '{\\ding{172}}',
    u'\u2461': '{\\ding{173}}',
    u'\u2462': '{\\ding{174}}',
    u'\u2463': '{\\ding{175}}',
    u'\u2464': '{\\ding{176}}',
    u'\u2465': '{\\ding{177}}',
    u'\u2466': '{\\ding{178}}',
    u'\u2467': '{\\ding{179}}',
    u'\u2468': '{\\ding{180}}',
    u'\u2469': '{\\ding{181}}',
    u'\u24c8': '$\\circledS$',
    u'\u2506': '$\\Elzdshfnc$',
    u'\u2519': '$\\Elzsqfnw$',
    u'\u2571': '$\\diagup$',
    u'\u25a0': '{\\ding{110}}',
    u'\u25a1': '$\\square$',
    u'\u25aa': '$\\blacksquare$',
    u'\u25ad': '$\\fbox{~~}$',
    u'\u25af': '$\\Elzvrecto$',
    u'\u25b1': '$\\ElsevierGlyph{E381}$',
    u'\u25b2': '{\\ding{115}}',
    u'\u25b3': '$\\bigtriangleup$',
    u'\u25b4': '$\\blacktriangle$',
    u'\u25b5': '$\\vartriangle$',
    u'\u25b8': '$\\blacktriangleright$',
    u'\u25b9': '$\\triangleright$',
    u'\u25bc': '{\\ding{116}}',
    u'\u25bd': '$\\bigtriangledown$',
    u'\u25be': '$\\blacktriangledown$',
    u'\u25bf': '$\\triangledown$',
    u'\u25c2': '$\\blacktriangleleft$',
    u'\u25c3': '$\\triangleleft$',
    u'\u25c6': '{\\ding{117}}',
    u'\u25ca': '$\\lozenge$',
    u'\u25cb': '$\\bigcirc$',
    u'\u25cf': '{\\ding{108}}',
    u'\u25d0': '$\\Elzcirfl$',
    u'\u25d1': '$\\Elzcirfr$',
    u'\u25d2': '$\\Elzcirfb$',
    u'\u25d7': '{\\ding{119}}',
    u'\u25d8': '$\\Elzrvbull$',
    u'\u25e7': '$\\Elzsqfl$',
    u'\u25e8': '$\\Elzsqfr$',
    u'\u25ea': '$\\Elzsqfse$',
    u'\u2605': '{\\ding{72}}',
    u'\u2606': '{\\ding{73}}',
    u'\u260e': '{\\ding{37}}',
    u'\u261b': '{\\ding{42}}',
    u'\u261e': '{\\ding{43}}',
    u'\u263e': '{\\rightmoon}',
    u'\u263f': '{\\mercury}',
    u'\u2640': '{\\venus}',
    u'\u2642': '{\\male}',
    u'\u2643': '{\\jupiter}',
    u'\u2644': '{\\saturn}',
    u'\u2645': '{\\uranus}',
    u'\u2646': '{\\neptune}',
    u'\u2647': '{\\pluto}',
    u'\u2648': '{\\aries}',
    u'\u2649': '{\\taurus}',
    u'\u264a': '{\\gemini}',
    u'\u264b': '{\\cancer}',
    u'\u264c': '{\\leo}',
    u'\u264d': '{\\virgo}',
    u'\u264e': '{\\libra}',
    u'\u264f': '{\\scorpio}',
    u'\u2650': '{\\sagittarius}',
    u'\u2651': '{\\capricornus}',
    u'\u2652': '{\\aquarius}',
    u'\u2653': '{\\pisces}',
    u'\u2660': '{\\ding{171}}',
    u'\u2662': '$\\diamond$',
    u'\u2663': '{\\ding{168}}',
    u'\u2665': '{\\ding{170}}',
    u'\u2666': '{\\ding{169}}',
    u'\u2669': '{\\quarternote}',
    u'\u266d': '$\\flat$',
    u'\u266e': '$\\natural$',
    u'\u266f': '$\\sharp$',
    u'\u2701': '{\\ding{33}}',
    u'\u2702': '{\\ding{34}}',
    u'\u2703': '{\\ding{35}}',
    u'\u2704': '{\\ding{36}}',
    u'\u2706': '{\\ding{38}}',
    u'\u2707': '{\\ding{39}}',
    u'\u2708': '{\\ding{40}}',
    u'\u2709': '{\\ding{41}}',
    u'\u270c': '{\\ding{44}}',
    u'\u270d': '{\\ding{45}}',
    u'\u270e': '{\\ding{46}}',
    u'\u270f': '{\\ding{47}}',
    u'\u2710': '{\\ding{48}}',
    u'\u2711': '{\\ding{49}}',
    u'\u2712': '{\\ding{50}}',
    u'\u2713': '{\\ding{51}}',
    u'\u2714': '{\\ding{52}}',
    u'\u2715': '{\\ding{53}}',
    u'\u2716': '{\\ding{54}}',
    u'\u2717': '{\\ding{55}}',
    u'\u2718': '{\\ding{56}}',
    u'\u2719': '{\\ding{57}}',
    u'\u271a': '{\\ding{58}}',
    u'\u271b': '{\\ding{59}}',
    u'\u271c': '{\\ding{60}}',
    u'\u271d': '{\\ding{61}}',
    u'\u271e': '{\\ding{62}}',
    u'\u271f': '{\\ding{63}}',
    u'\u2720': '{\\ding{64}}',
    u'\u2721': '{\\ding{65}}',
    u'\u2722': '{\\ding{66}}',
    u'\u2723': '{\\ding{67}}',
    u'\u2724': '{\\ding{68}}',
    u'\u2725': '{\\ding{69}}',
    u'\u2726': '{\\ding{70}}',
    u'\u2727': '{\\ding{71}}',
    u'\u2729': '{\\ding{73}}',
    u'\u272a': '{\\ding{74}}',
    u'\u272b': '{\\ding{75}}',
    u'\u272c': '{\\ding{76}}',
    u'\u272d': '{\\ding{77}}',
    u'\u272e': '{\\ding{78}}',
    u'\u272f': '{\\ding{79}}',
    u'\u2730': '{\\ding{80}}',
    u'\u2731': '{\\ding{81}}',
    u'\u2732': '{\\ding{82}}',
    u'\u2733': '{\\ding{83}}',
    u'\u2734': '{\\ding{84}}',
    u'\u2735': '{\\ding{85}}',
    u'\u2736': '{\\ding{86}}',
    u'\u2737': '{\\ding{87}}',
    u'\u2738': '{\\ding{88}}',
    u'\u2739': '{\\ding{89}}',
    u'\u273a': '{\\ding{90}}',
    u'\u273b': '{\\ding{91}}',
    u'\u273c': '{\\ding{92}}',
    u'\u273d': '{\\ding{93}}',
    u'\u273e': '{\\ding{94}}',
    u'\u273f': '{\\ding{95}}',
    u'\u2740': '{\\ding{96}}',
    u'\u2741': '{\\ding{97}}',
    u'\u2742': '{\\ding{98}}',
    u'\u2743': '{\\ding{99}}',
    u'\u2744': '{\\ding{100}}',
    u'\u2745': '{\\ding{101}}',
    u'\u2746': '{\\ding{102}}',
    u'\u2747': '{\\ding{103}}',
    u'\u2748': '{\\ding{104}}',
    u'\u2749': '{\\ding{105}}',
    u'\u274a': '{\\ding{106}}',
    u'\u274b': '{\\ding{107}}',
    u'\u274d': '{\\ding{109}}',
    u'\u274f': '{\\ding{111}}',
    u'\u2750': '{\\ding{112}}',
    u'\u2751': '{\\ding{113}}',
    u'\u2752': '{\\ding{114}}',
    u'\u2756': '{\\ding{118}}',
    u'\u2758': '{\\ding{120}}',
    u'\u2759': '{\\ding{121}}',
    u'\u275a': '{\\ding{122}}',
    u'\u275b': '{\\ding{123}}',
    u'\u275c': '{\\ding{124}}',
    u'\u275d': '{\\ding{125}}',
    u'\u275e': '{\\ding{126}}',
    u'\u2761': '{\\ding{161}}',
    u'\u2762': '{\\ding{162}}',
    u'\u2763': '{\\ding{163}}',
    u'\u2764': '{\\ding{164}}',
    u'\u2765': '{\\ding{165}}',
    u'\u2766': '{\\ding{166}}',
    u'\u2767': '{\\ding{167}}',
    u'\u2776': '{\\ding{182}}',
    u'\u2777': '{\\ding{183}}',
    u'\u2778': '{\\ding{184}}',
    u'\u2779': '{\\ding{185}}',
    u'\u277a': '{\\ding{186}}',
    u'\u277b': '{\\ding{187}}',
    u'\u277c': '{\\ding{188}}',
    u'\u277d': '{\\ding{189}}',
    u'\u277e': '{\\ding{190}}',
    u'\u277f': '{\\ding{191}}',
    u'\u2780': '{\\ding{192}}',
    u'\u2781': '{\\ding{193}}',
    u'\u2782': '{\\ding{194}}',
    u'\u2783': '{\\ding{195}}',
    u'\u2784': '{\\ding{196}}',
    u'\u2785': '{\\ding{197}}',
    u'\u2786': '{\\ding{198}}',
    u'\u2787': '{\\ding{199}}',
    u'\u2788': '{\\ding{200}}',
    u'\u2789': '{\\ding{201}}',
    u'\u278a': '{\\ding{202}}',
    u'\u278b': '{\\ding{203}}',
    u'\u278c': '{\\ding{204}}',
    u'\u278d': '{\\ding{205}}',
    u'\u278e': '{\\ding{206}}',
    u'\u278f': '{\\ding{207}}',
    u'\u2790': '{\\ding{208}}',
    u'\u2791': '{\\ding{209}}',
    u'\u2792': '{\\ding{210}}',
    u'\u2793': '{\\ding{211}}',
    u'\u2794': '{\\ding{212}}',
    u'\u2798': '{\\ding{216}}',
    u'\u2799': '{\\ding{217}}',
    u'\u279a': '{\\ding{218}}',
    u'\u279b': '{\\ding{219}}',
    u'\u279c': '{\\ding{220}}',
    u'\u279d': '{\\ding{221}}',
    u'\u279e': '{\\ding{222}}',
    u'\u279f': '{\\ding{223}}',
    u'\u27a0': '{\\ding{224}}',
    u'\u27a1': '{\\ding{225}}',
    u'\u27a2': '{\\ding{226}}',
    u'\u27a3': '{\\ding{227}}',
    u'\u27a4': '{\\ding{228}}',
    u'\u27a5': '{\\ding{229}}',
    u'\u27a6': '{\\ding{230}}',
    u'\u27a7': '{\\ding{231}}',
    u'\u27a8': '{\\ding{232}}',
    u'\u27a9': '{\\ding{233}}',
    u'\u27aa': '{\\ding{234}}',
    u'\u27ab': '{\\ding{235}}',
    u'\u27ac': '{\\ding{236}}',
    u'\u27ad': '{\\ding{237}}',
    u'\u27ae': '{\\ding{238}}',
    u'\u27af': '{\\ding{239}}',
    u'\u27b1': '{\\ding{241}}',
    u'\u27b2': '{\\ding{242}}',
    u'\u27b3': '{\\ding{243}}',
    u'\u27b4': '{\\ding{244}}',
    u'\u27b5': '{\\ding{245}}',
    u'\u27b6': '{\\ding{246}}',
    u'\u27b7': '{\\ding{247}}',
    u'\u27b8': '{\\ding{248}}',
    u'\u27b9': '{\\ding{249}}',
    u'\u27ba': '{\\ding{250}}',
    u'\u27bb': '{\\ding{251}}',
    u'\u27bc': '{\\ding{252}}',
    u'\u27bd': '{\\ding{253}}',
    u'\u27be': '{\\ding{254}}',
    u'\u27f5': '$\\longleftarrow$',
    u'\u27f6': '$\\longrightarrow$',
    u'\u27f7': '$\\longleftrightarrow$',
    u'\u27f8': '$\\Longleftarrow$',
    u'\u27f9': '$\\Longrightarrow$',
    u'\u27fa': '$\\Longleftrightarrow$',
    u'\u27fc': '$\\longmapsto$',
    u'\u27ff': '$\\sim\\joinrel\\leadsto$',
    u'\u2905': '$\\ElsevierGlyph{E212}$',
    u'\u2912': '$\\UpArrowBar$',
    u'\u2913': '$\\DownArrowBar$',
    u'\u2923': '$\\ElsevierGlyph{E20C}$',
    u'\u2924': '$\\ElsevierGlyph{E20D}$',
    u'\u2925': '$\\ElsevierGlyph{E20B}$',
    u'\u2926': '$\\ElsevierGlyph{E20A}$',
    u'\u2927': '$\\ElsevierGlyph{E211}$',
    u'\u2928': '$\\ElsevierGlyph{E20E}$',
    u'\u2929': '$\\ElsevierGlyph{E20F}$',
    u'\u292a': '$\\ElsevierGlyph{E210}$',
    u'\u2933': '$\\ElsevierGlyph{E21C}$',
    u'\u2936': '$\\ElsevierGlyph{E21A}$',
    u'\u2937': '$\\ElsevierGlyph{E219}$',
    u'\u2940': '$\\Elolarr$',
    u'\u2941': '$\\Elorarr$',
    u'\u2942': '$\\ElzRlarr$',
    u'\u2944': '$\\ElzrLarr$',
    u'\u2947': '$\\Elzrarrx$',
    u'\u294e': '$\\LeftRightVector$',
    u'\u294f': '$\\RightUpDownVector$',
    u'\u2950': '$\\DownLeftRightVector$',
    u'\u2951': '$\\LeftUpDownVector$',
    u'\u2952': '$\\LeftVectorBar$',
    u'\u2953': '$\\RightVectorBar$',
    u'\u2954': '$\\RightUpVectorBar$',
    u'\u2955': '$\\RightDownVectorBar$',
    u'\u2956': '$\\DownLeftVectorBar$',
    u'\u2957': '$\\DownRightVectorBar$',
    u'\u2958': '$\\LeftUpVectorBar$',
    u'\u2959': '$\\LeftDownVectorBar$',
    u'\u295a': '$\\LeftTeeVector$',
    u'\u295b': '$\\RightTeeVector$',
    u'\u295c': '$\\RightUpTeeVector$',
    u'\u295d': '$\\RightDownTeeVector$',
    u'\u295e': '$\\DownLeftTeeVector$',
    u'\u295f': '$\\DownRightTeeVector$',
    u'\u2960': '$\\LeftUpTeeVector$',
    u'\u2961': '$\\LeftDownTeeVector$',
    u'\u296e': '$\\UpEquilibrium$',
    u'\u296f': '$\\ReverseUpEquilibrium$',
    u'\u2970': '$\\RoundImplies$',
    u'\u297c': '$\\ElsevierGlyph{E214}$',
    u'\u297d': '$\\ElsevierGlyph{E215}$',
    u'\u2980': '$\\Elztfnc$',
    u'\u2985': '$\\ElsevierGlyph{3018}$',
    u'\u2986': '$\\Elroang$',
    u'\u2993': '$<\\kern-0.58em($',
    u'\u2994': '$\\ElsevierGlyph{E291}$',
    u'\u2999': '$\\Elzddfnc$',
    u'\u299c': '$\\Angle$',
    u'\u29a0': '$\\Elzlpargt$',
    u'\u29b5': '$\\ElsevierGlyph{E260}$',
    u'\u29b6': '$\\ElsevierGlyph{E61B}$',
    u'\u29ca': '$\\ElzLap$',
    u'\u29cb': '$\\Elzdefas$',
    u'\u29cf': '$\\LeftTriangleBar$',
    u'\u29d0': '$\\RightTriangleBar$',
    u'\u29dc': '$\\ElsevierGlyph{E372}$',
    u'\u29eb': '$\\blacklozenge$',
    u'\u29f4': '$\\RuleDelayed$',
    u'\u2a04': '$\\Elxuplus$',
    u'\u2a05': '$\\ElzThr$',
    u'\u2a06': '$\\Elxsqcup$',
    u'\u2a07': '$\\ElzInf$',
    u'\u2a08': '$\\ElzSup$',
    u'\u2a0d': '$\\ElzCint$',
    u'\u2a0f': '$\\clockoint$',
    u'\u2a10': '$\\ElsevierGlyph{E395}$',
    u'\u2a16': '$\\sqrint$',
    u'\u2a25': '$\\ElsevierGlyph{E25A}$',
    u'\u2a2a': '$\\ElsevierGlyph{E25B}$',
    u'\u2a2d': '$\\ElsevierGlyph{E25C}$',
    u'\u2a2e': '$\\ElsevierGlyph{E25D}$',
    u'\u2a2f': '$\\ElzTimes$',
    u'\u2a34': '$\\ElsevierGlyph{E25E}$',
    u'\u2a35': '$\\ElsevierGlyph{E25E}$',
    u'\u2a3c': '$\\ElsevierGlyph{E259}$',
    u'\u2a3f': '$\\amalg$',
    u'\u2a53': '$\\ElzAnd$',
    u'\u2a54': '$\\ElzOr$',
    u'\u2a55': '$\\ElsevierGlyph{E36E}$',
    u'\u2a56': '$\\ElOr$',
    u'\u2a5e': '$\\perspcorrespond$',
    u'\u2a5f': '$\\Elzminhat$',
    u'\u2a63': '$\\ElsevierGlyph{225A}$',
    u'\u2a6e': '$\\stackrel{*}{=}$',
    u'\u2a75': '$\\Equal$',
    u'\u2a7d': '$\\leqslant$',
    u'\u2a7e': '$\\geqslant$',
    u'\u2a85': '$\\lessapprox$',
    u'\u2a86': '$\\gtrapprox$',
    u'\u2a87': '$\\lneq$',
    u'\u2a88': '$\\gneq$',
    u'\u2a89': '$\\lnapprox$',
    u'\u2a8a': '$\\gnapprox$',
    u'\u2a8b': '$\\lesseqqgtr$',
    u'\u2a8c': '$\\gtreqqless$',
    u'\u2a95': '$\\eqslantless$',
    u'\u2a96': '$\\eqslantgtr$',
    u'\u2a9d': '$\\Pisymbol{ppi020}{117}$',
    u'\u2a9e': '$\\Pisymbol{ppi020}{105}$',
    u'\u2aa1': '$\\NestedLessLess$',
    u'\u2aa2': '$\\NestedGreaterGreater$',
    u'\u2aaf': '$\\preceq$',
    u'\u2ab0': '$\\succeq$',
    u'\u2ab5': '$\\precneqq$',
    u'\u2ab6': '$\\succneqq$',
    u'\u2ab7': '$\\precapprox$',
    u'\u2ab8': '$\\succapprox$',
    u'\u2ab9': '$\\precnapprox$',
    u'\u2aba': '$\\succnapprox$',
    u'\u2ac5': '$\\subseteqq$',
    u'\u2ac6': '$\\supseteqq$',
    u'\u2acb': '$\\subsetneqq$',
    u'\u2acc': '$\\supsetneqq$',
    u'\u2aeb': '$\\ElsevierGlyph{E30D}$',
    u'\u2af6': '$\\Elztdcol$',
    u'\u2afd': '${{/}\\!\\!{/}}$',
    u'\u300a': '$\\ElsevierGlyph{300A}$',
    u'\u300b': '$\\ElsevierGlyph{300B}$',
    u'\u3018': '$\\ElsevierGlyph{3018}$',
    u'\u3019': '$\\ElsevierGlyph{3019}$',
    u'\u301a': '$\\openbracketleft$',
    u'\u301b': '$\\openbracketright$',
    u'\ufb00': '{ff}',
    u'\ufb01': '{fi}',
    u'\ufb02': '{fl}',
    u'\ufb03': '{ffi}',
    u'\ufb04': '{ffl}',
    u'\U0001d400': '$\\mathbf{A}$',
    u'\U0001d401': '$\\mathbf{B}$',
    u'\U0001d402': '$\\mathbf{C}$',
    u'\U0001d403': '$\\mathbf{D}$',
    u'\U0001d404': '$\\mathbf{E}$',
    u'\U0001d405': '$\\mathbf{F}$',
    u'\U0001d406': '$\\mathbf{G}$',
    u'\U0001d407': '$\\mathbf{H}$',
    u'\U0001d408': '$\\mathbf{I}$',
    u'\U0001d409': '$\\mathbf{J}$',
    u'\U0001d40a': '$\\mathbf{K}$',
    u'\U0001d40b': '$\\mathbf{L}$',
    u'\U0001d40c': '$\\mathbf{M}$',
    u'\U0001d40d': '$\\mathbf{N}$',
    u'\U0001d40e': '$\\mathbf{O}$',
    u'\U0001d40f': '$\\mathbf{P}$',
    u'\U0001d410': '$\\mathbf{Q}$',
    u'\U0001d411': '$\\mathbf{R}$',
    u'\U0001d412': '$\\mathbf{S}$',
    u'\U0001d413': '$\\mathbf{T}$',
    u'\U0001d414': '$\\mathbf{U}$',
    u'\U0001d415': '$\\mathbf{V}$',
    u'\U0001d416': '$\\mathbf{W}$',
    u'\U0001d417': '$\\mathbf{X}$',
    u'\U0001d418': '$\\mathbf{Y}$',
    u'\U0001d419': '$\\mathbf{Z}$',
    u'\U0001d41a': '$\\mathbf{a}$',
    u'\U0001d41b': '$\\mathbf{b}$',
    u'\U0001d41c': '$\\mathbf{c}$',
    u'\U0001d41d': '$\\mathbf{d}$',
    u'\U0001d41e': '$\\mathbf{e}$',
    u'\U0001d41f': '$\\mathbf{f}$',
    u'\U0001d420': '$\\mathbf{g}$',
    u'\U0001d421': '$\\mathbf{h}$',
    u'\U0001d422': '$\\mathbf{i}$',
    u'\U0001d423': '$\\mathbf{j}$',
    u'\U0001d424': '$\\mathbf{k}$',
    u'\U0001d425': '$\\mathbf{l}$',
    u'\U0001d426': '$\\mathbf{m}$',
    u'\U0001d427': '$\\mathbf{n}$',
    u'\U0001d428': '$\\mathbf{o}$',
    u'\U0001d429': '$\\mathbf{p}$',
    u'\U0001d42a': '$\\mathbf{q}$',
    u'\U0001d42b': '$\\mathbf{r}$',
    u'\U0001d42c': '$\\mathbf{s}$',
    u'\U0001d42d': '$\\mathbf{t}$',
    u'\U0001d42e': '$\\mathbf{u}$',
    u'\U0001d42f': '$\\mathbf{v}$',
    u'\U0001d430': '$\\mathbf{w}$',
    u'\U0001d431': '$\\mathbf{x}$',
    u'\U0001d432': '$\\mathbf{y}$',
    u'\U0001d433': '$\\mathbf{z}$',
    u'\U0001d434': '$\\mathsl{A}$',
    u'\U0001d435': '$\\mathsl{B}$',
    u'\U0001d436': '$\\mathsl{C}$',
    u'\U0001d437': '$\\mathsl{D}$',
    u'\U0001d438': '$\\mathsl{E}$',
    u'\U0001d439': '$\\mathsl{F}$',
    u'\U0001d43a': '$\\mathsl{G}$',
    u'\U0001d43b': '$\\mathsl{H}$',
    u'\U0001d43c': '$\\mathsl{I}$',
    u'\U0001d43d': '$\\mathsl{J}$',
    u'\U0001d43e': '$\\mathsl{K}$',
    u'\U0001d43f': '$\\mathsl{L}$',
    u'\U0001d440': '$\\mathsl{M}$',
    u'\U0001d441': '$\\mathsl{N}$',
    u'\U0001d442': '$\\mathsl{O}$',
    u'\U0001d443': '$\\mathsl{P}$',
    u'\U0001d444': '$\\mathsl{Q}$',
    u'\U0001d445': '$\\mathsl{R}$',
    u'\U0001d446': '$\\mathsl{S}$',
    u'\U0001d447': '$\\mathsl{T}$',
    u'\U0001d448': '$\\mathsl{U}$',
    u'\U0001d449': '$\\mathsl{V}$',
    u'\U0001d44a': '$\\mathsl{W}$',
    u'\U0001d44b': '$\\mathsl{X}$',
    u'\U0001d44c': '$\\mathsl{Y}$',
    u'\U0001d44d': '$\\mathsl{Z}$',
    u'\U0001d44e': '$\\mathsl{a}$',
    u'\U0001d44f': '$\\mathsl{b}$',
    u'\U0001d450': '$\\mathsl{c}$',
    u'\U0001d451': '$\\mathsl{d}$',
    u'\U0001d452': '$\\mathsl{e}$',
    u'\U0001d453': '$\\mathsl{f}$',
    u'\U0001d454': '$\\mathsl{g}$',
    u'\U0001d456': '$\\mathsl{i}$',
    u'\U0001d457': '$\\mathsl{j}$',
    u'\U0001d458': '$\\mathsl{k}$',
    u'\U0001d459': '$\\mathsl{l}$',
    u'\U0001d45a': '$\\mathsl{m}$',
    u'\U0001d45b': '$\\mathsl{n}$',
    u'\U0001d45c': '$\\mathsl{o}$',
    u'\U0001d45d': '$\\mathsl{p}$',
    u'\U0001d45e': '$\\mathsl{q}$',
    u'\U0001d45f': '$\\mathsl{r}$',
    u'\U0001d460': '$\\mathsl{s}$',
    u'\U0001d461': '$\\mathsl{t}$',
    u'\U0001d462': '$\\mathsl{u}$',
    u'\U0001d463': '$\\mathsl{v}$',
    u'\U0001d464': '$\\mathsl{w}$',
    u'\U0001d465': '$\\mathsl{x}$',
    u'\U0001d466': '$\\mathsl{y}$',
    u'\U0001d467': '$\\mathsl{z}$',
    u'\U0001d468': '$\\mathbit{A}$',
    u'\U0001d469': '$\\mathbit{B}$',
    u'\U0001d46a': '$\\mathbit{C}$',
    u'\U0001d46b': '$\\mathbit{D}$',
    u'\U0001d46c': '$\\mathbit{E}$',
    u'\U0001d46d': '$\\mathbit{F}$',
    u'\U0001d46e': '$\\mathbit{G}$',
    u'\U0001d46f': '$\\mathbit{H}$',
    u'\U0001d470': '$\\mathbit{I}$',
    u'\U0001d471': '$\\mathbit{J}$',
    u'\U0001d472': '$\\mathbit{K}$',
    u'\U0001d473': '$\\mathbit{L}$',
    u'\U0001d474': '$\\mathbit{M}$',
    u'\U0001d475': '$\\mathbit{N}$',
    u'\U0001d476': '$\\mathbit{O}$',
    u'\U0001d477': '$\\mathbit{P}$',
    u'\U0001d478': '$\\mathbit{Q}$',
    u'\U0001d479': '$\\mathbit{R}$',
    u'\U0001d47a': '$\\mathbit{S}$',
    u'\U0001d47b': '$\\mathbit{T}$',
    u'\U0001d47c': '$\\mathbit{U}$',
    u'\U0001d47d': '$\\mathbit{V}$',
    u'\U0001d47e': '$\\mathbit{W}$',
    u'\U0001d47f': '$\\mathbit{X}$',
    u'\U0001d480': '$\\mathbit{Y}$',
    u'\U0001d481': '$\\mathbit{Z}$',
    u'\U0001d482': '$\\mathbit{a}$',
    u'\U0001d483': '$\\mathbit{b}$',
    u'\U0001d484': '$\\mathbit{c}$',
    u'\U0001d485': '$\\mathbit{d}$',
    u'\U0001d486': '$\\mathbit{e}$',
    u'\U0001d487': '$\\mathbit{f}$',
    u'\U0001d488': '$\\mathbit{g}$',
    u'\U0001d489': '$\\mathbit{h}$',
    u'\U0001d48a': '$\\mathbit{i}$',
    u'\U0001d48b': '$\\mathbit{j}$',
    u'\U0001d48c': '$\\mathbit{k}$',
    u'\U0001d48d': '$\\mathbit{l}$',
    u'\U0001d48e': '$\\mathbit{m}$',
    u'\U0001d48f': '$\\mathbit{n}$',
    u'\U0001d490': '$\\mathbit{o}$',
    u'\U0001d491': '$\\mathbit{p}$',
    u'\U0001d492': '$\\mathbit{q}$',
    u'\U0001d493': '$\\mathbit{r}$',
    u'\U0001d494': '$\\mathbit{s}$',
    u'\U0001d495': '$\\mathbit{t}$',
    u'\U0001d496': '$\\mathbit{u}$',
    u'\U0001d497': '$\\mathbit{v}$',
    u'\U0001d498': '$\\mathbit{w}$',
    u'\U0001d499': '$\\mathbit{x}$',
    u'\U0001d49a': '$\\mathbit{y}$',
    u'\U0001d49b': '$\\mathbit{z}$',
    u'\U0001d49c': '$\\mathscr{A}$',
    u'\U0001d49e': '$\\mathscr{C}$',
    u'\U0001d49f': '$\\mathscr{D}$',
    u'\U0001d4a2': '$\\mathscr{G}$',
    u'\U0001d4a5': '$\\mathscr{J}$',
    u'\U0001d4a6': '$\\mathscr{K}$',
    u'\U0001d4a9': '$\\mathscr{N}$',
    u'\U0001d4aa': '$\\mathscr{O}$',
    u'\U0001d4ab': '$\\mathscr{P}$',
    u'\U0001d4ac': '$\\mathscr{Q}$',
    u'\U0001d4ae': '$\\mathscr{S}$',
    u'\U0001d4af': '$\\mathscr{T}$',
    u'\U0001d4b0': '$\\mathscr{U}$',
    u'\U0001d4b1': '$\\mathscr{V}$',
    u'\U0001d4b2': '$\\mathscr{W}$',
    u'\U0001d4b3': '$\\mathscr{X}$',
    u'\U0001d4b4': '$\\mathscr{Y}$',
    u'\U0001d4b5': '$\\mathscr{Z}$',
    u'\U0001d4b6': '$\\mathscr{a}$',
    u'\U0001d4b7': '$\\mathscr{b}$',
    u'\U0001d4b8': '$\\mathscr{c}$',
    u'\U0001d4b9': '$\\mathscr{d}$',
    u'\U0001d4bb': '$\\mathscr{f}$',
    u'\U0001d4bd': '$\\mathscr{h}$',
    u'\U0001d4be': '$\\mathscr{i}$',
    u'\U0001d4bf': '$\\mathscr{j}$',
    u'\U0001d4c0': '$\\mathscr{k}$',
    u'\U0001d4c1': '$\\mathscr{l}$',
    u'\U0001d4c2': '$\\mathscr{m}$',
    u'\U0001d4c3': '$\\mathscr{n}$',
    u'\U0001d4c5': '$\\mathscr{p}$',
    u'\U0001d4c6': '$\\mathscr{q}$',
    u'\U0001d4c7': '$\\mathscr{r}$',
    u'\U0001d4c8': '$\\mathscr{s}$',
    u'\U0001d4c9': '$\\mathscr{t}$',
    u'\U0001d4ca': '$\\mathscr{u}$',
    u'\U0001d4cb': '$\\mathscr{v}$',
    u'\U0001d4cc': '$\\mathscr{w}$',
    u'\U0001d4cd': '$\\mathscr{x}$',
    u'\U0001d4ce': '$\\mathscr{y}$',
    u'\U0001d4cf': '$\\mathscr{z}$',
    u'\U0001d4d0': '$\\mathmit{A}$',
    u'\U0001d4d1': '$\\mathmit{B}$',
    u'\U0001d4d2': '$\\mathmit{C}$',
    u'\U0001d4d3': '$\\mathmit{D}$',
    u'\U0001d4d4': '$\\mathmit{E}$',
    u'\U0001d4d5': '$\\mathmit{F}$',
    u'\U0001d4d6': '$\\mathmit{G}$',
    u'\U0001d4d7': '$\\mathmit{H}$',
    u'\U0001d4d8': '$\\mathmit{I}$',
    u'\U0001d4d9': '$\\mathmit{J}$',
    u'\U0001d4da': '$\\mathmit{K}$',
    u'\U0001d4db': '$\\mathmit{L}$',
    u'\U0001d4dc': '$\\mathmit{M}$',
    u'\U0001d4dd': '$\\mathmit{N}$',
    u'\U0001d4de': '$\\mathmit{O}$',
    u'\U0001d4df': '$\\mathmit{P}$',
    u'\U0001d4e0': '$\\mathmit{Q}$',
    u'\U0001d4e1': '$\\mathmit{R}$',
    u'\U0001d4e2': '$\\mathmit{S}$',
    u'\U0001d4e3': '$\\mathmit{T}$',
    u'\U0001d4e4': '$\\mathmit{U}$',
    u'\U0001d4e5': '$\\mathmit{V}$',
    u'\U0001d4e6': '$\\mathmit{W}$',
    u'\U0001d4e7': '$\\mathmit{X}$',
    u'\U0001d4e8': '$\\mathmit{Y}$',
    u'\U0001d4e9': '$\\mathmit{Z}$',
    u'\U0001d4ea': '$\\mathmit{a}$',
    u'\U0001d4eb': '$\\mathmit{b}$',
    u'\U0001d4ec': '$\\mathmit{c}$',
    u'\U0001d4ed': '$\\mathmit{d}$',
    u'\U0001d4ee': '$\\mathmit{e}$',
    u'\U0001d4ef': '$\\mathmit{f}$',
    u'\U0001d4f0': '$\\mathmit{g}$',
    u'\U0001d4f1': '$\\mathmit{h}$',
    u'\U0001d4f2': '$\\mathmit{i}$',
    u'\U0001d4f3': '$\\mathmit{j}$',
    u'\U0001d4f4': '$\\mathmit{k}$',
    u'\U0001d4f5': '$\\mathmit{l}$',
    u'\U0001d4f6': '$\\mathmit{m}$',
    u'\U0001d4f7': '$\\mathmit{n}$',
    u'\U0001d4f8': '$\\mathmit{o}$',
    u'\U0001d4f9': '$\\mathmit{p}$',
    u'\U0001d4fa': '$\\mathmit{q}$',
    u'\U0001d4fb': '$\\mathmit{r}$',
    u'\U0001d4fc': '$\\mathmit{s}$',
    u'\U0001d4fd': '$\\mathmit{t}$',
    u'\U0001d4fe': '$\\mathmit{u}$',
    u'\U0001d4ff': '$\\mathmit{v}$',
    u'\U0001d500': '$\\mathmit{w}$',
    u'\U0001d501': '$\\mathmit{x}$',
    u'\U0001d502': '$\\mathmit{y}$',
    u'\U0001d503': '$\\mathmit{z}$',
    u'\U0001d504': '$\\mathfrak{A}$',
    u'\U0001d505': '$\\mathfrak{B}$',
    u'\U0001d507': '$\\mathfrak{D}$',
    u'\U0001d508': '$\\mathfrak{E}$',
    u'\U0001d509': '$\\mathfrak{F}$',
    u'\U0001d50a': '$\\mathfrak{G}$',
    u'\U0001d50d': '$\\mathfrak{J}$',
    u'\U0001d50e': '$\\mathfrak{K}$',
    u'\U0001d50f': '$\\mathfrak{L}$',
    u'\U0001d510': '$\\mathfrak{M}$',
    u'\U0001d511': '$\\mathfrak{N}$',
    u'\U0001d512': '$\\mathfrak{O}$',
    u'\U0001d513': '$\\mathfrak{P}$',
    u'\U0001d514': '$\\mathfrak{Q}$',
    u'\U0001d516': '$\\mathfrak{S}$',
    u'\U0001d517': '$\\mathfrak{T}$',
    u'\U0001d518': '$\\mathfrak{U}$',
    u'\U0001d519': '$\\mathfrak{V}$',
    u'\U0001d51a': '$\\mathfrak{W}$',
    u'\U0001d51b': '$\\mathfrak{X}$',
    u'\U0001d51c': '$\\mathfrak{Y}$',
    u'\U0001d51e': '$\\mathfrak{a}$',
    u'\U0001d51f': '$\\mathfrak{b}$',
    u'\U0001d520': '$\\mathfrak{c}$',
    u'\U0001d521': '$\\mathfrak{d}$',
    u'\U0001d522': '$\\mathfrak{e}$',
    u'\U0001d523': '$\\mathfrak{f}$',
    u'\U0001d524': '$\\mathfrak{g}$',
    u'\U0001d525': '$\\mathfrak{h}$',
    u'\U0001d526': '$\\mathfrak{i}$',
    u'\U0001d527': '$\\mathfrak{j}$',
    u'\U0001d528': '$\\mathfrak{k}$',
    u'\U0001d529': '$\\mathfrak{l}$',
    u'\U0001d52a': '$\\mathfrak{m}$',
    u'\U0001d52b': '$\\mathfrak{n}$',
    u'\U0001d52c': '$\\mathfrak{o}$',
    u'\U0001d52d': '$\\mathfrak{p}$',
    u'\U0001d52e': '$\\mathfrak{q}$',
    u'\U0001d52f': '$\\mathfrak{r}$',
    u'\U0001d530': '$\\mathfrak{s}$',
    u'\U0001d531': '$\\mathfrak{t}$',
    u'\U0001d532': '$\\mathfrak{u}$',
    u'\U0001d533': '$\\mathfrak{v}$',
    u'\U0001d534': '$\\mathfrak{w}$',
    u'\U0001d535': '$\\mathfrak{x}$',
    u'\U0001d536': '$\\mathfrak{y}$',
    u'\U0001d537': '$\\mathfrak{z}$',
    u'\U0001d538': '$\\mathbb{A}$',
    u'\U0001d539': '$\\mathbb{B}$',
    u'\U0001d53b': '$\\mathbb{D}$',
    u'\U0001d53c': '$\\mathbb{E}$',
    u'\U0001d53d': '$\\mathbb{F}$',
    u'\U0001d53e': '$\\mathbb{G}$',
    u'\U0001d540': '$\\mathbb{I}$',
    u'\U0001d541': '$\\mathbb{J}$',
    u'\U0001d542': '$\\mathbb{K}$',
    u'\U0001d543': '$\\mathbb{L}$',
    u'\U0001d544': '$\\mathbb{M}$',
    u'\U0001d546': '$\\mathbb{O}$',
    u'\U0001d54a': '$\\mathbb{S}$',
    u'\U0001d54b': '$\\mathbb{T}$',
    u'\U0001d54c': '$\\mathbb{U}$',
    u'\U0001d54d': '$\\mathbb{V}$',
    u'\U0001d54e': '$\\mathbb{W}$',
    u'\U0001d54f': '$\\mathbb{X}$',
    u'\U0001d550': '$\\mathbb{Y}$',
    u'\U0001d552': '$\\mathbb{a}$',
    u'\U0001d553': '$\\mathbb{b}$',
    u'\U0001d554': '$\\mathbb{c}$',
    u'\U0001d555': '$\\mathbb{d}$',
    u'\U0001d556': '$\\mathbb{e}$',
    u'\U0001d557': '$\\mathbb{f}$',
    u'\U0001d558': '$\\mathbb{g}$',
    u'\U0001d559': '$\\mathbb{h}$',
    u'\U0001d55a': '$\\mathbb{i}$',
    u'\U0001d55b': '$\\mathbb{j}$',
    u'\U0001d55c': '$\\mathbb{k}$',
    u'\U0001d55d': '$\\mathbb{l}$',
    u'\U0001d55e': '$\\mathbb{m}$',
    u'\U0001d55f': '$\\mathbb{n}$',
    u'\U0001d560': '$\\mathbb{o}$',
    u'\U0001d561': '$\\mathbb{p}$',
    u'\U0001d562': '$\\mathbb{q}$',
    u'\U0001d563': '$\\mathbb{r}$',
    u'\U0001d564': '$\\mathbb{s}$',
    u'\U0001d565': '$\\mathbb{t}$',
    u'\U0001d566': '$\\mathbb{u}$',
    u'\U0001d567': '$\\mathbb{v}$',
    u'\U0001d568': '$\\mathbb{w}$',
    u'\U0001d569': '$\\mathbb{x}$',
    u'\U0001d56a': '$\\mathbb{y}$',
    u'\U0001d56b': '$\\mathbb{z}$',
    u'\U0001d56c': '$\\mathslbb{A}$',
    u'\U0001d56d': '$\\mathslbb{B}$',
    u'\U0001d56e': '$\\mathslbb{C}$',
    u'\U0001d56f': '$\\mathslbb{D}$',
    u'\U0001d570': '$\\mathslbb{E}$',
    u'\U0001d571': '$\\mathslbb{F}$',
    u'\U0001d572': '$\\mathslbb{G}$',
    u'\U0001d573': '$\\mathslbb{H}$',
    u'\U0001d574': '$\\mathslbb{I}$',
    u'\U0001d575': '$\\mathslbb{J}$',
    u'\U0001d576': '$\\mathslbb{K}$',
    u'\U0001d577': '$\\mathslbb{L}$',
    u'\U0001d578': '$\\mathslbb{M}$',
    u'\U0001d579': '$\\mathslbb{N}$',
    u'\U0001d57a': '$\\mathslbb{O}$',
    u'\U0001d57b': '$\\mathslbb{P}$',
    u'\U0001d57c': '$\\mathslbb{Q}$',
    u'\U0001d57d': '$\\mathslbb{R}$',
    u'\U0001d57e': '$\\mathslbb{S}$',
    u'\U0001d57f': '$\\mathslbb{T}$',
    u'\U0001d580': '$\\mathslbb{U}$',
    u'\U0001d581': '$\\mathslbb{V}$',
    u'\U0001d582': '$\\mathslbb{W}$',
    u'\U0001d583': '$\\mathslbb{X}$',
    u'\U0001d584': '$\\mathslbb{Y}$',
    u'\U0001d585': '$\\mathslbb{Z}$',
    u'\U0001d586': '$\\mathslbb{a}$',
    u'\U0001d587': '$\\mathslbb{b}$',
    u'\U0001d588': '$\\mathslbb{c}$',
    u'\U0001d589': '$\\mathslbb{d}$',
    u'\U0001d58a': '$\\mathslbb{e}$',
    u'\U0001d58b': '$\\mathslbb{f}$',
    u'\U0001d58c': '$\\mathslbb{g}$',
    u'\U0001d58d': '$\\mathslbb{h}$',
    u'\U0001d58e': '$\\mathslbb{i}$',
    u'\U0001d58f': '$\\mathslbb{j}$',
    u'\U0001d590': '$\\mathslbb{k}$',
    u'\U0001d591': '$\\mathslbb{l}$',
    u'\U0001d592': '$\\mathslbb{m}$',
    u'\U0001d593': '$\\mathslbb{n}$',
    u'\U0001d594': '$\\mathslbb{o}$',
    u'\U0001d595': '$\\mathslbb{p}$',
    u'\U0001d596': '$\\mathslbb{q}$',
    u'\U0001d597': '$\\mathslbb{r}$',
    u'\U0001d598': '$\\mathslbb{s}$',
    u'\U0001d599': '$\\mathslbb{t}$',
    u'\U0001d59a': '$\\mathslbb{u}$',
    u'\U0001d59b': '$\\mathslbb{v}$',
    u'\U0001d59c': '$\\mathslbb{w}$',
    u'\U0001d59d': '$\\mathslbb{x}$',
    u'\U0001d59e': '$\\mathslbb{y}$',
    u'\U0001d59f': '$\\mathslbb{z}$',
    u'\U0001d5a0': '$\\mathsf{A}$',
    u'\U0001d5a1': '$\\mathsf{B}$',
    u'\U0001d5a2': '$\\mathsf{C}$',
    u'\U0001d5a3': '$\\mathsf{D}$',
    u'\U0001d5a4': '$\\mathsf{E}$',
    u'\U0001d5a5': '$\\mathsf{F}$',
    u'\U0001d5a6': '$\\mathsf{G}$',
    u'\U0001d5a7': '$\\mathsf{H}$',
    u'\U0001d5a8': '$\\mathsf{I}$',
    u'\U0001d5a9': '$\\mathsf{J}$',
    u'\U0001d5aa': '$\\mathsf{K}$',
    u'\U0001d5ab': '$\\mathsf{L}$',
    u'\U0001d5ac': '$\\mathsf{M}$',
    u'\U0001d5ad': '$\\mathsf{N}$',
    u'\U0001d5ae': '$\\mathsf{O}$',
    u'\U0001d5af': '$\\mathsf{P}$',
    u'\U0001d5b0': '$\\mathsf{Q}$',
    u'\U0001d5b1': '$\\mathsf{R}$',
    u'\U0001d5b2': '$\\mathsf{S}$',
    u'\U0001d5b3': '$\\mathsf{T}$',
    u'\U0001d5b4': '$\\mathsf{U}$',
    u'\U0001d5b5': '$\\mathsf{V}$',
    u'\U0001d5b6': '$\\mathsf{W}$',
    u'\U0001d5b7': '$\\mathsf{X}$',
    u'\U0001d5b8': '$\\mathsf{Y}$',
    u'\U0001d5b9': '$\\mathsf{Z}$',
    u'\U0001d5ba': '$\\mathsf{a}$',
    u'\U0001d5bb': '$\\mathsf{b}$',
    u'\U0001d5bc': '$\\mathsf{c}$',
    u'\U0001d5bd': '$\\mathsf{d}$',
    u'\U0001d5be': '$\\mathsf{e}$',
    u'\U0001d5bf': '$\\mathsf{f}$',
    u'\U0001d5c0': '$\\mathsf{g}$',
    u'\U0001d5c1': '$\\mathsf{h}$',
    u'\U0001d5c2': '$\\mathsf{i}$',
    u'\U0001d5c3': '$\\mathsf{j}$',
    u'\U0001d5c4': '$\\mathsf{k}$',
    u'\U0001d5c5': '$\\mathsf{l}$',
    u'\U0001d5c6': '$\\mathsf{m}$',
    u'\U0001d5c7': '$\\mathsf{n}$',
    u'\U0001d5c8': '$\\mathsf{o}$',
    u'\U0001d5c9': '$\\mathsf{p}$',
    u'\U0001d5ca': '$\\mathsf{q}$',
    u'\U0001d5cb': '$\\mathsf{r}$',
    u'\U0001d5cc': '$\\mathsf{s}$',
    u'\U0001d5cd': '$\\mathsf{t}$',
    u'\U0001d5ce': '$\\mathsf{u}$',
    u'\U0001d5cf': '$\\mathsf{v}$',
    u'\U0001d5d0': '$\\mathsf{w}$',
    u'\U0001d5d1': '$\\mathsf{x}$',
    u'\U0001d5d2': '$\\mathsf{y}$',
    u'\U0001d5d3': '$\\mathsf{z}$',
    u'\U0001d5d4': '$\\mathsfbf{A}$',
    u'\U0001d5d5': '$\\mathsfbf{B}$',
    u'\U0001d5d6': '$\\mathsfbf{C}$',
    u'\U0001d5d7': '$\\mathsfbf{D}$',
    u'\U0001d5d8': '$\\mathsfbf{E}$',
    u'\U0001d5d9': '$\\mathsfbf{F}$',
    u'\U0001d5da': '$\\mathsfbf{G}$',
    u'\U0001d5db': '$\\mathsfbf{H}$',
    u'\U0001d5dc': '$\\mathsfbf{I}$',
    u'\U0001d5dd': '$\\mathsfbf{J}$',
    u'\U0001d5de': '$\\mathsfbf{K}$',
    u'\U0001d5df': '$\\mathsfbf{L}$',
    u'\U0001d5e0': '$\\mathsfbf{M}$',
    u'\U0001d5e1': '$\\mathsfbf{N}$',
    u'\U0001d5e2': '$\\mathsfbf{O}$',
    u'\U0001d5e3': '$\\mathsfbf{P}$',
    u'\U0001d5e4': '$\\mathsfbf{Q}$',
    u'\U0001d5e5': '$\\mathsfbf{R}$',
    u'\U0001d5e6': '$\\mathsfbf{S}$',
    u'\U0001d5e7': '$\\mathsfbf{T}$',
    u'\U0001d5e8': '$\\mathsfbf{U}$',
    u'\U0001d5e9': '$\\mathsfbf{V}$',
    u'\U0001d5ea': '$\\mathsfbf{W}$',
    u'\U0001d5eb': '$\\mathsfbf{X}$',
    u'\U0001d5ec': '$\\mathsfbf{Y}$',
    u'\U0001d5ed': '$\\mathsfbf{Z}$',
    u'\U0001d5ee': '$\\mathsfbf{a}$',
    u'\U0001d5ef': '$\\mathsfbf{b}$',
    u'\U0001d5f0': '$\\mathsfbf{c}$',
    u'\U0001d5f1': '$\\mathsfbf{d}$',
    u'\U0001d5f2': '$\\mathsfbf{e}$',
    u'\U0001d5f3': '$\\mathsfbf{f}$',
    u'\U0001d5f4': '$\\mathsfbf{g}$',
    u'\U0001d5f5': '$\\mathsfbf{h}$',
    u'\U0001d5f6': '$\\mathsfbf{i}$',
    u'\U0001d5f7': '$\\mathsfbf{j}$',
    u'\U0001d5f8': '$\\mathsfbf{k}$',
    u'\U0001d5f9': '$\\mathsfbf{l}$',
    u'\U0001d5fa': '$\\mathsfbf{m}$',
    u'\U0001d5fb': '$\\mathsfbf{n}$',
    u'\U0001d5fc': '$\\mathsfbf{o}$',
    u'\U0001d5fd': '$\\mathsfbf{p}$',
    u'\U0001d5fe': '$\\mathsfbf{q}$',
    u'\U0001d5ff': '$\\mathsfbf{r}$',
    u'\U0001d600': '$\\mathsfbf{s}$',
    u'\U0001d601': '$\\mathsfbf{t}$',
    u'\U0001d602': '$\\mathsfbf{u}$',
    u'\U0001d603': '$\\mathsfbf{v}$',
    u'\U0001d604': '$\\mathsfbf{w}$',
    u'\U0001d605': '$\\mathsfbf{x}$',
    u'\U0001d606': '$\\mathsfbf{y}$',
    u'\U0001d607': '$\\mathsfbf{z}$',
    u'\U0001d608': '$\\mathsfsl{A}$',
    u'\U0001d609': '$\\mathsfsl{B}$',
    u'\U0001d60a': '$\\mathsfsl{C}$',
    u'\U0001d60b': '$\\mathsfsl{D}$',
    u'\U0001d60c': '$\\mathsfsl{E}$',
    u'\U0001d60d': '$\\mathsfsl{F}$',
    u'\U0001d60e': '$\\mathsfsl{G}$',
    u'\U0001d60f': '$\\mathsfsl{H}$',
    u'\U0001d610': '$\\mathsfsl{I}$',
    u'\U0001d611': '$\\mathsfsl{J}$',
    u'\U0001d612': '$\\mathsfsl{K}$',
    u'\U0001d613': '$\\mathsfsl{L}$',
    u'\U0001d614': '$\\mathsfsl{M}$',
    u'\U0001d615': '$\\mathsfsl{N}$',
    u'\U0001d616': '$\\mathsfsl{O}$',
    u'\U0001d617': '$\\mathsfsl{P}$',
    u'\U0001d618': '$\\mathsfsl{Q}$',
    u'\U0001d619': '$\\mathsfsl{R}$',
    u'\U0001d61a': '$\\mathsfsl{S}$',
    u'\U0001d61b': '$\\mathsfsl{T}$',
    u'\U0001d61c': '$\\mathsfsl{U}$',
    u'\U0001d61d': '$\\mathsfsl{V}$',
    u'\U0001d61e': '$\\mathsfsl{W}$',
    u'\U0001d61f': '$\\mathsfsl{X}$',
    u'\U0001d620': '$\\mathsfsl{Y}$',
    u'\U0001d621': '$\\mathsfsl{Z}$',
    u'\U0001d622': '$\\mathsfsl{a}$',
    u'\U0001d623': '$\\mathsfsl{b}$',
    u'\U0001d624': '$\\mathsfsl{c}$',
    u'\U0001d625': '$\\mathsfsl{d}$',
    u'\U0001d626': '$\\mathsfsl{e}$',
    u'\U0001d627': '$\\mathsfsl{f}$',
    u'\U0001d628': '$\\mathsfsl{g}$',
    u'\U0001d629': '$\\mathsfsl{h}$',
    u'\U0001d62a': '$\\mathsfsl{i}$',
    u'\U0001d62b': '$\\mathsfsl{j}$',
    u'\U0001d62c': '$\\mathsfsl{k}$',
    u'\U0001d62d': '$\\mathsfsl{l}$',
    u'\U0001d62e': '$\\mathsfsl{m}$',
    u'\U0001d62f': '$\\mathsfsl{n}$',
    u'\U0001d630': '$\\mathsfsl{o}$',
    u'\U0001d631': '$\\mathsfsl{p}$',
    u'\U0001d632': '$\\mathsfsl{q}$',
    u'\U0001d633': '$\\mathsfsl{r}$',
    u'\U0001d634': '$\\mathsfsl{s}$',
    u'\U0001d635': '$\\mathsfsl{t}$',
    u'\U0001d636': '$\\mathsfsl{u}$',
    u'\U0001d637': '$\\mathsfsl{v}$',
    u'\U0001d638': '$\\mathsfsl{w}$',
    u'\U0001d639': '$\\mathsfsl{x}$',
    u'\U0001d63a': '$\\mathsfsl{y}$',
    u'\U0001d63b': '$\\mathsfsl{z}$',
    u'\U0001d63c': '$\\mathsfbfsl{A}$',
    u'\U0001d63d': '$\\mathsfbfsl{B}$',
    u'\U0001d63e': '$\\mathsfbfsl{C}$',
    u'\U0001d63f': '$\\mathsfbfsl{D}$',
    u'\U0001d640': '$\\mathsfbfsl{E}$',
    u'\U0001d641': '$\\mathsfbfsl{F}$',
    u'\U0001d642': '$\\mathsfbfsl{G}$',
    u'\U0001d643': '$\\mathsfbfsl{H}$',
    u'\U0001d644': '$\\mathsfbfsl{I}$',
    u'\U0001d645': '$\\mathsfbfsl{J}$',
    u'\U0001d646': '$\\mathsfbfsl{K}$',
    u'\U0001d647': '$\\mathsfbfsl{L}$',
    u'\U0001d648': '$\\mathsfbfsl{M}$',
    u'\U0001d649': '$\\mathsfbfsl{N}$',
    u'\U0001d64a': '$\\mathsfbfsl{O}$',
    u'\U0001d64b': '$\\mathsfbfsl{P}$',
    u'\U0001d64c': '$\\mathsfbfsl{Q}$',
    u'\U0001d64d': '$\\mathsfbfsl{R}$',
    u'\U0001d64e': '$\\mathsfbfsl{S}$',
    u'\U0001d64f': '$\\mathsfbfsl{T}$',
    u'\U0001d650': '$\\mathsfbfsl{U}$',
    u'\U0001d651': '$\\mathsfbfsl{V}$',
    u'\U0001d652': '$\\mathsfbfsl{W}$',
    u'\U0001d653': '$\\mathsfbfsl{X}$',
    u'\U0001d654': '$\\mathsfbfsl{Y}$',
    u'\U0001d655': '$\\mathsfbfsl{Z}$',
    u'\U0001d656': '$\\mathsfbfsl{a}$',
    u'\U0001d657': '$\\mathsfbfsl{b}$',
    u'\U0001d658': '$\\mathsfbfsl{c}$',
    u'\U0001d659': '$\\mathsfbfsl{d}$',
    u'\U0001d65a': '$\\mathsfbfsl{e}$',
    u'\U0001d65b': '$\\mathsfbfsl{f}$',
    u'\U0001d65c': '$\\mathsfbfsl{g}$',
    u'\U0001d65d': '$\\mathsfbfsl{h}$',
    u'\U0001d65e': '$\\mathsfbfsl{i}$',
    u'\U0001d65f': '$\\mathsfbfsl{j}$',
    u'\U0001d660': '$\\mathsfbfsl{k}$',
    u'\U0001d661': '$\\mathsfbfsl{l}$',
    u'\U0001d662': '$\\mathsfbfsl{m}$',
    u'\U0001d663': '$\\mathsfbfsl{n}$',
    u'\U0001d664': '$\\mathsfbfsl{o}$',
    u'\U0001d665': '$\\mathsfbfsl{p}$',
    u'\U0001d666': '$\\mathsfbfsl{q}$',
    u'\U0001d667': '$\\mathsfbfsl{r}$',
    u'\U0001d668': '$\\mathsfbfsl{s}$',
    u'\U0001d669': '$\\mathsfbfsl{t}$',
    u'\U0001d66a': '$\\mathsfbfsl{u}$',
    u'\U0001d66b': '$\\mathsfbfsl{v}$',
    u'\U0001d66c': '$\\mathsfbfsl{w}$',
    u'\U0001d66d': '$\\mathsfbfsl{x}$',
    u'\U0001d66e': '$\\mathsfbfsl{y}$',
    u'\U0001d66f': '$\\mathsfbfsl{z}$',
    u'\U0001d670': '$\\mathtt{A}$',
    u'\U0001d671': '$\\mathtt{B}$',
    u'\U0001d672': '$\\mathtt{C}$',
    u'\U0001d673': '$\\mathtt{D}$',
    u'\U0001d674': '$\\mathtt{E}$',
    u'\U0001d675': '$\\mathtt{F}$',
    u'\U0001d676': '$\\mathtt{G}$',
    u'\U0001d677': '$\\mathtt{H}$',
    u'\U0001d678': '$\\mathtt{I}$',
    u'\U0001d679': '$\\mathtt{J}$',
    u'\U0001d67a': '$\\mathtt{K}$',
    u'\U0001d67b': '$\\mathtt{L}$',
    u'\U0001d67c': '$\\mathtt{M}$',
    u'\U0001d67d': '$\\mathtt{N}$',
    u'\U0001d67e': '$\\mathtt{O}$',
    u'\U0001d67f': '$\\mathtt{P}$',
    u'\U0001d680': '$\\mathtt{Q}$',
    u'\U0001d681': '$\\mathtt{R}$',
    u'\U0001d682': '$\\mathtt{S}$',
    u'\U0001d683': '$\\mathtt{T}$',
    u'\U0001d684': '$\\mathtt{U}$',
    u'\U0001d685': '$\\mathtt{V}$',
    u'\U0001d686': '$\\mathtt{W}$',
    u'\U0001d687': '$\\mathtt{X}$',
    u'\U0001d688': '$\\mathtt{Y}$',
    u'\U0001d689': '$\\mathtt{Z}$',
    u'\U0001d68a': '$\\mathtt{a}$',
    u'\U0001d68b': '$\\mathtt{b}$',
    u'\U0001d68c': '$\\mathtt{c}$',
    u'\U0001d68d': '$\\mathtt{d}$',
    u'\U0001d68e': '$\\mathtt{e}$',
    u'\U0001d68f': '$\\mathtt{f}$',
    u'\U0001d690': '$\\mathtt{g}$',
    u'\U0001d691': '$\\mathtt{h}$',
    u'\U0001d692': '$\\mathtt{i}$',
    u'\U0001d693': '$\\mathtt{j}$',
    u'\U0001d694': '$\\mathtt{k}$',
    u'\U0001d695': '$\\mathtt{l}$',
    u'\U0001d696': '$\\mathtt{m}$',
    u'\U0001d697': '$\\mathtt{n}$',
    u'\U0001d698': '$\\mathtt{o}$',
    u'\U0001d699': '$\\mathtt{p}$',
    u'\U0001d69a': '$\\mathtt{q}$',
    u'\U0001d69b': '$\\mathtt{r}$',
    u'\U0001d69c': '$\\mathtt{s}$',
    u'\U0001d69d': '$\\mathtt{t}$',
    u'\U0001d69e': '$\\mathtt{u}$',
    u'\U0001d69f': '$\\mathtt{v}$',
    u'\U0001d6a0': '$\\mathtt{w}$',
    u'\U0001d6a1': '$\\mathtt{x}$',
    u'\U0001d6a2': '$\\mathtt{y}$',
    u'\U0001d6a3': '$\\mathtt{z}$',
    u'\U0001d6a8': '$\\mathbf{\\Alpha}$',
    u'\U0001d6a9': '$\\mathbf{\\Beta}$',
    u'\U0001d6aa': '$\\mathbf{\\Gamma}$',
    u'\U0001d6ab': '$\\mathbf{\\Delta}$',
    u'\U0001d6ac': '$\\mathbf{\\Epsilon}$',
    u'\U0001d6ad': '$\\mathbf{\\Zeta}$',
    u'\U0001d6ae': '$\\mathbf{\\Eta}$',
    u'\U0001d6af': '$\\mathbf{\\Theta}$',
    u'\U0001d6b0': '$\\mathbf{\\Iota}$',
    u'\U0001d6b1': '$\\mathbf{\\Kappa}$',
    u'\U0001d6b2': '$\\mathbf{\\Lambda}$',
    u'\U0001d6b3': '$M$',
    u'\U0001d6b4': '$N$',
    u'\U0001d6b5': '$\\mathbf{\\Xi}$',
    u'\U0001d6b6': '$O$',
    u'\U0001d6b7': '$\\mathbf{\\Pi}$',
    u'\U0001d6b8': '$\\mathbf{\\Rho}$',
    u'\U0001d6b9': '{\\mathbf{\\vartheta}}',
    u'\U0001d6ba': '$\\mathbf{\\Sigma}$',
    u'\U0001d6bb': '$\\mathbf{\\Tau}$',
    u'\U0001d6bc': '$\\mathbf{\\Upsilon}$',
    u'\U0001d6bd': '$\\mathbf{\\Phi}$',
    u'\U0001d6be': '$\\mathbf{\\Chi}$',
    u'\U0001d6bf': '$\\mathbf{\\Psi}$',
    u'\U0001d6c0': '$\\mathbf{\\Omega}$',
    u'\U0001d6c1': '$\\mathbf{\\nabla}$',
    u'\U0001d6c2': '$\\mathbf{\\Alpha}$',
    u'\U0001d6c3': '$\\mathbf{\\Beta}$',
    u'\U0001d6c4': '$\\mathbf{\\Gamma}$',
    u'\U0001d6c5': '$\\mathbf{\\Delta}$',
    u'\U0001d6c6': '$\\mathbf{\\Epsilon}$',
    u'\U0001d6c7': '$\\mathbf{\\Zeta}$',
    u'\U0001d6c8': '$\\mathbf{\\Eta}$',
    u'\U0001d6c9': '$\\mathbf{\\theta}$',
    u'\U0001d6ca': '$\\mathbf{\\Iota}$',
    u'\U0001d6cb': '$\\mathbf{\\Kappa}$',
    u'\U0001d6cc': '$\\mathbf{\\Lambda}$',
    u'\U0001d6cd': '$M$',
    u'\U0001d6ce': '$N$',
    u'\U0001d6cf': '$\\mathbf{\\Xi}$',
    u'\U0001d6d0': '$O$',
    u'\U0001d6d1': '$\\mathbf{\\Pi}$',
    u'\U0001d6d2': '$\\mathbf{\\Rho}$',
    u'\U0001d6d3': '$\\mathbf{\\varsigma}$',
    u'\U0001d6d4': '$\\mathbf{\\Sigma}$',
    u'\U0001d6d5': '$\\mathbf{\\Tau}$',
    u'\U0001d6d6': '$\\mathbf{\\Upsilon}$',
    u'\U0001d6d7': '$\\mathbf{\\Phi}$',
    u'\U0001d6d8': '$\\mathbf{\\Chi}$',
    u'\U0001d6d9': '$\\mathbf{\\Psi}$',
    u'\U0001d6da': '$\\mathbf{\\Omega}$',
    u'\U0001d6db': '$\\partial$',
    u'\U0001d6dc': '$\\in$',
    u'\U0001d6dd': '{\\mathbf{\\vartheta}}',
    u'\U0001d6de': '{\\mathbf{\\varkappa}}',
    u'\U0001d6df': '{\\mathbf{\\phi}}',
    u'\U0001d6e0': '{\\mathbf{\\varrho}}',
    u'\U0001d6e1': '{\\mathbf{\\varpi}}',
    u'\U0001d6e2': '$\\mathsl{\\Alpha}$',
    u'\U0001d6e3': '$\\mathsl{\\Beta}$',
    u'\U0001d6e4': '$\\mathsl{\\Gamma}$',
    u'\U0001d6e5': '$\\mathsl{\\Delta}$',
    u'\U0001d6e6': '$\\mathsl{\\Epsilon}$',
    u'\U0001d6e7': '$\\mathsl{\\Zeta}$',
    u'\U0001d6e8': '$\\mathsl{\\Eta}$',
    u'\U0001d6e9': '$\\mathsl{\\Theta}$',
    u'\U0001d6ea': '$\\mathsl{\\Iota}$',
    u'\U0001d6eb': '$\\mathsl{\\Kappa}$',
    u'\U0001d6ec': '$\\mathsl{\\Lambda}$',
    u'\U0001d6ed': '$M$',
    u'\U0001d6ee': '$N$',
    u'\U0001d6ef': '$\\mathsl{\\Xi}$',
    u'\U0001d6f0': '$O$',
    u'\U0001d6f1': '$\\mathsl{\\Pi}$',
    u'\U0001d6f2': '$\\mathsl{\\Rho}$',
    u'\U0001d6f3': '{\\mathsl{\\vartheta}}',
    u'\U0001d6f4': '$\\mathsl{\\Sigma}$',
    u'\U0001d6f5': '$\\mathsl{\\Tau}$',
    u'\U0001d6f6': '$\\mathsl{\\Upsilon}$',
    u'\U0001d6f7': '$\\mathsl{\\Phi}$',
    u'\U0001d6f8': '$\\mathsl{\\Chi}$',
    u'\U0001d6f9': '$\\mathsl{\\Psi}$',
    u'\U0001d6fa': '$\\mathsl{\\Omega}$',
    u'\U0001d6fb': '$\\mathsl{\\nabla}$',
    u'\U0001d6fc': '$\\mathsl{\\Alpha}$',
    u'\U0001d6fd': '$\\mathsl{\\Beta}$',
    u'\U0001d6fe': '$\\mathsl{\\Gamma}$',
    u'\U0001d6ff': '$\\mathsl{\\Delta}$',
    u'\U0001d700': '$\\mathsl{\\Epsilon}$',
    u'\U0001d701': '$\\mathsl{\\Zeta}$',
    u'\U0001d702': '$\\mathsl{\\Eta}$',
    u'\U0001d703': '$\\mathsl{\\Theta}$',
    u'\U0001d704': '$\\mathsl{\\Iota}$',
    u'\U0001d705': '$\\mathsl{\\Kappa}$',
    u'\U0001d706': '$\\mathsl{\\Lambda}$',
    u'\U0001d707': '$M$',
    u'\U0001d708': '$N$',
    u'\U0001d709': '$\\mathsl{\\Xi}$',
    u'\U0001d70a': '$O$',
    u'\U0001d70b': '$\\mathsl{\\Pi}$',
    u'\U0001d70c': '$\\mathsl{\\Rho}$',
    u'\U0001d70d': '$\\mathsl{\\varsigma}$',
    u'\U0001d70e': '$\\mathsl{\\Sigma}$',
    u'\U0001d70f': '$\\mathsl{\\Tau}$',
    u'\U0001d710': '$\\mathsl{\\Upsilon}$',
    u'\U0001d711': '$\\mathsl{\\Phi}$',
    u'\U0001d712': '$\\mathsl{\\Chi}$',
    u'\U0001d713': '$\\mathsl{\\Psi}$',
    u'\U0001d714': '$\\mathsl{\\Omega}$',
    u'\U0001d715': '$\\partial$',
    u'\U0001d716': '$\\in$',
    u'\U0001d717': '{\\mathsl{\\vartheta}}',
    u'\U0001d718': '{\\mathsl{\\varkappa}}',
    u'\U0001d719': '{\\mathsl{\\phi}}',
    u'\U0001d71a': '{\\mathsl{\\varrho}}',
    u'\U0001d71b': '{\\mathsl{\\varpi}}',
    u'\U0001d71c': '$\\mathbit{\\Alpha}$',
    u'\U0001d71d': '$\\mathbit{\\Beta}$',
    u'\U0001d71e': '$\\mathbit{\\Gamma}$',
    u'\U0001d71f': '$\\mathbit{\\Delta}$',
    u'\U0001d720': '$\\mathbit{\\Epsilon}$',
    u'\U0001d721': '$\\mathbit{\\Zeta}$',
    u'\U0001d722': '$\\mathbit{\\Eta}$',
    u'\U0001d723': '$\\mathbit{\\Theta}$',
    u'\U0001d724': '$\\mathbit{\\Iota}$',
    u'\U0001d725': '$\\mathbit{\\Kappa}$',
    u'\U0001d726': '$\\mathbit{\\Lambda}$',
    u'\U0001d727': '$M$',
    u'\U0001d728': '$N$',
    u'\U0001d729': '$\\mathbit{\\Xi}$',
    u'\U0001d72a': '$O$',
    u'\U0001d72b': '$\\mathbit{\\Pi}$',
    u'\U0001d72c': '$\\mathbit{\\Rho}$',
    u'\U0001d72d': '{\\mathbit{O}}',
    u'\U0001d72e': '$\\mathbit{\\Sigma}$',
    u'\U0001d72f': '$\\mathbit{\\Tau}$',
    u'\U0001d730': '$\\mathbit{\\Upsilon}$',
    u'\U0001d731': '$\\mathbit{\\Phi}$',
    u'\U0001d732': '$\\mathbit{\\Chi}$',
    u'\U0001d733': '$\\mathbit{\\Psi}$',
    u'\U0001d734': '$\\mathbit{\\Omega}$',
    u'\U0001d735': '$\\mathbit{\\nabla}$',
    u'\U0001d736': '$\\mathbit{\\Alpha}$',
    u'\U0001d737': '$\\mathbit{\\Beta}$',
    u'\U0001d738': '$\\mathbit{\\Gamma}$',
    u'\U0001d739': '$\\mathbit{\\Delta}$',
    u'\U0001d73a': '$\\mathbit{\\Epsilon}$',
    u'\U0001d73b': '$\\mathbit{\\Zeta}$',
    u'\U0001d73c': '$\\mathbit{\\Eta}$',
    u'\U0001d73d': '$\\mathbit{\\Theta}$',
    u'\U0001d73e': '$\\mathbit{\\Iota}$',
    u'\U0001d73f': '$\\mathbit{\\Kappa}$',
    u'\U0001d740': '$\\mathbit{\\Lambda}$',
    u'\U0001d741': '$M$',
    u'\U0001d742': '$N$',
    u'\U0001d743': '$\\mathbit{\\Xi}$',
    u'\U0001d744': '$O$',
    u'\U0001d745': '$\\mathbit{\\Pi}$',
    u'\U0001d746': '$\\mathbit{\\Rho}$',
    u'\U0001d747': '$\\mathbit{\\varsigma}$',
    u'\U0001d748': '$\\mathbit{\\Sigma}$',
    u'\U0001d749': '$\\mathbit{\\Tau}$',
    u'\U0001d74a': '$\\mathbit{\\Upsilon}$',
    u'\U0001d74b': '$\\mathbit{\\Phi}$',
    u'\U0001d74c': '$\\mathbit{\\Chi}$',
    u'\U0001d74d': '$\\mathbit{\\Psi}$',
    u'\U0001d74e': '$\\mathbit{\\Omega}$',
    u'\U0001d74f': '$\\partial$',
    u'\U0001d750': '$\\in$',
    u'\U0001d751': '{\\mathbit{\\vartheta}}',
    u'\U0001d752': '{\\mathbit{\\varkappa}}',
    u'\U0001d753': '{\\mathbit{\\phi}}',
    u'\U0001d754': '{\\mathbit{\\varrho}}',
    u'\U0001d755': '{\\mathbit{\\varpi}}',
    u'\U0001d756': '$\\mathsfbf{\\Alpha}$',
    u'\U0001d757': '$\\mathsfbf{\\Beta}$',
    u'\U0001d758': '$\\mathsfbf{\\Gamma}$',
    u'\U0001d759': '$\\mathsfbf{\\Delta}$',
    u'\U0001d75a': '$\\mathsfbf{\\Epsilon}$',
    u'\U0001d75b': '$\\mathsfbf{\\Zeta}$',
    u'\U0001d75c': '$\\mathsfbf{\\Eta}$',
    u'\U0001d75d': '$\\mathsfbf{\\Theta}$',
    u'\U0001d75e': '$\\mathsfbf{\\Iota}$',
    u'\U0001d75f': '$\\mathsfbf{\\Kappa}$',
    u'\U0001d760': '$\\mathsfbf{\\Lambda}$',
    u'\U0001d761': '$M$',
    u'\U0001d762': '$N$',
    u'\U0001d763': '$\\mathsfbf{\\Xi}$',
    u'\U0001d764': '$O$',
    u'\U0001d765': '$\\mathsfbf{\\Pi}$',
    u'\U0001d766': '$\\mathsfbf{\\Rho}$',
    u'\U0001d767': '{\\mathsfbf{\\vartheta}}',
    u'\U0001d768': '$\\mathsfbf{\\Sigma}$',
    u'\U0001d769': '$\\mathsfbf{\\Tau}$',
    u'\U0001d76a': '$\\mathsfbf{\\Upsilon}$',
    u'\U0001d76b': '$\\mathsfbf{\\Phi}$',
    u'\U0001d76c': '$\\mathsfbf{\\Chi}$',
    u'\U0001d76d': '$\\mathsfbf{\\Psi}$',
    u'\U0001d76e': '$\\mathsfbf{\\Omega}$',
    u'\U0001d76f': '$\\mathsfbf{\\nabla}$',
    u'\U0001d770': '$\\mathsfbf{\\Alpha}$',
    u'\U0001d771': '$\\mathsfbf{\\Beta}$',
    u'\U0001d772': '$\\mathsfbf{\\Gamma}$',
    u'\U0001d773': '$\\mathsfbf{\\Delta}$',
    u'\U0001d774': '$\\mathsfbf{\\Epsilon}$',
    u'\U0001d775': '$\\mathsfbf{\\Zeta}$',
    u'\U0001d776': '$\\mathsfbf{\\Eta}$',
    u'\U0001d777': '$\\mathsfbf{\\Theta}$',
    u'\U0001d778': '$\\mathsfbf{\\Iota}$',
    u'\U0001d779': '$\\mathsfbf{\\Kappa}$',
    u'\U0001d77a': '$\\mathsfbf{\\Lambda}$',
    u'\U0001d77b': '$M$',
    u'\U0001d77c': '$N$',
    u'\U0001d77d': '$\\mathsfbf{\\Xi}$',
    u'\U0001d77e': '$O$',
    u'\U0001d77f': '$\\mathsfbf{\\Pi}$',
    u'\U0001d780': '$\\mathsfbf{\\Rho}$',
    u'\U0001d781': '$\\mathsfbf{\\varsigma}$',
    u'\U0001d782': '$\\mathsfbf{\\Sigma}$',
    u'\U0001d783': '$\\mathsfbf{\\Tau}$',
    u'\U0001d784': '$\\mathsfbf{\\Upsilon}$',
    u'\U0001d785': '$\\mathsfbf{\\Phi}$',
    u'\U0001d786': '$\\mathsfbf{\\Chi}$',
    u'\U0001d787': '$\\mathsfbf{\\Psi}$',
    u'\U0001d788': '$\\mathsfbf{\\Omega}$',
    u'\U0001d789': '$\\partial$',
    u'\U0001d78a': '$\\in$',
    u'\U0001d78b': '{\\mathsfbf{\\vartheta}}',
    u'\U0001d78c': '{\\mathsfbf{\\varkappa}}',
    u'\U0001d78d': '{\\mathsfbf{\\phi}}',
    u'\U0001d78e': '{\\mathsfbf{\\varrho}}',
    u'\U0001d78f': '{\\mathsfbf{\\varpi}}',
    u'\U0001d790': '$\\mathsfbfsl{\\Alpha}$',
    u'\U0001d791': '$\\mathsfbfsl{\\Beta}$',
    u'\U0001d792': '$\\mathsfbfsl{\\Gamma}$',
    u'\U0001d793': '$\\mathsfbfsl{\\Delta}$',
    u'\U0001d794': '$\\mathsfbfsl{\\Epsilon}$',
    u'\U0001d795': '$\\mathsfbfsl{\\Zeta}$',
    u'\U0001d796': '$\\mathsfbfsl{\\Eta}$',
    u'\U0001d797': '$\\mathsfbfsl{\\vartheta}$',
    u'\U0001d798': '$\\mathsfbfsl{\\Iota}$',
    u'\U0001d799': '$\\mathsfbfsl{\\Kappa}$',
    u'\U0001d79a': '$\\mathsfbfsl{\\Lambda}$',
    u'\U0001d79b': '$M$',
    u'\U0001d79c': '$N$',
    u'\U0001d79d': '$\\mathsfbfsl{\\Xi}$',
    u'\U0001d79e': '$O$',
    u'\U0001d79f': '$\\mathsfbfsl{\\Pi}$',
    u'\U0001d7a0': '$\\mathsfbfsl{\\Rho}$',
    u'\U0001d7a1': '{\\mathsfbfsl{\\vartheta}}',
    u'\U0001d7a2': '$\\mathsfbfsl{\\Sigma}$',
    u'\U0001d7a3': '$\\mathsfbfsl{\\Tau}$',
    u'\U0001d7a4': '$\\mathsfbfsl{\\Upsilon}$',
    u'\U0001d7a5': '$\\mathsfbfsl{\\Phi}$',
    u'\U0001d7a6': '$\\mathsfbfsl{\\Chi}$',
    u'\U0001d7a7': '$\\mathsfbfsl{\\Psi}$',
    u'\U0001d7a8': '$\\mathsfbfsl{\\Omega}$',
    u'\U0001d7a9': '$\\mathsfbfsl{\\nabla}$',
    u'\U0001d7aa': '$\\mathsfbfsl{\\Alpha}$',
    u'\U0001d7ab': '$\\mathsfbfsl{\\Beta}$',
    u'\U0001d7ac': '$\\mathsfbfsl{\\Gamma}$',
    u'\U0001d7ad': '$\\mathsfbfsl{\\Delta}$',
    u'\U0001d7ae': '$\\mathsfbfsl{\\Epsilon}$',
    u'\U0001d7af': '$\\mathsfbfsl{\\Zeta}$',
    u'\U0001d7b0': '$\\mathsfbfsl{\\Eta}$',
    u'\U0001d7b1': '$\\mathsfbfsl{\\vartheta}$',
    u'\U0001d7b2': '$\\mathsfbfsl{\\Iota}$',
    u'\U0001d7b3': '$\\mathsfbfsl{\\Kappa}$',
    u'\U0001d7b4': '$\\mathsfbfsl{\\Lambda}$',
    u'\U0001d7b5': '$M$',
    u'\U0001d7b6': '$N$',
    u'\U0001d7b7': '$\\mathsfbfsl{\\Xi}$',
    u'\U0001d7b8': '$O$',
    u'\U0001d7b9': '$\\mathsfbfsl{\\Pi}$',
    u'\U0001d7ba': '$\\mathsfbfsl{\\Rho}$',
    u'\U0001d7bb': '$\\mathsfbfsl{\\varsigma}$',
    u'\U0001d7bc': '$\\mathsfbfsl{\\Sigma}$',
    u'\U0001d7bd': '$\\mathsfbfsl{\\Tau}$',
    u'\U0001d7be': '$\\mathsfbfsl{\\Upsilon}$',
    u'\U0001d7bf': '$\\mathsfbfsl{\\Phi}$',
    u'\U0001d7c0': '$\\mathsfbfsl{\\Chi}$',
    u'\U0001d7c1': '$\\mathsfbfsl{\\Psi}$',
    u'\U0001d7c2': '$\\mathsfbfsl{\\Omega}$',
    u'\U0001d7c3': '$\\partial$',
    u'\U0001d7c4': '$\\in$',
    u'\U0001d7c5': '{\\mathsfbfsl{\\vartheta}}',
    u'\U0001d7c6': '{\\mathsfbfsl{\\varkappa}}',
    u'\U0001d7c7': '{\\mathsfbfsl{\\phi}}',
    u'\U0001d7c8': '{\\mathsfbfsl{\\varrho}}',
    u'\U0001d7c9': '{\\mathsfbfsl{\\varpi}}',
    u'\U0001d7ce': '$\\mathbf{0}$',
    u'\U0001d7cf': '$\\mathbf{1}$',
    u'\U0001d7d0': '$\\mathbf{2}$',
    u'\U0001d7d1': '$\\mathbf{3}$',
    u'\U0001d7d2': '$\\mathbf{4}$',
    u'\U0001d7d3': '$\\mathbf{5}$',
    u'\U0001d7d4': '$\\mathbf{6}$',
    u'\U0001d7d5': '$\\mathbf{7}$',
    u'\U0001d7d6': '$\\mathbf{8}$',
    u'\U0001d7d7': '$\\mathbf{9}$',
    u'\U0001d7d8': '$\\mathbb{0}$',
    u'\U0001d7d9': '$\\mathbb{1}$',
    u'\U0001d7da': '$\\mathbb{2}$',
    u'\U0001d7db': '$\\mathbb{3}$',
    u'\U0001d7dc': '$\\mathbb{4}$',
    u'\U0001d7dd': '$\\mathbb{5}$',
    u'\U0001d7de': '$\\mathbb{6}$',
    u'\U0001d7df': '$\\mathbb{7}$',
    u'\U0001d7e0': '$\\mathbb{8}$',
    u'\U0001d7e1': '$\\mathbb{9}$',
    u'\U0001d7e2': '$\\mathsf{0}$',
    u'\U0001d7e3': '$\\mathsf{1}$',
    u'\U0001d7e4': '$\\mathsf{2}$',
    u'\U0001d7e5': '$\\mathsf{3}$',
    u'\U0001d7e6': '$\\mathsf{4}$',
    u'\U0001d7e7': '$\\mathsf{5}$',
    u'\U0001d7e8': '$\\mathsf{6}$',
    u'\U0001d7e9': '$\\mathsf{7}$',
    u'\U0001d7ea': '$\\mathsf{8}$',
    u'\U0001d7eb': '$\\mathsf{9}$',
    u'\U0001d7ec': '$\\mathsfbf{0}$',
    u'\U0001d7ed': '$\\mathsfbf{1}$',
    u'\U0001d7ee': '$\\mathsfbf{2}$',
    u'\U0001d7ef': '$\\mathsfbf{3}$',
    u'\U0001d7f0': '$\\mathsfbf{4}$',
    u'\U0001d7f1': '$\\mathsfbf{5}$',
    u'\U0001d7f2': '$\\mathsfbf{6}$',
    u'\U0001d7f3': '$\\mathsfbf{7}$',
    u'\U0001d7f4': '$\\mathsfbf{8}$',
    u'\U0001d7f5': '$\\mathsfbf{9}$',
    u'\U0001d7f6': '$\\mathtt{0}$',
    u'\U0001d7f7': '$\\mathtt{1}$',
    u'\U0001d7f8': '$\\mathtt{2}$',
    u'\U0001d7f9': '$\\mathtt{3}$',
    u'\U0001d7fa': '$\\mathtt{4}$',
    u'\U0001d7fb': '$\\mathtt{5}$',
    u'\U0001d7fc': '$\\mathtt{6}$',
    u'\U0001d7fd': '$\\mathtt{7}$',
    u'\U0001d7fe': '$\\mathtt{8}$',
    u'\U0001d7ff': '$\\mathtt{9}$',

    # Items from simple list
    u'\u0106': "{\\a\\'C}",
    u'\u0408': '{\\CYRJE}',
    u'\u20ac': '{\\texteuro}',
    u'\u2191': '{\\textuparrow}',
    u'\u0493': '{\\cyrghcrs}',
    u'\u2116': '{\\textnumero}',
    u'\u0418': '{\\CYRI}',
    u'\u04a3': '{\\cyrndsc}',
    u'\u2126': '{\\textohm}',
    u'\u0428': '{\\CYRSH}',
    u'\u04b3': '{\\cyrhdsc}',
    u'\u0438': '{\\cyri}',
    u'\u03bd': '{$\\nu$}',
    u'\u04c3': '{\\CYRKHK}',
    u'\u0448': '{\\cyrsh}',
    u'\xcb': '{\\"E}',
    u'\u0458': '{\\cyrje}',
    u'\xdb': '{\\^U}',
    u'\xeb': '{\\"e}',
    u'\xfb': '{\\^u}',
    u'\u0413': '{\\CYRG}',
    u'\u0498': '{\\CYRZDSC}',
    u'\xa0': '{~}',
    u'\u0423': '{\\CYRU}',
    u'\u04a8': '{\\CYRABHHA}',
    u'\u0433': '{\\cyrg}',
    u'\u04b8': '{\\CYRCHVCRS}',
    u'\u203b': '{\\textreferencemark}',
    u'\u211e': '{\\textrecipe}',
    u'\xc0': '{\\`A}',
    u'\u0443': '{\\cyru}',
    u'\u04c8': '{\\cyrnhk}',
    u'\u0151': '{\\H o}',
    u'\u04d8': '{\\CYRSCHWA}',
    u'\u0161': '{\\v s}',
    u'\xe0': '{\\`a}',
    u'\u0463': '{\\cyryat}',
    u'\u04e8': '{\\CYROTLD}',
    u'\u0171': '{\\H u}',
    u'\u0473': '{\\cyrfita}',
    u'\u20ab': '{\\textdong}',
    u'\u2103': '{\\textcelsius}',
    u'\u040e': '{\\CYRUSHRT}',
    u'\u2212': '{\\textminus}',
    u'\u2016': '{\\textbardbl}',
    u'\u0499': '{\\cyrzdsc}',
    u'\u041e': '{\\CYRO}',
    u'\u2120': '{\\textservicemark}',
    u'\u03a7': '{$\\chi$}',
    u'\u2026': '{\\textellipsis}',
    u'\u04a9': '{\\cyrabhha}',
    u'\u042e': '{\\CYRYU}',
    u'\xb1': '{\\textpm}',
    u'\u0130': '{\\.I}',
    u'\u04b9': '{\\cyrchvcrs}',
    u'\u043e': '{\\cyro}',
    u'\xc1': "{\\'A}",
    u'\u044e': '{\\cyryu}',
    u'\xd1': '{\\~N}',
    u'\u0150': '{\\H O}',
    u'\u04d9': '{\\cyrschwa}',
    u'\u02dd': '{\\textacutedbl}',
    u'\u045e': '{\\cyrushrt}',
    u'\xe1': "{\\'a}",
    u'\u0160': '{\\v S}',
    u'\u04e9': '{\\cyrotld}',
    u'\u266a': '{\\textmusicalnote}',
    u'\xf1': '{\\~n}',
    u'\u0170': '{\\H U}',
    u'\u0409': '{\\CYRLJE}',
    u'\u048e': '{\\CYRRTICK}',
    u'\u2190': '{\\leftarrow}',
    u'\u0419': '{\\CYRISHRT}',
    u'\u011b': '{\\v e}',
    u'\u049e': '{\\CYRKHCRS}',
    u'\u0429': '{\\CYRSHCH}',
    u'\u04ae': '{\\CYRY}',
    u'\u0439': '{\\cyrishrt}',
    u'\u04be': '{\\CYRABHCHDSC}',
    u'\u0449': '{\\cyrshch}',
    u'\u04ce': '{\\cyrmdsc}',
    u'\xd6': '{\\"O}',
    u'\u0459': '{\\cyrlje}',
    u'\u015b': "{\\'s}",
    u'\u20a6': '{\\textnaira}',
    u'\xf6': '{\\"o}',
    u'\u017b': '{\\.Z}',
    u'\u0102': '{\\u A}',
    u'\u0404': '{\\CYRIE}',
    u'\u200c': '{\\textcompwordmark}',
    u'\u048f': '{\\cyrrtick}',
    u'\u0414': '{\\CYRD}',
    u'\u049f': '{\\cyrkhcrs}',
    u'\u0424': '{\\CYRF}',
    u'\u04af': '{\\cyry}',
    u'\u0434': '{\\cyrd}',
    u'\xb7': '{\\textperiodcentered}',
    u'\u04bf': '{\\cyrabhchdsc}',
    u'\u0444': '{\\cyrf}',
    u'\xc7': '{\\c C}',
    u'\u0454': '{\\cyrie}',
    u'\u0162': '{\\c T}',
    u'\xe7': '{\\c c}',
    u'\u0474': '{\\CYRIZH}',
    u'\xf7': '{\\textdiv}',
    u'\u010d': '{\\v c}',
    u'\u040f': '{\\CYRDZHE}',
    u'\u0192': '{\\textflorin}',
    u'\u0494': '{\\CYRGHK}',
    u'\u041f': '{\\CYRP}',
    u'\u04a4': '{\\CYRNG}',
    u'\xac': '{\\textlnot}',
    u'\u042f': '{\\CYRYA}',
    u'\u04b4': '{\\CYRTETSE}',
    u'\u013d': '{\\v L}',
    u'\u043f': '{\\cyrp}',
    u'\u04c4': '{\\cyrkhk}',
    u'\xcc': '{\\`I}',
    u'\u044f': '{\\cyrya}',
    u'\u2422': '{\\textblank}',
    u'\u04d4': '{\\CYRAE}',
    u'\xdc': '{\\"U}',
    u'\u045f': '{\\cyrdzhe}',
    u'\xec': '{\\`i}',
    u'\u017d': '{\\v Z}',
    u'\xfc': '{\\"u}',
    u'\u040a': '{\\CYRNJE}',
    u'\u010c': '{\\v C}',
    u'\u0495': '{\\cyrghk}',
    u'\u041a': '{\\CYRK}',
    u'\u04a5': '{\\cyrng}',
    u'\u042a': '{\\CYRHRDSN}',
    u'\u2032': '{$\\prime$}',
    u'\u04b5': '{\\cyrtetse}',
    u'\u043a': '{\\cyrk}',
    u'\u04c5': '{\\CYRLDSC}',
    u'\u044a': '{\\cyrhrdsn}',
    u'\xcd': "{\\'I}",
    u'\u2052': '{\\textdiscount}',
    u'\u04d5': '{\\cyrae}',
    u'\u045a': '{\\cyrnje}',
    u'\xdd': "{\\'Y}",
    u'\u046a': '{\\CYRBYUS}',
    u'\xed': "{\\'\\i}",
    u'\u25ef': '{\\textbigcircle}',
    u'\xfd': "{\\'y}",
    u'\u017c': '{\\.z}',
    u'\u0405': '{\\CYRDZE}',
    u'\u0107': "{\\'c}",
    u'\u0415': '{\\CYRE}',
    u'\u2117': '{\\textcircledP}',
    u'\u049a': '{\\CYRKDSC}',
    u'\u0425': '{\\CYRH}',
    u'\u2127': '{\\textmho}',
    u'\u04aa': '{\\CYRSDSC}',
    u'\xb2': '{\\texttwosuperior}',
    u'\u0435': '{\\cyre}',
    u'\u04ba': '{\\CYRSHHA}',
    u'\u203d': '{\\textinterrobang}',
    u'\xc2': '{\\^A}',
    u'\u0445': '{\\cyrh}',
    u'\u0147': '{\\v N}',
    u'\u02c6': '{\\textasciicircum}',
    u'\xd2': '{\\`O}',
    u'\u0455': '{\\cyrdze}',
    u'\u2261': '{$\\equiv$}',
    u'\xe2': '{\\^a}',
    u'\xf2': '{\\`o}',
    u'\u0475': '{\\cyrizh}',
    u'\u010e': '{\\v D}',
    u'\u0410': '{\\CYRA}',
    u'\u2018': '{\\textquoteleft}',
    u'\u049b': '{\\cyrkdsc}',
    u'\u011e': '{\\u G}',
    u'\u0420': '{\\CYRR}',
    u'\u04ab': '{\\cyrsdsc}',
    u'\u232a': '{\\textrangle}',
    u'\u212e': '{\\textestimated}',
    u'\u0430': '{\\cyra}',
    u'\xb3': '{\\textthreesuperior}',
    u'\u04bb': '{\\cyrshha}',
    u'\u013e': '{\\v l}',
    u'\u0440': '{\\cyrr}',
    u'\xc3': '{\\~A}',
    u'\u04cb': '{\\CYRCHLDSC}',
    u'\xd3': "{\\'O}",
    u'\u015e': '{\\c S}',
    u'\xe3': '{\\~a}',
    u'\u016e': '{\\r U}',
    u'\xf3': "{\\'o}",
    u'\u017e': '{\\v z}',
    u'\u040b': '{\\CYRTSHE}',
    u'\u0490': '{\\CYRGUP}',
    u'\u0119': '{\\k e}',
    u'\u041b': '{\\CYRL}',
    u'\u04a0': '{\\CYRKBEAK}',
    u'\u042b': '{\\CYRERY}',
    u'\u04b0': '{\\CYRYHCRS}',
    u'\u0e37': '{\\textbaht}',
    u'\u0139': "{\\'L}",
    u'\xb8': '{\\c\\ }',
    u'\u043b': '{\\cyrl}',
    u'\u04c0': '{\\CYRpalochka}',
    u'\xc8': '{\\`E}',
    u'\u044b': '{\\cyrery}',
    u'\u0159': '{\\v r}',
    u'\u045b': '{\\cyrtshe}',
    u'\u04e0': '{\\CYRABHDZE}',
    u'\u25e6': '{\\textopenbullet}',
    u'\xe8': '{\\`e}',
    u'\u046b': '{\\cyrbyus}',
    u'\u0179': "{\\'Z}",
    u'\u0406': '{\\CYRII}',
    u'\u0491': '{\\cyrgup}',
    u'\u2193': '{\\textdownarrow}',
    u'\u2192': '{\\textrightarrow}',
    u'\u0416': '{\\CYRZH}',
    u'\u0118': '{\\k E}',
    u'\u201e': '{\\quotedblbase}',
    u'\u04a1': '{\\cyrkbeak}',
    u'\u0426': '{\\CYRC}',
    u'\u04b1': '{\\cyryhcrs}',
    u'\u0436': '{\\cyrzh}',
    u'\xb9': '{\\textonesuperior}',
    u'\u0446': '{\\cyrc}',
    u'\xc9': "{\\'E}",
    u'\u0148': '{\\v n}',
    u'\u204e': '{\\textasteriskcentered}',
    u'\u0456': '{\\cyrii}',
    u'\xd9': '{\\`U}',
    u'\u0158': '{\\v R}',
    u'\u04e1': '{\\cyrabhdze}',
    u'\xe9': "{\\'e}",
    u'\xf9': '{\\`u}',
    u'\u0178': '{\\"Y}',
    u'\u0401': '{\\CYRYO}',
    u'\u0103': '{\\u a}',
    u'\u0411': '{\\CYRB}',
    u'\u0496': '{\\CYRZHDSC}',
    u'\u2019': '{\\textquoteright}',
    u'\u0421': '{\\CYRS}',
    u'\u04a6': '{\\CYRPHK}',
    u'\u0431': '{\\cyrb}',
    u'\u04b6': '{\\CYRCHRDSC}',
    u'\u0441': '{\\cyrs}',
    u'\u0143': "{\\'N}",
    u'\u04c6': '{\\cyrldsc}',
    u'\u02ca': '{\\textasciitilde}',
    u'\xce': '{\\^I}',
    u'\u0451': '{\\cyryo}',
    u'\u0163': '{\\c t}',
    u'\xee': '{\\^\\i}',
    u'\u0497': '{\\cyrzhdsc}',
    u'\u011a': '{\\v E}',
    u'\u041c': '{\\CYRM}',
    u'\u04a7': '{\\cyrphk}',
    u'\u042c': '{\\CYRSFTSN}',
    u'\u04b7': '{\\cyrchrdsc}',
    u'\u013a': "{\\'l}",
    u'\u043c': '{\\cyrm}',
    u'\u2044': '{\\textfractionsolidus}',
    u'\u04c7': '{\\CYRNHK}',
    u'\u044c': '{\\cyrsftsn}',
    u'\xcf': '{\\"I}',
    u'\u015a': "{\\'S}",
    u'\xef': '{\\"\\i}',
    u'\u017a': "{\\'z}",
    u'\xff': '{\\"y}',
    u'\u0105': '{\\k a}',
    u'\u0407': '{\\CYRYI}',
    u'\u048c': '{\\CYRSEMISFTSN}',
    u'\u0417': '{\\CYRZ}',
    u'\u049c': '{\\CYRKVCRS}',
    u'\u0427': '{\\CYRCH}',
    u'\u2329': '{\\textlangle}',
    u'\u04ac': '{\\CYRTDSC}',
    u'\u0437': '{\\cyrz}',
    u'\u04bc': '{\\CYRABHCH}',
    u'\u20a1': '{\\textcolonmonetary}',
    u'\xc4': '{\\"A}',
    u'\u0447': '{\\cyrch}',
    u'\u04cc': '{\\cyrchldsc}',
    u'\u0155': "{\\'r}",
    u'\xd4': '{\\^O}',
    u'\u0457': '{\\cyryi}',
    u'\u0165': '{\\v t}',
    u'\xe4': '{\\"a}',
    u'\u20a9': '{\\textwon}',
    u'\xf4': '{\\^o}',
    u'\u0402': '{\\CYRDJE}',
    u'\u0104': '{\\k A}',
    u'\u048d': '{\\cyrsemisftsn}',
    u'\u0412': '{\\CYRV}',
    u'\u201a': '{\\quotesinglbase}',
    u'\u049d': '{\\cyrkvcrs}',
    u'\u20b1': '{\\textpeso}',
    u'\u0422': '{\\CYRT}',
    u'\u04ad': '{\\cyrtdsc}',
    u'\u0432': '{\\cyrv}',
    u'\xb5': '{\\textmu}',
    u'\u04bd': '{\\cyrabhch}',
    u'\u0442': '{\\cyrt}',
    u'\xc5': '{\\r A}',
    u'\u0144': "{\\'n}",
    u'\u04cd': '{\\CYRMDSC}',
    u'\u0452': '{\\cyrdje}',
    u'\xd5': '{\\~O}',
    u'\u0154': "{\\'R}",
    u'\u0462': '{\\CYRYAT}',
    u'\xe5': '{\\r a}',
    u'\u0164': '{\\v T}',
    u'\u0472': '{\\CYRFITA}',
    u'\xf5': '{\\~o}',
    u'\u010f': '{\\v d}',
    u'\u0492': '{\\CYRGHCRS}',
    u'\u041d': '{\\CYRN}',
    u'\u011f': '{\\u g}',
    u'\u04a2': '{\\CYRNDSC}',
    u'\u042d': '{\\CYREREV}',
    u'\u04b2': '{\\CYRHDSC}',
    u'\u043d': '{\\cyrn}',
    u'\xca': '{\\^E}',
    u'\u044d': '{\\cyrerev}',
    u'\xda': "{\\'U}",
    u'\u015f': '{\\c s}',
    u'\u20a4': '{\\textlira}',
    u'\xea': '{\\^e}',
    u'\u016f': '{\\r u}',
    u'\xfa': "{\\'u}"

    # Items to add at a latter date (check first)
    # u'\u0000': r'{$\alpha$}',
    # u'\u0000': r'{$\beta$}',
    # u'\u0000': r'{$\gamma$}',
    # u'\u0000': r'{$\delta$}',
    # u'\u0000': r'{$\epsilon$}',
    # u'\u0000': r'{$\varepsilon$}',
    # u'\u0000': r'{$\zeta$}',
    # u'\u0000': r'{$\eta$}',
    # u'\u0000': r'{$\theta$}',
    # u'\u0000': r'{$\vartheta$}',
    # u'\u0000': r'{$\iota$}',
    # u'\u0000': r'{$\kappa$}',
    # u'\u0000': r'{$\lambda$}',
    # u'\u0000': r'{$\mu$}',
    # u'\u0000': r'{$\xi$}',
    # u'\u0000': r'{$\pi$}',
    # u'\u0000': r'{$\varpi$}',
    # u'\u0000': r'{$\rho$}',
    # u'\u0000': r'{$\varrho$}',
    # u'\u0000': r'{$\sigma$}',
    # u'\u0000': r'{$\varsigma$}',
    # u'\u0000': r'{$\tau$}',
    # u'\u0000': r'{$\upsilon$}',
    # u'\u0000': r'{$\phi$}',
    # u'\u0000': r'{$\varphi$}',
    # u'\u0000': r'{$\psi$}',
    # u'\u0000': r'{$\omega$}',
    # u'\u0000': r'{$\Gamma$}',
    # u'\u0000': r'{$\Delta$}',
    # u'\u0000': r'{$\Theta$}',
    # u'\u0000': r'{$\Lambda$}',
    # u'\u0000': r'{$\Xi$}',
    # u'\u0000': r'{$\Pi$}',
    # u'\u0000': r'{$\Sigma$}',
    # u'\u0000': r'{$\Upsilon$}',
    # u'\u0000': r'{$\Phi$}',
    # u'\u0000': r'{$\Psi$}',
    # u'\u0000': r'{$\Omega$}',
    }

entity_mapping = {
                '&mdash;':'{---}',
                '&ndash;':'{--}',
                '"':'{"}',
                }


class BibTeX:

    def __init__(self):
        self.rep_utf8 = MReplace(utf8enc2latex_mapping)
        self.rep_ent = MReplace(entity_mapping)
        # Set default conversion to ASCII BibTeX
        self.ascii_bibtex = True
        # This substitution is based on the description of cite key restrictions at
        # http://bibdesk.sourceforge.net/manual/BibDesk%20Help_2.html
        self.invalid_cit = re.compile(u'[ "@\',\\#}{~%&$^]')
        self.upper = re.compile(u'[' +
            string.ascii_uppercase + u']')
        self.escape = re.compile(u'[~#&%_]')

    def ValidateCitationKey(self, text):
        """
        Removes characters not allowed in BibTeX keys
        """
        return self.invalid_cit.sub(u'', text)

    def braceUppercase(self, text):
        """
        Convert uppercase letters to bibtex encoded uppercase
        """
        return self.upper.sub(lambda m: u'{%s}' % m.group(), text)

    def resolveEntities(self, text):
        return self.rep_ent.mreplace(text)

    def resolveUnicode(self, text):
        # UTF-8 text as entry
        text = self.rep_utf8.mreplace(text)
        return text.replace(u'$}{$', u'')

    def escapeSpecialCharacters(self, text):
        """
        Latex escaping some (not all) special characters
        """
        text.replace('\\', '\\\\')
        return self.escape.sub(lambda m: u'\\%s' % m.group(), text)

    # Calibre functions: Option to go to official ASCII Bibtex or unofficial UTF-8
    def utf8ToBibtex(self, text):
        """
        Go from an unicode entry to ASCII Bibtex format without encoding
        """
        if len(text) == 0:
            return ''
        text.replace('\\', '\\\\')
        text = self.resolveEntities(text)
        if self.ascii_bibtex :
            text = self.resolveUnicode(text)
        return self.escapeSpecialCharacters(text)

    def bibtex_author_format(self, item):
        """
        Format authors for Bibtex compliance (get a list as input)
        """
        return self.utf8ToBibtex(u' and '.join([author for author in item]))

    def stripUnmatchedSyntax(self, text, open_character, close_character):
        """
        Strips unmatched BibTeX syntax
        """
        stack = []
        assert len(open_character) == 1 and len(close_character) == 1
        remove = []
        for i, ch in enumerate(text):
            if ch == open_character:
                stack.append(i)
            elif ch == close_character:
                try:
                    stack.pop()
                except IndexError:
                    # Remove unmatched closing char
                    remove.append(i)
        # Remove unmatched opening chars
        remove.extend(stack)

        if remove:
            text = list(text)
            for i in sorted(remove, reverse=True):
                text.pop(i)
            text = ''.join(text)
        return text
