*-----------------------------------------------------------------------
*     TMSTLA : THE ROUTINE FOR DRAWING STREAM LINES (COORD. OF ANNULAR)
*-----------------------------------------------------------------------
*     COPYRIGHT (C) 2000-2017 GFD DENNOU CLUB. ALL RIGHTS RESERVED.
*-----------------------------------------------------------------------
      SUBROUTINE TMZTLA( R, T, U, V, NX, NY,TRX,TRY,NM,X,Y,TMPU,TMPV )

      IMPLICIT NONE

*-- AGREENMENT
      INTEGER  NX        !* GRID NUMBERS FOR X-DIRECTION
      INTEGER  NY        !* GRID NUMBERS FOR Y-DIRECTION
      REAL     U(NX,NY)  !* VECTOR COMPONENT OF X-DIRECTION
      REAL     V(NX,NY)  !* VECTOR COMPONENT OF Y-DIRECTION
      REAL     R(NX)     !* GRID POINTS OF RADIAL DIR. [UNIT:LENGTH]
      REAL     T(NY)     !* GRID POINTS OF TANGENT DIR. [UNIT:DEGREE]

*-- INTERNAL VARIABLES
      REAL     TRX(2,NX*NY,*)  !* STREAM LINE OF X-COORDINATE
      REAL     TRY(2,NX*NY,*)  !* STREAM LINE OF Y-COORDINATE
      INTEGER  I, J, K             !* TMP VALUES
      INTEGER  COUNTER             !* NUMBER OF STREAM LINE
      INTEGER  NM(2,*)         !* ARRAY NUMBER IN EACH STREAM LINE
      REAL     X(*), Y(*)
      REAL     TMPU(NX,*), TMPV(NX,*)
      REAL     ARROW_THRES
      REAL     DXA, DYA
      REAL     ARROW_LENG
      REAL     VXMIN, VXMAX, VYMIN, VYMAX
      REAL     UXMIN, UXMAX, UYMIN, UYMAX
      REAL     VRRATIO
      REAL     RCOE
      REAL     CIRC_FLAG
      REAL     UNDEF
      INTEGER  N, M, IBLKGE, ARRCNT
      LOGICAL  NO_SHORT, END_ARR

*-- EXTERNAL FUNCTION
      REAL     RFPI
      EXTERNAL RFPI

      RCOE=RFPI()/180.0

*-- GETTING TMPACK'S PARAMETERS
      CALL TMRGET( 'ARRWINTV', ARROW_THRES )
      CALL TMLGET( 'NODRSHRT', NO_SHORT )

      CALL GLRGET( 'RMISS', UNDEF )
      CALL GLLSET( 'LMISS', .TRUE. )

*-- GETTING VIEWPORT PARAMETERS
      CALL SGQVPT( VXMIN, VXMAX, VYMIN, VYMAX)
      CALL SGQWND( UXMIN, UXMAX, UYMIN, UYMAX)
      VRRATIO=(VXMAX-VXMIN)/(UXMAX-UXMIN)

*-- CONVERTING DEGREE TO RADIAN
      DO 11 I=1,NX
         X(I)=R(I)
 11   CONTINUE
      DO 12 J=1,NY
         Y(J)=T(J)*RCOE
 12   CONTINUE

*-- CONVERTING VECTORS TO THEMSELVES INCLUDING SCALE PARAMETER
      DO 20 J=1,NY
         DO 21 I=1,NX
            IF(U(I,J).NE.UNDEF.AND.V(I,J).NE.UNDEF
     &         .AND.R(I).NE.0.0)THEN
               TMPU(I,J)=U(I,J)
               TMPV(I,J)=V(I,J)/R(I)
            ELSE
               TMPU(I,J)=UNDEF
               TMPV(I,J)=UNDEF
            END IF
 21      CONTINUE
 20   CONTINUE

      DO 71 K=1,2
         DO 70 I=1,NX*NY
            NM(K,I)=0
 70      CONTINUE
 71   CONTINUE

*-- DOING TMSTLN ROUTINE
      CALL TMSTLN( X, Y, TMPU, TMPV, NX, NY, TRX, TRY, NM )

*-- GETTING STREAM LINE NUMBERS
      CALL TMIGET( 'STLNNUM', COUNTER )

*-- CONVERTING TRY(RADIAN) TO TRY(DEGREE)
      DO 32 K=1,2
         DO 30 I=1,COUNTER
            DO 31 J=1,NM(K,I)
               IF(TRX(K,J,I).NE.UNDEF.AND.TRY(K,J,I).NE.UNDEF)THEN
                  TRY(K,J,I)=TRY(K,J,I)/RCOE
               END IF
 31         CONTINUE
 30      CONTINUE
 32   CONTINUE

*-- SETTING PARAMETER FOR ARROW. (NOW, CONSTANT VALUES)
      CALL SGLSET('LPROP',.FALSE.)
      CALL SGRSET('CONST',0.01)

*-- DRAWING STREAM LINES
      DO 82 K=1,2
         DO 81 I=1,COUNTER

*-- CALCULATING THE INTERVAL LENGTH OF DRAWING ARROWS.
            ARROW_LENG=0.0
            ARRCNT=0
            IF((NM(K,I).GT.1).AND.(NM(K,I).LE.NX*NY))THEN
               DO 80 J=2,NM(K,I)
                  IF(TRX(K,J,I).NE.UNDEF.AND.TRY(K,J,I).NE.UNDEF.AND.
     &               TRX(K,J-1,I).NE.UNDEF.AND.TRY(K,J-1,I).NE.UNDEF
     &               )THEN
                     DXA=(TRX(K,J,I)-TRX(K,J-1,I))*VRRATIO
                     DYA=(TRY(K,J,I)-TRY(K,J-1,I))*VRRATIO
     &                                            *TRX(K,J,I)*RCOE
                     ARROW_LENG=ARROW_LENG+SQRT(DXA*DXA+DYA*DYA)
                     IF(ARROW_LENG.GE.ARROW_THRES)THEN
                        CALL SGLAU( TRX(K,J-1,I), TRY(K,J-1,I),
     &                              TRX(K,J,I), TRY(K,J,I) )
                        ARROW_LENG=0.0
                        ARRCNT=ARRCNT+1
                     END IF
                  END IF
 80            CONTINUE

*-- IF NO_SHORT IS TRUE, NO DRAWING STREAM LINE WHOSE ARROW NUMBER IS ZERO
*-- ήλȽˤ, ĤήȤߤʤ.
*-- 𱩤Ͻ.
               IF(ARRCNT.EQ.0)THEN
                  IF(NO_SHORT.EQV..TRUE.)THEN
                     IF(NM(K,I).LE.2)THEN
                        GO TO 81
                     ELSE
                        N=IBLKGE( R, NX, TRX(K,1,I) )
                        M=IBLKGE( R, NX, TRX(K,NM(K,I),I) )
                        IF(ABS(N-M).GT.1)THEN
                           GO TO 81
                        ELSE
*-- ƤΤ, ûʤΤΥå
*--  , , νƤа.
                           CIRC_FLAG=
     &                         (TRX(K,NM(K,I),I)-TRX(K,NM(K,I)-1,I))
     &                         *(TRX(K,1,I)-TRX(K,NM(K,I),I))
                           IF(CIRC_FLAG.LT.0.0)THEN  ! ñû
                              GO TO 81
                           ELSE
                              N=IBLKGE( T, NY, TRY(K,1,I) )
                              M=IBLKGE( T, NY, TRY(K,NM(K,I),I) )
                              IF(ABS(N-M).GT.1)THEN
                                 GO TO 81
                              ELSE
                                 CIRC_FLAG=
     &                             (TRY(K,NM(K,I),I)-TRY(K,NM(K,I)-1,I))
     &                             *(TRY(K,1,I)-TRY(K,NM(K,I),I))
                                 IF(CIRC_FLAG.LT.0.0)THEN
                                    GO TO 81
!                                 ELSE
!                                 CALL SGLAU( TRX(I,NM(I)-1,I), TRY(NM(I)-1),
!     &                                       TRX(I,NM(I),I), TRY(NM(I)) )
                                 END IF
                              END IF
                           END IF
                        END IF
                     END IF
                  ELSE
                     IF(END_ARR.EQV..TRUE.)THEN
                        CALL SGLAU( TRX(K,NM(K,I)-1,I),
     &                              TRY(K,NM(K,I)-1,I),
     &                              TRX(K,NM(K,I),I),
     &                              TRY(K,NM(K,I),I) )
                     END IF
                  END IF
               END IF

               CALL UULIN( NM(K,I), TRX(K,1:NM(K,I),I),
     &                     TRY(K,1:NM(K,I),I) )

            END IF

 81      CONTINUE

 82   CONTINUE

      CALL MSGDMP( 'M', 'TMSTLA', 'DRAWING FINISHED.' )

      END SUBROUTINE TMZTLA

