// SPDX-FileCopyrightText: 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef CONNECTIVITYCHECKER_H
#define CONNECTIVITYCHECKER_H

#include <QObject>

namespace Dtk {
namespace Core {
class DConfig;
}
}

namespace dde {

namespace network {

class ConnectivityChecker : public QObject
{
    Q_OBJECT

public:
    explicit ConnectivityChecker(QObject *parent = nullptr);

Q_SIGNALS:
    void checkFinished(bool connectivity) const;
    void runFinished();

public Q_SLOTS:
    void startCheck();

private:
    void updateUrls(const QStringList &urls);

private Q_SLOTS:
    void onConfigChanged(const QString &key);

private:
    QStringList m_checkUrls;
    Dtk::Core::DConfig *m_dConfig;
    bool m_isRunning;
};

}   // namespace network

}   // namespace dde

#endif // CONNECTIVITYCHECKER_H
