// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef NETWORKHELPER_H
#define NETWORKHELPER_H

#include <QObject>
#include <QJsonObject>

#include <NetworkManagerQt/WirelessDevice>

namespace dde {
namespace network {

class NetworkHelper : public QObject
{
    Q_OBJECT

public:
    explicit NetworkHelper(QObject *parent = nullptr);
    ~NetworkHelper();

    QJsonObject accessPointJson() const;

signals:
    void accessPointChanged(const QJsonObject &);

private:
    QJsonObject makeJsonObject(const NetworkManager::AccessPoint::Ptr &accessPoint);

private slots:
    void onAccessPointAppeared(const QString &uni);
    void onAccessPointDisappeared(const QString &uni);

private:
    QJsonObject m_json;
};

}
}

#endif // NETWORKHELPER_H
