#include "shared_memory_image.h"
#include <QSharedData>
#include <QPaintDevice>
#include <QPainter>
#include <QSharedMemory>

Shared_Memory_Image::Shared_Memory_Image(QWidget *parent) : QWidget(parent)
{

}

void Shared_Memory_Image::slot_update_image(const QString &share_key)
{
    this->share_key = share_key;
    repaint();
}

void Shared_Memory_Image::paintEvent(QPaintEvent *)
{
    QPainter painter(this);
    QSharedMemory memory(share_key);
    if (memory.attach()) {
        QImage image;
        image.loadFromData((const unsigned char *)memory.data(), memory.size());
        painter.drawImage(QRect(0, 0, width(), height()), image);
        memory.detach();
    } else {
        painter.setPen(QPen(Qt::red));
        painter.setBrush(QBrush(QColor(Qt::red), Qt::SolidPattern));
        painter.drawText(geometry(), QStringLiteral("没有图片"), QTextOption(Qt::AlignCenter | Qt::AlignHCenter));
    }
}
