#ifndef xcontrol_attribute_h_
#define xcontrol_attribute_h_ 1

#include <stdexcept>
#include <memory>

template<typename To_, typename From_>
To_ attribute_cast(From_ const &rhs)
{
	return static_cast<To_>(rhs);
}

template<typename Visible_>
class attribute
{
public:
	typedef Visible_ visible_type;

private:
	class attribute_impl_base
	{
	public:
		virtual ~attribute_impl_base(void) throw();
		virtual void set(visible_type const &) = 0;
		virtual visible_type get(void) = 0;
	};

	template<typename Member_>
	class member_traits;

	template<typename Containing_, typename Contained_>
	class member_traits<Contained_ Containing_::*>
	{
	public:
		typedef Containing_ containing_type;
		typedef Contained_ contained_type;
	};

	template<typename Member_>
	class member_attribute_impl :
		public attribute_impl_base
	{
	public:
		typedef Member_ member_type;
		typedef typename member_traits<member_type>::containing_type container_type;
		typedef typename member_traits<member_type>::contained_type value_type;

		member_attribute_impl(member_type member, container_type &container) :
			container(container),
			member(member)
		{
			return;
		}
		virtual ~member_attribute_impl(void) throw() { }
		virtual void set(visible_type const &v) { (container.*member) = attribute_cast<value_type>(v); }
		virtual visible_type get(void) { return attribute_cast<visible_type>(container.*member); }
	
	private:
		container_type &container;
		member_type member;
	};

	struct attribute_ref
	{
		explicit attribute_ref(attribute_impl_base *p) : p(p) { }

		attribute_impl_base *p;
	};

public:
	template<typename Member_>
	attribute(Member_ member, typename member_traits<Member_>::containing_type &container) :
		impl(new member_attribute_impl<Member_>(member, container))
	{
		return;
	}

	attribute(attribute_ref ref) : impl(ref.p) { }
	operator attribute_ref(void) { return attribute_ref(impl.release()); }

	attribute &operator=(visible_type const &value)
	{
		impl->set(value);
		return *this;
	}

	class unknown_attribute :
		public std::logic_error
	{
	public:
		unknown_attribute(std::string const &);
	};

private:
	std::auto_ptr<attribute_impl_base> impl;
};

template<typename Visible_>
attribute<Visible_>::attribute_impl_base::~attribute_impl_base(void) throw()
{
	return;
}

template<typename Visible_>
attribute<Visible_>::unknown_attribute::unknown_attribute(std::string const &attr) :
	std::logic_error(std::string("unknown attribute ") + attr)
{
	return;
}
#endif
