/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>
#include "glue.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-control-knob.h"
#include "sig_integer.h"
#include "sig_manage.h"
#include "sig_std_logic.h"

typedef struct {
	GtkVBoxClass parent_class;

} GuiGtkControlKnobClass;

enum{
	VALUE_CHANGED_GUI,
	GUI_GTK_CONTROL_KNOB_LAST_SIGNAL
};

static guint gui_gtk_control_knob_signals[GUI_GTK_CONTROL_KNOB_LAST_SIGNAL] = { 0 };

static void
gui_gtk_control_knob_class_init(GuiGtkControlKnobClass *class)
{	
    gui_gtk_control_knob_signals[VALUE_CHANGED_GUI] =
	g_signal_new("value-changed-gui",
		     G_TYPE_FROM_CLASS(class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
		     0, NULL, NULL,
		     g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);

}

static void
on_selection_changed(GtkComboBox *widget, void *_control_knob)
{
	GuiGtkControlKnob *control_knob = _control_knob;
	g_signal_emit(G_OBJECT(control_knob),
			gui_gtk_control_knob_signals[VALUE_CHANGED_GUI], 0);
}

static void
gui_gtk_control_knob_init(GuiGtkControlKnob *control_knob)
{
}

GType
gui_gtk_control_knob_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkControlKnobClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			(GClassInitFunc) gui_gtk_control_knob_class_init,
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof(GuiGtkControlKnob),
			0,	/* n_preallocs */
			(GInstanceInitFunc) gui_gtk_control_knob_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_HBOX,
				"ControlKnob", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKCONTROLKNOB_TYPE gui_gtk_control_knob_get_type()

GtkWidget *
gui_gtk_control_knob_new(const char *desc, int number_entries, const char **entries)
{
	GtkWidget *vbox;
	GuiGtkControlKnob *control_knob;
	GtkComboBoxText *combo_box;	
	int i;
	
	control_knob = GUI_GTK_CONTROL_KNOB(g_object_new(GUIGTKCONTROLKNOB_TYPE, NULL));
	
	vbox = gtk_vbox_new(FALSE, 1);
	
	control_knob->label = gtk_label_new(desc);
	combo_box = GTK_COMBO_BOX_TEXT(gtk_combo_box_text_new());
	control_knob->number_items = number_entries;
	control_knob->items = (char**)malloc(number_entries * sizeof(char*));
	
	g_signal_connect (combo_box,
		    "changed",
		    G_CALLBACK (on_selection_changed),
		    control_knob);

	for(i = 0; i < number_entries; i++){
		gtk_combo_box_text_append_text(GTK_COMBO_BOX_TEXT(combo_box), entries[i]);
		
		control_knob->items[i] = strdup(entries[i]);
	}

	control_knob->combo_box =GTK_WIDGET(combo_box);	
	
	gtk_box_pack_start(GTK_BOX(vbox), control_knob->label, FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(vbox), control_knob->combo_box, FALSE, FALSE, 1);
	
	gtk_box_pack_start(GTK_BOX(control_knob), vbox, FALSE, FALSE, 1);
	gtk_widget_show(control_knob->label);
	gtk_widget_show(control_knob->combo_box);
	gtk_widget_show(vbox);
	gtk_widget_show(GTK_WIDGET(control_knob));	
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box), 0);
	on_selection_changed(NULL, control_knob); 
	return GTK_WIDGET(control_knob);
}

void
gui_gtk_control_knob_set_value(gpointer _control_knob, const char *value_string)
{
	GuiGtkControlKnob *control_knob;
	int item;

	control_knob = _control_knob;
	for (item = 0; item < control_knob->number_items ; item++) {
		if (strcmp(control_knob->items[item], value_string) == 0) {
			gtk_combo_box_set_active(GTK_COMBO_BOX(control_knob->combo_box),
					item);
			break;
		}
	}
}

void
gui_gtk_control_knob_destroy(gpointer _control_knob)
{
	GuiGtkControlKnob *knob = (GuiGtkControlKnob*) _control_knob;
	int i;

	for (i = 0; i < knob->number_items; i++) {
		free(knob->items[i]);
	}	 
}
