/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __RTC_H_INCLUDED
#define __RTC_H_INCLUDED

#include "build_config.h"
#include "compiler.h"

/* ==================== RUNTIME_RM ==================== */
#ifdef RUNTIME_RM

extern void 
rtc_tick(void);

/*
 * Get timer ticks.
 *
 * In:	AH	= 1Ah
 *	AL	= 00h
 *
 * Out:	CX:DX	= timer ticks since midnight
 *	AL	= number of midnight passes since last call
 */

/* Must be static inline, for ubcd32-sys-nssi experiment */

static ALWAYS_INLINE void
bios_1a_00xx(struct regs *regs)
{
	/* Allow some time ticks. */
	/* FIXME JOSEF: export to cpu.h */
	asm (
			"sti	\n"
			"nop			\n"
			"cli	\n"
			:
			:
	    );

	CX = var_get(ticks_high);
	DX = var_get(ticks_low);
	AL = var_get(time_24h);
	var_put(time_24h, 0);

	AH = 0;
	
	F &= ~(1 << 0);	/* Clear carry. */
}

extern void
bios_1a_01xx(struct regs *regs);
extern void
bios_1a_02xx(struct regs *regs);
extern void
bios_1a_03xx(struct regs *regs);
extern void
bios_1a_04xx(struct regs *regs);
extern void
bios_1a_05xx(struct regs *regs);
extern void
bios_1a_06xx(struct regs *regs);
extern void
bios_1a_07xx(struct regs *regs);

#endif /* RUNTIME_RM */
/* ==================== REAL-MODE INIT ==================== */
#ifdef INIT_RM

extern void
rtc_init(void);

#endif /* INIT_RM */

#endif /* __RTC_H_INCLUDED */
