/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.NoSuchElementException;
import jonelo.jacksum.JacksumAPI;
import jonelo.jacksum.algorithm.AbstractChecksum;
import jonelo.jacksum.algorithm.Edonkey;
import jonelo.jacksum.algorithm.MD;
import jonelo.jacksum.algorithm.MDgnu;
import jonelo.jacksum.algorithm.None;
import jonelo.jacksum.algorithm.Read;
import jonelo.jacksum.ui.MetaInfo;
import jonelo.jacksum.ui.MetaInfoVersionException;
import jonelo.jacksum.ui.Summary;
import jonelo.jacksum.ui.Verbose;
import jonelo.sugar.util.EncodingException;
import jonelo.sugar.util.ExitException;
import jonelo.sugar.util.GeneralString;

public class CheckFile {
    public static final String COMMENTDEFAULT = "Jacksum: Comment:";
    private String CSEP = "\t";
    private String checkFile = null;
    private MetaInfo metaInfo = null;
    private AbstractChecksum checksum = null;
    private boolean _l = false;
    private Verbose verbose = null;
    private Summary summary = null;
    private long removed = 0L;
    private long modified = 0L;
    private String workingDir = null;

    public CheckFile(String string) {
        this.checkFile = string;
    }

    public void setMetaInfo(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public void setVerbose(Verbose verbose) {
        this.verbose = verbose;
    }

    public Verbose getVerbose() {
        return this.verbose;
    }

    public void setSummary(Summary summary) {
        this.summary = summary;
        summary.setCheck(true);
    }

    public Summary getSummary() {
        return this.summary;
    }

    public void setList(boolean bl) {
        this._l = bl;
    }

    public boolean isList() {
        return this._l;
    }

    public long getModified() {
        return this.modified;
    }

    public long getRemoved() {
        return this.removed;
    }

    public void setWorkingDir(String string) {
        this.workingDir = string;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() throws FileNotFoundException, IOException, MetaInfoVersionException, ExitException {
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            int n;
            String string2;
            block39: {
                fileInputStream = new FileInputStream(this.checkFile);
                inputStreamReader = new InputStreamReader(fileInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                bufferedReader.mark(1024);
                string2 = null;
                n = 2;
                string = null;
                string2 = bufferedReader.readLine();
                if (string2 != null) {
                    if (string2.startsWith("Jacksum: Meta-Info: ") && !string2.startsWith(this.metaInfo.getCommentchars())) {
                        this.metaInfo = new MetaInfo(string2);
                    } else {
                        if (this.verbose.getWarnings()) {
                            System.err.println("Jacksum: Warning: file does not contain meta information. Please set suitable command line parameters.");
                        }
                        bufferedReader.reset();
                    }
                } else {
                    throw new ExitException("File is empty.\nExit.", 3);
                }
                try {
                    this.checksum = JacksumAPI.getChecksumInstance(this.metaInfo.getAlgorithm(), this.metaInfo.isAlternate());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new ExitException(noSuchAlgorithmException.getMessage(), 3);
                }
                if (this.checksum instanceof MD || this.checksum instanceof MDgnu || this.checksum instanceof Edonkey) {
                    --n;
                }
                if (this.checksum instanceof None || this.checksum instanceof Read) {
                    --n;
                }
                if (this.metaInfo.isSeparatorWanted()) {
                    this.CSEP = this.metaInfo.getSeparator();
                    this.checksum.setSeparator(this.CSEP);
                } else {
                    this.CSEP = this.checksum.getSeparator();
                }
                if (this.metaInfo.isTimestampFormat()) {
                    ++n;
                    this.checksum.setTimestampFormat(this.metaInfo.getTimestampFormat());
                    String[] stringArray = GeneralString.split(this.metaInfo.getTimestampFormat(), this.CSEP);
                    n += stringArray.length - 1;
                } else {
                    this.checksum.setTimestampFormat(null);
                }
                if (this.metaInfo.isGrouping()) {
                    this.checksum.setGroup(this.metaInfo.getGrouping());
                    this.checksum.setGroupChar(this.metaInfo.getGroupChar());
                } else {
                    this.checksum.setGroup(0);
                }
                if (this.metaInfo.isEncoding()) {
                    try {
                        this.checksum.setEncoding(this.metaInfo.getEncoding());
                    }
                    catch (EncodingException encodingException) {
                        if (!this.verbose.getWarnings()) break block39;
                        System.err.println("Jacksum: Warning: " + encodingException.getMessage());
                    }
                }
            }
            int n2 = 0;
            if (this.checksum.getEncoding().length() == 0 || this.checksum.getEncoding().equalsIgnoreCase("dec") || this.checksum.getEncoding().equalsIgnoreCase("oct") || this.checksum instanceof None || this.checksum instanceof Read) {
                n2 = 0;
            } else {
                n2 = this.checksum.getFormattedValue().length();
                --n;
            }
            String string3 = "";
            boolean bl = true;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith(COMMENTDEFAULT) || string2.startsWith(this.metaInfo.getCommentchars())) continue;
                if (string2.length() == 0) {
                    bl = true;
                    continue;
                }
                if (string2.startsWith("Jacksum")) {
                    if (!this.verbose.getWarnings()) continue;
                    System.err.println("Jacksum: Warning: Ignoring unknown directive.");
                    continue;
                }
                if (bl && this.metaInfo.isRecursive() && !this.metaInfo.isPathInfo() && string2.endsWith(":")) {
                    bl = false;
                    string3 = string2.substring(0, string2.length() - 1);
                    if (this.workingDir != null && this.workingDir.length() > 0) {
                        string3 = this.workingDir + this.metaInfo.getFilesep() + string3;
                    }
                    if (File.separatorChar != this.metaInfo.getFilesep()) {
                        string3 = string3.replace(this.metaInfo.getFilesep(), File.separatorChar);
                    }
                    if (!this._l) {
                        System.out.println("\n" + string3 + ":");
                    }
                    if (string3.length() <= 0) continue;
                    string3 = string3 + File.separator;
                    continue;
                }
                try {
                    string = this.parseFilename(string2, n, n2);
                    int n3 = string.length();
                    if (this.metaInfo.isPathInfo() && this.workingDir != null && this.workingDir.length() > 0) {
                        string3 = this.workingDir + this.metaInfo.getFilesep();
                        n3 += string3.length();
                    }
                    if (File.separatorChar != this.metaInfo.getFilesep()) {
                        string = string.replace(this.metaInfo.getFilesep(), File.separatorChar);
                    }
                    if (this._l) {
                        this.skipOkFiles(string3 + string, string2, n3);
                        continue;
                    }
                    System.out.print(this.whatChanged(string3 + string, string2, n3));
                    System.out.println(string);
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!this.verbose.getWarnings()) continue;
                    System.err.println("Jacksum: Warning: Invalid entry: " + string2);
                }
                catch (IOException iOException) {
                    this.summary.addErrorFile();
                    String string4 = null;
                    string4 = this.verbose.getDetails() ? string + " [" + iOException.getMessage() + "]" : string;
                    System.err.println("Jacksum: Error: " + string4);
                }
            }
        }
        finally {
            this.summary.setRemovedFiles(this.removed);
            this.summary.setModifiedFiles(this.modified);
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void skipOkFiles(String string, String string2, int n) throws IOException {
        boolean bl = false;
        if (!new File(string).exists()) {
            ++this.removed;
            bl = true;
        } else {
            String string3 = this.getChecksumOutput(string);
            if (!string3.regionMatches(0, string2, 0, string3.length() - n)) {
                bl = true;
                ++this.modified;
            }
        }
        if (bl) {
            System.out.println(string);
        }
        this.summary.addFile();
    }

    private String whatChanged(String string, String string2, int n) throws IOException {
        if (!new File(string).exists()) {
            ++this.removed;
            this.summary.addFile();
            return "[REMOVED] ";
        }
        String string3 = this.getChecksumOutput(string);
        if (!string3.regionMatches(0, string2, 0, string3.length() - n)) {
            ++this.modified;
            this.summary.addFile();
            return "[FAILED]  ";
        }
        this.summary.addFile();
        return "[OK]      ";
    }

    private String parseFilename(String string, int n, int n2) throws NoSuchElementException {
        if (n2 > 0) {
            string = string.substring(n2 + this.CSEP.length());
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = GeneralString.split(string, this.CSEP);
        stringBuffer.append(stringArray[n]);
        for (int i = n + 1; i < stringArray.length; ++i) {
            stringBuffer.append(this.CSEP);
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private String getChecksumOutput(String string) throws IOException {
        this.summary.addBytes(this.checksum.readFile(string, true));
        File file = new File(string);
        if (this.metaInfo.isRecursive() && !this.metaInfo.isPathInfo()) {
            this.checksum.setFilename(file.getName());
        } else {
            this.checksum.setFilename(string);
        }
        return this.checksum.toString();
    }
}

