/*
 * jaZip for Linux  (c) 1996  Jarrod A. Smith
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#include <mntent.h>
#include <forms.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/genhd.h>
#include <linux/fs.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "jazip.h"

#define MAXIMUM_PARTS   60
#define SECTOR_SIZE  512
#define offset(b, n) ((struct partition *)((b) + 0x1be + \
		(n) * sizeof(struct partition)))

char  buffer[SECTOR_SIZE];    /* first four partitions */
char  *buffers[MAXIMUM_PARTS] = {buffer, buffer, buffer, buffer};
uint offsets[MAXIMUM_PARTS] = {0, 0, 0, 0};

/* partitions */
struct   partition *part_table[MAXIMUM_PARTS] = {offset(buffer, 0), offset(buffer, 1),
	offset(buffer, 2), offset(buffer, 3)};

struct systypes {
	unsigned char index;
	char *name;
	char *fstype;
	} sys_types[] = {
		{0, "Empty", "unknown"},
		{1, "DOS 12-bit FAT", "msdos"},
		{4, "DOS 16-bit <32M", "vfat"},
		{5, "Extended", "unknown"},
		{6, "DOS 16-bit >=32M", "vfat"},
		{0xb, "Win95 FAT32", "fat32"},
		{0x81, "Linux/MINIX", "ext"},
		{0x82, "Linux swap", "swap"},
		{0x83, "Linux native", "ext2"},
  };

char *partition_type(unsigned char type)
{
	int high = sizeof(sys_types) / sizeof(struct systypes),
		low = 0, mid;
	uint tmp;

	while (high >= low) {
		mid = (high + low) >> 1;
		if ((tmp = sys_types[mid].index) == type)
			return sys_types[mid].fstype;
		else if (tmp < type)
			low = mid + 1;
		else high = mid - 1;
	}
	return NULL;
}

int z_mount( char *dev )
{
	FILE		*jazipconf, *mtab;
	struct	mntent	*mp;
	struct	stat		s;
	struct	statfs	fs;
	struct	partition *p;
	int		mntopt=0, tmp, i;
	int		fd, partitions = 4;
	char		*type, perm_stat[32], pname[10];

	if (is_mounted( dev )) {
		sprintf (mesg, "%s is already mounted as %s on %s.", mnt_fsname, mnt_type, mnt_dir);
		return (0);
	}

/*Read the partition table from the disk and find a filesystem to mount*/

	seteuid(0);

	if ((fd = open (dev, O_RDONLY)) < 0){
		sprintf (mesg, "Couldn't open %s.  Is there a disk in the drive?", dev);
		seteuid(getuid());
		return (0);
	}

	if (SECTOR_SIZE != read(fd, buffer, SECTOR_SIZE)){
		sprintf (mesg, "Error reading the partition table.");
		close (fd);
		seteuid(getuid());
		return (0);
	} else close (fd);

	seteuid(getuid());

/* Get the correct line from IOMEGA_FSTAB */
	if (!(jazipconf = setmntent (IOMEGA_FSTAB, "r"))) {
		sprintf (mesg, "Unable to read %s: %s.", dev, strerror (errno));
		return (0);
	}
	for(i=1; i<=conf; i++) mp = getmntent (jazipconf);
	endmntent (jazipconf);

/* Get the first partition only */
	for (i=0; i<partitions; i++)
		if ((p = part_table[i])->sys_ind)
			break;
	sprintf( mp->mnt_fsname, "%7s%-1d", dev, i+1 );
	mp->mnt_type = partition_type( p->sys_ind );
	strcpy( mp->mnt_opts, "defaults");
	mp->mnt_freq = 0;
	mp->mnt_passno = 0;

/* Check to make sure the mount point exists. */
	if (tmp=stat (mp->mnt_dir, &s)) {
		sprintf (mesg, "Couldn't find mount point %s specified in %s.",
			mp->mnt_dir, IOMEGA_FSTAB);
		return( 0 );
	}

	if (dostatus (dev) != 0) {
		strcpy (perm_stat, "write-protected ");
		mntopt=MS_NOSUID|MS_RDONLY;
	} else {
		strcpy (perm_stat, "");
		mntopt=MS_NOSUID&~MS_RDONLY;
	}

	if (!lock_mtab()) {
		sprintf (mesg, "Unable to create lock-file.  Mount denied.");
		return (0);
	}

	seteuid(0);
  	if (!mount (mp->mnt_fsname,mp->mnt_dir,mp->mnt_type,0xc0ed0000|mntopt,"" )) {
  		sprintf (mesg, "Mounted %s%s disk on %s", perm_stat, mp->mnt_type, mp->mnt_dir);
		if (!(mtab = setmntent(MOUNTED, "a"))) {
			printf ("ERROR! Couldn't write entry to %s.", MOUNTED);
			endmntent (mtab);
			unlink (LOCK_FILE);
			exit (-1);
		} else {
			addmntent (mtab, mp);
			endmntent (mtab);
			unlink (LOCK_FILE);
			seteuid(getuid());
			return (1);
		}
	} else {
			sprintf (mesg, "Error trying to mount %s : %s", dev, strerror (errno));
			unlink (LOCK_FILE);
			seteuid(getuid());
			return (0);
	}
	seteuid(getuid());
}

int lock_mtab()
{
	int fd;

	seteuid(0);
	if ((fd = open (LOCK_FILE, O_WRONLY | O_CREAT | O_EXCL, 0744)) < 0){
		seteuid(getuid());
 		return 0;
	}else{
		close (fd);
		seteuid(getuid());
		return (1);
	}
}
