/* ==================================================================== 
 * The Kannel Software License, Version 1.0 
 * 
 * Copyright (c) 2001-2018 Kannel Group  
 * Copyright (c) 1998-2001 WapIT Ltd.   
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 * 
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in 
 *    the documentation and/or other materials provided with the 
 *    distribution. 
 * 
 * 3. The end-user documentation included with the redistribution, 
 *    if any, must include the following acknowledgment: 
 *       "This product includes software developed by the 
 *        Kannel Group (http://www.kannel.org/)." 
 *    Alternately, this acknowledgment may appear in the software itself, 
 *    if and wherever such third-party acknowledgments normally appear. 
 * 
 * 4. The names "Kannel" and "Kannel Group" must not be used to 
 *    endorse or promote products derived from this software without 
 *    prior written permission. For written permission, please  
 *    contact org@kannel.org. 
 * 
 * 5. Products derived from this software may not be called "Kannel", 
 *    nor may "Kannel" appear in their name, without prior written 
 *    permission of the Kannel Group. 
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED.  IN NO EVENT SHALL THE KANNEL GROUP OR ITS CONTRIBUTORS 
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,  
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT  
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR  
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,  
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE  
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,  
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 * ==================================================================== 
 * 
 * This software consists of voluntary contributions made by many 
 * individuals on behalf of the Kannel Group.  For more information on  
 * the Kannel Group, please see <http://www.kannel.org/>. 
 * 
 * Portions of this software are based upon software originally written at  
 * WapIT Ltd., Helsinki, Finland for the Kannel project.  
 */ 

/*
 * test_hash.c - test MD5 and SHA1 routines.
 *
 * Stipe Tolj <stolj at kannel dot org>
 */

#include <string.h>
#include <unistd.h>
#include <signal.h>

#include "gwlib/gwlib.h"

#ifdef HAVE_LIBSSL
#if OPENSSL_VERSION_NUMBER < 0x10100000L
static Octstr *our_hash_func(Octstr *os)
{
    /* use openssl's SHA1 */
    EVP_MD_CTX mdctx;
    const EVP_MD *md;
    unsigned char md_value[EVP_MAX_MD_SIZE];
    unsigned int md_len;

    md = EVP_get_digestbyname("sha1");

    EVP_MD_CTX_init(&mdctx);
    EVP_DigestInit_ex(&mdctx, md, NULL);
    EVP_DigestUpdate(&mdctx, octstr_get_cstr(os), octstr_len(os));
    EVP_DigestFinal_ex(&mdctx, md_value, &md_len);
    EVP_MD_CTX_cleanup(&mdctx);

    return octstr_create_from_data((char*) md_value, md_len);
}
#else
static Octstr *our_hash_func(Octstr *os)
{
    unsigned char hash[20];
    
    memset(hash, 0, sizeof(hash));
    
    SHA1((const unsigned char *)octstr_get_cstr(os), octstr_len(os), hash);
    
    return octstr_create_from_data((const char*)hash, sizeof(hash));
}
#endif
#endif


int main(int argc, char **argv)
{
    Octstr *data, *enc;

    gwlib_init();

    get_and_set_debugs(argc, argv, NULL);

    if (argc < 2)
        panic(0, "Syntax: %s <txt>\n", argv[0]);

    data = octstr_create(argv[1]);
    enc = md5(data);

    debug("",0,"MD5:");
    octstr_dump(enc, 0);

    octstr_destroy(enc);
    enc = md5digest(data);

    debug("",0,"MD5 (digest):");
    octstr_dump(enc, 0);

#ifdef HAVE_LIBSSL
    OpenSSL_add_all_digests();
    
    octstr_destroy(enc);
    enc = our_hash_func(data);

    debug("",0,"SHA1:");
    octstr_dump(enc, 0);

    octstr_binary_to_hex(enc, 0);
    debug("",0,"SHA1 (digest):");
    octstr_dump(enc, 0);
#endif

    octstr_destroy(data);
    octstr_destroy(enc);
    gwlib_shutdown();
    return 0;
}
