/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

/*
 *   pixadisp_reg.c
 *
 *     Regression test exercising various pixaDisplay*() functions.
 */

#include "allheaders.h"

int main(int    argc,
         char **argv)
{
l_int32       ws, hs, ncols;
BOX          *box;
BOXA         *boxa;
PIX          *pixs, *pix32, *pix1, *pix2, *pix3;
PIXA         *pixa, *pixa1, *pixa2, *pixa3;
L_REGPARAMS  *rp;

    if (regTestSetup(argc, argv, &rp))
        return 1;

    pixa = pixaCreate(0);
    pix32 = pixRead("marge.jpg");
    pixs = pixRead("feyn.tif");
    box = boxCreate(683, 799, 970, 479);
    pix1 = pixClipRectangle(pixs, box, NULL);
    boxDestroy(&box);
    regTestWritePixAndCheck(rp, pix1, IFF_PNG);  /* 0 */
    pixaAddPix(pixa, pix1, L_INSERT);

        /* Generate pixa2 from pixs and pixa3 from pix1 */
    boxa = pixConnComp(pixs, &pixa1, 8);
    pixa2 = pixaSelectBySize(pixa1, 60, 60, L_SELECT_IF_BOTH,
                             L_SELECT_IF_LTE, NULL);
    pixaDestroy(&pixa1);
    boxaDestroy(&boxa);
    boxa = pixConnComp(pix1, &pixa3, 8);
    boxaDestroy(&boxa);

        /* pixaDisplay() */
    pixGetDimensions(pixs, &ws, &hs, NULL);
    pix2 = pixaDisplay(pixa2, ws, hs);
    regTestWritePixAndCheck(rp, pix2, IFF_PNG);  /* 1 */
    pixaAddPix(pixa, pix2, L_INSERT);
    pixDestroy(&pixs);

        /* pixaDisplayRandomCmap() */
    pix2 = pixaDisplayRandomCmap(pixa2, ws, hs);  /* black bg */
    regTestWritePixAndCheck(rp, pix2, IFF_PNG);  /* 2 */
    pixaAddPix(pixa, pix2, L_COPY);
    pixcmapResetColor(pixGetColormap(pix2), 0, 255, 255, 255);  /* white bg */
    regTestWritePixAndCheck(rp, pix2, IFF_PNG);  /* 3 */
    pixaAddPix(pixa, pix2, L_INSERT);
    pixaDestroy(&pixa2);

        /* pixaDisplayOnLattice() */
    pix2 = pixaDisplayOnLattice(pixa3, 50, 50, &ncols, &boxa);
    regTestWritePixAndCheck(rp, pix2, IFF_PNG);  /* 4 */
    pixaAddPix(pixa, pix2, L_INSERT);
    fprintf(stderr, "Number of columns = %d; number of boxes: %d\n",
            ncols, boxaGetCount(boxa));
    boxaDestroy(&boxa);

        /* pixaDisplayUnsplit() */
    pixa1 = pixaSplitPix(pix32, 5, 7, 10, 0x0000ff00);
    pix2 = pixaDisplayUnsplit(pixa1, 5, 7, 10, 0x00ff0000);
    regTestWritePixAndCheck(rp, pix2, IFF_JFIF_JPEG);  /* 5 */
    pixaAddPix(pixa, pix2, L_INSERT);
    pixaDestroy(&pixa1);

        /* pixaDisplayTiled() */
    pix2 = pixaDisplayTiled(pixa3, 1000, 0, 10);
    regTestWritePixAndCheck(rp, pix2, IFF_PNG);  /* 6 */
    pixaAddPix(pixa, pix2, L_INSERT);

        /* pixaDisplayTiledInRows() */
    pix2 = pixaDisplayTiledInRows(pixa3, 1, 1000, 1.0, 0, 10, 2);
    regTestWritePixAndCheck(rp, pix2, IFF_PNG);  /* 7 */
    pixaAddPix(pixa, pix2, L_INSERT);

        /* pixaDisplayTiledAndScaled() */
    pix2 = pixaDisplayTiledAndScaled(pixa3, 1, 25, 20, 0, 5, 0);
    regTestWritePixAndCheck(rp, pix2, IFF_PNG);  /* 8 */
    pixaAddPix(pixa, pix2, L_INSERT);
    pixaDestroy(&pixa3);

    pixa1 = pixaCreate(10);
    pix2 = pixRankFilter(pix32, 8, 8, 0.5);
    pixaAddPix(pixa1, pix2, L_INSERT);
    pix3 = pixScale(pix32, 0.5, 0.5);
    pix2 = pixRankFilter(pix3, 8, 8, 0.5);
    pixaAddPix(pixa1, pix2, L_INSERT);
    pixDestroy(&pix3);
    pix3 = pixScale(pix32, 0.25, 0.25);
    pix2 = pixRankFilter(pix3, 8, 8, 0.5);
    pixaAddPix(pixa1, pix2, L_INSERT);
    pixDestroy(&pix3);
    pix2 = pixaDisplayTiledAndScaled(pixa1, 32, 500, 3, 0, 25, 0);
    regTestWritePixAndCheck(rp, pix2, IFF_JFIF_JPEG);  /* 9 */
    pixaAddPix(pixa, pix2, L_INSERT);
    pixaDestroy(&pixa1);
    pixDestroy(&pix32);

    if (rp->display) {
        lept_mkdir("lept/padisp");
        fprintf(stderr, "Writing to: /tmp/lept/padisp/pixadisp.pdf\n");
        pixaConvertToPdf(pixa, 0, 1.0, L_FLATE_ENCODE, 0, "pixadisp-test",
                         "/tmp/lept/padisp/pixadisp.pdf");
        fprintf(stderr, "Writing to: /tmp/lept/padisp/pixadisp.jpg\n");
        pix1 = pixaDisplayTiledInColumns(pixa, 2, 0.5, 30, 2);
        pixWrite("/tmp/lept/padisp/pixadisp.jpg", pix1, IFF_JFIF_JPEG);
        pixDisplay(pix1, 100, 100);
        pixDestroy(&pix1);
    }

    pixaDestroy(&pixa);
    return regTestCleanup(rp);
}
